import React, { useState } from 'react';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import './Contracts.css';
import house from '@/assets/house.png';
// import * as z from 'zod';
// import { Button } from '@/components/Elements';
// import { Form, InputField } from '@/components/Form';
// import clsx from 'clsx';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import { Button } from '@/components/Elements/Button';
import { usePaymentData } from '@/api/contract/getPaymentData';
import Footer from '@/components/Layout/Footer/Footer';
import { PaymentDetail } from '@/types';
import PropertyDetail from '@/components/Elements/Loader/PropertyDetail';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const Purchase = () => {
  const searchParams = new URLSearchParams(document.location.search);
  const contractID = searchParams.get('id');
  const { data, isLoading, isFetching } = usePaymentData({ id: contractID ?? '1' });

  const user = data?.data ?? ({} as PaymentDetail);
  // const schema = z.object({
  //   coupoun: z.string(),
  // });
  // type PurchaseValue = {
  //   coupoun: string;
  // };
  // const [togl, setTogl] = useState(1);

  const navigate = useNavigate();
  const handleOnlineNavigate = () => {
    if (contractID) {
      navigate(`/user/online-payment?id=${contractID}`);
    }
  };

  const handleOfflineNavigate = () => {
    if (contractID) {
      navigate(`/user/offline-payment?id=${contractID}`);
    }
  };

  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  return (
    <>
      {isLoading || isFetching ? (
        <PropertyDetail />
      ) : (
        <>
          <UserHeadBar />
          <button onClick={() => navigate(-1)}>
            <i className="fa-regular fa-circle-left go-back-button"></i>
          </button>
          <section className="container">
            <h4>Complete Your Purchase .</h4>
            <div className="row">
              <div className="col-12 col-md-8 pay-out">
                <div className="pay-box">
                  <div className="row">
                    <div className="col-md-4 col-4">
                      <img src={house} alt="house" />
                    </div>
                    <div className="col-md-8 col-8">
                      <div>
                        <h5 className="h-top">{user?.property_name}</h5>
                      </div>
                      <div>
                        <p>Cambridge ,C53 Street</p>
                      </div>
                      <div className="row find">
                        <div className="col-6 col-md-6 right-s"> {i18next.t('Purchase price')}</div>
                        <div className="col-6 col-md-6 left-s">
                          {localSymbol}{' '}
                          {(parseFloat(user?.price) * localCurrency)?.toFixed(0) ?? ''}
                        </div>
                      </div>
                      <div className="row">
                        <div className="col-6 col-md-6 right-s">
                          {i18next.t('Return On Investment')}
                        </div>
                        <div className="col-6 col-md-6 left-s">
                          {localSymbol}{' '}
                          {(parseFloat(user?.return_on_investment) * localCurrency)?.toFixed(0) ??
                            ''}
                        </div>
                      </div>
                      <div className="row">
                        <div className="col-6 col-md-6 right-s">{i18next.t('Cashflow PCM')}</div>
                        <div className="col-6 col-md-6 left-s">
                          {localSymbol}{' '}
                          {(parseFloat(user?.cashflow_pcm) * localCurrency)?.toFixed(0) ?? ''}
                        </div>
                      </div>
                      <div className="row">
                        <div className="col-6 col-md-6 right-s">Finder Fee</div>
                        <div className="col-6 col-md-6 left-s">
                          {localSymbol}{' '}
                          {(parseFloat(user?.finder_fees) * localCurrency)?.toFixed(0) ?? ''}
                        </div>
                      </div>
                    </div>
                  </div>
                  {/* <div className="row coupn">
                <div className="col-md-6 col-6 right--s">
                  <Form<PurchaseValue, typeof schema>
                    onSubmit={async (values) => {
                      //   alert(JSON.stringify(values, null, 2));
                      console.log(values);
                    }}
                    schema={schema}
                  >
                    {({ register, formState }) => (
                      <>
                        <div className="row coupn-form">
                          <div className="col-9 colmd-9">
                            <InputField
                              label="Have a discoutn code ? "
                              error={formState.errors['coupoun']}
                              registration={register('coupoun')}
                            />
                          </div>
                          <div className="col-3 colmd-3">
                            <Button type="submit">
                              <i className="fa-solid fa-arrow-right"></i>
                            </Button>
                          </div>
                        </div>
                      </>
                    )}
                  </Form>
                </div>
                <div className="col-md-6 col-6 left-s">
                  <span className="amnt">$555.0</span>
                </div>
              </div> */}
                  {/* <div className="hides">
                <div className="row">
                  <div className="col-md-6 col-6">
                    <h4>Pay With A Monthly Fees </h4>
                  </div>
                  <div className="col-md-6 col-6 leftt">
                    <button
                      className={clsx(togl == 1 ? 'hidess' : 'showss')}
                      onClick={() => setTogl(1)}
                    >
                      Hide Plans <i className="fa-solid fa-angle-up"></i>
                    </button>
                    <button
                      className={clsx(togl == 2 ? 'hidess' : 'showss')}
                      onClick={() => setTogl(2)}
                    >
                      Show PLans <i className="fa-solid fa-angle-down"></i>
                    </button>
                  </div>
                </div>
                {togl == 1 ? null : (
                  <>
                    <div className="row emi">
                      <div className="col-md-3 outt">
                        <div className="inn">
                          <p className="pp1">$450.0</p>
                          <p className="pp2">per month</p>
                          <p className="pp3">$ monthly Emis</p>
                        </div>
                      </div>
                      <div className="col-md-3 outt">
                        <div className="inn">
                          <p className="pp1">$450.0</p>
                          <p className="pp2">per month</p>
                          <p className="pp3">$ monthly Emis</p>
                        </div>
                      </div>
                      <div className="col-md-3 outt">
                        <div className="inn">
                          <p className="pp1">$450.0</p>
                          <p className="pp2">per month</p>
                          <p className="pp3">$ monthly Emis</p>
                        </div>
                      </div>
                      <div className="col-md-3 outt">
                        <div className="inn">
                          <p className="pp1">$450.0</p>
                          <p className="pp2">per month</p>
                          <p className="pp3">$ monthly Emis</p>
                        </div>
                      </div>
                      <div className="col-md-3 outt">
                        <div className="inn">
                          <p className="pp1">$450.0</p>
                          <p className="pp2">per month</p>
                          <p className="pp3">$ monthly Emis</p>
                        </div>
                      </div>
                    </div>
                  </>
                )}
              </div> */}
                </div>
              </div>

              <div className="col-12 col-md-4 pay-out">
                <div className="pay-box2">
                  <h4>Billing Summary</h4>

                  <div className="row">
                    <div className="col-7 col-md-7 right-s">Amount to be Paid</div>
                    <div className="col-5 col-md-5 left-s ">
                      {localSymbol} {(parseFloat(user?.price) * localCurrency)?.toFixed(0) ?? ''}
                    </div>
                  </div>

                  <div className="lover-butns">
                    <button onClick={onOpenModal} className="coloured-box">
                      Pay {localSymbol}{' '}
                      {(parseFloat(user?.price) * localCurrency)?.toFixed(0) ?? ''}
                    </button>
                  </div>
                </div>
              </div>
            </div>
            <Modal open={open} onClose={onCloseModal} center>
              <section className="model-datas">
                <h3>Please select the payment method..</h3>
              </section>
              <p className="btn-lines delete-bots">
                <Button onClick={handleOfflineNavigate}>Offline</Button>
                <Button onClick={handleOnlineNavigate}>Online</Button>
              </p>
            </Modal>
          </section>
          <br />
          <Footer />
        </>
      )}
    </>
  );
};
