import React, { useState } from 'react';
import Footer from '@/components/Layout/Footer/Footer';
import UserHeadBar from '../../components/UserHeadBar';
import { VerifyPayment } from '@/types';
import Signature from '@/components/Elements/Loader/Signature';
// import { useNotificationStore } from '@/stores/notifications';
import { Link, useNavigate } from 'react-router-dom';
import './Contracts.css';
import './PayStubForm.css';
import { useVerifyPayment } from '@/api/contract/getVerifyPayment';
import FileViewer from '@/components/Viewer/FileViewer';

import { useNotificationStore } from '@/stores/notifications';

import 'react-responsive-modal/styles.css';

import storage from '@/utils/storage';
import axios from 'axios';
import { Button } from '@/components/Elements';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';

export const VerifyContract = () => {
  const searchParams = new URLSearchParams(document.location.search);
  const contract_id = searchParams.get('id');
  // const inquiry_id = searchParams.get('identity');
  const inquiry_id = searchParams.get('id');
  const { data, isLoading, isFetching } = useVerifyPayment({ id: contract_id ?? '1' });
  const user = data?.data ?? ({} as VerifyPayment);
  console.log(user);

  // const pdfUrl = user?.payment_recipet;
  const pdfUrl = 'http://www.africau.edu/images/default/sample.pdf';
  const extension = pdfUrl?.split('.').at(-1);

  const navigate = useNavigate();

  const token = storage.getToken();
  const [loading, setLoading] = useState<boolean>(false);

  const handleApproveResponse = () => {
    handleSubmit('Accepted');
  };
  const handleDisapproveResponse = () => {
    handleSubmit('Rejected');
  };
  const axiosUrl = process.env.REACT_APP_API_URL;

  const handleSubmit = async (val: string) => {
    setLoading(true);
    axios
      .post(
        `${axiosUrl}/customer-api/approve-offline-payment
        `,
        { inquiry_id, payment_response: val },
        {
          headers: {
            Authorization: `${token}`,
          },
        }
      )
      .then(() => {
        setLoading(false);
        useNotificationStore.getState().addNotification({
          type: 'success',
          title: 'Success',
          message: 'Payment record uploaded Susccessfully',
        });
        // navigate(`/user/purchase?id=${contract_id}`);
        navigate(`/user/my-leads`);
      });
  };

  const fileData = 'http://www.africau.edu/images/default/sample.pdf';
  // const fileData = 'http://54.225.243.254:9007/media/customer_profile/ZA4WEo1w9B9r.png';
  // const fileData = user?.payment_recipet;

  return (
    <>
      <BackdropLoader open={loading} />
      {isLoading || isFetching ? (
        <Signature />
      ) : (
        <>
          <UserHeadBar />
          <section className="container">
            <p className="topHeadings">
              Verify contract
              {extension == 'pdf' && (
                <Link to={fileData} target="_blank">
                  View Contract
                </Link>
              )}{' '}
            </p>

            <FileViewer file={fileData}></FileViewer>
            <div className="row m-4">
              <div className="col-md-6 col-6 makeRight">
                <Button onClick={handleApproveResponse}>Approve</Button>
              </div>
              <div className="col-md-6 col-6 makeLeft">
                <Button onClick={handleDisapproveResponse}>Disapprove</Button>
              </div>
            </div>
          </section>
          <br />

          <Footer />
        </>
      )}
    </>
  );
};
