import React, { useEffect, useState } from 'react';
import * as z from 'zod';
import { ContentLayout } from '@/components/Layout';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import UserHeadBar from '../components/UserHeadBar';
import '../user.css';
import { Button } from '@/components/Elements';
import ServiceItem from '../components/ServiceItem';
import { Form, InputField } from '@/components/Form';
import { useDraftListing } from '@/api/draftList/myDraftListing';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useNavigate } from 'react-router-dom';
type SearchValues = {
  search: string;
};

const schema = z.object({
  search: z.string().min(1, 'Please enter first name'),
});

export const DraftListing = () => {
  const navigate = useNavigate();
  const [loading] = useState(false);
  const { data: listing, isLoading, refetch } = useDraftListing({ page: '1' });

  const [dRefetch, setDeleteRefetch] = useState<boolean>();

  useEffect(() => {
    refetch();
    setDeleteRefetch(false);
  }, [dRefetch, refetch]);

  return (
    <ContentLayout title="My Listing">
      <BackdropLoader open={loading} />
      <UserHeadBar />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="container listingContainer">
        <div className="d-flex justify-content-between">
          <h3>My Listing</h3>
          <div className="d-flex align-items-center">
            {/* <Form<SearchValues, typeof schema> onSubmit={() => null} schema={schema}>
              {({ register, formState }) => (
                <InputField
                  label="Search"
                  error={formState.errors['search']}
                  registration={register('search')}
                  placeholder="First name"
                />
              )}
            </Form> */}
            <Button
              className="ms-3 filterBtn"
              variant="outlineDark"
              startIcon={<i className="fa-solid fa-sliders" />}
            >
              Filters
            </Button>
          </div>
        </div>
        <div className="row">
          {listing?.length == 0 ? (
            <h4 className="makeCenter">{i18next.t('No listing found !')}</h4>
          ) : (
            <>
              {isLoading ? (
                <MyListingLoader />
              ) : (
                <>
                  {listing?.map((item, index) => (
                    <ServiceItem
                      showEditIcon={false}
                      key={index}
                      item={item}
                      showDeleteIcon={false}
                      setDeleteRefetch={setDeleteRefetch}
                      showHeartFavIcon={false}
                      showHeartIcon={false}
                    />
                  ))}
                </>
              )}
            </>
          )}
        </div>
      </div>
    </ContentLayout>
  );
};
