import BreadCrumb from '@/components/Layout/BreadCrumb';
import Footer from '@/components/Layout/Footer/Footer';
import React, { useEffect, useState } from 'react';
import { useFavouriteListing } from '@/api/favouriteListing/favouriteListing';
import ServiceItem from '@/features/user/components/ServiceItem';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';

export const FavouriteListing = () => {
  const [loading] = useState(false);
  const { data: listing, isLoading, refetch } = useFavouriteListing({ page: '1' });
  const [heartClickedLanding, setHeartClickedLanding] = useState(false);
  const [heartClicked, setHeartClicked] = useState<boolean>();
  refetch();

  useEffect(() => {
    refetch();
    setHeartClicked(false);
  }, [heartClicked]);
  useEffect(() => {
    setHeartClickedLanding(false);
  }, [heartClickedLanding]);
  return (
    <>
      <BreadCrumb
        head="Enjoy What You Love"
        line2="Here are Your Favorite Listings"
        paragraph="With favorites, you can easily track projects, check progress, and build your portfolio the way you want."
      />
      <BackdropLoader open={loading} />
      <div className="container fav-banner">
        <div className="row">
          {listing?.length == 0 ? (
            <h4 className="makeCenter">No listings found!</h4>
          ) : (
            <>
              {isLoading ? (
                <MyListingLoader />
              ) : (
                <>
                  {listing?.map((item, index) => (
                    <ServiceItem
                      key={index}
                      item={item}
                      showEditIcon={false}
                      showDeleteIcon={false}
                      showHeartIcon={false}
                      showHeartFavIcon={true}
                      setDeleteRefetch={undefined}
                      setHeartClickedLanding={setHeartClickedLanding}
                    />
                  ))}
                </>
              )}
            </>
          )}
        </div>
      </div>
      <Footer />
    </>
  );
};
