import React, { useEffect, useState } from 'react';
import * as z from 'zod';
import plus from '@/assets/plus.png';
import { ContentLayout } from '@/components/Layout';
import { useSelectFile } from '@/hooks/useSelectFile';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import { Button, Spinner } from '@/components/Elements';
import { uploadImage } from '@/api/uploadImage';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate, useParams } from 'react-router-dom';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useAuth } from '@/lib/auth';
import storage from '@/utils/storage';
import { axios } from '@/lib/axios';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';
import './Investor.css';
import { companyInvestmentDetails } from '@/api/companyInvestment/companyInvestmentDetails';

import { InvestmentCompany } from '@/types';
import EditSalePageLoader from '@/components/Elements/Loader/EditSalePageLoader';
import FileViewer from '@/components/Viewer/FileViewer';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { GoogleMap, Marker } from '@react-google-maps/api';
import axiosmod from 'axios';
import i18next from 'i18next';

const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;

// -------------- google maps --------------------

function Map({
  location,
  // addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

// ---------------google maps -------------------

const schema = z.object({
  company_name: z.string().min(1, 'Please enter company name'),
  company_established: z.string().min(1, 'Please enter company established'),
  company_email: z
    .string()
    .min(1, 'Please enter company email address')
    .email('Please enter a valid email address'),
  company_telephone: z
    .string()
    .min(1, 'Please enter company phone')
    .regex(/^[-0-9+]+$/, 'Phone should contain numbers only!'),
  facebook: z.string().optional(),
  twitter: z.string().optional(),
  youtube: z.string().optional(),
  linkedIn: z.string().optional(),
  instagram: z.string().optional(),
  the_valuation: z.string().optional(),
  shares_for_sale: z.string().optional(),
  minimum_drawing: z.string().optional(),
  remaninig_shares: z.string().optional(),
  property_id: z.string().optional(),
  image_data: z.string().optional(),
  video: z.string().optional(),
  documents_data: z.string().optional(),
  description: z.string().optional(),
  max_drawing: z.string().optional(),
  youtube_url: z.string().optional(),
  company_address: z.string().optional(),
  team: z.string().optional(),
  board: z.string().optional(),
  partners: z.string().optional(),
  company_postcode: z.string().optional(),
  company_postal_code: z.string().optional(),
  company_website: z.string().optional(),
  issue_account_no: z.string().optional(),
  bank_acc_created: z.string().optional(),
  chairman_email: z.string().optional(),
  no_share_bfr_issue: z.string().optional(),
  nominal_share_price: z.string().optional(),
  company_logo: z.string().optional(),
  small_company_logo: z.string().optional(),
  shareholders: z.string().optional(),
  self_report: z.string().optional(),
  price_per_share: z.string().optional(),
});

type CreateBusinessValues = {
  price_per_share: string;
  property_id: string;
  image_data: string;
  video: string;
  company_name: string;
  company_established: string;
  documents_data: string;
  company_email: string;
  company_telephone: string;
  description: string;
  the_valuation: string;
  shares_for_sale: string;
  remaninig_shares: string;
  minimum_drawing: string;
  max_drawing: string;
  youtube_url: string;
  company_address: string;
  team: string;
  board: string;
  partners: string;
  is_draft: string;
  // -------------------
  company_postcode: string;
  company_postal_code: string;
  company_website: string;
  issue_account_no: string;
  bank_acc_created: string;
  chairman_email: string;
  no_share_bfr_issue: string;
  nominal_share_price: string;
  company_logo: string;
  small_company_logo: string;
  shareholders: string;
  self_report: string;
  latitude: string;
  longitude: string;
  location: string;
};
export const CompanyInvestment = () => {
  const [user, setUser] = useState<InvestmentCompany>();
  const [isLoader, setisLoader] = useState<boolean>(false);
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const [investData, setInvestData] = useState<any>();

  const investConvert = user?.shareholders;

  const [value, setValue] = useState(null);
  const [latitude, setlatitude] = useState(0);
  const [longitude, setlongitude] = useState(0);
  const [addressValue, setAddressValue] = useState<string>('');
  const [address, setAddress] = useState<string>('');
  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_line: '',
    latitude: '',
    longitude: '',
  });

  useEffect(() => {
    setlatitude(addressDetails?.latitude);
    setlongitude(addressDetails?.longitude);
    setAddressValue(addressDetails?.address_line);
  }, [addressDetails]);

  useEffect(() => {
    setlatitude(user?.latitude);
    setlongitude(user?.longitude);
  }, [user]);

  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  useEffect(() => {
    if (investConvert) {
      setInvestData(JSON.parse(investConvert));
    }
  }, [investConvert]);

  const [items, setItems] = useState([]);
  const [name, setName] = useState('');
  const [stock, setStock] = useState('');

  useEffect(() => {
    if (investData) {
      setItems(investData);
    }
  }, [investData]);

  // Function to handle form submission
  const handleSubmitHolder = () => {
    // e.preventDefault();
    const newItem = { name, stock };
    setItems([...items, newItem]);
    setName('');
    setStock('');
  };

  // Function to handle deletion of an item
  const handleDelete = (index) => {
    const updatedItems = [...items];
    updatedItems.splice(index, 1);
    setItems(updatedItems);
  };

  // =======================?

  const navigate = useNavigate();
  const {
    file: videoFile,
    preview: videoPreview,
    handleChange: handleVideoChange,
    cover,
  } = useSelectFile();

  const [loading, setLoading] = useState(false);

  const auth = useAuth();
  const { id } = useParams();

  // ye h edit k lies
  const {
    file: pdfFile,
    preview: pdfPreview,
    handleChange: pdfhandleChange,
    pdfName,
  } = useSelectFile();

  const getDataOfApi = async () => {
    if (id != null) {
      setisLoader(true);
      const data = await companyInvestmentDetails(id);
      const userIn = data?.data ?? ({} as InvestmentCompany);
      setUser(userIn);
      setisLoader(false);
    }
  };
  useEffect(() => {
    auth.refetchUser();
    getDataOfApi();
  }, [id]);

  const [idd, setIdd] = useState('');
  const [is_draft, setis_draft] = useState<string>('False');
  const [userSubscribed, setuserSubscribed] = useState();

  useEffect(() => {
    auth.refetchUser();
    setuserSubscribed(auth.user?.has_subscription);
  }, [auth.user.has_subscription]);

  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft('False');
    } else {
      setis_draft('True');
    }
  }, [auth?.user?.has_subscription]);

  const addData = {
    editId: `${idd}`,
    pageUrl: `/user/company-money/${idd}?type=InvestmentCompany`,
  };

  storage.setSubmitFormData(addData);

  const showSuccess = () => {
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'success',
      message: 'Bussiness Submitted Successfully!',
    });
  };

  const { images, handleChange, uploaded, deleteImage, about, text, setText, load } =
    useSelectMultipleFile();
  // ------------------------Team Data upload -----------------
  const {
    images: teamimages,
    handleChange: teamhandleChange,
    uploaded: teamuploaded,
    deleteImage: teamdeleteImage,
    about: teamabout,
    setAbout: teamsetAbout,
    text: teamtext,
    setText: teamsetText,
    load: teamload,
  } = useSelectMultipleFile();

  const [teamArray, setTeamArray] = useState<any>([]);

  const deleteTeamImages = (val: any) => {
    const filteredTeamItems = teamArray
      .slice(0, val)
      .concat(teamArray.slice(val + 1, teamArray.length));
    setTeamArray(filteredTeamItems);
  };

  const handleTeamText = (index: number, val: string) => {
    const textItems = [...teamtext];
    textItems[index] = val;
    teamsetText(textItems);
  };
  const handleTeamAbout = (index: number, val: string) => {
    const aboutItems = [...teamabout];
    aboutItems[index] = val;
    teamsetAbout(aboutItems);
  };
  useEffect(() => {
    if (user) {
      const previousteamImage = eval(user?.team);
      setTeamArray(previousteamImage);
    }
  }, [user]);
  // ----------------- Board Data Upload --------------------

  const {
    images: boardimages,
    handleChange: boardhandleChange,
    uploaded: boarduploaded,
    deleteImage: boarddeleteImage,
    about: boardabout,
    setAbout: boardsetAbout,
    text: boardtext,
    setText: boardsetText,
    load: boardload,
  } = useSelectMultipleFile();

  const [boardArray, setboardArray] = useState<any>([]);

  const deleteboardImages = (val: any) => {
    const filteredboardItems = boardArray
      .slice(0, val)
      .concat(boardArray.slice(val + 1, boardArray.length));
    setboardArray(filteredboardItems);
  };

  const handleboardText = (index: number, val: string) => {
    const textItems = [...boardtext];
    textItems[index] = val;
    boardsetText(textItems);
  };
  const handleboardAbout = (index: number, val: string) => {
    const aboutItems = [...boardabout];
    aboutItems[index] = val;
    boardsetAbout(aboutItems);
  };

  useEffect(() => {
    if (user) {
      const previousboardImage = eval(user?.board);
      setboardArray(previousboardImage);
    }
  }, [user]);

  // ----------------- Partner Upload -----------------------

  const {
    images: partnerimages,
    handleChange: partnerhandleChange,
    uploaded: partneruploaded,
    deleteImage: partnerdeleteImage,
    about: partnerabout,
    setAbout: partnersetAbout,
    text: partnertext,
    setText: partnersetText,
    load: partnerload,
  } = useSelectMultipleFile();

  const [partnerArray, setpartnerArray] = useState<any>([]);

  const deletepartnerImages = (val: any) => {
    const filteredpartnerItems = partnerArray
      .slice(0, val)
      .concat(partnerArray.slice(val + 1, partnerArray.length));
    setpartnerArray(filteredpartnerItems);
  };

  const handlepartnerText = (index: number, val: string) => {
    const textItems = [...partnertext];
    textItems[index] = val;
    partnersetText(textItems);
  };
  const handlepartnerAbout = (index: number, val: string) => {
    const aboutItems = [...partnerabout];
    aboutItems[index] = val;
    partnersetAbout(aboutItems);
  };

  useEffect(() => {
    if (user) {
      const previousPartnerImage = eval(user?.partners);
      setpartnerArray(previousPartnerImage);
    }
  }, [user]);

  // ---------------Image data --------------

  const {
    file: smallLogoFile,
    preview: smalllogoPreview,
    handleChange: smalllogoChange,
  } = useSelectFile();
  const { file: logoFile, preview: logoPreview, handleChange: logoChange } = useSelectFile();
  // -------------------------- Upload property image -------------------
  const [imageArray, setImageArray] = useState<any>([]);

  const deleteImages = (val: any) => {
    const filteredItems = imageArray
      .slice(0, val)
      .concat(imageArray.slice(val + 1, imageArray.length));
    setImageArray(filteredItems);
  };

  const convertValuesToLocalCurrency = async (values: any) => {
    const fieldsToConvert = ['price_per_share', 'nominal_share_price'];

    fieldsToConvert.forEach((field) => {
      values[field] /= localCurrency;
    });
  };

  useEffect(() => {
    if (user) {
      const previousImage = eval(user?.image_data);
      setImageArray(previousImage);
    }
  }, [user]);

  const handleText = (index: number, val: string) => {
    const textItems = [...text];
    textItems[index] = val;
    setText(textItems);
  };

  const agency_id = localStorage.getItem('agency_id');

  const handleSubmit = async (values: CreateBusinessValues) => {
    try {
      setLoading(true);
      let pdfUrl = '';
      if (pdfFile) {
        const response = await uploadImage({ file: pdfFile });
        pdfUrl = response.url;
      } else {
        pdfUrl = user?.documents_data ?? '';
      }
      await convertValuesToLocalCurrency(values);
      let videoUrl = '';

      const newArray = uploaded.map(function (value, index) {
        return { image: value, name: text[index], about: about[index] };
      });
      const image_data = imageArray.concat(newArray);

      const newTeamArray = teamuploaded.map(function (value, index) {
        return { image: value, name: teamtext[index], about: teamabout[index] };
      });
      const team = teamArray.concat(newTeamArray);

      const newboardArray = boarduploaded.map(function (value, index) {
        return { image: value, name: boardtext[index], about: boardabout[index] };
      });
      const board = boardArray.concat(newboardArray);

      const newpartnerArray = partneruploaded.map(function (value, index) {
        return { image: value, name: partnertext[index], about: partnerabout[index] };
      });
      const partner = partnerArray.concat(newpartnerArray);

      if (videoFile) {
        const response = await uploadImage({ file: videoFile });
        videoUrl = response.url;
      } else {
        videoUrl = user?.video ?? '';
      }

      let logoimage = user?.company_logo;

      if (logoFile) {
        const response = await uploadImage({ file: logoFile });
        logoimage = response.url;
      }

      let smalllogoimage = user?.small_company_logo;

      if (smallLogoFile) {
        const response = await uploadImage({ file: smallLogoFile });
        smalllogoimage = response.url;
      }
      values.property_id = id ?? '1';
      values.is_draft = is_draft.toString();
      values.image_data = JSON.stringify(image_data);
      values.company_logo = logoimage;
      values.small_company_logo = smalllogoimage;
      values.video = videoUrl;
      values.documents_data = pdfUrl;
      values.latitude = latitude;
      values.longitude = longitude;
      values.location = addressValue;
      values.team = JSON.stringify(team);
      values.board = JSON.stringify(board);
      values.partners = JSON.stringify(partner);
      values.shareholders = JSON.stringify(items);

      id != null
        ? axios
            .post('/customer-api/edit-investment-company', values)
            .then(() => {
              setLoading(false);
              showSuccess();
              navigate('/user/my-listing');
            })
            .catch(() => {
              setLoading(false);
            })
        : axios
            .post('/customer-api/investment-my-company', { ...values, agency_id: agency_id })
            .then((response) => {
              setLoading(false);
              showSuccess();
              if (auth.user?.has_subscription == true) {
                setLoading(false);
                navigate('/business-for-sale');
              } else {
                setIdd(response?.data?.id);
                navigate('/user/subscription');
                setLoading(false);
              }
            })
            .catch(() => {
              setLoading(false);
            });
    } finally {
      setLoading(false);
    }
  };

  const [canAddMore, setcanAddMore] = useState(false);
  useEffect(() => {
    if (auth.user?.total_property_upload >= auth.user?.property_count) {
      setcanAddMore(true);
    }
  }, [auth?.user?.has_subscription]);

  return (
    <ContentLayout title="Create Business">
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <BackdropLoader open={loading} />
      <div className="container mt-4">
        <h3>Add New Advertisement/Listing of company</h3>
        <h5 className="ms-2 my-4 invest-prop">Property Information for Investment</h5>
        {isLoader ? (
          <EditSalePageLoader />
        ) : (
          <>
            <Form<CreateBusinessValues, typeof schema>
              onSubmit={handleSubmit}
              schema={schema}
              options={{
                defaultValues: {
                  ...user,
                  max_drawing: user?.max_drawing.toString(),
                  the_valuation: user?.the_valuation.toString(),
                  shares_for_sale: user?.shares_for_sale.toString(),
                  minimum_drawing: user?.minimum_drawing.toString(),
                  price_per_share: user?.price_per_share
                    ? (user?.price_per_share * localCurrency)?.toString()
                    : '',
                  remaninig_shares: user?.remaninig_shares.toString(),
                  company_postcode: user?.company_postcode.toString(),
                  no_share_bfr_issue: user?.no_share_bfr_issue.toString(),
                  nominal_share_price: user?.nominal_share_price
                    ? (user?.nominal_share_price * localCurrency)?.toString()
                    : '',
                },
              }}
            >
              {({ register, formState }) => (
                <div className="profile-box c-invest mb-5">
                  <div className="row">
                    <div className="col-12 col-md-4 col-lg-3">
                      <h5 className="mb-0">Video</h5>
                      <label htmlFor="videoInput">
                        <div className="image-box">
                          {videoPreview ? (
                            <img src={cover?.toString() ?? ''} alt="" className="profileImage" />
                          ) : user?.video ? (
                            <p className="smallFile">
                              <FileViewer file={user?.video} />
                            </p>
                          ) : (
                            <img src={plus} alt="" width="60" />
                          )}
                        </div>
                      </label>
                      <input
                        accept="video/mp4,video/x-m4v,video/*"
                        onChange={handleVideoChange}
                        type="file"
                        id="videoInput"
                        className="d-none"
                      />
                    </div>

                    <div className="col-12  col-md-4 col-lg-3">
                      <h5 className="mb-0">Small Company Logo</h5>
                      <label htmlFor="fileInput22">
                        <div className="image-box">
                          {smalllogoPreview ? (
                            <img src={smalllogoPreview} alt="" className="profileImage" />
                          ) : user?.small_company_logo ? (
                            <img src={user?.small_company_logo} alt="" width="60" />
                          ) : (
                            <img src={plus} alt="" width="60" />
                          )}
                        </div>
                      </label>
                      <input
                        accept="image/*"
                        onChange={smalllogoChange}
                        type="file"
                        id="fileInput22"
                        className="d-none"
                      />
                    </div>
                    <div className="col-12 col-md-4 col-lg-3">
                      <h5 className="mb-0">Company Logo</h5>
                      <label htmlFor="fileInput33">
                        <div className="image-box">
                          {logoPreview ? (
                            <img src={logoPreview} alt="" className="profileImage" />
                          ) : user?.company_logo ? (
                            <img src={user?.company_logo} alt="" width="60" />
                          ) : (
                            <img src={plus} alt="" width="60" />
                          )}
                        </div>
                      </label>
                      <input
                        accept="image/*"
                        onChange={logoChange}
                        type="file"
                        id="fileInput33"
                        className="d-none"
                      />
                    </div>
                  </div>
                  <div className="d-flex images-investment mt-4">
                    <div className="selectedImagesDiv">
                      <h5 className="mb-0">Images</h5>
                      <div className="row">
                        {imageArray?.map((item: any, index: number) => (
                          <div key={index} className="col-12 col-md-4 col-lg-3 cross-pic">
                            <div className="image-box">
                              <button type="button" onClick={() => deleteImages(index)}>
                                <i className="fa-solid fa-square-xmark pics"></i>
                              </button>
                              <img src={item.image} alt="..." />
                            </div>
                            {item.name && <h6 className="itemName">{item.name}</h6>}
                          </div>
                        ))}
                        {images.map((item: any, index: number) => (
                          <div key={index} className="cross-pic">
                            <div className="image-box">
                              <button type="button" onClick={() => deleteImage(index)}>
                                <i className="fa-solid fa-square-xmark pics"></i>
                              </button>
                              <img src={item} alt="..." />
                            </div>
                            <input
                              type="text"
                              id="imageName"
                              name="imageName"
                              placeholder="Image name"
                              onChange={(e) => handleText(index, e.target.value)}
                              value={text[index]}
                            />
                          </div>
                        ))}

                        <div className="col-md-6 col-12">
                          <div className="padding-r">
                            <label htmlFor="fileInput1">
                              <div className="image-box">
                                {load ? <Spinner /> : <img src={plus} alt="" width="60" />}
                              </div>
                            </label>
                            <input
                              accept="image/*"
                              onChange={handleChange}
                              multiple
                              type="file"
                              id="fileInput1"
                              className="d-none"
                            />
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="row money-cmp-col">
                    <div className="col-12 col-md-6">
                      <InputField
                        type="text"
                        label={i18next.t('Company name')}
                        error={formState.errors['company_name']}
                        registration={register('company_name')}
                        placeholder={i18next.t('Company name')}
                      />
                    </div>
                    <div className="col-12 col-md-6">
                      <InputField
                        type="number"
                        label="Company established (In Years)"
                        error={formState.errors['company_established']}
                        registration={register('company_established')}
                        placeholder="Company established (In Years)"
                      />
                    </div>

                    <div className="col-12 col-md-6">
                      <InputField
                        type="email"
                        label="Company Email Address"
                        error={formState.errors['company_email']}
                        registration={register('company_email')}
                        placeholder="Company Email Address"
                      />
                    </div>
                    <div className="col-12 col-md-6">
                      <InputField
                        type="text"
                        label="Company Telephone"
                        error={formState.errors['company_telephone']}
                        registration={register('company_telephone')}
                        placeholder="Company Telephone"
                      />
                    </div>
                    <div className="col-12 col-md-6">
                      <InputField
                        type="text"
                        label="Company Address"
                        error={formState.errors['company_address']}
                        registration={register('company_address')}
                        placeholder="Twitter"
                      />
                    </div>
                    <div className="col-12 col-md-6">
                      <InputField
                        type="text"
                        label={i18next.t('Youtube')}
                        error={formState.errors['youtube_url']}
                        registration={register('youtube_url')}
                        placeholder="Facebook"
                      />
                    </div>

                    <div className="col-12 col-md-6">
                      <p className="headingUplod mb-2">Upload Doccuments here</p>
                      <label htmlFor="fileInput">
                        <div>
                          {pdfPreview ? null : (
                            <>
                              {user?.documents_data ? (
                                <div className="pdfDiv">
                                  <FileViewer file={user?.documents_data} />
                                </div>
                              ) : null}
                            </>
                          )}

                          {pdfPreview ? (
                            <>
                              {pdfName ? (
                                <>
                                  <div className="files-box">
                                    <p>{pdfName}</p>
                                  </div>
                                </>
                              ) : (
                                <>
                                  <div className="image-box">
                                    <img src={pdfPreview} alt="" className="profileImage" />
                                  </div>
                                </>
                              )}
                            </>
                          ) : (
                            <>
                              {user?.documents_data ? (
                                <div className="files-box">
                                  <p>Edit Doccument here .</p>
                                </div>
                              ) : (
                                <div className="files-box">
                                  <img src={plus} alt="" width="60" />
                                </div>
                              )}
                            </>
                          )}
                        </div>
                      </label>
                      <input
                        accept="pdf/*"
                        onChange={pdfhandleChange}
                        type="file"
                        id="fileInput"
                        className="d-none"
                      />
                    </div>
                  </div>

                  <div className="row Team_Data_Upload upload-teams mt-4">
                    {teamArray?.map((item: any, index: number) => (
                      <div key={index} className="col-md-2 cross-pic">
                        <div className="image-box">
                          <button type="button" onClick={() => deleteTeamImages(index)}>
                            <i className="fa-solid fa-square-xmark pics"></i>
                          </button>
                          <img src={item.image} alt="..." />
                        </div>
                        {item.name && <h6 className="itemName">{item.name}</h6>}
                        {item.about && <h6 className="itemName">{item.about}</h6>}
                      </div>
                    ))}

                    {teamimages?.map((item: any, index: number) => (
                      <div key={index} className="cross-pic">
                        <div className="image-box">
                          <button type="button" onClick={() => teamdeleteImage(index)}>
                            <i className="fa-solid fa-square-xmark pics"></i>
                          </button>
                          <img src={item} alt="..." />
                        </div>
                        <input
                          type="text"
                          id="imageNamea"
                          name="imageNamea"
                          placeholder="Member name"
                          onChange={(e) => handleTeamText(index, e.target.value)}
                          value={teamtext[index]}
                        />
                        <textarea
                          id="imageAbouts"
                          name="imageAbouts"
                          placeholder="About Member"
                          onChange={(e) => handleTeamAbout(index, e.target.value)}
                          value={teamabout[index]}
                          rows={2}
                        />
                      </div>
                    ))}

                    <div className="col-md-4 col-12">
                      <p className="headingUplod mb-2">Upload team Data Here</p>
                      <div className="padding-r">
                        <label htmlFor="fileInput2">
                          <div className="image-box">
                            {teamload ? <Spinner /> : <img src={plus} alt="" width="60" />}
                          </div>
                        </label>
                        <input
                          accept="image/*"
                          onChange={teamhandleChange}
                          multiple
                          type="file"
                          id="fileInput2"
                          className="d-none"
                        />
                      </div>
                    </div>
                    <div className="col-12 col-md-4 Board_Data_Upload">
                      <p className="headingUplod mb-2">Upload Board Data Here</p>
                      {boardArray?.map((item: any, index: number) => (
                        <div key={index} className="col-md-2 cross-pic">
                          <div className="image-box">
                            <button type="button" onClick={() => deleteboardImages(index)}>
                              <i className="fa-solid fa-square-xmark pics"></i>
                            </button>
                            <img src={item.image} alt="..." />
                          </div>
                          {item.name && <h6 className="itemName">{item.name}</h6>}
                          {item.about && <h6 className="itemName">{item.about}</h6>}
                        </div>
                      ))}

                      {boardimages?.map((item: any, index: number) => (
                        <div key={index} className="cross-pic">
                          <div className="image-box">
                            <button type="button" onClick={() => boarddeleteImage(index)}>
                              <i className="fa-solid fa-square-xmark pics"></i>
                            </button>
                            <img src={item} alt="..." />
                          </div>
                          <input
                            type="text"
                            id="imageBoardName"
                            name="imageBoardName"
                            placeholder="Member name"
                            onChange={(e) => handleboardText(index, e.target.value)}
                            value={boardtext[index]}
                          />

                          <textarea
                            id="imageBoardAbout"
                            name="imageBoardAbout"
                            placeholder="About Member"
                            onChange={(e) => handleboardAbout(index, e.target.value)}
                            value={boardabout[index]}
                            rows={2}
                          />
                        </div>
                      ))}

                      <div className="board-inner">
                        <div className="padding-r">
                          <label htmlFor="fileInput3">
                            <div className="image-box">
                              {boardload ? <Spinner /> : <img src={plus} alt="" width="60" />}
                            </div>
                          </label>
                          <input
                            accept="image/*"
                            onChange={boardhandleChange}
                            multiple
                            type="file"
                            id="fileInput3"
                            className="d-none"
                          />
                        </div>
                      </div>
                    </div>
                    <div className="col-12 col-md-4 Partner_Data_Upload">
                      <p className="headingUplod mb-2">Upload partner Data Here</p>
                      {partnerArray?.map((item: any, index: number) => (
                        <div key={index} className="col-md-2 cross-pic">
                          <div className="image-box">
                            <button type="button" onClick={() => deletepartnerImages(index)}>
                              <i className="fa-solid fa-square-xmark pics"></i>
                            </button>
                            <img src={item.image} alt="..." />
                          </div>
                          {item.name && <h6 className="itemName">{item.name}</h6>}
                          {item.about && <h6 className="itemName">{item.about}</h6>}
                        </div>
                      ))}

                      {partnerimages?.map((item: any, index: number) => (
                        <div key={index} className="cross-pic">
                          <div className="image-box">
                            <button type="button" onClick={() => partnerdeleteImage(index)}>
                              <i className="fa-solid fa-square-xmark pics"></i>
                            </button>
                            <img src={item} alt="..." />
                          </div>
                          <input
                            type="text"
                            id="imagepartnerName"
                            name="imagepartnerName"
                            placeholder="Member name"
                            onChange={(e) => handlepartnerText(index, e.target.value)}
                            value={partnertext[index]}
                          />

                          <textarea
                            id="imageBoardAbout"
                            name="imageBoardAbout"
                            placeholder="About Member"
                            onChange={(e) => handlepartnerAbout(index, e.target.value)}
                            value={partnerabout[index]}
                            rows={2}
                          />
                        </div>
                      ))}

                      <div className="partner-data">
                        <div className="padding-r">
                          <label htmlFor="fileInput4">
                            <div className="image-box">
                              {partnerload ? <Spinner /> : <img src={plus} alt="" width="60" />}
                            </div>
                          </label>
                          <input
                            accept="image/*"
                            onChange={partnerhandleChange}
                            multiple
                            type="file"
                            id="fileInput4"
                            className="d-none"
                          />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="stockHolder">
                    <h5>Add Shareholder</h5>
                    <form>
                      <div className="row add-shareholder">
                        <div className="col-12 col-md-5 bol-btm">
                          <input
                            type="text"
                            placeholder="Enter name"
                            value={name}
                            onChange={(e) => setName(e.target.value)}
                          />
                        </div>
                        <div className="col-12 col-md-5 bol-btm">
                          <input
                            type="text"
                            placeholder="Enter shares"
                            value={stock}
                            onChange={(e) => setStock(e.target.value)}
                          />
                        </div>
                        <div className="col-md-2 spnButton">
                          {name == '' && stock == '' ? (
                            <span className="spanButton">Add Item</span>
                          ) : (
                            <span className="spanButton" onClick={handleSubmitHolder}>
                              Add Item
                            </span>
                          )}
                        </div>
                      </div>
                    </form>
                    <div className="StockDataDiv">
                      <ul>
                        {items.map((item, index) => (
                          <li key={index}>
                            <div className="row StockData">
                              <div className="col-12 col-md-5"> Name : {item.name}</div>
                              <div className="col-12 col-md-5">Shares : {item.stock}</div>
                              <div className="col-md-2 spnButton">
                                <span
                                  className="spanButtonDelete"
                                  onClick={() => handleDelete(index)}
                                >
                                  <i className="fa-solid fa-trash-can"></i>
                                </span>
                              </div>
                            </div>
                          </li>
                        ))}
                      </ul>
                    </div>
                  </div>

                  <div className="col-12">
                    <TextAreaField
                      rows={4}
                      error={formState.errors['description']}
                      registration={register('description')}
                      label={i18next.t('Description')}
                    />
                  </div>
                  <p className="mt-4 btn-heavy">Company Information</p>
                  <div className="row comp-info">
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label={i18next.t('Valuation')}
                        error={formState.errors['the_valuation']}
                        registration={register('the_valuation')}
                        placeholder={i18next.t('Valuation')}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="text"
                        label="Max Drawing"
                        error={formState.errors['max_drawing']}
                        registration={register('max_drawing')}
                        placeholder="Facebook"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label="Shares For Sale"
                        error={formState.errors['shares_for_sale']}
                        registration={register('shares_for_sale')}
                        placeholder="Shares For Sale"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label="Minimum Drawing"
                        error={formState.errors['minimum_drawing']}
                        registration={register('minimum_drawing')}
                        placeholder="Minimum Drawing"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="float"
                        label={`Price Per Share ${localSymbol}`}
                        error={formState.errors['price_per_share']}
                        registration={register('price_per_share')}
                        placeholder="Minimum Drawing"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label="Remaninig Shares"
                        error={formState.errors['remaninig_shares']}
                        registration={register('remaninig_shares')}
                        placeholder="Remaninig Shares"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label={i18next.t('Postcode')}
                        error={formState.errors['company_postcode']}
                        registration={register('company_postcode')}
                        placeholder="Enter data here"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label="Number of Share Before Issue"
                        error={formState.errors['no_share_bfr_issue']}
                        registration={register('no_share_bfr_issue')}
                        placeholder="Enter data here"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <TextAreaField
                        label="Self Report"
                        error={formState.errors['self_report']}
                        registration={register('self_report')}
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="float"
                        label={`Nominal Share Price ${localSymbol}`}
                        error={formState.errors['nominal_share_price']}
                        registration={register('nominal_share_price')}
                        placeholder="Enter data here"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="text"
                        label=" Bank Acc Created"
                        error={formState.errors['bank_acc_created']}
                        registration={register('bank_acc_created')}
                        placeholder="Enter data here"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="email"
                        label={i18next.t('Chairman Email')}
                        error={formState.errors['chairman_email']}
                        registration={register('chairman_email')}
                        placeholder="Enter data here"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label=" Issue Account Number"
                        error={formState.errors['issue_account_no']}
                        registration={register('issue_account_no')}
                        placeholder="Enter data here"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="text"
                        label=" Company Website"
                        error={formState.errors['company_website']}
                        registration={register('company_website')}
                        placeholder="Enter data here"
                      />
                    </div>

                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="number"
                        label={i18next.t('Postal Code')}
                        error={formState.errors['company_postal_code']}
                        registration={register('company_postal_code')}
                        placeholder="Enter data here"
                      />
                    </div>
                  </div>
                  <div style={{ width: '100%' }}>
                    <div style={{ width: '100%', height: '80%' }}>
                      <Map
                        location={location}
                        setAddressDetails={setAddressDetails}
                        addressDetails={addressDetails}
                      />
                    </div>
                  </div>
                  <br />
                  <div className="col-12">
                    <div className="pt-2 pb-2">
                      <GooglePlacesAutocomplete
                        selectProps={{
                          defaultInputValue: user?.location ? user?.location : '',
                          value,
                          onChange: handleChangeLocation,
                        }}
                      />
                    </div>
                  </div>

                  <div className="d-flex justify-content-center mt-4">
                    {userSubscribed == true ? (
                      <>
                        {' '}
                        {canAddMore ? (
                          <Button disabled className="disableSubmit">
                            Reached Upload limit
                          </Button>
                        ) : (
                          <Button
                            isLoading={loading}
                            type="submit"
                            variant="primary"
                            size="md"
                            className="mt-2 "
                          >
                            Submit
                          </Button>
                        )}
                      </>
                    ) : (
                      <>
                        {' '}
                        <Button
                          isLoading={loading}
                          type="submit"
                          variant="primary"
                          size="md"
                          className="mt-2 "
                        >
                          Subscribe
                        </Button>
                      </>
                    )}
                  </div>
                </div>
              )}
            </Form>
          </>
        )}
      </div>
    </ContentLayout>
  );
};
