import { GoogleMap, Marker } from '@react-google-maps/api';
import React, { useEffect, useRef, useState } from 'react';
import axiosmod from 'axios';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { ContentLayout } from '@/components/Layout';
import { Card } from '@/components/Elements/Card';
import * as z from 'zod';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import { Button, Spinner } from '@/components/Elements';
import { axios } from '@/lib/axios';
import { useNotificationStore } from '@/stores/notifications';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';
import { usePartnerDataUpload } from '@/hooks/usePartnerDataUpload';
import { useNavigate, useParams } from 'react-router-dom';
import '../../map.css';
import './PropertyMoney.css';
import plus from '@/assets/plus.png';
import { useAuth } from '@/lib/auth';
import { propertyInvestmentDetails } from '@/api/propertyInvestment/propertyInvestmentDetails';
import { Investment } from '@/types';
import EditSalePageLoader from '@/components/Elements/Loader/EditSalePageLoader';
import storage from '@/utils/storage';
import { uploadImage } from '@/api/uploadImage';
import FileViewer from '@/components/Viewer/FileViewer';
import { useSelectFile } from '@/hooks/useSelectFile';
import DraftInput from '@/components/Elements/DraftInput/DraftInput';
import EditDraftInput from '@/components/Elements/DraftInput/EditDraftInput';
import { EditorState } from 'draft-js';

import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import i18next from 'i18next';
const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;
// -------------- google maps --------------------

function Map({
  location,
  addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

// ---------------google maps -------------------

const schema = z.object({
  project_name: z.string().min(1, 'Please enter project name '),
  phone_number: z.custom(isValidMobile, isValidMobileMsg),

  location: z.string().min(1, 'Please enter location'),
  target_irr: z.string().min(1, 'Please enter '),
  target_return_on_cost: z.string().min(1, 'Please enter target return cost'),
  target_equity_multiple: z.string().min(1, 'Please enter target equity multiple'),
  estimated_hold_period: z.string().min(1, 'Please enter estimated hold period'),
  funded: z.string().min(1, 'Please enter funded'),
  offered_by: z.string().min(1, 'Please enter offered by'),
  investment_strategy: z.string().min(1, 'Please enter investment strategy'),
  investment_type: z.string().min(1, 'Please enter investment type'),
  estimated_first_distribution: z.string().min(1, 'Please enter estimated first distribution'),
  minimum_investment: z
    .string()
    .min(1, 'Please enter minimum investment')
    .regex(/^\d+$/)
    .transform(Number),
  // overview: z.string().min(1, 'Please enter overview'),
  asset_quality: z.string().min(1, 'Please enter asset quality'),
  investment_highlights: z.string().min(1, 'Please enter market'),
  business_plan: z.string().min(1, 'Please enter market'),
  disclaimers: z.string().min(1, 'Please enter market'),
  // -------------------?
  property_type: z.string(),
  property_id: z.string().optional(),
  about_management: z.string(),
});

type rentValues = {
  image_data: string;
  videos: string;
  documents_data: string;
  property_type: string;
  project_name: string;
  location: string;
  phone_number: string;
  target_irr: string;
  target_return_on_cost: any;
  target_equity_multiple: string;
  estimated_hold_period: string;
  funded: string;
  offered_by: string;
  investment_strategy: string;
  investment_type: string;
  estimated_first_distribution: any;
  minimum_investment: any;
  overview: string;
  investment_highlights: string;
  management_logo: string;
  about_management: string;
  partner: string;
  business_plan: string;
  asset_quality: string;
  property_summary: string;
  property_detail: string;
  property_location: string;
  latitude: string;
  longitude: string;
  financial_cap_stack: string;
  financial_debt_assumption: string;
  property_at_glance: string;
  disclaimers: string;
  is_draft: string;
  property_id: string;
};

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

export const ProjectMoney = () => {
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const [idd, setIdd] = useState('');
  const [user, setUser] = useState<Investment>();
  const [locationData, setLocationData] = useState<any>(null);
  const [propertySummary, setPropertySummary] = useState<any>(null);
  const [propertyDetail, setPropertyDetail] = useState<any>(null);
  const [deptAsumption, setDeptAsumption] = useState<any>(null);
  const [iseditForm, setIseditForm] = useState<boolean>(false);
  const [financialCapStackData, setfinancialCapStackData] = useState<any>(null);
  const [glanceData, setGlanceData] = useState<any>(null);

  const getDataOfApi = async () => {
    if (id != null) {
      setisLoader(true);
      const data = await propertyInvestmentDetails(id);
      const userIn = data?.data ?? ({} as Investment);
      setUser(userIn);
      setIseditForm(true);
      setisLoader(false);
    }
  };

  useEffect(() => {
    auth.refetchUser();
    getDataOfApi();
  }, [id]);

  const locationOldData = user?.property_location;
  const [locationState, setlocationState] = useState(() => EditorState.createEmpty());
  const propertySummaryOldData = user?.property_summary;
  const [propertySummaryState, setpropertySummaryState] = useState(() => EditorState.createEmpty());
  const propertyDetailOldData = user?.property_detail;
  const [propertyDetailState, setpropertyDetailState] = useState(() => EditorState.createEmpty());
  const overviewOldData = user?.overview;
  const [overviewState, setoverviewState] = useState(() => EditorState.createEmpty());
  const deptAsumptionOldData = user?.financial_debt_assumption;
  const [deptAsumptionState, setdeptAsumptionState] = useState(() => EditorState.createEmpty());
  const dataConvert = user?.financial_cap_stack;
  const glanceDataConvert = user?.property_at_glance;

  useEffect(() => {
    if (dataConvert) {
      setfinancialCapStackData(JSON.parse(dataConvert));
    }
  }, [dataConvert]);
  useEffect(() => {
    if (glanceDataConvert) {
      setGlanceData(JSON.parse(glanceDataConvert));
    }
  }, [glanceDataConvert]);

  const [financialDebtAssumption, setFinancialDebtAssumption] = useState({
    equityPrice: financialCapStackData?.equityPrice ? financialCapStackData?.equityPrice : '',
    lpEquityPercent: financialCapStackData?.lpEquityPercent
      ? financialCapStackData?.lpEquityPercent
      : '',
    gpEquityPercent: financialCapStackData?.gpEquityPercent
      ? financialCapStackData?.gpEquityPercent
      : '',
    debtPrice: financialCapStackData?.debtPrice ? financialCapStackData?.debtPrice : '',
    debtPercent: financialCapStackData?.debtPercent ? financialCapStackData?.debtPercent : '',
  });
  useEffect(() => {
    setFinancialDebtAssumption(() => ({
      equityPrice: financialCapStackData?.equityPrice,
      lpEquityPercent: financialCapStackData?.lpEquityPercent,
      gpEquityPercent: financialCapStackData?.gpEquityPercent,
      debtPrice: financialCapStackData?.debtPrice,
      debtPercent: financialCapStackData?.debtPercent,
    }));
  }, [
    financialCapStackData?.debtPercent,
    financialCapStackData?.debtPrice,
    financialCapStackData?.equityPrice,
    financialCapStackData?.gpEquityPercent,
    financialCapStackData?.lpEquityPercent,
  ]);

  const handleFinancialChange = (e) => {
    const { name, value } = e.target;
    setFinancialDebtAssumption((prevState) => ({
      ...prevState,
      [name]: value,
    }));
  };

  const [overview, setOverview] = useState<any>(null);

  const {
    file: videoFile,
    preview: videoPreview,
    handleChange: handleVideoChange,
    cover,
  } = useSelectFile();

  const {
    file: pdfFile,
    preview: pdfPreview,
    handleChange: pdfhandleChange,
    pdfName,
  } = useSelectFile();

  const {
    file: managementLogoFile,
    preview: managementlogoPreview,
    handleChange: managementlogoChange,
  } = useSelectFile();

  // ================================= Property at glanc ==================

  const [propertyItem, setPropertyItem] = useState('');
  const [propertyItemData, setPropertyItemData] = useState('');
  const [propertyGlanceData, setPropertyGlanceData] = useState([]);

  useEffect(() => {
    if (glanceData) {
      setPropertyGlanceData(glanceData);
    }
  }, [glanceData]);
  const handleItemChange = (e: any) => {
    setPropertyItem(e.target.value);
  };

  const handleItemDataChange = (e: any) => {
    setPropertyItemData(e.target.value);
  };

  const addItem = () => {
    const newItem = {
      id: Date.now(),
      item: propertyItem,
      data: propertyItemData,
    };
    setPropertyGlanceData([...propertyGlanceData, newItem]);
    setPropertyItem('');
    setPropertyItemData('');
  };

  const deleteItem = (id) => {
    const updatedItems = propertyGlanceData.filter((item) => item.id !== id);
    setPropertyGlanceData(updatedItems);
  };

  // ========= p at glance =========================

  const auth = useAuth();
  const [userSubscribed, setuserSubscribed] = useState();

  useEffect(() => {
    auth.refetchUser();
    setuserSubscribed(auth.user?.has_subscription);
  }, [auth, auth.user?.has_subscription]);

  const navigate = useNavigate();
  const [value, setValue] = useState(null);
  const [address, setAddress] = useState<string>('');
  const [loading, setLoading] = useState(false);
  const inputFileRef = useRef<HTMLInputElement | null>(null);
  const [is_draft, setis_draft] = useState<string>('False');
  const [latitude, setlatitude] = useState('1');
  const [longitude, setlongitude] = useState('1');
  const [addressValue, setAddressValue] = useState<string>('');
  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft('False');
    } else {
      setis_draft('True');
    }
  }, [auth?.user?.has_subscription]);

  const addData = {
    editId: `${idd}`,
    pageUrl: `/user/project-money/${idd}?type=InvestmentProject`,
  };
  storage.setSubmitFormData(addData);

  const { images, handleChange, uploaded, deleteImage, text, setText, load } =
    useSelectMultipleFile();

  const deleteImages = (val: any) => {
    const filteredItems = imageArray
      .slice(0, val)
      .concat(imageArray.slice(val + 1, imageArray.length));
    setImageArray(filteredItems);
  };

  const [isLoader, setisLoader] = useState<boolean>(false);
  const [imageArray, setImageArray] = useState<any>([]);

  useEffect(() => {
    if (user) {
      const previousImage = eval(user?.image_data);
      setImageArray(previousImage);
    }
  }, [user]);

  const handleText = (index: number, val: string) => {
    const textItems = [...text];
    textItems[index] = val;
    setText(textItems);
  };

  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_label: '1',
    latitude: '2',
    longitude: '2',
  });

  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  // ----------------- Partner Upload -----------------------
  useEffect(() => {
    setlatitude(addressDetails?.latitude);
    setlongitude(addressDetails?.longitude);
    setAddressValue(addressDetails?.address_line);
  }, [addressDetails]);

  const {
    images: partnerimages,
    handleChange: partnerhandleChange,
    uploaded: partneruploaded,
    deleteImage: partnerdeleteImage,
    about: partnerabout,
    setAbout: partnersetAbout,
    text: partnertext,
    setText: partnersetText,
    linkedin: partnerlinkedin,
    setLinkedin: partnersetLinkedin,
    position: partnerposition,
    setPosition: partnersetPosition,
    load: partnerload,
  } = usePartnerDataUpload();

  const [partnerArray, setpartnerArray] = useState<any>([]);

  const deletepartnerImages = (val: any) => {
    const filteredpartnerItems = partnerArray
      .slice(0, val)
      .concat(partnerArray.slice(val + 1, partnerArray.length));
    setpartnerArray(filteredpartnerItems);
  };

  const handlepartnerText = (index: number, val: string) => {
    const textItems = [...partnertext];
    textItems[index] = val;
    partnersetText(textItems);
  };
  const handlepartnerAbout = (index: number, val: string) => {
    const aboutItems = [...partnerabout];
    aboutItems[index] = val;
    partnersetAbout(aboutItems);
  };

  const handlepartnerLinkedin = (index: number, val: string) => {
    const linkedinItems = [...partnerlinkedin];
    linkedinItems[index] = val;
    partnersetLinkedin(linkedinItems);
  };

  const handlepartnerPosition = (index: number, val: string) => {
    const positionItems = [...partnerposition];
    positionItems[index] = val;
    partnersetPosition(positionItems);
  };

  const convertValuesToLocalCurrency = async (values: any) => {
    const fieldsToConvert = [
      'minimum_investment',
      'estimated_first_distribution',
      'target_return_on_cost',
    ];

    fieldsToConvert.forEach((field) => {
      values[field] /= localCurrency;
    });
  };

  useEffect(() => {
    if (user) {
      const previousPartnerImage = eval(user?.partner);
      setpartnerArray(previousPartnerImage);
    }
  }, [user]);
  // --------------------------------------------------------------

  const [canAddMore, setcanAddMore] = useState(false);
  useEffect(() => {
    if (auth.user?.total_property_upload >= auth.user?.property_count) {
      setcanAddMore(true);
    }
  }, [auth?.user?.has_subscription]);

  const agency_id = localStorage.getItem('agency_id');

  const handleSubmit = async (values: rentValues) => {
    setLoading(true);
    let pdfUrl = '';
    if (pdfFile) {
      const response = await uploadImage({ file: pdfFile });
      pdfUrl = response.url;
    } else {
      pdfUrl = user?.documents_data ?? '';
    }

    let managementImage = '';
    if (managementLogoFile) {
      const response = await uploadImage({ file: managementLogoFile });
      managementImage = response.url;
    } else {
      managementImage = user?.management_logo;
    }

    let videoUrl = '';

    const newArray = uploaded.map(function (value, index) {
      return { image: value, name: text[index] };
    });

    const image_data = imageArray.concat(newArray);

    if (videoFile) {
      const response = await uploadImage({ file: videoFile });
      videoUrl = response.url;
    } else {
      videoUrl = user?.videos ?? '';
    }

    const newpartnerArray = partneruploaded.map(function (value, index) {
      return {
        image: value,
        name: partnertext[index],
        about: partnerabout[index],
        linkedin: partnerlinkedin[index],
        position: partnerposition[index],
      };
    });
    await convertValuesToLocalCurrency(values);
    financialDebtAssumption.equityPrice /= localCurrency;
    financialDebtAssumption.debtPrice /= localCurrency;
    const partnerData = partnerArray.concat(newpartnerArray);
    values.property_id = id ?? '1';
    values.videos = videoUrl;
    values.documents_data = pdfUrl;
    values.image_data = JSON.stringify(image_data);
    values.is_draft = is_draft;
    // ---------------
    values.partner = JSON.stringify(partnerData);
    values.management_logo = managementImage;
    values.property_summary = propertySummary;
    values.financial_debt_assumption = deptAsumption;
    values.property_detail = propertyDetail;
    values.overview = overview;
    values.latitude = latitude;
    values.longitude = longitude;
    values.location = addressValue;
    values.property_location = locationData;
    values.property_at_glance = JSON.stringify(propertyGlanceData);
    values.financial_cap_stack = JSON.stringify(financialDebtAssumption);
    setLoading(true);

    id != null
      ? axios
          .post('/customer-api/edit-investment-project', values)
          .then(() => {
            setLoading(false);
            navigate('/user/my-listing');
            showSuccess();
            // navigate('/');
          })
          .catch(() => {
            setLoading(false);
          })
      : axios
          .post('/customer-api/investment-my-project', { ...values, agency_id: agency_id })
          .then((response) => {
            setLoading(false);
            showSuccess();
            if (auth.user?.has_subscription == true) {
              setLoading(false);
              navigate('/project-developer');
            } else {
              setIdd(response?.data?.id);
              navigate('/user/subscription');
              setLoading(false);
            }
          })
          .catch(() => {
            setLoading(false);
          });
  };

  const showSuccess = () => {
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'success',
      message: 'Investment For Company  submited successfully!',
    });
  };

  return (
    <ContentLayout title="Property for Rent/Sale">
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="my-5 d-flex flex-column projct-money align-items-center">
        <div className="mt-3 row short-title-rw" style={{ width: '70%' }}>
          <div className="col-12">
            {isLoader ? (
              <EditSalePageLoader />
            ) : (
              <>
                <Card shadow className="shadow-lg p-4">
                  <Form<rentValues, typeof schema>
                    onSubmit={handleSubmit}
                    schema={schema}
                    options={{
                      defaultValues: {
                        ...user,
                        minimum_investment: user?.minimum_investment
                          ? (user?.minimum_investment * localCurrency)?.toString()
                          : '',
                        estimated_first_distribution: user?.estimated_first_distribution
                          ? (user?.estimated_first_distribution * localCurrency)?.toString()
                          : '',
                        target_return_on_cost: user?.target_return_on_cost
                          ? (user?.target_return_on_cost * localCurrency)?.toString()
                          : '',
                      },
                    }}
                  >
                    {({ register, formState }) => (
                      <>
                        <div className="d-flex flex-column align-items-center text-center">
                          {id != null ? (
                            <>
                              <h1>Edit your Property</h1>
                            </>
                          ) : (
                            <>
                              <h1>Add New Project for money !</h1>
                              <h5>
                                Include as much details and pictures as possible, and set the right
                                price.
                              </h5>
                            </>
                          )}
                          <br />
                          <div className="selectedImagesDiv mb-0">
                            <div className="row">
                              <div className="col-12 col-md-4 no-space">
                                <div className="left-money">
                                  <h5>Video</h5>
                                  <label htmlFor="videoInput">
                                    <div className="image-box">
                                      {videoPreview ? (
                                        <img
                                          src={cover?.toString() ?? ''}
                                          alt=""
                                          className="profileImage"
                                        />
                                      ) : user?.videos ? (
                                        <p className="smallFile">
                                          <FileViewer file={user?.videos} />
                                        </p>
                                      ) : (
                                        <img src={plus} alt="" width="60" />
                                      )}
                                    </div>
                                  </label>
                                  <input
                                    accept="video/mp4,video/x-m4v,video/*"
                                    onChange={handleVideoChange}
                                    type="file"
                                    id="videoInput"
                                    className="d-none"
                                  />
                                </div>
                              </div>
                              <div className="col-md-12 col-12  no-space">
                                <h5>Images</h5>

                                <div className="row">
                                  {imageArray?.map((item: any, index: number) => (
                                    <div key={index} className="col-md-2 cross-pic">
                                      <div className="image-box">
                                        <button type="button" onClick={() => deleteImages(index)}>
                                          <i className="fa-solid fa-square-xmark pics"></i>
                                        </button>
                                        <img src={item.image} alt="..." />
                                      </div>
                                      {item.name && <h6 className="itemName">{item.name}</h6>}
                                    </div>
                                  ))}

                                  {images.map((item: any, index: number) => (
                                    <div key={index} className="cross-pic">
                                      <div className="image-box">
                                        <button type="button" onClick={() => deleteImage(index)}>
                                          <i className="fa-solid fa-square-xmark pics"></i>
                                        </button>
                                        <img src={item} alt="..." />
                                      </div>
                                      <input
                                        type="text"
                                        id="imageName"
                                        name="imageName"
                                        placeholder="Image name"
                                        onChange={(e) => handleText(index, e.target.value)}
                                        value={text[index]}
                                      />
                                      {/* {item.name && <h6 className="itemName">{item.name}</h6>} */}
                                    </div>
                                  ))}

                                  <div className="col-md-2 col-12  no-space">
                                    <div className="padding-r">
                                      <label htmlFor="fileInput1">
                                        <div className="image-box">
                                          {load ? (
                                            <Spinner />
                                          ) : (
                                            <img src={plus} alt="" width="60" />
                                          )}
                                        </div>
                                      </label>
                                      <input
                                        accept="image/*"
                                        onChange={handleChange}
                                        multiple
                                        type="file"
                                        id="fileInput1"
                                        className="d-none"
                                      />
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div className="col-md-12 col-12  no-space Partner_Data_Upload">
                                <h5>Partners Data </h5>
                                <div className="row">
                                  {partnerArray?.map((item: any, index: number) => (
                                    <div key={index} className="col-md-4 cross-pic">
                                      <div className="image-box">
                                        <button
                                          type="button"
                                          onClick={() => deletepartnerImages(index)}
                                        >
                                          <i className="fa-solid fa-square-xmark pics"></i>
                                        </button>
                                        <img src={item.image} alt="..." />
                                      </div>
                                      {item.name && <h6 className="itemName">{item.name}</h6>}
                                      {item.about && <h6 className="itemName">{item.about}</h6>}
                                      {item.position && (
                                        <h6 className="itemName">{item.position}</h6>
                                      )}
                                      {item.linkedin && (
                                        <h6 className="itemName">{item.linkedin}</h6>
                                      )}
                                    </div>
                                  ))}
                                </div>
                                {partnerimages?.map((item: any, index: number) => (
                                  <div key={index} className="cross-pic">
                                    <div className="image-box">
                                      <button
                                        type="button"
                                        onClick={() => partnerdeleteImage(index)}
                                      >
                                        <i className="fa-solid fa-square-xmark pics"></i>
                                      </button>
                                      <img src={item} alt="..." />
                                    </div>
                                    <input
                                      type="text"
                                      id="imagepartnerName"
                                      name="imagepartnerName"
                                      placeholder="Member name"
                                      onChange={(e) => handlepartnerText(index, e.target.value)}
                                      value={partnertext[index]}
                                    />

                                    <input
                                      type="text"
                                      id="imagepartnerLinkedin"
                                      name="imagepartnerLinkedin"
                                      placeholder="Linkedin Link"
                                      onChange={(e) => handlepartnerLinkedin(index, e.target.value)}
                                      value={partnerlinkedin[index]}
                                    />
                                    <input
                                      type="text"
                                      id="imagepartnerPosition"
                                      name="imagepartnerPosition"
                                      placeholder="Member Position"
                                      onChange={(e) => handlepartnerPosition(index, e.target.value)}
                                      value={partnerposition[index]}
                                    />
                                    <textarea
                                      id="imageBoardAbout"
                                      name="imageBoardAbout"
                                      placeholder="About Member"
                                      onChange={(e) => handlepartnerAbout(index, e.target.value)}
                                      value={partnerabout[index]}
                                      rows={2}
                                    />
                                  </div>
                                ))}

                                <div className="col-md-6 col-12">
                                  <div className="padding-r">
                                    <label htmlFor="fileInput4">
                                      <div className="image-box">
                                        {partnerload ? (
                                          <Spinner />
                                        ) : (
                                          <img src={plus} alt="" width="60" />
                                        )}
                                      </div>
                                    </label>
                                    <input
                                      accept="image/*"
                                      onChange={partnerhandleChange}
                                      multiple
                                      type="file"
                                      id="fileInput4"
                                      className="d-none"
                                    />
                                  </div>
                                </div>
                              </div>

                              {/* <div className="row">
                            <div className="col-md-6"></div>
                            <div className="col-md-6"></div>
                          </div> */}

                              <div className="col-12 col-md-6  no-space">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label={i18next.t('Property Type')}
                                  error={formState.errors['property_type']}
                                  registration={register('property_type')}
                                />{' '}
                              </div>
                              <div className="col-12 col-md-6  no-space">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Property name"
                                  error={formState.errors['project_name']}
                                  registration={register('project_name')}
                                  placeholder="property_name"
                                />
                              </div>
                              <div className="col-12 col-md-6  no-space">
                                {' '}
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label={i18next.t('Asset Quality')}
                                  error={formState.errors['asset_quality']}
                                  registration={register('asset_quality')}
                                />
                              </div>
                              <div className="col-12 col-md-6  no-space">
                                {' '}
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label={i18next.t('Investment Highlights')}
                                  error={formState.errors['investment_highlights']}
                                  registration={register('investment_highlights')}
                                />
                              </div>
                            </div>
                          </div>
                          {/* ====================== MAnagement logo ============ */}
                          <div className="row managementDiv">
                            <div className=" col-md-4">
                              <h5>Management Logo</h5>
                              <label htmlFor="fileInput22">
                                <div className="image-box">
                                  {managementlogoPreview ? (
                                    <img
                                      src={managementlogoPreview}
                                      alt=""
                                      className="profileImage"
                                    />
                                  ) : user?.management_logo ? (
                                    <img src={user?.management_logo} alt="" width="60" />
                                  ) : (
                                    <img src={plus} alt="" width="60" />
                                  )}
                                </div>
                              </label>
                              <input
                                accept="image/*"
                                onChange={managementlogoChange}
                                type="file"
                                id="fileInput22"
                                className="d-none"
                              />
                            </div>
                            <div className="col-md-8">
                              <TextAreaField
                                rows={5}
                                label="About Management"
                                wrapperClass="w-full"
                                error={formState.errors['about_management']}
                                registration={register('about_management')}
                              ></TextAreaField>
                            </div>
                          </div>

                          {/* =============== Financial ==================== */}
                          <div className="propertyGlanceDiv">
                            <h5 className="mb-3">Financial Capital Stack</h5>
                            <div className="row">
                              <form className="no-space">
                                <div className="row">
                                  <div className="col-12 col-md-4 mb-2 no-space">
                                    <label>
                                      Equity Price ({localSymbol}):
                                      <input
                                        type="text"
                                        name="equityPrice"
                                        value={
                                          financialDebtAssumption.equityPrice
                                            ? financialDebtAssumption.equityPrice * localCurrency
                                            : financialCapStackData?.equityPrice * localCurrency
                                        }
                                        onChange={handleFinancialChange}
                                      />
                                    </label>
                                  </div>
                                  <div className="col-12 col-md-4 mb-2 no-space">
                                    <label>
                                      LP Equity Percent:
                                      <input
                                        type="text"
                                        name="lpEquityPercent"
                                        value={
                                          financialDebtAssumption.lpEquityPercent
                                            ? financialDebtAssumption.lpEquityPercent
                                            : financialCapStackData?.lpEquityPercent
                                        }
                                        onChange={handleFinancialChange}
                                      />
                                    </label>
                                  </div>
                                  <div className="col-12 col-md-4 mb-2 no-space">
                                    <label>
                                      GP Equity Percent:
                                      <input
                                        type="text"
                                        name="gpEquityPercent"
                                        value={
                                          financialDebtAssumption.gpEquityPercent
                                            ? financialDebtAssumption.gpEquityPercent
                                            : financialCapStackData?.gpEquityPercent
                                        }
                                        onChange={handleFinancialChange}
                                      />
                                    </label>
                                  </div>

                                  <div className="col-12 col-md-6 mb-2 no-space">
                                    <label className="w-100">
                                      Debt Price ({localSymbol}):
                                      <input
                                        type="text"
                                        name="debtPrice"
                                        value={
                                          financialDebtAssumption.debtPrice
                                            ? financialDebtAssumption.debtPrice * localCurrency
                                            : financialCapStackData?.debtPrice * localCurrency
                                        }
                                        onChange={handleFinancialChange}
                                      />
                                    </label>
                                  </div>
                                  <div className="col-12 col-md-6 mb-2 no-space">
                                    <label className="w-100">
                                      Debt Percent:
                                      <input
                                        type="text"
                                        name="debtPercent"
                                        value={
                                          financialDebtAssumption.debtPercent
                                            ? financialDebtAssumption.debtPercent
                                            : financialCapStackData?.debtPercent
                                        }
                                        onChange={handleFinancialChange}
                                      />
                                    </label>
                                  </div>
                                </div>

                                {/* <Button onClick={handleFinancialSubmit}>Add</Button> */}
                              </form>
                            </div>
                          </div>
                          {/* =================== FInancial ======================== */}

                          {/* <div className="document-upload-div">
                            <h5>Select Doccument</h5>
                            <label htmlFor="fileInput">
                              <div>
                                {pdfPreview ? (
                                  <>
                                    {pdfName ? (
                                      <>
                                        <div className="files-box">
                                          <p>{pdfName}</p>
                                        </div>
                                      </>
                                    ) : (
                                      <>
                                        <div className="image-box">
                                          <img src={pdfPreview} alt="" className="profileImage" />
                                        </div>
                                      </>
                                    )}
                                  </>
                                ) : (
                                  <>
                                    <div className="files-box">
                                      <img src={plus} alt="" width="60" />
                                    </div>
                                  </>
                                )}
                              </div>
                            </label>
                            <input
                              accept="pdf/*"
                              onChange={pdfhandleChange}
                              type="file"
                              id="fileInput"
                              className="d-none"
                            />
                          </div> */}
                          <div className="docDiv">
                            <p className="headingUplod">Upload Doccuments here</p>
                            <label htmlFor="fileInput">
                              <div>
                                {pdfPreview ? null : (
                                  <>
                                    {user?.documents_data ? (
                                      <div className="pdfDiv">
                                        <FileViewer file={user?.documents_data} />
                                      </div>
                                    ) : null}
                                  </>
                                )}

                                {pdfPreview ? (
                                  <>
                                    {pdfName ? (
                                      <>
                                        <div className="files-box">
                                          <p>{pdfName}</p>
                                        </div>
                                      </>
                                    ) : (
                                      <>
                                        <div className="image-box">
                                          <img src={pdfPreview} alt="" className="profileImage" />
                                        </div>
                                      </>
                                    )}
                                  </>
                                ) : (
                                  <>
                                    {user?.documents_data ? (
                                      <div className="files-box">
                                        <p>Edit Doccument here .</p>
                                      </div>
                                    ) : (
                                      <div className="files-box">
                                        <img src={plus} alt="" width="60" />
                                      </div>
                                    )}
                                  </>
                                )}
                              </div>
                            </label>
                            <input
                              accept="pdf/*"
                              onChange={pdfhandleChange}
                              type="file"
                              id="fileInput"
                              className="d-none"
                            />
                          </div>
                          <div className="propertyGlanceDiv">
                            <h4>Property At Glance</h4>
                            <div className="row">
                              <div className="col-md-5 no-space mb-3">
                                <label>{i18next.t('Title')} </label>
                                <input
                                  type="text"
                                  value={propertyItem}
                                  placeholder="Property Item"
                                  onChange={handleItemChange}
                                />
                              </div>
                              <div className="col-md-5 no-space mb-3">
                                <label>Relevent Data </label>
                                <input
                                  type="text"
                                  placeholder="Property Item Data"
                                  value={propertyItemData}
                                  onChange={handleItemDataChange}
                                />
                              </div>
                              <div className="col-md-2 mt-4">
                                {propertyItemData == '' || propertyItem == '' ? (
                                  <Button disabled> Add</Button>
                                ) : (
                                  <Button onClick={addItem}>Add</Button>
                                )}
                              </div>
                            </div>
                            {propertyGlanceData.length > 0 && (
                              <div className="propertyGlanceDataDiv">
                                <div className="row headPart">
                                  <div className="col-md-5">
                                    <h5>{i18next.t('Title')}</h5>
                                  </div>
                                  <div className="col-md-5">
                                    <h5>Relevent Data</h5>
                                  </div>
                                </div>
                                {propertyGlanceData?.map((item, index) => (
                                  <div className="row dataPart" key={item.id}>
                                    <div className="col-md-5">{item.item}</div>
                                    <div className="col-md-5 overss">{item.data}</div>
                                    <div className="col-md-2">
                                      <Button onClick={() => deleteItem(item.id)}>
                                        <i className="fa-solid fa-trash-can"></i>
                                      </Button>
                                    </div>
                                  </div>
                                ))}

                                {/* <ul>
                                {propertyGlanceData.map((item, index) => (
                                  <li key={item.id}>
                                    {item.item} - {item.data}
                                    <button onClick={() => deleteItem(item.id)}>Delete</button>
                                  </li>
                                ))}
                              </ul> */}
                              </div>
                            )}
                          </div>
                          <div className="row">
                            <div className="col-12 col-md-6 no-space">
                              <TextAreaField
                                label={i18next.t('Business Plan')}
                                wrapperClass="w-full"
                                error={formState.errors['business_plan']}
                                registration={register('business_plan')}
                              ></TextAreaField>
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <TextAreaField
                                label="disclaimers Project"
                                wrapperClass="w-full"
                                error={formState.errors['disclaimers']}
                                registration={register('disclaimers')}
                              ></TextAreaField>
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <InputField
                                type="float"
                                wrapperClass="w-full"
                                label={`${i18next.t('Minimum Investment')} ${localSymbol}`}
                                error={formState.errors['minimum_investment']}
                                registration={register('minimum_investment')}
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <InputField
                                type="text"
                                wrapperClass="w-full"
                                label="Offered By"
                                error={formState.errors['offered_by']}
                                registration={register('offered_by')}
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <TextAreaField
                                label={i18next.t('Investment Strategy')}
                                wrapperClass="w-full"
                                error={formState.errors['investment_strategy']}
                                registration={register('investment_strategy')}
                              ></TextAreaField>
                            </div>

                            <div className="col-12 col-md-6 no-space">
                              <InputField
                                type="float"
                                wrapperClass="w-full"
                                label={`Estimated first Distribution ${localSymbol}`}
                                error={formState.errors['estimated_first_distribution']}
                                registration={register('estimated_first_distribution')}
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <InputField
                                type="number"
                                wrapperClass="w-full"
                                label={i18next.t('Estimated Hold Period')}
                                error={formState.errors['estimated_hold_period']}
                                registration={register('estimated_hold_period')}
                                placeholder="Finder fee"
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <SelectField
                                wrapperClass="w-full"
                                label={i18next.t('Investment Type')}
                                error={formState.errors['investment_type']}
                                registration={register('investment_type')}
                                placeholder="3"
                                options={[
                                  { label: 1, value: 1 },
                                  { label: 2, value: 2 },
                                  { label: 3, value: 3 },
                                  { label: 4, value: 4 },
                                  { label: 5, value: 5 },
                                ]}
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <SelectField
                                wrapperClass="w-full"
                                label={i18next.t('Funded')}
                                error={formState.errors['funded']}
                                registration={register('funded')}
                                placeholder="3"
                                options={[
                                  { label: 'Yes', value: 'Yes' },
                                  { label: 'No', value: 'No' },
                                ]}
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <InputPhone
                                floating
                                error={formState.errors['phone_number']}
                                registration={register('phone_number')}
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <InputField
                                type="float"
                                wrapperClass="w-full"
                                label={`Target Return On Cost ${localSymbol}`}
                                error={formState.errors['target_return_on_cost']}
                                registration={register('target_return_on_cost')}
                                placeholder="Property reference id"
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <InputField
                                type="number"
                                wrapperClass="w-full"
                                label={i18next.t('Target Equity Multiple')}
                                error={formState.errors['target_equity_multiple']}
                                registration={register('target_equity_multiple')}
                                placeholder="213"
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <InputField
                                type="number"
                                wrapperClass="w-full"
                                label="Target irr (in %)"
                                error={formState.errors['target_irr']}
                                registration={register('target_irr')}
                                placeholder="Maintainance Fee &#8364;"
                              />
                            </div>
                            <div className="col-12 col-md-12 no-space">
                              <InputField
                                type="text"
                                wrapperClass="w-full"
                                label="Address"
                                error={formState.errors['location']}
                                registration={register('location')}
                              />
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <div className="draftDivs">
                                <h6 className="draftHead">Location Detail</h6>

                                {iseditForm === true ? (
                                  <EditDraftInput
                                    stateData={locationOldData}
                                    html={locationData}
                                    setHtml={setLocationData}
                                    editorState={locationState}
                                    setEditorState={setlocationState}
                                  />
                                ) : (
                                  <DraftInput html={locationData} setHtml={setLocationData} />
                                )}
                              </div>
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <div className="draftDivs">
                                <h6 className="draftHead">{i18next.t('Property Summary')}</h6>
                                {iseditForm === true ? (
                                  <EditDraftInput
                                    stateData={propertySummaryOldData}
                                    html={propertySummary}
                                    setHtml={setPropertySummary}
                                    editorState={propertySummaryState}
                                    setEditorState={setpropertySummaryState}
                                  />
                                ) : (
                                  <DraftInput html={propertySummary} setHtml={setPropertySummary} />
                                )}
                              </div>
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <div className="draftDivs">
                                <h6 className="draftHead">{i18next.t('Property Detail')}</h6>

                                {iseditForm === true ? (
                                  <EditDraftInput
                                    stateData={propertyDetailOldData}
                                    html={propertyDetail}
                                    setHtml={setPropertyDetail}
                                    editorState={propertyDetailState}
                                    setEditorState={setpropertyDetailState}
                                  />
                                ) : (
                                  <DraftInput html={propertyDetail} setHtml={setPropertyDetail} />
                                )}
                              </div>
                            </div>
                            <div className="col-12 col-md-6 no-space">
                              <div className="draftDivs">
                                <h6 className="draftHead">{i18next.t('OverView')}</h6>
                                {iseditForm === true ? (
                                  <EditDraftInput
                                    stateData={overviewOldData}
                                    html={overview}
                                    setHtml={setOverview}
                                    editorState={overviewState}
                                    setEditorState={setoverviewState}
                                  />
                                ) : (
                                  <DraftInput html={overview} setHtml={setOverview} />
                                )}
                              </div>
                            </div>
                          </div>

                          <div className="draftDivs">
                            <h6 className="draftHead">Dept Assumption</h6>
                            {iseditForm === true ? (
                              <EditDraftInput
                                stateData={deptAsumptionOldData}
                                html={deptAsumption}
                                setHtml={setDeptAsumption}
                                editorState={deptAsumptionState}
                                setEditorState={setdeptAsumptionState}
                              />
                            ) : (
                              <DraftInput html={deptAsumption} setHtml={setDeptAsumption} />
                            )}
                          </div>
                          <h5>Is the pin in the right location?</h5>
                          <br />
                          <div style={{ width: '100%' }}>
                            <div style={{ width: '100%', height: '80%' }}>
                              <Map
                                location={location}
                                setAddressDetails={setAddressDetails}
                                addressDetails={addressDetails}
                              />
                            </div>
                          </div>
                          <br />
                          <div className="col-12">
                            <div className="pt-2 pb-2">
                              <GooglePlacesAutocomplete
                                selectProps={{
                                  defaultInputValue: user?.location ? user?.location : '',
                                  value,
                                  onChange: handleChangeLocation,
                                }}
                              />
                            </div>
                          </div>
                          <br />
                          <div className="d-flex justify-content-end mt-4">
                            {userSubscribed == true ? (
                              <>
                                {' '}
                                {canAddMore ? (
                                  <Button disabled className="disableSubmit">
                                    Reached Upload limit
                                  </Button>
                                ) : (
                                  <Button
                                    isLoading={loading}
                                    type="submit"
                                    variant="primary"
                                    size="md"
                                    className="mt-2 w-full"
                                  >
                                    Submit
                                  </Button>
                                )}
                              </>
                            ) : (
                              <>
                                {' '}
                                <Button
                                  isLoading={loading}
                                  type="submit"
                                  variant="primary"
                                  size="md"
                                  className="mt-2 w-full"
                                >
                                  Subscribe
                                </Button>
                              </>
                            )}
                          </div>
                        </div>
                      </>
                    )}
                  </Form>
                </Card>
              </>
            )}
          </div>
        </div>
      </div>
    </ContentLayout>
  );
};
