import Footer from '@/components/Layout/Footer/Footer';
// import './landing.css';
import React, { useState } from 'react';
import ServiceItemList from './ServiceItemList';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useMyDeals } from '@/api/myDeal/myDeal';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import MyDealListing from '../../components/MyDeal/MyDealListing';
import storage from '@/utils/storage';

export const MyDeal = () => {
  const navigate = useNavigate();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const [loading] = useState(false);
  const { data: listing, isLoading } = useMyDeals({ page: '1' });
  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar content="View your potential deals here and check their progress." />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      {/* <ServiceItemList /> */}
      <div className="container">
        {listing?.length == 0 ? (
          <h5 className="makeCenter">No deals in progress !</h5>
        ) : (
          <div className="row">
            {isLoading ? (
              <MyListingLoader />
            ) : (
              <>
                {listing?.map((item, index) => (
                  <MyDealListing key={index} item={item} myDeal={true} myLead={false} />
                ))}
              </>
            )}
          </div>
        )}
      </div>

      <br />
      <Footer />
    </>
  );
};
