import Footer from '@/components/Layout/Footer/Footer';
// import './landing.css';
import React, { useState } from 'react';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useMyLead } from '@/api/myLead/myLead';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import MyDealListing from '../../components/MyDeal/MyDealListing';

export const MyLeads = () => {
  const navigate = useNavigate();

  const [loading] = useState(false);
  const { data: listing, isLoading } = useMyLead({ page: '1' });
  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar content="Check out the leads on your listings and tenants here." />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="container">
        <div className="row">
          {isLoading ? (
            <MyListingLoader />
          ) : (
            <>
              {listing?.length > 0 ? (
                listing?.map((item, index) => (
                  <MyDealListing key={index} item={item} myDeal={false} myLead={true} />
                ))
              ) : (
                <h5 className="makeCenter">No Leads Yet!</h5>
              )}
            </>
          )}
        </div>
      </div>

      <br />
      <Footer />
    </>
  );
};
