import Footer from '@/components/Layout/Footer/Footer';
import './ServiceItemList.css';
import React, { useState } from 'react';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { usepaymentDoneListing } from '@/api/paymentDone/paymentDone';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import { Button } from '@/components/Elements';
import { Image } from '@/components/Elements/Images/Image';
import { ImageTag } from '@/components/Elements/Images/ImageTag';
import { timeFromNow, trimTen } from '@/utils/format';
export const PaymentDone = () => {
  const navigate = useNavigate();

  const [loading] = useState(false);
  const { data: listing, isLoading } = usepaymentDoneListing({ page: '1' });
  const handleOpen = () => {};
  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar content="View your entire payment history on REEIPO here." />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      {/* <ServiceItemList /> */}
      <div className="container">
        {listing?.length == 0 ? (
          <h5 className="makeCenter">No Payments Recorded!</h5>
        ) : (
          <div className="row">
            {isLoading ? (
              <MyListingLoader />
            ) : (
              <>
                <div className="row">
                  <h4>Payment History</h4>

                  {listing?.map((item, index) => (
                    <div className="col-md-6 col-sm-6 out-pay" key={index}>
                      <div className="pay-box row">
                        <div className="col-md-4 col-sm-4">
                          <Image src={item?.payment_recipet} alt="" />
                        </div>
                        <div className="col-md-8">
                          <div className="item-boxs">
                            {/* <span className="crated-span">{timeFromNow(listing?.created_date)} ago.</span> */}
                            <span className="crated-span">{timeFromNow(item?.created_at)} ago</span>
                            <h5>{trimTen(item?.property_name)}</h5>

                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Payment Mode</p>
                              <p className="rightSd col-4 col-md-4">{item?.mode}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Payment Status</p>
                              <p className="rightSd col-4 col-md-4">{item?.payment_status}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Reciept Status</p>
                              <p className="rightSd col-4 col-md-4">{item?.recipet_status}</p>
                            </div>
                            {/* <div className="row ity">
                              <p className="leftSd col-md-8 col-8">Payment Recipet</p>
                              <p className="rightSd col-4 col-md-4">{item?.payment_recipet}</p>
                              <Button
                                onClick={() => handleOpen(`{item?.payment_recipet}`)}
                              ></Button>
                              <Image src={item?.payment_recipet} alt="" />
                            </div> */}
                          </div>
                        </div>
                      </div>
                    </div>
                  ))}
                </div>
              </>
            )}
          </div>
        )}
      </div>

      <br />
      <Footer />
    </>
  );
};
