import React, { useEffect, useState } from 'react';
import { ContentLayout } from '@/components/Layout';
import clips1 from '@/assets/clips1.png';
import clips2 from '@/assets/clips2.png';
import clips4 from '@/assets/clips4.png';
import clips5 from '@/assets/clips5.png';
import clips6 from '@/assets/clips6.png';
import clips7 from '@/assets/clips7.png';
import clips8 from '@/assets/clips8.png';
import clips9 from '@/assets/clips9.png';
import clips10 from '@/assets/clips10.png';
import clips11 from '@/assets/clips11.png';
import clips12 from '@/assets/clips12.png';
import ui1 from '@/assets/ui1.png';
import ui2 from '@/assets/ui2.png';
import ui3 from '@/assets/ui3.png';
import ui4 from '@/assets/ui4.png';
import ui5 from '@/assets/ui5.png';
import ui6 from '@/assets/ui6.png';
import '../../user.css';
import { Button, Image } from '@/components/Elements';
import { useAuth } from '@/lib/auth';
import { Card } from '@/components/Elements/Card';
import { useNavigate } from 'react-router-dom';
import { useReviewRating } from '@/api/viewProfile/ReviewRating';

const ProfileCard = ({
  image,
  name,
  ContentData,
  link = '',
}: {
  image: string;
  name: string;
  ContentData: string;
  link?: string;
}) => {
  const navigate = useNavigate();

  return (
    <div className="col-12 col-md-6 col-lg-4 mt-4">
      <Card shadow className="p-2 cursor-pointer prf-card">
        <div
          role="button"
          tabIndex={-1}
          onClick={() => navigate(link)}
          onKeyDown={() => navigate(link)}
        >
          <div className="d-flex align-items-center ">
            <Image alt="banner" className="profileCardImage" src={image} width="50" height="40" />
            <span className="ms-4 card-title-eipo">{name}</span>
          </div>
          <p className="mt-3 mb-1">{ContentData}</p>
        </div>
      </Card>
    </div>
  );
};

export const Profile = () => {
  const { user, logout } = useAuth();

  const [isAgent, setIsAgent] = useState(false);
  const loginHeader = localStorage.getItem('loginType');

  useEffect(() => {
    if (loginHeader === 'admin') {
      setIsAgent(true);
    }
  }, [loginHeader]);

  const pId = user?.customer_id;
  const navigate = useNavigate();
  const { data, isLoading, refetch } = useReviewRating({ id: pId });
  return (
    <ContentLayout title="Profile">
      <div className="container-fluid profileContainer">
        <div className="row">
          <div className="col-12 col-md-12 col-lg-5 d-flex profile-top">
            <Image alt="banner" className="previewImage" src={user?.profile_image} width="100" />
            <div className="d-flex flex-column mt-2">
              <h5 className="mb-1">
                <b>{`${user?.first_name ?? ''} ${user?.last_name ?? ''}`} </b>
              </h5>
              <p className="mb-1">{user?.email ?? ''}</p>
              {/* <span>
                <a className="textprimary" role="button">
                  Reviews : {data?.total_reviews === 0 ? 'N/A' : data?.total_reviews}
                </a>
                //l
                &nbsp; &nbsp; | &nbsp; &nbsp;
                <a className="textprimary" role="button">
                  Ratings : {data?.average_rating === null ? 'N/A' : data?.average_rating}
                </a>
              </span> */}
              <span>
                {data?.total_reviews === ' ' ? (
                  <a className="textprimary" role="button">
                    Reviews :N/A
                  </a>
                ) : (
                  <a
                    className="textprimary"
                    role="button"
                    onClick={() => navigate(`/all-review?id=${pId}`)}
                  >
                    Reviews :{data?.total_reviews}
                  </a>
                )}
                &nbsp; &nbsp; | &nbsp; &nbsp;
                {data?.average_rating === ' ' ? (
                  <a className="textprimary" role="button">
                    Ratings : N/A
                  </a>
                ) : (
                  <a
                    className="textprimary"
                    role="button"
                    onClick={() => navigate(`/all-review?id=${pId}`)}
                  >
                    Ratings : {data?.average_rating}
                  </a>
                )}
              </span>
            </div>
          </div>
          <div className="col-12 col-md-1 col-lg-1"></div>
          <div className="col-12 col-md-12 col-lg-6">
            <div className="d-flex justify-content-end profile-col">
              <Button variant="outlineDark" onClick={() => navigate(`/profile-details?id=${pId}`)}>
                {' '}
                View your profile as others see it
              </Button>
              <Button onClick={() => logout()} variant="outlineDark" className="ms-3">
                Log out
              </Button>
            </div>
          </div>
        </div>
      </div>
      <div className="container mt-4">
        <h4>My Reeipo</h4>
        {!isAgent && (
          <div className="row mt-4 ">
            <ProfileCard
              link="/user/update-profile"
              image={clips4}
              name="Account Details"
              ContentData="User account details"
            />
            <ProfileCard
              link="/user/my-listing"
              image={clips8}
              name="My Listing"
              ContentData="All the listings created by you are available here."
            />
            <ProfileCard
              link="/user/favourite-list"
              image={clips7}
              name="Favourite"
              ContentData="My favorite listings are kept here."
            />
            <ProfileCard
              link="/user/my-leads"
              image={ui6}
              name="My Leads"
              ContentData="All request on my properties and tenant will appear here."
            />{' '}
            <ProfileCard
              link="/user/payment-completed"
              image={clips5}
              name="Payments"
              ContentData="All the payments records are available here."
            />
            <ProfileCard
              link="/user/my-deals"
              image={clips6}
              name="My Deal"
              ContentData="All the deals that you are interested in will be displayed here."
            />
            <ProfileCard
              link="/user/saved-search"
              image={ui3}
              name="Saved Searches"
              ContentData="All the save searches will appear here."
            />
            <ProfileCard
              link="/read-Notifications"
              image={clips9}
              name="Notifications"
              ContentData="Manage your notifications"
            />
            <ProfileCard
              link="/user/create-company"
              image={clips12}
              name="Company"
              ContentData="Your company profile builder."
            />
            <ProfileCard
              link="/user/get-verified"
              image={clips11}
              name="Get Verified"
              ContentData="Want more benefits on REEIPO? Get verified here!"
            />
            {/* <ProfileCard
              link="/user/draft-listing"
              image={clips10}
              name="Draft Item"
              ContentData="All the draft item will appear here."
            />{' '} */}
            <ProfileCard
              link="/user/my-bookings"
              image={ui1}
              name="My Bookings"
              ContentData="All the business meeting details will appear here."
            />
            <ProfileCard
              link="/user/agency-list"
              image={ui6}
              name="Agency Deals"
              ContentData="All the deals offered by the agency appear here."
            />
            <ProfileCard
              link="/user/shares-list"
              image={ui2}
              name="Buy Shares"
              ContentData="All the shares related details will appear here."
            />
            <ProfileCard image={clips2} name="Dialogue" ContentData="View user chats." />
            <ProfileCard
              link="/user/subscription"
              image={ui5}
              name="My Subscription"
              ContentData="Want to change your subscription plan ."
            />
          </div>
        )}
        {isAgent && (
          <div className="row mt-4 ">
            <ProfileCard
              link="/user/my-listing"
              image={clips8}
              name="My Listing"
              ContentData="All the listings created by users are available here."
            />
          </div>
        )}
      </div>
    </ContentLayout>
  );
};
