import React, { useState, useEffect } from 'react';
import { GoogleMap, Marker } from '@react-google-maps/api';
// import React, { useEffect, useRef, useState } from 'react';
import axiosmod from 'axios';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { ContentLayout } from '@/components/Layout';
import { Card } from '@/components/Elements/Card';
import * as z from 'zod';
import plus from '@/assets/plus.png';
import { Form, InputField, SelectField } from '@/components/Form';
import { Button, Spinner } from '@/components/Elements';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import { axios } from '@/lib/axios';
import './CreateProperty.css';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import DraftInput from '@/components/Elements/DraftInput/DraftInput';
import amanetiesCategory from '@/constants/amanetiesCategory';
import { MultiSelect } from 'react-multi-select-component';
// import EditProperty from '@/components/Elements/Loader/EditProperty ';
import propertyCategory from '@/constants/propertyCategory';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import CustomTooltip from '@/components/Elements/CustomTooltip/CustomTooltip';
import { useAuth } from '@/lib/auth';
import storage from '@/utils/storage';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';
import EditSalePageLoader from '@/components/Elements/Loader/EditSalePageLoader';
import i18next from 'i18next';
import { translateAmenties } from '@/translations/translateFunction';

const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;

// -------------- google maps --------------------

function Map({
  location,
  // addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

// ---------------google maps -------------------

const schema2 = z.object({
  short_title: z.string().min(1, 'Please enter short title'),
});
type CreateTitle = {
  short_title: string;
};

const schema = z.object({
  property_name: z.string().min(1, 'Please enter property name'),
  youtube_url: z.string().optional(),
  phone_number: z.custom(isValidMobile, isValidMobileMsg),

  price: z.string().min(1, 'Please enter price'),
  size: z.string().min(1, 'Please enter size').max(10, 'Property size cnnnot exceed 5 units'),
  bill_utilites: z.string().optional(),
  return_on_investment: z.string().min(1, 'Please enter return of investments'),
  cashflow_pcm: z.string().min(1, 'Please enter cashflow PCM').max(10, 'Price value too large'),
  finder_fees: z.string().optional(),
  gross_income: z.string().min(1, 'Please enter gross income').max(10, 'Price value too large'),
  total_closing_fees: z.string().optional(),
  developer: z.string().optional(),
  bedroom: z.string().optional(),
  bathroom: z.string().optional(),
  read_by: z.string().optional(),
  property_refernce_id: z.string().optional(),
  maintance_fees: z.string().optional(),
  house_number: z.string().min(1, 'Please enter house number'),
  postal_code: z.string().min(1, 'Please enter postal code').max(10, 'Postal code value too large'),
  rent_to_landlord: z
    .string()
    .min(1, 'Please enter rent to landloard')
    .max(10, 'Price value too large'),
  title: z.string().min(1, 'Please enter short title'),
  category: z.string().optional(),
});

type CreatePropertyValues = {
  title: string;
  property_name: string;
  youtube_url: string;
  phone_number: string;
  price: any;
  size: string;
  bill_utilites: any;
  return_on_investment: any;
  cashflow_pcm: any;
  finder_fees: any;
  gross_income: any;
  total_closing_fees: any;
  developer: string;
  bedroom: string;
  bathroom: string;
  read_by: string;
  property_refernce_id: string;
  maintance_fees: any;
  house_number: string;
  town: string;
  postal_code: string;
  rent_to_landlord: any;
  latitude: string;
  longitude: string;
  category: string;
  is_draft: boolean;
  image_data: any;
  disclaimer: string;
  property_information: string;
};

export const CreatePropertyProject = () => {
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();

  const auth = useAuth();
  const [id, setId] = useState('');
  const [selected, setSelected] = useState([]);
  const navigate = useNavigate();
  const [loading, setLoading] = useState(false);
  const [step, setStep] = useState(1);
  const [short_title, setShort_title] = useState('');
  const [latitude, setlatitude] = useState('');
  const [longitude, setlongitude] = useState('');
  // const [isPic, setIsPic] = useState('');
  const { images, handleChange, uploaded, deleteImage, text, setText, load } =
    useSelectMultipleFile();
  const handleSubmit2 = async (values: CreateTitle) => {
    setShort_title(values.short_title);
    setlatitude(values.short_title);
    setlongitude(values.short_title);
    setStep(2);
  };

  // const [value, setValue] = useState(null);
  // const [address, setAddress] = useState<string>('');
  // const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  // const [addressDetails, setAddressDetails] = useState({
  //   address_label: '',
  //   latitude: '',
  //   longitude: '',
  // });

  // const handleChangeLocation = async (value: any) => {
  //   const placeId = value.value.place_id;
  //   const { data } = await axiosmod.get(
  //     `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
  //   );
  //   const location = data?.results[0]?.geometry?.location;
  //   if (location) {
  //     setLocation(location);
  //     setAddress(value.label);
  //     setValue(value);
  //   }
  // };
  const [address, setAddress] = useState<string>('');
  const [value, setValue] = useState(null);
  const [addressValue, setAddressValue] = useState<string>('');
  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_line: '',
    latitude: '',
    longitude: '',
  });

  useEffect(() => {
    setlatitude(addressDetails?.latitude);
    setlongitude(addressDetails?.longitude);
    setAddressValue(addressDetails?.address_line);
  }, [addressDetails]);
  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  const [is_draft, setis_draft] = useState<boolean>(false);
  const [visionHtml, setvisionHtml] = useState<any>(null);
  const [rentalHtml, setRentalHtml] = useState<any>(null);
  const [property_descriptionHTML, setproperty_descriptionHTML] = useState<any>(null);
  const [cashflow_forecastHTML, setcashflow_forecastHTML] = useState<any>(null);
  const [costs_to_considerHTML, setcosts_to_considerHTML] = useState<any>(null);
  const [capital_requiredHTML, setcapital_requiredHTML] = useState<any>(null);
  const [locationHTML, setlocationHTML] = useState<any>(null);
  const [disclaimerHTML, setdisclaimerHTML] = useState<any>(null);
  const [property_informationHTML, setproperty_informationHTML] = useState<any>(null);
  const [options, setOptions] = useState<string>();
  const [isLoading, setIsLoading] = useState<boolean>(false);

  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft(false);
    } else {
      setis_draft(true);
    }
  }, [auth?.user?.has_subscription]);
  const [canAddMore, setcanAddMore] = useState(false);
  useEffect(() => {
    if (auth.user?.total_property_upload >= auth.user?.property_count) {
      setcanAddMore(true);
    }
  }, [auth?.user?.has_subscription]);

  const addData = {
    editId: `${id}`,
    pageUrl: `/user/edit-property-project/${id}?type=PropertyProject`,
  };
  storage.setSubmitFormData(addData);

  const handleText = (index: number, val: string) => {
    const textItems = [...text];
    textItems[index] = val;
    setText(textItems);
  };

  const agency_id = localStorage.getItem('agency_id');

  const convertValuesToLocalCurrency = async (values: any) => {
    const fieldsToConvert = [
      'price',
      'bill_utilites',
      'total_closing_fees',
      'rent_to_landlord',
      'maintance_fees',
      'return_on_investment',
      'cashflow_pcm',
      'finder_fees',
      'gross_income',
    ];

    fieldsToConvert.forEach((field) => {
      values[field] /= localCurrency;
    });
  };

  const handleSubmit = async (values: CreatePropertyValues) => {
    const newArray = uploaded.map(function (value, index) {
      return { image: value, name: text[index] };
    });
    const image_data = newArray;

    try {
      setLoading(true);
      const amenities = selected.map(({ value }) => `${value}`).join(',');
      const rental = rentalHtml ?? '';
      const vision = visionHtml ?? '';
      const property_description = property_descriptionHTML ?? '';
      const cashflow_forecast = cashflow_forecastHTML ?? '';
      const location = locationHTML ?? '';
      const disclaimer = disclaimerHTML ?? '';
      const property_information = property_informationHTML ?? '';
      // const latitude = latitude;
      // const longitude = longitude;
      const town = addressValue;
      const costs_to_consider = costs_to_considerHTML ?? '';
      const capital_required = capital_requiredHTML ?? '';
      await convertValuesToLocalCurrency(values);
      console.log(values);
      const result = await axios.post('/customer-api/add-property-project', {
        ...values,
        is_draft,
        image_data,
        rental,
        disclaimer,
        property_information,
        vision,
        property_description,
        cashflow_forecast,
        costs_to_consider,
        capital_required,
        location,
        amenities,
        short_title,
        latitude,
        longitude,
        town,
        agency_id: agency_id,
      });
      const responseData = result.data;
      setId(responseData.id);
      const property_id = responseData.id;
      const property_name = responseData.property_name;
      const youtube_url = responseData.youtube_url;
      const phone_number = responseData.phone_number;
      const price = responseData.price;
      const size = responseData.size;
      const category = responseData.category;
      const bill_utilites = responseData.bill_utilites;
      const return_on_investment = responseData.return_on_investment;
      const cashflow_pcm = responseData.cashflow_pcm;
      const finder_fees = responseData.finder_fees;
      const gross_income = responseData.gross_income;
      const total_closing_fees = responseData.total_closing_fees;
      const developer = responseData.developer;
      const bedroom = responseData.bedroom;
      const bathroom = responseData.bathroom;
      const read_by = responseData.read_by;
      const property_refernce_id = responseData.property_refernce_id;
      const maintance_fees = responseData.maintance_fees;
      const house_number = responseData.house_number;
      // const town = responseData.town;
      const postal_code = responseData.postal_code;
      const rent_to_landlord = responseData.rent_to_landlord;

      await axios.post('/customer-api/edit-property-project', {
        image_data,
        property_id,
        property_name,
        location,
        youtube_url,
        phone_number,
        price,
        size,
        is_draft,
        bill_utilites,
        return_on_investment,
        cashflow_pcm,
        finder_fees,
        disclaimer,
        property_information,
        gross_income,
        property_description,
        total_closing_fees,
        developer,
        bedroom,
        short_title,
        bathroom,
        read_by,
        property_refernce_id,
        maintance_fees,
        amenities,
        house_number,
        town,
        postal_code,
        rent_to_landlord,
        rental,
        vision,
        cashflow_forecast,
        costs_to_consider,
        capital_required,
        category,
        latitude,
        longitude,
      });

      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Property submitted successfully!',
      });
      navigate('/property-project');
    } finally {
      if (auth.user?.has_subscription == true) {
        setLoading(false);
      } else {
        navigate('/user/subscription');
        setLoading(false);
      }
    }
  };

  const step3Clicked = (title: string) => {
    setOptions(title);
    setStep(3);
    setIsLoading(true);
    setTimeout(() => {
      setIsLoading(false);
    }, 1000);
  };

  return (
    <>
      <BackdropLoader open={loading} />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <ContentLayout title="Create Property Project">
        <div className="container creatie-project mt-4">
          {step == 3 && (
            <>
              <h3>Add New Advertisement/Listing one</h3>
              <h5 className="ms-2 my-4">Property Information</h5>
            </>
          )}
          <Form<CreateTitle, typeof schema2> onSubmit={handleSubmit2} schema={schema2}>
            {({ register, formState }) => (
              <>
                {step == 1 && (
                  <div className="my-5 d-flex flex-column align-items-center">
                    <div className="mt-3 row short-title-rw" style={{ width: '60%' }}>
                      <div className="col-12">
                        <Card shadow className="shadow-lg p-4">
                          <div className="d-flex flex-column align-items-center text-center">
                            <h1>
                              {translateAmenties('Enter a short title to describe your listing')}
                            </h1>
                            <h4>
                              {translateAmenties('Make your title informative and attractive')}.
                            </h4>
                            <br />
                            <InputField
                              type="text"
                              wrapperClass="w-full"
                              label="Short Title"
                              error={formState.errors['short_title']}
                              registration={register('short_title')}
                            />
                            <Button type="submit" variant="primary" size="md" className="mt-2 ">
                              Let&apos;s Go
                            </Button>
                          </div>
                        </Card>
                      </div>
                    </div>
                  </div>
                )}
              </>
            )}
          </Form>

          {isLoading && <EditSalePageLoader />}
          {!isLoading && (
            <Form<CreatePropertyValues, typeof schema>
              onSubmit={handleSubmit}
              schema={schema}
              options={{
                defaultValues: {
                  title: short_title,
                  category: options,
                },
              }}
              // options={{
              //   defaultValues: {
              //     property_id: localStorageData?.property_id,
              //     property_name: localStorageData?.property_name,
              //     location: localStorageData?.location,
              //     youtube_url: localStorageData?.youtube_url,
              //     phone_number: localStorageData?.phone_number,
              //     price: localStorageData?.price,
              //     size: localStorageData?.size,
              //     bill_utilites: localStorageData?.bill_utilites,
              //     return_on_investment: localStorageData?.return_on_investment,
              //     cashflow_pcm: localStorageData?.cashflow_pcm,
              //     finder_fees: localStorageData?.finder_fees,
              //     gross_income: localStorageData?.gross_income,
              //     property_description: localStorageData?.property_description,
              //     total_closing_fees: localStorageData?.total_closing_fees,
              //     developer: localStorageData?.developer,
              //     bedroom: localStorageData?.bedroom,
              //     short_title: localStorageData?.short_title,
              //     bathroom: localStorageData?.bathroom,
              //     read_by: localStorageData?.read_by,
              //     property_refernce_id: localStorageData?.property_refernce_id,
              //     maintance_fees: localStorageData?.maintance_fees,
              //     amenities: localStorageData?.amenities,
              //     house_number: localStorageData?.house_number,
              //     postal_code: localStorageData?.postal_code,
              //     rent_to_landlord: localStorageData?.rent_to_landlord,
              //     rental: localStorageData?.rental,
              //     vision: localStorageData?.vision,
              //     cashflow_forecast: localStorageData?.cashflow_forecast,
              //     costs_to_consider: localStorageData?.costs_to_consider,
              //     capital_required: localStorageData?.capital_required,
              //     image_one: localStorageData?.image_one,
              //     image_two: localStorageData?.image_two,
              //     image_three: localStorageData?.image_three,
              //     image_four: localStorageData?.image_four,
              //     image_five: localStorageData?.image_five,
              //     category: localStorageData?.category,
              //     image_one_name: localStorageData?.image_one_name,
              //     image_two_name: localStorageData?.image_two_name,
              //     image_three_name: localStorageData?.image_three_name,
              //     image_four_name: localStorageData?.image_four_name,
              //     image_five_name: localStorageData?.image_five_name,
              //   },
              // }}
            >
              {({ register, formState }) => (
                <>
                  {/* {step == 2 && (
                  <div className="my-5 d-flex flex-column align-items-center">
                    <div className="mt-3 row short-title-rw" style={{ width: '60%' }}>
                      <div className="col-12">
                        <Card shadow className="shadow-lg p-4">
                          <div className="d-flex flex-column align-items-center text-center">
                            <h1>Now choose the right category for your listing</h1>
                            <br />
                            <SelectField
                              wrapperClass="w-full"
                              label="Company Category"
                              label="Company Category"
                              error={formState.errors['category']}
                              registration={register('category', {
                                onChange: () => setNext(true),
                              })}
                              placeholder="Company Category"
                              options={Object.entries(propertyCategory).map(([key, value]) => ({
                                label: value,
                                value: key,
                              }))}
                            />
                            {next && (
                              <Button
                                type="submit"
                                className="mt-2"
                                onClick={() => {
                                  setStep(3);
                                }}
                              >
                                Next
                              </Button>
                            )}
                          </div>
                        </Card>
                      </div>
                    </div>
                  </div>
                )} */}
                  {step == 2 && (
                    <div className="my-5 d-flex flex-column align-items-center rent-sale-add">
                      <div className="mt-3 row short-title-rw" style={{ width: '70%' }}>
                        <div className="col-12">
                          <Card shadow className="shadow-lg- p-4">
                            <div className="d-flex flex-column align-items-center text-center">
                              <h1>
                                {translateAmenties(
                                  'Now choose the right category for your listing'
                                )}
                              </h1>
                              <br />
                              <a
                                className="w-full cursor-pointer mb-2"
                                role="presentation"
                                onClick={() => step3Clicked('apartment_for_sale')}
                              >
                                <div className="flex justify-between p-4 border rounded">
                                  {i18next.t('Apartment For Sale')} <div>&gt;</div>
                                </div>
                              </a>
                              <a
                                className="w-full cursor-pointer mb-2"
                                role="presentation"
                                onClick={() => step3Clicked('villa_house_for_sale')}
                              >
                                <div className="flex justify-between p-4 border rounded">
                                  {i18next.t('Villa/House for Sale')}
                                  <div>&gt;</div>
                                </div>
                              </a>
                              <a
                                className="w-full cursor-pointer mb-2"
                                role="presentation"
                                onClick={() => step3Clicked('townhouse')}
                              >
                                <div className="flex justify-between p-4 border rounded">
                                  {i18next.t('Townhouse')} <div>&gt;</div>
                                </div>
                              </a>
                              <a
                                className="w-full cursor-pointer mb-2"
                                role="presentation"
                                onClick={() => step3Clicked('Penthouse')}
                              >
                                <div className="flex justify-between p-4 border rounded">
                                  {i18next.t('Penthouse')} <div>&gt;</div>
                                </div>
                              </a>
                              <a
                                className="w-full cursor-pointer mb-2"
                                role="presentation"
                                onClick={() => step3Clicked('Residential_Floor')}
                              >
                                <div className="flex justify-between p-4 border rounded">
                                  {i18next.t('Residential Floor')}
                                  <div>&gt;</div>
                                </div>
                              </a>
                              <a
                                className="w-full cursor-pointer mb-2"
                                role="presentation"
                                onClick={() => step3Clicked('Residential_Building')}
                              >
                                <div className="flex justify-between p-4 border rounded">
                                  {i18next.t('Residential Building')} <div>&gt;</div>
                                </div>
                              </a>
                            </div>
                          </Card>
                        </div>
                      </div>
                    </div>
                  )}
                  {step == 3 && (
                    <div className="profile-box mb-5">
                      <div className="row">
                        {images.map((item: any, index: number) => (
                          <div key={index} className="cross-pic">
                            <div className="image-box">
                              <button type="button" onClick={() => deleteImage(index)}>
                                <i className="fa-solid fa-square-xmark pics"></i>
                              </button>
                              <img src={item} alt="..." />
                            </div>
                            <input
                              type="text"
                              id="imageName"
                              name="imageName"
                              placeholder="Image name"
                              onChange={(e) => handleText(index, e.target.value)}
                              value={text[index]}
                            />
                            {/* {item.name && <h6 className="itemName">{item.name}</h6>} */}
                          </div>
                        ))}

                        <div className="col-md-2 col-12">
                          <div className="padding-r">
                            <label htmlFor="fileInput1">
                              <div className="image-box">
                                {load ? <Spinner /> : <img src={plus} alt="" width="60" />}
                              </div>
                            </label>
                            <input
                              accept="image/*"
                              onChange={handleChange}
                              multiple
                              type="file"
                              id="fileInput1"
                              className="d-none"
                            />
                          </div>
                        </div>
                      </div>
                      <div className="row">
                        <div className="col-6">
                          <InputField
                            type="text"
                            label="Short Title"
                            error={formState.errors['title']}
                            registration={register('title')}
                          />
                        </div>
                        <div className="col-6">
                          <SelectField
                            label={i18next.t('Sub Category')}
                            error={formState.errors['category']}
                            registration={register('category')}
                            placeholder={i18next.t('Sub Category')}
                            options={Object.entries(propertyCategory).map(([key, value]) => ({
                              label: value,
                              value: key,
                            }))}
                          />
                        </div>
                      </div>

                      <div className="row">
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="text"
                            label="Property Name"
                            error={formState.errors['property_name']}
                            registration={register('property_name')}
                            placeholder="Property Name"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="number"
                            label="House Number"
                            error={formState.errors['house_number']}
                            registration={register('house_number')}
                            placeholder="House Number"
                          />
                        </div>

                        <div style={{ width: '100%' }}>
                          <div style={{ width: '100%', height: '80%' }}>
                            <Map
                              location={location}
                              setAddressDetails={setAddressDetails}
                              addressDetails={addressDetails}
                            />
                          </div>
                        </div>
                        <br />
                        <div className="col-12 col-md-6 mt-4">
                          <div className="">
                            <GooglePlacesAutocomplete
                              selectProps={{
                                // defaultInputValue: user?.location ? user?.location : '',
                                defaultInputValue: '',
                                value,
                                onChange: handleChangeLocation,
                              }}
                            />
                          </div>
                        </div>

                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="text"
                            label={i18next.t('Postal Code')}
                            error={formState.errors['postal_code']}
                            registration={register('postal_code')}
                            placeholder="{i18next.t('Postal Code')}"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="text"
                            min={0}
                            label="Youtube URL"
                            error={formState.errors['youtube_url']}
                            registration={register('youtube_url')}
                            placeholder="Youtube URL"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputPhone
                            floating
                            error={formState.errors['phone_number']}
                            registration={register('phone_number')}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="number"
                            label={`${i18next.t('Price')} ${localSymbol}`}
                            error={formState.errors['price']}
                            registration={register('price')}
                            placeholder={i18next.t('Price')}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="number"
                            label="Property dimensions sq.ft"
                            error={formState.errors['size']}
                            registration={register('size')}
                            placeholder="Property dimensions sq.ft"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <p className="draftHead">
                            Location
                            <CustomTooltip
                              text={'Please share referece / nearby location to your property. '}
                            />
                          </p>
                          <DraftInput html={locationHTML} setHtml={setlocationHTML} />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <p className="draftHead">
                            Vision <CustomTooltip text={'Please share your vision here. '} />
                          </p>
                          <DraftInput html={visionHtml} setHtml={setvisionHtml} />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <p className="draftHead">
                            {translateAmenties('Rental')}
                            <CustomTooltip text={'Explain your Rental criteria with us. '} />
                          </p>
                          <DraftInput html={rentalHtml} setHtml={setRentalHtml} />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <p className="draftHead">
                            Property Description
                            <CustomTooltip text={'Share the description of your property. '} />
                          </p>
                          <DraftInput
                            html={property_descriptionHTML}
                            setHtml={setproperty_descriptionHTML}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="number"
                            label={`Total closing fees ${localSymbol}`}
                            error={formState.errors['total_closing_fees']}
                            registration={register('total_closing_fees')}
                            placeholder="Total closing fees &#8364;"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="text"
                            label="Developer"
                            error={formState.errors['developer']}
                            registration={register('developer')}
                            placeholder="Developer"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <SelectField
                            wrapperClass="w-full"
                            label={i18next.t('Bedrooms')}
                            error={formState.errors['bedroom']}
                            registration={register('bedroom')}
                            placeholder="3"
                            options={[
                              { label: 1, value: 1 },
                              { label: 2, value: 2 },
                              { label: 3, value: 3 },
                              { label: 4, value: 4 },
                              { label: 5, value: 5 },
                            ]}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <SelectField
                            wrapperClass="w-full"
                            label="Bathrooms"
                            error={formState.errors['bathroom']}
                            registration={register('bathroom')}
                            placeholder="3"
                            options={[
                              { label: 1, value: 1 },
                              { label: 2, value: 2 },
                              { label: 3, value: 3 },
                              { label: 4, value: 4 },
                              { label: 5, value: 5 },
                            ]}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="text"
                            label="Ready by"
                            error={formState.errors['read_by']}
                            registration={register('read_by')}
                            placeholder="Ready by"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="text"
                            label="Property Refernce ID"
                            error={formState.errors['property_refernce_id']}
                            registration={register('property_refernce_id')}
                            placeholder="Property Refernce ID"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4">
                          <InputField
                            type="number"
                            label={`Maintance fees  ${localSymbol}`}
                            error={formState.errors['maintance_fees']}
                            registration={register('maintance_fees')}
                            placeholder="Maintance fees &#8364;"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-4 ">
                          <MultiSelect
                            options={Object.entries(amanetiesCategory).map(([key, value]) => ({
                              label: value,
                              value: key,
                            }))}
                            value={selected}
                            onChange={setSelected}
                            labelledBy="Select Amenaties."
                          />
                        </div>
                        <p className="mt-4 btn-heavy">Property Information</p>
                        <div className="col-12 col-md-6">
                          <InputField
                            type="number"
                            label={`Bills & Utilites ${localSymbol}`}
                            error={formState.errors['bill_utilites']}
                            registration={register('bill_utilites')}
                            placeholder="Bills & Utilites &#8364;"
                          />
                        </div>
                        <div className="col-12 col-md-6">
                          <InputField
                            type="number"
                            label={`${i18next.t('Return on investment')} ${localSymbol}`}
                            error={formState.errors['return_on_investment']}
                            registration={register('return_on_investment')}
                            placeholder={`${i18next.t('Return on investment')} &#8364;`}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <InputField
                            type="number"
                            label={`${i18next.t('Cashflow PCM')} ${localSymbol}`}
                            error={formState.errors['cashflow_pcm']}
                            registration={register('cashflow_pcm')}
                            placeholder="Cashflow PCM &#8364;"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <InputField
                            type="number"
                            label={`Finder fees ${localSymbol}`}
                            error={formState.errors['finder_fees']}
                            registration={register('finder_fees')}
                            placeholder="Finder fees &#8364;"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <InputField
                            type="number"
                            label={`Potential gross income ${localSymbol}`}
                            error={formState.errors['gross_income']}
                            registration={register('gross_income')}
                            placeholder="Potential gross income &#8364;"
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <InputField
                            type="number"
                            label={`${i18next.t('Rent To Landlord')} ${localSymbol}`}
                            error={formState.errors['rent_to_landlord']}
                            registration={register('rent_to_landlord')}
                            placeholder={i18next.t('Rent To Landlord')}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <p className="draftHead">{i18next.t('Cashflow Forecast')}</p>
                          <DraftInput
                            html={cashflow_forecastHTML}
                            setHtml={setcashflow_forecastHTML}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <p className="draftHead">Costs To Consider</p>
                          <DraftInput
                            html={costs_to_considerHTML}
                            setHtml={setcosts_to_considerHTML}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <p className="draftHead">{i18next.t('Disclaimer')}</p>
                          <DraftInput html={disclaimerHTML} setHtml={setdisclaimerHTML} />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <p className="draftHead">Property Information</p>
                          <DraftInput
                            html={property_informationHTML}
                            setHtml={setproperty_informationHTML}
                          />
                        </div>
                        <div className="col-12 col-md-6 mt-2">
                          <p className="draftHead">{i18next.t('Capital Required')}</p>
                          <DraftInput
                            html={capital_requiredHTML}
                            setHtml={setcapital_requiredHTML}
                          />
                        </div>
                        <div className="d-flex justify-content-center mt-4">
                          {auth.user?.has_subscription == true ? (
                            <>
                              {canAddMore ? (
                                <Button disabled className="disableSubmit">
                                  Reached Upload limit
                                </Button>
                              ) : (
                                <Button type="submit">Submit</Button>
                              )}
                            </>
                          ) : (
                            <>
                              {' '}
                              <Button type="submit">Subscribe</Button>
                            </>
                          )}
                        </div>
                      </div>
                    </div>
                  )}
                </>
              )}
            </Form>
          )}
        </div>
      </ContentLayout>
    </>
  );
};
