import React, { useState, useEffect } from 'react';
import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import Typography from '@mui/material/Typography';
import Box from '@mui/material/Box';
import DraftInput from '@/components/Elements/DraftInput/DraftInput';
import { translateAmenties } from '@/translations/translateFunction';
interface TabPanelProps {
  children?: React.ReactNode;
  index: number;
  value: number;
}

function TabPanel(props: TabPanelProps) {
  const { children, value, index, ...other } = props;
  const [locationHTMLs, setlocationHTMLs] = useState<any>(null);
  return (
    <div
      role="tabpanel"
      hidden={value !== index}
      id={`simple-tabpanel-${index}`}
      aria-labelledby={`simple-tab-${index}`}
      {...other}
    >
      {value === index && (
        <Box sx={{ p: 3 }}>
          <Typography>{children}</Typography>
        </Box>
      )}
    </div>
  );
}

function a11yProps(index: number) {
  return {
    id: `simple-tab-${index}`,
    'aria-controls': `simple-tabpanel-${index}`,
  };
}

export default function PropertyTabs({
  setvisionHtml,
  setRentalHtml,
  setproperty_descriptionHTML,
  setcashflow_forecastHTML,
  setcosts_to_considerHTML,
  setcapital_requiredHTML,
  setlocationHTML,
}: {
  setvisionHtml: any;
  setRentalHtml: any;
  setproperty_descriptionHTML: any;
  setcashflow_forecastHTML: any;
  setcosts_to_considerHTML: any;
  setcapital_requiredHTML: any;
  setlocationHTML: any;
}) {
  const [value, setValue] = React.useState(0);

  const handleChange = (event: React.SyntheticEvent, newValue: number) => {
    setValue(newValue);
  };
  const [locationHTMLs, setlocationHTMLs] = useState<any>(null);
  const [visionHtmls, setvisionHtmls] = useState<any>(null);
  const [rentalHtmls, setrentalHtmls] = useState<any>(null);
  const [property_descriptionHTMLs, setproperty_descriptionHTMLs] = useState<any>(null);
  const [cashflow_forecastHTMLs, setcashflow_forecastHTMLs] = useState<any>(null);
  const [costs_to_considerHTMLs, setcosts_to_considerHTMLs] = useState<any>(null);
  const [capital_requiredHTMLs, setcapital_requiredHTMLs] = useState<any>(null);

  useEffect(() => {
    setvisionHtml(visionHtmls);
    setRentalHtml(rentalHtmls);
    setproperty_descriptionHTML(property_descriptionHTMLs);
    setcashflow_forecastHTML(cashflow_forecastHTMLs);
    setcosts_to_considerHTML(costs_to_considerHTMLs);
    setcapital_requiredHTML(capital_requiredHTMLs);
    setlocationHTML(locationHTMLs);
  }, [
    setvisionHtml,
    setRentalHtml,
    setproperty_descriptionHTML,
    setcashflow_forecastHTML,
    setcosts_to_considerHTML,
    setcapital_requiredHTML,
    setlocationHTML,
    visionHtmls,
    rentalHtmls,
    property_descriptionHTMLs,
    cashflow_forecastHTMLs,
    costs_to_considerHTMLs,
    capital_requiredHTMLs,
    locationHTMLs,
  ]);
  return (
    <Box className="property-tabs" sx={{ width: '100%' }}>
      <Box sx={{ borderBottom: 0, borderColor: 'divider' }}>
        <Tabs
          className="property-tabs-contain"
          value={value}
          onChange={handleChange}
          aria-label="Property tabs"
        >
          <Tab label={translateAmenties('Location')} {...a11yProps(0)} />
          <Tab label={translateAmenties('Vision')} {...a11yProps(1)} />
          <Tab label={translateAmenties('Rental')} {...a11yProps(2)} />
          <Tab label={translateAmenties('Property Description')} {...a11yProps(3)} />
          <Tab label={translateAmenties('Cashflow Forecast')} {...a11yProps(4)} />
          <Tab label={translateAmenties('Cost To Consider')} {...a11yProps(5)} />
          <Tab label={translateAmenties('Capital Required')} {...a11yProps(6)} />
          {/* <Tooltip arrow title="one">
            {' '}
            <Tab value="one" label="Item One" />{' '}
          </Tooltip> */}
        </Tabs>
      </Box>
      <TabPanel value={value} index={0}>
        <div className="location-tab">
          <DraftInput html={locationHTMLs} setHtml={setlocationHTMLs} />
        </div>
      </TabPanel>
      <TabPanel value={value} index={1}>
        <div className="location-tab">
          <DraftInput html={visionHtmls} setHtml={setvisionHtmls} />
        </div>
      </TabPanel>
      <TabPanel value={value} index={2}>
        <div className="location-tab">
          <DraftInput html={rentalHtmls} setHtml={setrentalHtmls} />
        </div>
      </TabPanel>
      <TabPanel value={value} index={3}>
        <div className="location-tab">
          <DraftInput html={property_descriptionHTMLs} setHtml={setproperty_descriptionHTMLs} />
        </div>
      </TabPanel>
      <TabPanel value={value} index={4}>
        <div className="location-tab">
          <DraftInput html={cashflow_forecastHTMLs} setHtml={setcashflow_forecastHTMLs} />
        </div>
      </TabPanel>
      <TabPanel value={value} index={5}>
        <div className="location-tab">
          <DraftInput html={costs_to_considerHTMLs} setHtml={setcosts_to_considerHTMLs} />
        </div>
      </TabPanel>
      <TabPanel value={value} index={6}>
        <div className="location-tab">
          <DraftInput html={capital_requiredHTMLs} setHtml={setcapital_requiredHTMLs} />
        </div>
      </TabPanel>
    </Box>
  );
}
