import { GoogleMap, Marker } from '@react-google-maps/api';
import React, { useEffect, useState } from 'react';
import axiosmod from 'axios';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { ContentLayout } from '@/components/Layout';
import { Card } from '@/components/Elements/Card';
import * as z from 'zod';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import { Button, Spinner } from '@/components/Elements';
import { axios } from '@/lib/axios';
import { useNotificationStore } from '@/stores/notifications';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';
import { useNavigate, useParams } from 'react-router-dom';
import '../../map.css';
import plus from '@/assets/plus.png';
import { uploadImage } from '@/api/uploadImage';
import amanetiesCategory from '@/constants/amanetiesCategory';
import { MultiSelect } from 'react-multi-select-component';
import { useAuth } from '@/lib/auth';
import mainRentCategory from '@/constants/mainRentCategory';
import subRentCategory from '@/constants/subRentCategory';
import { getPropertyforRentDetails } from '@/api/propertyForRent/getPropertyforRentDetails';
import { PropertyforRent } from '@/types';
import EditSalePageLoader from '@/components/Elements/Loader/EditSalePageLoader';
import storage from '@/utils/storage';
import { useSelectFile } from '@/hooks/useSelectFile';
import FileViewer from '@/components/Viewer/FileViewer';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import StateComponent from '@/components/Elements/SelectState/StateComponent';
import CountryComponent from '@/components/Elements/SelectState/CountryComponent';
import CityComponent from '@/components/Elements/SelectState/CityComponent';
import { Country, State } from 'country-state-city';
import i18next from 'i18next';
import { translateAmenties } from '@/translations/translateFunction';

const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;

// -------------- google maps --------------------

function Map({
  location,
  addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

// ---------------google maps -------------------

const schema2 = z.object({
  title: z.string().min(1, 'Please enter short title'),
});
type CreateTitle = {
  title: string;
};

const schema = z.object({
  title: z.string().min(1, 'Please enter short title'),
  telephone: z.custom(isValidMobile, isValidMobileMsg),
  description: z.string().min(1, 'Please enter property description'),
  note: z.string().optional(),
  bedrooms: z.string().min(1, 'Please enter number of bedrooms'),
  bathrooms: z.string().min(1, 'Please enter number of bathrooms'),
  postal_code: z.string().min(1, 'Please enter postal code'),
  rented_out: z.string().min(1, 'Please enter rented out'),
  street_address: z.string().min(1, 'Please enter street address'),
  gross_area: z.string().optional(),
  use_area: z.string().optional(),
  floor: z.string().optional(),
  furnishing: z.string().min(1, 'Please select furnishing.'),
  prom: z.string().min(1, 'Please enter prom ID'),
  energy_rating: z.string().optional(),
  heating_grade: z.string().optional(),
  pets_allowed: z.string().min(1, 'Please select pets allowed'),
  rented_from: z.string().min(1, 'Please select rented from date'),
  rented_to: z.string().min(1, 'Please select rented from date'),
  monthly_rent: z.string().min(1, 'Please enter monthly rent').regex(/^\d+$/).transform(Number),
  deposit: z.string().optional(),
  included_in_rent: z.string().optional(),
  category: z.string().min(1, 'Please enter category'),
  sub_category: z.string().min(1, 'Please enter sub category'),
  security_money: z.string().min(1, 'Please enter security money'),
  country: z.string().optional(),
  city: z.string().optional(),
  state: z.string().optional(),
});

type rentValues = {
  title: string;
  category: string;
  sub_category: string;
  bedrooms: string;
  bathrooms: string;
  postal_code: string;
  street_address: string;
  rented_out: string;
  prom: string;
  gross_area: string;
  use_area: string;
  floor: string;
  furnishing: string;
  security_money: any;
  energy_rating: string;
  heating_grade: string;
  monthly_rent: any;
  deposit: any;
  pets_allowed: string;
  rented_from: string;
  rented_to: string;
  latitude: string;
  longitude: string;
  location: string;
  telephone: string;
  description: string;
  note: string;
  included_in_rent: string;
  facilites: string;
  is_draft: string;
  rent_id: any;
  image_data: any;
  city: string;
  country: string;
  state: string;
  rent_aggrement_documents: any;
};

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

export const AddPropertyRent = () => {
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();

  const [idd, setIdd] = useState('');
  const [user, setUser] = useState<PropertyforRent>();
  // eslint-disable-next-line react-hooks/exhaustive-deps

  const {
    file: pdfFile,
    preview: pdfPreview,
    handleChange: pdfhandleChange,
    pdfName,
  } = useSelectFile();

  const getDataOfApi = async () => {
    if (id != null) {
      setisLoader(true);
      const data = await getPropertyforRentDetails(id);
      const userIn = data?.data ?? ({} as PropertyforRent);
      setUser(userIn);
      setisLoader(false);
    }
  };

  useEffect(() => {
    auth.refetchUser();
    getDataOfApi();
  }, [id]);

  const [selected, setSelected] = useState([]);
  const facilites = selected.map(({ value }) => `${value}`).join(',');
  const auth = useAuth();
  const [userSubscribed, setuserSubscribed] = useState();
  useEffect(() => {
    auth.refetchUser();
    setuserSubscribed(auth.user?.has_subscription);
  }, [auth.user?.has_subscription]);
  const navigate = useNavigate();
  const [step, setStep] = useState(1);
  const [value, setValue] = useState(null);
  const [address, setAddress] = useState<string>('');
  const [loading, setLoading] = useState(false);
  // const inputFileRef = useRef<HTMLInputElement | null>(null);
  const [category, setmain_category] = useState('');
  const [sub_category, setSub_category] = useState('');
  const [is_draft, setis_draft] = useState<string>('False');
  const [title, settitle] = useState('');
  // const [category, setcategory] = useState('');
  const [latitude, setlatitude] = useState('1');
  const [longitude, setlongitude] = useState('1');
  const [addressValue, setAddressValue] = useState<string>('');
  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_label: '1',
    latitude: '2',
    longitude: '2',
  });

  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft('False');
    } else {
      setis_draft('True');
    }
  }, [auth?.user?.has_subscription]);
  useEffect(() => {
    if (id != null) {
      setStep(4);
    }
  }, [id]);

  const [options, setOption] = useState<any>();

  const [countryError, setCountryError] = useState<boolean>(false);
  const [stateError, setStateError] = useState<boolean>(false);
  const [cityError, setCityError] = useState<boolean>(false);

  const [selectedCountry, setSelectedCountry] = useState<any>(options?.country ?? '');
  const [selectedState, setSelectedState] = useState<any>(options?.state ?? '');
  const [selectedCity, setSelectedCity] = useState<any>(options?.city ?? '');

  const [selectedCountryIsoCode, setSelectedCountryIsoCode] = useState('');
  const [selectedStateIsoCode, setSelectedStateIsoCode] = useState('');

  const countryCode = Country.getAllCountries();

  useEffect(() => {
    countryCode.map((country) => {
      if (country?.name === selectedCountry) {
        setSelectedCountryIsoCode(country?.isoCode);
      }
    });
  }, [selectedCountry]);

  useEffect(() => {
    countryCode.map((country) => {
      if (country?.name === options?.country) {
        setSelectedCountryIsoCode(country?.isoCode);
      }
    });
  }, [options]);

  const stateCode = State.getStatesOfCountry(`${selectedCountryIsoCode}`);

  useEffect(() => {
    stateCode.map((state) => {
      if (state?.name === selectedState) {
        setSelectedStateIsoCode(state?.isoCode);
      }
    });
  }, [selectedState]);

  useEffect(() => {
    stateCode?.map((state) => {
      if (state?.name == options?.state) {
        setSelectedStateIsoCode(state?.isoCode);
      }
    });
  }, [options, stateCode]);

  const handleCountryChange = (value: any) => {
    setSelectedCountry(value);
    setCountryError(false);
  };

  const handleCityChange = (value: any) => {
    setSelectedCity(value);
    setCityError(false);
  };

  const handleStateChange = (value: any) => {
    setSelectedState(value);
    setStateError(false);
  };

  useEffect(() => {
    setlatitude(addressDetails?.latitude);
    setlongitude(addressDetails?.longitude);
    setAddressValue(addressDetails?.address_line);
  }, [addressDetails]);

  useEffect(() => {
    setlatitude(user?.latitude);
    setlongitude(user?.longitude);
  }, [user]);

  useEffect(() => {
    if (user && user.facilites) {
      const facilites = user.facilites.split(',');
      const selected = facilites.map((i) => {
        return {
          label: amanetiesCategory[i],
          value: i,
        };
      });
      setSelected(selected);
    }
  }, [user]);
  const addData = {
    editId: `${idd}`,
    pageUrl: `/user/add-property-for-rent/${idd}?type=RentProperty`,
  };
  storage.setSubmitFormData(addData);

  const { images, handleChange, uploaded, deleteImage, text, setText, load } =
    useSelectMultipleFile();

  const deleteImages = (val: any) => {
    const filteredItems = imageArray
      .slice(0, val)
      .concat(imageArray.slice(val + 1, imageArray.length));
    setImageArray(filteredItems);
  };

  const [isLoader, setisLoader] = useState<boolean>(false);
  const [imageArray, setImageArray] = useState<any>([]);
  useEffect(() => {
    if (user) {
      const previousImage = eval(user?.image_data);
      setImageArray(previousImage);
    }
  }, [user]);

  const handleText = (index: number, val: string) => {
    const textItems = [...text];
    textItems[index] = val;
    setText(textItems);
  };

  const handleSubmit2 = async (values: CreateTitle) => {
    setisLoader(true);
    settitle(values.title);
    setStep(2);
    setisLoader(false);
  };

  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  const step4Clicked = (title1: string) => {
    setSub_category(title1);
    setStep(4);
    const addOptions = {
      title: title ?? '',
      sub_category: title1,
      category: category ?? '',
    };

    setOption(addOptions);
    setisLoader(true);
    setTimeout(() => setisLoader(false), 0);
  };

  const convertValuesToLocalCurrency = async (values: any) => {
    const fieldsToConvert = [
      'monthly_rent',
      'included_in_rent',
      'security_money',
      'rented_out',
      'deposit',
    ];

    fieldsToConvert.forEach((field) => {
      values[field] /= localCurrency;
    });
  };

  useEffect(() => {
    if (id) {
      const editOptions = {
        ...user,
      };
      setOption(editOptions);
      setSub_category(user?.sub_category ?? '');
      setmain_category(user?.category ?? '');
    }
  }, [id, user]);
  const handleSubmit = async (values: rentValues) => {
    if (selectedCountry == '' && options?.country == '') {
      setCountryError(true);
    }
    if (selectedState == '' && options?.state == '') {
      setStateError(true);
    }
    // if (selectedCity == '') {
    //   setCityError(true);
    // }
    const newArray = uploaded.map(function (value, index) {
      return { image: value, name: text[index] };
    });
    let pdfUrl = '';
    if (pdfFile) {
      const response = await uploadImage({ file: pdfFile });
      pdfUrl = response.url;
    } else {
      pdfUrl = user?.rent_aggrement_documents ?? '';
    }
    const image_data = imageArray.concat(newArray);
    values.rent_id = id ?? '1';
    values.rent_aggrement_documents = pdfUrl;
    values.image_data = JSON.stringify(image_data);
    values.is_draft = is_draft;
    values.facilites = facilites;
    values.latitude = latitude;
    values.state = selectedState ? selectedState : options?.state;
    values.country = selectedCountry ? selectedCountry : options?.country;
    values.city = selectedCity ? selectedCity : options?.city;
    values.longitude = longitude;
    values.location = addressValue;
    await convertValuesToLocalCurrency(values);
    setLoading(true);
    id != null
      ? axios
          .post('/customer-api/edit-rent-property', values)
          .then(() => {
            setLoading(false);
            navigate('/user/my-listing');
            showSuccess();
            // navigate('/');
          })
          .catch(() => {
            setLoading(false);
          })
      : axios
          .post('/customer-api/add-rent-property', values)
          .then((response) => {
            setLoading(false);
            showSuccess();
            if (auth.user?.has_subscription == true) {
              setLoading(false);
              navigate('/property-for-rent');
            } else {
              setIdd(response?.data?.id);
              navigate('/user/subscription');
              setLoading(false);
            }
          })
          .catch(() => {
            setLoading(false);
          });
  };

  const showSuccess = () => {
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'success',
      message: 'Property for Rent submited successfully!',
    });
  };
  const [canAddMore, setcanAddMore] = useState(false);
  useEffect(() => {
    if (auth.user?.total_property_upload >= auth.user?.property_count) {
      setcanAddMore(true);
    }
  }, [auth?.user?.has_subscription]);

  return (
    <ContentLayout title="Property for Rent/Sale">
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <Form<CreateTitle, typeof schema2> onSubmit={handleSubmit2} schema={schema2}>
        {({ register, formState }) => (
          <>
            {step == 1 && (
              <div className="my-5 d-flex flex-column align-items-center">
                <div className="mt-3 row short-title-rw" style={{ width: '60%' }}>
                  <div className="col-12">
                    <Card shadow className="shadow-lg p-4">
                      <div className="d-flex flex-column align-items-center text-center">
                        <h1>
                          {translateAmenties(
                            'Enter a short title to describe your property for rent'
                          )}
                        </h1>
                        <h4>{translateAmenties('Make your title informative and attractive')}</h4>
                        <br />
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label="Short Title"
                          error={formState.errors['title']}
                          registration={register('title')}
                        />
                        <Button type="submit" variant="primary" size="md" className="mt-2 ">
                          Let&apos;s Go
                        </Button>
                      </div>
                    </Card>
                  </div>
                </div>
              </div>
            )}
          </>
        )}
      </Form>

      <div className="my-5 d-flex flex-column align-items-center">
        <div className="mt-3 row short-title-rw" style={{ width: '70%' }}>
          <div className="col-12">
            {isLoader ? (
              <EditSalePageLoader />
            ) : (
              <>
                <Card shadow className="shadow-lg p-4">
                  <Form<rentValues, typeof schema>
                    onSubmit={handleSubmit}
                    schema={schema}
                    options={{
                      defaultValues: {
                        ...options,
                        monthly_rent: (options?.monthly_rent * localCurrency)?.toString(),
                        security_money: (options?.security_money * localCurrency)?.toString(),
                        included_in_rent: (options?.included_in_rent * localCurrency)?.toString(),
                        bedrooms: options?.bedrooms?.toString(),
                        bathrooms: options?.bathrooms?.toString(),
                        deposit: (options?.deposit * localCurrency).toString(),
                        rented_out: (options?.rented_out * localCurrency).toString(),
                      },
                    }}
                  >
                    {({ register, formState }) => (
                      <>
                        {step == 2 && (
                          <div className="d-flex flex-column align-items-center text-center">
                            <h1>Enter a short title to describe your listing</h1>
                            <br />
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Residential_for_rent');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {translateAmenties('Residential for Rent')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Commercial_for_rent');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {translateAmenties('Commercial for rent')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Land_for_rent');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {translateAmenties('Land for rent')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Multiple_units_for_rent');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {translateAmenties('Multiple units for ren')} <div>&gt;</div>
                              </div>
                            </a>
                          </div>
                        )}
                        {step == 3 && (
                          <div className="d-flex flex-column align-items-center text-center">
                            <h1>
                              {translateAmenties('Now choose the right category for your listing')}
                            </h1>
                            <br />
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('apartment_for_rent')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Apartment/Flat for rent')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('villa_house_for_rent')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Villa/House for rent')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Townhouse')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Townhouse')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Penthouse')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Penthouse')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Residential_Building')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Residential Building')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Residential_Floor')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Residential Floor')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Villa_Compound')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Villa Compound')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Commercial_for_Rent')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Commercial for Rent')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Rooms_for_Rent')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Rooms for Rent')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Short_term_monthly')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                Short term &#40;Monthly&#41; <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Short_term_daily')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                Short term &#40;Daily&#41; <div>&gt;</div>
                              </div>
                            </a>
                          </div>
                        )}
                        {step == 4 && (
                          <div className="d-flex flex-column align-items-center text-center">
                            {id != null ? (
                              <>
                                <h1>Edit your Property</h1>
                              </>
                            ) : (
                              <>
                                <h1>You&lsquo;re almost there!</h1>
                                <h5>
                                  Include as much details and pictures as possible, and set the
                                  right price.
                                </h5>
                              </>
                            )}
                            <br />
                            <div className="row width-max">
                              <div className="col-12 col-md-12">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Short Title"
                                  error={formState.errors['title']}
                                  registration={register('title')}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Main Category')}
                                  error={formState.errors['category']}
                                  registration={register('category')}
                                  placeholder={i18next.t('Main Category')}
                                  options={Object.entries(mainRentCategory).map(([key, value]) => ({
                                    label: translateAmenties(value),
                                    value: key,
                                  }))}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Sub Category')}
                                  error={formState.errors['sub_category']}
                                  registration={register('sub_category')}
                                  placeholder={i18next.t('Sub Category')}
                                  options={Object.entries(subRentCategory)?.map(([key, value]) => ({
                                    label: translateAmenties(value),
                                    value: key,
                                  }))}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label={i18next.t('Postal Code')}
                                  error={formState.errors['postal_code']}
                                  registration={register('postal_code')}
                                  placeholder="Postal code"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label={`${i18next.t('Included in Rent')} ${localSymbol}`}
                                  error={formState.errors['included_in_rent']}
                                  registration={register('included_in_rent')}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <div className="docDiv">
                                  {/* <p className="headingUplod">Upload Doccuments here</p> */}
                                  <label htmlFor="fileInput">
                                    <div className="width-full">
                                      {pdfPreview ? null : (
                                        <>
                                          {user?.rent_aggrement_documents ? (
                                            <div className="pdfDiv">
                                              <FileViewer file={user?.rent_aggrement_documents} />
                                            </div>
                                          ) : null}
                                        </>
                                      )}

                                      {pdfPreview ? (
                                        <>
                                          {pdfName ? (
                                            <>
                                              <div className="files-box">
                                                <p>{pdfName}</p>
                                              </div>
                                            </>
                                          ) : (
                                            <>
                                              <div className="image-box">
                                                <img
                                                  src={pdfPreview}
                                                  alt=""
                                                  className="profileImage"
                                                />
                                              </div>
                                            </>
                                          )}
                                        </>
                                      ) : (
                                        <>
                                          {user?.rent_aggrement_documents ? (
                                            <div className="files-box">
                                              <p>Edit Doccument here .</p>
                                            </div>
                                          ) : (
                                            <div className="files-box">
                                              <img src={plus} alt="" width="60" />
                                            </div>
                                          )}
                                        </>
                                      )}
                                    </div>
                                  </label>
                                  <input
                                    accept="pdf/*"
                                    onChange={pdfhandleChange}
                                    type="file"
                                    id="fileInput"
                                    className="d-none"
                                  />
                                </div>
                              </div>
                              <div className="col-12 col-md-6 col-sm-6 mt-3">
                                {' '}
                                <InputPhone
                                  floating
                                  value={options?.telephone}
                                  error={formState.errors['telephone']}
                                  registration={register('telephone')}
                                />
                              </div>
                              <div className="col-12 col-md-12 mt-3">
                                <div className="selectedImagesDiv">
                                  <div className="row">
                                    {imageArray?.map((item: any, index: number) => (
                                      <div key={index} className="col-md-2 cross-pic">
                                        <div className="image-box">
                                          <button type="button" onClick={() => deleteImages(index)}>
                                            <i className="fa-solid fa-square-xmark pics"></i>
                                          </button>
                                          <img src={item.image} alt="..." />
                                        </div>
                                        {item.name && <h6 className="itemName">{item.name}</h6>}
                                      </div>
                                    ))}

                                    {images?.map((item: any, index: number) => (
                                      <div key={index} className="cross-pic">
                                        <div className="image-box">
                                          <button type="button" onClick={() => deleteImage(index)}>
                                            <i className="fa-solid fa-square-xmark pics"></i>
                                          </button>
                                          <img src={item} alt="..." />
                                        </div>
                                        <input
                                          type="text"
                                          id="imageName"
                                          name="imageName"
                                          placeholder="Image name"
                                          onChange={(e) => handleText(index, e.target.value)}
                                          value={text[index]}
                                        />
                                        {/* {item.name && <h6 className="itemName">{item.name}</h6>} */}
                                      </div>
                                    ))}

                                    <div className="col-md-2 col-12">
                                      <div className="padding-r">
                                        <label htmlFor="fileInput1">
                                          <div className="image-box">
                                            {load ? (
                                              <Spinner />
                                            ) : (
                                              <img src={plus} alt="" width="60" />
                                            )}
                                          </div>
                                        </label>
                                        <input
                                          accept="image/*"
                                          onChange={handleChange}
                                          multiple
                                          type="file"
                                          id="fileInput1"
                                          className="d-none"
                                        />
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <TextAreaField
                                  label="Describe your property"
                                  wrapperClass="w-full"
                                  error={formState.errors['description']}
                                  registration={register('description')}
                                ></TextAreaField>
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <TextAreaField
                                  label="Note for property"
                                  wrapperClass="w-full"
                                  error={formState.errors['note']}
                                  registration={register('note')}
                                ></TextAreaField>
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Property gross area sq.ft"
                                  error={formState.errors['gross_area']}
                                  registration={register('gross_area')}
                                  placeholder="Property gross area sq.ft ;"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Property use area sq.ft"
                                  error={formState.errors['use_area']}
                                  registration={register('use_area')}
                                  placeholder="Property use area sq.ft ;"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label={`${i18next.t('Monthly Rent')} ${localSymbol}`}
                                  error={formState.errors['monthly_rent']}
                                  registration={register('monthly_rent')}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label={`Security money  ${localSymbol}`}
                                  error={formState.errors['security_money']}
                                  registration={register('security_money')}
                                  placeholder="Security money &#8364;"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label={`${i18next.t('Rented Out')} ${localSymbol}`}
                                  error={formState.errors['rented_out']}
                                  registration={register('rented_out')}
                                  placeholder={`${i18next.t('Rented Out')} &#8364;`}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <div className="multiDiv">
                                  <MultiSelect
                                    options={Object.entries(amanetiesCategory).map(
                                      ([key, value]) => ({
                                        label: translateAmenties(value),
                                        value: key,
                                      })
                                    )}
                                    value={selected}
                                    onChange={setSelected}
                                    labelledBy="Select Amenaties."
                                  />
                                </div>
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Bedrooms')}
                                  error={formState.errors['bedrooms']}
                                  registration={register('bedrooms')}
                                  placeholder="3"
                                  options={[
                                    { label: 1, value: 1 },
                                    { label: 2, value: 2 },
                                    { label: 3, value: 3 },
                                    { label: 4, value: 4 },
                                    { label: 5, value: 5 },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label="Bathrooms"
                                  error={formState.errors['bathrooms']}
                                  registration={register('bathrooms')}
                                  placeholder="3"
                                  options={[
                                    { label: 1, value: 1 },
                                    { label: 2, value: 2 },
                                    { label: 3, value: 3 },
                                    { label: 4, value: 4 },
                                    { label: 5, value: 5 },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Pets allowed')}
                                  error={formState.errors['pets_allowed']}
                                  registration={register('pets_allowed')}
                                  placeholder="3"
                                  options={[
                                    { label: 'Yes', value: 'Yes' },
                                    { label: 'No', value: 'No' },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label="furnishing"
                                  error={formState.errors['furnishing']}
                                  registration={register('furnishing')}
                                  placeholder="3"
                                  options={[
                                    { label: 'Yes', value: 'Yes' },
                                    { label: 'No', value: 'No' },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Energy Rating')}
                                  error={formState.errors['energy_rating']}
                                  registration={register('energy_rating')}
                                  placeholder="3"
                                  options={[
                                    { label: 'A', value: 'A' },
                                    { label: 'B', value: 'B' },
                                    { label: 'C', value: 'C' },
                                    { label: 'D', value: 'D' },
                                    { label: 'E', value: 'E' },
                                    { label: 'F', value: 'F' },
                                    { label: 'G', value: 'G' },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Heating Grade')}
                                  error={formState.errors['heating_grade']}
                                  registration={register('heating_grade')}
                                  placeholder="3"
                                  options={[
                                    { label: 'A', value: 'A' },
                                    { label: 'B', value: 'B' },
                                    { label: 'C', value: 'C' },
                                    { label: 'D', value: 'D' },
                                    { label: 'E', value: 'E' },
                                    { label: 'F', value: 'F' },
                                    { label: 'G', value: 'G' },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label={i18next.t('Street address')}
                                  error={formState.errors['selectedCountryIsoCodestreet_address']}
                                  registration={register('street_address')}
                                  placeholder={i18next.t('Street address')}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="date"
                                  wrapperClass="w-full"
                                  label={`${i18next.t('Rented from')} [DD-MM-YYYY]`}
                                  error={formState.errors['rented_from']}
                                  registration={register('rented_from')}
                                  placeholder={`${i18next.t('Rented from')} [DD-MM-YYY]`}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="date"
                                  wrapperClass="w-full"
                                  label={`${i18next.t('Rented to')} [DD-MM-YYYY]`}
                                  error={formState.errors['rented_to']}
                                  registration={register('rented_to')}
                                  placeholder={`${i18next.t('Rented to')}  [DD-MM-YYY]`}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label="Prom Id "
                                  error={formState.errors['prom']}
                                  registration={register('prom')}
                                  placeholder="Prom Id "
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label={i18next.t('Floor')}
                                  error={formState.errors['floor']}
                                  registration={register('floor')}
                                  placeholder="AMRA9812"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="number"
                                  wrapperClass="w-full"
                                  label={`Deposit Fee ${localSymbol}`}
                                  error={formState.errors['deposit']}
                                  registration={register('deposit')}
                                  placeholder="Deposit Fee &#8364;"
                                />
                              </div>
                            </div>

                            <div className="row width-max contBtm">
                              <div className="col-12 col-md-4 col-sm-4">
                                <p className="locHeading">{i18next.t('Country')}</p>
                                <CountryComponent
                                  onCountryChange={handleCountryChange}
                                  defaultCountry={options?.country}
                                />
                                {countryError ? (
                                  <p
                                    style={{
                                      color: 'rgba(239, 68, 68, var(--tw-text-opacity))',
                                    }}
                                    className="font-semibold"
                                  >
                                    Please Select a country
                                  </p>
                                ) : null}
                              </div>
                              <div className="col-12 col-md-4 col-sm-4">
                                <p className="locHeading">State</p>
                                <StateComponent
                                  onStateChange={handleStateChange}
                                  defaultState={options?.state}
                                  selectedCountryVal={selectedCountryIsoCode}
                                />
                                {stateError ? (
                                  <p
                                    style={{
                                      color: 'rgba(239, 68, 68, var(--tw-text-opacity))',
                                    }}
                                    className="font-semibold"
                                  >
                                    Please Select a state
                                  </p>
                                ) : null}
                              </div>
                              <div className="col-12 col-md-4 col-sm-4">
                                <p className="locHeading">City</p>
                                <CityComponent
                                  onStateChange={handleCityChange}
                                  defaultState={options?.city}
                                  selectedStateVAl={selectedStateIsoCode}
                                  selectedCountryVal={selectedCountryIsoCode}
                                />
                                {cityError ? (
                                  <p
                                    style={{
                                      color: 'rgba(239, 68, 68, var(--tw-text-opacity))',
                                    }}
                                    className="font-semibold"
                                  >
                                    Please Select a city !
                                  </p>
                                ) : null}
                              </div>
                            </div>

                            <h5>Is the pin in the right location?</h5>
                            <br />
                            <div style={{ width: '100%' }}>
                              <div style={{ width: '100%', height: '80%' }}>
                                <Map
                                  location={location}
                                  setAddressDetails={setAddressDetails}
                                  addressDetails={addressDetails}
                                />
                              </div>
                            </div>
                            <br />
                            <div className="col-12">
                              <div className="pt-2 pb-2">
                                <GooglePlacesAutocomplete
                                  selectProps={{
                                    defaultInputValue: user?.location ? user?.location : '',
                                    value,
                                    onChange: handleChangeLocation,
                                  }}
                                />
                              </div>
                            </div>
                            <br />
                            <div className="d-flex justify-content-end mt-4">
                              {userSubscribed == true ? (
                                <>
                                  {canAddMore ? (
                                    <Button disabled className="disableSubmit">
                                      Reached Upload limit
                                    </Button>
                                  ) : (
                                    <Button
                                      isLoading={loading}
                                      type="submit"
                                      variant="primary"
                                      size="md"
                                      className="mt-2 w-full"
                                    >
                                      Submit
                                    </Button>
                                  )}
                                </>
                              ) : (
                                <>
                                  {' '}
                                  <Button
                                    isLoading={loading}
                                    type="submit"
                                    variant="primary"
                                    size="md"
                                    className="mt-2 w-full"
                                  >
                                    Subscribe
                                  </Button>
                                </>
                              )}
                            </div>
                          </div>
                        )}
                      </>
                    )}
                  </Form>
                </Card>
              </>
            )}
          </div>
        </div>
      </div>
    </ContentLayout>
  );
};
