import { GoogleMap, Marker } from '@react-google-maps/api';
import React, { useEffect, useState } from 'react';
import axiosmod from 'axios';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { ContentLayout } from '@/components/Layout';
import { Card } from '@/components/Elements/Card';
import * as z from 'zod';
import { State, Country } from 'country-state-city';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import { Button, Spinner } from '@/components/Elements';
import { axios } from '@/lib/axios';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate, useParams } from 'react-router-dom';
import '../../map.css';
import amanetiesCategory from '@/constants/amanetiesCategory';
import { MultiSelect } from 'react-multi-select-component';
import { useAuth } from '@/lib/auth';
import mainCategory from '@/constants/mainCategory';
import subCategory from '@/constants/subCategory';
import { getPropertyforSaleDetails } from '@/api/propertyForSale/getPropertyforSaleDetails';
import { Property } from '@/types';
import EditSalePageLoader from '@/components/Elements/Loader/EditSalePageLoader';
import storage from '@/utils/storage';
import plus from '@/assets/plus.png';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';
import StateComponent from '@/components/Elements/SelectState/StateComponent';
import CountryComponent from '@/components/Elements/SelectState/CountryComponent';
import CityComponent from '@/components/Elements/SelectState/CityComponent';
import { translateAmenties } from '@/translations/translateFunction';
import i18next from 'i18next';

const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;

// -------------- google maps ---------------sssss-----

function Map({
  location,
  addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

// ---------------google maps -------------------

const schema2 = z.object({
  title: z.string().min(1, 'Please enter short title'),
  // .max(10, 'Short title cannot exceed 10 words'),
});
type CreateTitle = {
  title: string;
};

const schema = z.object({
  youtube_url: z.string().optional(),
  title: z.string().min(1, 'Please enter short title'),
  phone_number: z.custom(isValidMobile, isValidMobileMsg),

  price: z
    .string()
    .min(1, 'Please enter price')
    .regex(/^[-0-9+]+$/, 'Please enter valid price')
    .regex(/^\d+$/)
    .transform(Number),
  description: z.string().min(1, 'Please enter title'),
  size: z.string().optional(),
  closing_fee: z.string().min(1, 'Please enter closing fee'),
  bedrooms: z.string().min(1, 'Please enter number of bedrooms'),
  bathrooms: z.string().min(1, 'Please enter number of bathrooms'),
  developer: z.string().optional(),
  ready_by: z.string().optional(),
  annual_community_fee: z.string().optional(),
  property_reference_id: z.string().optional(),
  buyer_transfer_fee: z.string().optional(),
  seller_transfer_fee: z.string().optional(),
  maintenance_fee: z.string().optional(),
  occupancy_status: z.string().optional(),
  landlord_name: z.string().optional(),
  title_deed_number: z.string().optional(),
  pre_registration_number: z.string().optional(),
  main_category: z.string().optional(),
  sub_category: z.string().optional(),
  city: z.string().optional(),
  state: z.string().optional(),
  country: z.string().optional(),
});

const newSchema = z.object({
  title: z.string().min(1, 'Please enter short title'),
  youtube_url: z.string().optional(),
  phone_number: z.custom(isValidMobile, isValidMobileMsg),

  price: z
    .string()
    .min(1, 'Please enter price')
    .regex(/^[-0-9+]+$/, 'Please enter valid price'),
  description: z.string().min(1, 'Please enter title'),
  size: z.string().min(1, 'Please enter property size'),
  closing_fee: z
    .string()
    .min(1, 'Please enter closing fee')
    .regex(/^[-0-9+]+$/, 'Please enter valid closing fee'),
  bedrooms: z.string().min(1, 'Please enter number of bedrooms'),
  bathrooms: z.string().min(1, 'Please enter number of bathrooms'),
  developer: z.string().optional(),
  ready_by: z.string().optional(),
  annual_community_fee: z.string().optional(),
  property_reference_id: z.string().optional(),
  buyer_transfer_fee: z.string().optional(),
  seller_transfer_fee: z.string().optional(),
  maintenance_fee: z.string().optional(),
  occupancy_status: z.string().optional(),
  building: z.string().optional(),
  neighbourhood: z.string().optional(),
  broker_id_number: z.string().optional(),
  lister_company_name: z.string().optional(),
  permit_number: z.string().optional(),
  agent_name: z.string().optional(),
  city: z.string().optional(),
  state: z.string().optional(),
  country: z.string().optional(),
});

type rentValues = {
  title: string;
  main_category: string;
  sub_category: string;
  youtube_url: string;
  phone_number: string;
  price: any;
  description: string;
  size: string;
  closing_fee: any;
  bedrooms: string;
  bathrooms: string;
  developer: string;
  ready_by: string;
  annual_community_fee: any;
  property_reference_id: string;
  buyer_transfer_fee: any;
  seller_transfer_fee: any;
  maintenance_fee: any;
  occupancy_status: string;
  amenities: string;
  user_is: string;
  building?: string;
  neighbourhood?: string;
  latitude: string;
  longitude: string;
  landlord_name?: string;
  pre_registration_number?: string;
  title_deed_number?: string;
  broker_id_number?: string;
  lister_company_name?: string;
  permit_number?: string;
  agent_name?: string;
  is_draft: string;
  sale_id: any;
  image_data: any;
  property_status: any;
  location: any;
  city: string;
  state: string;
  country: string;
};

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

export const AddRentSale = () => {
  const { id } = useParams();
  const [idd, setIdd] = useState('');
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const [user, setUser] = useState<Property>();
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const [options, setOption] = useState<any>();

  const getDataOfApi = async () => {
    if (id != null) {
      setisLoader(true);
      const data = await getPropertyforSaleDetails(id);
      const userIn = data?.data ?? ({} as Property);
      setUser(userIn);
      setisLoader(false);
    }
  };

  const convertValuesToLocalCurrency = async (values: any) => {
    const fieldsToConvert = [
      'price',
      'closing_fee',
      'annual_community_fee',
      'buyer_transfer_fee',
      'seller_transfer_fee',
      'maintenance_fee',
    ];

    fieldsToConvert.forEach((field) => {
      values[field] /= localCurrency;
    });
  };

  const [countryError, setCountryError] = useState<boolean>(false);
  const [stateError, setStateError] = useState<boolean>(false);
  const [cityError, setCityError] = useState<boolean>(false);

  const [selectedCountry, setSelectedCountry] = useState<any>(options?.country ?? '');
  const [selectedState, setSelectedState] = useState<any>(options?.state ?? '');
  const [selectedCity, setSelectedCity] = useState<any>(options?.city ?? '');

  const [selectedCountryIsoCode, setSelectedCountryIsoCode] = useState('');
  const [selectedStateIsoCode, setSelectedStateIsoCode] = useState('');

  const countryCode = Country.getAllCountries();

  useEffect(() => {
    countryCode.map((country) => {
      if (country?.name === selectedCountry) {
        setSelectedCountryIsoCode(country?.isoCode);
      }
    });
  }, [selectedCountry]);

  useEffect(() => {
    countryCode.map((country) => {
      if (country?.name === options?.country) {
        setSelectedCountryIsoCode(country?.isoCode);
      }
    });
  }, [countryCode, options]);

  const stateCode = State.getStatesOfCountry(`${selectedCountryIsoCode}`);

  useEffect(() => {
    stateCode.map((state) => {
      if (state?.name === selectedState) {
        setSelectedStateIsoCode(state?.isoCode);
      }
    });
  }, [selectedState]);

  useEffect(() => {
    stateCode?.map((state) => {
      if (state?.name == options?.state) {
        setSelectedStateIsoCode(state?.isoCode);
      }
    });
  }, [options, stateCode]);

  const handleCountryChange = (value: any) => {
    setSelectedCountry(value);
    setCountryError(false);
  };

  const handleCityChange = (value: any) => {
    setSelectedCity(value);
    setCityError(false);
  };

  const handleStateChange = (value: any) => {
    setSelectedState(value);
    setStateError(false);
  };

  useEffect(() => {
    auth.refetchUser();
    getDataOfApi();
  }, [id]);

  useEffect(() => {
    if (id != null) {
      setStep(4);
    }
  }, [id]);

  const [selected, setSelected] = useState([]);
  const amenities = selected.map(({ value }) => `${value}`).join(',');
  const auth = useAuth();
  const [userSubscribed, setuserSubscribed] = useState();

  useEffect(() => {
    auth.refetchUser();
    setuserSubscribed(auth.user?.has_subscription);
  }, [auth.user.has_subscription]);

  const navigate = useNavigate();
  const [step, setStep] = useState(1);
  const [value, setValue] = useState(null);
  const [address, setAddress] = useState<string>('');
  const [loading, setLoading] = useState(false);
  // const inputFileRef = useRef<HTMLInputElement | null>(null);
  const [main_category, setmain_category] = useState('');
  const [sub_category, setSub_category] = useState('');
  const [user_is, setUser_is] = useState<string>(`${user?.user_is}` ?? '');
  const [property_status, setproperty_status] = useState<string>('');
  const [is_draft, setis_draft] = useState<string>('False');

  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft('False');
    } else {
      setis_draft('True');
    }
  }, [auth?.user?.has_subscription]);

  useEffect(() => {
    if (user && user.amenities) {
      const amenities = user.amenities.split(',');
      const selected = amenities.map((i) => {
        return {
          label: amanetiesCategory[i],
          value: i,
        };
      });
      setSelected(selected);
    }
  }, [user]);

  const addData = {
    editId: `${idd}`,
    pageUrl: `/user/add-property-for-sale/${idd}?type=SaleProperty`,
  };
  storage.setSubmitFormData(addData);

  const [isLoader, setisLoader] = useState<boolean>(false);
  const [imageArray, setImageArray] = useState<any>([]);

  const { images, handleChange, uploaded, deleteImage, text, setText, load } =
    useSelectMultipleFile();

  const deleteImages = (val: any) => {
    const filteredItems = imageArray
      .slice(0, val)
      .concat(imageArray.slice(val + 1, imageArray.length));
    setImageArray(filteredItems);
  };

  useEffect(() => {
    if (user) {
      const previousImage = eval(user?.image_data);
      setImageArray(previousImage);
    }
  }, [user]);

  const handleText = (index: number, val: string) => {
    const textItems = [...text];
    textItems[index] = val;
    setText(textItems);
  };

  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_label: '1',
    latitude: '2',
    longitude: '2',
  });
  const [title, settitle] = useState('');
  // const [category, setcategory] = useState('');
  const [addressValue, setAddressValue] = useState<string>('');
  const [latitude, setlatitude] = useState('1');
  const [longitude, setlongitude] = useState('1');

  useEffect(() => {
    setlatitude(addressDetails?.latitude);
    setlongitude(addressDetails?.longitude);
    setAddressValue(addressDetails?.address_line);
  }, [addressDetails]);

  useEffect(() => {
    setlatitude(user?.latitude);
    setlongitude(user?.longitude);
  }, [user]);

  const handleSubmit2 = async (values: CreateTitle) => {
    setisLoader(true);
    settitle(values.title);
    setStep(2);
    setisLoader(false);
  };
  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;

    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  const step4Clicked = (title1: string) => {
    setSub_category(title1);
    setStep(4);
    const addOptions = {
      title: title ?? '',
      sub_category: title1,
      main_category: main_category ?? '',
    };

    setOption(addOptions);
    setisLoader(true);
    setTimeout(() => setisLoader(false), 0);
  };

  useEffect(() => {
    if (id) {
      const editOptions = {
        ...user,
      };
      setOption(editOptions);
    }
  }, [id, user]);

  const handleSubmit = async (values: rentValues) => {
    if (selectedCountry == '' && options?.country == '') {
      setCountryError(true);
    }
    if (selectedState == '' && options?.state == '') {
      setStateError(true);
    }
    // if (selectedCity == '') {
    //   setCityError(true);
    // }
    const newArray = uploaded.map(function (value, index) {
      return { image: value, name: text[index] };
    });
    await convertValuesToLocalCurrency(values);
    const image_data = imageArray.concat(newArray);
    values.state = selectedState;
    values.country = selectedCountry;
    values.city = selectedCity;
    values.sale_id = id ?? '1';
    values.image_data = JSON.stringify(image_data);
    values.is_draft = is_draft;
    values.property_status = property_status;
    values.user_is = user_is ?? values.user_is;
    values.amenities = amenities;
    values.latitude = latitude;
    values.longitude = longitude;
    values.location = address;
    values.broker_id_number ? values.broker_id_number : (values.broker_id_number = '');
    values.lister_company_name ? values.lister_company_name : (values.lister_company_name = '');
    values.permit_number ? values.permit_number : (values.permit_number = '');
    values.agent_name ? values.agent_name : (values.agent_name = '');
    values.pre_registration_number
      ? values.pre_registration_number
      : (values.pre_registration_number = '');
    values.landlord_name ? values.landlord_name : (values.landlord_name = '');
    values.title_deed_number ? values.title_deed_number : (values.title_deed_number = '');
    values.pre_registration_number
      ? values.pre_registration_number
      : (values.pre_registration_number = '');

    if (user_is == 'Landlord') {
      delete values.broker_id_number;
      delete values.lister_company_name;
      delete values.permit_number;
      delete values.agent_name;
      delete values.building;
      delete values.neighbourhood;
    }

    if (user_is == 'Agent') {
      delete values.landlord_name;
      delete values.title_deed_number;
      delete values.pre_registration_number;
    }

    setLoading(true);

    id != null
      ? axios
          .post('/customer-api/edit-sale-property', values)
          .then(() => {
            setLoading(false);
            navigate('/user/my-listing');
            showSuccess();
          })
          .catch(() => {
            setLoading(false);
          })
      : axios
          .post('/customer-api/add-sale-property', values)
          .then((response) => {
            setLoading(false);
            showSuccess();
            if (auth.user?.has_subscription == true) {
              setLoading(false);
              navigate('/property-for-sale');
            } else {
              setIdd(response?.data?.id);
              navigate('/user/subscription');
              setLoading(false);
            }
          })
          .catch(() => {
            setLoading(false);
          });
  };

  const showSuccess = () => {
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'success',
      message: 'Property Listing Added Successfully!',
    });
  };

  // eslint-disable-next-line react-hooks/exhaustive-deps
  // eslint-disable-next-line react-hooks/exhaustive-deps

  const [canAddMore, setcanAddMore] = useState(false);
  useEffect(() => {
    if (auth.user?.total_property_upload >= auth.user?.property_count) {
      setcanAddMore(true);
    }
  }, [auth?.user?.has_subscription]);

  return (
    <ContentLayout title="Property for Rent/Sale">
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <Form<CreateTitle, typeof schema2> onSubmit={handleSubmit2} schema={schema2}>
        {({ register, formState }) => (
          <>
            {step == 1 && (
              <div className="my-5 d-flex flex-column align-items-center">
                <div className="mt-3 row short-title-rw" style={{ width: '60%' }}>
                  <div className="col-12">
                    <Card shadow className="shadow-lg p-4">
                      <div className="d-flex flex-column align-items-center text-center">
                        <h1>Enter a short title to describe your property for sale</h1>
                        <h4>{translateAmenties('Make your title informative and attractive')}</h4>
                        <br />
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label="Short Title"
                          error={formState.errors['title']}
                          registration={register('title')}
                        />
                        <Button type="submit" variant="primary" size="md" className="mt-2 ">
                          Let&apos;s Go
                        </Button>
                      </div>
                    </Card>
                  </div>
                </div>
              </div>
            )}
          </>
        )}
      </Form>

      <div className="my-5 d-flex flex-column align-items-center rent-sale-add">
        <div className="mt-3 row short-title-rw" style={{ width: '70%' }}>
          <div className="col-12">
            {isLoader ? (
              <EditSalePageLoader />
            ) : (
              <>
                <Card shadow className="shadow-lg p-4">
                  <Form<rentValues, typeof schema>
                    onSubmit={handleSubmit}
                    schema={user_is === 'Landlord' ? schema : newSchema}
                    options={{
                      defaultValues: {
                        ...options,
                        price: options?.price?.toString(),
                        bedrooms: options?.bedrooms?.toString(),
                        bathrooms: options?.bathrooms?.toString(),
                        buyer_transfer_fee: options?.buyer_transfer_fee?.toString(),
                        seller_transfer_fee: options?.seller_transfer_fee?.toString(),
                        maintenance_fee: options?.maintenance_fee?.toString(),
                        // : options?.?.toString(),
                        // : options?.?.toString(),
                        // : options?.?.toString(),
                        annual_community_fee: options?.annual_community_fee?.toString(),
                      },
                    }}
                  >
                    {({ register, formState }) => (
                      <>
                        {step == 2 && (
                          <div className="d-flex flex-column align-items-center text-center">
                            <h1>Enter a short title to describe your listing</h1>
                            <br />
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Residential_for_sale');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                Residential for sale <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Commercial_for_sale');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                Commercial for sale <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Land_for_sale');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                Land for sale <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => {
                                setmain_category('Multiple_units_for_sale');
                                setStep(3);
                                setisLoader(true);
                                setTimeout(() => setisLoader(false), 0);
                              }}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Multiple Units for Sale')} <div>&gt;</div>
                              </div>
                            </a>
                          </div>
                        )}
                        {step == 3 && (
                          <div className="d-flex flex-column align-items-center text-center">
                            <h1>
                              {translateAmenties('Now choose the right category for your listing')}
                            </h1>
                            <br />
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('apartment_for_sale')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Apartment For Sale')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('villa_house_for_sale')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Villa/House for Sale')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Townhouse')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Townhouse')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Penthouse')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Penthouse')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Residential_Building')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Residential Building')}
                                <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Residential_Floor')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Residential Floor')}
                                <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Villa_Compound')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Villa Compound')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Commercial_for_Sale')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Commercial for Sale')} <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Land_for_Sale')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                Land for Sale <div>&gt;</div>
                              </div>
                            </a>
                            <a
                              className="w-full cursor-pointer mb-2"
                              role="presentation"
                              onClick={() => step4Clicked('Multiple_Units_for_Sale')}
                            >
                              <div className="flex justify-between p-4 border rounded">
                                {i18next.t('Multiple Units for Sale')}
                                <div>&gt;</div>
                              </div>
                            </a>
                          </div>
                        )}
                        {step == 4 && (
                          <div className="d-flex flex-column align-items-center text-center width-max">
                            {id != null ? (
                              <>
                                <h1>Edit your Property</h1>
                              </>
                            ) : (
                              <>
                                <h1>You&lsquo;re almost there!</h1>
                                <h5>
                                  Include as much details and pictures as possible, and set the
                                  right price.
                                </h5>
                              </>
                            )}
                            <br />

                            <div className="row width-max">
                              <div className="col-12">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Short Title"
                                  error={formState.errors['title']}
                                  registration={register('title')}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Main Category')}
                                  error={formState.errors['main_category']}
                                  registration={register('main_category')}
                                  placeholder={i18next.t('Main Category')}
                                  options={Object.entries(mainCategory).map(([key, value]) => ({
                                    label: value,
                                    value: key,
                                  }))}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Sub Category')}
                                  error={formState.errors['sub_category']}
                                  registration={register('sub_category')}
                                  placeholder={i18next.t('Sub Category')}
                                  options={Object.entries(subCategory).map(([key, value]) => ({
                                    label: value,
                                    value: key,
                                  }))}
                                />
                              </div>

                              <div className="col-12 col-md-12 col-sm-12">
                                <div className="selectedImagesDiv">
                                  <div className="row">
                                    {imageArray.map((item: any, index: number) => (
                                      <div key={index} className="col-md-2 cross-pic">
                                        <div className="image-box">
                                          <button type="button" onClick={() => deleteImages(index)}>
                                            <i className="fa-solid fa-square-xmark pics"></i>
                                          </button>
                                          <img src={item.image} alt="..." />
                                        </div>
                                        {item.name && <h6 className="itemName">{item.name}</h6>}
                                      </div>
                                    ))}

                                    {images.map((item: any, index: number) => (
                                      <div key={index} className="cross-pic">
                                        <div className="image-box">
                                          <button type="button" onClick={() => deleteImage(index)}>
                                            <i className="fa-solid fa-square-xmark pics"></i>
                                          </button>
                                          <img src={item} alt="..." />
                                        </div>
                                        <input
                                          type="text"
                                          id="imageName"
                                          name="imageName"
                                          placeholder="Image name"
                                          onChange={(e) => handleText(index, e.target.value)}
                                          value={text[index]}
                                        />
                                        {/* {item.name && <h6 className="itemName">{item.name}</h6>} */}
                                      </div>
                                    ))}

                                    <div className="col-md-2 col-12">
                                      <div className="padding-r">
                                        <label htmlFor="fileInput1">
                                          <div className="image-box">
                                            {load ? (
                                              <Spinner />
                                            ) : (
                                              <img src={plus} alt="" width="60" />
                                            )}
                                          </div>
                                        </label>
                                        <input
                                          accept="image/*"
                                          onChange={handleChange}
                                          multiple
                                          type="file"
                                          id="fileInput1"
                                          className="d-none"
                                        />
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>

                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Youtube URL"
                                  error={formState.errors['youtube_url']}
                                  registration={register('youtube_url')}
                                  placeholder="http://youtube.com/xHdgahjbsfbn"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                <InputPhone
                                  floating
                                  value={options?.phone_number}
                                  error={formState.errors['phone_number']}
                                  registration={register('phone_number')}
                                />
                              </div>

                              <div className="col-12 col-md-6 col-sm-6">
                                <InputField
                                  type="float"
                                  wrapperClass="w-full"
                                  label={`${i18next.t('Price')} ${localSymbol}`}
                                  error={formState.errors['price']}
                                  registration={register('price')}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Property dimension sq.ft"
                                  error={formState.errors['size']}
                                  registration={register('size')}
                                  placeholder="Property dimension sq.ft ;"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="float"
                                  wrapperClass="w-full"
                                  label={`${i18next.t('Closing Fee')} ${localSymbol}`}
                                  error={formState.errors['closing_fee']}
                                  registration={register('closing_fee')}
                                  placeholder={`${i18next.t('Closing Fee')} &#8364`}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="float"
                                  wrapperClass="w-full"
                                  label={`Annual community Fee ${localSymbol}`}
                                  error={formState.errors['annual_community_fee']}
                                  registration={register('annual_community_fee')}
                                  placeholder={`${i18next.t('Annual community fee')} &#8364;`}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <SelectField
                                  wrapperClass="w-full"
                                  label={i18next.t('Bedrooms')}
                                  error={formState.errors['bedrooms']}
                                  registration={register('bedrooms')}
                                  placeholder="3"
                                  options={[
                                    { label: 1, value: 1 },
                                    { label: 2, value: 2 },
                                    { label: 3, value: 3 },
                                    { label: 4, value: 4 },
                                    { label: 5, value: 5 },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <SelectField
                                  wrapperClass="w-full"
                                  label="Bathrooms"
                                  error={formState.errors['bathrooms']}
                                  registration={register('bathrooms')}
                                  placeholder="3"
                                  options={[
                                    { label: 1, value: 1 },
                                    { label: 2, value: 2 },
                                    { label: 3, value: 3 },
                                    { label: 4, value: 4 },
                                    { label: 5, value: 5 },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="float"
                                  wrapperClass="w-full"
                                  label={`Buyer Transfer Fee ${localSymbol}`}
                                  error={formState.errors['buyer_transfer_fee']}
                                  registration={register('buyer_transfer_fee')}
                                  placeholder="Buyer Transfer Fee &#8364;"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="float"
                                  wrapperClass="w-full"
                                  label={`Seller Transfer Fee ${localSymbol}`}
                                  error={formState.errors['seller_transfer_fee']}
                                  registration={register('seller_transfer_fee')}
                                  placeholder="Seller Transfer Fee &#8364;"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="float"
                                  wrapperClass="w-full"
                                  label={`Maintenance Fee ${localSymbol}`}
                                  error={formState.errors['maintenance_fee']}
                                  registration={register('maintenance_fee')}
                                  placeholder="Maintenance Fee &#8364;"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Property reference ID"
                                  error={formState.errors['property_reference_id']}
                                  registration={register('property_reference_id')}
                                  placeholder="AMRA9812"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="text"
                                  wrapperClass="w-full"
                                  label="Developer"
                                  error={formState.errors['developer']}
                                  registration={register('developer')}
                                  placeholder="Developer"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <InputField
                                  type="date"
                                  wrapperClass="w-full"
                                  label="Select Date  "
                                  error={formState.errors['ready_by']}
                                  registration={register('ready_by')}
                                  placeholder="Ready by [DD-MM-YYY]"
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <SelectField
                                  wrapperClass="w-full"
                                  label="Occupancy Status"
                                  error={formState.errors['occupancy_status']}
                                  registration={register('occupancy_status')}
                                  placeholder="3"
                                  options={[
                                    { label: 'Available', value: 'Available' },
                                    { label: 'Unavailable', value: 'Unavailable' },
                                  ]}
                                />
                              </div>
                              <div className="col-12 col-md-6 col-sm-6">
                                {' '}
                                <div className="multiDiv">
                                  <MultiSelect
                                    options={Object.entries(amanetiesCategory).map(
                                      ([key, value]) => ({
                                        label: value,
                                        value: key,
                                      })
                                    )}
                                    value={selected}
                                    onChange={setSelected}
                                    labelledBy="Select Amenaties."
                                  />
                                </div>
                              </div>
                              <div className="col-12 col-md-6 col-sm-6"></div>
                              <div className="col-12 col-md-6 col-sm-6"></div>
                              <div className="col-12 col-md-6 col-sm-6"></div>
                              <div className="col-12 col-md-6 col-sm-6"></div>
                            </div>

                            <br />
                            <h5>Are you a Landlord or an Agent?</h5>
                            <br />
                            <div className="flex gap-2 w-full">
                              <Button
                                variant={user_is == 'Landlord' ? 'primary' : 'outline'}
                                size="md"
                                className="mt-2 w-full"
                                onClick={() => setUser_is('Landlord')}
                              >
                                Landlord
                              </Button>
                              <Button
                                variant={user_is == 'Agent' ? 'primary' : 'outline'}
                                size="md"
                                className="mt-2 w-full"
                                onClick={() => setUser_is('Agent')}
                              >
                                Agent
                              </Button>
                            </div>

                            {user_is == 'Landlord' ? (
                              <>
                                <div className="landloardDiv">
                                  <InputField
                                    type="text"
                                    wrapperClass="w-full"
                                    label="Landloard name"
                                    error={formState.errors['landlord_name']}
                                    registration={register('landlord_name')}
                                    placeholder="Ultron"
                                  />
                                  <div className="flex gap-2 w-full">
                                    <Button
                                      variant={
                                        property_status == 'Complete' ? 'primary' : 'outline'
                                      }
                                      size="md"
                                      className="mt-2 w-full"
                                      onClick={() => setproperty_status('Complete')}
                                    >
                                      Property Complete
                                    </Button>
                                    <Button
                                      variant={
                                        property_status == 'Incomplete' ? 'primary' : 'outline'
                                      }
                                      size="md"
                                      className="mt-2 w-full"
                                      onClick={() => setproperty_status('Incomplete')}
                                    >
                                      Property Incomplete
                                    </Button>
                                  </div>
                                  {property_status == 'Complete' ? (
                                    <>
                                      <br />
                                      <InputField
                                        type="text"
                                        wrapperClass="w-full"
                                        label="Title deed number"
                                        error={formState.errors['title_deed_number']}
                                        registration={register('title_deed_number')}
                                        placeholder="Ultron"
                                      />
                                    </>
                                  ) : null}
                                  {property_status == 'Incomplete' ? (
                                    <>
                                      <br />
                                      <InputField
                                        type="text"
                                        wrapperClass="w-full"
                                        label="Pre Registration Number"
                                        error={formState.errors['pre_registration_number']}
                                        registration={register('pre_registration_number')}
                                        placeholder="Ultron"
                                      />
                                    </>
                                  ) : null}
                                </div>
                              </>
                            ) : null}
                            {user_is == 'Agent' ? (
                              <>
                                <div className="landloardDiv">
                                  <div className="row width-max">
                                    <div className="col-12 col-md-6 col-sm-6">
                                      {' '}
                                      <InputField
                                        type="number"
                                        wrapperClass="w-full"
                                        label="Broker id number"
                                        error={formState.errors['broker_id_number']}
                                        registration={register('broker_id_number')}
                                        placeholder={i18next.t('Building')}
                                      />
                                    </div>
                                    <div className="col-12 col-md-6 col-sm-6">
                                      {' '}
                                      <InputField
                                        type="text"
                                        wrapperClass="w-full"
                                        label="Lister company name"
                                        error={formState.errors['lister_company_name']}
                                        registration={register('lister_company_name')}
                                        placeholder={i18next.t('Building')}
                                      />
                                    </div>

                                    <div className="col-12 col-md-6 col-sm-6">
                                      {' '}
                                      <InputField
                                        type="text"
                                        wrapperClass="w-full"
                                        label="Permit number"
                                        error={formState.errors['permit_number']}
                                        registration={register('permit_number')}
                                        placeholder={i18next.t('Building')}
                                      />
                                    </div>
                                    <div className="col-12 col-md-6 col-sm-6">
                                      {' '}
                                      <InputField
                                        type="text"
                                        wrapperClass="w-full"
                                        label="Agent name"
                                        error={formState.errors['agent_name']}
                                        registration={register('agent_name')}
                                        placeholder={i18next.t('Building')}
                                      />
                                    </div>

                                    <div className="col-12 col-md-6 col-sm-6">
                                      {' '}
                                      <InputField
                                        type="text"
                                        wrapperClass="w-full"
                                        label={i18next.t('Building')}
                                        error={formState.errors['building']}
                                        registration={register('building')}
                                        placeholder={i18next.t('Building')}
                                      />
                                    </div>
                                    <div className="col-12 col-md-6 col-sm-6">
                                      {' '}
                                      <InputField
                                        type="text"
                                        wrapperClass="w-full"
                                        label={i18next.t('Neighbourhood')}
                                        error={formState.errors['neighbourhood']}
                                        registration={register('neighbourhood')}
                                        placeholder={i18next.t('Neighbourhood')}
                                      />
                                    </div>
                                  </div>
                                </div>
                              </>
                            ) : null}
                            <br />
                            <div className="col-12">
                              <TextAreaField
                                label="Describe your property"
                                wrapperClass="w-full"
                                error={formState.errors['description']}
                                registration={register('description')}
                              ></TextAreaField>
                            </div>

                            <div className="row width-max contBtm">
                              <div className="col-12 col-md-4 col-sm-4">
                                <p className="locHeading">{i18next.t('Country')}</p>
                                <CountryComponent
                                  onCountryChange={handleCountryChange}
                                  defaultCountry={options?.country}
                                />
                                {countryError ? (
                                  <p
                                    style={{
                                      color: 'rgba(239, 68, 68, var(--tw-text-opacity))',
                                    }}
                                    className="font-semibold"
                                  >
                                    Please Select a country
                                  </p>
                                ) : null}
                              </div>
                              <div className="col-12 col-md-4 col-sm-4">
                                <p className="locHeading">State</p>
                                <StateComponent
                                  onStateChange={handleStateChange}
                                  defaultState={options?.state}
                                  selectedCountryVal={selectedCountryIsoCode}
                                />
                                {stateError ? (
                                  <p
                                    style={{
                                      color: 'rgba(239, 68, 68, var(--tw-text-opacity))',
                                    }}
                                    className="font-semibold"
                                  >
                                    Please Select a state
                                  </p>
                                ) : null}
                              </div>
                              <div className="col-12 col-md-4 col-sm-4">
                                <p className="locHeading">City</p>
                                <CityComponent
                                  onStateChange={handleCityChange}
                                  defaultState={options?.city}
                                  selectedStateVAl={selectedStateIsoCode}
                                  selectedCountryVal={selectedCountryIsoCode}
                                />
                                {cityError ? (
                                  <p
                                    style={{
                                      color: 'rgba(239, 68, 68, var(--tw-text-opacity))',
                                    }}
                                    className="font-semibold"
                                  >
                                    Please Select a city !
                                  </p>
                                ) : null}
                              </div>
                            </div>
                            <div className="col-12" style={{ width: '100%' }}>
                              <div style={{ width: '100%', height: '80%' }}>
                                <Map
                                  location={location}
                                  setAddressDetails={setAddressDetails}
                                  addressDetails={addressDetails}
                                />
                              </div>
                            </div>
                            <div className="col-12">
                              <div className="pt-2 pb-2">
                                <GooglePlacesAutocomplete
                                  selectProps={{
                                    defaultInputValue: user?.location ? user?.location : '',
                                    value,
                                    onChange: handleChangeLocation,
                                  }}
                                />
                              </div>
                            </div>
                            <br />
                            {/* <Button
                              isLoading={loading}
                              type="submit"
                              variant="primary"
                              size="md"
                              className="mt-2 w-full"
                            >
                              Submit
                            </Button> */}

                            <div className="d-flex justify-content-end mt-4">
                              {userSubscribed == true ? (
                                <>
                                  {' '}
                                  {canAddMore ? (
                                    <Button disabled className="disableSubmit">
                                      Reached Upload limit
                                    </Button>
                                  ) : (
                                    <Button
                                      isLoading={loading}
                                      type="submit"
                                      variant="primary"
                                      size="md"
                                      className="mt-2 w-full"
                                    >
                                      Submit
                                    </Button>
                                  )}
                                </>
                              ) : (
                                <>
                                  <Button
                                    isLoading={loading}
                                    type="submit"
                                    variant="primary"
                                    size="md"
                                    className="mt-2 w-full"
                                  >
                                    Subscribe
                                  </Button>
                                </>
                              )}
                            </div>
                          </div>
                        )}
                      </>
                    )}
                  </Form>
                </Card>
              </>
            )}
          </div>
        </div>
      </div>
    </ContentLayout>
  );
};
