import { GoogleMap, Marker } from '@react-google-maps/api';
import React, { useEffect, useRef, useState } from 'react';
import axiosmod from 'axios';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { ContentLayout } from '@/components/Layout';
import { Card } from '@/components/Elements/Card';
import * as z from 'zod';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import { Button } from '@/components/Elements';
import { axios } from '@/lib/axios';
import { useNotificationStore } from '@/stores/notifications';
import { useSelectFile } from '@/hooks/useSelectFile';
import { useNavigate, useParams } from 'react-router-dom';
import '../../map.css';
import { usePropertyForSaleDetails } from '@/api/propertyForSale/getPropertyforSaleDetails';
// import plus from '@/assets/plus.png';
import amanetiesCategory from '@/constants/amanetiesCategory';
import { MultiSelect } from 'react-multi-select-component';
import { useAuth } from '@/lib/auth';
import { uploadImage } from '@/api/uploadImage';
import { Property } from '@/types';
import EditPageLoader from '@/components/Elements/Loader/EditPageLoader';
import clsx from 'clsx';
import plus from '@/assets/plus.png';

import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import i18next from 'i18next';
const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;

// -------------- google maps --------------------

function Map({
  location,
  addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

// ---------------google maps -------------------

const schema = z.object({
  title: z.string().min(1, 'Please enter short title'),
  youtube_url: z.string().min(1, 'Please enter youtube url'),
  phone_number: z.custom(isValidMobile, isValidMobileMsg),

  price: z
    .string()
    .min(1, 'Please enter price')
    .regex(/^[-0-9+]+$/, 'Please enter valid price'),
  description: z.string().min(1, 'Please enter title'),
  size: z.string().min(1, 'Please enter property size'),
  closing_fee: z
    .string()
    .min(1, 'Please enter closing fee')
    .regex(/^[-0-9+]+$/, 'Please enter valid closing fee'),
  bedrooms: z.string().min(1, 'Please enter number of bedrooms'),
  bathrooms: z.string().min(1, 'Please enter number of bathrooms'),
  developer: z.string().min(1, 'Please enter developer reference'),
  ready_by: z.string().min(1, 'Please enter ready by reference'),
  annual_community_fee: z
    .string()
    .min(1, 'Please enter annual community fee')
    .regex(/^[-0-9+]+$/, 'Please enter annual community fee'),
  property_reference_id: z.string().min(1, 'Please enter reference ID'),
  buyer_transfer_fee: z
    .string()
    .min(1, 'Please enter buyer transfer fee')
    .regex(/^[-0-9+]+$/, 'Please enter buyer transfer fee'),
  seller_transfer_fee: z
    .string()
    .min(1, 'Please enter seller transfer fee')
    .regex(/^[-0-9+]+$/, 'Please enter seller transfer fee'),
  maintenance_fee: z
    .string()
    .min(1, 'Please enter maintenance fee')
    .regex(/^[-0-9+]+$/, 'Please enter valid maintenance fee'),
  occupancy_status: z.string().min(1, 'Please enter occupancy status'),
  // amenities: z.string().min(1, 'Please enter amenities'),
  building: z.string().min(1, 'Please enter building'),
  neighbourhood: z.string().min(1, 'Please enter neighbourhood'),
  // landlord_name: z.string(),
  // title_deed_number: z.string(),
  // pre_registration_number: z.string(),
  // broker_id_number: z.string(),
  // lister_company_name: z.string(),
  // permit_number: z.string(),
  // agent_name: z.string(),
});

const newSchema = z.object({
  title: z.string().min(1, 'Please enter short title'),
  youtube_url: z.string().min(1, 'Please enter youtube url'),
  phone_number: z.custom(isValidMobile, isValidMobileMsg),

  price: z
    .string()
    .min(1, 'Please enter price')
    .regex(/^[-0-9+]+$/, 'Please enter valid price'),
  description: z.string().min(1, 'Please enter title'),
  size: z.string().min(1, 'Please enter property size'),
  closing_fee: z
    .string()
    .min(1, 'Please enter closing fee')
    .regex(/^[-0-9+]+$/, 'Please enter valid closing fee'),
  bedrooms: z.string().min(1, 'Please enter number of bedrooms'),
  bathrooms: z.string().min(1, 'Please enter number of bathrooms'),
  developer: z.string().min(1, 'Please enter developer reference'),
  ready_by: z.string().min(1, 'Please enter ready by reference'),
  annual_community_fee: z
    .string()
    .min(1, 'Please enter annual community fee')
    .regex(/^[-0-9+]+$/, 'Please enter annual community fee'),
  property_reference_id: z.string().min(1, 'Please enter reference ID'),
  buyer_transfer_fee: z
    .string()
    .min(1, 'Please enter buyer transfer fee')
    .regex(/^[-0-9+]+$/, 'Please enter buyer transfer fee'),
  seller_transfer_fee: z
    .string()
    .min(1, 'Please enter seller transfer fee')
    .regex(/^[-0-9+]+$/, 'Please enter seller transfer fee'),
  maintenance_fee: z
    .string()
    .min(1, 'Please enter maintenance fee')
    .regex(/^[-0-9+]+$/, 'Please enter valid maintenance fee'),
  occupancy_status: z.string().min(1, 'Please enter occupancy status'),
});

type rentValues = {
  title: string;
  main_category: string;
  sub_category: string;
  youtube_url: string;
  phone_number: string;
  price: any;
  description: string;
  size: string;
  closing_fee: any;
  bedrooms: string;
  bathrooms: string;
  developer: string;
  ready_by: string;
  annual_community_fee: any;
  property_reference_id: string;
  buyer_transfer_fee: any;
  seller_transfer_fee: any;
  maintenance_fee: any;
  occupancy_status: string;
  amenities: string;
  user_is: string;
  building?: string;
  neighbourhood?: string;
  latitude: string;
  longitude: string;
  landlord_name?: string;
  pre_registration_number?: string;
  title_deed_number?: string;
  broker_id_number?: string;
  lister_company_name?: string;
  permit_number?: string;
  agent_name?: string;
  is_draft: string;
  image_data: any;
  property_status: any;
  sale_id: any;
};

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

export const EditPropertyForSale = () => {
  const { id } = useParams();
  const { data, isLoading, isRefetching } = usePropertyForSaleDetails({ id: id ?? '1' });
  const user = data?.data ?? ({} as Property);

  const [selected, setSelected] = useState<any>([]);
  const amenities = selected.map(({ value }) => `${value}`).join(',');
  const auth = useAuth();
  const navigate = useNavigate();
  const [value, setValue] = useState(null);
  const [address, setAddress] = useState<string>('');
  const [loading, setLoading] = useState(false);
  // const inputFileRef = useRef<HTMLInputElement | null>(null);
  const [main_cat, setmain_cat] = useState<string>('');
  const [sub_cat, setSub_cat] = useState<string>('');

  useEffect(() => {
    if (user && user?.main_category) {
      setmain_cat(`${user?.main_category}`);
    }
  }, [user]);
  useEffect(() => {
    if (user && user?.sub_category) {
      setSub_cat(`${user?.sub_category}`);
    }
  }, [user]);

  const [main_category, setmain_category] = useState<string>(main_cat);
  const [sub_category, setSub_category] = useState<string>(sub_cat);
  const [user_is, setUser_is] = useState<string>(`${user?.user_is}`);
  const [property_status, setproperty_status] = useState<string>(`${user?.property_status}`);
  const [is_draft, setis_draft] = useState<string>('False');

  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft('False');
    } else {
      setis_draft('True');
    }
  }, [auth?.user?.has_subscription]);
  const { file, preview, handleChange } = useSelectFile();
  const [imageName, setImageName] = useState('');
  const handleChangeName = (event) => {
    setImageName(event.target.value);
  };
  const [imageArray, setImageArray] = useState<any>([]);

  useEffect(() => {
    if (data) {
      const user = data?.data ?? ({} as Property);
      const previousImage = eval(user?.image_data);
      setImageArray(previousImage);
    }
    // if (user) {
    // }
  }, [data]);

  const updateImage = async () => {
    const arr: any[] = [...imageArray];
    let imageUrl = '';
    if (file) {
      const response = await uploadImage({ file });
      imageUrl = response.url;
    }
    arr.push({
      image: imageUrl,
      name: imageName,
    });
    setImageArray(arr);
    setImageName('');
  };

  const deleteImage = (val: any) => {
    const filteredItems = imageArray
      .slice(0, val)
      .concat(imageArray.slice(val + 1, imageArray.length));
    setImageArray(filteredItems);
  };

  const image_data = imageArray;

  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_label: '',
    latitude: '',
    longitude: '',
  });

  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  useEffect(() => {
    if (user && user.amenities) {
      const amenities = user.amenities.split(',');
      const selected = amenities.map((i) => {
        return {
          label: amanetiesCategory[i],
          value: i,
        };
      });
      setSelected(selected);
    }
  }, [user]);

  useEffect(() => {
    setlatitude(user?.latitude);
    setlongitude(user?.longitude);
  }, [user]);

  const handleSubmit = async (values: rentValues) => {
    values.image_data = JSON.stringify(image_data);
    values.property_status = property_status;
    values.sale_id = id ?? '1';
    values.main_category = main_category;
    values.sub_category = sub_category;
    values.is_draft = is_draft;
    values.user_is = user_is;
    values.amenities = amenities;
    // values.latitude', latitude);
    // values.longitude', longitude);

    setLoading(true);
    if (user_is == 'Landlord') {
      delete values.broker_id_number;
      delete values.lister_company_name;
      delete values.permit_number;
      delete values.agent_name;
      delete values.building;
      delete values.neighbourhood;
    }

    if (user_is == 'Agent') {
      delete values.landlord_name;
      delete values.title_deed_number;
      delete values.pre_registration_number;
    }
  };

  const showSuccess = () => {
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'success',
      message: 'Property Sale item edited Successfully!',
    });
  };

  // const changeClicked = () => {
  //   inputFileRef?.current?.click();
  // };

  return (
    <ContentLayout title="Property for Rent/Sale">
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      {isLoading || isRefetching ? (
        <EditPageLoader />
      ) : (
        <div className="my-5 d-flex flex-column align-items-center">
          <div className="mt-3 row short-title-rw" style={{ width: '50%' }}>
            <div className="col-12">
              <Card shadow className="shadow-lg p-4">
                <Form<rentValues, typeof schema>
                  onSubmit={handleSubmit}
                  options={{
                    defaultValues: user,
                  }}
                  schema={user_is == 'Landlord' ? newSchema : schema}
                >
                  {({ register, formState }) => (
                    <>
                      <div className="d-flex flex-column ">
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label="Short Title"
                          error={formState.errors['title']}
                          registration={register('title')}
                        />

                        <div className="d-flex flex-column full-widthdo">
                          <p>Enter a short title to describe your listing</p>
                          <br />
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              main_category == 'Residential for sale' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setmain_category('Residential for sale');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              Residential for sale <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              main_category == 'Commercial for sale' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setmain_category('Commercial for sale');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              Commercial for sale <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              main_category == 'Land for sale' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setmain_category('Land for sale');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              Land for sale <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              main_category == 'Multiple units for sale' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setmain_category('Multiple units for sale');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              {i18next.t('Multiple Units for Sale')} <div>&gt;</div>
                            </div>
                          </a>
                        </div>

                        <div className="d-flex flex-column  full-widthdo">
                          <p>
                            {translateAmenties('Now choose the right category for your listing')}
                          </p>
                          <br />
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              sub_category == 'Apartment for sale' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setSub_category('Apartment for sale');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              {i18next.t('Apartment For Sale')} <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              sub_category == 'Villa/House for sale' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setSub_category('Villa/House for sale');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              {i18next.t('Villa/House for Sale')} <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              sub_category == 'Townhouse' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setSub_category('Townhouse');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              {i18next.t('Townhouse')} <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              sub_category == 'Penthouse' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setSub_category('Penthouse');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              {i18next.t('Penthouse')} <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              sub_category == 'Residential Building' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setSub_category('Residential Building');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              Residential Building <div>&gt;</div>
                            </div>
                          </a>
                          <a
                            className={clsx(
                              'w-full cursor-pointer mb-2',
                              sub_category == 'Residential Floor' ? 'pinkBackground' : ''
                            )}
                            role="presentation"
                            onClick={() => {
                              setSub_category('Residential Floor');
                            }}
                          >
                            <div className="flex justify-between p-4 border rounded">
                              {i18next.t('Residential Floor')} <div>&gt;</div>
                            </div>
                          </a>
                        </div>
                        <div className="row">
                          {imageArray.map((item: any, index: number) => (
                            <div key={index} className="col-md-6 cross-pic">
                              <div className="image-box">
                                <button type="button" onClick={() => deleteImage(index)}>
                                  <i className="fa-solid fa-square-xmark pics"></i>
                                </button>
                                <img src={item.image} alt="..." />
                              </div>
                              <h6 className="itemName">{item.name}</h6>
                            </div>
                          ))}
                        </div>
                        <div className="row">
                          <div>
                            <div className="padding-r">
                              <label htmlFor="fileInput1">
                                <div className="image-box">
                                  {/* {preview ? setIsPic('1') : null} */}
                                  {/* {preview && isPic ? ( */}
                                  {preview ? (
                                    <img src={preview} alt="" className="profileImage" />
                                  ) : (
                                    <img src={plus} alt="" width="60" />
                                  )}
                                </div>
                              </label>
                              <input
                                accept="image/*"
                                onChange={handleChange}
                                type="file"
                                id="fileInput1"
                                className="d-none"
                              />
                            </div>

                            <input
                              type="text"
                              id="imageName"
                              name="imageName"
                              onChange={handleChangeName}
                              value={imageName}
                            />
                            <Button onClick={updateImage}>Confirm</Button>
                          </div>
                        </div>

                        <br />
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label="Youtube URL"
                          error={formState.errors['youtube_url']}
                          registration={register('youtube_url')}
                          placeholder="http://youtube.com/xHdgahjbsfbn"
                        />

                        <InputPhone
                          floating
                          error={formState.errors['phone_number']}
                          registration={register('phone_number')}
                        />

                        <InputField
                          type="number"
                          wrapperClass="w-full"
                          label={i18next.t('Price')}
                          error={formState.errors['price']}
                          registration={register('price')}
                          placeholder="8000"
                        />
                        <TextAreaField
                          label="Describe your property"
                          wrapperClass="w-full"
                          error={formState.errors['description']}
                          registration={register('description')}
                        ></TextAreaField>
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label="Size"
                          error={formState.errors['size']}
                          registration={register('size')}
                          placeholder="10*10"
                        />
                        <InputField
                          type="number"
                          wrapperClass="w-full"
                          label={i18next.t('Closing Fee')}
                          error={formState.errors['closing_fee']}
                          registration={register('closing_fee')}
                          placeholder="6000"
                        />
                        <SelectField
                          wrapperClass="w-full"
                          label={i18next.t('Bedrooms')}
                          error={formState.errors['bedrooms']}
                          registration={register('bedrooms')}
                          placeholder="3"
                          options={[
                            { label: 1, value: 1 },
                            { label: 2, value: 2 },
                            { label: 3, value: 3 },
                            { label: 4, value: 4 },
                            { label: 5, value: 5 },
                          ]}
                        />
                        <SelectField
                          wrapperClass="w-full"
                          label="Bathrooms"
                          error={formState.errors['bathrooms']}
                          registration={register('bathrooms')}
                          placeholder="3"
                          options={[
                            { label: 1, value: 1 },
                            { label: 2, value: 2 },
                            { label: 3, value: 3 },
                            { label: 4, value: 4 },
                            { label: 5, value: 5 },
                          ]}
                        />
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label="Developer"
                          error={formState.errors['developer']}
                          registration={register('developer')}
                          placeholder="Developer"
                        />
                        <InputField
                          type="date"
                          wrapperClass="w-full"
                          label="Ready by [YYYY-MM-DD]"
                          error={formState.errors['ready_by']}
                          registration={register('ready_by')}
                          placeholder="Ready by [YYYY-MM-DD]"
                        />
                        <InputField
                          type="number"
                          wrapperClass="w-full"
                          label="Annual community Fee"
                          error={formState.errors['annual_community_fee']}
                          registration={register('annual_community_fee')}
                          placeholder="1000"
                        />
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label="Property reference ID"
                          error={formState.errors['property_reference_id']}
                          registration={register('property_reference_id')}
                          placeholder="AMRA9812"
                        />
                        <InputField
                          type="number"
                          wrapperClass="w-full"
                          label="Buyer Transfer Fee"
                          error={formState.errors['buyer_transfer_fee']}
                          registration={register('buyer_transfer_fee')}
                          placeholder="1000"
                        />
                        <InputField
                          type="number"
                          wrapperClass="w-full"
                          label="Seller Transfer Fee"
                          error={formState.errors['seller_transfer_fee']}
                          registration={register('seller_transfer_fee')}
                          placeholder="1000"
                        />
                        <InputField
                          type="number"
                          wrapperClass="w-full"
                          label="Maintenance Fee"
                          error={formState.errors['maintenance_fee']}
                          registration={register('maintenance_fee')}
                          placeholder="1000"
                        />
                        <SelectField
                          wrapperClass="w-full"
                          label="Occupancy Status"
                          error={formState.errors['occupancy_status']}
                          registration={register('occupancy_status')}
                          placeholder="3"
                          options={[
                            { label: 'Available', value: 'Available' },
                            { label: 'Unavailable', value: 'Unavailable' },
                          ]}
                        />

                        <div className="multiDiv">
                          <MultiSelect
                            options={Object.entries(amanetiesCategory).map(([key, value]) => ({
                              label: value,
                              value: key,
                            }))}
                            value={selected}
                            onChange={setSelected}
                            labelledBy="Select Amenaties."
                          />
                        </div>
                        <br />
                        <h5>Are you a Landlord or an Agent?</h5>
                        <br />
                        <div className="flex gap-2 w-full">
                          <Button
                            variant={user_is == 'Landlord' ? 'primary' : 'outline'}
                            size="md"
                            className="mt-2 w-full"
                            onClick={() => setUser_is('Landlord')}
                          >
                            Landlord
                          </Button>
                          <Button
                            variant={user_is == 'Agent' ? 'primary' : 'outline'}
                            size="md"
                            className="mt-2 w-full"
                            onClick={() => setUser_is('Agent')}
                          >
                            Agent
                          </Button>
                        </div>

                        {user_is == 'Landlord' ? (
                          <>
                            <div className="landloardDiv">
                              <InputField
                                type="text"
                                wrapperClass="w-full"
                                label="Landloard name"
                                error={formState.errors['landlord_name']}
                                registration={register('landlord_name')}
                                placeholder="Ultron"
                              />
                              <div className="flex gap-2 w-full">
                                <Button
                                  variant={property_status == 'Complete' ? 'primary' : 'outline'}
                                  size="md"
                                  className="mt-2 w-full"
                                  onClick={() => setproperty_status('Complete')}
                                >
                                  Property Complete
                                </Button>
                                <Button
                                  variant={property_status == 'Incomplete' ? 'primary' : 'outline'}
                                  size="md"
                                  className="mt-2 w-full"
                                  onClick={() => setproperty_status('Incomplete')}
                                >
                                  Property Incomplete
                                </Button>
                              </div>
                              {property_status == 'Complete' ? (
                                <>
                                  <br />
                                  <InputField
                                    type="text"
                                    wrapperClass="w-full"
                                    label="Title deed number"
                                    error={formState.errors['title_deed_number']}
                                    registration={register('title_deed_number')}
                                    placeholder="Ultron"
                                  />
                                </>
                              ) : null}
                              {property_status == 'Incomplete' ? (
                                <>
                                  <br />
                                  <InputField
                                    type="text"
                                    wrapperClass="w-full"
                                    label="Pre Registration Number"
                                    error={formState.errors['pre_registration_number']}
                                    registration={register('pre_registration_number')}
                                    placeholder="Ultron"
                                  />
                                </>
                              ) : null}
                            </div>
                          </>
                        ) : null}
                        {user_is == 'Agent' ? (
                          <>
                            <div className="landloardDiv">
                              <InputField
                                type="number"
                                wrapperClass="w-full"
                                label="Broker id number"
                                error={formState.errors['broker_id_number']}
                                registration={register('broker_id_number')}
                                placeholder={i18next.t('Building')}
                              />
                              <InputField
                                type="text"
                                wrapperClass="w-full"
                                label="Lister company name"
                                error={formState.errors['lister_company_name']}
                                registration={register('lister_company_name')}
                                placeholder={i18next.t('Building')}
                              />
                              <InputField
                                type="text"
                                wrapperClass="w-full"
                                label="Permit number"
                                error={formState.errors['permit_number']}
                                registration={register('permit_number')}
                                placeholder={i18next.t('Building')}
                              />
                              <InputField
                                type="text"
                                wrapperClass="w-full"
                                label="Agent name"
                                error={formState.errors['agent_name']}
                                registration={register('agent_name')}
                                placeholder={i18next.t('Building')}
                              />
                            </div>
                          </>
                        ) : null}
                        <br />
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label={i18next.t('Building')}
                          error={formState.errors['building']}
                          registration={register('building')}
                          placeholder={i18next.t('Building')}
                        />
                        <InputField
                          type="text"
                          wrapperClass="w-full"
                          label={i18next.t('Neighbourhood')}
                          error={formState.errors['neighbourhood']}
                          registration={register('neighbourhood')}
                          placeholder={i18next.t('Neighbourhood')}
                        />
                        <br />
                        <h5>Is the pin in the right location?</h5>
                        <br />
                        <div style={{ width: '100%' }}>
                          <div style={{ width: '100%', height: '80%' }}>
                            <Map
                              location={location}
                              setAddressDetails={setAddressDetails}
                              addressDetails={addressDetails}
                            />
                          </div>
                        </div>
                        <br />
                        <div className="col-12">
                          <div className="pt-2 pb-2">
                            <GooglePlacesAutocomplete
                              selectProps={{
                                defaultInputValue: '',
                                value,
                                onChange: handleChangeLocation,
                              }}
                            />
                          </div>
                        </div>
                        <br />
                        <Button
                          isLoading={loading}
                          type="submit"
                          variant="primary"
                          size="md"
                          className="mt-2 w-full"
                        >
                          Submit
                        </Button>
                      </div>
                    </>
                  )}
                </Form>
              </Card>
            </div>
          </div>
        </div>
      )}
    </ContentLayout>
  );
};
