import React, { useState } from 'react';
import UserHeadBar from '../../components/UserHeadBar';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useNavigate, useParams } from 'react-router-dom';
import './ratings.css';
import * as z from 'zod';
import { Form, TextAreaField } from '@/components/Form';
import { Button } from '@/components/Elements';
import { postRating } from '../../api/postRating';

export type ReviewFormValues = {
  review_data: string;
  rating_data?: string;
  receive_customer_id?: string;
};

const schema = z.object({
  review_data: z.string().optional(),
});

export const Rating = () => {
  const { id } = useParams();
  const [btnLoad, setBtnLoad] = useState<boolean>(false);
  const [rating, setRating] = useState(0);
  const navigate = useNavigate();

  return (
    <>
      <UserHeadBar />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="container">
        <div className="row">
          <div className="col-12 col-md-12 mt-3">
            <h3>Give your Reviews</h3>
          </div>
        </div>

        <div className="w-full px-8 d-flex justify-content-center">
          <div className="bg-white mt-8 mb-8 py-8 px-8 shadow sm:rounded-lg sm:px-12 w-50 h-full">
            <Form<ReviewFormValues, typeof schema>
              onSubmit={async (values: ReviewFormValues) => {
                await postRating({
                  ...values,
                  rating_data: rating.toString(),
                  receive_customer_id: id,
                });
                setBtnLoad(false);
                navigate('/user/profile');
              }}
            >
              {({ register, formState }) => (
                <>
                  <div className="row">
                    <div className="col-6">
                      <h4>Ratings:</h4>
                    </div>
                    {rating === 0 ? (
                      <div className="col-6">
                        {[...new Array(5)].map((item, index) => {
                          index += 1;
                          return (
                            <>
                              <button type="button" key={index} onClick={() => setRating(index)}>
                                <i className="fa-regular fa-star item"></i>
                              </button>
                            </>
                          );
                        })}
                      </div>
                    ) : (
                      <div className="col-6">
                        {[...new Array(rating)].map((item, index) => {
                          index += 1;
                          return (
                            <>
                              <button type="button" key={index} onClick={() => setRating(index)}>
                                <i className="fa-solid fa-star item"></i>
                              </button>
                            </>
                          );
                        })}
                        {[...new Array(5 - rating)].map((item, index) => {
                          const newIndex = index + rating;
                          index = newIndex + 1;
                          return (
                            <>
                              <button type="button" key={index} onClick={() => setRating(index)}>
                                <i className="fa-regular fa-star item"></i>
                              </button>
                            </>
                          );
                        })}
                      </div>
                    )}
                  </div>

                  <div className="row mt-3">
                    <div className="col-6">
                      <h4>Reviews:</h4>
                    </div>

                    <div className="col-12 mt-3">
                      <TextAreaField
                        error={formState.errors['review_data']}
                        registration={register('review_data')}
                      />
                    </div>
                  </div>

                  <div>
                    <Button type="submit" isLoading={btnLoad}>
                      Submit
                    </Button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </>
  );
};
