import React, { useEffect, useState } from 'react';
import { ContentLayout } from '@/components/Layout';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { Button } from '@/components/Elements';
import '../user.css';
import { useSaveSearchListing } from '@/api/Search/saveSearchListing';
import { deleteSearch } from '@/api/Search/deleteSearch';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useNavigate } from 'react-router-dom';
import { ConfirmDialogWithButton } from '@/components/Elements/ConfirmationDialog/ConfirmDialogWithButton';
import { useNotificationStore } from '@/stores/notifications';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const SavedSearch = () => {
  const navigate = useNavigate();
  const [loading] = useState(false);
  const [load, setLoad] = useState(false);
  const { data: listing, isLoading, refetch } = useSaveSearchListing({ page: '1' });
  const deleteSelected = async (selected: any) => {
    try {
      setLoad(true);
      await deleteSearch(selected);
      refetch();
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'info',
        message: 'Search deleted successfully!',
      });
    } finally {
      setLoad(false);
    }
  };

  const [dRefetch, setDeleteRefetch] = useState<boolean>();

  useEffect(() => {
    refetch();
    setDeleteRefetch(false);
  }, [dRefetch, refetch]);
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  return (
    <ContentLayout title="My Listing">
      <BackdropLoader open={loading} />
      {/* <UserHeadBar /> */}
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="container listingContainer  saving-search">
        <div className="d-flex justify-content-between">
          <h3>My Saved Searches</h3>
        </div>
        <div className="row">
          {listing?.length == 0 ? (
            <h4 className="makeCenter">No Saved Searches Found!</h4>
          ) : (
            <>
              {isLoading ? (
                <MyListingLoader />
              ) : (
                <>
                  {listing?.map((item, index) => {
                    return (
                      <div className="savedItem col-md-6 col-sm-6 save-search" key={index}>
                        <div className="out-pay ">
                          <div className="pay-box row golf">
                            <div
                              className="col-md-10 posRel"
                              role="button"
                              onClick={() => navigate(`${item?.type_url}`)}
                            >
                              <div className="item-boxs">
                                <span className="crated-span">10 days ago.</span>
                                <h5>{item?.type}</h5>

                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-12 mb-0">Max Price</p>
                                  <p className="rightSd col-12 col-md-6 mb-0">
                                    {localSymbol}{' '}
                                    {(parseFloat(item?.max_price) * localCurrency)?.toFixed(0) ??
                                      ''}
                                  </p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-12 mb-0">
                                    {i18next.t('Location')}
                                  </p>
                                  <p className="rightSd col-12 col-md-6 mb-0">{item?.location}</p>
                                </div>
                              </div>
                            </div>
                            <div className="col-md-2 unsaveButtonDiv paymentBooks">
                              <ConfirmDialogWithButton
                                triggerButton={
                                  <button
                                    className="unsaveButton"
                                    onClick={(e) => {
                                      e.stopPropagation();
                                    }}
                                  >
                                    <i className="fa-solid fa-bookmark"></i>
                                  </button>
                                }
                                confirmButton={
                                  <Button
                                    isLoading={load}
                                    onClick={() => deleteSelected(item?.id)}
                                    variant="primary"
                                  >
                                    Sure
                                  </Button>
                                }
                                title="Confirm"
                                icon="info"
                                body="Are you sure you want to unsave this search."
                              />
                            </div>
                          </div>
                        </div>
                      </div>
                    );
                  })}
                </>
              )}
            </>
          )}
        </div>
      </div>
    </ContentLayout>
  );
};
