/* eslint-disable react/jsx-key */
import React, { useEffect, useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import './ViewAsOther.css';

import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';

import { Button, Image } from '@/components/Elements';

import { ContentLayout } from '@/components/Layout';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useNavigate } from 'react-router-dom';
import { useReviewRating } from '@/api/viewProfile/ReviewRating';
import { formatDateTime } from '@/utils/format';

export const AllReview = () => {
  const [loading] = useState(false);

  const searchParams = new URLSearchParams(document.location.search);
  const id = searchParams.get('id');

  const { data: review, isLoading, refetch } = useReviewRating({ id });
  // useEffect(() => {
  //   refetch();
  //   refetch2();
  // }, [id, saveSearch]);

  const reviewData = review?.rating_review_data;

  const navigate = useNavigate();
  return (
    <>
      <ContentLayout title="Home">
        <BackdropLoader open={loading} />
        <Header type={HeaderType.LANDING} />

        {isLoading ? (
          <MyListingLoader />
        ) : (
          <>
            <button onClick={() => navigate(-1)}>
              <i className="fa-regular fa-circle-left go-back-button"></i>
            </button>
            <div className="container">
              <div id="riviewList" className="riviewList">
                <div className="row">
                  <div className="col-md-6">
                    <h4 className="mt-2 mb-2">Review and Ratings</h4>
                  </div>
                  {/* <div className="col-md-6 hide">
                <Button onClick={() => setShowReview(false)}>Hide</Button>
              </div> */}

                  {reviewData?.length > 0 ? (
                    <>
                      {reviewData &&
                        reviewData?.map((item, index) => (
                          <div className="col-md-9 outerRiv" key={index}>
                            <div className="row innerRiv">
                              <div className="col-md-3">
                                <Image
                                  alt="banner"
                                  className="previewImage"
                                  src={item?.customer_image}
                                  width="100"
                                />
                              </div>
                              <div className="col-md-9">
                                <h6>{item?.customer_name} </h6>
                                <p>{item?.review}</p>
                                <p>
                                  <div className="ratings">
                                    {[...new Array(5)].map((arr, index) => {
                                      return index < item?.rating ? (
                                        <i className="fa-solid fa-star"></i>
                                      ) : (
                                        <i className="fa-regular fa-star"></i>
                                      );
                                    })}
                                  </div>
                                </p>
                                <p className="time">{formatDateTime(item?.rating_review_date)}</p>
                              </div>
                            </div>
                          </div>
                        ))}
                    </>
                  ) : (
                    <>
                      <h1>No rating and review added !</h1>
                    </>
                  )}
                </div>
              </div>
            </div>
          </>
        )}

        <Footer />
      </ContentLayout>
    </>
  );
};
