import React from 'react';
import OwlCarousel from 'react-owl-carousel';
import 'owl.carousel/dist/assets/owl.carousel.css';
import 'owl.carousel/dist/assets/owl.theme.default.css';
import './Carousel.css';
import item1 from '@/assets/item1.png';
import item2 from '@/assets/item2.png';
import item3 from '@/assets/item3.png';
import item4 from '@/assets/item4.png';
import item5 from '@/assets/item5.png';
import item7 from '@/assets/item7.png';
import item8 from '@/assets/item8.png';
import i18next from 'i18next';

function Carousel() {
  const options = {
    margin: 30,
    responsiveClass: true,
    nav: true,
    dots: false,
    autoplay: true,
    navText: ['<', '>'],
    smartSpeed: 1000,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 1,
      },
      600: {
        items: 1,
      },
      700: {
        items: 2,
      },
      1000: {
        items: 8,
      },
    },
  };
  return (
    <>
      <div className="container">
        <div className="landingCar">
          <OwlCarousel {...options} className="owl-theme" loop nav>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item1} />
                </span>

                <p>Rent To Rent</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item2} />
                </span>

                <p>Market Value</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item3} />
                </span>

                <p>Opportunities </p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item4} />
                </span>

                <p>{i18next.t('Properties')}</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item5} />
                </span>

                <p>Lease Option</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item7} />
                </span>

                <p>Hotel</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item8} />
                </span>

                <p>Retails</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item1} />
                </span>

                <p>Rent To Rent</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item2} />
                </span>

                <p>Market Value</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item3} />
                </span>

                <p>Opportunities </p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item4} />
                </span>

                <p>{i18next.t('Properties')}</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item5} />
                </span>

                <p>Lease Option</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item7} />
                </span>

                <p>Hotel</p>
              </div>
            </div>
            <div>
              <div className="item">
                <span>
                  {' '}
                  <img alt="hias" src={item8} />
                </span>

                <p>Retails</p>
              </div>
            </div>
          </OwlCarousel>
        </div>
      </div>
    </>
  );
}

export default Carousel;
