/* eslint-disable react/jsx-key */
import React, { useEffect, useState } from 'react';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import Footer from '@/components/Layout/Footer/Footer';
import './ViewAsOther.css';
import BreadCrumb from '@/components/Layout/BreadCrumb';
import ServiceItemList from '@/features/misc/routes/Landing/ServiceItemList';

import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useViewProfile } from '@/api/viewProfile/viewProfile';

import ServiceItem from '@/features/user/components/ServiceItem';
import { Button, Image } from '@/components/Elements';

import { ContentLayout } from '@/components/Layout';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useNavigate } from 'react-router-dom';
import { useReviewRating } from '@/api/viewProfile/ReviewRating';
import { formatDateTime } from '@/utils/format';

export const ViewAsOther = () => {
  const [loading] = useState(false);

  const searchParams = new URLSearchParams(document.location.search);
  const id = searchParams.get('id');
  const [object, setObject] = useState(null);
  const [saveSearch, setSaveSearch] = useState(false);
  const [showReview, setShowReview] = useState(false);

  const { data, isLoading, isFetching, refetch } = useViewProfile({
    id: id,
    min_price: '',
    max_price: '',
    location: '',
    type: '',
    amenities: '',
    filter_data: saveSearch,
    bedroom_min: '',
    bedroom_max: '',
    subscription_tyre: object?.subscriptionSort ? object?.subscriptionSort : '',
    sort_price: object?.priceSort,
  });

  const handleTwo = () => {
    setShowReview(!showReview);
  };

  useEffect(() => {
    handlegh();
  }, [handleTwo]);
  const handlegh = () => {
    const riviewListDiv = document.getElementById('riviewList');
    if (riviewListDiv) {
      riviewListDiv.scrollIntoView({ behavior: 'smooth' });
    }
  };

  const { data: review, isLoading: isLoading2, refetch: refetch2 } = useReviewRating({ id });
  // useEffect(() => {
  //   refetch();
  //   refetch2();
  // }, [id, saveSearch]);

  const [clear, setClear] = useState(false);
  const [sendObj, setSendObj] = useState({});
  const obj = {
    priceSort: object?.priceSort,
    subscriptionSort: object?.subscriptionSort,
    timeSort: object?.timeSort,
  };
  const objNew = {
    priceSort: '',
    subscriptionSort: '',
    timeSort: '',
  };
  useEffect(() => {
    refetch();
    refetch2();
    setSaveSearch(false);
    setSendObj(obj);
  }, [refetch, saveSearch]);

  useEffect(() => {
    setSaveSearch(false);
    setClear(false);
    refetch();
    setSendObj(objNew);
  }, [clear]);

  const user = data?.customer_all_data;
  const reviewData = review?.rating_review_data;
  const navigate = useNavigate();
  return (
    <>
      <ContentLayout title="Home">
        <BackdropLoader open={loading} />
        <Header type={HeaderType.LANDING} />

        {isLoading && isLoading2 ? null : (
          <>
            <button onClick={() => navigate(-1)}>
              <i className="fa-regular fa-circle-left go-back-button"></i>
            </button>
            <div className="container-fluid profileContainer">
              <div className="row">
                <div className="col-12 col-md-5 d-flex view-prf-mb">
                  <Image
                    alt="banner"
                    className="previewImage"
                    src={user?.profile_image}
                    width="100"
                  />
                  <div className="d-flex flex-column ms-5 mt-2 profl-lft">
                    <h5 className="mb-1">
                      <b>{`${user?.customer_name ?? ''} `} </b>
                    </h5>
                    <p className="mb-1">
                      <b>{`${user?.customer_email ?? ''}`} </b>
                    </p>
                    <p className="mb-1">{user?.email ?? ''}</p>
                    {/* <span>
                      <a className="textprimary" role="button">
                        Reviews : {data?.total_reviews === 0 ? 'N/A' : data?.total_reviews}
                      </a>{' '}
                      &nbsp; &nbsp; | &nbsp; &nbsp;
                      <a className="textprimary" role="button">
                        Ratings : {data?.average_rating === null ? 'N/A' : data?.average_rating}
                      </a>{' '}
                    </span> */}
                    <span>
                      {data?.total_reviews === 0 ? (
                        <a className="textprimary" role="button">
                          Reviews : N/A
                        </a>
                      ) : (
                        <a className="textprimary" role="button" onClick={() => handleTwo()}>
                          Reviews : {data?.total_reviews}
                        </a>
                      )}
                      &nbsp; &nbsp; | &nbsp; &nbsp;
                      {data?.average_rating === 0 ? (
                        <a className="textprimary" role="button">
                          Ratings : N/A
                        </a>
                      ) : (
                        <a className="textprimary" role="button" onClick={() => handleTwo()}>
                          Ratings : {data?.average_rating}
                        </a>
                      )}
                    </span>
                    <p className="mt-2">Bio : {user?.bio}</p>
                  </div>
                </div>
                <div className="col-12 col-md-2"></div>
                <div className="col-12 col-md-5">
                  <div className="profileText">
                    <p>{user?.address}</p>
                    <p>{user?.nationality}</p>
                  </div>
                  <div className="row">
                    <div className=" profileLinks">
                      <button onClick={() => window.open(`${user?.facebook_url}`)}>
                        <i className="fa-brands fa-facebook"></i>
                      </button>
                      <button onClick={() => window.open(`${user?.instagram_url}`)}>
                        <i className="fa-brands fa-instagram"></i>
                      </button>
                      <button onClick={() => window.open(`${user?.linkedin_url}`)}>
                        <i className="fa-brands fa-linkedin"></i>
                      </button>
                      <button onClick={() => window.open(`${user?.pintrest_url}`)}>
                        <i className="fa-brands fa-pinterest"></i>
                      </button>
                      <button onClick={() => window.open(`${user?.twitter_url}`)}>
                        <i className="fa-brands fa-twitter"></i>
                      </button>
                      <button onClick={() => window.open(`${user?.youtube_url}`)}>
                        <i className="fa-brands fa-youtube"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </>
        )}

        <div className="container profile-contain">
          <div className="row">
            {data?.length == 0 && isFetching ? (
              <h4 className="makeCenter">{i18next.t('No listing found !')}</h4>
            ) : (
              <>
                {isLoading ? (
                  <MyListingLoader />
                ) : (
                  <>
                    <ServiceItemList
                      setObject={setObject}
                      setSaveSearch={setSaveSearch}
                      setClear={setClear}
                      newObj={sendObj}
                    />
                    <h4>Property Listing</h4>
                    {data?.propertyData?.map((item, index) => (
                      <ServiceItem
                        key={index}
                        item={item}
                        showEditIcon={false}
                        showDeleteIcon={false}
                        showHeartIcon={false}
                        setDeleteRefetch={undefined}
                      />
                    ))}

                    {showReview ? (
                      <>
                        <hr />
                        <div id="riviewList" className="riviewList">
                          <div className="row">
                            <div className="col-md-6">
                              <h4 className="mt-5 mb-5">Review and Ratings</h4>
                            </div>
                            <div className="col-md-6 hide">
                              <Button onClick={() => setShowReview(false)}>Hide</Button>
                            </div>
                          </div>
                          {reviewData?.slice(0, 3)?.map((item, index) => (
                            <div className="col-md-9 outerRiv" key={index}>
                              <div className="row innerRiv">
                                <div className="col-md-3">
                                  <Image
                                    alt="banner"
                                    className="previewImage"
                                    src={item?.customer_image}
                                    width="100"
                                  />
                                </div>
                                <div className="col-md-9">
                                  <h6>{item?.customer_name} </h6>
                                  <p>{item?.review}</p>
                                  <p>
                                    <div className="ratings">
                                      {[...new Array(5)].map((arr, index) => {
                                        return index < item?.rating ? (
                                          <i className="fa-solid fa-star"></i>
                                        ) : (
                                          <i className="fa-regular fa-star"></i>
                                        );
                                      })}
                                    </div>
                                  </p>
                                  <p className="time">{formatDateTime(item?.rating_review_date)}</p>
                                </div>
                              </div>
                            </div>
                          ))}
                          {reviewData?.length > 3 ? (
                            <div className="botm-btn">
                              <Button onClick={() => navigate(`/all-review?id=${id}`)}>
                                Show all
                              </Button>
                            </div>
                          ) : null}
                        </div>
                      </>
                    ) : null}
                  </>
                )}
              </>
            )}
          </div>
        </div>
        <br />
        <Footer />
      </ContentLayout>
    </>
  );
};
