import { BaseEntity, Property } from '.';
import { Business } from './Business';
import { Housing } from './Housing';
import { Investment } from './Investment';
import { InvestmentCompany } from './InvestmentCompany';
import { PropertyProject } from './PropertyProject';
import { PropertyforRent } from './PropertyforRent';

export type Listing = {
  company_name: string;
  first_name: string;
  address: string;
  price: string;
  location: string;
  max_month_price: string;
  phone_number: string;
  wanted_from: string;
  type: string;
  image: string;
} & BaseEntity &
  Housing &
  Business &
  Investment &
  InvestmentCompany &
  PropertyforRent &
  PropertyProject &
  Property;
