function nametest(st)
{
  if(/^[a-zA-Z\s]+$/.test(st))
  {
  return true;
  }
  else
  {
    return false;
  }

}



$( "#open-add-area-modal" ).on( "click", function() {
  // debugger;
  $('#add_area_name_txt').text('')
  $('#add_area_workingradius_txt').text('')
  $('#add_area_distanceunit_txt').text('')
  
  $('#add_area_name').val('')
  $('#add_area_workingradius').val('')
  $('#add_area_distanceunit').val('')
  $('#latitude').val('')
  $('#longitude').val('')
  
  $('#AddAreaModal').modal('show')

});

$("#add-area-btn" ).on( "click", function() {
  $('#add_area_name_txt').text('')
  $('#add_area_workingradius_txt').text('')
  $('#add_area_distanceunit_txt').text('')
  
  var name = $('#add_area_name').val()
  var workingradius = $('#add_area_workingradius').val()
  var distanceunit = $('#add_area_distanceunit').val()
  var latitude = $('#latitude').val()
  var longitude = $('#longitude').val()
  
  name = name.trim()
  workingradius = workingradius.trim()
  distanceunit = distanceunit.trim()
  latitude = latitude.trim()
  longitude = longitude.trim()
  
  if (name.length == 0)
  {
    $('#add_area_name_txt').text('This field is required.')
    return false;
  }
  if (name.length > 100)
  {
    $('#add_area_name_txt').text('Enter less than 100 characters.')
    return false;
  }
  if (latitude.length == 0)
  {
    $('#add_area_name_txt').text('Please select from Google suggestions.')
    $( "#add_area_names" ).focus();
    return false;
  }  
  if (workingradius.length >= 1 && workingradius.length <= 6)
  {
    if(isNaN(workingradius))
    {
      $('#add_area_workingradius_txt').text('Enter digits only.')
      return false; 
    }
  }
  else
  {
    $('#add_area_workingradius_txt').text('Enter between 1-6 digits.')
      return false; 
  }
  if (distanceunit.length == 0)
  {
    $('#add_area_distanceunit_txt').text('This field is required.')
    return false;
  }
  
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/addaddoperationalarea/',
      data: {'name' : name, 'workingradius' : workingradius, 'distanceunit' : distanceunit, 'latitude' : latitude, 'longitude' : longitude, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#AddAreaModal').modal('hide');
          $('#success_modal_add').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else
        {
          $('#add_area_name_txt').text(response.status_message)
        }
        // $('#EditdriverModal').modal('show')
      }
    });
});




$( ".disable_driver" ).on( "click", function() {
  // debugger;
  driver_id = $ (this).closest('td').find('.driver_id').text()
  $('#disable-record-data').val(driver_id)
  $('#DisableUserModal').modal('show')

});

$( ".disable-record-yes-btn" ).on( "click", function() {
  // debugger;
  driver_id = $('#disable-record-data').val()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/disabledriver/',
      data: { 'driver_id' : driver_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#DisableUserModal').modal('hide');
          $('#success_modal_deleted').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else if(response.status_code == 0)
        {

        }
      }
    });
});

$( ".enable_driver" ).on( "click", function() {
  // debugger;
  driver_id = $ (this).closest('td').find('.driver_id').text()
  $('#enable-record-data').val(driver_id)
  $('#EnableUserModal').modal('show')

});

$( ".enable-record-yes-btn" ).on( "click", function() {
  // debugger;
  driver_id = $('#enable-record-data').val()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/enabledriver/',
      data: { 'driver_id' : driver_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#EnableUserModal').modal('hide');
          $('.response-msg').text(response.status_message)
          $('#success_modal_deleted').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else if(response.status_code == 0)
        {

        }
      }
    });
});


$( "#close-driver-view-btn" ).on( "click", function() {
  $('#ViewDriverModal').modal('hide')
});

$( ".view_driver" ).on( "click", function() {
  // debugger;
  driver_id = $ (this).closest('td').find('.driver_id').text()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/editdriver/',
      data: { 'driver_id' : driver_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        driver_details = JSON.parse(response)
        if(driver_details[0].image)
          {
            $('#view-show-image').attr("src", driver_details[0].image);
          }
          // else
          // {
          //   $('#edit-show-image').attr("src", "/static/images/camera.png"); 
          // }
        $('#view_driver_name').val(driver_details[0].name)
        $('#view_driver_email').val(driver_details[0].email)

        $('#view_driver_countrycode').val(driver_details[0].countrycode)
        $('#view_driver_phone').val(driver_details[0].phone)
        
        $('#view_driver_phone_txt').text('')
        $('#view_driver_id').val(driver_details[0].id)
        $('#ViewDriverModal').modal('show')
      }
    });
});

$( ".edit_driver" ).on( "click", function() {
	// debugger;
  driver_id = $ (this).closest('td').find('.driver_id').text()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/editdriver/',
      data: { 'driver_id' : driver_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        console.log(JSON.parse(response));
        driver_details = JSON.parse(response)
        console.log(driver_details[0].id)
        if(driver_details[0].image)
        {
          $('#edit-show-image').attr("src", driver_details[0].image);
        }
        $('#edit_driver_name').val(driver_details[0].name)
        $('#edit_driver_email').val(driver_details[0].email)

        $('#edit_driver_countrycode').val(driver_details[0].countrycode)
        $('#edit_driver_phone').val(driver_details[0].phone)
        
        $('#edit_driver_phone_txt').text('')
        $('#edit_driver_id').val(driver_details[0].id)
        $('#EditDriverModal').modal('show')
      }
    });
});

$( "#update-driver-btn" ).on( "click", function() {
  
  $('#edit_driver_name_txt').text('')
  $('#edit_driver_countrycode_txt').text('')
  $('#edit_driver_phone_txt').text('')
  
  var name = $('#edit_driver_name').val()
  var countrycode = $('#edit_driver_countrycode').val()
  var phone = $('#edit_driver_phone').val()
  
  var driver_id = $('#edit_driver_id').val()

  name = name.trim()
  countrycode = countrycode.trim()
  phone = phone.trim()
  
  if (name.length == 0)
  {
    $('#edit_driver_name_txt').text('This field is required.')
    return false;
  }
  if (countrycode.length == 0)
  {
    $('#edit_driver_countrycode_txt').text('This field is required.')
    return false;
  }
  if (phone.length == 0)
  {
    $('#edit_driver_phone_txt').text('This field is required.')
    return false;
  }
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/updatedriver/',
      data: { 'driver_id' : driver_id, 'name' : name, 'countrycode' : countrycode, 'phone' : phone, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#EditDriverModal').modal('hide');
          $('#success_modal_updated').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else if(response.status_code == 0)
        {

        }
        // $('#EditdriverModal').modal('show')
      }
    });
});