from django.shortcuts import render
from rest_framework.views import APIView
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth.models import User
from django.contrib.auth import authenticate
from rest_framework.authtoken.models import Token
from Customer.models import *
from Driver.models import *
from AdminApp.models import *
import math, random, datetime, pytz, string
from datetime import timedelta
from django.conf import settings
from rest_framework.views import APIView
from django.core.mail import send_mail
import base64
from io import BytesIO
from PIL import Image
import requests, json
from Customer.commonfunctions import getunreadnotificationcount, sendfcmnotification, generateparcelpdf, generateqrcode
from AdminApp.adminfunctions import sendnewusermail
from pyfcm import FCMNotification
# Create your views here.
from django.contrib.auth.hashers import make_password
import stripe
import sys
from django.db.models import Avg
from django.db.models import Q


def convert24(str1):
	if str1[-2:] == "AM" and str1[:2] == "12":
		res= "00" + str1[2:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	elif str1[-2:] == "AM":
		res= str1[:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	elif str1[-2:] == "PM" and str1[:2] == "12":
		res= str1[:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	else:
		res= str(int(str1[:2]) + 12) + str1[2:6]
		res=res+":00"
		res=res.replace(" ","")
		return res

def makeslotAvailable(slotId,slotId2,DriverID):
	try:
		slotId=slotId+1
		driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj).first()
		if driverslotsobj:
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=True
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=True
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=True
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=True
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=True
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=True
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=True
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=True
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=True
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=True
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=True
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=True
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=True
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=True
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=True
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=True
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=True
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=True
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=True
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=True
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=True
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=True
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=True
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=True
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'

def slotStatusonJobComplete(sameparcelID):
	customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID)
	packageCompleted=True
	startSlot=24
	lastSlot=0
	driverID=0
	driverExist=False
	for customer in customerjob_obj_all:
		dJob=DriverJob.objects.filter(customerjob=customer).first()
		if dJob:
			driverExist=True
			driverID=dJob.driver.id
			print(customer.pickuptimeslotDate)
			print(customer.pickuptimeslot)
			stringFirst=customer.pickuptimeslot
			one=stringFirst.split('-')[0]
			two=stringFirst.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringFirst=one+" "+two
			print(one)
			print(two)
			print(stringFirst)
			pickupSlotID=int(stringFirst[:2])
			if pickupSlotID<startSlot:
				startSlot=pickupSlotID
			print("Pickupslotid",pickupSlotID)
			print(customer.dropofftimeslot)
			stringSecond=customer.dropofftimeslot
			one=stringSecond.split('-')[0]
			two=stringSecond.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringSecond=one+" "+two
			print(one)
			print(two)
			print(stringSecond)
			deliverySlotID=int(stringSecond[:2])
			if deliverySlotID>lastSlot:
				lastSlot=deliverySlotID
	if driverExist:
		makeslotAvailable(startSlot,lastSlot+1,driverID)


def slotStatusonJobCompletenew(sameparcelID):
	customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID)
	packageCompleted=True
	startSlot=24
	lastSlot=0
	driverID=0
	driverExist=False
	for customer in customerjob_obj_all:
		dJob=DriverJob.objects.filter(customerjob=customer).first()
		if dJob:
			print("we are in driver job")
			driverExist=True
			driverID=dJob.driver.id
			print(customer.pickuptimeslotDate)
			print(customer.pickuptimeslot)
			stringFirst=customer.pickuptimeslot
			one=stringFirst.split('-')[0]
			two=stringFirst.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringFirst=one+" "+two
			print(one)
			print(two)
			print(stringFirst)
			pickupSlotID=int(stringFirst[:2])
			if pickupSlotID<startSlot:
				startSlot=pickupSlotID
			print("Pickupslotid",pickupSlotID)
			print(customer.dropofftimeslot)
			stringSecond=customer.dropofftimeslot
			one=stringSecond.split('-')[0]
			two=stringSecond.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringSecond=one+" "+two
			print(one)
			print(two)
			print(stringSecond)
			deliverySlotID=int(stringSecond[:2])
			if deliverySlotID>lastSlot:
				lastSlot=deliverySlotID
	slotsFind=False
	idofslottables=0
	print("one 1")
	pickupdateCuystomer = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID).first()
	print(pickupdateCuystomer)
	print("one 2")
	parcelpickupdate=pickupdateCuystomer.pickuptimeslotDate
	print("one 3")
	dJob=DriverJob.objects.filter(customerjob=pickupdateCuystomer).first()
	print(dJob)
	if dJob:
		print("one 4")
		driver=dJob.driver
		print("one 5",driver)
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver)
		print("one 6",driverslotsobj)
		for d in driverslotsobj:
			print("one 7")
			if d.dateOfSlots==parcelpickupdate:
				print("one 8",d.dateOfSlots)
				slotsFind=True
				idofslottables=d.id
				print("one 8",idofslottables)
	if slotsFind==True:
		print("one 9")
		if driverExist:
			print("one 10")
			makeslotAvailablenew(startSlot,lastSlot+1,idofslottables)

def makeslotAvailablenew(slotId,slotId2,driveridforslots):
	try:
		slotId=slotId+1
		# driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(id=driveridforslots).first()
		if driverslotsobj:
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=True
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=True
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=True
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=True
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=True
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=True
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=True
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=True
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=True
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=True
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=True
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=True
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=True
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=True
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=True
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=True
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=True
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=True
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=True
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=True
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=True
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=True
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=True
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=True
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'

class cancelParcelOrder(APIView):
	def post(self, request, *args, **kwargs):
		'''This function is being used to delete the parcel type details by Admin'''
		print('Customer - in cancelParcelOrder ')
		try:	
			sameparcelID = request.POST.get('sameparcelID')
			if not sameparcelID:
				return JsonResponse({'status_code' : 400, 'status_message' : 'sameparcelID is required.'})
			customerjob_obj=CustomerJob.objects.filter(sameIdForParcelsDetails=sameparcelID)
			cancelParcel=True
			if customerjob_obj:
				for c in customerjob_obj:
					try:
						dJob=DriverJob.objects.filter(customerjob=c).first()
						if dJob.jobstarted==True:
							cancelParcel=False
					except Exception as e:
						print(e)
				if cancelParcel==True:
					for custom in customerjob_obj:
						custom.isdeleted=True
						dJob=DriverJob.objects.filter(customerjob=custom).first()
						if dJob:
							dJob.isdeleted=True
							dJob.save()
						custom.save()
					slotStatusonJobCompletenew(sameparcelID)
					return JsonResponse({'status_code' : 200, 'status_message' : 'Parcel cancelled successfully.'})
				else:
					return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request.'})
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})


class AllAdress(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					profile_data=[]
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						customerjob_obj = CustomerJob.objects.filter(customer=customer_obj)
						for custom in customerjob_obj:
							profile_data.append({
										'recipientname':custom.recipientname,
										'recipientcountrycode':custom.recipientcountrycode,
										'recipientphone':custom.recipientphone,
										'recipientlatitude':custom.recipientlatitude,
										'recipientlongitude':custom.recipientlongitude,
										'dropoffaddress':custom.dropoffaddress,

										# 'vehiclenumber':driver_obj.vehiclenumber,
										# 'vehicledetailsexist':vehicledetailsexist,
										# 'address' : address,
										# 'city' : driver_obj.city,
										# 'postalcode' : driver_obj.postalcode,
										# 'country' : driver_obj.country,
										# 'national_insurance_number' : driver_obj.national_insurance_number,
										# 'driving_license_number' : driver_obj.driving_license_number,
										# 'image':image,
										# 'ratings' : ratings,
										# 'documents_approved':documents_approved_by_admin,
										# 'license_front' : license_front,
										# 'license_back' : license_back,
										# 'id_front' : id_front,
										# 'id_back' : id_back,
										# 'crb_dbs' : crb_dbs,
									})
						return JsonResponse({ 'status_code': 200 , 'data' : profile_data,'status_message' : 'success' })

						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						# return JsonResponse({ 'status_code': 200 , 'data' : profile_data,'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 400 , 'data' : {},'status_message' : '' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : {},'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 400 , 'data' : {},'status_message' : '' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})



class Testman(APIView):
	'''This class is used to get all vehicle types '''
	def get(self, request, *args, **kwargs):
		try:
			print('GetRepeatOrders API - in get')
			session_token_val = request.GET.get('session_token')

			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			
			repeatorders_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				customer_obj = Customer.objects.filter(user_id = token_obj.user_id).first()
				if customer_obj:
					customerjob_obj = CustomerJob.objects.all()
					if customerjob_obj:
						for custom in customerjob_obj:
							temp_dict={
									'recipientlatitude' : custom.recipientlatitude,
									'recipientlongitude' : custom.recipientlongitude,
									'dropoffaddress' : custom.dropoffaddress,
								}
							if temp_dict in repeatorders_data:
								pass
							else:
								repeatorders_data.append(temp_dict)
					# repeatorder_obj = RepeatOrder.objects.filter(customer = customer_obj, is_cancelled = False)
					# if repeatorder_obj:
					# 	for order in repeatorder_obj:
					# 		customerjob_obj = CustomerJob.objects.filter(id = order.base_customerjob_id).first()
					# 		if customerjob_obj:
					# 			repeatorders_data.append({
					# 				'base_customerjob_id' : order.base_customerjob_id,
					# 				'repeat_after_days' : order.repeat_after_days,
					# 				'repeat_date_string' : order.repeat_date_string,
					# 				})

								
			return JsonResponse({'status_code': 200, 'status_message' : 'success', 'data' : repeatorders_data})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})

class GetRepeatOrders(APIView):
	'''This class is used to get all vehicle types '''
	def get(self, request, *args, **kwargs):
		try:
			print('GetRepeatOrders API - in get')
			session_token_val = request.GET.get('session_token')

			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			
			repeatorders_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				customer_obj = Customer.objects.filter(user_id = token_obj.user_id).first()
				if customer_obj:
					repeatorder_obj = RepeatOrder.objects.filter(customer = customer_obj, is_cancelled = False)
					if repeatorder_obj:
						for order in repeatorder_obj:
							customerjob_obj = CustomerJob.objects.filter(id = order.base_customerjob_id).first()
							if customerjob_obj:
								repeatorders_data.append({
									'base_customerjob_id' : order.base_customerjob_id,
									'repeat_after_days' : order.repeat_after_days,
									'repeat_date_string' : order.repeat_date_string,
									'start_date' : order.start_date,
									'end_date' : order.end_date,
									'pickuptimeslot' : order.pickuptimeslot,
									'dropofftimeslot' : order.dropofftimeslot,

									'sendername' : customerjob_obj.sendername,
									'recipientname' : customerjob_obj.recipientname,
									'senderphone' : customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone,
									'recipientphone' : customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone, 
									'pickupaddress' : customerjob_obj.pickupaddress,
									'dropoffaddress' : customerjob_obj.dropoffaddress,
									})

								
			return JsonResponse({'status_code': 200, 'status_message' : 'success', 'data' : repeatorders_data})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})


class CancelRepeatBooking(APIView):
	def post(self, request, *args, **kwargs):
		'''This function is being used to delete the parcel type details by Admin'''
		print('Customer - in CancelRepeatBooking ')
		try:	
			base_customerjob_id = request.POST.get('base_customerjob_id')
			if not base_customerjob_id:
				return JsonResponse({'status_code' : 400, 'status_message' : 'base_customerjob_id is required.'})
			repeatorder_obj = RepeatOrder.objects.filter(base_customerjob_id = base_customerjob_id).first()
			if repeatorder_obj:
				repeatorder_obj.is_cancelled = True
				repeatorder_obj.save()
				return JsonResponse({'status_code' : 200, 'status_message' : 'Booking cancelled successfully.'})
				
			else:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request.'})
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})



class GetCards(APIView):
	'''This class is used to get all vehicle types '''
	def get(self, request, *args, **kwargs):
		try:
			print('GetCards API - in get')
			session_token_val = request.GET.get('session_token')

			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			
			storedcards_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				customer_obj = Customer.objects.filter(user_id = token_obj.user_id).first()
				if customer_obj:
					storedcard_obj = StoredCard.objects.filter(customer = customer_obj)
					if storedcard_obj:
						serialno = 0
						for card in storedcard_obj:
							serialno += 1
							storedcards_data.append({
								'serialno' : serialno,
								'last4digits' : card.stripe_card_number_lastfourdigits,
								'expiry_date' : card.stripe_card_exp_month + '/' + card.stripe_card_exp_year,
								'card_id' : card.id,
								})
			return JsonResponse({'status_code': 200, 'status_message' : 'success', 'data' : storedcards_data})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})


class CustomerDeleteCard(APIView):
	def post(self, request, *args, **kwargs):
		'''This function is being used to delete the parcel type details by Admin'''
		print('Customer - in delete_card function')
		try:	
			card_id = request.POST.get('card_id')
			if not card_id:
				return JsonResponse({'status_code' : 400, 'status_message' : 'card_id is required.'})
			storedcard_obj = StoredCard.objects.filter(id = card_id).first()
			if storedcard_obj:
				# stripe.api_key = "sk_test_P9sozPTZ5nZbhc3fOFCsjNqm00hYGCvJ7l"
				stripe.api_key = str(settings.STRIPE_KEY)

				res = stripe.Customer.delete_source(
				  storedcard_obj.stripe_customer_id,
				  storedcard_obj.stripe_card_id,
				)
				print(res)
				if res['deleted'] == True:
					StoredCard.objects.filter(id = card_id).delete()
					return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
				else:
					return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request.'})
				
				return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
			else:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request.'})
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})


class CustomerAddCard(APIView):
	def post(self, request, *args, **kwargs):
		'''This function shows the content on profile screen'''
		print("CustomerAddCard - in post ")
		try:	
			
			# print(request.POST)
			
			session_token_val = request.POST.get('session_token')
			
			card_name = request.POST.get('card_name')
			card_number = request.POST.get('card_number')
			card_expiry_month = request.POST.get('card_expiry_month')
			card_expiry_year = request.POST.get('card_expiry_year')
			card_expiry_cvc = request.POST.get('card_expiry_cvc')
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			
			if not card_name:
				return JsonResponse({'status_code': 400, 'status_message': 'card_name is required'})
			if not card_number:
				return JsonResponse({'status_code': 400, 'status_message': 'card_number is required'})
			if not card_expiry_month:
				return JsonResponse({'status_code': 400, 'status_message': 'card_expiry_month is required'})
			if not card_expiry_year:
				return JsonResponse({'status_code': 400, 'status_message': 'card_expiry_year is required'})
			if not card_expiry_cvc:
				return JsonResponse({'status_code': 400, 'status_message': 'card_expiry_cvc is required'})
			
			# stripe.api_key = "sk_test_P9sozPTZ5nZbhc3fOFCsjNqm00hYGCvJ7l" # varis_raheja
			stripe.api_key = str(settings.STRIPE_KEY)
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				customer_obj = Customer.objects.filter(user_id = token_obj.user_id).first()
				if customer_obj:
					email_val = customer_obj.email 
					storedcard_obj = StoredCard.objects.filter(customer = customer_obj).first()
					if storedcard_obj:
						pass
						print('atleast one card is stored')
						try:	
							card = stripe.Token.create(
							card={
								"number": card_number,
								"exp_month": int(card_expiry_month),
							    "exp_year": int(card_expiry_year),
							    "cvc": card_expiry_cvc,
								},
							)
							last_four_digits = card['card']['last4']
							exp_month = card['card']['exp_month']
							exp_year = card['card']['exp_year']
							card_id = card['card']['id']
							token_id = card['id']
							print('card_id = ', card_id) 
							print('token_id = ', token_id)
							res2 = stripe.Customer.create_source(
							  storedcard_obj.stripe_customer_id,
							  source = token_id,
							)
							storedcard_obj = StoredCard.objects.create(customer = customer_obj, stripe_customer_id = storedcard_obj.stripe_customer_id, stripe_card_id = card_id, stripe_card_number_lastfourdigits = last_four_digits, stripe_card_exp_month = exp_month, stripe_card_exp_year = exp_year)	

							return JsonResponse({'status_code': 200, 'status_message': 'Your card is added successfully.'})
							# paymentmethod = stripe.PaymentMethod.create(
							#   type="card",
							#   card={
							#     "number": card_number,
							#     "exp_month": int(card_expiry_month),
							#     "exp_year": int(card_expiry_year),
							#     "cvc": card_expiry_cvc,
							#   },
							# )
							# print(paymentmethod['id'])
						except Exception as e:
							print(e)
							return JsonResponse({'status_code': 400, 'status_message': 'Your card details are invalid'})
						
					else:
						customer = stripe.Customer.create(email = email_val)
						customer_id = customer['id']
						print('customer_id = ', customer_id)
						storedcard_obj = StoredCard.objects.create(customer = customer_obj, stripe_customer_id = customer_id, is_default = True)
						if storedcard_obj:
							try:
								card = stripe.Token.create(
								card={
									"number": card_number,
									"exp_month": int(card_expiry_month),
								    "exp_year": int(card_expiry_year),
								    "cvc": card_expiry_cvc,
									},
								)
								last_four_digits = card['card']['last4']
								exp_month = card['card']['exp_month']
								exp_year = card['card']['exp_year']
								card_id = card['card']['id']
								token_id = card['id']
								print('card_id = ', card_id) 
								print('token_id = ', token_id)
								# attach card with customer
								res2 = stripe.Customer.create_source(
								  customer_id,
								  source = token_id,
								)
								print(res2)
								storedcard_obj.stripe_card_id = card_id
								storedcard_obj.stripe_card_number_lastfourdigits = last_four_digits
								storedcard_obj.stripe_card_exp_month = exp_month
								storedcard_obj.stripe_card_exp_year = exp_year
								storedcard_obj.save()
								return JsonResponse({'status_code': 200, 'status_message': 'Your card is added successfully.'})
							except Exception as e:
								print(e)
								return JsonResponse({'status_code': 400, 'status_message': 'Your card details are invalid'})

				else:
					return JsonResponse({'status_code': 400, 'status_message': 'You are not authorized to add card'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})




class RepeatBooking(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('RepeatBooking - post ')

		print('data is  : ',request.POST)
		try:
			session_token_val = request.POST.get('session_token')
			start_date = request.POST.get('start_date')
			end_date = request.POST.get('end_date')
			repeat_date_string = request.POST.get('repeat_date_string')
			repeat_after_days = request.POST.get('repeat_after_days')
			base_customerjob_id = request.POST.get('base_customerjob_id')
			pickuptimeslot = request.POST.get('pickuptimeslot')
			dropofftimeslot = request.POST.get('dropofftimeslot')
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			if not start_date:
				return JsonResponse({'status_code': 400, 'status_message': 'start_date is required'})
			if not end_date:
				return JsonResponse({'status_code': 400, 'status_message': 'end_date is required'})
			if not repeat_date_string:
				return JsonResponse({'status_code': 400, 'status_message': 'repeat_date_string is required'})
			
			if not repeat_after_days:
				return JsonResponse({'status_code': 400, 'status_message': 'repeat_after_days is required'})
			if not base_customerjob_id:
				return JsonResponse({'status_code': 400, 'status_message': 'base_customerjob_id is required'})
			if not pickuptimeslot:
				return JsonResponse({'status_code': 400, 'status_message': 'pickuptimeslot is required'})
			if not dropofftimeslot:
				return JsonResponse({'status_code': 400, 'status_message': 'dropofftimeslot is required'})
			
			try:
				customerjob_obj = CustomerJob.objects.filter(id = base_customerjob_id).first()
				if customerjob_obj:
					repeatorder_obj = RepeatOrder.objects.create(customer = customerjob_obj.customer, base_customerjob_id = base_customerjob_id, repeat_date_string = repeat_date_string, repeat_after_days = repeat_after_days, start_date = start_date, end_date = end_date, pickuptimeslot = pickuptimeslot, dropofftimeslot = dropofftimeslot)
					if repeatorder_obj:
						return JsonResponse({'status_code': 200, 'status_message' : 'success'})
					else:
						return JsonResponse({'status_code': 400, 'status_message' : 'Bad Request'})
				else:
					return JsonResponse({'status_code': 400, 'status_message' : 'Bad Request'})
			except Exception as e:
				print(e)
				return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})
			
			try:
				customerjob_obj = CustomerJob.objects.filter(id = base_customerjob_id).first()
				if customerjob_obj:
					pass
					print(customerjob_obj.order)
					print(customerjob_obj.order.id)
					specialbooking_charges = 0.0
					if customerjob_obj.specialbooking:
						backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
						if backendcontrol_obj:
							specialbooking_charges = backendcontrol_obj.price
						
					parceldelivery_charges = customerjob_obj.price
					totalamount = parceldelivery_charges + specialbooking_charges
					order_obj = Order.objects.create(customer = customerjob_obj.order.customer,ordertype = 1,  parceldelivery_charges = parceldelivery_charges, specialbooking_charges = specialbooking_charges, totalamount = totalamount)
					if order_obj:
						print('\norder_obj is successfully created\n')
						new_customerjob_obj = CustomerJob.objects.create(order = order_obj, customer = order_obj.customer, sendername = customerjob_obj.sendername, senderemail = customerjob_obj.senderemail, sendercountrycode = customerjob_obj.sendercountrycode, senderphone = customerjob_obj.senderphone, pickupaddress = customerjob_obj.pickupaddress, sendercity = customerjob_obj.sendercity, senderlatitude = customerjob_obj.senderlatitude, senderlongitude = customerjob_obj.senderlongitude, pickupspecialnote = customerjob_obj.pickupspecialnote, noofparcels = customerjob_obj.noofparcels, recipientname = customerjob_obj.recipientname, recipientcountrycode = customerjob_obj.recipientcountrycode, recipientphone = customerjob_obj.recipientphone, recipientlatitude = customerjob_obj.recipientlatitude, recipientlongitude = customerjob_obj.recipientlongitude, dropoffaddress = customerjob_obj.dropoffaddress, dropoffspecialnote = customerjob_obj.dropoffspecialnote, length = customerjob_obj.length, width = customerjob_obj.width, height = customerjob_obj.height, weight = customerjob_obj.weight, parceltype = customerjob_obj.parceltype, pickuptimeslot = customerjob_obj.pickuptimeslot, dropofftimeslot = customerjob_obj.dropofftimeslot, vehicletype = customerjob_obj.vehicletype, image = customerjob_obj.image.name, specialbooking = customerjob_obj.specialbooking)
						if new_customerjob_obj:
							if pickuptimeslot and dropofftimeslot:
								new_customerjob_obj.pickuptimeslot = pickuptimeslot
								new_customerjob_obj.dropofftimeslot = dropofftimeslot
								new_customerjob_obj.save()
							print('\nnew_customerjob_obj is created\n')
							try:
								print('before generateqrcode function call')
								generateqrcode(id_val = new_customerjob_obj.id)
								print('after function call')
							except Exception as e:
								print(e)
							try:
								res = generateparcelpdf(new_customerjob_obj.id)
								print(res)
							except Exception as e:
								print(e)
						else:
							print('\nnew_customerjob_obj is not created\n')	
					else:
						pass
						print('\norder_obj is not created\n')
					return JsonResponse({'status_code': 200, 'status_message' : 'success'})
				else:
					return JsonResponse({'status_code': 400, 'status_message' : 'Bad Request'})
			except Exception as e:
				print(e)
				return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})





class CompanyGetAllCreditRequests(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			token_obj = Token.objects.filter(key = session_token_val).first()
			all_credit_requests_data = []
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					customer_obj = Customer.objects.filter(user = user_obj, role = 'company').first()
					if customer_obj:
						companydetail_obj = CompanyDetail.objects.filter(customer = customer_obj).first()
						current_credits = 0.0
						if companydetail_obj:
							current_credits = companydetail_obj.credits
						creditsrequested_obj = CreditsRequested.objects.filter(company_email = user_obj.email)
						if creditsrequested_obj:
							for req in creditsrequested_obj:
								all_credit_requests_data.append({
									'credits' : str(req.credits),
									'note_by_company' : req.note_by_company,
									'status' : req.status,
									'date' : req.created_at.strftime("%d/%m/%Y %I:%M:%S %p"),
									})
						
						
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : all_credit_requests_data,'status_message' : 'success', 'current_credits' : current_credits })
					else:
						return JsonResponse({ 'status_code': 400 , 'data' : all_credit_requests_data,'status_message' : '', 'current_credits' : current_credits })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : all_credit_requests_data,'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 400 , 'data' : all_credit_requests_data,'status_message' : '' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})



class CompanyMakeCreditrequest(APIView):
	def post(self, request, *args, **kwargs):
		'''This function shows the content on profile screen'''
		print("CompanyMakeCreditrequest - in post ")
		try:	
			
			# print(request.POST)
			
			session_token_val = request.POST.get('session_token')
			credits_request = request.POST.get('credits_request')
			credits_request_note = request.POST.get('credits_request_note')

			
			if not credits_request:
				return JsonResponse({'status_code': 400, 'status_message': 'credits_request is required'})
			if not credits_request_note:
				return JsonResponse({'status_code': 400, 'status_message': 'credits_request_note is required'})
			
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id, role = 'company').first()
				
				if customer_obj:
					creditsrequested_obj = CreditsRequested.objects.create(company_email = customer_obj.email, credits = credits_request, note_by_company = credits_request_note, status = 'pending')
					if creditsrequested_obj:
						return JsonResponse({'status_code': 200, 'status_message': 'success'})
			
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'You are not authorized to make credit request'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})



class CheckOperationArea(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('CheckOperationArea - post ')

		print('data is  : ',request.POST)
		try:
			session_token_val = request.POST.get('session_token')
			latitude_val = request.POST.get('latitude')
			longitude_val = request.POST.get('longitude')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			if not latitude_val:
				return JsonResponse({'status_code': 400, 'status_message': 'latitude is required'})
			if not longitude_val:
				return JsonResponse({'status_code': 400, 'status_message': 'longitude is required'})
			from math import radians, cos, sin, asin, sqrt
			def haversine(lat1, lon1, lat2, lon2):
				lat1, lon1, lat2, lon2 = map(float, [lat1, lon1, lat2, lon2])# haversine formula 
				lat1, lon1, lat2, lon2 = map(radians, [lat1, lon1, lat2, lon2])# haversine formula 
				dlon = lon2 - lon1 
				dlat = lat2 - lat1 
				a = sin(dlat/2)**2 + cos(lat1) * cos(lat2) * sin(dlon/2)**2
				c = 2 * asin(sqrt(a)) 
				# r = 6371 # Radius of earth in kilometers. Use 3956 for miles
				r = 3956 # Radius of earth in miles. Use 6371 for km
				return (c * r)

			# distance_from_centre_point
			operationalarea_obj = OperationalArea.objects.all()
			if operationalarea_obj:
				for area in operationalarea_obj:
					dis = haversine(latitude_val, longitude_val, area.latitude, area.longitude)
					print(dis)
					if dis <= area.distance_from_centre_point:
						return JsonResponse({'status_code': 200, 'status_message' : 'success'})
			return JsonResponse({'status_code': 400, 'status_message' : 'Currently, we do not operate in this area.'})

			
		
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})





class GiveRating(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('GiveRating - post ')

		print('data is  : ',request.POST)
		try:
			session_token_val = request.POST.get('session_token')
			ratingfor_val = request.POST.get('ratingfor')
			customerjobid_val = request.POST.get('customerjobid')
			customerid_val = request.POST.get('customerid')
			driverid_val = request.POST.get('driverid')
			rating_val = request.POST.get('rating')
			note_val = request.POST.get('note')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			if not ratingfor_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Rating for is required'})
			if not customerjobid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'customerjobid is required'})
			if not driverid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'driverid is required'})
			if not rating_val:
				return JsonResponse({'status_code': 400, 'status_message': 'rating is required'})
			
			try:
				UserRating.objects.create(ratingfor = ratingfor_val, customerjobid = customerjobid_val, customerid = customerid_val, driverid = driverid_val, rating = rating_val, note = note_val)
				return JsonResponse({'status_code': 200, 'status_message' : 'Thanks for the review.'})
			except Exception as e:
				print(e)
			
		
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})





class GetTimeSlots(APIView):
	'''This class is used to get all vehicle types '''
	def get(self, request, *args, **kwargs):
		try:
			print('GetTimeSlots API - in get')
			data = []
			alltimeslots = TimeSlots.objects.filter(active = True)
			if alltimeslots:
				for slot in alltimeslots:
					data.append({
						'id' : slot.id,
						'openinghour' : slot.openinghour.strftime("%I:%M %p"),
						'closinghour' : slot.closinghour.strftime("%I:%M %p"),
						'status' : slot.active,
						})
			print(data)
			return JsonResponse({'status_code': 200, 'status_message' : 'success', 'data' : data})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})


class GetDriverCoordinates(APIView):
	
	def get(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('GetDriverCoordinates - get ')

		print('data is  : ',request.GET)
		try:
			driverid_val = request.GET.get('driverid')
			if not driverid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'driverid is required',})
			data = {}
			driver_obj = DriverModel.objects.filter(id = driverid_val).first()
			if driver_obj:
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
				if drivercoordinates_obj:
					data.update({
						'latitude' : drivercoordinates_obj.latitude,
						'longitude' : drivercoordinates_obj.longitude,
						})
					
				return JsonResponse({ 'status_code': 200 , 'data' : data,'status_message' : 'success' })
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
		
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})


def prorityandChecking(prority):
	checkin=CustomerJob.objects.filter(priorityBaseIDForParcel=prority)
	if checkin:
		prority=prority+1
		return(prorityandChecking(prority))
	else:
		return prority

class CompanyPlaceOrderExtraTest(APIView):
	'''This class is being used to save the customer job request details in the database'''
	
	def post(self, request, *args, **kwargs):
		print('\n\n')
		print('CompanyPlaceOrder API - in post')
		print('\n\n')
		# print(request.POST)
		print('\n\n')


		def generateqrcode(id_val):
			try:	
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					print('\n\n\n\n')
					print('directory exists')
					pass
				else:
					print('\n\n\n\n')
					print('directory not exists')
					os.umask(0)
					os.makedirs(filepath, mode=0o777)
					# os.mkdir(filepath, mode=0o777)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')
			except Exception as e:
				print(e)

		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.makedirs(filepath, mode=0o777)
				# os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')



		session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')
		ordertype = request.POST.get('ordertype')
		totalamount = request.POST.get('totalamount')
		parceldelivery_charges = request.POST.get('parceldelivery_charges')
		specialbooking_charges = request.POST.get('specialbooking_charges')
		vehicletype = request.POST.get('vehicletype')
		credits_to_be_used = request.POST.get('credits_to_be_used')
		try:
			last_customer_obj=CustomerJob.objects.last()
			if last_customer_obj:
				if int(last_customer_obj.sameIdForParcelsDetails)==0:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1000
				else:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1
		except Exception as e:
			pass
			print(e)
		

		try:
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					companydetail_obj = CompanyDetail.objects.filter(customer__email = customer_obj.email).first()
					if companydetail_obj:
						if companydetail_obj.credits - float(credits_to_be_used) < 0.0:
							return JsonResponse({'status_code': 400, 'status_message': 'Not enough credits in account.'})
					if ordertype == 'singledrop':
						ordertype = 1
					elif ordertype == 'multidrop':
						ordertype = 2
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Order type is required.'})
					order_obj = Order.objects.create(customer = customer_obj, ordertype = ordertype, totalamount = float(totalamount), parceldelivery_charges = float(parceldelivery_charges), specialbooking_charges = float(specialbooking_charges), isdeleted = False)
		except Exception as e:
			print(e)
		print('0')

		parcels_data = json.loads(parcels_data)
		print('1')
		print(totalamount)
		if payment_token:
			try:	
				print(payment_token)
				stripe.api_key = str(settings.STRIPE_KEY)
				charge = stripe.Charge.create(
				amount = int(float(totalamount)*100),
				currency = 'gbp',
				description = 'Parcel Payment',
				source = payment_token,
				)
				print(charge)
				OrderPayment.objects.create(order = order_obj, method = 'card', stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
			except Exception as e:
				print('Exception in creating charge = ', e)
		else:
			companydetail_obj = CompanyDetail.objects.filter(customer__email = customer_obj.email).first()
			if companydetail_obj:
				if companydetail_obj.credits - float(credits_to_be_used) >= 0.0:
					companydetail_obj.credits -= float(credits_to_be_used)
					companydetail_obj.save()
					orderpayment_obj = OrderPayment.objects.create(order = order_obj, method = 'credits', credits_to_be_used = float(credits_to_be_used))
					if orderpayment_obj:
						pass
						print('credits payment success')
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Internal Server Error.'})	
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Not enough credits in account.'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'Not enough credits in account.'})


		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')
		token_obj = Token.objects.filter(key = session_token_val).first()
		print('1')
		if token_obj:
			print('2')
			user_id = token_obj.user_id
			customer_obj = Customer.objects.filter(user__id = user_id).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print("count for manpreet")
					print('\n')
					print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['length'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					print(parcel['parcelItems'])
					print(parcel['parcelDeliver_Safe'])

					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = ''
					try:
						sendercity_val = parcel['sendercity']
					except Exception as e:
						print(e)
					# noofparcels_val = parcel['noofparcels']
					length_val = parcel['length']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']

					pickuptimeslotDate_val = parcel['pickuptimeslotDate']
					pickuptimeslot_val = parcel['pickuptimeslot']
					dropofftimeslot_val = parcel['dropofftimeslot']

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val = parcel['recipientlongitude']
					recipientspecialnote_val = parcel['recipientspecialnote']
					parcelItems=parcel['parcelItems']
					parcelDeliverysafe1=parcel['parcelDeliver_Safe']
					parcelDeliverysafe=False
					if parcelDeliverysafe1 == '1':
						parcelDeliverysafe=True

					# vehicletype_val = parcel['vehicletype']
					# price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					specialbooking_val = parcel['specialbooking'] #in apis, we are taking this parameter outside
					if specialbooking_val == 'yes':
						specialbooking = True
					else:
						specialbooking = False
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype).first()
					if vehicletype_obj:
						print('5')
						try:
							distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
							if distancetable_obj:
								distance = distancetable_obj.distance

										# distance = totaldistanceinmiles
								if distance <= vehicletype_obj.fixeddistance:
									rate = vehicletype_obj.baserate
								else:
									rate = vehicletype_obj.baserate
									print('\n')
									print(vehicletype_obj.name)
									print(rate)
									distance = distance - vehicletype_obj.fixeddistance
									# print(totaldistanceinmiles)
									if distance > int(distance):
										distance = int(distance) + 1
									else:
										distance = distance
									print(distance)
									print(vehicletype_obj.addittionalrateperunit)
									rate = rate + distance * vehicletype_obj.addittionalrateperunit
									print(rate)

								pass
						except Exception as e:
							print(e)
						try:
							specialbooking_charge = 0.0
							if specialbooking:
								backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
								if backendcontrol_obj:
									specialbooking_charge = backendcontrol_obj.price
						except Exception as e:
							print(e)
						last_customer_obj=CustomerJob.objects.last()
						prorityIdforParcel=last_customer_obj.priorityBaseIDForParcel
						prorityIdforParcel=prorityIdforParcel+1
						prorityIdforParcel=prorityandChecking(prorityIdforParcel)
						customerjob_obj = CustomerJob.objects.create(order = order_obj, sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, dropoffspecialnote = recipientspecialnote_val, deliveryduration = deliveryduration_val, length = length_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = rate, pickuptimeslot = pickuptimeslot_val, dropofftimeslot = dropofftimeslot_val,pickuptimeslotDate=pickuptimeslotDate_val,specialbooking = specialbooking, specialbooking_charge = specialbooking_charge,sameIdForParcelsDetails=sameIdForStoring,no_of_item_in_parcel=parcelItems,deliverySafePlace=parcelDeliverysafe,priorityBaseIDForParcel=prorityIdforParcel)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							CustomerJobDateTime.objects.create(job = customerjob_obj, payment_datetime = current_date)
						except Exception as e:
							print(e)
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							print('before generateqrcode function call')
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Selected Vehicle does not exist.'})
				try:
					sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
				except Exception as e:
					print(e)
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})

class CompanyPlaceOrder(APIView):
	'''This class is being used to save the customer job request details in the database'''
	
	def post(self, request, *args, **kwargs):
		print('\n\n')
		print('CompanyPlaceOrder API - in post')
		print('\n\n')
		# print(request.POST)
		print('\n\n')


		def generateqrcode(id_val):
			try:	
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					print('\n\n\n\n')
					print('directory exists')
					pass
				else:
					print('\n\n\n\n')
					print('directory not exists')
					os.umask(0)
					os.makedirs(filepath, mode=0o777)
					# os.mkdir(filepath, mode=0o777)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')
			except Exception as e:
				print(e)

		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.makedirs(filepath, mode=0o777)
				# os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')



		session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')
		ordertype = request.POST.get('ordertype')
		totalamount = request.POST.get('totalamount')
		parceldelivery_charges = request.POST.get('parceldelivery_charges')
		specialbooking_charges = request.POST.get('specialbooking_charges')
		vehicletype = request.POST.get('vehicletype')
		credits_to_be_used = request.POST.get('credits_to_be_used')
		

		try:
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					companydetail_obj = CompanyDetail.objects.filter(customer__email = customer_obj.email).first()
					if companydetail_obj:
						if companydetail_obj.credits - float(credits_to_be_used) < 0.0:
							return JsonResponse({'status_code': 400, 'status_message': 'Not enough credits in account.'})
					if ordertype == 'singledrop':
						ordertype = 1
					elif ordertype == 'multidrop':
						ordertype = 2
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Order type is required.'})
					order_obj = Order.objects.create(customer = customer_obj, ordertype = ordertype, totalamount = float(totalamount), parceldelivery_charges = float(parceldelivery_charges), specialbooking_charges = float(specialbooking_charges), isdeleted = False)
		except Exception as e:
			print(e)
		print('0')

		parcels_data = json.loads(parcels_data)
		print('1')
		print(totalamount)
		if payment_token:
			try:	
				print(payment_token)
				stripe.api_key = str(settings.STRIPE_KEY)
				charge = stripe.Charge.create(
				amount = int(float(totalamount)*100),
				currency = 'gbp',
				description = 'Parcel Payment',
				source = payment_token,
				)
				print(charge)
				OrderPayment.objects.create(order = order_obj, method = 'card', stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
			except Exception as e:
				print('Exception in creating charge = ', e)
		else:
			companydetail_obj = CompanyDetail.objects.filter(customer__email = customer_obj.email).first()
			if companydetail_obj:
				if companydetail_obj.credits - float(credits_to_be_used) >= 0.0:
					companydetail_obj.credits -= float(credits_to_be_used)
					companydetail_obj.save()
					orderpayment_obj = OrderPayment.objects.create(order = order_obj, method = 'credits', credits_to_be_used = float(credits_to_be_used))
					if orderpayment_obj:
						pass
						print('credits payment success')
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Internal Server Error.'})	
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Not enough credits in account.'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'Not enough credits in account.'})


		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')
		token_obj = Token.objects.filter(key = session_token_val).first()
		print('1')
		if token_obj:
			print('2')
			user_id = token_obj.user_id
			customer_obj = Customer.objects.filter(user__id = user_id).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print("count for manpreet")
					print('\n')
					print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['length'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = ''
					try:
						sendercity_val = parcel['sendercity']
					except Exception as e:
						print(e)
					# noofparcels_val = parcel['noofparcels']
					length_val = parcel['length']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']
					pickuptimeslot_val = parcel['pickuptimeslot']
					dropofftimeslot_val = parcel['dropofftimeslot']

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val = parcel['recipientlongitude']
					recipientspecialnote_val = parcel['recipientspecialnote']

					# vehicletype_val = parcel['vehicletype']
					# price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					specialbooking_val = parcel['specialbooking'] #in apis, we are taking this parameter outside
					if specialbooking_val == 'yes':
						specialbooking = True
					else:
						specialbooking = False
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype).first()
					if vehicletype_obj:
						print('5')
						try:
							distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
							if distancetable_obj:
								distance = distancetable_obj.distance

										# distance = totaldistanceinmiles
								if distance <= vehicletype_obj.fixeddistance:
									rate = vehicletype_obj.baserate
								else:
									rate = vehicletype_obj.baserate
									print('\n')
									print(vehicletype_obj.name)
									print(rate)
									distance = distance - vehicletype_obj.fixeddistance
									# print(totaldistanceinmiles)
									if distance > int(distance):
										distance = int(distance) + 1
									else:
										distance = distance
									print(distance)
									print(vehicletype_obj.addittionalrateperunit)
									rate = rate + distance * vehicletype_obj.addittionalrateperunit
									print(rate)

								pass
						except Exception as e:
							print(e)
						try:
							specialbooking_charge = 0.0
							if specialbooking:
								backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
								if backendcontrol_obj:
									specialbooking_charge = backendcontrol_obj.price
						except Exception as e:
							print(e)
						customerjob_obj = CustomerJob.objects.create(order = order_obj, sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, dropoffspecialnote = recipientspecialnote_val, deliveryduration = deliveryduration_val, length = length_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = rate, pickuptimeslot = pickuptimeslot_val, dropofftimeslot = dropofftimeslot_val, specialbooking = specialbooking, specialbooking_charge = specialbooking_charge)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							CustomerJobDateTime.objects.create(job = customerjob_obj, payment_datetime = current_date)
						except Exception as e:
							print(e)
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							print('before generateqrcode function call')
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Selected Vehicle does not exist.'})
				try:
					sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
				except Exception as e:
					print(e)
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		
		


class PlaceOrderTesExtraTest(APIView):
	'''This class is being used to save the customer job request details in the database'''
	
	def post(self, request, *args, **kwargs):
		print('\n\n')
		# print(request.POST)
		print('PlaceOrderTest API - in post')
		print('\n\n')
		print(request.POST)
		print('\n\n')
		print("1 test")
		def generateqrcode(id_val):
			try:	
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					print('\n\n\n\n')
					print('directory exists')
					pass
				else:
					print('\n\n\n\n')
					print('directory not exists')
					os.umask(0)
					os.makedirs(filepath, mode=0o777)
					# os.mkdir(filepath, mode=0o777)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')
			except Exception as e:
				print(e)
		print("2 test")
		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)+str(st)
			if(os.path.exists(filepath)):
				pass
				# filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				# for f in filesToRemove:
				# 	os.remove(f) 
			else:
				os.makedirs(filepath, mode=0o777)
				# os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id)+str(st) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')

		print("3 test")
		session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')
		ordertype = request.POST.get('ordertype')
		totalamount = request.POST.get('totalamount')
		parceldelivery_charges = request.POST.get('parceldelivery_charges')
		specialbooking_charges = request.POST.get('specialbooking_charges')
		vehicletype = request.POST.get('vehicletype')
		card_id = request.POST.get('card_id')
		# parcelItems = request.POST.get('parcelItems')
		# no_of_item_inParcel = request.POST.get('parcelItems')
		print(session_token_val)
		print(parcels_data)
		print(noofparcels_val)
		print(payment_token)
		print(totalamount)
		# print(request.POST.get('parcelItems'))
		# print(parcelItems)
		print("4 test")
		if not session_token_val:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
		if not parcels_data:
			return JsonResponse({'status_code': 400, 'status_message': 'parcels_data is required',})
		if not noofparcels_val:
			return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required',})
		if not ordertype:
			return JsonResponse({'status_code': 400, 'status_message': 'ordertype is required',})
		if not totalamount:
			return JsonResponse({'status_code': 400, 'status_message': 'totalamount is required',})
		print("5 test")
		if not parceldelivery_charges:
			return JsonResponse({'status_code': 400, 'status_message': 'parceldelivery_charges is required',})
		if not specialbooking_charges:
			return JsonResponse({'status_code': 400, 'status_message': 'specialbooking_charges is required',})
		if not vehicletype:
			return JsonResponse({'status_code': 400, 'status_message': 'vehicletype is required',})
		if not card_id:
			return JsonResponse({'status_code': 400, 'status_message': 'card_id is required',})
		print("6 test")
		# print(parcelItems)
		# if not parcelItems:
		# 	return JsonResponse({'status_code': 400, 'status_message': 'no_of_item_inParcel is required',})
		print("7 test")
		try:
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					if ordertype == 'singledrop':
						ordertype = 1
					elif ordertype == 'multidrop':
						ordertype = 2
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Order type is required.'})
					order_obj = Order.objects.create(customer = customer_obj, ordertype = ordertype, totalamount = float(totalamount), charge_from_card = card_id, parceldelivery_charges = float(parceldelivery_charges), specialbooking_charges = float(specialbooking_charges), isdeleted = False)
		except Exception as e:
			print(e)
		print('0')
		try:
			last_customer_obj=CustomerJob.objects.last()
			if last_customer_obj:
				if int(last_customer_obj.sameIdForParcelsDetails)==0:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1000
				else:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1
			else:
				sameIdForStoring=1000
		except Exception as e:
			pass
			print(e)
		parcels_data = json.loads(parcels_data)
		print('1')
		print("8 test")
		print(totalamount)
		# if payment_token:
		# 	try:	
		# 		print(payment_token)
		# 		stripe.api_key = str(settings.STRIPE_KEY)
		# 		charge = stripe.Charge.create(
		# 		amount = int(float(totalamount)*100),
		# 		currency = 'gbp',
		# 		description = 'Parcel Payment',
		# 		source = payment_token,
		# 		)
		# 		print(charge)
		# 		OrderPayment.objects.create(order = order_obj, stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
		# 	except Exception as e:
		# 		print('Exception in creating charge = ', e)
		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')
		token_obj = Token.objects.filter(key = session_token_val).first()
		print('1')
		if token_obj:
			print('2')
			user_id = token_obj.user_id
			customer_obj = Customer.objects.filter(user__id = user_id).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print('\n')
					print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['length'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					print(parcel['parcelItems'])
					print(parcel['parcelDeliver_Safe'])

					parcelItems=parcel['parcelItems']

					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = ''
					try:
						sendercity_val = parcel['sendercity']
					except Exception as e:
						print(e)
					# noofparcels_val = parcel['noofparcels']
					length_val = parcel['length']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']

					# pickuptimeslotDate_val = parcel['pickuptimeslot']
					pickuptimeslot_val = parcel['pickuptimeslot']
					dropofftimeslot_val = parcel['dropofftimeslot']
					parcelDeliverysafe1=parcel['parcelDeliver_Safe']
					parcelDeliverysafe=False
					if parcelDeliverysafe1 == '1':
						parcelDeliverysafe=True

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val = parcel['recipientlongitude']
					recipientspecialnote_val = parcel['recipientspecialnote']

					# vehicletype_val = parcel['vehicletype']
					# price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					specialbooking_val = parcel['specialbooking'] #in apis, we are taking this parameter outside
					if specialbooking_val == 'yes':
						specialbooking = True
					else:
						specialbooking = False
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype).first()
					if vehicletype_obj:
						print('5')
						try:
							distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
							if distancetable_obj:
								distance = distancetable_obj.distance
										# distance = totaldistanceinmiles
								if distance <= vehicletype_obj.fixeddistance:
									rate = vehicletype_obj.baserate
								else:
									rate = vehicletype_obj.baserate
									print('\n')
									print(vehicletype_obj.name)
									print(rate)
									distance = distance - vehicletype_obj.fixeddistance
									# print(totaldistanceinmiles)
									if distance > int(distance):
										distance = int(distance) + 1
									else:
										distance = distance
									print(distance)
									print(vehicletype_obj.addittionalrateperunit)
									rate = rate + distance * vehicletype_obj.addittionalrateperunit
									print(rate)
								pass
						except Exception as e:
							print(e)
						try:
							specialbooking_charge = 0.0
							if specialbooking:
								backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
								if backendcontrol_obj:
									specialbooking_charge = backendcontrol_obj.price
						except Exception as e:
							print(e)
						last_customer_obj=CustomerJob.objects.last()
						if last_customer_obj:
							prorityIdforParcel=last_customer_obj.priorityBaseIDForParcel
							prorityIdforParcel=prorityIdforParcel+1
							prorityIdforParcel=prorityandChecking(prorityIdforParcel)
						else:
							prorityIdforParcel=1
						customerjob_obj = CustomerJob.objects.create(order = order_obj, sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, dropoffspecialnote = recipientspecialnote_val, deliveryduration = deliveryduration_val, length = length_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = rate, pickuptimeslot = pickuptimeslot_val, dropofftimeslot = dropofftimeslot_val,pickuptimeslotDate=pickuptimeslot_val, specialbooking = specialbooking, specialbooking_charge = specialbooking_charge,sameIdForParcelsDetails=sameIdForStoring,no_of_item_in_parcel=parcelItems,deliverySafePlace=parcelDeliverysafe,priorityBaseIDForParcel=prorityIdforParcel)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							CustomerJobDateTime.objects.create(job = customerjob_obj, payment_datetime = current_date)
						except Exception as e:
							print(e)
						try:
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						
						if imagebase64_val:
							# try:
							# 	image=imagebase64_val
							# 	filename = image.name
							# 	filename = filename.split('.')
							# 	extension = str(filename[-1])
							# 	image_data = BytesIO(image.read())
							# 	img = Image.open(image_data)
							# 	st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
							# 	filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)+str(st)
							# 	if(os.path.exists(filepath)):
							# 		pass
							# 		# filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
							# 		# for f in filesToRemove:
							# 		# 	os.remove(f) 
							# 	else:
							# 		os.makedirs(filepath, mode=0o777)
							# 	img = Image.open(image_data)
							# 	img.save(filepath+'/'+ 'parcelimage.'+extension)
							# 	filename = '/media/CustomerJobs/'+str(customerjob_obj.id)+str(st)+ '/'+ 'parcelimage.'+extension
							# except Exception as e:
							# 	print(e)
							# codec = 'data:image/png;base64,' + imagebase64_val
							# print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							print('before generateqrcode function call')
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Selected Vehicle does not exist.'})
				try:
					sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
				except Exception as e:
					print(e)
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		
		# print('data is  : ',request.POST)
		try:
			# print(request.POST)
			
			def generateqrcode(id_val):
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					pass
				else:
					os.mkdir(filepath)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')


			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				base64_data = codec.split(";base64,")
				extens = base64_data[0]
				ext = extens.split("/")
				extension = str(ext[1])
				base64_data = base64_data[1]
				byte_data = base64.b64decode(base64_data)
				image_data = BytesIO(byte_data)
				from PIL import Image
				import string, random, os
				img = Image.open(image_data)
				customerjob_obj = CustomerJob.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.mkdir(filepath)
				img = Image.open(image_data)
				im = img.thumbnail([400,400], Image.ANTIALIAS)
				im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
				customerjob_obj.image = filename
				customerjob_obj.save()
				return('1')



			session_token_val = request.POST.get('session_token')
			payment_token = request.POST.get('payment_token')
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			senderlatitude_val = request.POST.get('senderlatitude')
			senderlongitude_val = request.POST.get('senderlongitude')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')
			recipientspecialnote_val = request.POST.get('recipientspecialnote')
			recipientlatitude_val = request.POST.get('recipientlatitude')
			recipientlongitude_val = request.POST.get('recipientlongitude')

			vehicletype_val = request.POST.get('vehicletype')
			price_val = request.POST.get('price')
			imagebase64_val = request.POST.get('imagebase64')
			
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			# if not payment_token:
			# 	return Response({'status': 0, 'message': 'payment_token Empty',})
			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			if not sendercountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender senderphone_val is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})

			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype_val is required'})
			if not price_val:
				return JsonResponse({'status_code': 400, 'status_message': 'price_val is required'})
			# if not imagebase64_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'Image is required'})
			
			if payment_token:
				try:	
					print(payment_token)
					stripe.api_key = 'sk_test_w82uzdTc8eWEVizgPOI0WRnj00n43jBnY5'
					# str(settings.STRIPE_KEY)
					charge = stripe.Charge.create(
					amount=int(float(price_val)*100),
					currency='gbp',
					description='Parcel Payment',
					source=payment_token,
					)
					print(charge)
				except Exception as e:
					print('Exception in creating charge = ', e)
			deliveryduration_val = 1
			print('0')
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					print('4')
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype_val).first()
					if vehicletype_obj:
						print('5')
						customerjob_obj = CustomerJob.objects.create(sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = price_val)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': customerjob_obj.id})	
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})	
			user_obj = User.objects.filter(username = 'raheja@yopmail.com').first()
			if user_obj:
				pass	
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			
			token_obj = Token.objects.filter()

			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj, accountapproved = True).first()
				if customer_obj:
					# content_object = customer_obj,
					otp_obj = OTP.objects.filter(case = 'signup',otp = otp_val).last()
					if otp_obj:
						st_time = otp_obj.startdatetime
						ex_time = otp_obj.expiredatetime
						print(st_time)
						print(ex_time)
						timezone = str(settings.TIME_ZONE)
						time = datetime.datetime.now(pytz.timezone(timezone))
						print(time)
						if((time>st_time) and (time<ex_time)):
							otp_obj.verified = True
							otp_obj.save()
							return JsonResponse({'status_code': 200, 'status_message': 'User registered successfully.'})							
						else:
							return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired 1'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
				
			else:
				return JsonResponse({'status_code': 401, 'status_message': 'User not logged in.'})
				
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})




class PlaceOrderTest(APIView):
	'''This class is being used to save the customer job request details in the database'''
	
	def post(self, request, *args, **kwargs):
		print('\n\n')
		print('PlaceOrderTest API - in post')
		print('\n\n')
		# print(request.POST)
		print('\n\n')


		def generateqrcode(id_val):
			try:	
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					print('\n\n\n\n')
					print('directory exists')
					pass
				else:
					print('\n\n\n\n')
					print('directory not exists')
					os.umask(0)
					os.makedirs(filepath, mode=0o777)
					# os.mkdir(filepath, mode=0o777)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')
			except Exception as e:
				print(e)

		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.makedirs(filepath, mode=0o777)
				# os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')



		session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')
		ordertype = request.POST.get('ordertype')
		totalamount = request.POST.get('totalamount')
		parceldelivery_charges = request.POST.get('parceldelivery_charges')
		specialbooking_charges = request.POST.get('specialbooking_charges')
		vehicletype = request.POST.get('vehicletype')
		card_id = request.POST.get('card_id')
		if not session_token_val:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
		if not parcels_data:
			return JsonResponse({'status_code': 400, 'status_message': 'parcels_data is required',})
		if not noofparcels_val:
			return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required',})
		if not ordertype:
			return JsonResponse({'status_code': 400, 'status_message': 'ordertype is required',})
		if not totalamount:
			return JsonResponse({'status_code': 400, 'status_message': 'totalamount is required',})
		if not parceldelivery_charges:
			return JsonResponse({'status_code': 400, 'status_message': 'parceldelivery_charges is required',})
		if not specialbooking_charges:
			return JsonResponse({'status_code': 400, 'status_message': 'specialbooking_charges is required',})
		if not vehicletype:
			return JsonResponse({'status_code': 400, 'status_message': 'vehicletype is required',})
		if not card_id:
			return JsonResponse({'status_code': 400, 'status_message': 'card_id is required',})
		
		try:
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					if ordertype == 'singledrop':
						ordertype = 1
					elif ordertype == 'multidrop':
						ordertype = 2
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Order type is required.'})
					order_obj = Order.objects.create(customer = customer_obj, ordertype = ordertype, totalamount = float(totalamount), charge_from_card = card_id, parceldelivery_charges = float(parceldelivery_charges), specialbooking_charges = float(specialbooking_charges), isdeleted = False)
		except Exception as e:
			print(e)
		print('0')

		parcels_data = json.loads(parcels_data)
		print('1')
		print(totalamount)
		# if payment_token:
		# 	try:	
		# 		print(payment_token)
		# 		stripe.api_key = str(settings.STRIPE_KEY)
		# 		charge = stripe.Charge.create(
		# 		amount = int(float(totalamount)*100),
		# 		currency = 'gbp',
		# 		description = 'Parcel Payment',
		# 		source = payment_token,
		# 		)
		# 		print(charge)
		# 		OrderPayment.objects.create(order = order_obj, stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
		# 	except Exception as e:
		# 		print('Exception in creating charge = ', e)
		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')
		token_obj = Token.objects.filter(key = session_token_val).first()
		print('1')
		if token_obj:
			print('2')
			user_id = token_obj.user_id
			customer_obj = Customer.objects.filter(user__id = user_id).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print('\n')
					print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['length'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = ''
					try:
						sendercity_val = parcel['sendercity']
					except Exception as e:
						print(e)
					# noofparcels_val = parcel['noofparcels']
					length_val = parcel['length']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']
					pickuptimeslot_val = parcel['pickuptimeslot']
					dropofftimeslot_val = parcel['dropofftimeslot']

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val = parcel['recipientlongitude']
					recipientspecialnote_val = parcel['recipientspecialnote']

					# vehicletype_val = parcel['vehicletype']
					# price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					specialbooking_val = parcel['specialbooking'] #in apis, we are taking this parameter outside
					if specialbooking_val == 'yes':
						specialbooking = True
					else:
						specialbooking = False
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype).first()
					if vehicletype_obj:
						print('5')
						try:
							distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
							if distancetable_obj:
								distance = distancetable_obj.distance
										# distance = totaldistanceinmiles
								if distance <= vehicletype_obj.fixeddistance:
									rate = vehicletype_obj.baserate
								else:
									rate = vehicletype_obj.baserate
									print('\n')
									print(vehicletype_obj.name)
									print(rate)
									distance = distance - vehicletype_obj.fixeddistance
									# print(totaldistanceinmiles)
									if distance > int(distance):
										distance = int(distance) + 1
									else:
										distance = distance
									print(distance)
									print(vehicletype_obj.addittionalrateperunit)
									rate = rate + distance * vehicletype_obj.addittionalrateperunit
									print(rate)
								pass
						except Exception as e:
							print(e)
						try:
							specialbooking_charge = 0.0
							if specialbooking:
								backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
								if backendcontrol_obj:
									specialbooking_charge = backendcontrol_obj.price
						except Exception as e:
							print(e)
						customerjob_obj = CustomerJob.objects.create(order = order_obj, sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, dropoffspecialnote = recipientspecialnote_val, deliveryduration = deliveryduration_val, length = length_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = rate, pickuptimeslot = pickuptimeslot_val, dropofftimeslot = dropofftimeslot_val, specialbooking = specialbooking, specialbooking_charge = specialbooking_charge)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							CustomerJobDateTime.objects.create(job = customerjob_obj, payment_datetime = current_date)
						except Exception as e:
							print(e)
						try:
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							print('before generateqrcode function call')
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Selected Vehicle does not exist.'})
				try:
					sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
				except Exception as e:
					print(e)
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		
		# print('data is  : ',request.POST)
		try:
			# print(request.POST)
			
			def generateqrcode(id_val):
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					pass
				else:
					os.mkdir(filepath)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')


			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				base64_data = codec.split(";base64,")
				extens = base64_data[0]
				ext = extens.split("/")
				extension = str(ext[1])
				base64_data = base64_data[1]
				byte_data = base64.b64decode(base64_data)
				image_data = BytesIO(byte_data)
				from PIL import Image
				import string, random, os
				img = Image.open(image_data)
				customerjob_obj = CustomerJob.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.mkdir(filepath)
				img = Image.open(image_data)
				im = img.thumbnail([400,400], Image.ANTIALIAS)
				im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
				customerjob_obj.image = filename
				customerjob_obj.save()
				return('1')



			session_token_val = request.POST.get('session_token')
			payment_token = request.POST.get('payment_token')
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			senderlatitude_val = request.POST.get('senderlatitude')
			senderlongitude_val = request.POST.get('senderlongitude')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')
			recipientspecialnote_val = request.POST.get('recipientspecialnote')
			recipientlatitude_val = request.POST.get('recipientlatitude')
			recipientlongitude_val = request.POST.get('recipientlongitude')

			vehicletype_val = request.POST.get('vehicletype')
			price_val = request.POST.get('price')
			imagebase64_val = request.POST.get('imagebase64')
			
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			# if not payment_token:
			# 	return Response({'status': 0, 'message': 'payment_token Empty',})
			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			if not sendercountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender senderphone_val is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})

			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype_val is required'})
			if not price_val:
				return JsonResponse({'status_code': 400, 'status_message': 'price_val is required'})
			# if not imagebase64_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'Image is required'})
			
			if payment_token:
				try:	
					print(payment_token)
					stripe.api_key = 'sk_test_w82uzdTc8eWEVizgPOI0WRnj00n43jBnY5'
					# str(settings.STRIPE_KEY)
					charge = stripe.Charge.create(
					amount=int(float(price_val)*100),
					currency='gbp',
					description='Parcel Payment',
					source=payment_token,
					)
					print(charge)
				except Exception as e:
					print('Exception in creating charge = ', e)
			deliveryduration_val = 1
			print('0')
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					print('4')
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype_val).first()
					if vehicletype_obj:
						print('5')
						customerjob_obj = CustomerJob.objects.create(sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = price_val)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': customerjob_obj.id})	
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})	
			user_obj = User.objects.filter(username = 'raheja@yopmail.com').first()
			if user_obj:
				pass	
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			
			token_obj = Token.objects.filter()

			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj, accountapproved = True).first()
				if customer_obj:
					# content_object = customer_obj,
					otp_obj = OTP.objects.filter(case = 'signup',otp = otp_val).last()
					if otp_obj:
						st_time = otp_obj.startdatetime
						ex_time = otp_obj.expiredatetime
						print(st_time)
						print(ex_time)
						timezone = str(settings.TIME_ZONE)
						time = datetime.datetime.now(pytz.timezone(timezone))
						print(time)
						if((time>st_time) and (time<ex_time)):
							otp_obj.verified = True
							otp_obj.save()
							return JsonResponse({'status_code': 200, 'status_message': 'User registered successfully.'})							
						else:
							return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired 1'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
				
			else:
				return JsonResponse({'status_code': 401, 'status_message': 'User not logged in.'})
				
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})



class Test(APIView):
	'''This class is used for login process for company or customer users'''
	def get(self, request, *args, **kwargs):
		try:
			print('Test API - in get')
			# import pdfkit
			# pdfkit.from_url('http://google.com','google.pdf')
			

			drivers = DriverModel.objects.filter(isdisabled = False, emailverified = True)
			print(drivers)
			if drivers:
				for driver in drivers:
					# current_date = datetime.datetime.now().date()
					yesterday_date = (datetime.datetime.now() - timedelta(days = 1)).date()
					yesterday_date = datetime.datetime.combine(yesterday_date, datetime.datetime.min.time())
					print(yesterday_date)
					# print(current_date)
					# driverjob_obj = DriverJob.objects.filter(driver = driver, created_at = current_date).count()
					# print(driverjob_obj)
					driverjob_obj = DriverJob.objects.filter(driver = driver).filter(created_at__gte = yesterday_date).count()
					print(driverjob_obj)
					print(DriverJob.objects.all().order_by('-created_at')[0])
					break


			return JsonResponse({'status_code': 200, 'status_message' : 'success'})
			res = generateparcelpdf(247)
			print(res)
			return JsonResponse({'status_code': 200, 'status_message' : 'success'})
			from telesign.messaging import MessagingClient

			# # customer_id = str(settings.)



			# customer_id = 'CAC2B989-9F06-4316-9BDE-94ADABF1DF6B'

			customer_id = '20158A81-3357-414B-A605-82EEF14E0ACD' # client - live

			# api_key = "whfmfSWJydAyZ2RBCKcCjr4L+8pCDgpKbaiOHsc8YXhGqsSLCOFnstMjMMpGT8fm2ZwODxRYmFq83I6O2JHL0g=="
			api_key = "M/Uts+7ollgrq0oGkaNtTu3k45ZYi/SK+u+5QpFuvFOLZU+NAZcYeaRFkPmit1FQH9ThrS0cCs+k2Ey5UawsOA==" # client - live

			phone_number = "919255568967"
			message = "Hello, this is a test message"
			message_type = "ARN"
			message_type = "OTP"

			messaging = MessagingClient(customer_id, api_key)
			print(messaging)
			response = messaging.message(phone_number, message, message_type)
			print(type(response))
			print(response.json)
			# server_key = str(settings.FIREBASE_SERVER_KEY)

			# server_key = 'AAAA5-TDUdg:APA91bG1Za_SqVuUDn3ZcqfAeelG76kvXmkOA_wN0tGU-OQg0LKA5GzDX_aYcP8StTTOKohjQXkWslYJRfnZGYMkygM_qCjtc_heesrg8ubPWha8C4pqgg9t8253RA7jAPbcA9H74_sk'
			# 		# customer_fcmtoken='f7qxT-icg8I:APA91bEF7aG6QvR2HqUyvS7X8ngBz4nk_i9aBHoOcqAdoytc2STcsi26iVFzbY_hICiCd4UiF1GwqDZV5_Eekf8vDNxFKI4sG5HAQWYKV-bZ2Vn4aOEIiKomcI0i6o6tjs6WCAfvhEGa'
			# fcm_token = 'fvAUR5HPo1g:APA91bEC8q_0bt2rrXljTq5ZtMGDRhIyJ4XEs83AUziMRWkHwDZwEJfpfYtncoTxSxdWrhRSmVeR6f9ZZJFu36JMXJQrPqPyLNqIixUoUL0c_kqNWpAFiX9UQnOfQdZxKC1W2DcCsjoB'
			# message_title = 'Title'
			# message_body = 'Body'
			# data_message = {
			# 			"app":'normal',
			# 			'type':'profile',
			# 			"sendparcel": 'no',
			# 			'title' : 'Airdely', # these are being used at API end
			# 			"message" : 'Your profile is updated successfully',
			# 		}

			# result = FCMNotification(api_key=server_key).notify_single_device(registration_id=fcm_token, message_title=message_title, message_body=message_body, data_message=data_message)
			# print(result)

			


			# from django.template.loader import get_template 
			# from django.core.mail import EmailMultiAlternatives
			# templates = str(settings.BASE_DIR) + '/AdminApp/templates/emailtemplates/newuser.html'
			# plaintext = 'email.txt'
			# htmly = get_template(templates)
			# print(htmly)
			# d = {'name' : 'Varis Raheja'}
			# subject, from_email, to = 'subject', settings.EMAIL_HOST_USER, 'test@yopmail.com'
			# html_content = htmly.render(d)
			# msg = EmailMultiAlternatives(subject, 'text_content', from_email, [to])
			# msg.attach_alternative(html_content, "text/html")
			# res = msg.send()
			# print(res)

			# def send_mail_from_adminsection(senderemail, recipientemail, sub):	
			# 	from email.mime.text import MIMEText
			# 	from email.mime.multipart import MIMEMultipart
			# 	from django.conf import settings
			# 	import smtplib, ssl
			# 	print('#'*25)
			# 	port = 587  # For starttls
			# 	smtp_server = "mail.gmail.com"
			# 	sender_email = senderemail
			# 	receiver_email = recipientemail
			# 	password = "python#0143"
				
			# 	message = MIMEMultipart("alternative")
			# 	message["Subject"] = sub
			# 	message["From"] = sender_email
			# 	message["To"] = receiver_email
			# 	print('before html')
			# 	html = """

			# 	"""
			# 	print('after html')
			# 	# part1 = MIMEText(text, "plain")
			# 	part2 = MIMEText(html, "html")
			# 	# message.attach(part1)
			# 	message.attach(part2)
				
			# 	print('1')
			# 	# context = ssl.create_default_context()
			# 	print('2')
			# 	try:
			# 		server = smtplib.SMTP('localhost')
			# 		print(type(server))
			# 		aa=server.login(sender_email, password)
			# 		# msg = ("From: contact@airdely.com\r\nTo: "+emailid+"\r\n\r\n"+message)
			# 		server.sendmail(sender_email, receiver_email, message.as_string())
			# 		print("Email has been sent succesfully")
			# 	except Exception as e:
			# 		print(e)
			# 	finally:
			# 		server.quit() 	


			# send_mail_from_adminsection(str(settings.EMAIL_HOST_USER),'test@yopmail.com', 'TEST_SUBJECT')
			# senderemail, recipientemail, subject, username, useremail, userpassword, loginurl
			# re = sendnewusermail(senderemail = str(settings.EMAIL_HOST_USER), recipientemail = 'test@yopmail.com', subject = 'TEST_SUBJECT', username = 'Varis Raheja', useremail = 'varisraheja@gmail.com', userpassword = 'Qaz@1234', loginurl = str(settings.WEB_BASE_URL)+'/login/')
			# print(re)
			return JsonResponse({'status_code': 200, 'status_message' : 'success'})
		except Exception as error:
			print('error is',error)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})
	def post(self, request, *args, **kwargs):
		try:
			print('Test - post')
			customerjobid = request.POST.get('customerjobid')
			res = generateparcelpdf(customerjobid)
			print(res)
			return JsonResponse({'status_code': 200, 'status_message' : 'success'})
			from math import radians, cos, sin, asin, sqrt
			context = {}
			data = []
			tracking_data = []
			# driverid = kwargs['driverid']
			driverid = 5
			driver_obj = DriverModel.objects.filter(id = driverid).first()
			if driver_obj:
				driverlatitude, driverlongitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
				if drivercoordinates_obj:
					# print('drivercoordinates_obj exists')
					driverlatitude = drivercoordinates_obj.latitude
					driverlongitude = drivercoordinates_obj.longitude
				else:
					print('drivercoordinates_obj does not exist')
				driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False)
				picked_tracking_data = [] 
				for driverjob in driverjobs_obj:
					print(driverjob.customerjob.id)
					status = 'Assigned'
					if driverjob.jobstarted or driverjob.jobcompleted: 
						if driverjob.jobcompleted:
							status = 'Completed'
						elif driverjob.jobstarted:
							status = 'Picked Up'
					print(status)
					if status == 'Picked Up' or status == 'Assigned':
						data.append({
							'sendername' : driverjob.customerjob.sendername,
							'senderemail' : driverjob.customerjob.senderemail,
							'senderphone' : driverjob.customerjob.senderphone,
							'senderpickupaddress' : driverjob.customerjob.pickupaddress,
							'senderlatitude' : driverjob.customerjob.senderlatitude,
							'senderlongitude' : driverjob.customerjob.senderlongitude,
							'recipientname' : driverjob.customerjob.recipientname,
							'recipientdropoffaddress' : driverjob.customerjob.dropoffaddress,
							'recipientlatitude' : driverjob.customerjob.recipientlatitude,
							'recipientlongitude' : driverjob.customerjob.recipientlongitude,

							'customerjobid' : driverjob.customerjob.id,
							'status' : status,
							'id' : driverjob.id,
							})

					
					if status == 'Picked Up':
						customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = driverjob.customerjob).first()
						if customerjobdatetime_obj:
							picked_tracking_data.append({
								'type' : 'pickup',
								'customerjobid' : driverjob.customerjob.id,
								'address' : driverjob.customerjob.pickupaddress,
								'pickup_datetime' : customerjobdatetime_obj.pickup_datetime,
								'latitude' : driverjob.customerjob.senderlatitude,
								'longitude' : driverjob.customerjob.senderlongitude,
								'typeplusaddress' : '<b>Pickup:</b> ' + driverjob.customerjob.pickupaddress,
								})
							# print(picked_tracking_data)
						else:
							print('pickup_datetime does not exist')
				picked_tracking_data_sorted = sorted(picked_tracking_data, key = lambda i: i['pickup_datetime'], reverse = False)
				print(picked_tracking_data_sorted)

				return JsonResponse({'status_code': 200, 'status_message' : 'success'})
				if True:
					if status == 'Picked Up' or status == 'Assigned':
						tracking_data.append({
							'type' : 'pickup',
							'address' : driverjob.customerjob.pickupaddress,
							'latitude' : driverjob.customerjob.senderlatitude,
							'longitude' : driverjob.customerjob.senderlongitude,
							'typeplusaddress' : '<b>Pickup:</b> ' + driverjob.customerjob.pickupaddress,
							})

						tracking_data.append({
							'type' : 'dropoff',
							'address' : driverjob.customerjob.dropoffaddress,
							'latitude' : driverjob.customerjob.recipientlatitude,
							'longitude' : driverjob.customerjob.recipientlongitude,
							'typeplusaddress' : '<b>Dropoff:</b> ' + driverjob.customerjob.dropoffaddress,
							
							})
					# print(data)
					

				tracking_data.append({
					'type' : 'driverlocation',
					'address' : 'Start',
					'latitude' : driverlatitude,
					'longitude' : driverlongitude,
					'typeplusaddress' : '<b>Start</b>'
					
					})

				context['all_driverjobs'] = data
				context['driverlatitude'] = driverlatitude
				context['driverlongitude'] = driverlongitude
				print(len(tracking_data))
				def haversine(lat1, lon1, lat2, lon2):
					lat1, lon1, lat2, lon2 = map(float, [lat1, lon1, lat2, lon2])# haversine formula 
					lat1, lon1, lat2, lon2 = map(radians, [lat1, lon1, lat2, lon2])# haversine formula 
					dlon = lon2 - lon1 
					dlat = lat2 - lat1 
					a = sin(dlat/2)**2 + cos(lat1) * cos(lat2) * sin(dlon/2)**2
					c = 2 * asin(sqrt(a)) 
					r = 6371 # Radius of earth in kilometers. Use 3956 for miles
					return (c * r)

				for location in tracking_data:
					distance_fromdriverlocation = haversine(driverlatitude, driverlongitude, location['latitude'], location['longitude'])
					location['distance_fromdriverlocation'] = distance_fromdriverlocation

				tracking_data = sorted(tracking_data, key = lambda i: i['distance_fromdriverlocation'], reverse = False)
				print('\n\n')
				for location in tracking_data:
					print(location['address'] + '  --  ' + str(location['distance_fromdriverlocation']))
				print('\n\n')
				context['tracking_data'] = tracking_data
			# return context

			return JsonResponse({'status_code': 200, 'status_message' : 'success'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})




class SendSupportQuery(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('SendSupportQuery - post ')

		print('data is  : ',request.POST)
		try:
			session_token_val = request.POST.get('session_token')
			query_val = request.POST.get('query')
			if not query_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter query',})
			message = query_val
			try:
				print(message)
				res = send_mail('Help and Support:',message,'tmpython4esf@gmail.com',['test@yopmail.com'],fail_silently=False)
				print(res)
				return JsonResponse({'status_code': 200, 'status_message' : 'Request sent.'})
			except Exception as e:
				print(e)
			
		
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})





class ChangePassword(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\naa')
		print('data is  : ',request.POST)
		try:
			session_token_val = request.POST.get('session_token')
			userrole_val = request.POST.get('userrole')
			oldpassword_val = request.POST.get('oldpassword')
			newpassword_val = request.POST.get('newpassword')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			if not oldpassword_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter old password',})
			if not newpassword_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter new password',})
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				print(token_obj.user_id)
				user_obj = User.objects.get(id = token_obj.user_id)
				
				if user_obj.check_password(oldpassword_val):
					print('correct password')
					user_obj.password = make_password(newpassword_val)
					user_obj.save()
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'passwordchange', 'KwickDelivery', 'Your password is updated successfully')
						except Exception as e:
							print(e)
					return JsonResponse({'status_code': 200, 'status_message': 'success',})
					
				else:
					print('invalid password')
					return JsonResponse({'status_code': 400, 'status_message': 'Current password is incorrect',})

			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})


class GetUnreadNotificationsCount(APIView):
	
	def get(self, request, *args, **kwargs):
		'''This function shows the content on customer dashboard screen'''
		print("GetUnreadNotificationsCount - in get ")

		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				result, count = getunreadnotificationcount(token_obj.user_id)
				if result == 'success':
					print(count)
				elif result == 'error':
					print(count)
				return JsonResponse({'status_code': 200, 'unread_notifications_count' : count, 'status_message': 'success',})		
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})		
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})

class CustomerNotifications(APIView):
	
	def get(self, request, *args, **kwargs):
		'''This function shows the content on customer dashboard screen'''
		print("CustomerNotifications - in get ")

		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					notifications_data = []
					all_notifications = Notifications.objects.filter(user = user_obj, deleted = False).order_by('-id')
					if all_notifications:
						for notification in all_notifications:
							notifications_data.append({
								'id' : notification.id,
								'forcustomer' : notification.forcustomer,
								'notificationtype' : notification.notificationtype,
								'notificationtext' : notification.notificationtext,
								'customerjobid' : notification.customerjobid,
								'status' : notification.status,
								'date' : notification.date,
								})
						return JsonResponse({ 'status_code': 200 , 'data' : notifications_data, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})		
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})

class GetParcelWeights(APIView):
	'''This class is used to get all vehicle types '''
	def get(self, request, *args, **kwargs):
		try:
			print('GetParcelWeights API - in get')
			data = []
			allvehicletypes = VehicleType.objects.filter(isdeleted = False)
			
			data.append({
				'id' : 1,
				'weight' : 'Less than 5 kg',
				})
			data.append({
				'id' : 2,
				'weight' : 'More than 5 kg but less than 20 kg',
				})
			data.append({
				'id' : 3,
				'weight' : 'More than 20 kg but less than 50 kg',
				})
			data.append({
				'id' : 4,
				'weight' : 'More than 50 kg',
				})

			print(data)
			return JsonResponse({'status_code': 200, 'status_message' : 'success', 'data' : data})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})



class GetVehicleTypes(APIView):
	'''This class is used to get all vehicle types '''
	def get(self, request, *args, **kwargs):
		try:
			print('GetVehicleTypes API - in get')
			data = []
			allvehicletypes = VehicleType.objects.filter(isdeleted = False)
			if allvehicletypes:
				for vehicletype in allvehicletypes:
					data.append({
						'vehicletypeid' : vehicletype.id,
						'vehicletype' : vehicletype.name,
						'vehicleimage' : str(settings.WEB_BASE_URL) + '/static/images/bike.png'
						})

			print(data)
			return JsonResponse({'status_code': 200, 'status_message' : 'success', 'data' : data})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})

class QuickFareEstimate(APIView):
	'''This class is used for login process for company or customer users'''
	def post(self, request, *args, **kwargs):
		try:
			print('QuickFareEstimate API - in post')
			
			def getquickfareforvehicletype(pickupaddress_val, dropaddress_val, vehicletype_val, sendercoordinates_val, recipientcoordinates_val):
				data = {}
				try:

					api_key = str(settings.GOOGLE_API_KEY)

					pickupaddress_val = pickupaddress_val.replace(' ','')
					pickupaddress_val = pickupaddress_val.replace('#','')
					dropaddress_val = dropaddress_val.replace(' ','')
					dropaddress_val = dropaddress_val.replace('#','')
					source = pickupaddress_val

					dest = dropaddress_val

					url ='https://maps.googleapis.com/maps/api/distancematrix/json?'
					if sendercoordinates_val and recipientcoordinates_val:
					# return response object 
						print(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
						r = requests.get(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
					else:
						print(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)
						r = requests.get(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

					# return response object 
					
					x = r.json() 
					print(x) 
					print('\n')
					if x['status'] == 'OK':
						multiplicationfactor = 0.000621371192
						distanceinmiles = float(x['rows'][0]['elements'][0]['distance']['value']) * multiplicationfactor
						# print(distanceinmiles)
						vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', name = vehicletype_val).first()
						if vehicletype_obj:
							distance = distanceinmiles
							if distance <= vehicletype_obj.fixeddistance:
								rate = vehicletype_obj.baserate
							else:
								rate = vehicletype_obj.baserate
								distance = distance - vehicletype_obj.fixeddistance
								if distance > int(distance):
									distance = int(distance) + 1
								else:
									distance = distance
								rate = rate + distance * vehicletype_obj.addittionalrateperunit
								
							image = str(settings.WEB_BASE_URL)
							if vehicletype_obj.name == 'Bike':
								image += '/static/images/bike.png'
							elif vehicletype_obj.name == 'Car':
								image += '/static/images/car.jpg'
							elif vehicletype_obj.name == 'smallvan':
								image += '/static/images/smallvan.png'
							elif vehicletype_obj.name == 'mediumvan':
								image += '/static/images/smallvan.png'
							elif vehicletype_obj.name == 'largevan':
								image += '/static/images/largevan.jpg'
							
								
							data.update({"vehicletype" : vehicletype_obj.name, 'price' : str(round(float(rate),2)), 'currency' : vehicletype_obj.currency, 'image' : image})
						return(200, 'success', data)
					else:
						return(400, 'Enter valid address', data)
						
				except Exception as e:
					print(e)
					return(400, 'Enter valid address', data)

			pickupaddress_val = request.POST.get('pickupaddress')
			dropaddress_val = request.POST.get('dropaddress')
			vehicletype_val = request.POST.get('vehicletype')
			senderlatitude_val = request.POST.get('senderlatitude')
			senderlongitude_val = request.POST.get('senderlongitude')
			recipientlatitude_val = request.POST.get('recipientlatitude')
			recipientlongitude_val = request.POST.get('recipientlongitude')
			
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress is required'})
			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype is required'})
			sendercoordinates_val, recipientcoordinates_val = '', ''
			if senderlatitude_val and senderlongitude_val and recipientlatitude_val and recipientlongitude_val:
				sendercoordinates_val = senderlatitude_val + ',' + senderlongitude_val
				recipientcoordinates_val = recipientlatitude_val + ',' + recipientlongitude_val
			status_code, status_message, data = getquickfareforvehicletype(pickupaddress_val, dropaddress_val, vehicletype_val, sendercoordinates_val, recipientcoordinates_val)
			
			return JsonResponse({'status_code': status_code, 'status_message' : status_message, 'data' : data})
		except Exception as error:
			print('error is',error)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})


class GetParcelTypes(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get all parcel types'''
		try:
			
			allparceltypes = ParcelType.objects.filter(isdeleted = False)
			allparceltypes_data = []
			if allparceltypes:
				for parceltype in allparceltypes:
					allparceltypes_data.append({
						'parceltype' : parceltype.parceltype,
						'id' : parceltype.id,
						})

			return JsonResponse({ 'status_code': 200 , 'data' : allparceltypes_data,'status_message' : 'success' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})

#Create and Edit by manpreet singh 6/11/2020
class OngoingRequestsExtraTest(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			query=request.GET.get('query')
			if not query:
				query=''
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					print('0')
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						print('1')

						supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
						if supportdetail_obj:
							support_phone = supportdetail_obj.phone
						else:
							support_phone = ''
						customerjob_obj = CustomerJob.objects.filter(customer = customer_obj,isdeleted=False).order_by('-id')
						if customerjob_obj:
							print('2')
							print(len(customerjob_obj))
							unique=[]
							# all_customers=[]
							all_data_main_list=[]
							for jobIDs in customerjob_obj:
								if jobIDs.sameIdForParcelsDetails not in unique:
									unique.append(jobIDs.sameIdForParcelsDetails)
							for unique_id in unique:
								ongoingcustomerjobs_data = []
								for job in customerjob_obj:
									if job.sameIdForParcelsDetails == unique_id:
										try:
											awbnumber = 'AWB-' + str(10000 + job.id)
										except Exception as e:
											print(e)
											awbnumber = ''
										if not job.image:
											parcelimage = ''
										else:
											parcelimage = str(settings.WEB_BASE_URL) + job.image.name


										driverjob_data = {}
										driverexist = False
										parcelpicked = False
										driverjob_obj = DriverJob.objects.filter(customerjob = job).first()
										if driverjob_obj:
											driverexist = True
											# if driverjob_obj.jobstarted:
											# 	parcelpicked = True
											status = 'Driver have not yet Started Job'
											if driverjob_obj.jobstarted == True and driverjob_obj.arrived_at_pickup == False:
												status = 'Driver Started Job'
											elif driverjob_obj.arrived_at_pickup == True and driverjob_obj.parcel_picked_by_driver == False:
												status = 'Driver Arrived,Waiting For Pickup'
											elif driverjob_obj.parcel_picked_by_driver == True and driverjob_obj.arrived_atDropOffLocation == False:
												status = 'Out For Delivery,Start Drop Off Job'
											elif driverjob_obj.arrived_atDropOffLocation == True and driverjob_obj.jobcompleted == False:
												status = 'Arrived At Drop Off Location'
											elif driverjob_obj.parcel_picked_by_driver == True and driverjob_obj.jobcompleted == True:
												status = 'Delivered'
												parcelpicked = True

											# if job.customerjob.order.ordertype == 1:
											# 	ordertype = 'Single-Drop'
											# elif job.customerjob.order.ordertype == 2:
											# 	ordertype = 'Multi-Drop'
											if driverjob_obj.jobcompleted != True:
												if not driverjob_obj.driver.image.name:
													driverimage = ''
												else:
													driverimage = str(settings.WEB_BASE_URL) + driverjob_obj.driver.image.name
												driverjob_data.update({
													'drivername' : driverjob_obj.driver.name,
													'drivercountrycode' : driverjob_obj.driver.countrycode,
													'driverphone' : driverjob_obj.driver.phone,
													'driverid' : driverjob_obj.driver.id,
													'driverimage' : driverimage,
													})
												driverexist = True
												ongoingcustomerjobs_data.append({
													'senderlatitude' : job.senderlatitude,
													'senderlongitude' : job.senderlongitude,
													'recipientlatitude' : job.recipientlatitude,
													'recipientlongitude' : job.recipientlongitude,
													'sendername' : job.sendername,
													'senderphone' : job.senderphone,
													'senderpickupaddress' : job.pickupaddress,
													'recipientname' : job.recipientname,
													'recipientdropoffaddress' : job.dropoffaddress,
													'parcelimage' : parcelimage,
													'awbnumber' : awbnumber,
													'customerjobid' : job.id,
													'driverexist' : driverexist, 
													'parcelpicked' : parcelpicked,
													'driverdetails' : driverjob_data,
													'status':status,
													'isDisabled':job.isdisabled,
													'comment':job.comment_of_Parcel,


													})
										else:
											ongoingcustomerjobs_data.append({
												'senderlatitude' : job.senderlatitude,
												'senderlongitude' : job.senderlongitude,
												'recipientlatitude' : job.recipientlatitude,
												'recipientlongitude' : job.recipientlongitude,
												'sendername' : job.sendername,
												'senderphone' : job.senderphone,
												'senderpickupaddress' : job.pickupaddress,
												'recipientname' : job.recipientname,
												'recipientdropoffaddress' : job.dropoffaddress,
												'parcelimage' : parcelimage,
												'awbnumber' : awbnumber,
												'customerjobid' : job.id,
												'driverexist' : driverexist, 
												'parcelpicked' : parcelpicked,
												'driverdetails' : driverjob_data,
												'Same Package Id':job.sameIdForParcelsDetails,

												})
										if unique_id==0:
											all_data_main_list.append(ongoingcustomerjobs_data)
											ongoingcustomerjobs_data=[]
								all_data_main_list.append(ongoingcustomerjobs_data)
						if query != '':
							two=[]
							for all_data in all_data_main_list:
								one=[]
								for d in all_data:
									if (query in d['sendername']) or (query in d['senderphone']) or (query in d['recipientname']):
										one.append(d)
								if one:
									two.append(one)
							all_data_main_list=two
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : all_data_main_list, 'support_phone' : support_phone, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})

class OngoingRequests(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			ongoingcustomerjobs_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					print('0')
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						print('1')

						supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
						if supportdetail_obj:
							support_phone = supportdetail_obj.phone
						else:
							support_phone = ''
						customerjob_obj = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')
						if customerjob_obj:
							print('2')
							print(len(customerjob_obj))
							for job in customerjob_obj:
								try:
									awbnumber = 'AWB-' + str(10000 + job.id)
								except Exception as e:
									print(e)
									awbnumber = ''
								if not job.image:
									parcelimage = ''
								else:
									parcelimage = str(settings.WEB_BASE_URL) + job.image.name


								driverjob_data = {}
								driverexist = False
								parcelpicked = False
								driverjob_obj = DriverJob.objects.filter(customerjob = job).first()
								if driverjob_obj:
									driverexist = True
									if driverjob_obj.jobstarted:
										parcelpicked = True
									if driverjob_obj.jobcompleted != True:
										if not driverjob_obj.driver.image.name:
											driverimage = ''
										else:
											driverimage = str(settings.WEB_BASE_URL) + driverjob_obj.driver.image.name
										driverjob_data.update({
											'drivername' : driverjob_obj.driver.name,
											'drivercountrycode' : driverjob_obj.driver.countrycode,
											'driverphone' : driverjob_obj.driver.phone,
											'driverid' : driverjob_obj.driver.id,
											'driverimage' : driverimage,
											})
										driverexist = True
										ongoingcustomerjobs_data.append({
											'senderlatitude' : job.senderlatitude,
											'senderlongitude' : job.senderlongitude,
											'recipientlatitude' : job.recipientlatitude,
											'recipientlongitude' : job.recipientlongitude,
											'sendername' : job.sendername,
											'senderphone' : job.senderphone,
											'senderpickupaddress' : job.pickupaddress,
											'recipientname' : job.recipientname,
											'recipientdropoffaddress' : job.dropoffaddress,
											'parcelimage' : parcelimage,
											'awbnumber' : awbnumber,
											'customerjobid' : job.id,
											'driverexist' : driverexist, 
											'parcelpicked' : parcelpicked,
											'driverdetails' : driverjob_data,

											})
								else:
									ongoingcustomerjobs_data.append({
										'senderlatitude' : job.senderlatitude,
										'senderlongitude' : job.senderlongitude,
										'recipientlatitude' : job.recipientlatitude,
										'recipientlongitude' : job.recipientlongitude,
										'sendername' : job.sendername,
										'senderphone' : job.senderphone,
										'senderpickupaddress' : job.pickupaddress,
										'recipientname' : job.recipientname,
										'recipientdropoffaddress' : job.dropoffaddress,
										'parcelimage' : parcelimage,
										'awbnumber' : awbnumber,
										'customerjobid' : job.id,
										'driverexist' : driverexist, 
										'parcelpicked' : parcelpicked,
										'driverdetails' : driverjob_data,

										})
								
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : ongoingcustomerjobs_data, 'support_phone' : support_phone, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})


class OngoingRequestsTest(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			print('OngoingRequestsTest - in get')
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			
			supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
			if supportdetail_obj:
				support_phone = supportdetail_obj.phone
			else:
				support_phone = ''


			ongoingcustomerjobs_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					print('0')
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						print('1')
						order_obj = Order.objects.filter(customer = customer_obj, status = 0).order_by('-id')
						if order_obj:
							for order in order_obj:
								order_data = []
								customerjob_obj = CustomerJob.objects.filter(order = order, customer = customer_obj).order_by('-id')
								if customerjob_obj:
									print('2')
									print(len(customerjob_obj))
									for job in customerjob_obj:
										try:
											awbnumber = 'AWB-' + str(10000 + job.id)
										except Exception as e:
											print(e)
											awbnumber = ''
										if not job.image:
											parcelimage = ''
										else:
											parcelimage = str(settings.WEB_BASE_URL) + job.image.name


										driverjob_data = {}
										driverexist = False
										parcelpicked = False
										driverjob_obj = DriverJob.objects.filter(customerjob = job).first()
										if driverjob_obj:
											driverexist = True
											if driverjob_obj.jobstarted:
												parcelpicked = True
											if driverjob_obj.jobcompleted != True:
												if not driverjob_obj.driver.image.name:
													driverimage = ''
												else:
													driverimage = str(settings.WEB_BASE_URL) + driverjob_obj.driver.image.name
												driverjob_data.update({
													'drivername' : driverjob_obj.driver.name,
													'drivercountrycode' : driverjob_obj.driver.countrycode,
													'driverphone' : driverjob_obj.driver.phone,
													'driverid' : driverjob_obj.driver.id,
													'driverimage' : driverimage,
													})
												driverexist = True
												order_data.append({
													'senderlatitude' : job.senderlatitude,
													'senderlongitude' : job.senderlongitude,
													'recipientlatitude' : job.recipientlatitude,
													'recipientlongitude' : job.recipientlongitude,
													'sendername' : job.sendername,
													'senderphone' : job.senderphone,
													'senderpickupaddress' : job.pickupaddress,
													'recipientname' : job.recipientname,
													'recipientdropoffaddress' : job.dropoffaddress,
													'parcelimage' : parcelimage,
													'awbnumber' : awbnumber,
													'customerjobid' : job.id,
													'driverexist' : driverexist, 
													'parcelpicked' : parcelpicked,
													'driverdetails' : driverjob_data,

													})
										else:
											order_data.append({
												'senderlatitude' : job.senderlatitude,
												'senderlongitude' : job.senderlongitude,
												'recipientlatitude' : job.recipientlatitude,
												'recipientlongitude' : job.recipientlongitude,
												'sendername' : job.sendername,
												'senderphone' : job.senderphone,
												'senderpickupaddress' : job.pickupaddress,
												'recipientname' : job.recipientname,
												'recipientdropoffaddress' : job.dropoffaddress,
												'parcelimage' : parcelimage,
												'awbnumber' : awbnumber,
												'customerjobid' : job.id,
												'driverexist' : driverexist, 
												'parcelpicked' : parcelpicked,
												'driverdetails' : driverjob_data,

												})
									ongoingcustomerjobs_data.append(order_data)		
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : ongoingcustomerjobs_data, 'support_phone' : support_phone, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})




class CompletedRequestsExtraTest(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			
			query=request.GET.get('query')
			if not query:
				query=''
			completedcustomerjobs_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					print('0')
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						print('1')
						all_data_main_list=[]
						supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
						if supportdetail_obj:
							support_phone = supportdetail_obj.phone
						else:
							support_phone = ''
						customerjob_obj = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')
						if customerjob_obj:
							unique=[]
							for jobIDs in customerjob_obj:
								if jobIDs.sameIdForParcelsDetails not in unique:
									unique.append(jobIDs.sameIdForParcelsDetails)
							print('2')
							print(len(customerjob_obj))
							for unique_id in unique:
								completedcustomerjobs_data = []
								for job in customerjob_obj:
									if job.sameIdForParcelsDetails == unique_id:
										try:
											awbnumber = 'AWB-' + str(10000 + job.id)
										except Exception as e:
											print(e)
											awbnumber = ''
										if not job.image:
											parcelimage = ''
										else:
											parcelimage = str(settings.WEB_BASE_URL) + job.image.name

										driverjob_data = {}
										driverexist = False
										driverjob_obj = DriverJob.objects.filter(customerjob = job).first()
										if driverjob_obj:
											driverexist = True
											if driverjob_obj.jobcompleted:
												driverjob_data.update({
													'drivername' : driverjob_obj.driver.name,
													'drivercountrycode' : driverjob_obj.driver.countrycode,
													'driverphone' : driverjob_obj.driver.phone,
													'driverid' : driverjob_obj.driver.id,
													})
												driverexist = True
												completedcustomerjobs_data.append({
													'sendername' : job.sendername,
													'senderphone' : job.senderphone,
													'senderpickupaddress' : job.pickupaddress,
													'recipientname' : job.recipientname,
													'recipientdropoffaddress' : job.dropoffaddress,
													'parcelimage' : parcelimage,
													'awbnumber' : awbnumber,
													'customerjobid' : job.id,
													'driverexist' : driverexist, 
													'driverdetails' : driverjob_data,

													})
										if unique_id==0:
											if completedcustomerjobs_data:
												all_data_main_list.append(completedcustomerjobs_data)
												completedcustomerjobs_data=[]
								if completedcustomerjobs_data:
									all_data_main_list.append(completedcustomerjobs_data)
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						# if query != '':
						# 	for all_data in all_data_main_list:
						# 		if query in all_data_main_list[]
						if query != '':
							two=[]
							for all_data in all_data_main_list:
								one=[]
								for d in all_data:
									if (query in d['sendername']) or (query in d['senderphone']) or (query in d['recipientname']):
										one.append(d)
								if one:
									two.append(one)
							all_data_main_list=two
						return JsonResponse({ 'status_code': 200 , 'data' : all_data_main_list, 'support_phone' : support_phone, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})




class CompletedRequests(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			completedcustomerjobs_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					print('0')
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						print('1')

						supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
						if supportdetail_obj:
							support_phone = supportdetail_obj.phone
						else:
							support_phone = ''
						customerjob_obj = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')
						if customerjob_obj:
							print('2')
							print(len(customerjob_obj))
							for job in customerjob_obj:
								try:
									awbnumber = 'AWB-' + str(10000 + job.id)
								except Exception as e:
									print(e)
									awbnumber = ''
								if not job.image:
									parcelimage = ''
								else:
									parcelimage = str(settings.WEB_BASE_URL) + job.image.name

								driverjob_data = {}
								driverexist = False
								driverjob_obj = DriverJob.objects.filter(customerjob = job).first()
								if driverjob_obj:
									driverexist = True
									if driverjob_obj.jobcompleted:
										driverjob_data.update({
											'drivername' : driverjob_obj.driver.name,
											'drivercountrycode' : driverjob_obj.driver.countrycode,
											'driverphone' : driverjob_obj.driver.phone,
											'driverid' : driverjob_obj.driver.id,
											})
										driverexist = True
										completedcustomerjobs_data.append({
											'sendername' : job.sendername,
											'senderphone' : job.senderphone,
											'senderpickupaddress' : job.pickupaddress,
											'recipientname' : job.recipientname,
											'recipientdropoffaddress' : job.dropoffaddress,
											'parcelimage' : parcelimage,
											'awbnumber' : awbnumber,
											'customerjobid' : job.id,
											'driverexist' : driverexist, 
											'driverdetails' : driverjob_data,

											})
								
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : completedcustomerjobs_data, 'support_phone' : support_phone, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})

class CompletedRequestsTest(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			print('CompletedRequestsTest - in get')
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			
			supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
			if supportdetail_obj:
				support_phone = supportdetail_obj.phone
			else:
				support_phone = ''


			completedcustomerjobs_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					print('0')
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						print('1')
						order_obj = Order.objects.filter(customer = customer_obj, status = 1).order_by('-id')
						if order_obj:
							for order in order_obj:
								order_data = []
								customerjob_obj = CustomerJob.objects.filter(customer = customer_obj)
								if customerjob_obj:
									print('2')
									print(len(customerjob_obj))
									for job in customerjob_obj:
										try:
											awbnumber = 'AWB-' + str(10000 + job.id)
										except Exception as e:
											print(e)
											awbnumber = ''
										if not job.image:
											parcelimage = ''
										else:
											parcelimage = str(settings.WEB_BASE_URL) + job.image.name

										driverjob_data = {}
										driverexist = False
										driverjob_obj = DriverJob.objects.filter(customerjob = job).first()
										if driverjob_obj:
											driverexist = True
											if driverjob_obj.jobcompleted:
												driverjob_data.update({
													'drivername' : driverjob_obj.driver.name,
													'drivercountrycode' : driverjob_obj.driver.countrycode,
													'driverphone' : driverjob_obj.driver.phone,
													'driverid' : driverjob_obj.driver.id,
													})
												driverexist = True
												order_data.append({
													'sendername' : job.sendername,
													'senderphone' : job.senderphone,
													'senderpickupaddress' : job.pickupaddress,
													'recipientname' : job.recipientname,
													'recipientdropoffaddress' : job.dropoffaddress,
													'parcelimage' : parcelimage,
													'awbnumber' : awbnumber,
													'customerjobid' : job.id,
													'driverexist' : driverexist, 
													'driverdetails' : driverjob_data,

													})
								completedcustomerjobs_data.append(order_data)				
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : completedcustomerjobs_data, 'support_phone' : support_phone, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})


class AllRequests(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			allcustomerjobs_data = []
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					print('0')
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						print('1')

						supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
						if supportdetail_obj:
							support_phone = supportdetail_obj.phone
						else:
							support_phone = ''
						customerjob_obj = CustomerJob.objects.filter(customer = customer_obj)
						if customerjob_obj:
							print('2')
							print(len(customerjob_obj))
							for job in customerjob_obj:
								if not job.image:
									parcelimage = ''
								else:
									parcelimage = str(settings.WEB_BASE_URL) + job.image.name

								driverjob_data = {}
								driverexist = False
								driverjob_obj = DriverJob.objects.filter(customerjob = job).first()
								if driverjob_obj:
									driverjob_data.update({
										'drivername' : driverjob_obj.driver.name,
										'drivercountrycode' : driverjob_obj.driver.countrycode,
										'driverphone' : driverjob_obj.driver.phone,
										'driverid' : driverjob_obj.driver.id,
										})
									driverexist = True
								allcustomerjobs_data.append({
									'sendername' : job.sendername,
									'senderphone' : job.senderphone,
									'senderpickupaddress' : job.pickupaddress,
									'recipientname' : job.recipientname,
									'recipientdropoffaddress' : job.dropoffaddress,
									'parcelimage' : parcelimage,
									'customerjobid' : job.id,
									'driverexist' : driverexist, 
									'driverdetails' : driverjob_data,

									})
						
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : allcustomerjobs_data, 'support_phone' : support_phone, 'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 200 , 'data' : [],'status_message' : 'success' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})


class InvoiceScreenDetail(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			customerjobid_val = request.GET.get('customerjobid')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			if not customerjobid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'CustomerJob id is required',})
			customerjob_data = {}
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						customerjob_obj = CustomerJob.objects.filter(id = customerjobid_val).first()
						if customerjob_obj:
							extracharges = 0.0
							if customerjob_obj.parcelpdf:
								parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
							else:
								parcelpdf_link = ''

							customerjob_data.update({
								# 'sendername' : customerjob_obj.sendername,
								# 'sendercountrycode' : customerjob_obj.sendercountrycode,
								# 'senderphone' : customerjob_obj.senderphone,
								# 'senderpickupaddress' : customerjob_obj.pickupaddress,
								# 'recipientname' : customerjob_obj.recipientname,
								# 'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
								'vehicletype' : customerjob_obj.vehicletype.name,
								'fare' : round(customerjob_obj.price,2),
								'extracharges' : str(extracharges),
								'totalcharges' : str(round(customerjob_obj.price,2)),
								'parcelpdf_link' : parcelpdf_link,
								'currency' : '€',
								})
						
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
							return JsonResponse({ 'status_code': 200 , 'data' : customerjob_data,'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})



class CustomerJobDetail(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			customerjobid_val = request.GET.get('customerjobid')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			if not customerjobid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'CustomerJob id is required',})
			customerjob_data = {}
			token_obj = Token.objects.filter(key = session_token_val).first()
			if True:
				# user_obj = User.objects.filter(id = token_obj.user_id).first()
				if True:
					# customer_obj = Customer.objects.filter(user = user_obj).first()
					if True:
						print('last true')
						customerjob_obj = CustomerJob.objects.filter(id = customerjobid_val).first()
						print('before if')
						if customerjob_obj:
							print('in if')			
							if not customerjob_obj.sendercountrycode:
								sendercountrycode = ''
							else:
								sendercountrycode = customerjob_obj.sendercountrycode

							if not customerjob_obj.recipientcountrycode:
								recipientcountrycode = ''
							else:
								recipientcountrycode = customerjob_obj.recipientcountrycode
							if not customerjob_obj.qrcode:
								qrcode = ''
							else:
								qrcode = str(settings.MEDIA_BASE_URL) + customerjob_obj.qrcode.name

							if not customerjob_obj.image:
								parcelimage = ''
							else:
								parcelimage = str(settings.MEDIA_BASE_URL) + customerjob_obj.image.name
							if customerjob_obj.parcelpdf:
								parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
							else:
								parcelpdf_link = ''

							
							
							print(parcelpdf_link)

							if customerjob_obj.order.ordertype == 1:
								ordertype = 'Single-Drop'
							elif customerjob_obj.order.ordertype == 2:
								ordertype = 'Multi-Drop'
							delivery_failed_status=False
							failed_image_proof=''
							rating, feedback, feedbackgiven = 0, '', False
							userrating_obj = UserRating.objects.filter(customerjobid = customerjob_obj.id, ratingfor = 'driver').first()
							if userrating_obj:
								feedbackgiven = True
								rating = userrating_obj.rating
								feedback = userrating_obj.note

							customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob_obj).first()
							payment_datetime, pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', '', ''
							if customerjobdatetime_obj:
								payment_datetime = customerjobdatetime_obj.payment_datetime
								pickup_datetime = customerjobdatetime_obj.pickup_datetime
								itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime
								itemspickup_datetime = customerjobdatetime_obj.pickup_datetime
								deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime


							try:
								pickup_proof_method_new,pickup_fromperson_name_new, pickup_fromperson_phone_new, pickup_fromperson_signature_new = '', '', '', ''
								pickup_proof_method_new=''
								if customerjob_obj.sameIdForParcelsDetails!=0:
									all_customer_job = CustomerJob.objects.filter(sameIdForParcelsDetails = customerjob_obj.sameIdForParcelsDetails)
									for al in all_customer_job:
										customer_deatils_all = CustomerJobDeliveryExtraDetails.objects.filter(job = al).first()
										if customer_deatils_all:
											if customer_deatils_all.pickup_proof_method == 'signature':
												pickup_proof_method_new = customer_deatils_all.pickup_proof_method
												pickup_fromperson_name_new = customer_deatils_all.pickup_fromperson_name
												try:
													pickup_fromperson_signature_new = str(settings.MEDIA_BASE_URL) + customer_deatils_all.pickup_fromperson_signature.name
												except:
													pickup_fromperson_signature_new= ''
											elif customer_deatils_all.pickup_proof_method == 'otp':
												pickup_proof_method_new= customer_deatils_all.pickup_proof_method
												pickup_fromperson_name_new= al.sendername
												try:
													pickup_fromperson_phone_new= al.sendercountrycode + '-' + al.senderphone
												except:
													pickup_fromperson_phone_new= ''
											else:
												pickup_proof_method_temp= customer_deatils_all.pickup_proof_method
												if pickup_proof_method_temp is not None:
													pickup_proof_method_new= customer_deatils_all.pickup_proof_method
							except Exception as e:
								print(e)





							delivery_proof_method, delivery_toperson_name, delivery_toperson_phone, delivery_toperson_signature = '', '', '', ''
							pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
							customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job = customerjob_obj).first()
							if customerjobdeliveryextradetails_obj:
								if customerjobdeliveryextradetails_obj.delivery_proof_method == 'signature':
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
									delivery_toperson_name = customerjobdeliveryextradetails_obj.delivery_toperson_name
									delivery_toperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.delivery_toperson_signature.name
								elif customerjobdeliveryextradetails_obj.delivery_proof_method == 'otp':
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
									delivery_toperson_name = customerjob_obj.recipientname
									delivery_toperson_phone = customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone
								else:
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method

								
								if customerjobdeliveryextradetails_obj.pickup_proof_method == 'signature':
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
									pickup_fromperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.pickup_fromperson_signature.name
								elif customerjobdeliveryextradetails_obj.pickup_proof_method == 'otp':
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjob_obj.sendername
									pickup_fromperson_phone = customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone
								else:
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
							try:
								customerdeliveryfailed_obj = CustomerJobDeliveryFailed.objects.filter(job = customerjob_obj).first()
								if customerdeliveryfailed_obj:
									delivery_failed_status=True
									failed_image_proof=customerdeliveryfailed_obj.deliveryfailed_image.name
								else:
									delivery_failed_status=False
									failed_image_proof=''
							except:
								delivery_failed_status=False
								failed_image_proof=''
							driverexist = False
							parcelpicked = False
							driverjob_data = {}
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
							driver_job_status=0
							if driverjob_obj:	
								if driverjob_obj.jobstarted == True:
									driver_job_status=1
								if driverjob_obj.arrived_at_pickup == True:
									driver_job_status=2
								if driverjob_obj.parcel_picked_by_driver == True:
									driver_job_status=3
								if driverjob_obj.start_DropOff == True:
									driver_job_status=4
								if driverjob_obj.arrived_atDropOffLocation == True:
									driver_job_status=5
								if driverjob_obj.jobcompleted == True:
									driver_job_status=6
								if driverjob_obj.deliveryfailed == True:
									driver_job_status=99

							delivery_safe_status=False
							safe_image_proof=''

							safepalceImage=DriverDropSafePalace.objects.filter(driver_job=driverjob_obj,customerjob=customerjob_obj).first()
							if customerjob_obj.deliverySafePlace==True:
								delivery_safe_status=True
								if safepalceImage:
									safe_image_proof=str(settings.MEDIA_BASE_URL) + safepalceImage.safeplace.name

							if driverjob_obj:
								if driverjob_obj.jobstarted:
									parcelpicked = True
								driver_obj = DriverModel.objects.filter(id = driverjob_obj.driver.id).first()
								if driver_obj.image:
									driverimage = str(settings.MEDIA_BASE_URL) + driver_obj.image.name
								else:
									driverimage = ''
								driverjob_data.update({
									'drivername' : driverjob_obj.driver.name,
									'drivercountrycode' : driverjob_obj.driver.countrycode,
									'driverphone' : driverjob_obj.driver.phone,
									'driverimage' : driverimage,
									'driverid' : driverjob_obj.driver.id,
									'driverjobid' : driverjob_obj.id,
									'driver_job_status':driver_job_status,
									})
								driverexist = True
							customerjob_data.update({
								'sendername' : customerjob_obj.sendername,
								'sendercountrycode' : sendercountrycode,
								'senderphone' : customerjob_obj.senderphone,
								'senderpickupaddress' : customerjob_obj.pickupaddress,
								'sendercity' : customerjob_obj.sendercity,
								'senderlatitude' : customerjob_obj.senderlatitude,
								'senderlongitude' : customerjob_obj.senderlongitude,
								'pickuptimeslot' : customerjob_obj.pickuptimeslot,
								'noofparcels' : customerjob_obj.noofparcels,
								'recipientname' : customerjob_obj.recipientname,
								'recipientcountrycode' : recipientcountrycode,
								'recipientphone' : customerjob_obj.recipientphone,
								'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
								'recipientlatitude' : customerjob_obj.recipientlatitude,
								'recipientlongitude' : customerjob_obj.recipientlongitude,
								'dropofftimeslot' : customerjob_obj.dropofftimeslot,
								'pickupspecialnote' : customerjob_obj.pickupspecialnote,
								'dropoffspecialnote' : customerjob_obj.dropoffspecialnote,
								'itemspickup_datetime' : itemspickup_datetime,

								'delivery_safe_status':delivery_safe_status,
								'safe_image_proof':safe_image_proof,
								'no_of_item_in_parcel':customerjob_obj.no_of_item_in_parcel,

								# 'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
								'length' : customerjob_obj.length,
								'width' : customerjob_obj.width,
								'height' : customerjob_obj.height,
								'weight' : customerjob_obj.weight,
								'parceltype' : customerjob_obj.parceltype,
								'vehicletype' : customerjob_obj.vehicletype.name,
								'fare' : round(customerjob_obj.price,2),

								'specialbooking' : customerjob_obj.specialbooking,
								'parcelimage' : parcelimage,
								'parcelpdf_link' : parcelpdf_link,
								'qrcode' : qrcode,
								'customerjobid' : customerjob_obj.id,
								'awbnumber' : 'AWB-' + str(10000 + customerjob_obj.id),
								'driverexist' : driverexist,
								'parcelpicked' : parcelpicked,
								'driverdetails' : driverjob_data,

								'rating' : rating,
								'feedback' : feedback,
								'feedbackgiven' : feedbackgiven,

								'ordertype' : ordertype,

								'delivery_proof_method' : delivery_proof_method,
								'delivery_toperson_name' : delivery_toperson_name,
								'delivery_toperson_phone' : delivery_toperson_phone,
								'delivery_toperson_signature' : delivery_toperson_signature,
								
								'pickup_proof_method' : pickup_proof_method_new,
								'pickup_fromperson_name' : pickup_fromperson_name_new,
								'pickup_fromperson_phone' : pickup_fromperson_phone_new,
								'pickup_fromperson_signature' : pickup_fromperson_signature_new,

								'itemsdelivered_datetime' : itemsdelivered_datetime,
								
								})
						
						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
							return JsonResponse({ 'status_code': 200 , 'data' : customerjob_data,'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : [],'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 401 , 'data' : [] ,'status_message' : 'User not logged in.' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})







class Login(APIView):
	'''This class is used for login process for company or customer users'''
	def post(self, request, *args, **kwargs):
		try:
			print('CustomerLogin API - in post')
			userrole_val = request.POST.get('userrole')
			email_val = request.POST.get('email')
			password_val = request.POST.get('password')
			
			if not userrole_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User Role is required'})
			fcmtoken_val = request.POST.get('fcmtoken')
			if not fcmtoken_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Fcm token is required'})
			if not email_val:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Email address is required'})
			if not password_val:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Password is required'})
			user = authenticate(username = email_val, password = password_val)  
			if user is not None:
				token, status = Token.objects.get_or_create(user = user)
				if userrole_val == 'customer' or userrole_val == 'company':
					if userrole_val == 'customer':
						customer_obj = Customer.objects.filter(user = user, role = 'customer').first()
					elif userrole_val == 'company':
						customer_obj = Customer.objects.filter(user = user, role = 'company').first()
					if customer_obj:
						if customer_obj.emailverified == False:
							return JsonResponse({'status_code' : 111, 'status_message' : 'Please verify your email first.'})
						elif customer_obj.isdisabled:
							return JsonResponse({'status_code' : 100, 'status_message' : 'Your account has been disabled by Admin.'})
						else:
							customer_obj.fcmtoken = fcmtoken_val
							customer_obj.save()
							result, unread_notifications_count = getunreadnotificationcount(user.id)
							if result == 'success':
								print(unread_notifications_count)
							elif result == 'error':
								print(unread_notifications_count)
							if not customer_obj.image:
								image = ''
							else:
								image = str(settings.WEB_BASE_URL) + customer_obj.image.name
							return JsonResponse({'status_code': 200, 'user' : 'customer', 'name' : customer_obj.name,'countrycode' : customer_obj.countrycode, 'phone' : customer_obj.phone, 'image' : image, 'token' : token.key, 'unread_notifications_count' : unread_notifications_count, 'status_message' : 'customer login successfull'})
				
				return JsonResponse({'status_code': 401, 'status_message' : 'Invalid Credentials.'})
			else:
				return JsonResponse({'status_code': 401, 'status_message' : 'Invalid Credentials.'})
		except Exception as error:
			print('error is',error)
			return JsonResponse({'status_code': 500, 'status_message' : 'Exception occurred : ' + str(error)})

class Register(APIView):
	'''This API sends the OTP on customer mobile at the time of registration'''
	def post(self, request, *args, **kwargs):
		try:
			print('Register API - in post')
			print('data is  : ',request.POST)
			userrole_val = request.POST.get('userrole')
			name_val = request.POST.get('name')
			email_val = request.POST.get('email')
			countrycode_val = request.POST.get('countrycode')
			phone_val = request.POST.get('phone')
			password_val = request.POST.get('password')
			if not userrole_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User Role is required'})
			if not name_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Name is required'})
			if not email_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Email Address is required'})
			if not countrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Countrycode is required'})
			if not phone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Phone number is required'})
			if not password_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Password is required'})
			

			if userrole_val == 'driver':
				vehicletype_val = request.POST.get('vehicletype')
				vehiclenumber_val = request.POST.get('vehiclenumber')
				preferredarea_val = request.POST.get('preferredarea')
				if not vehicletype_val:
					return JsonResponse({'status_code': 400, 'status_message': 'Vehicle Type is required'})
				if not vehiclenumber_val:
					return JsonResponse({'status_code': 400, 'status_message': 'Vehicle Number is required'})
				if not preferredarea_val:
					return JsonResponse({'status_code': 400, 'status_message': 'Preferred Area is required'})
			
			if userrole_val == 'company':
				job_title = request.POST.get('job_title')
				company_name = request.POST.get('company_name')
				company_website = request.POST.get('company_website')
				monthly_delivery_volume = request.POST.get('monthly_delivery_volume')
				registration_number = request.POST.get('registration_number')
				industry = request.POST.get('industry')

			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				try:
					customer_emailverified_obj = Customer.objects.filter(user = user_obj, emailverified = True)
					# driver_obj = DriverModel.objects.filter(user = user_obj, emailverified = True)
					if customer_emailverified_obj:
						return JsonResponse({'status_code': 409, 'status_message': 'User already exists.'})
					customer_emailnotverified_obj = Customer.objects.filter(user = user_obj, emailverified = False)
					if customer_emailnotverified_obj:
						return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address earlier. Please search your mail inbox.'})
					else:
						return JsonResponse({'status_code': 409, 'status_message': 'A driver with this email address already exists.'})
				except Exception as e:
					print(e)
					return JsonResponse({'status_code': 409, 'status_message': 'User exists.'})
			else:
				user_obj = User.objects.create_user(username = email_val, email = email_val, password = password_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(12)])
				baselink = '/user/' + userrole_val + '/verify/' + str(user_obj.email) + '/' + st
				completelink = str(settings.WEB_BASE_URL) + baselink
				message = "\nVerify your account through following link:\n" + completelink
				try:
					print(message)
					res = send_mail('Email verification:',message,'tmpython4esf@gmail.com',[str(email_val)],fail_silently=True)
					print(res)
				except Exception as e:
					print(e)
				if userrole_val == 'customer':
					customer_obj = Customer.objects.create(user = user_obj, name = name_val, email = email_val, countrycode = countrycode_val, phone = phone_val, emailverificationlink = baselink)
					if customer_obj:
						return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address.'})
				elif userrole_val == 'company':
					customer_obj = Customer.objects.create(user = user_obj, role = userrole_val, name = name_val, email = email_val, countrycode = countrycode_val, phone = phone_val, emailverificationlink = baselink)
					if customer_obj:
						companydetail_obj = CompanyDetail.objects.create(customer = customer_obj, job_title = job_title, name = company_name, website = company_website, monthly_delivery_volume = monthly_delivery_volume, registration_number = registration_number, industry = industry)
						if companydetail_obj:
							return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address.'})
				# elif userrole_val == 'driver':
				# 	driver_obj = DriverModel.objects.create(user = user_obj, name = name_val, email = email_val, phone = phone_val, vehicletype = vehicletype_val, vehiclenumber = vehiclenumber_val, preferredarea = preferredarea_val, emailverificationlink = baselink)
				# 	if driver_obj:
				# 		return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
				else:
					return JsonResponse({'status_code' : 400, 'status_message' : 'User Role is not defined'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})

class GetProfile(APIView):
	# permission_classes = (AllowAny,)
	def get(self, request):
		''' This API method is used to get profile data of user'''
		print('data is  : ',request.GET)
		try:
			session_token_val = request.GET.get('session_token')
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in',})
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						companydetail_data = {}
						if customer_obj.role == 'company':
							companydetail_obj = CompanyDetail.objects.filter(customer = customer_obj).first()
							if companydetail_obj:
								companydetail_data.update({
									'job_title' : companydetail_obj.job_title,
									'name' : companydetail_obj.name,
									'website' : companydetail_obj.website,
									'monthly_delivery_volume' : companydetail_obj.monthly_delivery_volume,
									'registration_number' : companydetail_obj.registration_number,
									'industry' : companydetail_obj.industry,
									'credits' : companydetail_obj.credits,
									})


						if not customer_obj.image.name:
							image = ''
						else:
							image = str(settings.WEB_BASE_URL) + customer_obj.image.name		
							image = image.replace(':9999','')
						if not customer_obj.address:
							address = ''
						else:
							address = customer_obj.address
						if not customer_obj.countrycode:
							countrycode = ''
						else:
							countrycode = customer_obj.countrycode
						profile_data = {}
						try:
							rating_customer = UserRating.objects.filter(ratingfor = 'customer', customerid = customer_obj.id).aggregate(Avg('rating'))
							print(rating_customer)
							print(rating_customer['rating__avg'])
							if not rating_customer['rating__avg']:
								ratings = 0.0
							else:	
								ratings = rating_customer['rating__avg']
						except Exception as e:
							print(e)
							ratings = 0.0
						profile_data.update({
									'name':customer_obj.name,
									'email':customer_obj.email,
									'countrycode':countrycode,
									'phone':customer_obj.phone,
									'address':address,
									'image':image,
									'ratings' : ratings,
									'companydetail_data' : companydetail_data,
								})

						# serializer = UserSerializer(obj, many=True)
						# print(serializer.data)
						return JsonResponse({ 'status_code': 200 , 'data' : profile_data,'status_message' : 'success' })
					else:
						return JsonResponse({ 'status_code': 400 , 'data' : {},'status_message' : '' })
				else:
					return JsonResponse({ 'status_code': 400 , 'data' : {},'status_message' : '' })
			else:
				return JsonResponse({ 'status_code': 400 , 'data' : {},'status_message' : '' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})

# @method_decorator(checklogin, name='dispatch')
class UpdateProfile(APIView):
	# permission_classes = (AllowAny,)
	def post(self, request, *args, **kwargs):
		print('UpdateProfile - in post')
		# print('data is  : ',request.POST)
		try:
			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				print('\n\n')
				# print(codec)
				print('0')
				base64_data = codec.split(";base64,")
				print('1')
				extens = base64_data[0]
				print('2')
				ext = extens.split("/")
				print('3')
				print(ext)
				extension = str(ext[1])
				print('4')
				base64_data = base64_data[1]
				print('5')
				byte_data = base64.b64decode(base64_data)
				print('6')
				image_data = BytesIO(byte_data)
				print('7')
				from PIL import Image
				import string, random, os
				print('8')
				img = Image.open(image_data)
				print('9')
				customer_obj = Customer.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.mkdir(filepath)
				for obj in thumbnailsize_objs:
					img = Image.open(image_data)
					im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
					im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
				img = Image.open(image_data)	
				img.save(filepath+'/original-'+st+'.'+extension)	
				filename = '/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)+'/original-'+st+'.'+extension
				customer_obj.image = filename
				customer_obj.save()
				return('1')

			session_token_val = request.POST.get('session_token')
			name_val = request.POST.get('name')
			countrycode_val = request.POST.get('countrycode')
			phone_val = request.POST.get('phone')
			email_val = request.POST.get('email')
			address_val = request.POST.get('address')
			imagebase64_val = request.POST.get('imagebase64')
			
			if not session_token_val:
				return JsonResponse({'status': 400, 'message': 'User not logged in',})
			if not name_val:
				return JsonResponse({'status': 400, 'message': 'Name is required'})
			if not countrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Countrycode is required'})
			if not phone_val:
				return JsonResponse({'status': 400, 'message': 'Phone Number is required'})
			if not email_val:
				return JsonResponse({'status': 400, 'message': 'Email is required'})
			# if not address_val:
			# 	return JsonResponse({'status': 400, 'message': 'Address is required'})
			# if not imagebase64_val:
			# 	return JsonResponse({'status': 400, 'message': 'Image is required'})
			
			token_obj = Token.objects.filter(key = session_token_val).first()
			if token_obj:
				user_obj = User.objects.filter(id = token_obj.user_id).first()
				if user_obj:
					customer_obj = Customer.objects.filter(user = user_obj).first()
					if customer_obj:
						customer_obj.name = name_val
						customer_obj.countrycode = countrycode_val
						customer_obj.phone = phone_val
						customer_obj.address = address_val
						customer_obj.save()

						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customer_obj.id)
							print('after function call')
						if customer_obj.role == 'company':
							job_title = request.POST.get('job_title')
							company_name = request.POST.get('company_name')
							company_website = request.POST.get('company_website')
							monthly_delivery_volume = request.POST.get('monthly_delivery_volume')
							registration_number = request.POST.get('registration_number')
							industry = request.POST.get('industry')
							companydetail_obj = CompanyDetail.objects.filter(customer = customer_obj).update(job_title = job_title, name = company_name, website = company_website, monthly_delivery_volume = monthly_delivery_volume, registration_number = registration_number, industry = industry)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'profile', 'KwickDelivery', 'Your profile is updated successfully')
						except Exception as e:
							print(e)
						return JsonResponse({ 'status_code': 200 , 'status_message' : 'profile updated successfully' })
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})



		otponon_val = request.POST.get('otpon')
		if not otponon_val:
			return JsonResponse({'status': 0, 'message': 'otpon Empty',})
		if otponon_val=='mobile':
			obj=MainUser.objects.filter(token=session_token_val,mobileOTP=otp_val)
		elif otponon_val=='email':
			obj=MainUser.objects.filter(token=session_token_val,updateprofileOTP=otp_val)
		try:
			if obj:
				st_time=obj[0].updateprofileOTP_starttime
				ex_time=obj[0].updateprofileOTP_expiretime
				print(st_time)
				print(ex_time)
				time=datetime.datetime.now()
				print(time)
				utc=pytz.timezone('Asia/Kolkata')
				print('0')
				time = utc.localize(time)
				print(time)
				print('1')
				# st_time = utc.localize(st_time)
				print('2')
				# ex_time = utc.localize(ex_time)
				print('3')

				if((time>st_time) and (time<ex_time)):
					from PIL import Image		
					image = request.FILES.get('image')
					
					if image:
						filename = image.name
						print('\n')
						print(filename)
						print('\n')
						filename = filename.split('.')
						extension = str(filename[-1])
						import io

						image_data = io.BytesIO(image.read())
						print('3')

						print(image_data)
						img = Image.open(image_data)
						# img.load()
						print('4')
						import random,string
						st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
						thumbnailsize_objs = ThumbnailSize.objects.all()
						print('beforee resizing')
						for obj in thumbnailsize_objs:
							print(obj.height,obj.width)
							img = Image.open(image_data)
							im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
							# img = Image.resize([int(obj.height),int(obj.width)],PIL.Image.ANTIALIAS)
							im = img.save(str(settings.BASE_DIR)+'/media/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								

						img = Image.open(image_data)	
						img.save(str(settings.BASE_DIR)+'/media/original-'+st+'.'+extension)	
						filename=st+'.'+extension
						print(filename)

					country_code_val = request.POST.get('country_code')
					if not country_code_val:
						return JsonResponse({'status': 0, 'message': 'Country code is required',})
					country_code_val = '+'+country_code_val
					phone_val = request.POST.get('phone')
					if not phone_val:
						return JsonResponse({'status': 0, 'message': 'Mobile number is required',})
					add1 = request.POST.get('add1')
					if not add1:
						return JsonResponse({'status': 0, 'message': 'Address line 1 is required',})
					add2 = request.POST.get('add2')
					country = request.POST.get('country')
					if not country:
						return JsonResponse({'status': 0, 'message': 'Country is required',})
					state = request.POST.get('state')
					if not state:
						return JsonResponse({'status': 0, 'message': 'State is required',})
					city = request.POST.get('city')
					if not city:
						return JsonResponse({'status': 0, 'message': 'City is required',})
					postalcode = request.POST.get('postalcode')
					if not postalcode:
						return JsonResponse({'status': 0, 'message': 'Postal code is required',})
					dob_val = request.POST.get('dob')
					if not dob_val:
						return JsonResponse({'status': 0, 'message': 'Date of birth is required',})
					try:
						dob_val = dob_val.split('/')
						dob_val = str(dob_val[1])+'/'+str(dob_val[0])+'/'+str(dob_val[2])
						dob = parse(dob_val)
					except:
						return JsonResponse({'status': 0, 'message': 'Date of birth format should be (mm/dd/yyyy)',})
					
					print(dob)
					if image:
						MainUser.objects.filter(token=session_token_val).update(image=filename,countrycode=country_code_val,phone=phone_val,addressline1=add1,addressline2=add2,country=country,state=state,city=city,postalcode=postalcode,dateofbirth=dob)
					else:
						MainUser.objects.filter(token=session_token_val).update(countrycode=country_code_val,phone=phone_val,addressline1=add1,addressline2=add2,country=country,state=state,city=city,postalcode=postalcode,dateofbirth=dob)
					
					main_user_obj = MainUser.objects.filter(token=session_token_val)
					main_user_obj_fcmtoken=main_user_obj[0].fcmtoken
					image = str(settings.BASE_URL)+'/media/original-'+main_user_obj[0].image.name
					print(main_user_obj_fcmtoken)
					message_title = ''
					message_body = ""
					print('####')
					server_key = str(settings.FIREBASE_SERVER_KEY)
					# customer_fcmtoken='f7qxT-icg8I:APA91bEF7aG6QvR2HqUyvS7X8ngBz4nk_i9aBHoOcqAdoytc2STcsi26iVFzbY_hICiCd4UiF1GwqDZV5_Eekf8vDNxFKI4sG5HAQWYKV-bZ2Vn4aOEIiKomcI0i6o6tjs6WCAfvhEGa'
					data_message = {
								"app":'normal',
								'type':'profile',
								"sendparcel": 'no',
								'title' : 'Airdely', # these are being used at API end
								"message" : 'Your profile is updated successfully',
							}

					result = FCMNotification(api_key=server_key).notify_single_device(registration_id=main_user_obj_fcmtoken, message_title=message_title, message_body=message_body, data_message=data_message)
					print(result)
					print("profile updated")
					return JsonResponse({'status': 200, 'message': 'Profile updated successfully','image':image})
				else:
					return JsonResponse({'status': 0, 'message': 'OTP has expired',})					
			else:
				return JsonResponse({'status': 0, 'message': 'Invalid OTP',})
		except Exception as e:
			return JsonResponse({'status': 0, 'message': str(e),})



class ForgotPassword(APIView):
	# permission_classes = (IsAuthenticated,)
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('data is  : ',request.POST)
		try:	
			userrole_val = request.POST.get('userrole')
			email_val = request.POST.get('email')

			if not userrole_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User Role is required'})
			if not email_val:
				return JsonResponse({'status': 400, 'message': 'Email Address is required',})		
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				print("first-0")
				if userrole_val == 'driver':
					print("first-0-driver")
					userrole_obj = DriverModel.objects.filter(user = user_obj).first()
				elif userrole_val == 'customer':
					print("first-0-customer")
					userrole_obj = Customer.objects.filter(user = user_obj, role = 'customer').first()
				elif userrole_val == 'company':
					print("first-0-company")
					userrole_obj = Customer.objects.filter(user = user_obj, role = 'company').first()
				if userrole_obj:	
					print("first-0-2.0")
					ran_num = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(12)])
					baselink = '/user/' + userrole_val + '/forgot/' + str(user_obj.email) + '/' + ran_num
					completelink = str(settings.WEB_BASE_URL) + baselink
					message = "\nForgot your Password click following link:\n" + completelink
					userrole_obj.forgot_password_link = baselink
					userrole_obj.save()
					print("first-3")
					send_mail('Forgot Password:',message,'testdemotest11@gmail.com',[str(email_val)],fail_silently=True)
					print("first-4")				
					return JsonResponse({'status_code': 200, 'status_message': 'Link sent on email address'})
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Not find any User',})				

			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User does not exist',})
		except Exception as e:
			print(e)
			return JsonResponse({'status': 500, 'message': str(e),})


class UpdatePassword(APIView):
	# permission_classes = (IsAuthenticated,)
	# permission_classes = (AllowAny,)
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('data is  : ',request.POST)
		try:
			userrole_val = request.POST.get('userrole')
			email = request.POST.get('email')
			otp = request.POST.get('otp')
			password = request.POST.get('newpassword')
			
			
			if not userrole_val:
				return JsonResponse({'status': 0, 'message': 'User Role is required',})
			if not email:
				return JsonResponse({'status': 0, 'message': 'Email is required',})	
			if not otp:
				return JsonResponse({'status': 0, 'message': 'OTP is required',})
			if not password:
				return JsonResponse({'status': 0, 'message': 'New password is required',})	
			

			user_obj = User.objects.filter(email = email).first()
			if user_obj:
				if userrole_val == 'customer':
					pass
					return JsonResponse({'status': 0, 'message': 'User is disabled. Contact SuperAdmin.',})
				elif userrole_val == 'company':
					pass
					return JsonResponse({'status': 0, 'message': 'User is disabled. Contact SuperAdmin.',})


				if main_user_obj[0].status=='0':
					print('0')
					return JsonResponse({'status': 0, 'message': 'User is not registered with us.',})
				if main_user_obj[0].status=='1':
					print('1')
					new_password_val = handler.hash(password)
					print(new_password_val)
					main_user_obj=MainUser.objects.filter(email=email)
					if main_user_obj:
						main_user_obj.update(password=new_password_val)
						return JsonResponse({'status': 200, 'message': 'Password updated successfully',})
					else:
						return JsonResponse({'status': 0, 'message': 'Password not updated',})
			else:
				return JsonResponse({'status': 0, 'message': 'Invalid OTP',})
		except Exception as e:
			print(e)
			return JsonResponse({'status': 0, 'message': str(e),})




#testing purpose or in advance created this api
class CustomerRegistration(APIView):
	'''This API class saves the registration details of customer or company users'''
	template_name = 'customer_registration.html'

	def post(self, request, *args, **kwargs):
		try:
			print('data is  : ',request.POST)
			
			userrole_val = request.POST.get('userrole')
			if not userrole_val:
				return JsonResponse({'status_code': 0, 'status_message': 'User Role is required'})
			firstname_val = request.POST.get('firstname')
			if not firstname_val:
				return JsonResponse({'status_code': 0, 'status_message': 'First Name is required'})
			lastname_val = request.POST.get('lastname')
			if not lastname_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Last Name is required'})
			email_val = request.POST.get('email')
			if not email_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Email Address is required'})
			countrycode_val = request.POST.get('countrycode')
			if not countrycode_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Countrycode is required'})
			if '+' not in countrycode_val:
				countrycode_val = '+' + countrycode_val
			phone_val = request.POST.get('phone')
			if not phone_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Phone number is required'})
			password_val = request.POST.get('password')
			if not password_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Password is required'})
			address_val = request.POST.get('address')
			if not address_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Address is required'})
			if userrole_val == 'driver':
				vehicletype_val = request.POST.get('vehicletype')
				if not vehicletype_val:
					return JsonResponse({'status_code': 0, 'status_message': 'Vehicle Type is required'})
				vehiclenumber_val = request.POST.get('vehiclenumber')
				if not vehiclenumber_val:
					return JsonResponse({'status_code': 0, 'status_message': 'Vehicle Number is required'})
				preferredarea_val = request.POST.get('preferredarea')
				if not preferredarea_val:
					return JsonResponse({'status_code': 0, 'status_message': 'Preferred Area is required'})

			elif userrole_val == 'company':
				companyname_val = request.POST.get('companyname')
				if not companyname_val:
					return JsonResponse({'status_code': 0, 'status_message': 'Company Name is required'})
				tinnumber_val = request.POST.get('tinnumber')
				if not tinnumber_val:
					return JsonResponse({'status_code': 0, 'status_message': 'TIN Number is required'})
			print('0')
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				return JsonResponse({'status_code': 0, 'status_message': 'User exists.'})
			else:
				otp_val = request.POST.get('otp')
				if not otp_val:
					return JsonResponse({'status_code': 0, 'status_message': 'OTP is required'})
				otp_obj = OTP.objects.filter(mobile = countrycode_val + phone_val, case = 'signup', otp = otp_val).first()
				if otp_obj:
					currentdatetime = datetime.datetime.now(pytz.timezone('UTC'))
					print(currentdatetime)
					print(otp_obj.startdatetime)
					print(otp_obj.expiredatetime)
					if (currentdatetime >= otp_obj.startdatetime and currentdatetime <= otp_obj.expiredatetime):
						otp_obj.verified = True
						otp_obj.save()
						user_obj = User.objects.create_user(username = email_val, email = email_val, password = password_val, first_name = firstname_val, last_name = lastname_val)
						if user_obj:
							if userrole_val == 'customer':
								customer_obj = Customer.objects.create(user = user_obj, countrycode = countrycode_val, phone = phone_val, address = address_val)
								if customer_obj:
									return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
							elif userrole_val == 'company':
								company_obj = Company.objects.create(user = user_obj, countrycode = countrycode_val, phone = phone_val, address = address_val, name = companyname_val, tinnumber = tinnumber_val)
								if company_obj:
									return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
							elif userrole_val == 'driver':
								driver_obj = DriverModel.objects.create(user = user_obj, countrycode = countrycode_val, phone = phone_val, address = address_val, vehicletype = vehicletype_val, vehiclenumber = vehiclenumber_val, preferredarea = preferredarea_val)
								if driver_obj:
									return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
							else:
								return JsonResponse({'status_code' : 0, 'status_message' : 'Record not created.'})
						return JsonResponse({'status_code': 0, 'status_message': 'Some backend error occurred.'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'OTP has been expired.'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP.'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 0, 'status_message': str(e)})

	def get_context_data(self,**kwargs):
		context = super(CustomerRegistration, self).get_context_data(**kwargs)
		print("CustomerRegistration-in get ")
		return context	


class GetFares(APIView):
	'''This class is being used to return fares according to different vehicle types'''
	def post(self, request, *args, **kwargs):
		try:
			# print(request.POST)
			print("GetFaresTest API- in post ")
			session_token_val = request.POST.get('session_token')
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')

			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			if not sendercountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender phone number is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})
			
			data = []
			try:
				api_key ='AIzaSyCZt3wR3ItaSSmIhWnRy4hy6FnqmEM81oY'

				pickupaddress_val = pickupaddress_val.replace(' ','')
				pickupaddress_val = pickupaddress_val.replace('#','')
				dropaddress_val = dropaddress_val.replace(' ','')
				dropaddress_val = dropaddress_val.replace('#','')
				source = pickupaddress_val

				dest = dropaddress_val

				url ='https://maps.googleapis.com/maps/api/distancematrix/json?'

				# return response object 
				print(api_key)
				print(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

				r = requests.get(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

				# json method of response object 
				# return json format result 
				x = r.json() 
				print(x) 
				print('\n')
				if x['status'] == 'OK':
					# if x['rows']:
					# print('\n')
					# print(x['rows'][0]['elements'])
					# print('\n')
					multiplicationfactor = 0.000621371192
					# print(x['rows'][0]['elements'][0]['distance']['value'])
					distanceinmiles = float(x['rows'][0]['elements'][0]['distance']['value']) * multiplicationfactor
					print(distanceinmiles)
					vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile')
					if vehicletype_obj:
						for vehicle in vehicletype_obj:
							distance = distanceinmiles
							if distance <= vehicle.fixeddistance:
								rate = vehicle.baserate
							else:
								rate = vehicle.baserate
								print('\n')
								print(vehicle.name)
								print(rate)
								distance = distance - vehicle.fixeddistance
								print(distanceinmiles)
								if distance > int(distance):
									distance = int(distance) + 1
								else:
									distance = distance
								print(distance)
								print(vehicle.addittionalrateperunit)
								rate = rate + distance * vehicle.addittionalrateperunit
								print(rate)
							image = str(settings.WEB_BASE_URL)
							if vehicle.name == 'Bike':
								image += '/static/images/bike.png'
							elif vehicle.name == 'Car':
								image += '/static/images/car.jpg'
							elif vehicle.name == 'smallvan':
								image += '/static/images/smallvan.png'
							elif vehicle.name == 'mediumvan':
								image += '/static/images/smallvan.png'
							elif vehicle.name == 'largevan':
								image += '/static/images/largevan.jpg'
							
								
							data.append({'vehicletype' : vehicle.name, 'price' : str(round(float(rate),2)), 'currency' : vehicle.currency, 'image' : image})

					# print(x) 

				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Enter valid address'})
			except Exception as e:
				print(e)
				return JsonResponse({'status_code': 400, 'status_message': 'Enter valid address'})
				# data.append({"vehicletype":'bike','price' : 10.0, 'image': 'http://13.126.26.12/static/images/bike.png'})
				# data.append({"vehicletype":'car','price' : 20.0, 'image': 'http://13.126.26.12/static/images/car.jpg'})
				# data.append({"vehicletype":'smallvan','price' : 30.0, 'image': 'http://13.126.26.12/static/images/smallvan.png'})
				# data.append({"vehicletype":'mediumvan','price' : 40.0, 'image': 'http://13.126.26.12/static/images/smallvan.png'})
				# data.append({"vehicletype":'largevan','price' : 50.0, 'image': 'http://13.126.26.12/static/images/largevan.jpg'})
				

			return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'data' : data})			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})

class GetFaresTest(APIView):
	'''This class is being used to return fares according to different vehicle types'''
	def post(self, request, *args, **kwargs):
		try:
			print("GetFaresTest API- in post ")
			print('\n\n')
			# print(request.POST)
			# print('\n\n')

			def getdistancebetweentwolocations(sendercoordinates_val, recipientcoordinates_val):
				try:
					api_key = str(settings.GOOGLE_API_KEY)
					url ='https://maps.googleapis.com/maps/api/distancematrix/json?'
					if sendercoordinates_val and recipientcoordinates_val:
					# return response object 
						print(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
						r = requests.get(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
					# else:
					# 	print(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)
					# 	r = requests.get(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

					x = r.json() 
					print(x) 
					print('\n')
					if x['status'] == 'OK':
						multiplicationfactor = 0.000621371192
						distanceinmiles = float(x['rows'][0]['elements'][0]['distance']['value']) * multiplicationfactor
						# print(distanceinmiles)
						senderlatitude = str(sendercoordinates_val.split(',')[0])
						senderlongitude = str(sendercoordinates_val.split(',')[1])
						recipientlatitude = str(recipientcoordinates_val.split(',')[0])
						recipientlongitude = str(recipientcoordinates_val.split(',')[1])
						distancetable_obj = DistanceTable(senderlatitude = senderlatitude, senderlongitude = senderlongitude, recipientlatitude = recipientlatitude, recipientlongitude = recipientlongitude, distance = distanceinmiles, distanceunit = 'mile', time = x['rows'][0]['elements'][0]['duration']['value'])
						distancetable_obj.save()
						return(200, 'success', distanceinmiles)
					else:
						return(400, 'Enter valid address', '')
						
				except Exception as e:
					print(e)
					return(400, 'Enter valid address', '')


			def calculatefarefromdistanceforvehicletype(distanceinmiles, vehicletype_val):
				data = []
				try:
					vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', name = vehicletype_val).first()
					if vehicletype_obj:
						distance = distanceinmiles
						if distance <= vehicletype_obj.fixeddistance:
							rate = vehicletype_obj.baserate
						else:
							rate = vehicletype_obj.baserate
							distance = distance - vehicletype_obj.fixeddistance
							if distance > int(distance):
								distance = int(distance) + 1
							else:
								distance = distance
							rate = rate + distance * vehicletype_obj.addittionalrateperunit
							
					return(200, 'success', round(float(rate),2))
				except Exception as e:
					print(e)
					return(400, 'Enter valid address', data)

			

			parcels_data = request.POST.get('parcels_data')
			noofparcels_val = request.POST.get('noofparcels')
			print('0')
			print(type(parcels_data))
			parcels_data = json.loads(parcels_data)
			print('1')
			print(parcels_data)
			total_price = 0.0
			api_key = str(settings.GOOGLE_API_KEY)
			data = []
			noofparcels_forspecialbooking = 0
			for parcel in parcels_data:
				print('\n')
				try:
					if parcel['specialbooking'] == 'yes':
						noofparcels_forspecialbooking += 1
				except Exception as e:
					print(e)
				pickupaddress_val = parcel['pickupaddress']
				dropaddress_val = parcel['dropaddress']

				senderlatitude_val = parcel['senderlatitude']
				senderlongitude_val = parcel['senderlongitude']
				recipientlatitude_val = parcel['recipientlatitude']
				recipientlongitude_val = parcel['recipientlongitude']
				distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
				if distancetable_obj:
					print('distance found in DistanceTable')
					distance = distancetable_obj.distance
				else:
					print('distance not found in DistanceTable')
					sendercoordinates_val = parcel['senderlatitude'] + ',' + parcel['senderlongitude']
					recipientcoordinates_val = parcel['recipientlatitude'] + ',' + parcel['recipientlongitude']
					status_code, status_message, distanceinmiles = getdistancebetweentwolocations( sendercoordinates_val = sendercoordinates_val, recipientcoordinates_val = recipientcoordinates_val)
					print(status_code, status_message, distanceinmiles)
					if status_code == 200:
						distance = distanceinmiles
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Please select same country for pickup and dropoff'})

				vehicle_count = VehicleType.objects.filter(distanceunit = 'mile', isdeleted = False).count()
				vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', isdeleted = False)
				if vehicletype_obj:
					for vehicle in vehicletype_obj:
						# distance = totaldistanceinmiles
						if distance <= vehicle.fixeddistance:
							rate = vehicle.baserate
						else:
							rate = vehicle.baserate
							print('\n')
							print(vehicle.name)
							print(rate)
							distance = distance - vehicle.fixeddistance
							# print(totaldistanceinmiles)
							if distance > int(distance):
								distance = int(distance) + 1
							else:
								distance = distance
							print(distance)
							print(vehicle.addittionalrateperunit)
							rate = rate + distance * vehicle.addittionalrateperunit
							print(rate)
						image = str(settings.WEB_BASE_URL)
						if vehicle.name == 'Bike':
							image += '/static/images/bike.png'
						elif vehicle.name == 'Car':
							image += '/static/images/car.jpg'
						elif vehicle.name == 'Small Van':
							image += '/static/images/smallvan.png'
						elif vehicle.name == 'Medium Van':
							image += '/static/images/smallvan.png'
						elif vehicle.name == 'Large Van':
							image += '/static/images/largevan.jpg'
						
						if len(data) < vehicle_count:	
							data.append({"vehicletype" : vehicle.name, 'price' : round(float(rate),2), 'image' : image, "currency" : vehicle.currency,})
						else:
							# print('second entry for vehicle type')
							for item in data:
								if item["vehicletype"] == vehicle.name:
									item["price"]+= rate

							
				print(data)
			backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
			if backendcontrol_obj:
				specialbookingcharges = backendcontrol_obj.price
			else:
				specialbookingcharges = 10
			extracharges = noofparcels_forspecialbooking * specialbookingcharges
			return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'data' : data, 'extracharges' : extracharges})			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})


class PlaceOrder(APIView):
	'''This class is being used to save the customer job request details in the database'''
	
	def post(self, request, *args, **kwargs):
		print('\n\n')
		print('PlaceOrder API - in post')
		# print('data is  : ',request.POST)
		try:
			# print(request.POST)
			
			def generateqrcode(id_val):
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					pass
				else:
					os.mkdir(filepath)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')


			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				base64_data = codec.split(";base64,")
				extens = base64_data[0]
				ext = extens.split("/")
				extension = str(ext[1])
				base64_data = base64_data[1]
				byte_data = base64.b64decode(base64_data)
				image_data = BytesIO(byte_data)
				from PIL import Image
				import string, random, os
				img = Image.open(image_data)
				customerjob_obj = CustomerJob.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.mkdir(filepath)
				img = Image.open(image_data)
				im = img.thumbnail([400,400], Image.ANTIALIAS)
				im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
				customerjob_obj.image = filename
				customerjob_obj.save()
				return('1')



			session_token_val = request.POST.get('session_token')
			payment_token = request.POST.get('payment_token')
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			senderlatitude_val = request.POST.get('senderlatitude')
			senderlongitude_val = request.POST.get('senderlongitude')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')
			recipientspecialnote_val = request.POST.get('recipientspecialnote')
			recipientlatitude_val = request.POST.get('recipientlatitude')
			recipientlongitude_val = request.POST.get('recipientlongitude')

			vehicletype_val = request.POST.get('vehicletype')
			price_val = request.POST.get('price')
			imagebase64_val = request.POST.get('imagebase64')
			
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			# if not payment_token:
			# 	return Response({'status': 0, 'message': 'payment_token Empty',})
			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			if not sendercountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender senderphone_val is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})

			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype_val is required'})
			if not price_val:
				return JsonResponse({'status_code': 400, 'status_message': 'price_val is required'})
			# if not imagebase64_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'Image is required'})
			
			if payment_token:
				try:	
					print(payment_token)
					stripe.api_key = 'sk_test_w82uzdTc8eWEVizgPOI0WRnj00n43jBnY5'
					# str(settings.STRIPE_KEY)
					charge = stripe.Charge.create(
					amount=int(float(price_val)*100),
					currency='eur',
					description='Parcel Payment',
					source=payment_token,
					)
					print(charge)
				except Exception as e:
					print('Exception in creating charge = ', e)
			deliveryduration_val = 1
			print('0')
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					print('4')
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype_val).first()
					if vehicletype_obj:
						print('5')
						customerjob_obj = CustomerJob.objects.create(sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = price_val)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': customerjob_obj.id})	
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})	
			user_obj = User.objects.filter(username = 'raheja@yopmail.com').first()
			if user_obj:
				pass	
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			
			token_obj = Token.objects.filter()

			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj, accountapproved = True).first()
				if customer_obj:
					# content_object = customer_obj,
					otp_obj = OTP.objects.filter(case = 'signup',otp = otp_val).last()
					if otp_obj:
						st_time = otp_obj.startdatetime
						ex_time = otp_obj.expiredatetime
						print(st_time)
						print(ex_time)
						timezone = str(settings.TIME_ZONE)
						time = datetime.datetime.now(pytz.timezone(timezone))
						print(time)
						if((time>st_time) and (time<ex_time)):
							otp_obj.verified = True
							otp_obj.save()
							return JsonResponse({'status_code': 200, 'status_message': 'User registered successfully.'})							
						else:
							return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired 1'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
				
			else:
				return JsonResponse({'status_code': 401, 'status_message': 'User not logged in.'})
				
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})


class SignUpOTP(APIView):
	# permission_classes = (AllowAny,)
	# parser_classes = (MultiPartParser, FormParser)
	# permission_classes = (IsAuthenticated,)
	@csrf_exempt
	# @permission_classes((AllowAny,))
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		try:
			print('data is  : ',request.POST)
			
			name_val = request.POST.get('name')
			if not name_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Name is required'})
			email_val = request.POST.get('email')
			if not email_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Email Address is required'})
			countrycode_val = request.POST.get('countrycode')
			if not countrycode_val:
				return JsonResponse({'status_code': 0, 'status_message': 'countrycode is required'})
			if '+' not in countrycode_val:
				countrycode_val = '+' + countrycode_val
			phone_val = request.POST.get('phone')
			if not phone_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Phone number is required'})
			password_val = request.POST.get('password')
			if not password_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Password is required'})
			address_val = request.POST.get('address')
			if not address_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Address is required'})
			print(email_val)
			print(password_val)
			
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				return JsonResponse({'status_code': 0, 'status_message': 'User exists.'})
			
			user_obj = User.objects.create_user(username = email_val, email = email_val, password = password_val)
			customer_obj = Customer.objects.filter(user = user_obj, accountapproved = True)
			if customer_obj:
				return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
			else:
				customer_obj = Customer.objects.create(user = user_obj, countrycode = countrycode_val, phone = phone_val, address = address_val)
				if customer_obj:
					digits = "0123456789"
					otp = ""
					for i in range(5) : 
						otp += digits[math.floor(random.random() * 10)]
					print("OTP of 5 digits:", otp)
					
					start_time = datetime.datetime.now()
					expire_time = datetime.datetime.now() + timedelta(minutes = 15)
					print('1')
					case = 'signup'
					otp_obj = OTP.objects.create(content_object = customer_obj, case = case, otp = otp, startdatetime = start_time, expiredatetime = expire_time)
					print('2')
					return JsonResponse({'status_code': 200, 'status_message': 'OTP sent on phone.'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Registeration not successfull.'})
				

				
				print('3')
				return JsonResponse({'status': 200, 'status_code': 200})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 0, 'status_message': str(e)})


# Create your views here.
class SignUp(APIView):
	# permission_classes = (AllowAny,)
	# parser_classes = (MultiPartParser, FormParser)
	# permission_classes = (IsAuthenticated,)
	@csrf_exempt
	# @permission_classes((AllowAny,))
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		
		print('data is  : ',request.POST)
		try:
			email_val = request.POST.get('email')
			if not email_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Email Address is required'})
			otp_val = request.POST.get('otp')
			if not otp_val:
				return JsonResponse({'status_code': 0, 'status_message': 'OTP is required'})
			fcmtoken_val = request.POST.get('fcmtoken')
			if not fcmtoken_val:
				return JsonResponse({'status_code': 0, 'status_message': 'fcmtoken is required'})
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj, accountapproved = False).first()
				if customer_obj:
					# content_object = customer_obj,
					otp_obj = OTP.objects.filter(case = 'signup',otp = otp_val).last()
					if otp_obj:
						st_time = otp_obj.startdatetime
						ex_time = otp_obj.expiredatetime
						print(st_time)
						print(ex_time)
						timezone = str(settings.TIME_ZONE)
						time = datetime.datetime.now(pytz.timezone(timezone))
						print(time)
						if((time>st_time) and (time<ex_time)):
							otp_obj.verified = True
							otp_obj.save()
							return JsonResponse({'status_code': 200, 'status_message': 'User registered successfully.'})							
						else:
							return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired 1'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
				
			else:
				return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired'})
				
			
		except Exception as e:
			print(e)
			return JsonResponse({'status': 0, 'message': str(e),'status_code': 0, 'status_message': str(e)})



# class PlaceOrder(APIView):
# 	'''This API class is being used to save the customer job request details in the database'''
# 	@csrf_exempt
# 	def post(self, request, *args, **kwargs):
# 		print('\n\n')
# 		print('data is  : ',request.POST)
# 		try:
# 			sendername_val = request.POST.get('sendername')
# 			senderphone_val = request.POST.get('senderphone')
# 			pickupaddress_val = request.POST.get('pickupaddress')
# 			sendercity_val = request.POST.get('sendercity')
# 			currentlocation_val = request.POST.get('currentlocation')
# 			noofparcels_val = request.POST.get('noofparcels')

# 			width_val = request.POST.get('width')
# 			height_val = request.POST.get('height')
# 			weight_val = request.POST.get('weight')
# 			parceltype_val = request.POST.get('parceltype')
# 			specialnote_val = request.POST.get('specialnote')

# 			recipientname_val = request.POST.get('recipientname')
# 			recipientphone_val = request.POST.get('recipientphone')
# 			dropaddress_val = request.POST.get('dropaddress')


# 			if not sendername_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'sendername_val is required'})
# 			if not senderphone_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'Sender senderphone_val is required'})
# 			if not pickupaddress_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'pickupaddress_val is required'})
# 			if not sendercity_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'sendercity_val is required'})
# 			if not currentlocation_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'currentlocation_val is required'})
# 			if not noofparcels_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'noofparcels_val is required'})
# 			if not width_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'width_val is required'})
# 			if not height_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'height_val is required'})
# 			if not weight_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'weight_val is required'})
# 			if not parceltype_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'parceltype_val is required'})
# 			if not specialnote_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'specialnote_val is required'})
# 			if not recipientname_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'recipientname_val is required'})
# 			if not recipientphone_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'recipientphone_val is required'})
# 			if not dropaddress_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'dropaddress_val is required'})
			
# 			session_token_val = request.POST.get('session_token')
# 			if not session_token_val:
# 				return JsonResponse({'status_code': 0, 'status_message': 'User not logged in.'})
			
# 			token_obj = Token.objects.filter()

# 			user_obj = User.objects.filter(username = email_val).first()
# 			if user_obj:
# 				customer_obj = Customer.objects.filter(user = user_obj, accountapproved = False).first()
# 				if customer_obj:
# 					# content_object = customer_obj,
# 					otp_obj = OTP.objects.filter(case = 'signup',otp = otp_val).last()
# 					if otp_obj:
# 						st_time = otp_obj.startdatetime
# 						ex_time = otp_obj.expiredatetime
# 						print(st_time)
# 						print(ex_time)
# 						timezone = str(settings.TIME_ZONE)
# 						time = datetime.datetime.now(pytz.timezone(timezone))
# 						print(time)
# 						if((time>st_time) and (time<ex_time)):
# 							otp_obj.verified = True
# 							otp_obj.save()
# 							return JsonResponse({'status_code': 200, 'status_message': 'User registered successfully.'})							
# 						else:
# 							return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired 1'})
# 					else:
# 						return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP'})
# 				else:
# 					return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
				
# 			else:
# 				return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired'})
				
			
# 		except Exception as e:
# 			print(e)
# 			return JsonResponse({'status': 0, 'message': str(e),'status_code': 0, 'status_message': str(e)})



