# Generated by Django 2.2 on 2022-01-07 09:52

import datetime
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Admin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True, unique=True)),
                ('countrycode', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, max_length=100, null=True)),
                ('image', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('idproof', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('emailverificationlink', models.CharField(blank=True, max_length=300, null=True)),
                ('emailverified', models.BooleanField(default=False)),
                ('accountverified', models.BooleanField(default=False)),
                ('accountapproved', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='AdminTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField()),
                ('status', models.IntegerField(choices=[(0, 'Pending'), (1, 'Completed')], default=0)),
                ('created_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='BackendControl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('price', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('enable', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Chat',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.TextField()),
                ('files', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('sender', models.CharField(blank=True, max_length=200, null=True)),
                ('senderemail', models.CharField(blank=True, max_length=100, null=True)),
                ('created_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=100, null=True)),
                ('currency', models.CharField(blank=True, max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DistanceTable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address1', models.CharField(blank=True, max_length=255, null=True)),
                ('address2', models.CharField(blank=True, max_length=255, null=True)),
                ('senderlatitude', models.CharField(blank=True, max_length=100, null=True)),
                ('senderlongitude', models.CharField(blank=True, max_length=100, null=True)),
                ('recipientlatitude', models.CharField(blank=True, max_length=100, null=True)),
                ('recipientlongitude', models.CharField(blank=True, max_length=100, null=True)),
                ('distance', models.FloatField(blank=True, default=0.0, null=True)),
                ('distanceunit', models.CharField(blank=True, max_length=100, null=True)),
                ('time', models.PositiveIntegerField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Notifications',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customerjobid', models.PositiveIntegerField(blank=True, null=True)),
                ('forcustomer', models.BooleanField(default=False)),
                ('fordriver', models.BooleanField(default=False)),
                ('foradmin', models.BooleanField(default=False)),
                ('others', models.BooleanField(default=False)),
                ('notificationtype', models.CharField(blank=True, max_length=100, null=True)),
                ('notificationtext', models.TextField(blank=True, null=True)),
                ('status', models.CharField(default='unread', max_length=100, null=True)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('deleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='OperationalArea',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('latitude', models.CharField(blank=True, max_length=100, null=True)),
                ('longitude', models.CharField(blank=True, max_length=100, null=True)),
                ('distance_from_centre_point', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('distanceunit', models.CharField(blank=True, default='', max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='OTP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('case', models.CharField(blank=True, max_length=100, null=True)),
                ('mobile', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True)),
                ('otp', models.CharField(blank=True, max_length=100, null=True)),
                ('startdatetime', models.DateTimeField(blank=True, null=True)),
                ('expiredatetime', models.DateTimeField(blank=True, null=True)),
                ('verified', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='ParcelType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parceltype', models.CharField(blank=True, max_length=100, null=True)),
                ('isdeleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Pushers',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('endpoint', models.CharField(max_length=250, null=True)),
                ('auth_key', models.CharField(max_length=250, null=True)),
                ('p256dh_key', models.CharField(max_length=250, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='RadiusControl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('distance', models.FloatField(blank=True, default=0.0, null=True)),
                ('enable', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='RadiusPermission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('distance', models.FloatField(blank=True, default=0.0, null=True)),
                ('status', models.CharField(max_length=100, null=True)),
                ('created_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='SupportDetail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(blank=True, max_length=100, null=True)),
                ('isdeleted', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='ThumbnailSize',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('height', models.CharField(blank=True, max_length=50, null=True)),
                ('width', models.CharField(blank=True, max_length=50, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TimeSlots',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('openinghour', models.TimeField()),
                ('closinghour', models.TimeField()),
                ('active', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='UserRating',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ratingfor', models.CharField(blank=True, max_length=100, null=True)),
                ('customerjobid', models.PositiveIntegerField(blank=True, null=True)),
                ('customerid', models.PositiveIntegerField(blank=True, null=True)),
                ('driverid', models.PositiveIntegerField(blank=True, null=True)),
                ('rating', models.FloatField(blank=True, default=0.0, null=True)),
                ('note', models.CharField(blank=True, max_length=100, null=True)),
                ('deleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='VehicleType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('image', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('carryinglimitinkg', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('fixeddistance', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('distanceunit', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('baserate', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('addittionalrateperunit', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('priceperdrop', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('priceperhour', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('currency', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('heightOfVehical', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('widthOfVehical', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('lengthOfVehical', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('carryingLimitOfVehical', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('isdeleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
    ]
