from django.db import models
from django.contrib.auth.models import User
from django.contrib.contenttypes.fields import GenericForeignKey
from django.contrib.contenttypes.models import ContentType
from django.contrib.auth.models import User
import datetime
from django.apps import apps
from django.utils.translation import gettext as _
# MyModel1 = apps.get_model('Driver', 'DriverModel')



# Create your models here.

class Admin(models.Model):
	"""
	This model is used to store the information of Customer.
	"""
	user = models.ForeignKey(User, on_delete = models.CASCADE, null = True, blank = True)
	name = models.CharField(max_length = 100, null = True, blank = True)
	email = models.CharField(max_length = 100, unique = True, null = True, blank = True)
	countrycode = models.CharField(max_length = 100, null = True, blank = True)
	phone = models.CharField(max_length = 100, blank = True, null = True)
	image = models.FileField(max_length = 200, blank = True, null = True)
	idproof = models.FileField(max_length = 200, blank = True, null = True)
	emailverificationlink = models.CharField(max_length = 300, blank = True, null = True)
	emailverified = models.BooleanField(default = False)
	accountverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	
	def __str__(self):
		return str(self.user)

TASKSTATUS_CHOICES = (
    (0, _("Pending")),
    (1, _("Completed")),
)

class AdminTask(models.Model):
	admin = models.ForeignKey(Admin, on_delete = models.CASCADE)
	description = models.TextField()
	status = models.IntegerField(choices = TASKSTATUS_CHOICES, default = 0) # default = Pending
	created_at = models.DateTimeField(auto_now=True)
	updated_at = models.DateTimeField(auto_now_add=True)

class TimeSlots(models.Model):
	openinghour = models.TimeField()
	closinghour = models.TimeField()
	active = models.BooleanField(default = False)
	
	def __str__(self):
		return (str(self.openinghour) + str(self.closinghour))

class BackendControl(models.Model):
	name = models.CharField(max_length = 100, blank = True, null = True)
	price = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	enable = models.BooleanField(default = False)
	
	def __str__(self):
		return (str(self.name) + str(self.enable))

class OperationalArea(models.Model):
	name = models.CharField(max_length = 100, blank = True, null = True)
	latitude = models.CharField(max_length = 100, blank = True, null = True)
	longitude = models.CharField(max_length = 100, blank = True, null = True)
	distance_from_centre_point = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	distanceunit = models.CharField(max_length = 100, default = '', null = True, blank = True)
	
	def __str__(self):
		return (str(self.name) + ' - ' + str(self.distance_from_centre_point) + ' ' + str(self.distanceunit))

class Pushers(models.Model):
    user=models.ForeignKey(User,on_delete=models.CASCADE,null=True,blank=True)
    endpoint = models.CharField(max_length=250,null=True)
    auth_key = models.CharField(max_length=250,null=True)
    p256dh_key = models.CharField(max_length=250,null=True)

    def __str__(self):
        return str(self.id)

class Country(models.Model):
	"""
	This model is used to store the information of countries.
	"""
	name = models.CharField(max_length = 100, null = True, blank = True)
	abbreviation = models.CharField(max_length = 100, null = True, blank = True)
	currency = models.CharField(max_length = 100, null = True, blank = True)
	
	def __str__(self):
		return str(self.name)

class City(models.Model):
	"""
	This model is used to store the information of cities.
	"""
	country = models.ForeignKey(Country, on_delete = models.CASCADE, null = True, blank = True)
	name = models.CharField(max_length = 100, null = True, blank = True)

	def __str__(self):
		return str(self.name)


class VehicleType(models.Model):
	"""
	This model is used to store the information of vehicle types.
	"""
	name = models.CharField(max_length = 100, null = True, blank = True)
	image = models.FileField(max_length = 200, default = '', blank = True, null = True)
	carryinglimitinkg = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	fixeddistance = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	distanceunit = models.CharField(max_length = 100, default = '', null = True, blank = True)
	baserate = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	addittionalrateperunit = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	priceperdrop = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	priceperhour = models.FloatField(max_length = 100, default = 0.0, null = True, blank = True)
	currency = models.CharField(max_length = 100, default = '', null = True, blank = True)
	heightOfVehical = models.CharField(max_length = 100, default = '', null = True, blank = True)
	widthOfVehical = models.CharField(max_length = 100, default = '', null = True, blank = True)
	lengthOfVehical = models.CharField(max_length = 100, default = '', null = True, blank = True)
	carryingLimitOfVehical = models.CharField(max_length = 100, default = '', null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now=True,null=True)
	updated_at = models.DateTimeField(auto_now_add=True,null=True)
	
	def __str__(self):
		return str(self.name)



class SupportDetail(models.Model):
	"""
	This model is used to store the support details.
	"""
	phone = models.CharField(max_length = 100, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	
	def __str__(self):
		return str(self.id)

class ParcelType(models.Model):
	"""
	This model is used to store the information of parcel types.
	"""
	parceltype = models.CharField(max_length = 100, null = True, blank = True)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now=True,null=True)
	updated_at = models.DateTimeField(auto_now_add=True,null=True)
	
	def __str__(self):
		return str(self.parceltype)

class ThumbnailSize(models.Model):
    height = models.CharField(max_length=50,null=True,blank=True)
    width = models.CharField(max_length=50,null=True,blank=True)
    
    def __str__(self):
        return str(str(self.height)+'*'+str(self.width)) 
        
class OTP(models.Model):
	"""
	This model is used to store the information regarding OTP.
	"""
	# content_type =   models.ForeignKey(ContentType, on_delete = models.CASCADE, null = True)
	# object_id = models.PositiveIntegerField()
	# content_object=GenericForeignKey('content_type', 'object_id')

	case = models.CharField(max_length = 100, null = True, blank = True)
	mobile = models.CharField(max_length = 100, null = True, blank = True)
	email = models.CharField(max_length = 100, null = True, blank = True)
	otp = models.CharField(max_length = 100, null = True, blank = True)
	startdatetime = models.DateTimeField(null=True,blank=True)
	expiredatetime = models.DateTimeField(null=True,blank=True)
	verified = models.BooleanField(default = False)

	def __str__(self):
		return str(self.mobile)



class Notifications(models.Model):
    user = models.ForeignKey(User,on_delete=models.SET_NULL,null=True,blank=True)
    customerjobid = models.PositiveIntegerField(null=True, blank=True)
    forcustomer = models.BooleanField(default=False)
    fordriver = models.BooleanField(default=False)
    foradmin = models.BooleanField(default=False)
    others = models.BooleanField(default=False)
    notificationtype = models.CharField(max_length=100, blank=True, null=True)
    notificationtext = models.TextField(null=True,blank=True)
    status = models.CharField(max_length=100,default='unread',null=True)
    date = models.DateTimeField(default=datetime.datetime.now)
    deleted = models.BooleanField(default=False)

    created_at = models.DateTimeField(auto_now=True,null=True)
    updated_at = models.DateTimeField(auto_now_add=True,null=True)
    def __str__(self):
        return str(self.id)


class UserRating(models.Model):
    ratingfor = models.CharField(max_length = 100, blank = True, null = True)
    customerjobid = models.PositiveIntegerField(blank = True, null = True)
    customerid = models.PositiveIntegerField(blank = True, null = True)
    driverid = models.PositiveIntegerField(blank = True, null = True)
    rating = models.FloatField(default = 0.0, blank = True, null = True)
    note = models.CharField(max_length = 100, blank = True, null = True)
    deleted = models.BooleanField(default=False)

    created_at = models.DateTimeField(auto_now=True,null=True)
    updated_at = models.DateTimeField(auto_now_add=True,null=True)
    def __str__(self):
        return str(self.id)


class DistanceTable(models.Model):
    address1 = models.CharField(max_length = 255, blank = True, null = True)
    address2 = models.CharField(max_length = 255, blank = True, null = True)
    senderlatitude = models.CharField(max_length = 100, blank = True, null = True)
    senderlongitude = models.CharField(max_length = 100, blank = True, null = True)
    recipientlatitude = models.CharField(max_length = 100, blank = True, null = True)
    recipientlongitude = models.CharField(max_length = 100, blank = True, null = True)
    distance = models.FloatField(default = 0.0, blank = True, null = True)
    distanceunit = models.CharField(max_length = 100, blank = True, null = True)
    time = models.PositiveIntegerField(blank = True, null = True)
    
    created_at = models.DateTimeField(auto_now=True,null=True)
    updated_at = models.DateTimeField(auto_now_add=True,null=True)
    def __str__(self):
        return str(self.id)

from Driver.models import DriverModel
class Chat(models.Model):
	driver = models.ForeignKey(DriverModel, on_delete = models.CASCADE)
	admin = models.ForeignKey(Admin, on_delete = models.CASCADE)
	message=models.TextField()
	files = models.FileField(max_length = 200,blank = True, null = True)
	sender = models.CharField(blank=True, max_length=200, null=True)
	senderemail = models.CharField(max_length=100, blank=True, null=True)
	created_at = models.DateTimeField(auto_now=True)
	updated_at = models.DateTimeField(auto_now_add=True)

	def __str__(self):
		return str(self.message+'    -------Admin------     '+str(self.admin.name)+'-- driver  ---'+str(self.driver))

class RadiusControl(models.Model):
	distance = models.FloatField(default = 0.0, blank = True, null = True)
	enable = models.BooleanField(default = False)
	
	def __str__(self):
		return (str(self.distance))

from Driver.models import DriverJob
from Customer.models import CustomerJob
class RadiusPermission(models.Model):
	driverjob=models.ForeignKey(DriverJob, on_delete = models.CASCADE)
	customerjob=models.ForeignKey(CustomerJob, on_delete = models.CASCADE, null = True, blank = True)
	distance = models.FloatField(default = 0.0, blank = True, null = True)
	status = models.CharField(max_length=100,null=True)
	created_at = models.DateTimeField(auto_now=True)
	def __str__(self):
		return (str(self.distance))