# Generated by Django 2.2.11 on 2020-06-25 21:49

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('Driver', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('Customer', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=100, null=True)),
                ('currency', models.CharField(blank=True, max_length=100, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='OTP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('case', models.CharField(blank=True, max_length=100, null=True)),
                ('mobile', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True)),
                ('otp', models.CharField(blank=True, max_length=100, null=True)),
                ('startdatetime', models.DateTimeField(blank=True, null=True)),
                ('expiredatetime', models.DateTimeField(blank=True, null=True)),
                ('verified', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='ParcelType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parceltype', models.CharField(blank=True, max_length=100, null=True)),
                ('isdeleted', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='SupportDetail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(blank=True, max_length=100, null=True)),
                ('isdeleted', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='ThumbnailSize',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('height', models.CharField(blank=True, max_length=50, null=True)),
                ('width', models.CharField(blank=True, max_length=50, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='VehicleType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('image', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('carryinglimitinkg', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('fixeddistance', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('distanceunit', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('baserate', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('addittionalrateperunit', models.FloatField(blank=True, default=0.0, max_length=100, null=True)),
                ('currency', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('isdeleted', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Pushers',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('endpoint', models.CharField(max_length=250, null=True)),
                ('auth_key', models.CharField(max_length=250, null=True)),
                ('p256dh_key', models.CharField(max_length=250, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Notifications',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customerjobid', models.PositiveIntegerField(blank=True, null=True)),
                ('forcustomer', models.BooleanField(default=False)),
                ('fordriver', models.BooleanField(default=False)),
                ('foradmin', models.BooleanField(default=False)),
                ('others', models.BooleanField(default=False)),
                ('notificationtype', models.CharField(blank=True, max_length=100, null=True)),
                ('notificationtext', models.TextField(blank=True, null=True)),
                ('status', models.CharField(default='unread', max_length=100, null=True)),
                ('date', models.DateTimeField(default=datetime.datetime.now)),
                ('deleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='MatchedParcelDriverModal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.BooleanField(default=False)),
                ('parcelpickup', models.BooleanField(default=False)),
                ('jobcompleted', models.BooleanField(default=False)),
                ('iscancelledbyadmin', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
                ('matchedddriver', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverModel')),
                ('matchedparcel', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
            ],
        ),
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('country', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='AdminApp.Country')),
            ],
        ),
        migrations.CreateModel(
            name='Admin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True, unique=True)),
                ('countrycode', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, max_length=100, null=True)),
                ('image', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('idproof', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('emailverificationlink', models.CharField(blank=True, max_length=300, null=True)),
                ('emailverified', models.BooleanField(default=False)),
                ('accountverified', models.BooleanField(default=False)),
                ('accountapproved', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
