from django.shortcuts import render
from django.views.generic.base import TemplateView
from django.http import HttpResponse, JsonResponse, HttpResponseRedirect
from django.contrib.auth import authenticate
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .decorators import checkloginadmin
from django.utils.decorators import method_decorator
from Customer.models import *
from Customer.commonfunctions import sendfcmnotification,send_text_message
from Driver.models import *
from .models import *
import json, base64, os, random, string
from io import BytesIO
from PIL import Image
from django.conf import settings
from django.urls import reverse
from pywebpush import webpush, WebPushException
from rest_framework.views import APIView
from django.core.paginator import Paginator
from .adminfunctions import sendnewusermail
from django.core.files.storage import FileSystemStorage
import sys, pytz
from math import radians, cos, sin, asin, sqrt
import stripe
from django.core.mail import send_mail
from django.core import mail

from django.contrib.auth import get_user_model
# Create your views here.
#Create and Edit By manpreet 6/11/2020

def take_second(elem):
	return elem['priorityBaseIDJobs']
def take_second2(elem):
	return elem['priorityBaseIDForParcel']

class viewProrityBasedJobs(TemplateView):
	template_name = 'viewProrityBasedJobs.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(viewProrityBasedJobs, self).get_context_data(**kwargs)
		print("viewProrityBasedJobs-viewProrityBasedJobs get ")
		driverid = kwargs['driverid']
		allDetailsOfDrivers=[]
		driver_obj = DriverModel.objects.filter(id=driverid).first()
		if driver_obj:
			countLoop=[]
			unique=[]
			driverJOB_OBJ=DriverJob.objects.filter(driver=driver_obj,jobstarted=False,jobcompleted=False)
			if driver_obj:
				pass
				driverlatitude, driverlongitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
				if drivercoordinates_obj:
					print('drivercoordinates_obj exists')
					driverlatitude = drivercoordinates_obj.latitude
					driverlongitude = drivercoordinates_obj.longitude
				print('drivercoordinates_obj does not exist')
				for job in driverJOB_OBJ:

					if job.customerjob.sameIdForParcelsDetails not in unique:
						if job.customerjob.sameIdForParcelsDetails!=0:
							unique.append(job.customerjob.sameIdForParcelsDetails)
						if job.customerjob.order.ordertype == 1:
							ordertype = 'Single-Drop'
						elif job.customerjob.order.ordertype == 2:
							ordertype = 'Multi-Drop'
						else:
							ordertype = ''
						allDetailsOfDrivers.append({
							'id':job.id,
							'pickup':job.customerjob.pickupaddress,
							'drop':job.customerjob.dropoffaddress,
							'name':job.driver.name,
							'email':job.driver.email,
							'customerName':job.customerjob.customer.name,
							'pickupDate':job.customerjob.pickuptimeslotDate,
							'pickupTime':job.customerjob.pickuptimeslot,
							'noofitems':job.customerjob.no_of_item_in_parcel,
							'senderLat':job.customerjob.senderlatitude,
							'senderLong':job.customerjob.senderlongitude,
							'recipientLat':job.customerjob.recipientlatitude,
							'recipientLong':job.customerjob.recipientlongitude,
							'priorityBaseIDJobs':job.priorityBaseIDJobs,
							'ordertype':ordertype,
							'dateOFPickup':job.customerjob.pickuptimeslotDate,
							'driver_latitude':driverlatitude,
							'driver_longitude':driverlongitude,
							'sameIdForParcelsDetails':job.sameIdForParcels,


							})
						countLoop.append(job.priorityBaseIDJobs)
		listisEmpty=''
		if not allDetailsOfDrivers:
			listisEmpty='yes'
		else:
			listisEmpty='no'
		outstandingdriverjobs_datanew = sorted(allDetailsOfDrivers, key=take_second)
		paginator = Paginator(outstandingdriverjobs_datanew, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")

		context['driversData'] = driversData
		context['countLoop'] = countLoop
		context['title'] = 'revenue'
		context['listisEmpty'] = listisEmpty
		return context

class viewProrityofParcel(TemplateView):
	template_name = 'viewProrityofParcel.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(viewProrityofParcel, self).get_context_data(**kwargs)
		print("viewProrityofParcel-viewProrityofParcel get ")
		driverid = kwargs['sameparcelID']
		allParcelDetails=[]
		countLoop=[]
		customerJob = CustomerJob.objects.filter(sameIdForParcelsDetails=driverid)
		for cust in customerJob:
			driverlatitude, driverlongitude = '', ''
			jobDriverObj=DriverJob.objects.filter(customerjob=cust).first()
			if jobDriverObj:
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = jobDriverObj.driver).first()
				if drivercoordinates_obj:
					print('drivercoordinates_obj exists')
					driverlatitude = drivercoordinates_obj.latitude
					driverlongitude = drivercoordinates_obj.longitude
			allParcelDetails.append({'id':cust.id,
			                         'customerName':cust.customer.name,
			                         'recipientName':cust.recipientname,
			                         'dateOFPickup':cust.pickuptimeslotDate,
			                         'senderLat':cust.senderlatitude,
			                         'senderLong':cust.senderlongitude,
			                         'recipientLat':cust.recipientlatitude,
			                         'recipientLong':cust.recipientlongitude,
			                         'driver_latitude':driverlatitude,
			                         'driver_longitude':driverlongitude,
			                         'priorityBaseIDForParcel':cust.priorityBaseIDForParcel,
			                         'pickupSlot':cust.pickuptimeslot,
			                         'dropSlot':cust.dropofftimeslot,})
			countLoop.append(cust.priorityBaseIDForParcel)
		listisEmpty=''
		if not allParcelDetails:
			listisEmpty='yes'
		else:
			listisEmpty='no'
		outstandingdriverjobs_datanew = sorted(allParcelDetails, key=take_second2)
		paginator = Paginator(outstandingdriverjobs_datanew, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")

		context['viewJobId'] = driverid
		context['driversData'] = driversData
		context['countLoop'] = countLoop
		context['title'] = 'revenue'
		context['listisEmpty'] = listisEmpty
		return context
		if driver_obj:
			countLoop=[]
			unique=[]
			driverJOB_OBJ=DriverJob.objects.filter(driver=driver_obj,jobstarted=False,jobcompleted=False)
			if driver_obj:
				pass
				driverlatitude, driverlongitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
				if drivercoordinates_obj:
					print('drivercoordinates_obj exists')
					driverlatitude = drivercoordinates_obj.latitude
					driverlongitude = drivercoordinates_obj.longitude
				print('drivercoordinates_obj does not exist')
				for job in driverJOB_OBJ:

					if job.customerjob.sameIdForParcelsDetails not in unique:
						if job.customerjob.sameIdForParcelsDetails!=0:
							unique.append(job.customerjob.sameIdForParcelsDetails)
						if job.customerjob.order.ordertype == 1:
							ordertype = 'Single-Drop'
						elif job.customerjob.order.ordertype == 2:
							ordertype = 'Multi-Drop'
						else:
							ordertype = ''
						allDetailsOfDrivers.append({
							'id':job.id,
							'pickup':job.customerjob.pickupaddress,
							'drop':job.customerjob.dropoffaddress,
							'name':job.driver.name,
							'email':job.driver.email,
							'customerName':job.customerjob.customer.name,
							'pickupDate':job.customerjob.pickuptimeslotDate,
							'pickupTime':job.customerjob.pickuptimeslot,
							'noofitems':job.customerjob.no_of_item_in_parcel,
							'senderLat':job.customerjob.senderlatitude,
							'senderLong':job.customerjob.senderlongitude,
							'recipientLat':job.customerjob.recipientlatitude,
							'recipientLong':job.customerjob.recipientlongitude,
							'priorityBaseIDJobs':job.priorityBaseIDJobs,
							'ordertype':ordertype,
							'dateOFPickup':job.customerjob.pickuptimeslotDate,
							'driver_latitude':driverlatitude,
							'driver_longitude':driverlongitude,
							'sameIdForParcelsDetails':job.sameIdForParcels,


							})
						countLoop.append(job.priorityBaseIDJobs)
		outstandingdriverjobs_datanew = sorted(allDetailsOfDrivers, key=take_second)
		paginator = Paginator(outstandingdriverjobs_datanew, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")

		context['driversData'] = driversData
		context['countLoop'] = countLoop
		context['title'] = 'revenue'
		return context

def changePriority(request, *args, **kwargs):
	print('changePriority by admin')
	try:
		data_ids = request.POST.get('data_ids')
		print("my one")
		print(request.POST.get('data_ids'))
		# print(request.POST)
		data_ids = json.loads(data_ids)
		print(data_ids)
		all_data_response=[]
		sameIdParcelCopy=0
		for ids in data_ids:
			print("my two")
			print(ids['job'])
			print(ids['priority'])
			customerID=ids['job']
			prorityID=ids['priority']
			customerjob_obj = CustomerJob.objects.filter(id = customerID).first()
			customerjob_obj.priorityBaseIDForParcel=prorityID
			customerjob_obj.save()
		return JsonResponse({'status_code':200})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code':0})

def changePriorityofJob(request, *args, **kwargs):
	print('changePriorityofJob by admin')
	try:
		data_ids = request.POST.get('data_ids')
		print("my one")
		print(request.POST.get('data_ids'))
		# print(request.POST)
		data_ids = json.loads(data_ids)
		print(data_ids)
		all_data_response=[]
		sameIdParcelCopy=0
		for ids in data_ids:
			print("my two")
			print(ids['job'])
			print(ids['priority'])
			customerID=ids['job']
			prorityID=ids['priority']
			customerjob_obj = DriverJob.objects.filter(sameIdForParcels = customerID)
			for cust in customerjob_obj:
				cust.priorityBaseIDJobs=prorityID
				cust.save()
		return JsonResponse({'status_code':200})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code':0})

class driverPickupsAndDrops(TemplateView):
	template_name = 'driverPickupsAndDrops.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(driverPickupsAndDrops, self).get_context_data(**kwargs)
		print("driverPickupsAndDrops-driverPickupsAndDrops get ")
		driverid = kwargs['driverid']
		allDetailsOfDrivers=[]
		driver_obj = DriverModel.objects.filter(id=driverid).first()
		if driver_obj:
			driverJOB_OBJ=DriverJob.objects.filter(driver=driver_obj)
			if driverJOB_OBJ:
				for job in driverJOB_OBJ:
					allDetailsOfDrivers.append({
						'id':job.id,
						'pickup':job.customerjob.pickupaddress,
						'drop':job.customerjob.dropoffaddress,
						'name':job.driver.name,
						'email':job.driver.email,
						'customerName':job.customerjob.customer.name,
						'pickupDate':job.customerjob.pickuptimeslotDate,
						'pickupTime':job.customerjob.pickuptimeslot,
						'noofitems':job.customerjob.no_of_item_in_parcel,
						'senderLat':job.customerjob.senderlatitude,
						'senderLong':job.customerjob.senderlongitude,
						'recipientLat':job.customerjob.recipientlatitude,
						'recipientLong':job.customerjob.recipientlongitude,

						})
		paginator = Paginator(allDetailsOfDrivers, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")

		context['driversData'] = driversData
		context['title'] = 'revenue'
		return context


@method_decorator(checkloginadmin, name='dispatch')
class revenueDays(TemplateView):
	template_name = 'Revenue.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(revenueDays, self).get_context_data(**kwargs)
		print("revenueDays-in get ")
		driver_obj = DriverModel.objects.all().order_by('-id')
		drivercommission=0.0
		admincommission=0.0
		totalEarnings=0.0
		srno=0
		driversData=[]
		today = datetime.date.today()

		for d in driver_obj:
			
			onDriverEarnings=0.0
			totalCompletedJob=0
			totalCompletedJob = DriverJob.objects.filter(driver = d, jobcompleted = True).count()
			driverjob_obj = DriverJob.objects.filter(driver = d, jobcompleted = True).order_by('-id')
			if driverjob_obj:
				srno=srno+1
				print('\n')
				for job in driverjob_obj:
					if job.customerjob.price:
						dateFind=False
						if job.created_at.date() == today and job.created_at.year == today.year:
							dateFind=True
							drivercommission = drivercommission+float(round(((70 * job.customerjob.price)/100),2))
							onDriverEarnings =onDriverEarnings+float(round(((70 * job.customerjob.price)/100),2))
							admincommission=admincommission+float(round(((30 * job.customerjob.price)/100),2))
							totalEarnings=totalEarnings+float(job.customerjob.price)
							
					else:
						onDriverEarnings=onDriverEarnings+0.0
						drivercommission = drivercommission+0.0
						admincommission=admincommission+0.0
						totalEarnings=totalEarnings+0.0
				
				if dateFind==True:
					onDriverEarnings=str(round(onDriverEarnings,2))
					driversData.append({'srno':srno,
						                'name':d.name,
				                        'total':onDriverEarnings,
				                        'jobcount':totalCompletedJob,
				                        'id':d.id,})
				
			else:
				drivercommission = drivercommission+0.0
				admincommission=admincommission+0.0
				totalEarnings=totalEarnings+0.0
		totalEarnings=str(round(totalEarnings,2))
		admincommission =str(round(admincommission,2))
		drivercommission =str(round(drivercommission,2))
		print(drivercommission)
		print(admincommission)
		print(totalEarnings)
		print(driversData)
		paginator = Paginator(driversData, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		print('allVehicals',vehicalList)
		context['allVehicals']=vehicalList
		context['driversData'] = driversData
		context['drivercommission'] = drivercommission
		context['admincommission'] = admincommission
		context['totalEarnings'] = totalEarnings
		context['title'] = 'revenue'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class revenueWeekly(TemplateView):
	template_name = 'Revenue.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(revenueWeekly, self).get_context_data(**kwargs)
		print("revenueWeekly-in get ")
		driver_obj = DriverModel.objects.all().order_by('-id')
		drivercommission=0.0
		admincommission=0.0
		totalEarnings=0.0
		srno=0
		driversData=[]
		today = datetime.date.today()
		for d in driver_obj:
			
			onDriverEarnings=0.0
			totalCompletedJob=0
			totalCompletedJob = DriverJob.objects.filter(driver = d, jobcompleted = True).count()
			driverjob_obj = DriverJob.objects.filter(driver = d, jobcompleted = True).order_by('-id')
			if driverjob_obj:
				srno=srno+1
				print('\n')
				for job in driverjob_obj:
					if job.customerjob.price:
						dateFind=False
						if job.created_at.isocalendar()[1] == today.isocalendar()[1] and job.created_at.year == today.year:
							dateFind=True
							drivercommission = drivercommission+float(round(((70 * job.customerjob.price)/100),2))
							onDriverEarnings =onDriverEarnings+float(round(((70 * job.customerjob.price)/100),2))
							admincommission=admincommission+float(round(((30 * job.customerjob.price)/100),2))
							totalEarnings=totalEarnings+float(job.customerjob.price)
					else:
						onDriverEarnings=onDriverEarnings+0.0
						drivercommission = drivercommission+0.0
						admincommission=admincommission+0.0
						totalEarnings=totalEarnings+0.0
				if dateFind==True:
					onDriverEarnings=str(round(onDriverEarnings,2))
					driversData.append({'srno':srno,
						                'name':d.name,
				                        'total':onDriverEarnings,
				                        'jobcount':totalCompletedJob,
				                        'id':d.id,})
				
			else:
				drivercommission = drivercommission+0.0
				admincommission=admincommission+0.0
				totalEarnings=totalEarnings+0.0
		totalEarnings=str(round(totalEarnings,2))
		admincommission =str(round(admincommission,2))
		drivercommission =str(round(drivercommission,2))
		print(drivercommission)
		print(admincommission)
		print(totalEarnings)
		print(driversData)
		paginator = Paginator(driversData, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		print('allVehicals',vehicalList)
		context['allVehicals']=vehicalList
		context['driversData'] = driversData
		context['drivercommission'] = drivercommission
		context['admincommission'] = admincommission
		context['totalEarnings'] = totalEarnings
		context['title'] = 'revenue'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class revenueMonthly(TemplateView):
	template_name = 'Revenue.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(revenueMonthly, self).get_context_data(**kwargs)
		print("revenueMonthly-in get ")
		driver_obj = DriverModel.objects.all().order_by('-id')
		drivercommission=0.0
		admincommission=0.0
		totalEarnings=0.0
		srno=0
		driversData=[]
		today = datetime.date.today()
		for d in driver_obj:
			
			onDriverEarnings=0.0
			totalCompletedJob=0
			totalCompletedJob = DriverJob.objects.filter(driver = d, jobcompleted = True).count()
			driverjob_obj = DriverJob.objects.filter(driver = d, jobcompleted = True).order_by('-id')
			if driverjob_obj:
				srno=srno+1
				print('\n')
				for job in driverjob_obj:
					if job.customerjob.price:
						dateFind=False
						if job.created_at.month == today.month and job.created_at.year == today.year:
							dateFind=True
							drivercommission = drivercommission+float(round(((70 * job.customerjob.price)/100),2))
							onDriverEarnings =onDriverEarnings+float(round(((70 * job.customerjob.price)/100),2))
							admincommission=admincommission+float(round(((30 * job.customerjob.price)/100),2))
							totalEarnings=totalEarnings+float(job.customerjob.price)
					else:
						onDriverEarnings=onDriverEarnings+0.0
						drivercommission = drivercommission+0.0
						admincommission=admincommission+0.0
						totalEarnings=totalEarnings+0.0
				if dateFind==True:
					onDriverEarnings=str(round(onDriverEarnings,2))
					driversData.append({'srno':srno,
						                'name':d.name,
				                        'total':onDriverEarnings,
				                        'jobcount':totalCompletedJob,
				                        'id':d.id,})
				
			else:
				drivercommission = drivercommission+0.0
				admincommission=admincommission+0.0
				totalEarnings=totalEarnings+0.0
		totalEarnings=str(round(totalEarnings,2))
		admincommission =str(round(admincommission,2))
		drivercommission =str(round(drivercommission,2))
		print(drivercommission)
		print(admincommission)
		print(totalEarnings)
		print(driversData)
		paginator = Paginator(driversData, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		print('allVehicals',vehicalList)
		context['allVehicals']=vehicalList
		context['driversData'] = driversData
		context['drivercommission'] = drivercommission
		context['admincommission'] = admincommission
		context['totalEarnings'] = totalEarnings
		context['title'] = 'revenue'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class revenueYear(TemplateView):
	template_name = 'Revenue.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(revenueYear, self).get_context_data(**kwargs)
		print("revenueYear-in get ")
		driver_obj = DriverModel.objects.all().order_by('-id')
		drivercommission=0.0
		admincommission=0.0
		totalEarnings=0.0
		srno=0
		driversData=[]
		today = datetime.date.today()
		for d in driver_obj:
			
			onDriverEarnings=0.0
			totalCompletedJob=0
			totalCompletedJob = DriverJob.objects.filter(driver = d, jobcompleted = True).count()
			driverjob_obj = DriverJob.objects.filter(driver = d, jobcompleted = True).order_by('-id')
			if driverjob_obj:
				srno=srno+1
				print('\n')
				for job in driverjob_obj:
					if job.customerjob.price:
						dateFind=False
						if job.created_at.year == today.year:
							dateFind=True
							drivercommission = drivercommission+float(round(((70 * job.customerjob.price)/100),2))
							onDriverEarnings =onDriverEarnings+float(round(((70 * job.customerjob.price)/100),2))
							admincommission=admincommission+float(round(((30 * job.customerjob.price)/100),2))
							totalEarnings=totalEarnings+float(job.customerjob.price)
					else:
						onDriverEarnings=onDriverEarnings+0.0
						drivercommission = drivercommission+0.0
						admincommission=admincommission+0.0
						totalEarnings=totalEarnings+0.0
				if dateFind==True:
					onDriverEarnings=str(round(onDriverEarnings,2))
					driversData.append({'srno':srno,
						                'name':d.name,
				                        'total':onDriverEarnings,
				                        'jobcount':totalCompletedJob,
				                        'id':d.id,})
				
			else:
				drivercommission = drivercommission+0.0
				admincommission=admincommission+0.0
				totalEarnings=totalEarnings+0.0
		totalEarnings=str(round(totalEarnings,2))
		admincommission =str(round(admincommission,2))
		drivercommission =str(round(drivercommission,2))
		print(drivercommission)
		print(admincommission)
		print(totalEarnings)
		print(driversData)
		paginator = Paginator(driversData, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		print('allVehicals',vehicalList)
		context['allVehicals']=vehicalList
		context['driversData'] = driversData
		context['drivercommission'] = drivercommission
		context['admincommission'] = admincommission
		context['totalEarnings'] = totalEarnings
		context['title'] = 'revenue'
		return context

def change_DriverRadiusRequests_status(request, *args, **kwargs):
	'''This function is being used to edit the parcel type details by Admin'''
	print('Admin - in change_DriverRadiusRequests_status function')
	try:	
		print(request.POST)
		radius_request_id = request.POST.get('radius_request_id')
		new_status = request.POST.get('new_status')
		extra=True
		RadiusPermission_obj = RadiusPermission.objects.filter(id = radius_request_id).first()
		if RadiusPermission_obj:
			if new_status == 'approve':
				RadiusPermission_obj.status = '1'
				msg = 'Request approved'
				print('approve request')
			if new_status == 'disapprove':
				RadiusPermission_obj.status = '2'
				msg = 'Request disapproved'
			RadiusPermission_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : msg})
		else:
			return JsonResponse({'status_code' : 500, 'status_message' : 'No request found'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})

@method_decorator(checkloginadmin, name='dispatch')
class showAllDriverRadiusRequests(TemplateView):
	template_name = 'showDriverRadiusRequest.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all companies screen to Admin user'''
		context = super(showAllDriverRadiusRequests, self).get_context_data(**kwargs)
		print("showAllDriverRadiusRequests-in get ")
		all_credit_requests_data = []
		radiusPermissionObject = RadiusPermission.objects.all().order_by('-id')
		if radiusPermissionObject:
			serialno = 0
			for req in radiusPermissionObject:
				serialno += 1
				all_credit_requests_data.append({
					'serialno' : serialno,
					'driverEmail' : req.driverjob.driver.email,
					'distance' : req.distance,
					'status' : req.status,
					'date' : req.created_at.strftime("%d/%m/%Y %I:%M:%S %p"),
					'id' : req.id,
					})
		
				# print(data)

		paginator = Paginator(all_credit_requests_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_credit_requests_data = paginator.page(page)
			print(len(all_credit_requests_data))
			print("truy")
		except PageNotAnInteger:
			all_credit_requests_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_credit_requests_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_credit_requests'] = all_credit_requests_data
		return context


class revenueByID(TemplateView):
	template_name = 'Revenue.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(revenueByID, self).get_context_data(**kwargs)
		print("revenueByID-revenueByID get ")
		driverid = kwargs['driverid']
		driver_obj = DriverModel.objects.filter(id=driverid).first()
		drivercommission=0.0
		admincommission=0.0
		totalEarnings=0.0
		srno=0
		driversData=[]

		onDriverEarnings=0.0
		totalCompletedJob=0
		totalCompletedJob = DriverJob.objects.filter(driver = driver_obj, jobcompleted = True).count()
		driverjob_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = True).order_by('-id')
		if driverjob_obj:
			
			print('\n')
			for job in driverjob_obj:
				if job.customerjob.price:
					srno=srno+1
					drivercommission = drivercommission+float(round(((70 * job.customerjob.price)/100),2))
					admincommission=admincommission+float(round(((30 * job.customerjob.price)/100),2))
					totalEarnings=totalEarnings+float(job.customerjob.price)
					driversData.append({
				                'srno':srno,
				                'name':job.customerjob.customer.name,
			                    'total':str(round(job.customerjob.price,2)),
			                    'driverComission':str(round(((70 * job.customerjob.price)/100),2)),
			                    'Date':job.customerjob.creation_date,})
		totalEarnings=str(round(totalEarnings,2))
		admincommission =str(round(admincommission,2))
		drivercommission =str(round(drivercommission,2))
		print(drivercommission)
		print(admincommission)
		print(totalEarnings)
		print(driversData)
		paginator = Paginator(driversData, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")

		context['driversData'] = driversData
		context['drivercommission'] = drivercommission
		context['admincommission'] = admincommission
		context['totalEarnings'] = totalEarnings
		context['title'] = 'revenueByID'
		return context

class revenue(TemplateView):
	template_name = 'Revenue.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(revenue, self).get_context_data(**kwargs)
		print("revenue-revenue get ")
		driver_obj = DriverModel.objects.all().order_by('-id')
		drivercommission=0.0
		admincommission=0.0
		totalEarnings=0.0
		srno=0
		driversData=[]
		for d in driver_obj:
			
			onDriverEarnings=0.0
			totalCompletedJob=0
			totalCompletedJob = DriverJob.objects.filter(driver = d, jobcompleted = True).count()
			driverjob_obj = DriverJob.objects.filter(driver = d, jobcompleted = True).order_by('-id')
			if driverjob_obj:
				srno=srno+1
				print('\n')
				for job in driverjob_obj:
					if job.customerjob.price:
						drivercommission = drivercommission+float(round(((70 * job.customerjob.price)/100),2))
						onDriverEarnings =onDriverEarnings+float(round(((70 * job.customerjob.price)/100),2))
						admincommission=admincommission+float(round(((30 * job.customerjob.price)/100),2))
						totalEarnings=totalEarnings+float(job.customerjob.price)
					else:
						onDriverEarnings=onDriverEarnings+0.0
						drivercommission = drivercommission+0.0
						admincommission=admincommission+0.0
						totalEarnings=totalEarnings+0.0
				onDriverEarnings=str(round(onDriverEarnings,2))
				driversData.append({'srno':srno,
					                'name':d.name,
				                    'total':onDriverEarnings,
				                    'jobcount':totalCompletedJob,
				                    'id':d.id,})
			else:
				drivercommission = drivercommission+0.0
				admincommission=admincommission+0.0
				totalEarnings=totalEarnings+0.0
		totalEarnings=str(round(totalEarnings,2))
		admincommission =str(round(admincommission,2))
		drivercommission =str(round(drivercommission,2))
		print(drivercommission)
		print(admincommission)
		print(totalEarnings)
		print(driversData)
		paginator = Paginator(driversData, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			driversData = paginator.page(page)
			print(len(driversData))
			print("truy")
		except PageNotAnInteger:
			driversData = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			driversData = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		print('allVehicals',vehicalList)
		context['allVehicals']=vehicalList
		context['driversData'] = driversData
		context['drivercommission'] = drivercommission
		context['admincommission'] = admincommission
		context['totalEarnings'] = totalEarnings
		context['title'] = 'revenue'
		return context


@method_decorator(checkloginadmin, name='dispatch')
class emailToAll(TemplateView):
	template_name = 'EmailToAll.html'
	

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(emailToAll, self).get_context_data(**kwargs)
		print("emailToAll-emailToAll get ")
		
		context['all_drivers'] = 'drivers_data'
		context['header_title'] = 'Outstanding Jobs'
		context['title']='All'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class emailByCategory(TemplateView):
	template_name = 'EmailByCategory.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(emailByCategory, self).get_context_data(**kwargs)
		print("emailByCategory-emailByCategory get ")
		
		context['all_drivers'] = 'drivers_data'
		context['header_title'] = 'Outstanding Jobs'
		return context

class sendALLMails(APIView):
	# permission_classes = (IsAuthenticated,)

	def post(self, request, *args, **kwargs):
		print('data is  : ',request.POST)
		try:
			subject=request.POST.get('subject')
			message=request.POST.get('message')
			title=request.POST.get('title')
			connection = mail.get_connection()
			connection.open()
			if not message:
				message='This is message From Admin'
			if not subject:
				subject='Message From Admin'
			# User = get_user_model()
			# users = User.objects.all()
			if title == 'All':
				DriverModelobjects = DriverModel.objects.filter(emailverified=True).order_by('-id')
				CustomerModelobjects = Customer.objects.filter(emailverified=True).order_by('-id')
			elif title== 'Drivers':
				userOBJ = DriverModel.objects.filter(emailverified=True).order_by('-id')
				pass
			elif title=='Customers':
				userOBJ = Customer.objects.filter(role='customer',emailverified=True).order_by('-id')
				pass
			elif title=='Company':
				userOBJ = Customer.objects.filter(role='company',emailverified=True).order_by('-id')
				pass
			email_list=[]
			if title == 'All':
				print("one")
				for driver in DriverModelobjects:
					if driver.email:
						print("checking...")
						email_list.append(driver.email)
				print("two")
				for custom in CustomerModelobjects:
					if custom.email:
						print("again.....")
						email_list.append(custom.email)
				# send_mass_mail(str(subject),str(message),'tmpython4esf@gmail.com',list(email_list),fail_silently=True)
				# reciever_list= ['aa@bb.cc', 'dd@ee.ff']  #extend this list according to your requirement
				email1 = mail.EmailMessage(str(subject), str(message), 'tmpython4esf@gmail.com',email_list, connection=connection)
				email1.send()
				connection.close()
				# send_mail(str(subject),str(message),'tmpython4esf@gmail.com',list(email_list),fail_silently=True)
				print("done...")
			else:
				print("another phase")
				for d in userOBJ:
					if d.email:
						print("checkingg one.....")
						email_list.append(d.email)
				send_mail(str(subject),str(message),'tmpython4esf@gmail.com',list(email_list),fail_silently=True)
			print("second last")
			print(email_list)
			print("last")
			return JsonResponse({'code': 200, 'message': 'Mail send',})
		except Exception as e:
			print(e)
			return JsonResponse({'code': 0, 'message': str(e),})

class sendMailsDrivers(TemplateView):
	template_name = 'EmailToAll.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(sendMailsDrivers, self).get_context_data(**kwargs)
		print("sendMailsDrivers-sendMailsDrivers get ")
		
		context['all_drivers'] = 'drivers_data'
		context['header_title'] = 'Outstanding Jobs'
		context['title']='Drivers'
		return context
	def post(self, request, *args, **kwargs):
		print('data is  : ',request.POST)
		try:
			driver_obj = DriverModel.objects.all()
			email_list=[]
			for d in driver_obj:
				if d.user.email:
					email_list.append(d.user.email)
			send_mail('Profile update message:','Message from admin','tmpython4esf@gmail.com',list(email_list),fail_silently=True)
			return JsonResponse({'code': 200, 'message': 'Mail send',})
		except Exception as e:
			return JsonResponse({'code': 0, 'message': str(e),})

class sendMailsCustomers(TemplateView):
	template_name = 'EmailToAll.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(sendMailsCustomers, self).get_context_data(**kwargs)
		print("sendMailsCustomers-sendMailsCustomers get ")
		
		context['all_drivers'] = 'drivers_data'
		context['header_title'] = 'Outstanding Jobs'
		context['title']='Customers'
		return context
	def post(self, request, *args, **kwargs):
		print('data is  : ',request.POST)
		try:
			no=0
			driver_obj = Customer.objects.all()
			email_list=[]
			for d in driver_obj:
				if d.role == 'customer':
					if d.user.email:
						no=no+1
						email_list.append(d.user.email)
			print(no)
			send_mail('Profile update message:','Message from admin','tmpython4esf@gmail.com',list(email_list),fail_silently=True)
			return JsonResponse({'code': 200, 'message': 'Mail send',})
		except Exception as e:
			return JsonResponse({'code': 0, 'message': str(e),})


class sendMailsCompany(TemplateView):
	template_name = 'EmailToAll.html'
	# permission_classes = (IsAuthenticated,)
	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(sendMailsCompany, self).get_context_data(**kwargs)
		print("sendMailsCompany-sendMailsCompany get ")
		
		context['all_drivers'] = 'drivers_data'
		context['header_title'] = 'Outstanding Jobs'
		context['title']='Company'
		return context
	def post(self, request, *args, **kwargs):
		print('data is  : ',request.POST)
		try:
			no=0
			driver_obj = Customer.objects.all()
			email_list=[]
			for d in driver_obj:
				if d.role == 'company':
					if d.user.email:
						no=no+1
						email_list.append(d.user.email)
			print(no)
			send_mail('Profile update message:','Message from admin','tmpython4esf@gmail.com',list(email_list),fail_silently=True)
			return JsonResponse({'code': 200, 'message': 'Mail send',})
		except Exception as e:
			return JsonResponse({'code': 0, 'message': str(e),})


# def sendMailsDrivers(request, *args, **kwargs):
# 	print('Admin - sendMails')
# 	try:
# 		driver_obj = DriverModel.objects.all()
# 		email_list=[]
# 		for d in driver_obj:
# 			if d.user.email:
# 				email_list.append(d.user.email)
# 		send_mail('Profile update message:','Message from admin','tmpython4esf@gmail.com',list(email_list),fail_silently=True)
# 	except Exception as e:
# 		print(e)

# def sendMailsCustomers(request, *args, **kwargs):
# 	print('Admin - sendMails')
# 	try:
# 		driver_obj = Customer.objects.all()
# 		email_list=[]
# 		for d in driver_obj:
# 			if d.user.email:
# 				email_list.append(d.user.email)
# 		send_mail('Profile update message:','Message from admin','tmpython4esf@gmail.com',list(email_list),fail_silently=True)
# 	except Exception as e:
# 		print(e)



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsCompletedVehical(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsCompletedVehical, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsCompletedVehical-AdminShowAllCustomerJobsCompletedVehical get ")
		vehicalID = kwargs['vehicalid']
		vehicalobj=VehicleType.objects.filter(id=vehicalID).first()
		# all_customerjobs = CustomerJob.objects.filter(isdeleted = False,vehicletype=vehicalobj).order_by('-id')#.prefetch_related('user')
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False,vehicletype=vehicalobj).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
					if customerjob.sameIdForParcelsDetails !=0:
						unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
					# driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
					completed = False
					if customerjob.sameIdForParcelsDetails !=0:
						driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
						driverexist = False
						if driverjob_obj:
							driverexist = True
							completed = True
							for d in driverjob_obj:
								if d.jobcompleted==False:
									completed = False
					if customerjob.sameIdForParcelsDetails == 0:
						driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						driverexist = False
						if driverjob_obj:
							driverexist = True
							if driverjob_obj.jobcompleted:
								completed = True
					# if driverjob_obj:
					# 	if driverjob_obj.jobcompleted:
					# 		completed = True
					Show=True
					if customerjob.sameIdForParcelsDetails == 0:
						Show=False
					if completed:
						if customerjob.deliveryduration == 0:
							deliveryduration = 'Same Day Delivery'
						elif customerjob.deliveryduration == 1:
							deliveryduration = 'Two Day Delivery'
						elif customerjob.deliveryduration == 2:
							deliveryduration = 'Same Day Delivery'
						serialno += 1
						all_customerjobs_data.append({
							'serialno' : serialno,
							'sendername' : customerjob.sendername,
							'senderemail' : customerjob.senderemail,
							'senderphone' : customerjob.senderphone,
							'senderpickupaddress' : customerjob.pickupaddress,
							'recipientname' : customerjob.recipientname,
							'recipientdropoffaddress' : customerjob.dropoffaddress,

							# 'sendername' : customerjob.sendername,
							# 'senderphone' : customerjob.senderphone,
							# 'deliveryduration' : deliveryduration,
							# 'vehicletype' : customerjob.vehicletype,
							# 'id' : customerjob.id,
							'showId':Show,
							'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
							'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
							})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		context['filterTitle'] = 'completed'
		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Completed Jobs'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsCompletedWeek(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsCompletedWeek, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsCompletedWeek get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		today = datetime.date.today()
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.created_at.isocalendar()[1] == today.isocalendar()[1] and customerjob.created_at.year == today.year:
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						# driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							if driverjob_obj:
								driverexist = True
								completed = True
								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						# if driverjob_obj:
						# 	if driverjob_obj.jobcompleted:
						# 		completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,

								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,
								# 'id' : customerjob.id,
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		context['filterTitle'] = 'completed'
		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Completed Jobs'
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsCompletedDay(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsCompletedDay, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsCompletedDay get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		today = datetime.date.today()
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.created_at.date() == today and customerjob.created_at.year == today.year:
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						# driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							if driverjob_obj:
								driverexist = True
								completed = True
								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						# if driverjob_obj:
						# 	if driverjob_obj.jobcompleted:
						# 		completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,

								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,
								# 'id' : customerjob.id,
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		context['filterTitle'] = 'completed'
		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Completed Jobs'
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsCompletedMonth(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsCompletedMonth, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsCompletedMonth get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		today = datetime.date.today()
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.created_at.month == today.month and customerjob.created_at.year == today.year:
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						# driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							if driverjob_obj:
								driverexist = True
								completed = True
								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						# if driverjob_obj:
						# 	if driverjob_obj.jobcompleted:
						# 		completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,

								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,
								# 'id' : customerjob.id,
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		context['filterTitle'] = 'completed'
		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Completed Jobs'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsCompletedYear(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsCompletedYear, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsCompletedYear get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		today = datetime.date.today()
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.created_at.year == today.year:
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						# driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							if driverjob_obj:
								driverexist = True
								completed = True
								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						# if driverjob_obj:
						# 	if driverjob_obj.jobcompleted:
						# 		completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,

								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,
								# 'id' : customerjob.id,
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		context['filterTitle'] = 'completed'
		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Completed Jobs'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsVehical(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsVehical, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsVehical-AdminShowAllCustomerJobsVehical get ")
		vehicalID = kwargs['vehicalid']
		vehicalobj=VehicleType.objects.filter(id=vehicalID).first()
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False,vehicletype=vehicalobj).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
					if customerjob.sameIdForParcelsDetails !=0:
						unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
					completed = False
					if customerjob.sameIdForParcelsDetails !=0:
						driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
						driverexist = False
						driverID=0
						if driverjob_obj:
							driverexist = True
							completed = True

							for d in driverjob_obj:
								if d.jobcompleted==False:
									completed = False
									driverID=d.sameIdForParcels
					if customerjob.sameIdForParcelsDetails == 0:
						driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						driverexist = False
						driverID=0
						if driverjob_obj:
							driverexist = True
							if driverjob_obj.jobcompleted:
								completed = True
					Show=True
					if customerjob.sameIdForParcelsDetails == 0:
						Show=False
					if not completed:
						if customerjob.deliveryduration == 0:
							deliveryduration = 'Same Day Delivery'
						elif customerjob.deliveryduration == 1:
							deliveryduration = 'Two Day Delivery'
						elif customerjob.deliveryduration == 2:
							deliveryduration = 'Same Day Delivery'
						serialno += 1
						all_customerjobs_data.append({
							'serialno' : serialno,
							'sendername' : customerjob.sendername,
							'senderemail' : customerjob.senderemail,
							'senderphone' : customerjob.senderphone,
							'senderpickupaddress' : customerjob.pickupaddress,
							'recipientname' : customerjob.recipientname,
							'recipientdropoffaddress' : customerjob.dropoffaddress,
							'senderlatitude' : customerjob.senderlatitude,
							'senderlongitude' : customerjob.senderlongitude,
							'recipientlatitude' : customerjob.recipientlatitude,
							'recipientlongitude' : customerjob.recipientlongitude,
							'driverexist' : driverexist,
							'driverID':driverID,
							# 'sendername' : customerjob.sendername,
							# 'senderphone' : customerjob.senderphone,
							# 'deliveryduration' : deliveryduration,
							# 'vehicletype' : customerjob.vehicletype,

							# 'id' : customerjob.id,#Original ID used before my changes
							'showId':Show,
							'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
							'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
							})
		# print(all_customerjobs_data)
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			# print(all_customerjobs_data)
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		# print(drivers_data)
		context['all_drivers'] = drivers_data
		context['header_title'] = 'Outstanding Jobs'
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDriversVehicalType(TemplateView):
	template_name = 'admin_showalldrivers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDriversVehicalType, self).get_context_data(**kwargs)
		print("AdminShowAllDriversVehicalType-in get ")
		vehicalID = kwargs['vehicalid']
		vehicalobj=VehicleType.objects.filter(id=vehicalID).first()
		print("first")
		all_drivers = DriverModel.objects.filter(isdeleted = False,vehicletype=vehicalobj).order_by('-id').prefetch_related('user')
		data = []
		print("second")
		if all_drivers:
			serialno = 0
			for driver in all_drivers:
				serialno +=1
				vehicletype=''
				if driver.vehicletype == 0:
					vehicletype = 'Bike'
				elif driver.vehicletype == 1:
					vehicletype = 'Car'
				elif driver.vehicletype == 2:
					vehicletype = 'Small Van'
				elif driver.vehicletype == 3:
					vehicletype = 'Medium Van'
				elif driver.vehicletype == 4:
					vehicletype = 'Large Van'
				elif driver.vehicletype == 5:
					vehicletype = 'Not Specified'
				
				if driver.emailverified:
					emailverified = 'Yes'
				else:
					emailverified = 'No'
				if driver.accountapproved:
					accountapproved = 'Yes'
				else:
					accountapproved = 'No'
				if driver.isdisabled:
					isdisabled = 'Yes'
				else:
					isdisabled = 'No'
				
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude
				else:
					latitude = ''
					longitude = ''
				data.append({
					'serialno' : serialno,
					'name' : driver.name,
					'phone' : driver.countrycode + '-' + driver.phone,
					'email' : driver.user.email,
					'vehicletype' : vehicletype,
					'vehiclenumber' : driver.vehiclenumber,
					'preferredarea' : driver.preferredarea,
					'created_at' : driver.user.date_joined,
					'emailverified' : emailverified,
					'accountapproved' : accountapproved,
					'isdisabled' : isdisabled,
					'latitude' : latitude,
					'longitude' : longitude,
					'id' : driver.id,
					})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			data = paginator.page(page)
			print(len(data))
			print("truy")
		except PageNotAnInteger:
			data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_drivers'] = data
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDriversDays(TemplateView):
	template_name = 'admin_showalldrivers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDriversDays, self).get_context_data(**kwargs)
		print("AdminShowAllDriversDays-in get ")
		all_drivers = DriverModel.objects.filter(isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		today = datetime.date.today()
		if all_drivers:
			serialno = 0
			for driver in all_drivers:
				if driver.user.date_joined.date() == today and driver.user.date_joined.year == today.year:
					serialno +=1
					vehicletype=''
					if driver.vehicletype == 0:
						vehicletype = 'Bike'
					elif driver.vehicletype == 1:
						vehicletype = 'Car'
					elif driver.vehicletype == 2:
						vehicletype = 'Small Van'
					elif driver.vehicletype == 3:
						vehicletype = 'Medium Van'
					elif driver.vehicletype == 4:
						vehicletype = 'Large Van'
					elif driver.vehicletype == 5:
						vehicletype = 'Not Specified'
					
					if driver.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if driver.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if driver.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					
					drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
					if drivercoordinates_obj:
						latitude = drivercoordinates_obj.latitude
						longitude = drivercoordinates_obj.longitude
					else:
						latitude = ''
						longitude = ''
					data.append({
						'serialno' : serialno,
						'name' : driver.name,
						'phone' : driver.countrycode + '-' + driver.phone,
						'email' : driver.user.email,
						'vehicletype' : vehicletype,
						'vehiclenumber' : driver.vehiclenumber,
						'preferredarea' : driver.preferredarea,
						'created_at' : driver.user.date_joined,
						'emailverified' : emailverified,
						'accountapproved' : accountapproved,
						'isdisabled' : isdisabled,
						'latitude' : latitude,
						'longitude' : longitude,
						'id' : driver.id,
						})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList

		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			data = paginator.page(page)
			print(len(data))
			print("truy")
		except PageNotAnInteger:
			data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_drivers'] = data
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDriversWeekly(TemplateView):
	template_name = 'admin_showalldrivers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDriversWeekly, self).get_context_data(**kwargs)
		print("AdminShowAllDriversWeekly-in get ")
		all_drivers = DriverModel.objects.filter(isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		today = datetime.date.today()
		if all_drivers:
			serialno = 0
			for driver in all_drivers:
				if driver.user.date_joined.isocalendar()[1] == today.isocalendar()[1] and driver.user.date_joined.year == today.year:
					serialno +=1
					vehicletype=''
					if driver.vehicletype == 0:
						vehicletype = 'Bike'
					elif driver.vehicletype == 1:
						vehicletype = 'Car'
					elif driver.vehicletype == 2:
						vehicletype = 'Small Van'
					elif driver.vehicletype == 3:
						vehicletype = 'Medium Van'
					elif driver.vehicletype == 4:
						vehicletype = 'Large Van'
					elif driver.vehicletype == 5:
						vehicletype = 'Not Specified'
					
					if driver.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if driver.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if driver.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					
					drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
					if drivercoordinates_obj:
						latitude = drivercoordinates_obj.latitude
						longitude = drivercoordinates_obj.longitude
					else:
						latitude = ''
						longitude = ''
					data.append({
						'serialno' : serialno,
						'name' : driver.name,
						'phone' : driver.countrycode + '-' + driver.phone,
						'email' : driver.user.email,
						'vehicletype' : vehicletype,
						'vehiclenumber' : driver.vehiclenumber,
						'preferredarea' : driver.preferredarea,
						'created_at' : driver.user.date_joined,
						'emailverified' : emailverified,
						'accountapproved' : accountapproved,
						'isdisabled' : isdisabled,
						'latitude' : latitude,
						'longitude' : longitude,
						'id' : driver.id,
						})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			data = paginator.page(page)
			print(len(data))
			print("truy")
		except PageNotAnInteger:
			data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_drivers'] = data
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDriversMonths(TemplateView):
	template_name = 'admin_showalldrivers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDriversMonths, self).get_context_data(**kwargs)
		print("AdminShowAllDriversMonths-in get ")
		all_drivers = DriverModel.objects.filter(isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		today = datetime.date.today()
		if all_drivers:
			serialno = 0
			for driver in all_drivers:
				if driver.user.date_joined.month == today.month and driver.user.date_joined.year == today.year:
					serialno +=1
					vehicletype=''
					if driver.vehicletype == 0:
						vehicletype = 'Bike'
					elif driver.vehicletype == 1:
						vehicletype = 'Car'
					elif driver.vehicletype == 2:
						vehicletype = 'Small Van'
					elif driver.vehicletype == 3:
						vehicletype = 'Medium Van'
					elif driver.vehicletype == 4:
						vehicletype = 'Large Van'
					elif driver.vehicletype == 5:
						vehicletype = 'Not Specified'
					
					if driver.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if driver.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if driver.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					
					drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
					if drivercoordinates_obj:
						latitude = drivercoordinates_obj.latitude
						longitude = drivercoordinates_obj.longitude
					else:
						latitude = ''
						longitude = ''
					data.append({
						'serialno' : serialno,
						'name' : driver.name,
						'phone' : driver.countrycode + '-' + driver.phone,
						'email' : driver.user.email,
						'vehicletype' : vehicletype,
						'vehiclenumber' : driver.vehiclenumber,
						'preferredarea' : driver.preferredarea,
						'created_at' : driver.user.date_joined,
						'emailverified' : emailverified,
						'accountapproved' : accountapproved,
						'isdisabled' : isdisabled,
						'latitude' : latitude,
						'longitude' : longitude,
						'id' : driver.id,
						})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			data = paginator.page(page)
			print(len(data))
			print("truy")
		except PageNotAnInteger:
			data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_drivers'] = data
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDriversYears(TemplateView):
	template_name = 'admin_showalldrivers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDriversYears, self).get_context_data(**kwargs)
		print("AdminShowAllDriversYears-in get ")
		all_drivers = DriverModel.objects.filter(isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		today = datetime.date.today()
		if all_drivers:
			serialno = 0
			for driver in all_drivers:
				if driver.user.date_joined.year == today.year:
					serialno +=1
					vehicletype=''
					if driver.vehicletype == 0:
						vehicletype = 'Bike'
					elif driver.vehicletype == 1:
						vehicletype = 'Car'
					elif driver.vehicletype == 2:
						vehicletype = 'Small Van'
					elif driver.vehicletype == 3:
						vehicletype = 'Medium Van'
					elif driver.vehicletype == 4:
						vehicletype = 'Large Van'
					elif driver.vehicletype == 5:
						vehicletype = 'Not Specified'
					
					if driver.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if driver.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if driver.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					
					drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
					if drivercoordinates_obj:
						latitude = drivercoordinates_obj.latitude
						longitude = drivercoordinates_obj.longitude
					else:
						latitude = ''
						longitude = ''
					data.append({
						'serialno' : serialno,
						'name' : driver.name,
						'phone' : driver.countrycode + '-' + driver.phone,
						'email' : driver.user.email,
						'vehicletype' : vehicletype,
						'vehiclenumber' : driver.vehiclenumber,
						'preferredarea' : driver.preferredarea,
						'created_at' : driver.user.date_joined,
						'emailverified' : emailverified,
						'accountapproved' : accountapproved,
						'isdisabled' : isdisabled,
						'latitude' : latitude,
						'longitude' : longitude,
						'id' : driver.id,
						})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			data = paginator.page(page)
			print(len(data))
			print("truy")
		except PageNotAnInteger:
			data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_drivers'] = data
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomersDays(TemplateView):
	template_name = 'admin_showallcustomers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllCustomersDays, self).get_context_data(**kwargs)
		print("AdminShowAllCustomersDays-in get ")
		today = datetime.date.today()
		all_customers = Customer.objects.filter(role = 'customer', isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_customers:
			serialno = 0
			for customer in all_customers:
				print("year",customer.user.date_joined)
				print("year",customer.user.date_joined.date())
				if customer.user.date_joined.date() == today:
					serialno +=1
					if customer.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if customer.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if customer.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					if customer.name:
						name = customer.name
					else:
						name = ''
					if not customer.countrycode:
						phone = customer.phone
					else:
						phone = customer.countrycode  + '-' + customer.phone
					data.append({
						'serialno' : serialno,
						'name' : name,
						'phone' : phone,
						'email' : customer.email,
						'created_at' : customer.user.date_joined,
						'accountapproved' : accountapproved,
						'emailverified' : emailverified,
						'isdisabled' : isdisabled,
						'id' : customer.id,
						})
					# print(data)
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customers = paginator.page(page)
			print(len(all_customers))
			print("truy")
		except PageNotAnInteger:
			all_customers = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customers = paginator.page(paginator.num_pages)
			print("except2")


		
		context['all_customers'] = all_customers
		context['in_allcustomers_section'] = 'yes'
		
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomersWeekly(TemplateView):
	template_name = 'admin_showallcustomers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllCustomersWeekly, self).get_context_data(**kwargs)
		print("AdminShowAllCustomersWeekly-in get ")
		today = datetime.date.today()
		all_customers = Customer.objects.filter(role = 'customer', isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_customers:
			serialno = 0
			for customer in all_customers:
				print("year",customer.user.date_joined)
				print("year",customer.user.date_joined.month)
				if customer.user.date_joined.isocalendar()[1] == today.isocalendar()[1] and customer.user.date_joined.year == today.year:
					serialno +=1
					if customer.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if customer.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if customer.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					if customer.name:
						name = customer.name
					else:
						name = ''
					if not customer.countrycode:
						phone = customer.phone
					else:
						phone = customer.countrycode  + '-' + customer.phone
					data.append({
						'serialno' : serialno,
						'name' : name,
						'phone' : phone,
						'email' : customer.email,
						'created_at' : customer.user.date_joined,
						'accountapproved' : accountapproved,
						'emailverified' : emailverified,
						'isdisabled' : isdisabled,
						'id' : customer.id,
						})
					# print(data)
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customers = paginator.page(page)
			print(len(all_customers))
			print("truy")
		except PageNotAnInteger:
			all_customers = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customers = paginator.page(paginator.num_pages)
			print("except2")


		
		context['all_customers'] = all_customers
		context['in_allcustomers_section'] = 'yes'
		
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomersMonths(TemplateView):
	template_name = 'admin_showallcustomers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllCustomersMonths, self).get_context_data(**kwargs)
		print("AdminShowAllCustomersMonths-in get ")
		today = datetime.date.today()
		all_customers = Customer.objects.filter(role = 'customer', isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_customers:
			serialno = 0
			for customer in all_customers:
				print("year",customer.user.date_joined)
				print("year",customer.user.date_joined.month)
				if customer.user.date_joined.month == today.month and customer.user.date_joined.year == today.year:
					serialno +=1
					if customer.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if customer.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if customer.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					if customer.name:
						name = customer.name
					else:
						name = ''
					if not customer.countrycode:
						phone = customer.phone
					else:
						phone = customer.countrycode  + '-' + customer.phone
					data.append({
						'serialno' : serialno,
						'name' : name,
						'phone' : phone,
						'email' : customer.email,
						'created_at' : customer.user.date_joined,
						'accountapproved' : accountapproved,
						'emailverified' : emailverified,
						'isdisabled' : isdisabled,
						'id' : customer.id,
						})
					# print(data)
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customers = paginator.page(page)
			print(len(all_customers))
			print("truy")
		except PageNotAnInteger:
			all_customers = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customers = paginator.page(paginator.num_pages)
			print("except2")


		
		context['all_customers'] = all_customers
		context['in_allcustomers_section'] = 'yes'
		
		return context





@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomersYears(TemplateView):
	template_name = 'admin_showallcustomers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllCustomersYears, self).get_context_data(**kwargs)
		print("AdminShowAllCustomersYears-in get ")
		today = datetime.date.today()
		all_customers = Customer.objects.filter(role = 'customer', isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_customers:
			serialno = 0
			for customer in all_customers:
				print("year",customer.user.date_joined.year)
				if customer.user.date_joined.year == today.year:
					serialno +=1
					if customer.emailverified:
						emailverified = 'Yes'
					else:
						emailverified = 'No'
					if customer.accountapproved:
						accountapproved = 'Yes'
					else:
						accountapproved = 'No'
					if customer.isdisabled:
						isdisabled = 'Yes'
					else:
						isdisabled = 'No'
					if customer.name:
						name = customer.name
					else:
						name = ''
					if not customer.countrycode:
						phone = customer.phone
					else:
						phone = customer.countrycode  + '-' + customer.phone
					data.append({
						'serialno' : serialno,
						'name' : name,
						'phone' : phone,
						'email' : customer.email,
						'created_at' : customer.user.date_joined,
						'accountapproved' : accountapproved,
						'emailverified' : emailverified,
						'isdisabled' : isdisabled,
						'id' : customer.id,
						})
					# print(data)
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customers = paginator.page(page)
			print(len(all_customers))
			print("truy")
		except PageNotAnInteger:
			all_customers = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customers = paginator.page(paginator.num_pages)
			print("except2")


		
		context['all_customers'] = all_customers
		context['in_allcustomers_section'] = 'yes'
		
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobMonths(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobMonths, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobMonths-AdminShowAllCustomerJobs get ")
		today = datetime.date.today()
		print(today.month)
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				print("today month--------",today.year)
				print("job month--------",customerjob.created_at.year)
				if customerjob.created_at.month == today.month:
					print("today month--------",today.month)
					print("job month--------",customerjob.created_at.month)
					
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								completed = True

								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
										driverID=d.sameIdForParcels
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if not completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,
								'senderlatitude' : customerjob.senderlatitude,
								'senderlongitude' : customerjob.senderlongitude,
								'recipientlatitude' : customerjob.recipientlatitude,
								'recipientlongitude' : customerjob.recipientlongitude,
								'driverexist' : driverexist,
								'driverID':driverID,
								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,

								# 'id' : customerjob.id,#Original ID used before my changes
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})
		# print(all_customerjobs_data)
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			# print(all_customerjobs_data)
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		# print(drivers_data)
		context['filterTitle'] = 'outstanding'
		context['all_drivers'] = drivers_data
		context['header_title'] = 'Outstanding Jobs'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobWeekly(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobWeekly, self).get_context_data(**kwargs)
		print("AdminShowAllCustomers-AdminShowAllCustomerJobs get ")
		today = datetime.date.today()
		print(today.month)
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				print("today week--------",today.isocalendar()[1])
				print("job week--------",customerjob.created_at.isocalendar()[1])
				if customerjob.created_at.isocalendar()[1] == today.isocalendar()[1] and customerjob.created_at.year == today.year:
					print("job month--------",today.isocalendar()[1])
					print("job month--------",customerjob.created_at.isocalendar()[1])
					
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								completed = True

								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
										driverID=d.sameIdForParcels
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if not completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,
								'senderlatitude' : customerjob.senderlatitude,
								'senderlongitude' : customerjob.senderlongitude,
								'recipientlatitude' : customerjob.recipientlatitude,
								'recipientlongitude' : customerjob.recipientlongitude,
								'driverexist' : driverexist,
								'driverID':driverID,
								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,

								# 'id' : customerjob.id,#Original ID used before my changes
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})
		# print(all_customerjobs_data)

		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			# print(all_customerjobs_data)
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		# print(drivers_data)
		context['filterTitle'] = 'outstanding'
		context['all_drivers'] = drivers_data
		context['header_title'] = 'Outstanding Jobs'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobYear(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobYear, self).get_context_data(**kwargs)
		print("AdminShowAllCustomers-AdminShowAllCustomerJobs get ")
		today = datetime.date.today()
		print(today.month)
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				print("today year--------",today.year)
				print("job year--------",customerjob.created_at.year)
				if customerjob.created_at.year == today.year:
					print("job month--------",today.isocalendar()[1])
					print("job month--------",customerjob.created_at.isocalendar()[1])
					
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								completed = True

								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
										driverID=d.sameIdForParcels
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if not completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,
								'senderlatitude' : customerjob.senderlatitude,
								'senderlongitude' : customerjob.senderlongitude,
								'recipientlatitude' : customerjob.recipientlatitude,
								'recipientlongitude' : customerjob.recipientlongitude,
								'driverexist' : driverexist,
								'driverID':driverID,
								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,

								# 'id' : customerjob.id,#Original ID used before my changes
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})
		# print(all_customerjobs_data)
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			# print(all_customerjobs_data)
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		# print(drivers_data)
		context['filterTitle'] = 'outstanding'
		context['all_drivers'] = drivers_data
		context['header_title'] = 'Outstanding Jobs'
		return context


#Create and Edit By manpreet 6/11/2020
@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobDay(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobDay, self).get_context_data(**kwargs)
		print("AdminShowAllCustomers-AdminShowAllCustomerJobs get ")
		today = datetime.date.today()
		print(today.month)
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				print("today day--------",today)
				print("job day--------",customerjob.created_at.date())
				if customerjob.created_at.date() == today:
					
					if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
						if customerjob.sameIdForParcelsDetails !=0:
							unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
						completed = False
						if customerjob.sameIdForParcelsDetails !=0:
							driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								completed = True

								for d in driverjob_obj:
									if d.jobcompleted==False:
										completed = False
										driverID=d.sameIdForParcels
						if customerjob.sameIdForParcelsDetails == 0:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
							driverexist = False
							driverID=0
							if driverjob_obj:
								driverexist = True
								if driverjob_obj.jobcompleted:
									completed = True
						Show=True
						if customerjob.sameIdForParcelsDetails == 0:
							Show=False
						if not completed:
							if customerjob.deliveryduration == 0:
								deliveryduration = 'Same Day Delivery'
							elif customerjob.deliveryduration == 1:
								deliveryduration = 'Two Day Delivery'
							elif customerjob.deliveryduration == 2:
								deliveryduration = 'Same Day Delivery'
							serialno += 1
							all_customerjobs_data.append({
								'serialno' : serialno,
								'sendername' : customerjob.sendername,
								'senderemail' : customerjob.senderemail,
								'senderphone' : customerjob.senderphone,
								'senderpickupaddress' : customerjob.pickupaddress,
								'recipientname' : customerjob.recipientname,
								'recipientdropoffaddress' : customerjob.dropoffaddress,
								'senderlatitude' : customerjob.senderlatitude,
								'senderlongitude' : customerjob.senderlongitude,
								'recipientlatitude' : customerjob.recipientlatitude,
								'recipientlongitude' : customerjob.recipientlongitude,
								'driverexist' : driverexist,
								'driverID':driverID,
								# 'sendername' : customerjob.sendername,
								# 'senderphone' : customerjob.senderphone,
								# 'deliveryduration' : deliveryduration,
								# 'vehicletype' : customerjob.vehicletype,

								# 'id' : customerjob.id,#Original ID used before my changes
								'showId':Show,
								'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
								'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
								})

		# print(all_customerjobs_data)
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			# print(all_customerjobs_data)
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		# print(drivers_data)
		context['all_drivers'] = drivers_data
		context['header_title'] = 'Outstanding Jobs'
		return context


def changeRadiusStatus(request, *args, **kwargs):
	'''This function is being used to edit the parcel type details by Admin'''
	print('Admin - in changeRadiusStatus function')
	try:	
		print(request.POST)
		radiusId = request.POST.get('radiusId')
		new_status = request.POST.get('new_status')
		if new_status == 'Enable':
			oneradius=RadiusControl.objects.filter(id=radiusId).first()
			if oneradius:
				oneradius.enable=True
				oneradius.save()
				rdAll=RadiusControl.objects.all()
				for rd in rdAll:
					if oneradius.id == rd.id:
						pass
					else:
						rd.enable=False
						rd.save()
		elif new_status == 'Disable':
			oneradius=RadiusControl.objects.filter(id=radiusId)
			oneradius.enable=False
			oneradius.save()
		else:
			return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})
		return JsonResponse({'status_code' : 200, 'status_message' : 'success'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})

def addNewRadius(request, *args, **kwargs):
	'''This function is being used to add the vehicle type details by Admin'''
	print('Admin - in addNewRadius function')
	try:
		radius = request.POST.get('radius')
		radius=float(radius)
		radiusAdded=RadiusControl.objects.create(distance=radius,enable=True)
		if radiusAdded:
			rdAll=RadiusControl.objects.all()
			for rd in rdAll:
				if radiusAdded.id == rd.id:
					pass
				else:
					rd.enable=False
					rd.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Error'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})


def slotStatusonJobComplete(sameparcelID):
	customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID)
	packageCompleted=True
	startSlot=24
	lastSlot=0
	driverID=0
	for customer in customerjob_obj_all:
		dJob=DriverJob.objects.filter(customerjob=customer).first()
		driverID=dJob.driver.id
		if dJob.jobcompleted!=True:
			packageCompleted=False
		print(customer.pickuptimeslotDate)
		print(customer.pickuptimeslot)
		stringFirst=customer.pickuptimeslot
		one=stringFirst.split('-')[0]
		two=stringFirst.split('-')[1]
		one=one[:-1]
		two=two[1:]
		one=convert24(one)
		two=convert24(two)
		stringFirst=one+" "+two
		print(one)
		print(two)
		print(stringFirst)
		pickupSlotID=int(stringFirst[:2])
		if pickupSlotID<startSlot:
			startSlot=pickupSlotID
		print("Pickupslotid",pickupSlotID)
		print(customer.dropofftimeslot)
		stringSecond=customer.dropofftimeslot
		one=stringSecond.split('-')[0]
		two=stringSecond.split('-')[1]
		one=one[:-1]
		two=two[1:]
		one=convert24(one)
		two=convert24(two)
		stringSecond=one+" "+two
		print(one)
		print(two)
		print(stringSecond)
		deliverySlotID=int(stringSecond[:2])
		if deliverySlotID>lastSlot:
			lastSlot=deliverySlotID
	if packageCompleted == True:
		makeslotAvailable(startSlot,lastSlot+1,driverID)


def shiftDriver_ExtraTestbefore(request, *args, **kwargs):
	print('Admin - in shiftDriver_ExtraTestbefore function')
	try:
		print(request.POST)
		# sys.exit()
		sameparcelID = request.POST.get('sameparcelID')
		selectedDriverID = request.POST.get('selectedDriverID')
		driverjob_obj = DriverJob.objects.filter(sameIdForParcels = sameparcelID)
		driver_obj = DriverModel.objects.filter(id = selectedDriverID).first()
		print(driverjob_obj)
		print(driver_obj)
		startSlot=24
		lastSlot=1
		if driverjob_obj and driver_obj:
			for driver in driverjob_obj:
				if driver.jobstarted == True:
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
				print(driver.customerjob.pickuptimeslotDate)
				print(driver.customerjob.pickuptimeslot)
				stringFirst=driver.customerjob.pickuptimeslot
				one=stringFirst.split('-')[0]
				two=stringFirst.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringFirst=one+" "+two
				print(one)
				print(two)
				print(stringFirst)
				pickupSlotID=int(stringFirst[:2])
				responseOf=compareSlotTimes(pickupSlotID,driver_obj.id)
				if pickupSlotID<startSlot:
					startSlot=pickupSlotID
				print(responseOf)
				if responseOf =='pass':
					pass
					print("available Delivery 1")
				else:
					print("unavailable Delivery 1")
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
				
				print("Pickupslotid",pickupSlotID)
				print(driver.customerjob.dropofftimeslot)
				stringSecond=driver.customerjob.dropofftimeslot
				one=stringSecond.split('-')[0]
				two=stringSecond.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringSecond=one+" "+two
				print(one)
				print(two)
				print(stringSecond)
				deliverySlotID=int(stringSecond[:2])
				responseOf=compareSlotTimes(deliverySlotID,driver_obj.id)
				print(responseOf)
				if deliverySlotID>lastSlot:
					lastSlot=deliverySlotID
				print("deliverySlotID",deliverySlotID)
				if responseOf =='pass':
					pass
					print("available Delivery2")
				else:
					print("unavailable Delivery2")
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
					print("unavailable Delivery")
			makeslotUnavailable(startSlot,lastSlot+1,driver_obj.id)
			makeslotAvailable(startSlot,lastSlot+1,driverjob_obj[0].driver.id)
			for driver in driverjob_obj:
				driver.driver=driver_obj
				driver.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
		else:
			return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
			# return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})

def newDrivertoDropOffDelveriy(request, *args, **kwargs):
	print('Admin - in newDrivertoDropOffDelveriy function')
	try:
		print(request.POST)
		# sys.exit()
		sameparcelID = request.POST.get('sameparcelID')
		selectedDriverID = request.POST.get('selectedDriverID')
		driverjob_obj = DriverJob.objects.filter(sameIdForParcels = sameparcelID)
		driver_obj = DriverModel.objects.filter(id = selectedDriverID).first()
		print(driverjob_obj)
		print(driver_obj)
		startSlot=24
		lastSlot=1
		if driverjob_obj and driver_obj:
			for driver in driverjob_obj:
				# if driver.deliveryfailed == True:
				# 	driver.deliveryfailed=False
				# 	driver.jobstarted=False
				# 	driver.arrived_at_pickup=False
				# 	driver.parcel_picked_by_driver=False
				# 	driver.start_DropOff=False
				# 	driver.arrived_atDropOffLocation=False
				# 	driver.jobcompleted=False
				# 	driver.save()
				print(driver.customerjob.pickuptimeslotDate)
				print(driver.customerjob.pickuptimeslot)
				stringFirst=driver.customerjob.pickuptimeslot
				one=stringFirst.split('-')[0]
				two=stringFirst.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringFirst=one+" "+two
				print(one)
				print(two)
				print(stringFirst)
				pickupSlotID=int(stringFirst[:2])
				# responseOf=compareSlotTimes(pickupSlotID,driver_obj.id)

				driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				idofslottables=0
				slotsFind=False
				print("here one 2")
				parcelpickupdate=driver.customerjob.pickuptimeslotDate
				for d in driverslotsobj:
					if d.dateOfSlots==parcelpickupdate:
						slotsFind=True
						idofslottables=d.id
				if slotsFind==False:
					newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					print(newdateSlots.id)
					if newdateSlots:
						print("here one 3")
						makeallsloteenablebydefault(newdateSlots.id)
						print("here one 3.1")
						responseOf=compareSlotTimesnew(pickupSlotID,newdateSlots.id)
						print("here one 3.2")
						idofslottables=newdateSlots.id
						print("here one 3.3")
					else:
						print("We are in else not working")
				else:
					responseOf=compareSlotTimesnew(pickupSlotID,idofslottables)
				print(responseOf)

				if pickupSlotID<startSlot:
					startSlot=pickupSlotID
				print(responseOf)
				if responseOf =='pass':
					pass
					print("available Delivery 1")
				else:
					print("unavailable Delivery 1")
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
				
				print("Pickupslotid",pickupSlotID)
				print(driver.customerjob.dropofftimeslot)
				stringSecond=driver.customerjob.dropofftimeslot
				one=stringSecond.split('-')[0]
				two=stringSecond.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringSecond=one+" "+two
				print(one)
				print(two)
				print(stringSecond)
				deliverySlotID=int(stringSecond[:2])
				# responseOf=compareSlotTimes(deliverySlotID,driver_obj.id)

				driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				idofslottables=0
				slotsFind=False
				print("here one 2")
				parcelpickupdate=driver.customerjob.pickuptimeslotDate
				for d in driverslotsobj:
					if d.dateOfSlots==parcelpickupdate:
						slotsFind=True
						idofslottables=d.id
				if slotsFind==False:
					newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					print(newdateSlots.id)
					if newdateSlots:
						print("here one 3")
						makeallsloteenablebydefault(newdateSlots.id)
						print("here one 3.1")
						responseOf=compareSlotTimesnew(deliverySlotID,newdateSlots.id)
						print("here one 3.2")
						idofslottables=newdateSlots.id
						print("here one 3.3")
					else:
						print("We are in else not working")
				else:
					responseOf=compareSlotTimesnew(deliverySlotID,idofslottables)
				print(responseOf)

				print(responseOf)
				if deliverySlotID>lastSlot:
					lastSlot=deliverySlotID
				print("deliverySlotID",deliverySlotID)
				if responseOf =='pass':
					pass
					print("available Delivery2")
				else:
					print("unavailable Delivery2")
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
					print("unavailable Delivery")
			slotofOlddrivers=DriverAllSlots.objects.filter(driver=driverjob_obj[0].driver)
			idofslottables2=0
			for slot in slotofOlddrivers:
				if slot.dateOfSlots==parcelpickupdate:
					idofslottables2=slot.id
			# makeslotUnavailable(startSlot,lastSlot+1,driver_obj.id)
			# makeslotAvailable(startSlot,lastSlot+1,driverjob_obj[0].driver.id)

			makeslotUnavailablenew(startSlot,lastSlot+1,idofslottables)		
			# makeslotUnavailable(startSlot,lastSlot+1,driver_obj.id)
			# makeslotAvailable(startSlot,lastSlot+1,driverjob_obj[0].driver.id)
			makeslotAvailablenew(startSlot,lastSlot+1,idofslottables2)



			for driver in driverjob_obj:
				if driver.deliveryfailed == True:
					customalreadyFailed=CustomerJobDeliveryFailed.objects.filter(job=driver.customerjob).first()
					if customalreadyFailed:
						customalreadyFailed.isdeleted=True
						customalreadyFailed.save()
					driver.deliveryfailed=False
					driver.jobstarted=False
					driver.arrived_at_pickup=False
					driver.parcel_picked_by_driver=False
					driver.start_DropOff=False
					driver.arrived_atDropOffLocation=False
					driver.jobcompleted=False
					# driver.save()
				driver.driver=driver_obj
				driver.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
		else:
			return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
			# return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})		

def shiftDriver_ExtraTest(request, *args, **kwargs):
	print('Admin - in shiftDriver_ExtraTest function')
	try:
		print(request.POST)
		# sys.exit()
		sameparcelID = request.POST.get('sameparcelID')
		selectedDriverID = request.POST.get('selectedDriverID')
		driverjob_obj = DriverJob.objects.filter(sameIdForParcels = sameparcelID)
		driver_obj = DriverModel.objects.filter(id = selectedDriverID).first()
		print(driverjob_obj)
		print(driver_obj)
		startSlot=24
		lastSlot=1
		if driverjob_obj and driver_obj:
			for driver in driverjob_obj:
				if driver.jobstarted == True:
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
				print(driver.customerjob.pickuptimeslotDate)
				print(driver.customerjob.pickuptimeslot)
				stringFirst=driver.customerjob.pickuptimeslot
				one=stringFirst.split('-')[0]
				two=stringFirst.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringFirst=one+" "+two
				print(one)
				print(two)
				print(stringFirst)
				pickupSlotID=int(stringFirst[:2])
				# responseOf=compareSlotTimes(pickupSlotID,driver_obj.id)


				driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				idofslottables=0
				slotsFind=False
				print("here one 2")
				parcelpickupdate=driver.customerjob.pickuptimeslotDate
				for d in driverslotsobj:
					if d.dateOfSlots==parcelpickupdate:
						slotsFind=True
						idofslottables=d.id
				if slotsFind==False:
					newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					print(newdateSlots.id)
					if newdateSlots:
						print("here one 3")
						makeallsloteenablebydefault(newdateSlots.id)
						print("here one 3.1")
						responseOf=compareSlotTimesnew(pickupSlotID,newdateSlots.id)
						print("here one 3.2")
						idofslottables=newdateSlots.id
						print("here one 3.3")
					else:
						print("We are in else not working")
				else:
					responseOf=compareSlotTimesnew(pickupSlotID,idofslottables)
				print(responseOf)




				if pickupSlotID<startSlot:
					startSlot=pickupSlotID
				print(responseOf)
				if responseOf =='pass':
					pass
					print("available Delivery 1")
				else:
					print("unavailable Delivery 1")
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
				
				print("Pickupslotid",pickupSlotID)
				print(driver.customerjob.dropofftimeslot)
				stringSecond=driver.customerjob.dropofftimeslot
				one=stringSecond.split('-')[0]
				two=stringSecond.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringSecond=one+" "+two
				print(one)
				print(two)
				print(stringSecond)
				deliverySlotID=int(stringSecond[:2])
				# responseOf=compareSlotTimes(deliverySlotID,driver_obj.id)
				driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				idofslottables=0
				slotsFind=False
				print("here one 2")
				parcelpickupdate=driver.customerjob.pickuptimeslotDate
				for d in driverslotsobj:
					if d.dateOfSlots==parcelpickupdate:
						slotsFind=True
						idofslottables=d.id
				if slotsFind==False:
					newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					print(newdateSlots.id)
					if newdateSlots:
						print("here one 3")
						makeallsloteenablebydefault(newdateSlots.id)
						print("here one 3.1")
						responseOf=compareSlotTimesnew(deliverySlotID,newdateSlots.id)
						print("here one 3.2")
						idofslottables=newdateSlots.id
						print("here one 3.3")
					else:
						print("We are in else not working")
				else:
					responseOf=compareSlotTimesnew(deliverySlotID,idofslottables)
				print(responseOf)
				if deliverySlotID>lastSlot:
					lastSlot=deliverySlotID
				print("deliverySlotID",deliverySlotID)
				if responseOf =='pass':
					pass
					print("available Delivery2")
				else:
					print("unavailable Delivery2")
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
					print("unavailable Delivery")
			slotofOlddrivers=DriverAllSlots.objects.filter(driver=driverjob_obj[0].driver)
			idofslottables2=0
			for slot in slotofOlddrivers:
				if slot.dateOfSlots==parcelpickupdate:
					idofslottables2=slot.id
			makeslotUnavailablenew(startSlot,lastSlot+1,idofslottables)		
			# makeslotUnavailable(startSlot,lastSlot+1,driver_obj.id)
			# makeslotAvailable(startSlot,lastSlot+1,driverjob_obj[0].driver.id)
			makeslotAvailablenew(startSlot,lastSlot+1,idofslottables2)
			for driver in driverjob_obj:
				driver.driver=driver_obj
				driver.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
		else:
			return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
			# return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})		


def getOneDriverDetails(request, *args, **kwargs):
	print('Admin - getOneDriverDetails')
	try:
		print(request.POST)
		# sys.exit()
		driver_id = request.POST.get('driverid')
		driver_obj = DriverModel.objects.filter(id=driver_id).first()
		assignedDriver={}
		image='http://13.126.26.12/static/images/camera.png'
		if driver_obj:
			try:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False).count()
			except Exception as e:
				print(e)
				latitude, longitude = '', ''
				pendingjobs=0
			if driver_obj.image.name:
				image=str(settings.WEB_BASE_URL) + driver_obj.image.name
			assignedDriver.update({
					'name': driver_obj.name,
					'email': driver_obj.email,
					'phone': driver_obj.countrycode + '-' + driver_obj.phone,
					'image': image,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver_obj.id,
					})
			return JsonResponse({'status_code' : 200,'current_driver':assignedDriver})
		else:
			return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})
	except Exception as e:
		print(e)
		# return JsonResponse({'status_code' : 400, 'all_drivers' : 'nothing','current_driver':'nothing'})
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})

def shiftDriverDetails(request, *args, **kwargs):
	print('Admin - in assigndriver function')
	try:
		print(request.POST)
		# sys.exit()
		driver_id = request.POST.get('driverid')
		# customerjob_id = request.POST.get('customerjobid')

		driverjob_obj = DriverJob.objects.filter(sameIdForParcels = driver_id).last()
		# customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = customerjob_id)
		
		driver_obj=driverjob_obj.driver
		alreadySelected=driver_obj.id
		assignedDriver={}
		image='http://13.126.26.12/static/images/camera.png'
		if driver_obj:

			try:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False).count()
			except Exception as e:
				print(e)
				latitude, longitude = '', ''
				pendingjobs=0
			if driver_obj.image.name:
				image=str(settings.WEB_BASE_URL) + driver_obj.image.name
			assignedDriver.update({
					'name': driver_obj.name,
					'email': driver_obj.email,
					'phone': driver_obj.countrycode + '-' + driver_obj.phone,
					'image': image,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver_obj.id,
					'senderlatitude' : driverjob_obj.customerjob.senderlatitude,
					'senderlongitude' : driverjob_obj.customerjob.senderlongitude,
					'recipientlatitude' : driverjob_obj.customerjob.recipientlatitude,
					'recipientlongitude' : driverjob_obj.customerjob.recipientlongitude,
					'sameIdForParcels' : driverjob_obj.sameIdForParcels,
					})
		driver_obj2 = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		image='http://13.126.26.12/static/images/camera.png'
		if driver_obj2:
			for driver in driver_obj2:
				if alreadySelected !=driver.id:
					latitude, longitude = '', ''
					drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
					if drivercoordinates_obj:
						latitude = drivercoordinates_obj.latitude
						longitude = drivercoordinates_obj.longitude

					pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
					if driver_obj.image.name:
						image=str(settings.WEB_BASE_URL) + driver_obj.image.name
					drivers_data.append({
						'name': driver.name,
						'email': driver.email,
						'phone': driver.countrycode + '-' + driver.phone,
						'image': image,
						'latitude' : latitude,
						'longitude' : longitude,
						'noofparcels' : pendingjobs, 
						'id': driver.id,
						})
		# context['all_drivers'] = drivers_data
		# context['current_driver'] = assignedDriver
		return JsonResponse({'status_code' : 200, 'all_drivers' : drivers_data,'current_driver':assignedDriver})
	except Exception as e:
		print(e)
		# return JsonResponse({'status_code' : 400, 'all_drivers' : 'nothing','current_driver':'nothing'})
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})

def makeslotUnavailable(slotId,slotId2,DriverID):
	try:
		slotId=slotId+1
		driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj).first()
		if driverslotsobj:
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=False
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=False
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=False
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=False
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=False
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=False
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=False
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=False
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=False
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=False
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=False
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=False
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=False
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=False
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=False
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=False
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=False
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=False
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=False
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=False
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=False
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=False
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=False
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=False
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'

def makeslotUnavailablenew(slotId,slotId2,driveridforslots):
	try:
		slotId=slotId+1
		# driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(id=driveridforslots).first()
		print("slot object",driverslotsobj) 
		print(slotId)
		print(slotId2)
		if driverslotsobj:
			print("we are in")
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=False
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=False
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=False
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=False
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=False
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=False
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=False
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=False
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=False
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=False
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=False
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=False
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=False
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=False
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=False
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=False
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=False
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=False
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=False
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=False
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=False
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=False
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=False
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=False
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'


def makeslotAvailable(slotId,slotId2,DriverID):
	try:
		slotId=slotId+1
		driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj).first()
		if driverslotsobj:
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=True
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=True
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=True
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=True
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=True
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=True
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=True
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=True
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=True
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=True
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=True
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=True
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=True
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=True
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=True
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=True
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=True
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=True
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=True
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=True
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=True
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=True
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=True
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=True
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'

def makeslotAvailablenew(slotId,slotId2,driveridforslots):
	try:
		slotId=slotId+1
		# driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(id=driveridforslots).first()
		if driverslotsobj:
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=True
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=True
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=True
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=True
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=True
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=True
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=True
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=True
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=True
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=True
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=True
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=True
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=True
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=True
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=True
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=True
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=True
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=True
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=True
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=True
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=True
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=True
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=True
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=True
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'

def compareSlotTimes(slotId,DriverID):
	try:
		slotId=slotId+1
		driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj).first()
		if driverslotsobj:
			if slotId==1:
				if driverslotsobj.activeSlot1 ==True:
					return 'pass'
			elif slotId==2:
				if driverslotsobj.activeSlot2 ==True:
					return 'pass'
			elif slotId==3:
				if driverslotsobj.activeSlot3 ==True:
					return 'pass'
			elif slotId==4:
				if driverslotsobj.activeSlot4 ==True:
					return 'pass'
			elif slotId==5:
				if driverslotsobj.activeSlot5 ==True:
					return 'pass'
			elif slotId==6:
				if driverslotsobj.activeSlot6 ==True:
					return 'pass'
			elif slotId==7:
				if driverslotsobj.activeSlot7 ==True:
					return 'pass'
			elif slotId==8:
				if driverslotsobj.activeSlot8 ==True:
					return 'pass'
			elif slotId==9:
				if driverslotsobj.activeSlot9 ==True:
					return 'pass'
			elif slotId==10:
				if driverslotsobj.activeSlot10 ==True:
					return 'pass'
			elif slotId==11:
				if driverslotsobj.activeSlot11 ==True:
					return 'pass'
			elif slotId==12:
				if driverslotsobj.activeSlot12 ==True:
					return 'pass'
			elif slotId==13:
				if driverslotsobj.activeSlot13 ==True:
					return 'pass'
			elif slotId==14:
				if driverslotsobj.activeSlot14 ==True:
					return 'pass'
			elif slotId==15:
				if driverslotsobj.activeSlot15 ==True:
					return 'pass'
			elif slotId==16:
				if driverslotsobj.activeSlot16 ==True:
					return 'pass'
			elif slotId==17:
				if driverslotsobj.activeSlot17 ==True:
					return 'pass'
			elif slotId==18:
				if driverslotsobj.activeSlot18 ==True:
					return 'pass'
			elif slotId==19:
				if driverslotsobj.activeSlot19 ==True:
					return 'pass'
			elif slotId==20:
				if driverslotsobj.activeSlot120==True:
					return 'pass'
			elif slotId==21:
				if driverslotsobj.activeSlot21==True:
					return 'pass'
			elif slotId==22:
				if driverslotsobj.activeSlot22==True:
					return 'pass'

			elif slotId==23:
				if driverslotsobj.activeSlot23 ==True:
					return 'pass'
			elif slotId==24:
				if driverslotsobj.activeSlot24 ==True:
					return 'pass'
			else:
				return 'fail'
		return 'fail'
	except Exception as e:
		print(e)
		return 'fail'

def compareSlotTimesnew(slotId,DriverIDforslots):
	try:
		slotId=slotId+1
		# driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(id=DriverIDforslots).first()
		if driverslotsobj:
			if slotId==1:
				if driverslotsobj.activeSlot1 ==True:
					return 'pass'
			elif slotId==2:
				if driverslotsobj.activeSlot2 ==True:
					return 'pass'
			elif slotId==3:
				if driverslotsobj.activeSlot3 ==True:
					return 'pass'
			elif slotId==4:
				if driverslotsobj.activeSlot4 ==True:
					return 'pass'
			elif slotId==5:
				if driverslotsobj.activeSlot5 ==True:
					return 'pass'
			elif slotId==6:
				if driverslotsobj.activeSlot6 ==True:
					return 'pass'
			elif slotId==7:
				if driverslotsobj.activeSlot7 ==True:
					return 'pass'
			elif slotId==8:
				if driverslotsobj.activeSlot8 ==True:
					return 'pass'
			elif slotId==9:
				if driverslotsobj.activeSlot9 ==True:
					return 'pass'
			elif slotId==10:
				if driverslotsobj.activeSlot10 ==True:
					return 'pass'
			elif slotId==11:
				if driverslotsobj.activeSlot11 ==True:
					return 'pass'
			elif slotId==12:
				if driverslotsobj.activeSlot12 ==True:
					return 'pass'
			elif slotId==13:
				if driverslotsobj.activeSlot13 ==True:
					return 'pass'
			elif slotId==14:
				if driverslotsobj.activeSlot14 ==True:
					return 'pass'
			elif slotId==15:
				if driverslotsobj.activeSlot15 ==True:
					return 'pass'
			elif slotId==16:
				if driverslotsobj.activeSlot16 ==True:
					return 'pass'
			elif slotId==17:
				if driverslotsobj.activeSlot17 ==True:
					return 'pass'
			elif slotId==18:
				if driverslotsobj.activeSlot18 ==True:
					return 'pass'
			elif slotId==19:
				if driverslotsobj.activeSlot19 ==True:
					return 'pass'
			elif slotId==20:
				if driverslotsobj.activeSlot120==True:
					return 'pass'
			elif slotId==21:
				if driverslotsobj.activeSlot21==True:
					return 'pass'
			elif slotId==22:
				if driverslotsobj.activeSlot22==True:
					return 'pass'

			elif slotId==23:
				if driverslotsobj.activeSlot23 ==True:
					return 'pass'
			elif slotId==24:
				if driverslotsobj.activeSlot24 ==True:
					return 'pass'
			else:
				return 'fail'
		return 'fail'
	except Exception as e:
		print(e)
		return 'fail'

def convert24(str1):
	if str1[-2:] == "AM" and str1[:2] == "12":
		res= "00" + str1[2:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	elif str1[-2:] == "AM":
		res= str1[:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	elif str1[-2:] == "PM" and str1[:2] == "12":
		res= str1[:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	else:
		res= str(int(str1[:2]) + 12) + str1[2:6]
		res=res+":00"
		res=res.replace(" ","")
		return res

def createDriverSlots(driverID):
	driver_obj = DriverModel.objects.filter(id = driverID).first()
	# print("DriverTimeSlots-in get ")
	# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
	driverslotsobj=DriverAllSlots.objects.create(driver=driver_obj)
	if driverslotsobj:
		driverslotsobj.openinghourSlot1='00:00:00'
		driverslotsobj.closinghourSlot1='01:00:00'
		driverslotsobj.activeSlot1=True
		driverslotsobj.openinghourSlot2='01:00:00'
		driverslotsobj.closinghourSlot2='02:00:00'
		driverslotsobj.activeSlot2=True
		driverslotsobj.openinghourSlot3='02:00:00'
		driverslotsobj.closinghourSlot3='03:00:00'
		driverslotsobj.activeSlot3=True
		driverslotsobj.openinghourSlot4='03:00:00'
		driverslotsobj.closinghourSlot4='04:00:00'
		driverslotsobj.activeSlot4=True
		driverslotsobj.openinghourSlot5='04:00:00'
		driverslotsobj.closinghourSlot5='05:00:00'
		driverslotsobj.activeSlot5=True
		driverslotsobj.openinghourSlot6='05:00:00'
		driverslotsobj.closinghourSlot6='06:00:00'
		driverslotsobj.activeSlot6=True
		driverslotsobj.openinghourSlot7='06:00:00'
		driverslotsobj.closinghourSlot7='07:00:00'
		driverslotsobj.activeSlot7=True
		driverslotsobj.openinghourSlot8='07:00:00'
		driverslotsobj.closinghourSlot8='08:00:00'
		driverslotsobj.activeSlot8=True
		driverslotsobj.openinghourSlot9='08:00:00'
		driverslotsobj.closinghourSlot9='09:00:00'
		driverslotsobj.activeSlot9=True
		driverslotsobj.openinghourSlot10='09:00:00'
		driverslotsobj.closinghourSlot10='10:00:00'
		driverslotsobj.activeSlot10=True
		driverslotsobj.openinghourSlot11='10:00:00'
		driverslotsobj.closinghourSlot11='11:00:00'
		driverslotsobj.activeSlot11=True
		driverslotsobj.openinghourSlot12='11:00:00'
		driverslotsobj.closinghourSlot12='12:00:00'
		driverslotsobj.activeSlot12=True
		driverslotsobj.openinghourSlot13='12:00:00'
		driverslotsobj.closinghourSlot13='13:00:00'
		driverslotsobj.activeSlot13=True
		driverslotsobj.openinghourSlot14='13:00:00'
		driverslotsobj.closinghourSlot14='14:00:00'
		driverslotsobj.activeSlot14=True
		driverslotsobj.openinghourSlot15='14:00:00'
		driverslotsobj.closinghourSlot15='15:00:00'
		driverslotsobj.activeSlot15=True
		driverslotsobj.openinghourSlot16='15:00:00'
		driverslotsobj.closinghourSlot16='16:00:00'
		driverslotsobj.activeSlot16=True
		driverslotsobj.openinghourSlot17='16:00:00'
		driverslotsobj.closinghourSlot17='17:00:00'
		driverslotsobj.activeSlot17=True
		driverslotsobj.openinghourSlot18='17:00:00'
		driverslotsobj.closinghourSlot18='18:00:00'
		driverslotsobj.activeSlot18=True
		driverslotsobj.openinghourSlot19='18:00:00'
		driverslotsobj.closinghourSlot19='19:00:00'
		driverslotsobj.activeSlot19=True
		driverslotsobj.openinghourSlot20='19:00:00'
		driverslotsobj.closinghourSlot20='20:00:00'
		driverslotsobj.activeSlot120=True
		driverslotsobj.openinghourSlot21='20:00:00'
		driverslotsobj.closinghourSlot21='21:00:00'
		driverslotsobj.activeSlot21=True
		driverslotsobj.openinghourSlot22='21:00:00'
		driverslotsobj.closinghourSlot22='22:00:00'
		driverslotsobj.activeSlot22=True
		driverslotsobj.openinghourSlot23='22:00:00'
		driverslotsobj.closinghourSlot23='23:00:00'
		driverslotsobj.activeSlot23=True
		driverslotsobj.openinghourSlot24='23:00:00'
		driverslotsobj.closinghourSlot24='00:00:00'
		driverslotsobj.activeSlot24=True
		driverslotsobj.save()
		return '1'
	return '0'

def makeallsloteenablebydefault(alreadycreatedSlotID):
	driverslotsobj=DriverAllSlots.objects.filter(id=alreadycreatedSlotID).first()
	if driverslotsobj:
		driverslotsobj.openinghourSlot1='00:00:00'
		driverslotsobj.closinghourSlot1='01:00:00'
		driverslotsobj.activeSlot1=True
		driverslotsobj.openinghourSlot2='01:00:00'
		driverslotsobj.closinghourSlot2='02:00:00'
		driverslotsobj.activeSlot2=True
		driverslotsobj.openinghourSlot3='02:00:00'
		driverslotsobj.closinghourSlot3='03:00:00'
		driverslotsobj.activeSlot3=True
		driverslotsobj.openinghourSlot4='03:00:00'
		driverslotsobj.closinghourSlot4='04:00:00'
		driverslotsobj.activeSlot4=True
		driverslotsobj.openinghourSlot5='04:00:00'
		driverslotsobj.closinghourSlot5='05:00:00'
		driverslotsobj.activeSlot5=True
		driverslotsobj.openinghourSlot6='05:00:00'
		driverslotsobj.closinghourSlot6='06:00:00'
		driverslotsobj.activeSlot6=True
		driverslotsobj.openinghourSlot7='06:00:00'
		driverslotsobj.closinghourSlot7='07:00:00'
		driverslotsobj.activeSlot7=True
		driverslotsobj.openinghourSlot8='07:00:00'
		driverslotsobj.closinghourSlot8='08:00:00'
		driverslotsobj.activeSlot8=True
		driverslotsobj.openinghourSlot9='08:00:00'
		driverslotsobj.closinghourSlot9='09:00:00'
		driverslotsobj.activeSlot9=True
		driverslotsobj.openinghourSlot10='09:00:00'
		driverslotsobj.closinghourSlot10='10:00:00'
		driverslotsobj.activeSlot10=True
		driverslotsobj.openinghourSlot11='10:00:00'
		driverslotsobj.closinghourSlot11='11:00:00'
		driverslotsobj.activeSlot11=True
		driverslotsobj.openinghourSlot12='11:00:00'
		driverslotsobj.closinghourSlot12='12:00:00'
		driverslotsobj.activeSlot12=True
		driverslotsobj.openinghourSlot13='12:00:00'
		driverslotsobj.closinghourSlot13='13:00:00'
		driverslotsobj.activeSlot13=True
		driverslotsobj.openinghourSlot14='13:00:00'
		driverslotsobj.closinghourSlot14='14:00:00'
		driverslotsobj.activeSlot14=True
		driverslotsobj.openinghourSlot15='14:00:00'
		driverslotsobj.closinghourSlot15='15:00:00'
		driverslotsobj.activeSlot15=True
		driverslotsobj.openinghourSlot16='15:00:00'
		driverslotsobj.closinghourSlot16='16:00:00'
		driverslotsobj.activeSlot16=True
		driverslotsobj.openinghourSlot17='16:00:00'
		driverslotsobj.closinghourSlot17='17:00:00'
		driverslotsobj.activeSlot17=True
		driverslotsobj.openinghourSlot18='17:00:00'
		driverslotsobj.closinghourSlot18='18:00:00'
		driverslotsobj.activeSlot18=True
		driverslotsobj.openinghourSlot19='18:00:00'
		driverslotsobj.closinghourSlot19='19:00:00'
		driverslotsobj.activeSlot19=True
		driverslotsobj.openinghourSlot20='19:00:00'
		driverslotsobj.closinghourSlot20='20:00:00'
		driverslotsobj.activeSlot120=True
		driverslotsobj.openinghourSlot21='20:00:00'
		driverslotsobj.closinghourSlot21='21:00:00'
		driverslotsobj.activeSlot21=True
		driverslotsobj.openinghourSlot22='21:00:00'
		driverslotsobj.closinghourSlot22='22:00:00'
		driverslotsobj.activeSlot22=True
		driverslotsobj.openinghourSlot23='22:00:00'
		driverslotsobj.closinghourSlot23='23:00:00'
		driverslotsobj.activeSlot23=True
		driverslotsobj.openinghourSlot24='23:00:00'
		driverslotsobj.closinghourSlot24='00:00:00'
		driverslotsobj.activeSlot24=True
		driverslotsobj.save()
		return '1'
	return '0'


def changetimeslotstatus2(request, *args, **kwargs):
	'''This function is being used to edit the parcel type details by Admin'''
	print('Admin - in changetimeslotstatus2 function')
	try:	
		print(request.POST)
		slot_id = request.POST.get('slot_id')
		new_status = request.POST.get('new_status')
		driverid = request.POST.get('driverid')
		# driver_obj = DriverModel.objects.filter(id = driverid).first()
		print("DriverTimeSlots-in get ")
		alltimeslots = DriverAllSlots.objects.filter(id=driverid).first()
		# timeslots_obj = TimeSlots.objects.filter(id = slot_id).first()
		if alltimeslots:
			slot_id=int(slot_id)
			if new_status == 'enable':
				status = True
				respo=changeSlotStatus(alltimeslots,slot_id,status)
				if respo=='1':
					return JsonResponse({'status_code' : 200, 'status_message' : 'success'})
				else:
					return JsonResponse({'status_code' : 0, 'status_message' : 'error'})
			elif new_status == 'disable':
				status = False
				respo=changeSlotStatus(alltimeslots,slot_id,status)
				if respo=='1':
					return JsonResponse({'status_code' : 200, 'status_message' : 'success'})
				else:
					return JsonResponse({'status_code' : 0, 'status_message' : 'error'})
			# timeslots_obj.save()
			# return JsonResponse({'status_code' : 200, 'status_message' : 'success'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})

def changeSlotStatus(slot,idTS,status):
	# timeslots_data=[]
	# if alltimeslots:
		# for slot in alltimeslots:
	if idTS==1:
		slot.activeSlot1=status
		slot.save()
		return '1'
	elif idTS ==2:
		slot.activeSlot2=status
		slot.save()
		return '1'
	elif idTS ==3:
		slot.activeSlot3=status
		slot.save()
		return '1'
	elif idTS ==4:
		slot.activeSlot4=status
		slot.save()
		return '1'
	elif idTS ==5:
		slot.activeSlot5=status
		slot.save()
		return '1'
	elif idTS ==6:
		slot.activeSlot6=status
		slot.save()
		return '1'
	elif idTS ==7:
		slot.activeSlot7=status
		slot.save()
		return '1'
	elif idTS ==8:
		slot.activeSlot8=status
		slot.save()
		return '1'
	elif idTS ==9:
		slot.activeSlot9=status
		slot.save()
		return '1'
	elif idTS ==10:
		slot.activeSlot10=status
		slot.save()
		return '1'
	elif idTS ==11:
		slot.activeSlot11=status
		slot.save()
		return '1'
	elif idTS ==12:
		slot.activeSlot12=status
		slot.save()
		return '1'
	elif idTS ==13:
		slot.activeSlot13=status
		slot.save()
		return '1'
	elif idTS ==14:
		slot.activeSlot14=status
		slot.save()
		return '1'
	elif idTS ==15:
		slot.activeSlot15=status
		slot.save()
		return '1'
	elif idTS ==16:
		slot.activeSlot16=status
		slot.save()
		return '1'
	elif idTS ==17:
		slot.activeSlot17=status
		slot.save()
		return '1'
	elif idTS ==18:
		slot.activeSlot18=status
		slot.save()
		return '1'
	elif idTS ==19:
		slot.activeSlot19=status
		slot.save()
		return '1'
	elif idTS ==20:
		slot.activeSlot120=status
		slot.save()
		return '1'
	elif idTS ==21:
		slot.activeSlot21=status
		slot.save()
		return '1'
	elif idTS ==22:
		slot.activeSlot22=status
		slot.save()
		return '1'
	elif idTS ==23:
		slot.activeSlot23=status
		slot.save()
		return '1'
	elif idTS ==24:
		slot.activeSlot24=status
		slot.save()
		return '1'
	else:
		return '0'
	return '0'


@method_decorator(checkloginadmin, name='dispatch')
class DriverTimeSlots(TemplateView):
	template_name = 'admin_showalltimeslotsDriver.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		timeslots_data=[]
		context = super(DriverTimeSlots, self).get_context_data(**kwargs)
		slotid = kwargs['slotid']
		# driver_obj = DriverModel.objects.filter(id = driverid).first()
		# print("DriverTimeSlots-in get ")
		alltimeslots = DriverAllSlots.objects.filter(id=slotid).first()
		if alltimeslots:
			timeslots_data=addSlots(alltimeslots)
			# serialno = 0
			# for slot in alltimeslots:
			# 	timeslots_data.append({
			# 		'serialno' : 1,
			# 		'openinghour' : slot.openinghourSlot1,
			# 		'closinghour' : slot.closinghourSlot1,
			# 		'status' : slot.activeSlot1,
			# 		'id' : 1,
			# 		})

			# 	print(timeslots_data)
		paginator = Paginator(timeslots_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			alltimeslots = paginator.page(page)
			print("try")
		except PageNotAnInteger:
			alltimeslots = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			alltimeslots = paginator.page(paginator.num_pages)
			print("except2")

		context['alltimeslots'] = alltimeslots
		context['driverid'] = slotid
		return context

@method_decorator(checkloginadmin, name='dispatch')
class allDatesOfSlots(TemplateView):
	template_name = 'showDatesOfSlots.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		timeslots_data=[]
		allslotsData=[]
		context = super(allDatesOfSlots, self).get_context_data(**kwargs)
		driverid = kwargs['driverid']
		driver_obj = DriverModel.objects.filter(id = driverid).first()
		print("allDatesOfSlots-in get ")
		alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj)
		for allt in alltimeslots:
			allslotsData.append({'drivername':driver_obj.name,
				                 'date':allt.dateOfSlots,
				                 'slotid':allt.id,})
		# if alltimeslots:
		# 	timeslots_data=addSlots(alltimeslots)
		paginator = Paginator(allslotsData, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			alltimeslots = paginator.page(page)
			print("try")
		except PageNotAnInteger:
			alltimeslots = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			alltimeslots = paginator.page(paginator.num_pages)
			print("except2")

		context['alltimeslots'] = alltimeslots
		context['driverid'] = driverid
		return context

def addSlots(slot):
	timeslots_data=[]
	# if alltimeslots:
		# for slot in alltimeslots:
	timeslots_data.append({
		'serialno' : 1,
		'openinghour' : slot.openinghourSlot1,
		'closinghour' : slot.closinghourSlot1,
		'status' : slot.activeSlot1,
		'id' : 1,
		})
	timeslots_data.append({
		'serialno' : 2,
		'openinghour' : slot.openinghourSlot2,
		'closinghour' : slot.closinghourSlot2,
		'status' : slot.activeSlot2,
		'id' : 2,
		})
	timeslots_data.append({
		'serialno' : 3,
		'openinghour' : slot.openinghourSlot3,
		'closinghour' : slot.closinghourSlot3,
		'status' : slot.activeSlot3,
		'id' : 3,
		})
	timeslots_data.append({
		'serialno' : 4,
		'openinghour' : slot.openinghourSlot4,
		'closinghour' : slot.closinghourSlot4,
		'status' : slot.activeSlot4,
		'id' : 4,
		})
	timeslots_data.append({
		'serialno' : 5,
		'openinghour' : slot.openinghourSlot5,
		'closinghour' : slot.closinghourSlot5,
		'status' : slot.activeSlot5,
		'id' : 5,
		})
	timeslots_data.append({
		'serialno' : 6,
		'openinghour' : slot.openinghourSlot6,
		'closinghour' : slot.closinghourSlot6,
		'status' : slot.activeSlot6,
		'id' : 6,
		})
	timeslots_data.append({
		'serialno' : 7,
		'openinghour' : slot.openinghourSlot7,
		'closinghour' : slot.closinghourSlot7,
		'status' : slot.activeSlot7,
		'id' : 7,
		})
	timeslots_data.append({
		'serialno' : 8,
		'openinghour' : slot.openinghourSlot8,
		'closinghour' : slot.closinghourSlot8,
		'status' : slot.activeSlot8,
		'id' : 8,
		})
	timeslots_data.append({
		'serialno' : 9,
		'openinghour' : slot.openinghourSlot9,
		'closinghour' : slot.closinghourSlot9,
		'status' : slot.activeSlot9,
		'id' : 9,
		})
	timeslots_data.append({
		'serialno' : 10,
		'openinghour' : slot.openinghourSlot10,
		'closinghour' : slot.closinghourSlot10,
		'status' : slot.activeSlot10,
		'id' : 10,
		})
	timeslots_data.append({
		'serialno' : 11,
		'openinghour' : slot.openinghourSlot11,
		'closinghour' : slot.closinghourSlot11,
		'status' : slot.activeSlot11,
		'id' : 11,
		})
	timeslots_data.append({
		'serialno' : 12,
		'openinghour' : slot.openinghourSlot12,
		'closinghour' : slot.closinghourSlot12,
		'status' : slot.activeSlot12,
		'id' : 12,
		})
	timeslots_data.append({
		'serialno' : 13,
		'openinghour' : slot.openinghourSlot13,
		'closinghour' : slot.closinghourSlot13,
		'status' : slot.activeSlot13,
		'id' : 13,
		})
	timeslots_data.append({
		'serialno' : 14,
		'openinghour' : slot.openinghourSlot14,
		'closinghour' : slot.closinghourSlot14,
		'status' : slot.activeSlot14,
		'id' : 14,
		})
	timeslots_data.append({
		'serialno' : 15,
		'openinghour' : slot.openinghourSlot15,
		'closinghour' : slot.closinghourSlot15,
		'status' : slot.activeSlot15,
		'id' : 15,
		})
	timeslots_data.append({
		'serialno' : 16,
		'openinghour' : slot.openinghourSlot16,
		'closinghour' : slot.closinghourSlot16,
		'status' : slot.activeSlot16,
		'id' : 16,
		})
	timeslots_data.append({
		'serialno' : 17,
		'openinghour' : slot.openinghourSlot17,
		'closinghour' : slot.closinghourSlot17,
		'status' : slot.activeSlot17,
		'id' : 17,
		})
	timeslots_data.append({
		'serialno' : 18,
		'openinghour' : slot.openinghourSlot18,
		'closinghour' : slot.closinghourSlot18,
		'status' : slot.activeSlot18,
		'id' : 18,
		})
	timeslots_data.append({
		'serialno' : 19,
		'openinghour' : slot.openinghourSlot19,
		'closinghour' : slot.closinghourSlot19,
		'status' : slot.activeSlot19,
		'id' : 19,
		})
	timeslots_data.append({
		'serialno' : 20,
		'openinghour' : slot.openinghourSlot20,
		'closinghour' : slot.closinghourSlot20,
		'status' : slot.activeSlot120,
		'id' : 20,
		})
	timeslots_data.append({
		'serialno' : 21,
		'openinghour' : slot.openinghourSlot21,
		'closinghour' : slot.closinghourSlot21,
		'status' : slot.activeSlot21,
		'id' : 21,
		})
	timeslots_data.append({
		'serialno' : 22,
		'openinghour' : slot.openinghourSlot22,
		'closinghour' : slot.closinghourSlot22,
		'status' : slot.activeSlot22,
		'id' : 22,
		})
	timeslots_data.append({
		'serialno' : 23,
		'openinghour' : slot.openinghourSlot23,
		'closinghour' : slot.closinghourSlot23,
		'status' : slot.activeSlot23,
		'id' : 23,
		})
	timeslots_data.append({
		'serialno' : 24,
		'openinghour' : slot.openinghourSlot24,
		'closinghour' : slot.closinghourSlot24,
		'status' : slot.activeSlot24,
		'id' : 24,
		})
	print(timeslots_data)
	return timeslots_data



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDriversTimeSlots(TemplateView):
	template_name = 'admin_showalldriversTS.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDriversTimeSlots, self).get_context_data(**kwargs)
		print("AdminShowAllDriversTimeSlots-in get ")
		all_drivers = DriverModel.objects.filter(isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_drivers:
			serialno = 0
			for driver in all_drivers:
				serialno +=1
				vehicletype=''
				if driver.vehicletype == 0:
					vehicletype = 'Bike'
				elif driver.vehicletype == 1:
					vehicletype = 'Car'
				elif driver.vehicletype == 2:
					vehicletype = 'Small Van'
				elif driver.vehicletype == 3:
					vehicletype = 'Medium Van'
				elif driver.vehicletype == 4:
					vehicletype = 'Large Van'
				elif driver.vehicletype == 5:
					vehicletype = 'Not Specified'
				
				if driver.emailverified:
					emailverified = 'Yes'
				else:
					emailverified = 'No'
				if driver.accountapproved:
					accountapproved = 'Yes'
				else:
					accountapproved = 'No'
				if driver.isdisabled:
					isdisabled = 'Yes'
				else:
					isdisabled = 'No'
				
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude
				else:
					latitude = ''
					longitude = ''
				data.append({
					'serialno' : serialno,
					'name' : driver.name,
					'phone' : driver.countrycode + '-' + driver.phone,
					'email' : driver.user.email,
					'vehicletype' : vehicletype,
					'vehiclenumber' : driver.vehiclenumber,
					'preferredarea' : driver.preferredarea,
					'created_at' : driver.user.date_joined,
					'emailverified' : emailverified,
					'accountapproved' : accountapproved,
					'isdisabled' : isdisabled,
					'latitude' : latitude,
					'longitude' : longitude,
					'id' : driver.id,
					})

		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			data = paginator.page(page)
			print(len(data))
			print("truy")
		except PageNotAnInteger:
			data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_drivers'] = data
		return context


def JobCompletedByDriver(request, *args, **kwargs):
	print('Job completed by admin')
	try:
		data_ids = request.POST.get('data_ids')
		print("my one")
		print(request.POST.get('data_ids'))
		# print(request.POST)
		data_ids = json.loads(data_ids)
		print(data_ids)
		all_data_response=[]
		sameIdParcelCopy=0
		for ids in data_ids:
			print("my two")
			print(ids['customerjobid'])
			print(ids['driverjobid'])
			customerjobid_val = ids['customerjobid']
			driverjobid_val = ids['driverjobid']
			comment = ids['comment']
			comment_for_parcel=False
			print("my There")
			try:
				print("my one4")
				driverjob_obj = DriverJob.objects.filter(id  = driverjobid_val, customerjob_id = customerjobid_val).first()
				if driverjob_obj.parcel_disabled == True:
					comment_for_parcel=True
						
			except Exception as e:
				print("my one5")
				all_data_response.append({
					'customerid':customerjobid_val,
					'driverid':driverjobid_val,
					'status_message' : 'Driver Job not Found',
					'error':'true',
					})
			# parcel_comment = ids['comment']
			
			if comment_for_parcel == False:
				print("my one6")
				try:
					customerjob_obj = CustomerJob.objects.filter(id = customerjobid_val).first()
					print("my one6.1")
					sameIdParcelCopy=customerjob_obj.sameIdForParcelsDetails
					print("my one6")
					if customerjob_obj.customer.role == 'customer':
						print('customer user')
						if customerjob_obj.order.charge_from_card:
							if customerjob_obj.price:
								parcel_charge = customerjob_obj.price
								specialbooking_charge = customerjob_obj.specialbooking_charge
								
								total_amount = parcel_charge + specialbooking_charge
								# stripe.api_key = "sk_test_P9sozPTZ5nZbhc3fOFCsjNqm00hYGCvJ7l" # varis_raheja
								stripe.api_key = str(settings.STRIPE_KEY)
								storedcard_obj = StoredCard.objects.filter(id = customerjob_obj.order.charge_from_card).first()
								if storedcard_obj:
									charge = stripe.Charge.create(
									  amount=int(float(total_amount)*100),
									  currency="gbp",
									  # source = storedcard_obj.stripe_card_id,
									  customer = storedcard_obj.stripe_customer_id,
									  card = storedcard_obj.stripe_card_id,
									  description="Payment for parcel (AWB-" + str(10000 + int(customerjob_obj.id)) + ")",
									)
									customerjobpayment_obj = CustomerJobPayment.objects.create(job = customerjob_obj, stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
									if customerjobpayment_obj:
										print('payment received successfully')
						else:
							print("Customer didn't select card while placing order")
							return JsonResponse({'status_code':0})
							# return JsonResponse({'status_code': 400, 'status_message': "Customer didn't select card while placing order"})

					else:
						print('company user')
				except Exception as e:
					print(e)
					return JsonResponse({'status_code':0})
					# return JsonResponse({'status_code': 400, 'status_message': "Payment Server Error"})
			try:
				print("my one7")
				driverjob_obj = DriverJob.objects.filter(id  = driverjobid_val, customerjob_id = customerjobid_val).first()
				
				if driverjob_obj:
					if comment_for_parcel == False:
						driverjob_obj.jobcompleted = True
						driverjob_obj.adminSumitionResaon=comment
						driverjob_obj.submitByAdmin=True
						driverjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job_id = customerjobid_val).first()
							if customerjobdatetime_obj:
								customerjobdatetime_obj.itemsdelivered_datetime = current_date
								customerjobdatetime_obj.save()
							else:
								customerjob_obj = CustomerJob.objects.filter(id = customerjobid_val).first()
								if customerjob_obj:
									CustomerJobDateTime.objects.create(job = customerjob_obj, itemsdelivered_datetime = current_date)
						except Exception as e:
							print(e)
					else:
						driverjob_obj.jobcompleted = True
						driverjob_obj.save()

					
					if comment_for_parcel == False:
						try:
							sendfcmnotification(driverjob_obj.driver.fcmtoken, 'driver', 'statuschange', 'KwickDelivery', 'You have delivered parcel successfully')
						except Exception as e:
							print(e)
					else:
						try:
							sendfcmnotification(driverjob_obj.driver.fcmtoken, 'driver', 'statuschange', 'KwickDelivery', 'This Parcel is Disabled')
						except Exception as e:
							print(e)

					if comment_for_parcel == False:
						try:
							Notifications.objects.create(user = driverjob_obj.driver.user, customerjobid = driverjob_obj.customerjob.id, driverjobid = driverjob_obj.id, fordriver = True, notificationtype = 'Parcel Delivered', notificationtext = 'You have delivered parcel successfully', status = 'unread')
						except Exception as e:
							print(e)
					else:
						try:
							Notifications.objects.create(user = driverjob_obj.driver.user, customerjobid = driverjob_obj.customerjob.id, driverjobid = driverjob_obj.id, fordriver = True, notificationtype = 'Parcel Delivered', notificationtext = 'This Parcel is Disabled', status = 'unread')
						except Exception as e:
							print(e)

					if comment_for_parcel == False:	
						try:
							sendfcmnotification(driverjob_obj.customerjob.customer.fcmtoken, 'customer', 'statuschange', 'KwickDelivery', 'Your parcel is delivered successfully')
						except Exception as e:
							print(e)
					else:
						try:
							sendfcmnotification(driverjob_obj.customerjob.customer.fcmtoken, 'customer', 'statuschange', 'KwickDelivery', 'This Parcel is Disabled,Driver not found this parcel')
						except Exception as e:
							print(e)

					if comment_for_parcel == False:		
						try:
							Notifications.objects.create(user = driverjob_obj.customerjob.customer.user, customerjobid = driverjob_obj.customerjob.id, forcustomer = True, notificationtype = 'Parcel Delivered', notificationtext = 'Your parcel is delivered successfully', status = 'unread')
						except Exception as e:
							print(e)
					else:
						try:
							Notifications.objects.create(user = driverjob_obj.customerjob.customer.user, customerjobid = driverjob_obj.customerjob.id, forcustomer = True, notificationtype = 'Parcel Delivered', notificationtext = 'This Parcel is Disabled,Driver not found this parcel', status = 'unread')
						except Exception as e:
							print(e)
					if comment_for_parcel == False:
						try:
							sender_phone = str(driverjob_obj.customerjob.sendercountrycode).strip('+') + driverjob_obj.customerjob.senderphone
							recipient_phone = str(driverjob_obj.customerjob.recipientcountrycode).strip('+') + driverjob_obj.customerjob.recipientphone
							print(sender_phone)
							print(recipient_phone)
							res1 = send_text_message(sender_phone, 'Your parcel is successfully delivered.', 'OTP')
							print(res1)
							res2 = send_text_message(recipient_phone, 'You have successfully received parcel.', 'OTP')
							print(res2)
						except Exception as e:
							print(e)

						# return JsonResponse({'status_code': 200, 'status_message': 'success'})
					if comment_for_parcel == False:
						all_data_response.append({
							'customerid':customerjobid_val,
							'driverid':driverjobid_val,
							'status_message' : 'Parcel Deliverd',
							'error':'false',
							})
					else:
						all_data_response.append({
							'customerid':customerjobid_val,
							'driverid':driverjobid_val,
							'status_message' : 'This Parcel is disabled',
							'error':'false',
							})
				else:
					all_data_response.append({
						'customerid':customerjobid_val,
						'driverid':driverjobid_val,
						'status_message' : 'Driver Job not Found',
						'error':'true',
						})
			
			
			except Exception as e:
				all_data_response.append({
					'customerid':customerjobid_val,
					'driverid':driverjobid_val,
					'status_message' : 'Internal Server Error',
					'error':'true',
					})
		if sameIdParcelCopy !=0:
			slotStatusonJobCompletenew(sameIdParcelCopy)
		return JsonResponse({'status_code':200})
		# return JsonResponse({'status_code': 200, 'status_message': all_data_response})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code':0})
	

def change_credit_request_status(request, *args, **kwargs):
	'''This function is being used to edit the parcel type details by Admin'''
	print('Admin - in change_credit_request_status function')
	try:	
		print(request.POST)
		credit_request_id = request.POST.get('credit_request_id')
		new_status = request.POST.get('new_status')
		creditsrequested_obj = CreditsRequested.objects.filter(id = credit_request_id).first()
		if creditsrequested_obj:
			if new_status == 'approve':
				company_email = creditsrequested_obj.company_email
				companydetail_obj = CompanyDetail.objects.filter(customer__email = company_email).first()
				if companydetail_obj:
					companydetail_obj.credits += creditsrequested_obj.credits
					companydetail_obj.save()
					creditsrequested_obj.status = 'approved'
					msg = 'Request approved'
				print('approve request')
			if new_status == 'disapprove':
				creditsrequested_obj.status = 'disapproved'
				msg = 'Request disapproved'
			creditsrequested_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : msg})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})




def generate_outstandingjobs_csv(request):
	'''This class shows the content on show all drivers screen to Admin user'''
	print("generate_outstandingjobs_csv - function ")
	all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
	all_customerjobs_data = []
	if all_customerjobs:
		serialno = 0
		for customerjob in all_customerjobs:
			driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
			completed = False
			if driverjob_obj:
				if driverjob_obj.jobcompleted:
					completed = True

			if completed:
				serialno += 1

				OrderPayment
				orderpayment_obj = OrderPayment.objects.filter(order = customerjob.order).first()
				if orderpayment_obj:
					payment_datetime = orderpayment_obj.created_at.strftime("%d/%m/%Y %I:%M %p")
				else:
					payment_datetime = ''
				customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob).first()
				pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', ''
				if customerjobdatetime_obj:
					print(type(customerjobdatetime_obj.payment_datetime))
					if customerjobdatetime_obj.payment_datetime != '' and customerjobdatetime_obj.payment_datetime:
						payment_datetime = customerjobdatetime_obj.payment_datetime.strftime("%d/%m/%Y %I:%M %p")
					if customerjobdatetime_obj.pickup_datetime != '' and customerjobdatetime_obj.pickup_datetime:
						pickup_datetime = customerjobdatetime_obj.pickup_datetime.strftime("%d/%m/%Y %I:%M %p")
					if customerjobdatetime_obj.itemsdelivered_datetime != '' and customerjobdatetime_obj.itemsdelivered_datetime:
						itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime.strftime("%d/%m/%Y %I:%M %p")
					if customerjobdatetime_obj.deliveryfailed_datetime != '' and customerjobdatetime_obj.deliveryfailed_datetime:
						deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime.strftime("%d/%m/%Y %I:%M %p")

				driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
				driverjob_data = {}
				if driverjob_obj:
					driverjob_data.update({
						'drivername' : driverjob_obj.driver.name,
						'drivercountrycode' : driverjob_obj.driver.countrycode,
						'driverphone' : driverjob_obj.driver.phone,
						'driverid' : driverjob_obj.driver.id,
						'driverjobid' : driverjob_obj.id,
						})

				
				all_customerjobs_data.append({
					'serialno' : serialno,
					'awbnumber' : 'AWB-' + str(10000 + customerjob.id),
					'sendername' : customerjob.sendername,
					# 'senderemail' : customerjob.order.customer.user.email,
					'senderphone' : customerjob.sendercountrycode + '-' +customerjob.senderphone,
					'senderpickupaddress' : customerjob.pickupaddress,
					'recipientname' : customerjob.recipientname,
					'recipientphone' : customerjob.recipientcountrycode + '-' +customerjob.recipientphone,
					'recipientdropoffaddress' : customerjob.dropoffaddress,

					'length' : customerjob.length,
					'width' : customerjob.width,
					'height' : customerjob.height,
					'weight' : customerjob.weight,
					
					'payment_datetime' : payment_datetime,
					'pickup_datetime' : pickup_datetime,
					'itemsdelivered_datetime' : itemsdelivered_datetime,
					'deliveryfailed_datetime' : deliveryfailed_datetime,
					'driverjob_data' : driverjob_data,
					'id' : customerjob.id,
					})
	import csv 
	filename = 'completedjobs_' + str(datetime.datetime.now()) + '.csv'  
	with open('/var/www/html/GoodsDelivery/media/CSV/Completed Jobs/' + filename, 'w', newline='') as file:
	    writer = csv.writer(file)
	    writer.writerow(["Serial No.", "AWB Number", "Sender Name", "Sender Phone Number", "Sender Pickup Address", "Recipient Name", "Recipient Phone Number", "Recipient Dropoff Address", "Length", "Width", "Height", "Weight", "Payment Time", "Driver Name", "Pickup Time", "Delivered Time","Failed Delivery Time"])
	    for d in all_customerjobs_data:
	    	writer.writerow([d['serialno'], d['awbnumber'], d['sendername'], d['senderphone'], d['senderpickupaddress'], d['recipientname'], d['recipientphone'], d['recipientdropoffaddress'], d['length'], d['width'], d['height'], d['weight'], d['payment_datetime'], d['driverjob_data']['drivername'], d['pickup_datetime'], d['itemsdelivered_datetime'], d['deliveryfailed_datetime'] ])
	
	
	return JsonResponse({'status_code' : 200, 'link' : str(settings.WEB_BASE_URL) + '/media/CSV/Completed Jobs/' + filename})


def generate_completedjobs_csv(request):
	'''This class shows the content on show all drivers screen to Admin user'''
	print("generate_completedjobs_csv - function ")
	all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
	all_customerjobs_data = []
	if all_customerjobs:
		serialno = 0
		for customerjob in all_customerjobs:
			driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
			completed = False
			if driverjob_obj:
				if driverjob_obj.jobcompleted:
					completed = True

			if completed:
				serialno += 1

				OrderPayment
				orderpayment_obj = OrderPayment.objects.filter(order = customerjob.order).first()
				if orderpayment_obj:
					payment_datetime = orderpayment_obj.created_at.strftime("%d/%m/%Y %I:%M %p")
				else:
					payment_datetime = ''
				customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob).first()
				pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', ''
				if customerjobdatetime_obj:
					print(type(customerjobdatetime_obj.payment_datetime))
					if customerjobdatetime_obj.payment_datetime != '' and customerjobdatetime_obj.payment_datetime:
						payment_datetime = customerjobdatetime_obj.payment_datetime.strftime("%d/%m/%Y %I:%M %p")
					if customerjobdatetime_obj.pickup_datetime != '' and customerjobdatetime_obj.pickup_datetime:
						pickup_datetime = customerjobdatetime_obj.pickup_datetime.strftime("%d/%m/%Y %I:%M %p")
					if customerjobdatetime_obj.itemsdelivered_datetime != '' and customerjobdatetime_obj.itemsdelivered_datetime:
						itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime.strftime("%d/%m/%Y %I:%M %p")
					if customerjobdatetime_obj.deliveryfailed_datetime != '' and customerjobdatetime_obj.deliveryfailed_datetime:
						deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime.strftime("%d/%m/%Y %I:%M %p")

				driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
				driverjob_data = {}
				if driverjob_obj:
					driverjob_data.update({
						'drivername' : driverjob_obj.driver.name,
						'drivercountrycode' : driverjob_obj.driver.countrycode,
						'driverphone' : driverjob_obj.driver.phone,
						'driverid' : driverjob_obj.driver.id,
						'driverjobid' : driverjob_obj.id,
						})

				
				all_customerjobs_data.append({
					'serialno' : serialno,
					'awbnumber' : 'AWB-' + str(10000 + customerjob.id),
					'sendername' : customerjob.sendername,
					# 'senderemail' : customerjob.order.customer.user.email,
					'senderphone' : customerjob.sendercountrycode + '-' +customerjob.senderphone,
					'senderpickupaddress' : customerjob.pickupaddress,
					'recipientname' : customerjob.recipientname,
					'recipientphone' : customerjob.recipientcountrycode + '-' +customerjob.recipientphone,
					'recipientdropoffaddress' : customerjob.dropoffaddress,

					'length' : customerjob.length,
					'width' : customerjob.width,
					'height' : customerjob.height,
					'weight' : customerjob.weight,
					
					'payment_datetime' : payment_datetime,
					'pickup_datetime' : pickup_datetime,
					'itemsdelivered_datetime' : itemsdelivered_datetime,
					'deliveryfailed_datetime' : deliveryfailed_datetime,
					'driverjob_data' : driverjob_data,
					'id' : customerjob.id,
					})
	import csv 
	filename = 'completedjobs_' + str(datetime.datetime.now()) + '.csv'  
	with open('/var/www/html/GoodsDelivery/media/CSV/Completed Jobs/' + filename, 'w', newline='') as file:
	    writer = csv.writer(file)
	    writer.writerow(["Serial No.", "AWB Number", "Sender Name", "Sender Phone Number", "Sender Pickup Address", "Recipient Name", "Recipient Phone Number", "Recipient Dropoff Address", "Length", "Width", "Height", "Weight", "Payment Time", "Driver Name", "Pickup Time", "Delivered Time","Failed Delivery Time"])
	    for d in all_customerjobs_data:
	    	writer.writerow([d['serialno'], d['awbnumber'], d['sendername'], d['senderphone'], d['senderpickupaddress'], d['recipientname'], d['recipientphone'], d['recipientdropoffaddress'], d['length'], d['width'], d['height'], d['weight'], d['payment_datetime'], d['driverjob_data']['drivername'], d['pickup_datetime'], d['itemsdelivered_datetime'], d['deliveryfailed_datetime'] ])
	
	
	return JsonResponse({'status_code' : 200, 'link' : str(settings.WEB_BASE_URL) + '/media/CSV/Completed Jobs/' + filename})
	

def add_driver_payment(request, *args, **kwargs):
	'''This function is being used to add the vehicle type details by Admin'''
	print('Admin - in add_driver_payment function')
	try:
		print(request.POST)
		driver_id = request.POST.get('driver_id')
		description = request.POST.get('description')
		amount = request.POST.get('amount')
		currency = request.POST.get('currency')
		
		if not driver_id:
			return JsonResponse({'status_code' : 400, 'status_message' : 'driver_id is required.'})
		if not description:
			return JsonResponse({'status_code' : 400, 'status_message' : 'description is required.'})
		if not amount:
			return JsonResponse({'status_code' : 400, 'status_message' : 'amount is required.'})
		if not currency:
			return JsonResponse({'status_code' : 400, 'status_message' : 'currency is required.'})
		if description == 'givebonus':
			description = 'bonus'
		elif description == 'deductmoney':
			description = 'deduction'

		driverextramoney_obj = DriverExtraMoney.objects.create(driver_id = int(driver_id), description = description, amount = amount, currency = currency)
		if driverextramoney_obj:
			return JsonResponse({'status_code' : 200, 'status_message' : 'success'})
		return JsonResponse({'status_code' : 400, 'status_message' : 'success'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})



def add_operationalarea(request, *args, **kwargs):
	'''This function is being used to add the vehicle type details by Admin'''
	print('Admin - in add_operationalarea function')
	try:
		name = request.POST.get('name')
		workingradius = request.POST.get('workingradius')
		distanceunit = request.POST.get('distanceunit')
		latitude = request.POST.get('latitude')
		longitude = request.POST.get('longitude')
		
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'name is required.'})
		if not workingradius:
			return JsonResponse({'status_code' : 0, 'status_message' : 'workingradius is required.'})
		if not distanceunit:
			return JsonResponse({'status_code' : 0, 'status_message' : 'distanceunit is required.'})
		if not latitude:
			return JsonResponse({'status_code' : 0, 'status_message' : 'latitude is required.'})
		if not longitude:
			return JsonResponse({'status_code' : 0, 'status_message' : 'longitude is required.'})
		
		operationalarea_obj = OperationalArea.objects.filter(name = name).first()
		if operationalarea_obj:
			return JsonResponse({'status_code': 0, 'status_message': 'There is already a record for this place.'})
		else:
			operationalarea_obj = OperationalArea.objects.create(name = name, latitude = latitude, longitude = longitude, distance_from_centre_point = workingradius, distanceunit = distanceunit)
			if operationalarea_obj:
					return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})




def generate_csv(request):
	'''This class shows the content on show all drivers screen to Admin user'''
	print("generate_csv - function ")
	all_drivers = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id').prefetch_related('user')
	
	data = []
	if all_drivers:
		serialno = 0
		from datetime import timedelta
		from django.utils import timezone
		some_day_last_week = timezone.now().date() - timedelta(days=7)
		a = DriverJob.objects.filter(id = 1).update(updated_at = some_day_last_week)
		print(a)
		monday_of_last_week = some_day_last_week - timedelta(days=(some_day_last_week.isocalendar()[2] - 1))
		monday_of_this_week = monday_of_last_week + timedelta(days=7)
		print(monday_of_last_week)
		print(monday_of_this_week)
		print('\n')
		driverpayments_data = []
		for driver in all_drivers:
			
			driverjob_obj = DriverJob.objects.filter(driver = driver, jobcompleted = True, updated_at__gte = monday_of_last_week, updated_at__lte = monday_of_this_week)
			print(driverjob_obj)
			print('\n\n')
			payment = 0.0 
			for job in driverjob_obj:
				drivercommission = 0.0
				drivercommission = round(((70 * job.customerjob.price)/100),2)
				payment += drivercommission

			if payment != 0.0:
				serialno += 1
				data.append({
					'serialno' : serialno,
					'name' : driver.name,
					'phone' : driver.countrycode + '-' + driver.phone,
					'email' : driver.user.email,
					# 'vehiclenumber' : driver.vehiclenumber,
					'id' : driver.id,
					'payment' : payment,
					'fromdate' : monday_of_last_week,
					'todate' : monday_of_this_week-timedelta(days = 1),
					})
		print(data)	
		import csv 
		filename = 'driverpayments_' + str(datetime.datetime.now()) + '.csv'  
		with open('/var/www/html/GoodsDelivery/media/CSV/' + filename, 'w', newline='') as file:
		    writer = csv.writer(file)
		    writer.writerow(["Serial No.", "Name", "Email Address", "Phone Number", "From Date", "To Date", "Payment"])
		    for d in data:
		    	writer.writerow([d['serialno'], d['name'], d['email'], d['phone'], d['fromdate'], d['todate'], d['payment'] ])
		    
	return JsonResponse({'status_code' : 200, 'link' : str(settings.WEB_BASE_URL) + '/media/CSV/' + filename})


@method_decorator(checkloginadmin, name='dispatch')
class AdminDriverPayments(TemplateView):
	template_name = 'admin_showalldriverpayments.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminDriverPayments, self).get_context_data(**kwargs)
		print("AdminDriverPayments-in get ")
		all_drivers = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id').prefetch_related('user')
		
		data = []
		if all_drivers:
			serialno = 0
			from datetime import timedelta
			from django.utils import timezone
			some_day_last_week = timezone.now().date() - timedelta(days=7)
			a = DriverJob.objects.filter(id = 1).update(updated_at = some_day_last_week)
			print(a)
			monday_of_last_week = some_day_last_week - timedelta(days=(some_day_last_week.isocalendar()[2] - 1))
			monday_of_this_week = monday_of_last_week + timedelta(days=7)
			print(monday_of_last_week)
			print(monday_of_this_week)
			print('\n')
			driverpayments_data = []
			for driver in all_drivers:
				
				driverjob_obj = DriverJob.objects.filter(driver = driver, jobcompleted = True, updated_at__gte = monday_of_last_week, updated_at__lte = monday_of_this_week)
				print(driverjob_obj)
				print('\n\n')
				payment = 0.0 
				for job in driverjob_obj:
					drivercommission = 0.0
					drivercommission = round(((70 * job.customerjob.price)/100),2)
					payment += drivercommission

				if payment != 0.0:
					serialno +=1
					data.append({
						'serialno' : serialno,
						'name' : driver.name,
						'phone' : driver.countrycode + '-' + driver.phone,
						'email' : driver.user.email,
						# 'vehiclenumber' : driver.vehiclenumber,

						'id' : driver.id,
						'payment' : payment,
						'fromdate' : monday_of_last_week,
						'todate' : monday_of_this_week-timedelta(days = 1),
						})
			print(data)	
		context['all_drivers'] = data
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminDriversPaymentHistory(TemplateView):
	template_name = 'admin_driverspaymenthistory.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminDriversPaymentHistory, self).get_context_data(**kwargs)
		print("AdminDriversPaymentHistory-in get ")
		try:
			date = self.request.GET.get('dt')
			print(date)
			date = datetime.datetime.strptime(date, "%d/%m/%Y").date()
			print(date)
			all_drivers = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False)
			driver_payment_history_data = []
			if all_drivers:
				serialno = 0
				for driver_obj in all_drivers:
					paymenthistory_data = {}
					no_of_drops = DriverJob.objects.filter(driver = driver_obj, created_at__contains = date, jobcompleted = True).count()
					print('no_of_drops = ', no_of_drops)
					driverjob_obj = DriverJob.objects.filter(driver = driver_obj, created_at__contains = date, jobcompleted = True)
					min_time = datetime.datetime.combine(date,datetime.datetime.now().time())
					max_time = datetime.datetime.combine(date, datetime.datetime.min.time())
					if driverjob_obj:
						print('in if')
						# print(driverjob_obj)
						utc = pytz.timezone(settings.TIME_ZONE)
						min_time = utc.localize(min_time)
						max_time = utc.localize(max_time)
						for driverjob in driverjob_obj:
							customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = driverjob.customerjob).first()
							if customerjobdatetime_obj:
								print(customerjobdatetime_obj.driver_pickuparrived_datetime)
								if customerjobdatetime_obj.driver_pickuparrived_datetime:
									if min_time > customerjobdatetime_obj.driver_pickuparrived_datetime:
										min_time = customerjobdatetime_obj.driver_pickuparrived_datetime
								if customerjobdatetime_obj.itemsdelivered_datetime:
									if max_time < customerjobdatetime_obj.itemsdelivered_datetime:
										max_time = customerjobdatetime_obj.itemsdelivered_datetime
						print('min_time = ', min_time)
						print('max_time = ', max_time)
						if min_time and max_time:
							tdelta = max_time - min_time
							seconds = tdelta.seconds
							total_minutes = (seconds / 60)
							print(total_minutes)
							# total_minutes = tdelta.total_minutes()
							priceperdrop = driver_obj.vehicletype.priceperdrop
							priceperhour = driver_obj.vehicletype.priceperhour
							print('priceperdrop = ', priceperdrop)
							print('priceperhour = ', priceperhour)
							total_price = no_of_drops * priceperdrop + ((total_minutes/60) * priceperhour)
							print(total_price)
							serialno += 1
							paymenthistory_data.update({
								'serialno' : serialno,
								'driverid' : driver_obj.id,
								'name' : driver_obj.name,
								'phone' : driver_obj.phone,
								'email' : driver_obj.email,
								'no_of_drops' : no_of_drops,
								'priceperdrop' : priceperdrop,
								'priceperhour' : priceperhour,
								'min_time' : min_time,
								'max_time' : max_time,
								'total_hours' : (total_minutes/60),
								'total_price' : round(total_price,2),
								})
							
							driver_payment_history_data.append(paymenthistory_data)
					else:
						print('else')
			print('\n*15')
			print(driver_payment_history_data)
			print('\n*15')
			context['driver_payment_history_data'] = driver_payment_history_data
		except Exception as e:
			print(e)
		
		all_drivers = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id').prefetch_related('user')
		

		data = []
		if all_drivers:
			serialno = 0
			from datetime import timedelta
			from django.utils import timezone
			some_day_last_week = timezone.now().date() - timedelta(days=7)
			a = DriverJob.objects.filter(id = 1).update(updated_at = some_day_last_week)
			# print(a)
			monday_of_last_week = some_day_last_week - timedelta(days=(some_day_last_week.isocalendar()[2] - 1))
			monday_of_this_week = monday_of_last_week + timedelta(days=7)
			# print(monday_of_last_week)
			# print(monday_of_this_week)
			# print('\n')
			driverpayments_data = []
			for driver in all_drivers:
				
				driverjob_obj = DriverJob.objects.filter(driver = driver, jobcompleted = True, updated_at__gte = monday_of_last_week, updated_at__lte = monday_of_this_week)
				# print(driverjob_obj)
				# print('\n\n')
				payment = 0.0 
				for job in driverjob_obj:
					drivercommission = 0.0
					drivercommission = round(((70 * job.customerjob.price)/100),2)
					payment += drivercommission

				if payment != 0.0:
					serialno +=1
					data.append({
						'serialno' : serialno,
						'name' : driver.name,
						'phone' : driver.countrycode + '-' + driver.phone,
						'email' : driver.user.email,
						# 'vehiclenumber' : driver.vehiclenumber,

						'id' : driver.id,
						'payment' : payment,
						'fromdate' : monday_of_last_week,
						'todate' : monday_of_this_week-timedelta(days = 1),
						})
			# print(data)	
		context['all_drivers'] = data
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminOperationalArea(TemplateView):
	template_name = 'admin_operationalarea.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminOperationalArea, self).get_context_data(**kwargs)
		print("AdminOperationalArea-in get ")

		operationalareas_data = []
		operationalarea_obj = OperationalArea.objects.all()
		if operationalarea_obj:
			serialno = 0
			for obj in operationalarea_obj:
				serialno +=1
				operationalareas_data.append({
					'serialno' : serialno,
					'name' : obj.name,
					'distance_from_centre_point' : obj.distance_from_centre_point,
					'distanceunit' : obj.distanceunit,
					})
				print(operationalareas_data)
		paginator = Paginator(operationalareas_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			operationalareas_data = paginator.page(page)
			print("try")
		except PageNotAnInteger:
			operationalareas_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			operationalareas_data = paginator.page(paginator.num_pages)
			print("except2")

		context['operationalareas_data'] = operationalareas_data
		return context

	# def post(self,request,*args,**kwargs):
	# 	print('AdminBackendControl - in post')
	# 	print(request.POST)
	# 	try:
	# 		new_status = request.POST.get('new_status')
			
	# 		backendcontrol_obj = BackendControl.objects.first()
	# 		if backendcontrol_obj:
	# 			if new_status == 'enable':
	# 				backendcontrol_obj.enable = True
	# 			else:
	# 				backendcontrol_obj.enable = False
	# 			backendcontrol_obj.save()		
	# 			return JsonResponse({'status_code' : 200, 'status_message' : 'Task created successfully.'})
	# 		return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request'})
	# 	except Exception as e:
	# 		print(e)
	# 		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})



@method_decorator(checkloginadmin, name='dispatch')
class AdminBackendControl(TemplateView):
	template_name = 'admin_backendcontrol.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminBackendControl, self).get_context_data(**kwargs)
		print("AdminBackendControl-in get ")

		backendcontrol_data = []
		radiusControlData = []
		backendcontrol_obj = BackendControl.objects.all()
		if backendcontrol_obj:
			serialno = 0
			for obj in backendcontrol_obj:
				serialno +=1
				if obj.enable:
					status = 'Enabled'
				else:
					status = 'Disabled'
				if obj.price != 0.0:
					pricefield = 'yes'
				else:
					pricefield = 'no'

				backendcontrol_data.append({
					'serialno' : serialno,
					'name' : obj.name,
					'pricefield' : pricefield,
					'price' : obj.price,
					'status' : status,
					'id' : obj.id,
					})
				print(backendcontrol_data)
		paginator = Paginator(backendcontrol_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			backendcontrol_data = paginator.page(page)
			print("try")
		except PageNotAnInteger:
			backendcontrol_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			backendcontrol_data = paginator.page(paginator.num_pages)
			print("except2")
		radiusObject=RadiusControl.objects.all()
		serialno = 0
		for rD in radiusObject:
			serialno +=1
			if rD.enable:
				status = 'Enabled'
			else:
				status = 'Disabled'
			distance = rD.distance
			radiusControlData.append({
				'serialno' : serialno,
				'distance' : distance,
				'parameters' : 'Meters',
				'status' : status,
				'id' : rD.id,
				})
		allDriversData=[]
		driverModalobj=DriverModel.objects.filter(isdeleted=False,isdisabled=False)
		serialno = 0
		for d in driverModalobj:
			serialno +=1
			allDriversData.append({'serialno' : serialno,
				                    'name':d.name,
				                   'email':d.email,
				                   'id':d.id})
		allCustomerData=[]
		customerModalobj=Customer.objects.filter(isdeleted=False,isdisabled=False)
		serialno = 0
		for d in customerModalobj:
			serialno +=1
			allCustomerData.append({'serialno' : serialno,
				                     'name':d.name,
				                   'email':d.email,
				                   'id':d.id})
		context['allDriversData'] = allDriversData
		context['allCustomerData'] = allCustomerData
		context['backendcontrol_data'] = backendcontrol_data
		context['radiusControlData'] = radiusControlData
		return context

	def post(self,request,*args,**kwargs):
		print('AdminBackendControl - in post')
		print(request.POST)
		try:
			task = request.POST.get('task')
			if task == 'Auto-Assign':
				new_status = request.POST.get('new_status')
				
				backendcontrol_obj = BackendControl.objects.first()
				if backendcontrol_obj:
					if new_status == 'enable':
						backendcontrol_obj.enable = True
					else:
						backendcontrol_obj.enable = False
					backendcontrol_obj.save()		
					return JsonResponse({'status_code' : 200, 'status_message' : 'Task created successfully.'})
			elif task == 'Special Booking Charges':
				id_val = request.POST.get('id')
				price_val = request.POST.get('price')
				backendcontrol_obj = BackendControl.objects.filter(name = task).first()
				if backendcontrol_obj:
					backendcontrol_obj.price = price_val
					backendcontrol_obj.save()
					return JsonResponse({'status_code' : 200, 'status_message' : 'Price changed successfully.'})


			return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllTimeSlots(TemplateView):
	template_name = 'admin_showalltimeslots.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllTimeSlots, self).get_context_data(**kwargs)
		print("AdminShowAllTimeSlots-in get ")

		timeslots_data = []
		alltimeslots = TimeSlots.objects.all()
		if alltimeslots:
			serialno = 0
			for slot in alltimeslots:
				serialno +=1
				timeslots_data.append({
					'serialno' : serialno,
					'openinghour' : slot.openinghour,
					'closinghour' : slot.closinghour,
					'status' : slot.active,
					'id' : slot.id,
					})
				print(timeslots_data)
		paginator = Paginator(timeslots_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			alltimeslots = paginator.page(page)
			print("try")
		except PageNotAnInteger:
			alltimeslots = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			alltimeslots = paginator.page(paginator.num_pages)
			print("except2")

		context['alltimeslots'] = alltimeslots
		return context


def assign_task(request, *args, **kwargs):
	print('Admin - in assign_task function')
	try:
		print(request.POST)
		# sys.exit()
		admin_id = request.POST.get('admin_id')
		description = request.POST.get('description')
		if not admin_id:
			return JsonResponse({'status_code' : 400, 'status_message' : 'Admin id is required.'})
		if not description:
			return JsonResponse({'status_code' : 400, 'status_message' : 'Task description is required.'})
		if admin_id and description:
			admintask_obj = AdminTask.objects.create(admin_id = admin_id, description = description)
			if admintask_obj:
				return JsonResponse({'status_code' : 200, 'status_message' : 'Task created successfully.'})
			else:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
		else:
			return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllAssignedTasks(TemplateView):
	template_name = 'admin_showallassignedtasks.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllAssignedTasks, self).get_context_data(**kwargs)
		print("AdminShowAllAssignedTasks-in get ")

		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(self.request.session['email'])
		data = []
		user_obj = User.objects.filter(email = email_val).first()
		if user_obj:
			admin_obj = Admin.objects.filter(user = user_obj).prefetch_related('user').first()
			if admin_obj:
				admintask_obj =AdminTask.objects.filter(admin = admin_obj)
				if admintask_obj:
					serialno = 0
					for task in admintask_obj:
						serialno +=1
						data.append({
							'serialno' : serialno,
							'description' : task.description,
							'created_at' : task.created_at,
							'id' : task.created_at,
							})
						print(data)
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			allassignedtaks = paginator.page(page)
			print("try")
		except PageNotAnInteger:
			allassignedtaks = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			allassignedtaks = paginator.page(paginator.num_pages)
			print("except2")

		context['allassignedtaks'] = allassignedtaks
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminProfile(TemplateView):
	template_name = 'admin_profile.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on profile screen'''
		context = super(AdminProfile, self).get_context_data(**kwargs)
		print("AdminProfile - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(self.request.session['email'])
		user_obj = User.objects.filter(email = email_val).first()
		print('0')
		if user_obj:
			print('1')
			print(user_obj)
			admin_obj = Admin.objects.filter(user = user_obj).prefetch_related('user').first()
			if admin_obj:
				print('2')
				admin_data = []
				admin_data.append({
					'name' : admin_obj.name,
					'email' : admin_obj.email,
					'phone' : admin_obj.phone,
					'image' : admin_obj.image.name,
					'id' : admin_obj.id,
					})
				print(admin_data)
				context['user'] = admin_data
		context['profile_section'] = 'yes'
		return context	

	def post(self, request):
		'''This function shows the content on profile screen'''
		print("AdminProfile - in post ")
		try:	
			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				try:	
					print('HERE')
					base64_data = codec.split(";base64,")
					extens = base64_data[0]
					ext = extens.split("/")
					extension = str(ext[1])
					base64_data = base64_data[1]
					byte_data = base64.b64decode(base64_data)
					image_data = BytesIO(byte_data)
					img = Image.open(image_data)
					admin_obj = Admin.objects.get(id=id_val)
					st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
					thumbnailsize_objs = ThumbnailSize.objects.all()
					filepath = str(settings.BASE_DIR)+'/media/Users/Admins/'+str(admin_obj.id)+'_'+str(admin_obj.user.email)
					if(os.path.exists(filepath)):
						filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
						for f in filesToRemove:
							os.remove(f) 
					else:
						os.makedirs(filepath)
					for obj in thumbnailsize_objs:
						img = Image.open(image_data)
						im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
						im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
					img = Image.open(image_data)	
					img.save(filepath+'/original-'+st+'.'+extension)	
					filename = '/media/Users/Admins/'+str(admin_obj.id)+'_'+str(admin_obj.user.email)+'/original-'+st+'.'+extension
					admin_obj.image = filename
					admin_obj.save()
					return (1)
				except Exception as e:
					print(e)
					return (0)
			
			print(request.POST)
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			
			adminid_val = self.request.POST.get('adminid')
			name_val = self.request.POST.get('name')
			email_val = self.request.POST.get('email')
			phone_val = self.request.POST.get('phone')
			image_val = self.request.POST.get('image')

			if not adminid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Admin Id is required'})
			if not name_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Name is required'})
			if not email_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Email Address is required'})
			if not phone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Phone is required'})
			
			if userrole_val == 'admin' or userrole_val == 'superadmin':
				admin_obj = Admin.objects.filter(id = adminid_val).first()
				if admin_obj:
					admin_obj.name = name_val
					admin_obj.email = email_val
					admin_obj.phone = phone_val
					admin_obj.save()
					if image_val:
						codec = image_val
						res = getI420FromBase64(codec,id_val = admin_obj.id)
						print(res)
					return JsonResponse({'status_code': 200, 'status_message': 'Profile updated successfully'})
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'You are not allowed to change details'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})

# This Function is created and impleement by manpreet singh on 06/11/2020
@method_decorator(checkloginadmin, name='dispatch')
class AdminShowCustomerJobExtraTest(TemplateView):
	template_name = 'admin_showcustomerjob.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowCustomerJobExtraTest, self).get_context_data(**kwargs)
		print("AdminShowCustomerJob-in get ")
		data = {}
		parcel_dict = {}
		parcel_list=[]
		customerjobid = kwargs['customerjobid']
		customerjob_obj=CustomerJob.objects.filter(sameIdForParcelsDetails = customerjobid).first()
		customerjob_obj2forParcels=CustomerJob.objects.filter(sameIdForParcelsDetails = customerjobid)
		if customerjob_obj:
			if not customerjob_obj.sendercountrycode:
				sendercountrycode = ''
			else:
				sendercountrycode = customerjob_obj.sendercountrycode

			if not customerjob_obj.recipientcountrycode:
				recipientcountrycode = ''
			else:
				recipientcountrycode = customerjob_obj.recipientcountrycode
			if not customerjob_obj.qrcode:
				qrcode = ''
			else:
				qrcode = str(settings.MEDIA_BASE_URL) + customerjob_obj.qrcode.name
			if not customerjob_obj.image:
				parcelimage = str(settings.MEDIA_BASE_URL) + str(settings.PARCEL_DEFAULT_IMAGE_PATH)
			else:
				parcelimage = str(settings.MEDIA_BASE_URL) + customerjob_obj.image.name

			if customerjob_obj.parcelpdf:
				parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
			else:
				parcelpdf_link = ''

			totalamount = customerjob_obj.price + customerjob_obj.specialbooking_charge


			customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob_obj).first()
			payment_datetime, pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', '', ''
			if customerjobdatetime_obj:
				payment_datetime = customerjobdatetime_obj.payment_datetime
				pickup_datetime = customerjobdatetime_obj.pickup_datetime
				itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime
				deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime

			delivery_proof_method, delivery_toperson_name, delivery_toperson_phone, delivery_toperson_signature = '', '', '', ''
			pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
			customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job = customerjob_obj).first()
			if customerjobdeliveryextradetails_obj:
				if customerjobdeliveryextradetails_obj.delivery_proof_method == 'signature':
					delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
					delivery_toperson_name = customerjobdeliveryextradetails_obj.delivery_toperson_name
					delivery_toperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.delivery_toperson_signature.name
				elif customerjobdeliveryextradetails_obj.delivery_proof_method == 'otp':
					delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
					delivery_toperson_name = customerjob_obj.recipientname
					delivery_toperson_phone = customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone
				else:
					delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method

				
				if customerjobdeliveryextradetails_obj.pickup_proof_method == 'signature':
					pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
					pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
					pickup_fromperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.pickup_fromperson_signature.name
				elif customerjobdeliveryextradetails_obj.pickup_proof_method == 'otp':
					pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
					pickup_fromperson_name = customerjob_obj.sendername
					pickup_fromperson_phone = customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone
				else:
					pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
					pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
			
			driverexist = False
			driverjob_data = {}
			driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
			if driverjob_obj:
				driverjob_data.update({
					'drivername' : driverjob_obj.driver.name,
					'drivercountrycode' : driverjob_obj.driver.countrycode,
					'driverphone' : driverjob_obj.driver.phone,
					'driverid' : driverjob_obj.driver.id,
					'driverjobid' : driverjob_obj.id,
					})
				driverexist = True	
			data.update({
				'id' : customerjob_obj.id,
				'sendername' : customerjob_obj.sendername,
				'senderemail' : customerjob_obj.customer.user.email,
				'senderphone' : customerjob_obj.senderphone,
				'sendercity' : customerjob_obj.sendercity,
				'senderpickupaddress' : customerjob_obj.pickupaddress,
				'pickuptimeslot' : customerjob_obj.pickuptimeslot,
				'recipientname' : customerjob_obj.recipientname,
				'recipientphone' : customerjob_obj.recipientphone,
				'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
				'dropofftimeslot' : customerjob_obj.dropofftimeslot,

				'pickupspecialnote' : customerjob_obj.pickupspecialnote,
				'dropoffspecialnote' : customerjob_obj.dropoffspecialnote,

				'length' : customerjob_obj.length,
				'weight' : customerjob_obj.weight,
				'height' : customerjob_obj.height,
				'width' : customerjob_obj.width,
				'parceltype' : customerjob_obj.parceltype,
				'image' : customerjob_obj.image,
				'vehicletype' : customerjob_obj.vehicletype.name,
				# 'price' : customerjob_obj.price,
				'specialbooking_charge' : customerjob_obj.specialbooking_charge,
				'totalamount' : totalamount,
				'specialbooking' : customerjob_obj.specialbooking,
				'parcelimage' : parcelimage,
				'parcelpdf_link' : parcelpdf_link,
				'qrcode' : qrcode,
				'customerjobid' : customerjob_obj.id,
				'awbnumber' : 'AWB-' + str(10000 + customerjob_obj.id),
				'driverexist' : driverexist,
				'driverdetails' : driverjob_data,


				'delivery_proof_method' : delivery_proof_method,
				'delivery_toperson_name' : delivery_toperson_name,
				'delivery_toperson_phone' : delivery_toperson_phone,
				'delivery_toperson_signature' : delivery_toperson_signature,
				
				'pickup_proof_method' : pickup_proof_method,
				'pickup_fromperson_name' : pickup_fromperson_name,
				'pickup_fromperson_phone' : pickup_fromperson_phone,
				'pickup_fromperson_signature' : pickup_fromperson_signature,

				'pickup_datetime' : pickup_datetime,
				'itemsdelivered_datetime' : itemsdelivered_datetime,
				'payment_datetime' : payment_datetime,

				
				})
			totalPrice=0
			totalamountWithSpecialBooking=0
			for parcel in customerjob_obj2forParcels:
				totalPrice=totalPrice+parcel.price
				driverexist1 = False
				safeplaceDeliverd = False
				driverjob_data1 = {}
				safepalaceData = {}
				driverjob_obj1 = DriverJob.objects.filter(customerjob = parcel).first()
				if driverjob_obj1:
					driverjob_data1.update({
						'drivername1' : driverjob_obj1.driver.name,
						'drivercountrycode1' : driverjob_obj1.driver.countrycode,
						'driverphone1' : driverjob_obj1.driver.phone,
						'driverid1' : driverjob_obj1.driver.id,
						'driverjobid1' : driverjob_obj1.id,
						'completeStatus':driverjob_obj1.jobcompleted,
						})
					driverexist1 = True
				if driverjob_obj1:
					if driverjob_obj1.safeplaceDeliverd:
						safeplaceDeliverd = True
						driveSafePalace=DriverDropSafePalace.objects.filter(customerjob = parcel,driver_job=driverjob_obj1).first()
						safepalaceImage=driveSafePalace.safeplace.name
						safepalaceTime=driveSafePalace.created_at
						safepalaceData.update({'image':str(settings.MEDIA_BASE_URL) + safepalaceImage,
							                   'time':safepalaceTime})
				if not customerjob_obj.qrcode:
					qrcode = ''
				else:
					qrcode = str(settings.MEDIA_BASE_URL) + parcel.qrcode.name
				if not customerjob_obj.image:
					parcelimage = str(settings.MEDIA_BASE_URL) + str(settings.PARCEL_DEFAULT_IMAGE_PATH)
				else:
					parcelimage = str(settings.MEDIA_BASE_URL) + parcel.image.name

				if customerjob_obj.parcelpdf:
					parcelpdf_link = str(settings.WEB_BASE_URL) + parcel.parcelpdf.name
				else:
					parcelpdf_link = ''

				totalamountWithSpecialBookinginParcel = parcel.price + parcel.specialbooking_charge
				totalamountWithSpecialBooking = customerjob_obj.price + totalamountWithSpecialBookinginParcel
				parcel_list.append({
				'length' : parcel.length,
				'weight' : parcel.weight,
				'height' : parcel.height,
				'width' : parcel.width,
				'parceltype' : parcel.parceltype,
				'image' : parcel.image,
				'vehicletype' : parcel.vehicletype.name,
				'price' : parcel.price,
				'specialbooking_charge' : parcel.specialbooking_charge,
				'totalamount' : totalamount,
				'specialbooking' : parcel.specialbooking,
				'parcelimage' : parcelimage,
				'parcelpdf_link' : parcelpdf_link,
				'qrcode' : qrcode,
				'customerjobid' : parcel.id,
				'awbnumber' : 'AWB-' + str(10000 + parcel.id),
				'recipientname' : parcel.recipientname,
				'recipientphone' : parcel.recipientphone,
				'recipientdropoffaddress' : parcel.dropoffaddress,
				'dropofftimeslot' : parcel.dropofftimeslot,

				'pickupspecialnote' : parcel.pickupspecialnote,
				'dropoffspecialnote' : parcel.dropoffspecialnote,
				'driverexist1' : driverexist1,
				'driverdetails1' : driverjob_data1,
				'customerjobid1' : parcel.id,
				'safeplaceDeliverd':safeplaceDeliverd,
				'safepalaceData':safepalaceData,

				})
			data.update({'price' : totalPrice,
				         'priceWithSpecialBooking':totalamountWithSpecialBooking,})
				# parcel_list.append(parcel_dict)
			context['customerjob'] = data
			context['parceldata'] = parcel_list
			print(parcel_list)
			# print(context['customerjob'])

		return context


# This Function is created and impleement by manpreet singh on 06/11/2020
@method_decorator(checkloginadmin, name='dispatch')
class AdminShowCustomerJobExtraTest2(TemplateView):
	template_name = 'admin_showcustomerjob.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowCustomerJobExtraTest2, self).get_context_data(**kwargs)
		print("AdminShowCustomerJobExtraTest2-in get ")
		data = {}
		parcel_dict = {}
		parcel_list=[]
		customerjobid = kwargs['customerjobid']
		customerjob_obj=CustomerJob.objects.filter(sameIdForParcelsDetails = customerjobid).first()
		customerjob_obj2forParcels=CustomerJob.objects.filter(sameIdForParcelsDetails = customerjobid)
		show='yes'
		countLoop=[]
		if customerjob_obj:
			pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
			for customerjob_obj in customerjob_obj2forParcels:
				data = {}
				if not customerjob_obj.sendercountrycode:
					sendercountrycode = ''
				else:
					sendercountrycode = customerjob_obj.sendercountrycode

				if not customerjob_obj.recipientcountrycode:
					recipientcountrycode = ''
				else:
					recipientcountrycode = customerjob_obj.recipientcountrycode
				if not customerjob_obj.qrcode:
					qrcode = ''
				else:
					qrcode = str(settings.MEDIA_BASE_URL) + customerjob_obj.qrcode.name
				if not customerjob_obj.image:
					parcelimage = str(settings.MEDIA_BASE_URL) + str(settings.PARCEL_DEFAULT_IMAGE_PATH)
				else:
					parcelimage = str(settings.MEDIA_BASE_URL) + customerjob_obj.image.name

				if customerjob_obj.parcelpdf:
					parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
				else:
					parcelpdf_link = ''

				totalamount = customerjob_obj.price + customerjob_obj.specialbooking_charge


				customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob_obj).first()
				payment_datetime, pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', '', ''
				if customerjobdatetime_obj:
					payment_datetime = customerjobdatetime_obj.payment_datetime
					pickup_datetime = customerjobdatetime_obj.pickup_datetime
					itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime
					deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime

				delivery_proof_method, delivery_toperson_name, delivery_toperson_phone, delivery_toperson_signature = '', '', '', ''
				# pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
				customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job = customerjob_obj).first()
				if customerjobdeliveryextradetails_obj:
					if customerjobdeliveryextradetails_obj.delivery_proof_method == 'signature':
						delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
						delivery_toperson_name = customerjobdeliveryextradetails_obj.delivery_toperson_name
						delivery_toperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.delivery_toperson_signature.name
					elif customerjobdeliveryextradetails_obj.delivery_proof_method == 'otp':
						delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
						delivery_toperson_name = customerjob_obj.recipientname
						delivery_toperson_phone = customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone
					else:
						delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method

					if pickup_proof_method=='' and pickup_fromperson_name =='':
						if customerjobdeliveryextradetails_obj.pickup_proof_method == 'signature':
							pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
							pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
							pickup_fromperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.pickup_fromperson_signature.name
						elif customerjobdeliveryextradetails_obj.pickup_proof_method == 'otp':
							pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
							pickup_fromperson_name = customerjob_obj.sendername
							pickup_fromperson_phone = customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone
						else:
							pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
							pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
				deliveryIsFailedOrNot=False
				failedData={}
				try:
					deliveryFailed=CustomerJobDeliveryFailed.objects.filter(job=customerjob_obj,isdeleted=False).first()
					if deliveryFailed:
						deliveryIsFailedOrNot=True
						failedimage=str(settings.MEDIA_BASE_URL)+deliveryFailed.deliveryfailed_image.name
						failedData.update({'image':failedimage,
							               'dateandTime':deliveryFailed.deliveryfailed_datetime,
							               'reason':deliveryFailed.deliveryfailurereason, 
							               })
				except Exception as e:
					print(e)
				deliveryonSafePalaceorNot=False
				safePalaceDeliverData={}
				try:
					driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
					if driverjob_obj:
						SafePalaceObject=DriverDropSafePalace.objects.filter(customerjob=customerjob_obj,driver_job=driverjob_obj).first()
						if SafePalaceObject:
							deliveryonSafePalaceorNot=True
							safeImage=str(settings.MEDIA_BASE_URL)+SafePalaceObject.safeplace.name
							safePalaceDeliverData.update({'image':safeImage,
								               'dateandTime':SafePalaceObject.created_at,
								               })
				except Exception as e:
					print(e)
				driverexist = False
				driverjob_data = {}
				driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
				if driverjob_obj:
					if driverjob_obj.jobcompleted != True:
						show='no'
					driverjob_data.update({
						'drivername' : driverjob_obj.driver.name,
						'drivercountrycode' : driverjob_obj.driver.countrycode,
						'driverphone' : driverjob_obj.driver.phone,
						'driverid' : driverjob_obj.driver.id,
						'driverjobid' : driverjob_obj.id,
						'completeStatus':driverjob_obj.jobcompleted,
						})
					driverexist = True	
				data.update({
					'id' : customerjob_obj.id,
					'sendername' : customerjob_obj.sendername,
					'senderemail' : customerjob_obj.customer.user.email,
					'senderphone' : customerjob_obj.senderphone,
					'sendercity' : customerjob_obj.sendercity,
					'senderpickupaddress' : customerjob_obj.pickupaddress,
					'pickuptimeslot' : customerjob_obj.pickuptimeslot,
					'recipientname' : customerjob_obj.recipientname,
					'recipientphone' : customerjob_obj.recipientphone,
					'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
					'dropofftimeslot' : customerjob_obj.dropofftimeslot,

					'pickupspecialnote' : customerjob_obj.pickupspecialnote,
					'dropoffspecialnote' : customerjob_obj.dropoffspecialnote,

					'length' : customerjob_obj.length,
					'weight' : customerjob_obj.weight,
					'height' : customerjob_obj.height,
					'width' : customerjob_obj.width,
					'parceltype' : customerjob_obj.parceltype,
					'image' : customerjob_obj.image,
					'vehicletype' : customerjob_obj.vehicletype.name,
					'price' : customerjob_obj.price,
					'specialbooking_charge' : customerjob_obj.specialbooking_charge,
					'totalamount' : totalamount,
					'specialbooking' : customerjob_obj.specialbooking,
					'parcelimage' : parcelimage,
					'parcelpdf_link' : parcelpdf_link,
					'qrcode' : qrcode,
					'customerjobid' : customerjob_obj.id,
					'awbnumber' : 'AWB-' + str(10000 + customerjob_obj.id),
					'driverexist' : driverexist,
					'driverdetails' : driverjob_data,


					'delivery_proof_method' : delivery_proof_method,
					'delivery_toperson_name' : delivery_toperson_name,
					'delivery_toperson_phone' : delivery_toperson_phone,
					'delivery_toperson_signature' : delivery_toperson_signature,
					
					'pickup_proof_method' : pickup_proof_method,
					'pickup_fromperson_name' : pickup_fromperson_name,
					'pickup_fromperson_phone' : pickup_fromperson_phone,
					'pickup_fromperson_signature' : pickup_fromperson_signature,

					'pickup_datetime' : pickup_datetime,
					'itemsdelivered_datetime' : itemsdelivered_datetime,
					'payment_datetime' : payment_datetime,
					'priorityId':customerjob_obj.priorityBaseIDForParcel,
					'deliveryIsFailedOrNot':deliveryIsFailedOrNot,
					'failedData':failedData,
					'deliveryonSafePalaceorNot':deliveryonSafePalaceorNot,
					'safePalaceDeliverData':safePalaceDeliverData,
					'pickuptimeslotDate':customerjob_obj.pickuptimeslotDate,
					
					})
				countLoop.append(customerjob_obj.priorityBaseIDForParcel)
				parcel_list.append(data)
			context['parceldata'] = parcel_list
			context['totalNo']=len(parcel_list)
			context['title'] = show
			context['countLoop'] = countLoop
			print(parcel_list)
			# print(context['customerjob'])

		return context		



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowCustomerJob(TemplateView):
	template_name = 'admin_showcustomerjob.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowCustomerJob, self).get_context_data(**kwargs)
		print("AdminShowCustomerJob-in get ")
		data = {}
		customerjobid = kwargs['customerjobid']
		customerjob_obj=CustomerJob.objects.filter(id = customerjobid).first()
		if customerjob_obj:
			if not customerjob_obj.sendercountrycode:
				sendercountrycode = ''
			else:
				sendercountrycode = customerjob_obj.sendercountrycode

			if not customerjob_obj.recipientcountrycode:
				recipientcountrycode = ''
			else:
				recipientcountrycode = customerjob_obj.recipientcountrycode
			if not customerjob_obj.qrcode:
				qrcode = ''
			else:
				qrcode = str(settings.MEDIA_BASE_URL) + customerjob_obj.qrcode.name
			if not customerjob_obj.image:
				parcelimage = str(settings.MEDIA_BASE_URL) + str(settings.PARCEL_DEFAULT_IMAGE_PATH)
			else:
				parcelimage = str(settings.MEDIA_BASE_URL) + customerjob_obj.image.name

			if customerjob_obj.parcelpdf:
				parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
			else:
				parcelpdf_link = ''

			totalamount = customerjob_obj.price + customerjob_obj.specialbooking_charge


			customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob_obj).first()
			payment_datetime, pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', '', ''
			if customerjobdatetime_obj:
				payment_datetime = customerjobdatetime_obj.payment_datetime
				pickup_datetime = customerjobdatetime_obj.pickup_datetime
				itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime
				deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime

			delivery_proof_method, delivery_toperson_name, delivery_toperson_phone, delivery_toperson_signature = '', '', '', ''
			pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
			customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job = customerjob_obj).first()
			if customerjobdeliveryextradetails_obj:
				if customerjobdeliveryextradetails_obj.delivery_proof_method == 'signature':
					delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
					delivery_toperson_name = customerjobdeliveryextradetails_obj.delivery_toperson_name
					delivery_toperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.delivery_toperson_signature.name
				elif customerjobdeliveryextradetails_obj.delivery_proof_method == 'otp':
					delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
					delivery_toperson_name = customerjob_obj.recipientname
					delivery_toperson_phone = customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone
				else:
					delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method

				
				if customerjobdeliveryextradetails_obj.pickup_proof_method == 'signature':
					pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
					pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
					pickup_fromperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.pickup_fromperson_signature.name
				elif customerjobdeliveryextradetails_obj.pickup_proof_method == 'otp':
					pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
					pickup_fromperson_name = customerjob_obj.sendername
					pickup_fromperson_phone = customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone
				else:
					pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
					pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
			
			driverexist = False
			driverjob_data = {}
			driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
			if driverjob_obj:
				driverjob_data.update({
					'drivername' : driverjob_obj.driver.name,
					'drivercountrycode' : driverjob_obj.driver.countrycode,
					'driverphone' : driverjob_obj.driver.phone,
					'driverid' : driverjob_obj.driver.id,
					'driverjobid' : driverjob_obj.id,
					})
				driverexist = True	
			data.update({
				'id' : customerjob_obj.id,
				'sendername' : customerjob_obj.sendername,
				'senderemail' : customerjob_obj.customer.user.email,
				'senderphone' : customerjob_obj.senderphone,
				'sendercity' : customerjob_obj.sendercity,
				'senderpickupaddress' : customerjob_obj.pickupaddress,
				'pickuptimeslot' : customerjob_obj.pickuptimeslot,
				'recipientname' : customerjob_obj.recipientname,
				'recipientphone' : customerjob_obj.recipientphone,
				'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
				'dropofftimeslot' : customerjob_obj.dropofftimeslot,

				'pickupspecialnote' : customerjob_obj.pickupspecialnote,
				'dropoffspecialnote' : customerjob_obj.dropoffspecialnote,

				'length' : customerjob_obj.length,
				'weight' : customerjob_obj.weight,
				'height' : customerjob_obj.height,
				'width' : customerjob_obj.width,
				'parceltype' : customerjob_obj.parceltype,
				'image' : customerjob_obj.image,
				'vehicletype' : customerjob_obj.vehicletype.name,
				'price' : customerjob_obj.price,
				'specialbooking_charge' : customerjob_obj.specialbooking_charge,
				'totalamount' : totalamount,
				'specialbooking' : customerjob_obj.specialbooking,
				'parcelimage' : parcelimage,
				'parcelpdf_link' : parcelpdf_link,
				'qrcode' : qrcode,
				'customerjobid' : customerjob_obj.id,
				'awbnumber' : 'AWB-' + str(10000 + customerjob_obj.id),
				'driverexist' : driverexist,
				'driverdetails' : driverjob_data,


				'delivery_proof_method' : delivery_proof_method,
				'delivery_toperson_name' : delivery_toperson_name,
				'delivery_toperson_phone' : delivery_toperson_phone,
				'delivery_toperson_signature' : delivery_toperson_signature,
				
				'pickup_proof_method' : pickup_proof_method,
				'pickup_fromperson_name' : pickup_fromperson_name,
				'pickup_fromperson_phone' : pickup_fromperson_phone,
				'pickup_fromperson_signature' : pickup_fromperson_signature,

				'pickup_datetime' : pickup_datetime,
				'itemsdelivered_datetime' : itemsdelivered_datetime,
				'payment_datetime' : payment_datetime,

				
				})

			context['customerjob'] = data
			print(context['customerjob'])

		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminDriverOutstandingCustomerJobsTest(TemplateView):
	template_name = 'admin_driver_outstandingcustomerjobs_test2.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminDriverOutstandingCustomerJobsTest, self).get_context_data(**kwargs)
		print("AdminDriverOutstandingCustomerJobsTest-in get ")
		data = []
		tracking_data = []
		driverid = kwargs['driverid']
		driver_obj = DriverModel.objects.filter(id = driverid).first()
		if driver_obj:
			driverlatitude, driverlongitude = '', ''
			drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
			if drivercoordinates_obj:
				print('drivercoordinates_obj exists')
				driverlatitude = drivercoordinates_obj.latitude
				driverlongitude = drivercoordinates_obj.longitude
			else:
				print('drivercoordinates_obj does not exist')
			driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False)
			for driverjob in driverjobs_obj:
				if driverjob.jobstarted or driverjob.jobcompleted: 
					if driverjob.jobcompleted:
						status = 'Completed'
					elif driverjob.jobstarted:
						status = 'Picked Up'
				else:
					status = 'Assigned'
				if status == 'Picked Up' or status == 'Assigned':
					data.append({
						'sendername' : driverjob.customerjob.sendername,
						'senderemail' : driverjob.customerjob.senderemail,
						'senderphone' : driverjob.customerjob.senderphone,
						'senderpickupaddress' : driverjob.customerjob.pickupaddress,
						'senderlatitude' : driverjob.customerjob.senderlatitude,
						'senderlongitude' : driverjob.customerjob.senderlongitude,
						'recipientname' : driverjob.customerjob.recipientname,
						'recipientdropoffaddress' : driverjob.customerjob.dropoffaddress,
						'recipientlatitude' : driverjob.customerjob.recipientlatitude,
						'recipientlongitude' : driverjob.customerjob.recipientlongitude,

						'customerjobid' : driverjob.customerjob.id,
						'status' : status,
						'id' : driverjob.id,
						})
					tracking_data.append({
						'type' : 'pickup',
						'address' : driverjob.customerjob.pickupaddress,
						'latitude' : driverjob.customerjob.senderlatitude,
						'longitude' : driverjob.customerjob.senderlongitude,
						'typeplusaddress' : '<b>Pickup:</b> ' + driverjob.customerjob.pickupaddress,
						})

					tracking_data.append({
						'type' : 'dropoff',
						'address' : driverjob.customerjob.dropoffaddress,
						'latitude' : driverjob.customerjob.recipientlatitude,
						'longitude' : driverjob.customerjob.recipientlongitude,
						'typeplusaddress' : '<b>Dropoff:</b> ' + driverjob.customerjob.dropoffaddress,
						
						})
				# print(data)
				

			tracking_data.append({
				'type' : 'driverlocation',
				'address' : 'Start',
				'latitude' : driverlatitude,
				'longitude' : driverlongitude,
				'typeplusaddress' : '<b>Start</b>'
				
				})

			context['all_driverjobs'] = data
			context['driverlatitude'] = driverlatitude
			context['driverlongitude'] = driverlongitude
			print(len(tracking_data))

			def haversine(lat1, lon1, lat2, lon2):
				print(lat1, lon1, lat2, lon2)
				lat1, lon1, lat2, lon2 = map(float, [lat1, lon1, lat2, lon2])# haversine formula 
				lat1, lon1, lat2, lon2 = map(radians, [lat1, lon1, lat2, lon2])# haversine formula 
				dlon = lon2 - lon1 
				dlat = lat2 - lat1 
				a = sin(dlat/2)**2 + cos(lat1) * cos(lat2) * sin(dlon/2)**2
				c = 2 * asin(sqrt(a)) 
				r = 6371 # Radius of earth in kilometers. Use 3956 for miles
				return (c * r)

			for location in tracking_data:
				distance_fromdriverlocation = haversine(driverlatitude, driverlongitude, location['latitude'], location['longitude'])
				location['distance_fromdriverlocation'] = distance_fromdriverlocation

			tracking_data = sorted(tracking_data, key = lambda i: i['distance_fromdriverlocation'], reverse = False)
			print('\n\n')
			for location in tracking_data:
				print(location['address'] + '  --  ' + str(location['distance_fromdriverlocation']))
			print('\n\n')
			context['tracking_data'] = tracking_data
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminDriverOutstandingCustomerJobs(TemplateView):
	template_name = 'admin_driver_outstandingcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminDriverOutstandingCustomerJobs, self).get_context_data(**kwargs)
		print("AdminDriverOutstandingCustomerJobs-in get ")
		data = []
		tracking_data = []
		driverid = kwargs['driverid']
		driver_obj = DriverModel.objects.filter(id = driverid).first()
		if driver_obj:
			driverlatitude, driverlongitude = '', ''
			drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
			if drivercoordinates_obj:
				print('drivercoordinates_obj exists')
				driverlatitude = drivercoordinates_obj.latitude
				driverlongitude = drivercoordinates_obj.longitude
			else:
				print('drivercoordinates_obj does not exist')
			driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False)
			for driverjob in driverjobs_obj:
				if driverjob.jobstarted or driverjob.jobcompleted: 
					if driverjob.jobcompleted:
						status = 'Completed'
					elif driverjob.jobstarted:
						status = 'Picked Up'
				else:
					status = 'Assigned'


				# if status == 'Picked Up' or status == 'Assigned':
				if status != 'Completed':
					data.append({
						'sendername' : driverjob.customerjob.sendername,
						'senderemail' : driverjob.customerjob.senderemail,
						'senderphone' : driverjob.customerjob.senderphone,
						'senderpickupaddress' : driverjob.customerjob.pickupaddress,
						'senderlatitude' : driverjob.customerjob.senderlatitude,
						'senderlongitude' : driverjob.customerjob.senderlongitude,
						'recipientname' : driverjob.customerjob.recipientname,
						'recipientdropoffaddress' : driverjob.customerjob.dropoffaddress,
						'recipientlatitude' : driverjob.customerjob.recipientlatitude,
						'recipientlongitude' : driverjob.customerjob.recipientlongitude,

						'customerjobid' : driverjob.customerjob.id,
						'status' : status,
						'id' : driverjob.id,
						})
					tracking_data.append({
						'type' : 'pickup',
						'address' : driverjob.customerjob.pickupaddress,
						'latitude' : driverjob.customerjob.senderlatitude,
						'longitude' : driverjob.customerjob.senderlongitude,
						})

					tracking_data.append({
						'type' : 'dropoff',
						'address' : driverjob.customerjob.dropoffaddress,
						'latitude' : driverjob.customerjob.recipientlatitude,
						'longitude' : driverjob.customerjob.recipientlongitude,
						
						})
				print(data)
				



			context['all_driverjobs'] = data
			context['driverlatitude'] = driverlatitude
			context['driverlongitude'] = driverlongitude
			print(len(tracking_data))
			def haversine(lat1, lon1, lat2, lon2):
				print(lat1)
				print(lon1)
				print(lat2)
				print(lon2)
				lat1, lon1, lat2, lon2 = map(float, [lat1, lon1, lat2, lon2])# haversine formula 
				lat1, lon1, lat2, lon2 = map(radians, [lat1, lon1, lat2, lon2])# haversine formula 
				dlon = lon2 - lon1 
				dlat = lat2 - lat1 
				a = sin(dlat/2)**2 + cos(lat1) * cos(lat2) * sin(dlon/2)**2
				c = 2 * asin(sqrt(a)) 
				r = 6371 # Radius of earth in kilometers. Use 3956 for miles
				return (c * r)

			for location in tracking_data:
				distance_fromdriverlocation = haversine(driverlatitude, driverlongitude, location['latitude'], location['longitude'])
				location['distance_fromdriverlocation'] = distance_fromdriverlocation

			tracking_data = sorted(tracking_data, key = lambda i: i['distance_fromdriverlocation'], reverse = False)
			print('\n\n')
			for location in tracking_data:
				print(location['address'] + '  --  ' + str(location['distance_fromdriverlocation']))
			print('\n\n')
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminDriverAllCustomerJobs(TemplateView):
	template_name = 'admin_driver_allcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminDriverAllCustomerJobs, self).get_context_data(**kwargs)
		print("AdminDriverAllCustomerJobs-in get ")
		data = []
		driverid = kwargs['driverid']
		driver_obj = DriverModel.objects.filter(id = driverid).first()
		if driver_obj:
			driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False)
			for driverjob in driverjobs_obj:
				if driverjob.jobstarted or driverjob.jobcompleted: 
					if driverjob.jobcompleted:
						status = 'Completed'
					elif driverjob.jobstarted:
						status = 'Picked Up'
				else:
					status = 'Assigned'
				if status == 'Picked Up' or status == 'Assigned':
					data.append({
						'sendername' : driverjob.customerjob.sendername,
						'senderemail' : driverjob.customerjob.senderemail,
						'senderphone' : driverjob.customerjob.senderphone,
						'senderpickupaddress' : driverjob.customerjob.pickupaddress,
						'recipientname' : driverjob.customerjob.recipientname,
						'recipientdropoffaddress' : driverjob.customerjob.dropoffaddress,
						'customerjobid' : driverjob.customerjob.id,
						'status' : status,
						'id' : driverjob.id,
						})
				# print(data)
			context['all_driverjobs'] = data

		return context




@method_decorator(checkloginadmin, name='dispatch')
class AdminNotifications(TemplateView):
	template_name = 'admin_notifications.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(AdminNotifications, self).get_context_data(**kwargs)
		print("AdminNotifications - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				notifications_data = []
				all_notifications = Notifications.objects.filter(foradmin = True).order_by('-id')
				if all_notifications:
					serialno = 0
					for notification in all_notifications:
						serialno += 1
						relatedto = ''
						if notification.notificationtype == 'Parcel Job Created':
							relatedto = 'Customer'
						notifications_data.append({
							'serialno' : serialno,
							'id' : notification.id,
							'notificationtype' : notification.notificationtype,
							'relatedto' : relatedto,
							'notificationtext' : notification.notificationtext,
							'status' : notification.status,
							'date' : notification.date,
							'deleted' : notification.deleted,
							})
					paginator = Paginator(notifications_data, 15)
					page = int(self.request.GET.get('page',1))
					print('page = ', page)
					try:
						notifications_data = paginator.page(page)
						print(len(notifications_data))
						print("try")
					except PageNotAnInteger:
						notifications_data = paginator.page(paginator.num_pages)
						print("except1")
					except EmptyPage:
						notifications_data = paginator.page(paginator.num_pages)
						print("except2")

					context['all_notifications'] = notifications_data
		Notifications.objects.filter(foradmin = True).update(status = 'read')	
		return context	


@method_decorator(checkloginadmin, name='dispatch')
class AdminChatTest(TemplateView):
	template_name = 'admin_chat_test.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(AdminChatTest, self).get_context_data(**kwargs)
		driver_obj = DriverModel.objects.all()
		driver_data = []
		for driver in driver_obj:
			if driver.image:
				image = str(str(settings.WEB_BASE_URL) + driver.image.name)#.replace('original','50*50')
			else:
				image = ''
			chat_obj = Chat.objects.filter(driver = driver).last()
			if chat_obj:
				recentmessage = chat_obj.message
			else:
				recentmessage = 'No message yet'

			driver_data.append({
				'id' : driver.id,
				'name' : driver.name,
				'image' : image,
				'recentmessage' : recentmessage,
				})
		context['driver_obj'] = driver_data
		
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			print('0')
			if user_obj:
				print('1')
				admin_obj = Admin.objects.filter(user = user_obj).first()
				if admin_obj:
					context['admin_id'] = admin_obj.id
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminChat(TemplateView):
	template_name = 'admin_chat.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(AdminChat, self).get_context_data(**kwargs)
		driver_obj = DriverModel.objects.all()
		context['driver_obj']=driver_obj
		# print(driver_obj)

		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			print('0')
			if user_obj:
				print('1')
				admin_obj = Admin.objects.filter(user = user_obj).first()
				if admin_obj:
					context['admin_id'] = admin_obj.id
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminDriverChat(APIView):

	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('Chat  - in post ')
		# print('data is  : ',request.POST)
		try:
			sender = request.POST.get('sender')
			driver_id = request.POST.get('driver_id')
			admin_id = request.POST.get('admin_id')
			message = request.POST.get('message')
			messageexist = request.POST.get('messageexist')
			attachmentexist = request.POST.get('attachmentexist')
			if messageexist == 'yes':
				message = request.POST.get('message')
			if attachmentexist == 'yes':
				attachment = request.FILES['file']
				if attachment:
					print('attachment exists')
				else:
					print('no attachment')
			# if driver_id == '':
			# 	print('driver_id does not exist')
			# if admin_id == '':
			# 	print('admin_id does not exist')
			# if message == '':
			# 	print('message does not exist')
			# if sender == '':
			# 	print('sender does not exist')
			if driver_id and admin_id  and sender:
				if messageexist == 'yes':
					chat_obj = Chat.objects.create(driver_id=driver_id,admin_id=admin_id,message=message,sender=sender)
					if chat_obj:
						print('message saved in database')
				if attachmentexist == 'yes':
					st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(8)])
					print(st)
					fs = FileSystemStorage()
					filename = fs.save(attachment.name, attachment)
					filename = fs.url(filename)
					filename = '/media/' + filename 
					print(filename)
					chat_obj = Chat.objects.create(driver_id=driver_id,admin_id=admin_id,files=filename,sender=sender)
					if chat_obj:
						print('attachment saved in database')		
			if attachmentexist == 'yes':
				attachment = str(settings.WEB_BASE_URL) + filename
			else:
				attachment = ''
			if messageexist == 'no':
				message = ''
			# try:
			# 	import websocket
			# 	import time
			# 	try:
			# 		import thread
			# 	except ImportError:
			# 		import _thread as thread

			# 	ws = websocket.WebSocket()
			# 	ws.connect("ws://kwickdelivery.co.uk:9090/api/driver/" + str(driver_id) + "/getchats/")
			# 	def on_message(ws, message):
			# 		print(message)

			# 	def on_error(ws, error):
			# 		print(error)

			# 	def on_close(ws):
			# 		print("### closed ###")

			# 	def on_open(ws):
			# 		def run(*args):
			# 			for i in range(3):
			# 				time.sleep(1)
			# 				ws.send("Hello %d" % i)
			# 			time.sleep(1)
			# 			ws.close()
			# 			print("thread terminating...")
			# 		thread.start_new_thread(run, ())
			# 	ws.send("update client")
			# except Exception as e:
			# 	print(e)	
			return JsonResponse({'status_code': 200, 'status_message': 'notification read', 'messageexist' : messageexist, 'message' :message, 'attachmentexist' : attachmentexist, 'attachment' : attachment, 'time' : chat_obj.created_at.strftime("%d/%m/%Y %I:%M %p") })
			# return JsonResponse({'code': 400, 'message': 'Bad Request',})
		except Exception as e:
			print(e)
			return JsonResponse({'code': 0, 'message': str(e),})
	

@method_decorator(checkloginadmin, name='dispatch')
class ChatRetrieve(APIView):

	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print(' Retrieve            eChat  - in post ')
		print('data is  : ',request.POST)
		try:
			driver_id = int(request.POST.get('driver_id'))
			admin_id = int(request.POST.get('admin_id'))
			
			all_chats=Chat.objects.filter(driver_id=driver_id,admin_id=(admin_id))
			final_list=[]
			for i in all_chats:
				dic={}
				if i.files:
					attachment = str(settings.WEB_BASE_URL) + i.files.name
				else:
					attachment = ''
				sender=i.sender
				message=i.message
# 				Time format (hh:mm am/pm)      -------       .strftime("%I:%M %p"),
# Date format (dd/mm/yyyy)      -------       .strftime("%d/%m/%Y"),
				time=i.created_at.strftime("%d/%m/%Y %I:%M %p")
				dic['sender']=sender
				dic['message']=message
				dic['attachment']=attachment
				dic['time']=time
				final_list.append(dic)
			return JsonResponse({'code': 200, 'lst':final_list})
		except Exception as e:
			print(e)
			return JsonResponse({'code': 0, 'message': str(e),})
	







class ReadNotification(APIView):
	# permission_classes = (IsAuthenticated,)

	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('ReadNotification API - in post ')
		print('data is  : ',request.POST)
		try:
			notificationid_val = request.POST.get('notificationid')
			if not notificationid_val:
				return JsonResponse({'code': 0, 'message': 'notificationid is required',})
			notificationid_val = int(notificationid_val)
			notification_obj = Notifications.objects.filter(id = notificationid_val).update(status='read')
			return JsonResponse({'code': 200, 'message': 'notification read',})
		except Exception as e:
			return JsonResponse({'code': 0, 'message': str(e),})

class DeleteNotification(APIView):
	# permission_classes = (AllowAny,)
	def post(self, request, *args, **kwargs):
		print('\n\n')
		print('DeleteNotification API - in post')
		print('data is  : ',request.POST)
		
		notificationid_val = request.POST.get('notificationid')
		print('notificationid_val = ',notificationid_val)
		if not notificationid_val:
			return JsonResponse({'code': 0, 'message': 'notification id is required',})
		try:
			Notifications.objects.filter(id = notificationid_val).update(deleted = True)
			return JsonResponse({'code': 200, 'message': 'notification deleted',})
		except Exception as e:
			return JsonResponse({'code': 0, 'message': str(e),})



# @method_decorator(csrf_exempt, name='dispatch')
class SavePusherDetail(APIView):
	
	def post(self, request, *args, **kwargs):
		print("SavePusherDetail-in post ")
		try:
			pass
			print('1')
			json_data = request.data
			# keys = json_data['keys']
			print('2')
			auth= 'O8yKafdGPtujC6a5K0L_Mw'
			print('3')
			p256dh = 'BHJXGA2u6Sx5uHJAk1LPjmsiQdZQJR6-Ru7s8HuNHpECwKHw9mwKItYRerCUhvY9uojJ26KUghe5SiXEYLe19VQ'
			endpoint = 'https://fcm.googleapis.com/fcm/send/cUqSQVM5MvU:APA91bGbvMALH4BO6OJoNqUui-G7vsmIunRkGUvaj0pkE_kM19v0oooDIRzQAqw8vCiSGdx1sdfjjV_D3i8NHHBHPhBZh3hyXLvIhAMHfctfN21SbtfiAjLTSOwb1vK9OZ8zH8dwmzyq'
			pusher_obj = Pushers.objects.filter(auth_key=auth)
			if pusher_obj:
				pass
			else:
				Pushers.objects.create(endpoint=endpoint,auth_key=auth,p256dh_key=p256dh)
		
		except Exception as e:
			print('2')
			print(e)
		return HttpResponse('1')

	def get(self,request):
		if self.request.session.has_key('email'):
			emailid=self.request.session['email']
		emailid='varis_raheja@esferasoft.com'
		main_user_obj=MainUser.objects.filter(email=emailid)
		if main_user_obj:
			pusher_obj = Pushers.objects.filter(user=main_user_obj[0])
			
			data_list = ["This Is Just For Testing 1","This Is Just For Testing2","This Is Just For Testing 3","This Is Just For Testing 4","This Is Just For Testing 5"]
			print(pusher_obj)
			print(pusher_obj[0])
			if pusher_obj:		
				try:
					webpush(
						subscription_info={
						"endpoint":pusher_obj[0].endpoint,
						"keys":{
						"p256dh":pusher_obj[0].p256dh_key,
						"auth":pusher_obj[0].auth_key
						}},
						data=random.choice(data_list),
						vapid_private_key="f5YsZV4K49BiMvOMVh1obJpk4oNXIw2oVXCbfbjsnm0",
						vapid_claims={"sub":"mailto:varisraheja@gmail.com"})

				except WebPushException as ex:
					print(ex)
		
		return HttpResponse('gettt')




def handler404(request, *args, **argv):
	try:
		response= render(request, '404.html')
	except Exception as r:
		print(r)
	response.status_code = 404
	return response

def handler500(request):
	try:
		response = render(request,'500.html')
	except Exception as r:
		print(r)
	response.status_code = 500
	return response


def changetimeslotstatus(request, *args, **kwargs):
	'''This function is being used to edit the parcel type details by Admin'''
	print('Admin - in changetimeslotstatus function')
	try:	
		print(request.POST)
		slot_id = request.POST.get('slot_id')
		new_status = request.POST.get('new_status')
		timeslots_obj = TimeSlots.objects.filter(id = slot_id).first()
		if timeslots_obj:
			if new_status == 'enable':
				timeslots_obj.active = True
			elif new_status == 'disable':
				timeslots_obj.active = False
			timeslots_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'success'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})


def changedisablestatus(request, *args, **kwargs):
	'''This function is being used to edit the parcel type details by Admin'''
	print('Admin - in changedisablestatus function')
	try:	
		print(request.POST)
		userrole = request.POST.get('userrole')
		id_val = request.POST.get('id')
		disable = request.POST.get('disable')
		
		if userrole == 'customer':
			customer_obj = Customer.objects.filter(id = id_val).first()
			if customer_obj:

				if disable == 'true':
					# print('true')
					customer_obj.isdisabled = True
				elif disable == 'false':
					# print('false')
					customer_obj.isdisabled = False
				customer_obj.save()
				return HttpResponse('1')	
		elif userrole == 'driver':
			driver_obj = DriverModel.objects.filter(id = id_val).first()
			if driver_obj:
				driver_obj.isdisable = disable
				driver_obj.save()
				return HttpResponse('1')	
			# return JsonResponse(json.dumps(parceltype_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def edit_parceltype(request, *args, **kwargs):
	'''This function is being used to edit the parcel type details by Admin'''
	print('Admin - in edit_parceltype function')
	try:	
		parceltype_id = request.POST.get('parceltype_id')
		
		parceltype_obj = ParcelType.objects.filter(id = parceltype_id).first()
		if parceltype_obj:
			parceltype_data = []
			parceltype_data.append({
					'parceltype' : parceltype_obj.parceltype,
					'id' : parceltype_obj.id,
				})
			return JsonResponse(json.dumps(parceltype_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def add_parceltype(request, *args, **kwargs):
	'''This function is being used to add the parcel type details by Admin'''
	print('Admin - in add_parceltype function')
	try:
		parceltype = request.POST.get('parceltype')
		if not parceltype:
			return JsonResponse({'status_code' : 0, 'status_message' : 'ParcelType is required.'})
		parceltype_obj = ParcelType.objects.filter(parceltype = parceltype).first()
		if parceltype_obj:
			return JsonResponse({'status_code': 0, 'status_message': 'This record already exists.'})
		else:
			parceltype_obj = ParcelType.objects.create(parceltype = parceltype)
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def update_parceltype(request, *args, **kwargs):
	'''This function is being used to update the parcel type details by Admin'''
	print('Admin - in update_parceltype function')
	try:	
		parceltype_id = request.POST.get('parceltype_id')
		if not parceltype_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'parcelType Id is required.'})
		parceltype = request.POST.get('parceltype')
		if not parceltype:
			return JsonResponse({'status_code' : 0, 'status_message' : 'ParcelType is required.'})
		parceltype_obj = ParcelType.objects.filter(id = parceltype_id).first()
		if parceltype_obj:
			parceltype_obj.parceltype = parceltype
			parceltype_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record updated successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'ParcelType record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def delete_parceltype(request, *args, **kwargs):
	'''This function is being used to delete the parcel type details by Admin'''
	print('Admin - in delete_parceltype function')
	try:	
		parceltype_id = request.POST.get('parceltype_id')
		if not parceltype_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Parceltype Id is required.'})
		parceltype_obj = ParcelType.objects.filter(id = parceltype_id).delete()
		
		return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})




@method_decorator(checkloginadmin, name='dispatch')
class AllParcelTypes(TemplateView):
	template_name = 'admin_showallparceltypes.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all parcel types screen to Admin user'''
		context = super(AllParcelTypes, self).get_context_data(**kwargs)
		print("AllparcelTypes-in get ")
		all_parceltypes = ParcelType.objects.filter(isdeleted = False)
		data = []
		if all_parceltypes:
			serialno = 0
			for parceltype in all_parceltypes:
				serialno +=1
				data.append({
					'serialno' : serialno,
					'parceltype' : parceltype.parceltype,
					'id' : parceltype.id,
					'created_at' : parceltype.created_at,
					})
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_parceltypes = paginator.page(page)
			print("truy")
		except PageNotAnInteger:
			all_parceltypes = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_parceltypes = paginator.page(paginator.num_pages)
			print("except2")

		context['all_parceltypes'] = all_parceltypes
		return context


@method_decorator(checkloginadmin, name='dispatch')
class Support(TemplateView):
	template_name = 'admin_support.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all parcel types screen to Admin user'''
		context = super(Support, self).get_context_data(**kwargs)
		print("Support-in get ")
		supportdetail_obj = SupportDetail.objects.filter(isdeleted = False)
		data = []
		if supportdetail_obj:
			for detail in supportdetail_obj:
				data.append({
					'phone' : detail.phone,
					'id' : detail.id,
					})
		context['supportdetails'] = data
		return context

def prorityandChecking(prority):
	checkin=DriverJob.objects.filter(priorityBaseIDJobs=prority)
	if checkin:
		prority=prority+1
		return(prorityandChecking(prority))
	else:
		return prority

def assign_driver_ExtraTestBefore(request, *args, **kwargs):
	print('Admin - in assigndriver function')
	try:
		print(request.POST)
		# sys.exit()
		driver_id = request.POST.get('driverid')
		customerjob_id = request.POST.get('customerjobid')

		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		if driver_obj.license_front_documentStatus==2 and driver_obj.license_back_documentStatus==2 and driver_obj.id_front_documentStatus==2 and driver_obj.id_back_documentStatus==2 and driver_obj.crb_dbs_documentStatus==2:
			drVehical=DriverVehicle.objects.filter(driver=driver_obj).first()
			if drVehical:
				if drVehical.motor_insurance_status and drVehical.goods_in_transit_cover_status and  drVehical.public_liability_insurance_status and drVehical.vehicle_approve_status:
					pass
				else:
					return JsonResponse({'status_code' : 777, 'status_message' : 'Bad request.'})
		else:
			return JsonResponse({'status_code' : 777, 'status_message' : 'Bad request.'})
		customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = customerjob_id)
		lastDriverJob=DriverJob.objects.last()
		lastProrityIdofJob=(lastDriverJob.priorityBaseIDJobs)+1
		lastProrityIdofJob=prorityandChecking(lastProrityIdofJob)
		startSlot=24
		lastSlot=1
		print("here one 1")
		if driver_obj and customerjob_obj_all:
			for custom in customerjob_obj_all:
				print(custom.pickuptimeslotDate)
				print(custom.pickuptimeslot)
				stringFirst=custom.pickuptimeslot
				one=stringFirst.split('-')[0]
				two=stringFirst.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringFirst=one+" "+two
				print(one)
				print(two)
				print(stringFirst)
				print("here one 1.0")
				pickupSlotID=int(stringFirst[:2])
				if pickupSlotID<startSlot:
					startSlot=pickupSlotID
				responseOf=compareSlotTimes(pickupSlotID,driver_id)

				# # driver_obj2 = DriverModel.objects.filter(id = driver_id).first()
				# driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				# idofslottables=0
				# slotsFind=False
				# print("here one 2")
				# parcelpickupdate=custom.pickuptimeslotDate
				# for d in driverslotsobj:
				# 	if d.dateOfSlots==parcelpickupdate:
				# 		slotsFind=True
				# 		idofslottables=d.id
				# if slotsFind==False:
				# 	newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					
				# 	if newdateSlots:
				# 		print("here one 3")
				# 		createDriverSlotsnew(newdateSlots.id)
				# 		print("here one 3.1")
				# 		responseOf=compareSlotTimesnew(deliverySlotID,newdateSlots.id)
				# 		print("here one 3.2")
				# 		idofslottables=newdateSlots.id
				# 		print("here one 3.3")
				# else:
				# 	responseOf=compareSlotTimesnew(deliverySlotID,idofslottables)
				if responseOf =='pass':
					pass
				else:
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
					print("unavailable Delivery")
				print("here one 4")	
				print("Pickupslotid",pickupSlotID)
				print(custom.dropofftimeslot)
				stringSecond=custom.dropofftimeslot
				one=stringSecond.split('-')[0]
				two=stringSecond.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringSecond=one+" "+two
				print(one)
				print(two)
				print(stringSecond)
				print("here one 5")
				deliverySlotID=int(stringSecond[:2])
				if deliverySlotID>lastSlot:
					lastSlot=deliverySlotID

				responseOf=compareSlotTimes(deliverySlotID,driver_id)
				# driver_obj2 = DriverModel.objects.filter(id = driver_id).first()
				driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				idofslottables=0
				slotsFind=False
				# parcelpickupdate=custom.pickuptimeslotDate
				# print("here one 6")
				# for d in driverslotsobj:
				# 	if d.dateOfSlots==parcelpickupdate:
				# 		slotsFind=True
				# 		idofslottables=d.id
				# if slotsFind==False:
				# 	newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					

				# 	if newdateSlots:
				# 		createDriverSlotsnew(newdateSlots.id)

				# 		responseOf=compareSlotTimesnew(deliverySlotID,newdateSlots.id)
				# 		idofslottables=newdateSlots.id
				# else:
				# 	responseOf=compareSlotTimesnew(deliverySlotID,idofslottables)
				print("here one 8")
				print("deliverySlotID",deliverySlotID)
				if responseOf =='pass':
					pass
				else:
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
					print("unavailable Delivery")

			makeslotUnavailablenew(startSlot,lastSlot+1,idofslottables)
			print("here one 9")
			# slotsFind=False
			# for d in driverslotsobj:
			# 	if dateOfSlots==parcelpickupdate:
			# 		slotsFind=True
			# 		makeslotUnavailablenew(startSlot,lastSlot+1,slotid)
			# if slotsFind==False:
			# 	newdateSlots=DriverAllSlots.objects.create(driver=driver_obj2,dateOfSlots=parcelpickupdate)
			# 	if newdateSlots:
			# 		makeslotUnavailablenew(startSlot,lastSlot+1,slotid)
			for customerjob_obj in customerjob_obj_all:
				
				# print(convert24(customerjob_obj.pickuptimeslot))
				# print(convert24(customerjob_obj.dropofftimeslot))
				
				idForStoreOarcel=customerjob_obj.sameIdForParcelsDetails
				driverjob_obj = DriverJob.objects.create(driver = driver_obj, customerjob = customerjob_obj,sameIdForParcels=idForStoreOarcel,priorityBaseIDJobs=lastProrityIdofJob)
				if driverjob_obj:
					try:
						Notifications.objects.create(user = customerjob_obj.customer.user, customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Driver Assigned', notificationtext = 'Driver has been assigned for your parcel request.', status = 'unread')
					except Exception as e:
						print(e)
					try:
						sendfcmnotification(customerjob_obj.customer.fcmtoken, 'customer', 'driverassigned', 'KwickDelivery', 'Driver has been assigned for your parcel request')
					except Exception as e:
						print(e)
					
					try:
						Notifications.objects.create(user_id = driver_obj.user.id, customerjobid = customerjob_obj.id, driverjobid = driver_obj.id, fordriver = True, notificationtype = 'Parcel Pickup Request', notificationtext = 'You have one pickup request.', status = 'unread')
					except Exception as e:
						print(e)
					try:
						sendfcmnotification(driver_obj.fcmtoken, 'driver', 'statuschange', 'KwickDelivery', 'You have one pickup request')
					except Exception as e:
						print(e)
					customerjob_obj.status = 1
					customerjob_obj.save()
				else:
					return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
			return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})

def assign_driver_ExtraTest(request, *args, **kwargs):
	print('Admin - in assigndriver function')
	try:
		print(request.POST)
		# sys.exit()
		driver_id = request.POST.get('driverid')
		customerjob_id = request.POST.get('customerjobid')

		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		if driver_obj.license_front_documentStatus==2 and driver_obj.license_back_documentStatus==2 and driver_obj.id_front_documentStatus==2 and driver_obj.id_back_documentStatus==2 and driver_obj.crb_dbs_documentStatus==2:
			drVehical=DriverVehicle.objects.filter(driver=driver_obj).first()
			if drVehical:
				if drVehical.motor_insurance_status and drVehical.goods_in_transit_cover_status and  drVehical.public_liability_insurance_status:
					pass
				else:
					return JsonResponse({'status_code' : 777, 'status_message' : 'Bad request.'})
		else:
			return JsonResponse({'status_code' : 777, 'status_message' : 'Bad request.'})
		customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = customerjob_id)
		lastDriverJob=DriverJob.objects.last()
		lastProrityIdofJob=(lastDriverJob.priorityBaseIDJobs)+1
		lastProrityIdofJob=prorityandChecking(lastProrityIdofJob)
		startSlot=24
		lastSlot=1
		idofslottables=0
		print("here one 1")
		if driver_obj and customerjob_obj_all:
			for custom in customerjob_obj_all:
				print(custom.pickuptimeslotDate)
				print(custom.pickuptimeslot)
				stringFirst=custom.pickuptimeslot
				one=stringFirst.split('-')[0]
				two=stringFirst.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringFirst=one+" "+two
				print(one)
				print(two)
				print(stringFirst)
				print("here one 1.0")
				pickupSlotID=int(stringFirst[:2])
				if pickupSlotID<startSlot:
					startSlot=pickupSlotID
				# responseOf=compareSlotTimes(pickupSlotID,driver_id)

				# driver_obj2 = DriverModel.objects.filter(id = driver_id).first()
				driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				
				slotsFind=False
				print("here one 2")
				parcelpickupdate=custom.pickuptimeslotDate
				for d in driverslotsobj:
					if d.dateOfSlots==parcelpickupdate:
						slotsFind=True
						idofslottables=d.id
				if slotsFind==False:
					newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					print(newdateSlots.id)
					if newdateSlots:
						print("here one 3")
						makeallsloteenablebydefault(newdateSlots.id)
						print("here one 3.1")
						responseOf=compareSlotTimesnew(pickupSlotID,newdateSlots.id)
						print("here one 3.2")
						idofslottables=newdateSlots.id
						print("here one 3.3")
					else:
						print("We are in else not working")
				else:
					responseOf=compareSlotTimesnew(pickupSlotID,idofslottables)
				if responseOf =='pass':
					pass
				else:
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
					print("unavailable Delivery")
				print("here one 4")	
				print("Pickupslotid",pickupSlotID)
				print(custom.dropofftimeslot)
				stringSecond=custom.dropofftimeslot
				one=stringSecond.split('-')[0]
				two=stringSecond.split('-')[1]
				one=one[:-1]
				two=two[1:]
				one=convert24(one)
				two=convert24(two)
				stringSecond=one+" "+two
				print(one)
				print(two)
				print(stringSecond)
				print("here one 5")
				deliverySlotID=int(stringSecond[:2])
				if deliverySlotID>lastSlot:
					lastSlot=deliverySlotID

				# responseOf=compareSlotTimes(deliverySlotID,driver_id)
				# driver_obj2 = DriverModel.objects.filter(id = driver_id).first()
				driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj)
				idofslottables=0
				slotsFind=False
				parcelpickupdate=custom.pickuptimeslotDate
				print("here one 6")
				for d in driverslotsobj:
					if d.dateOfSlots==parcelpickupdate:
						slotsFind=True
						idofslottables=d.id
				if slotsFind==False:
					newdateSlots=DriverAllSlots.objects.create(driver=driver_obj,dateOfSlots=parcelpickupdate)
					print(newdateSlots.id)

					if newdateSlots:
						makeallsloteenablebydefault(newdateSlots.id)

						responseOf=compareSlotTimesnew(deliverySlotID,newdateSlots.id)
						idofslottables=newdateSlots.id
				else:
					responseOf=compareSlotTimesnew(deliverySlotID,idofslottables)
				print("here one 8")
				print("deliverySlotID",deliverySlotID)
				if responseOf =='pass':
					pass
				else:
					return JsonResponse({'status_code' : 900, 'status_message' : 'Bad request.'})
					print("unavailable Delivery")
			print("making slot un aviable")
			makeslotUnavailablenew(startSlot,lastSlot+1,idofslottables)
			print("here one 9")
			# slotsFind=False
			# for d in driverslotsobj:
			# 	if dateOfSlots==parcelpickupdate:
			# 		slotsFind=True
			# 		makeslotUnavailablenew(startSlot,lastSlot+1,slotid)
			# if slotsFind==False:
			# 	newdateSlots=DriverAllSlots.objects.create(driver=driver_obj2,dateOfSlots=parcelpickupdate)
			# 	if newdateSlots:
			# 		makeslotUnavailablenew(startSlot,lastSlot+1,slotid)
			for customerjob_obj in customerjob_obj_all:
				
				# print(convert24(customerjob_obj.pickuptimeslot))
				# print(convert24(customerjob_obj.dropofftimeslot))
				
				idForStoreOarcel=customerjob_obj.sameIdForParcelsDetails
				driverjob_obj = DriverJob.objects.create(driver = driver_obj, customerjob = customerjob_obj,sameIdForParcels=idForStoreOarcel,priorityBaseIDJobs=lastProrityIdofJob)
				if driverjob_obj:
					try:
						Notifications.objects.create(user = customerjob_obj.customer.user, customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Driver Assigned', notificationtext = 'Driver has been assigned for your parcel request.', status = 'unread')
					except Exception as e:
						print(e)
					try:
						sendfcmnotification(customerjob_obj.customer.fcmtoken, 'customer', 'driverassigned', 'KwickDelivery', 'Driver has been assigned for your parcel request')
					except Exception as e:
						print(e)
					
					try:
						Notifications.objects.create(user_id = driver_obj.user.id, customerjobid = customerjob_obj.id, driverjobid = driver_obj.id, fordriver = True, notificationtype = 'Parcel Pickup Request', notificationtext = 'You have one pickup request.', status = 'unread')
					except Exception as e:
						print(e)
					try:
						sendfcmnotification(driver_obj.fcmtoken, 'driver', 'statuschange', 'KwickDelivery', 'You have one pickup request')
					except Exception as e:
						print(e)
					customerjob_obj.status = 1
					customerjob_obj.save()
				else:
					return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
			return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})		


def unassigndriver(request, *args, **kwargs):
	print('Admin - in unassigndriver function')
	try:
		print(request.POST)
		# sys.exit()
		idofsameparcel = request.POST.get('idofsameparcel')
		lastDriverJob=DriverJob.objects.filter(sameIdForParcels=idofsameparcel)
		if lastDriverJob:
			slotStatusonJobCompletenew(idofsameparcel)
			for dr in lastDriverJob:
				dr.delete()
			
			return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is unassigned for this job.'})
		else:
			return JsonResponse({'status_code' : 500, 'status_message' : 'some error'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})


def assign_driver(request, *args, **kwargs):
	print('Admin - in assigndriver function')
	try:
		print(request.POST)
		# sys.exit()
		driver_id = request.POST.get('driverid')
		customerjob_id = request.POST.get('customerjobid')

		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		customerjob_obj = CustomerJob.objects.filter(id = customerjob_id).first()
		if driver_obj and customerjob_obj:
			driverjob_obj = DriverJob.objects.create(driver = driver_obj, customerjob = customerjob_obj)
			if driverjob_obj:
				try:
					Notifications.objects.create(user = customerjob_obj.customer.user, customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Driver Assigned', notificationtext = 'Driver has been assigned for your parcel request.', status = 'unread')
				except Exception as e:
					print(e)
				try:
					sendfcmnotification(customerjob_obj.customer.fcmtoken, 'customer', 'driverassigned', 'KwickDelivery', 'Driver has been assigned for your parcel request')
				except Exception as e:
					print(e)
				
				try:
					Notifications.objects.create(user_id = driver_obj.user.id, customerjobid = customerjob_obj.id, driverjobid = driver_obj.id, fordriver = True, notificationtype = 'Parcel Pickup Request', notificationtext = 'You have one pickup request.', status = 'unread')
				except Exception as e:
					print(e)
				try:
					sendfcmnotification(driver_obj.fcmtoken, 'driver', 'statuschange', 'KwickDelivery', 'You have one pickup request')
				except Exception as e:
					print(e)
				customerjob_obj.status = 1
				customerjob_obj.save()
				return JsonResponse({'status_code' : 200, 'status_message' : 'Driver is assigned for this job.'})
			else:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Bad request.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error.'})

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsCompletedExtraTest(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsCompletedExtraTest, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsCompleted get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
					if customerjob.sameIdForParcelsDetails !=0:
						unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
					# driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
					completed = False
					if customerjob.sameIdForParcelsDetails !=0:
						driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
						driverexist = False
						if driverjob_obj:
							driverexist = True
							completed = True
							for d in driverjob_obj:
								if d.jobcompleted==False:
									completed = False
					if customerjob.sameIdForParcelsDetails == 0:
						driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						driverexist = False
						if driverjob_obj:
							driverexist = True
							if driverjob_obj.jobcompleted:
								completed = True
					# if driverjob_obj:
					# 	if driverjob_obj.jobcompleted:
					# 		completed = True
					Show=True
					if customerjob.sameIdForParcelsDetails == 0:
						Show=False
					if completed:
						if customerjob.deliveryduration == 0:
							deliveryduration = 'Same Day Delivery'
						elif customerjob.deliveryduration == 1:
							deliveryduration = 'Two Day Delivery'
						elif customerjob.deliveryduration == 2:
							deliveryduration = 'Same Day Delivery'
						serialno += 1
						try:
							if customerjob.order.ordertype == 1:
								ordertype = 'Single-Drop'
							elif customerjob.order.ordertype == 2:
								ordertype = 'Multi-Drop'
							else:
								ordertype = ''
						except Exception as e:
							print(e)
						all_customerjobs_data.append({
							'serialno' : serialno,
							'sendername' : customerjob.sendername,
							'senderemail' : customerjob.senderemail,
							'senderphone' : customerjob.senderphone,
							'senderpickupaddress' : customerjob.pickupaddress,
							'recipientname' : customerjob.recipientname,
							'recipientdropoffaddress' : customerjob.dropoffaddress,
							'ordertype':ordertype,
							# 'sendername' : customerjob.sendername,
							# 'senderphone' : customerjob.senderphone,
							# 'deliveryduration' : deliveryduration,
							# 'vehicletype' : customerjob.vehicletype,
							# 'id' : customerjob.id,
							'showId':Show,
							'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
							'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
							'createdDate':customerjob.created_at,
							})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		context['filterTitle'] = 'completed'
		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Completed Jobs'
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsFailed(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsFailed, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsFailed get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
					if customerjob.sameIdForParcelsDetails !=0:
						unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
					# driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
					failed = False
					driverID=0
					if customerjob.sameIdForParcelsDetails !=0:
						driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
						driverexist = False
						if driverjob_obj:
							driverexist = True
							for d in driverjob_obj:
								if d.deliveryfailed==True:
									failed = True
									driverID=d.sameIdForParcels
					if customerjob.sameIdForParcelsDetails == 0:
						driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						driverexist = False
						if driverjob_obj:
							driverexist = True
							if driverjob_obj.jobcompleted:
								completed = True
					# if driverjob_obj:
					# 	if driverjob_obj.jobcompleted:
					# 		completed = True
					Show=True
					forFun=True
					if customerjob.sameIdForParcelsDetails == 0:
						Show=False
					if failed==True:
						if customerjob.deliveryduration == 0:
							deliveryduration = 'Same Day Delivery'
						elif customerjob.deliveryduration == 1:
							deliveryduration = 'Two Day Delivery'
						elif customerjob.deliveryduration == 2:
							deliveryduration = 'Same Day Delivery'
						if customerjob.order.ordertype == 1:
							ordertype = 'Single-Drop'
						elif customerjob.order.ordertype == 2:
							ordertype = 'Multi-Drop'
						else:
							ordertype = ''
						serialno += 1
						all_customerjobs_data.append({
							'serialno' : serialno,
							'sendername' : customerjob.sendername,
							'senderemail' : customerjob.senderemail,
							'senderphone' : customerjob.senderphone,
							'senderpickupaddress' : customerjob.pickupaddress,
							'recipientname' : customerjob.recipientname,
							'recipientdropoffaddress' : customerjob.dropoffaddress,
							'senderlatitude' : customerjob.senderlatitude,
							'senderlongitude' : customerjob.senderlongitude,
							'recipientlatitude' : customerjob.recipientlatitude,
							'recipientlongitude' : customerjob.recipientlongitude,
							'driverexist' : driverexist,
							'driverID':driverID,
							'ordertype':ordertype,
							# 'sendername' : customerjob.sendername,
							# 'senderphone' : customerjob.senderphone,
							# 'deliveryduration' : deliveryduration,
							# 'vehicletype' : customerjob.vehicletype,
							# 'id' : customerjob.id,
							'showId':Show,
							'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
							'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
							'createdDate':customerjob.created_at,
							})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		# print(drivers_data)
		context['all_drivers'] = drivers_data
		context['filterTitle'] = 'Failed Jobs'
		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Failed Jobs'
		return context		
		
@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsCompleted(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsCompleted, self).get_context_data(**kwargs)
		print("AdminShowAllCustomerJobsCompleted get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			for customerjob in all_customerjobs:
				driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
				completed = False
				if driverjob_obj:
					if driverjob_obj.jobcompleted:
						completed = True
				Show=True
				if customerjob.sameIdForParcelsDetails == 0:
					Show=False
				if completed:
					if customerjob.deliveryduration == 0:
						deliveryduration = 'Same Day Delivery'
					elif customerjob.deliveryduration == 1:
						deliveryduration = 'Two Day Delivery'
					elif customerjob.deliveryduration == 2:
						deliveryduration = 'Same Day Delivery'
					serialno += 1
					all_customerjobs_data.append({
						'serialno' : serialno,
						'sendername' : customerjob.sendername,
						'senderemail' : customerjob.senderemail,
						'senderphone' : customerjob.senderphone,
						'senderpickupaddress' : customerjob.pickupaddress,
						'recipientname' : customerjob.recipientname,
						'recipientdropoffaddress' : customerjob.dropoffaddress,

						# 'sendername' : customerjob.sendername,
						# 'senderphone' : customerjob.senderphone,
						# 'deliveryduration' : deliveryduration,
						# 'vehicletype' : customerjob.vehicletype,
						# 'id' : customerjob.id,
						'showId':Show,
						'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
						'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
						})
		
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			print(len(all_customerjobs_data))
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		context['header_title'] = 'Completed Jobs'
		return context



#Create and Edit By manpreet 6/11/2020
@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobsExtraTest(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobsExtraTest, self).get_context_data(**kwargs)
		print("AdminShowAllCustomers-AdminShowAllCustomerJobs get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			unique_parcel_ids=[]
			for customerjob in all_customerjobs:
				if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
					if customerjob.sameIdForParcelsDetails !=0:
						unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
					completed = False
					if customerjob.sameIdForParcelsDetails !=0:
						driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
						driverexist = False
						driverID=0
						if driverjob_obj:
							driverexist = True
							completed = True

							for d in driverjob_obj:
								if d.jobcompleted==False:
									completed = False
									driverID=d.sameIdForParcels
					if customerjob.sameIdForParcelsDetails == 0:
						driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						driverexist = False
						driverID=0
						if driverjob_obj:
							driverexist = True
							if driverjob_obj.jobcompleted:
								completed = True
					Show=True
					if customerjob.sameIdForParcelsDetails == 0:
						Show=False
					if not completed:
						if customerjob.deliveryduration == 0:
							deliveryduration = 'Same Day Delivery'
						elif customerjob.deliveryduration == 1:
							deliveryduration = 'Two Day Delivery'
						elif customerjob.deliveryduration == 2:
							deliveryduration = 'Same Day Delivery'
						serialno += 1
						try:
							if customerjob.order.ordertype == 1:
								ordertype = 'Single-Drop'
							elif customerjob.order.ordertype == 2:
								ordertype = 'Multi-Drop'
							else:
								ordertype = ''
						except Exception as e:
							print(e)
						all_customerjobs_data.append({
							'serialno' : serialno,
							'sendername' : customerjob.sendername,
							'senderemail' : customerjob.senderemail,
							'senderphone' : customerjob.senderphone,
							'senderpickupaddress' : customerjob.pickupaddress,
							'recipientname' : customerjob.recipientname,
							'recipientdropoffaddress' : customerjob.dropoffaddress,
							'senderlatitude' : customerjob.senderlatitude,
							'senderlongitude' : customerjob.senderlongitude,
							'recipientlatitude' : customerjob.recipientlatitude,
							'recipientlongitude' : customerjob.recipientlongitude,
							'driverexist' : driverexist,
							'driverID':driverID,
							'ordertype':ordertype,
							# 'sendername' : customerjob.sendername,
							# 'senderphone' : customerjob.senderphone,
							# 'deliveryduration' : deliveryduration,
							# 'vehicletype' : customerjob.vehicletype,

							# 'id' : customerjob.id,#Original ID used before my changes
							'showId':Show,
							'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
							'id' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
							'createdDate':customerjob.created_at,
							})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		# print(all_customerjobs_data)
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			# print(all_customerjobs_data)
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		# print(drivers_data)
		context['all_drivers'] = drivers_data
		context['header_title'] = 'Outstanding Jobs'
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomerJobs(TemplateView):
	template_name = 'admin_showallcustomerjobs.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customer jobs screen to Admin user'''
		context = super(AdminShowAllCustomerJobs, self).get_context_data(**kwargs)
		print("AdminShowAllCustomers-AdminShowAllCustomerJobs get ")
		all_customerjobs = CustomerJob.objects.filter(isdeleted = False).order_by('-id')#.prefetch_related('user')
		all_customerjobs_data = []
		if all_customerjobs:
			serialno = 0
			for customerjob in all_customerjobs:
				driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
				completed = False
				driverexist = False
				if driverjob_obj:
					driverexist = True
					if driverjob_obj.jobcompleted:
						completed = True

				if not completed:
					if customerjob.deliveryduration == 0:
						deliveryduration = 'Same Day Delivery'
					elif customerjob.deliveryduration == 1:
						deliveryduration = 'Two Day Delivery'
					elif customerjob.deliveryduration == 2:
						deliveryduration = 'Same Day Delivery'
					serialno += 1
					all_customerjobs_data.append({
						'serialno' : serialno,
						'sendername' : customerjob.sendername,
						'senderemail' : customerjob.senderemail,
						'senderphone' : customerjob.senderphone,
						'senderpickupaddress' : customerjob.pickupaddress,
						'recipientname' : customerjob.recipientname,
						'recipientdropoffaddress' : customerjob.dropoffaddress,
						'senderlatitude' : customerjob.senderlatitude,
						'senderlongitude' : customerjob.senderlongitude,
						'recipientlatitude' : customerjob.recipientlatitude,
						'recipientlongitude' : customerjob.recipientlongitude,
						'driverexist' : driverexist,

						# 'sendername' : customerjob.sendername,
						# 'senderphone' : customerjob.senderphone,
						# 'deliveryduration' : deliveryduration,
						# 'vehicletype' : customerjob.vehicletype,
						'id' : customerjob.id,
						})
		# print(all_customerjobs_data)
		paginator = Paginator(all_customerjobs_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customerjobs_data = paginator.page(page)
			# print(all_customerjobs_data)
			print("truy")
		except PageNotAnInteger:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customerjobs_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customerjobs'] = all_customerjobs_data
		driver_obj = DriverModel.objects.filter(emailverified = True, isdisabled = False, isdeleted = False).order_by('-id')
		drivers_data = []
		if driver_obj:
			for driver in driver_obj:
				latitude, longitude = '', ''
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude

				pendingjobs = DriverJob.objects.filter(driver = driver, jobcompleted = False).count()
				
				drivers_data.append({
					'name': driver.name,
					'email': driver.email,
					'phone': driver.countrycode + '-' + driver.phone,
					'image': driver.image.name,
					'latitude' : latitude,
					'longitude' : longitude,
					'noofparcels' : pendingjobs, 
					'id': driver.id,
					})
		# print(drivers_data)
		context['all_drivers'] = drivers_data
		context['header_title'] = 'Outstanding Jobs'
		return context




def dashboard(request, *args, **kwargs):
	print('Admin - in dashboard function')
	try:
		from django.shortcuts import render
		context = {}
		if request.session.has_key('userrole'):
			context['userrole'] = request.session['userrole']
		if request.session.has_key('email'):
			email_val = request.session['email']
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				context['username'] = user_obj.first_name + ' ' + user_obj.last_name
		totalcustomers = Customer.objects.filter(accountapproved = True, isdeleted = True).count()
		totalcompanies = Company.objects.filter(accountapproved = True, isdeleted = True).count()
		totaldrivers = DriverModel.objects.filter(accountapproved = True, isdeleted = True).count()
		context['totalcustomers'] = totalcustomers
		context['totalcompanies'] = totalcompanies
		context['totaldrivers'] = totaldrivers
		recent_companies = Company.objects.all().order_by('-id')[:5][::-1]
		context['recent_companies'] = recent_companies
		print('\n\n\n')
		if request.session.has_key('userrole'):
			print('0')
			userrole = request.session['userrole']
			if userrole == 'superadmin':
				print('1')
				return HttpResponseRedirect(reverse('superadmin-dashboard'))
				return render(request, 'superadmin_dashboard.html', context)
			elif userrole == 'admin':
				print('2')
				return HttpResponseRedirect(reverse('admin-dashboard'))
				return render(request, 'admin_dashboard.html', context)
			elif userrole == 'customer':
				print('3')
				return HttpResponseRedirect(reverse('customer-dashboard'))
			elif userrole == 'company':
				print('4')
				return HttpResponseRedirect(reverse('company-dashboard'))
			elif userrole == 'driver':
				print('5')
				return HttpResponseRedirect(reverse('driver-dashboard'))
			else:
				print('6')
				return HttpResponseRedirect(reverse('customer-login'))

		else:
			return HttpResponseRedirect(reverse('customer-login'))
			return render(request, 'admin_login.html', context)
	except Exception as e:
		print(e)
		return HttpResponseRedirect(reverse('customer-login'))
		return render(request, 'admin_login.html', context)



def edit_vehicletype(request, *args, **kwargs):
	'''This function is being used to edit the vehicle type details by Admin'''
	print('Admin - in edit_vehicletype function')
	try:	
		vehicletype_id = request.POST.get('vehicletype_id')
		
		vehicletype_obj = VehicleType.objects.filter(id = vehicletype_id).first()
		if vehicletype_obj:
			vehicletype_data = []
			vehicletype_data.append({
					'name' : vehicletype_obj.name,
					'carryinglimitinkg' : vehicletype_obj.carryinglimitinkg,
					'fixeddistance' : vehicletype_obj.fixeddistance,
					'distanceunit' : vehicletype_obj.distanceunit,
					'baserate' : vehicletype_obj.baserate,
					'addittionalrateperunit' : vehicletype_obj.addittionalrateperunit,
					'priceperdrop' : vehicletype_obj.priceperdrop,
					'priceperhour' : vehicletype_obj.priceperhour,
					'currency' : vehicletype_obj.currency,
					'id' : vehicletype_obj.id,
					'height':vehicletype_obj.heightOfVehical,
					'width':vehicletype_obj.widthOfVehical,
					'length':vehicletype_obj.lengthOfVehical,
				})
			return JsonResponse(json.dumps(vehicletype_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def add_vehicletype(request, *args, **kwargs):
	'''This function is being used to add the vehicle type details by Admin'''
	print('Admin - in add_vehicletype function')
	try:
		name = request.POST.get('name')
		carryinglimitinkg = request.POST.get('carryinglimitinkg')
		fixeddistance = request.POST.get('fixeddistance')
		distanceunit = request.POST.get('distanceunit')
		baserate = request.POST.get('baserate')
		addittionalrateperunit = request.POST.get('addittionalrateperunit')
		priceperdrop = request.POST.get('priceperdrop')
		priceperhour = request.POST.get('priceperhour')
		currency = request.POST.get('currency')

		height = request.POST.get('height')
		width = request.POST.get('width')
		length = request.POST.get('length')

		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'VehicleType Name is required.'})
		if not carryinglimitinkg:
			return JsonResponse({'status_code' : 0, 'status_message' : 'carryinglimitinkg is required.'})
		if not fixeddistance:
			return JsonResponse({'status_code' : 0, 'status_message' : 'fixeddistance is required.'})
		if not distanceunit:
			return JsonResponse({'status_code' : 0, 'status_message' : 'distanceunit is required.'})
		if not baserate:
			return JsonResponse({'status_code' : 0, 'status_message' : 'baserate is required.'})
		if not addittionalrateperunit:
			return JsonResponse({'status_code' : 0, 'status_message' : 'addittionalrateperunit is required.'})
		if not priceperdrop:
			return JsonResponse({'status_code' : 0, 'status_message' : 'priceperdrop is required.'})
		if not priceperhour:
			return JsonResponse({'status_code' : 0, 'status_message' : 'priceperhour is required.'})
		if not currency:
			return JsonResponse({'status_code' : 0, 'status_message' : 'currency is required.'})
		if not height:
			return JsonResponse({'status_code' : 0, 'status_message' : 'height is required.'})
		if not width:
			return JsonResponse({'status_code' : 0, 'status_message' : 'width is required.'})
		if not length:
			return JsonResponse({'status_code' : 0, 'status_message' : 'length is required.'})

		vehicletype_obj = VehicleType.objects.filter(name = name, isdeleted = False).first()
		if vehicletype_obj:
			return JsonResponse({'status_code': 0, 'status_message': 'VehicleType exists.'})
		else:
			vehicletype_obj = VehicleType.objects.create(name = name, carryinglimitinkg = carryinglimitinkg, fixeddistance = fixeddistance, distanceunit = distanceunit, baserate = baserate, addittionalrateperunit = addittionalrateperunit, priceperdrop = priceperdrop, priceperhour = priceperhour, currency = currency,heightOfVehical=height,widthOfVehical=width,lengthOfVehical=length)
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def delete_vehicletype(request, *args, **kwargs):
	'''This function is being used to delete the vehicle type details by Admin'''
	print('Admin - in delete_vehicletype function')
	try:	
		vehicletype_id = request.POST.get('vehicletype_id')
		if not vehicletype_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'vehicletype Id is required.'})
		vehicletype_obj = VehicleType.objects.filter(id = vehicletype_id).first()
		if vehicletype_obj:
			vehicletype_obj.isdeleted = True
			vehicletype_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'VehicleType record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})


def update_vehicletype(request, *args, **kwargs):
	'''This function is being used to update the vehicle type details by Admin'''
	print('Admin - in update_vehicletype function')
	try:	
		vehicletype_id = request.POST.get('vehicletype_id')
		if not vehicletype_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'VehicleType Id is required.'})
		name = request.POST.get('name')
		carryinglimitinkg = request.POST.get('carryinglimitinkg')
		fixeddistance = request.POST.get('fixeddistance')
		distanceunit = request.POST.get('distanceunit')
		baserate = request.POST.get('baserate')
		addittionalrateperunit = request.POST.get('addittionalrateperunit')
		priceperdrop = request.POST.get('priceperdrop')
		priceperhour = request.POST.get('priceperhour')
		height = request.POST.get('height')
		width = request.POST.get('width')
		length = request.POST.get('length')

		currency = request.POST.get('currency')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'VehicleType Name is required.'})
		if not carryinglimitinkg:
			return JsonResponse({'status_code' : 0, 'status_message' : 'carryinglimitinkg is required.'})
		if not fixeddistance:
			return JsonResponse({'status_code' : 0, 'status_message' : 'fixeddistance is required.'})
		if not distanceunit:
			return JsonResponse({'status_code' : 0, 'status_message' : 'distanceunit is required.'})
		if not baserate:
			return JsonResponse({'status_code' : 0, 'status_message' : 'baserate is required.'})
		if not addittionalrateperunit:
			return JsonResponse({'status_code' : 0, 'status_message' : 'addittionalrateperunit is required.'})
		if not priceperdrop:
			return JsonResponse({'status_code' : 0, 'status_message' : 'priceperdrop is required.'})
		if not priceperhour:
			return JsonResponse({'status_code' : 0, 'status_message' : 'priceperhour is required.'})
		if not currency:
			return JsonResponse({'status_code' : 0, 'status_message' : 'currency is required.'})

		if not height:
			return JsonResponse({'status_code' : 0, 'status_message' : 'height is required.'})
		if not width:
			return JsonResponse({'status_code' : 0, 'status_message' : 'width is required.'})
		if not length:
			return JsonResponse({'status_code' : 0, 'status_message' : 'length is required.'})
		
		vehicletype_obj = VehicleType.objects.filter(id = vehicletype_id).first()
		if vehicletype_obj:
			vehicletype_obj.name = name
			vehicletype_obj.carryinglimitinkg = carryinglimitinkg
			vehicletype_obj.fixeddistance = fixeddistance
			vehicletype_obj.distanceunit = distanceunit
			vehicletype_obj.baserate = baserate
			vehicletype_obj.addittionalrateperunit = addittionalrateperunit
			vehicletype_obj.priceperdrop = priceperdrop
			vehicletype_obj.priceperhour = priceperhour
			vehicletype_obj.currency = currency


			vehicletype_obj.heightOfVehical = height
			vehicletype_obj.widthOfVehical = width
			vehicletype_obj.lengthOfVehical = length
			vehicletype_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record updated successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'VehicleType record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})


def rejectDocuments(request, *args, **kwargs):
	'''This function is being used to edit the driver details'''
	print('Admin - in edit_driver function')
	try:	
		driver_id = request.POST.get('driver_id')
		license_front = request.POST.get('license_front')
		license_back = request.POST.get('license_back')
		passport_front = request.POST.get('passport_front')
		passport_back = request.POST.get('passport_back')
		crd_dbs = request.POST.get('crd_dbs')
		vehical__GTC = request.POST.get('vehical__GTC')
		vehical_mi = request.POST.get('vehical_mi')
		vehical_PLI= request.POST.get('vehical_PLI')
		print(driver_id)
		print(license_front)
		print(license_back)
		print(passport_front)
		print(vehical__GTC)
		print(vehical_mi)
		print(crd_dbs)
		print(vehical_PLI)
		
		try:
			driver_obj = DriverModel.objects.filter(id = driver_id).first()
		except Exception as e:
			print(e)

		if driver_obj:
			if license_front =='True':
				driver_obj.license_front_documentStatus=3
			if license_back =='True':
				driver_obj.license_back_documentStatus=3
			if passport_front =='True':
				driver_obj.id_front_documentStatus=3
			if passport_back =='True':
				driver_obj.id_back_documentStatus=3
			if crd_dbs =='True':
				driver_obj.crb_dbs_documentStatus=3
			driver_obj.save()

			try:
				driver_vehical = DriverVehicle.objects.filter(driver = driver_obj,active=True).first()
			
			except:
				pass

			if vehical__GTC =='True':
				driver_vehical.goods_in_transit_cover_status=3
			if vehical_mi =='True':
				driver_vehical.motor_insurance_status=3
			if vehical_PLI =='True':
				driver_vehical.public_liability_insurance_status=3
			driver_vehical.save()
			
			# driver_data.append({
			# 		'name' : driver_obj.name,
			# 		'countrycode' : driver_obj.countrycode,
			# 		'phone' : driver_obj.phone,
			# 		'email' : driver_obj.user.email,
			# 		'image' : image,
			# 		'license_front' : license_front,
			# 		'license_back' : license_back,
			# 		'id_front' : id_front,
			# 		'id_back' : id_back,
			# 		'crb_dbs' : crb_dbs,
			# 		'id' : driver_obj.id,
			# 		'vehical_number' : vehical_number,
			# 		'vehical_type' : vehical_type,
			# 		'vehical_image' : vehical_image,
			# 		'vehical_motor_in' : vehical_motor_insurance,
			# 	})
			# print("===========Friver Data -====================00",driver_data)
			return JsonResponse({'status_code':200,'safe':False})
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')


def acceptDocuments(request, *args, **kwargs):
	'''This function is being used to edit the driver details'''
	print('Admin - in edit_driver function')
	try:	
		driver_id = request.POST.get('driver_id')
		license_front = request.POST.get('license_front')
		license_back = request.POST.get('license_back')
		passport_front = request.POST.get('passport_front')
		passport_back = request.POST.get('passport_back')
		crd_dbs = request.POST.get('crd_dbs')
		vehical__GTC = request.POST.get('vehical__GTC')
		vehical_mi = request.POST.get('vehical_mi')
		vehical_PLI= request.POST.get('vehical_PLI')
		print(driver_id)
		print(license_front)
		print(license_back)
		print(passport_front)
		print(vehical__GTC)
		print(vehical_mi)
		print(crd_dbs)
		print(vehical_PLI)
		
		try:
			driver_obj = DriverModel.objects.filter(id = driver_id).first()
		except Exception as e:
			print(e)
		print("acceot 1")
		if driver_obj:
			if license_front =='True':
				driver_obj.license_front_documentStatus=2
			if license_back =='True':
				driver_obj.license_back_documentStatus=2
			print("acceot 2")
			if passport_front =='True':
				driver_obj.id_front_documentStatus=2
			if passport_back =='True':
				driver_obj.id_back_documentStatus=2
			print("acceot 3")
			if crd_dbs =='True':
				driver_obj.crb_dbs_documentStatus=2
			driver_obj.save()

			try:
				driver_vehical = DriverVehicle.objects.filter(driver = driver_obj,active=True).first()
			
			except:
				pass
			print("acceot 4")
			if driver_vehical:
				if vehical__GTC =='True':
					driver_vehical.goods_in_transit_cover_status=2
				if vehical_mi =='True':
					driver_vehical.motor_insurance_status=2
				if vehical_PLI =='True':
					driver_vehical.public_liability_insurance_status=2
				driver_vehical.save()
			print("acceot 5")
			# driver_data.append({
			# 		'name' : driver_obj.name,
			# 		'countrycode' : driver_obj.countrycode,
			# 		'phone' : driver_obj.phone,
			# 		'email' : driver_obj.user.email,
			# 		'image' : image,
			# 		'license_front' : license_front,
			# 		'license_back' : license_back,
			# 		'id_front' : id_front,
			# 		'id_back' : id_back,
			# 		'crb_dbs' : crb_dbs,
			# 		'id' : driver_obj.id,
			# 		'vehical_number' : vehical_number,
			# 		'vehical_type' : vehical_type,
			# 		'vehical_image' : vehical_image,
			# 		'vehical_motor_in' : vehical_motor_insurance,
			# 	})
			# print("===========Friver Data -====================00",driver_data)
			return JsonResponse({'status_code':200,'safe':False})
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')


def edit_driverExtraTest(request, *args, **kwargs):
	'''This function is being used to edit the driver details'''
	print('Admin - in edit_driver function')
	try:	
		driver_id = request.POST.get('driver_id')
		
		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		try:
			driver_vehical = DriverVehicle.objects.filter(driver = driver_obj,active=True).first()
		except:
			pass

		
		is_license_front_pdf=False
		is_license_back_pdf=False
		is_id_front_pdf=False
		is_id_back_pdf=False
		is_crb_dbs_pdf=False
		is_vehicleimage_pdf=False
		is_motor_insurance_pdf=False
		is_GTC_pdf=False
		is_PLI_pdf=False
		motor_insurance_status=''
		vehicleimage_status=''
		GTC_status=''
		PLI_status=''
		if driver_obj:
			driver_data = []
			if driver_obj.image:
				image = driver_obj.image.name
			else:
				image = ''
			
			if driver_obj.license_front:
				if 'pdf' in driver_obj.license_front.name:
					is_license_front_pdf=True
					license_front = str(settings.MEDIA_BASE_URL) + driver_obj.license_front.name

				else:
					is_license_front_pdf=False
					license_front = str(settings.MEDIA_BASE_URL) + driver_obj.license_front.name
			else:
				license_front = ''

			if driver_obj.license_back:
				if 'pdf' in driver_obj.license_back.name:
					is_license_back_pdf=True
					license_back = str(settings.MEDIA_BASE_URL) + driver_obj.license_back.name

				else:
					is_license_back_pdf=False
					license_back = str(settings.MEDIA_BASE_URL) + driver_obj.license_back.name
			else:
				license_back = ''


			if driver_obj.id_front:
				if 'pdf' in driver_obj.id_front.name:
					is_id_front_pdf=True
					id_front = str(settings.MEDIA_BASE_URL) + driver_obj.id_front.name

				else:
					is_id_front_pdf=False
					id_front = str(settings.MEDIA_BASE_URL) + driver_obj.id_front.name
				
			else:
				id_front = ''


			if driver_obj.id_back:
				if 'pdf' in driver_obj.id_back.name:
					is_id_back_pdf=True
					id_back = str(settings.MEDIA_BASE_URL) + driver_obj.id_back.name

				else:
					is_id_back_pdf=False
					id_back = str(settings.MEDIA_BASE_URL) + driver_obj.id_back.name
				
			else:
				id_back = ''


			if driver_obj.crb_dbs:
				if 'pdf' in driver_obj.crb_dbs.name:
					is_crb_dbs_pdf=True
					crb_dbs = str(settings.MEDIA_BASE_URL) + driver_obj.crb_dbs.name

				else:
					is_crb_dbs_pdf=False
					crb_dbs = str(settings.MEDIA_BASE_URL) + driver_obj.crb_dbs.name
				
			else:
				crb_dbs = ''


			if driver_vehical:
				if driver_vehical.vehiclenumber:
					vehical_number=driver_vehical.vehiclenumber
				else:
					vehical_number= ''

				if driver_vehical.vehicletype:
					vehical_type=driver_vehical.vehicletype
				else:
					vehical_type= ''

				
				if driver_vehical.vehicleimage:
					if 'pdf' in driver_vehical.vehicleimage.name:
						is_vehicleimage_pdf=True
						vehical_image= str(settings.MEDIA_BASE_URL) + driver_vehical.vehicleimage.name
					else:
						is_vehicleimage_pdf=False
						vehical_image= str(settings.MEDIA_BASE_URL) + driver_vehical.vehicleimage.name
				else:
					vehical_image= ''


				if driver_vehical.motor_insurance:
					if 'pdf' in driver_vehical.motor_insurance.name:
						is_motor_insurance_pdf=True
						vehical_motor_insurance= str(settings.MEDIA_BASE_URL) + driver_vehical.motor_insurance.name
					else:
						is_motor_insurance_pdf=False
						vehical_motor_insurance= str(settings.MEDIA_BASE_URL) + driver_vehical.motor_insurance.name
					
				else:
					vehical_motor_insurance= ''

				if driver_vehical.goods_in_transit_cover:
					if 'pdf' in driver_vehical.goods_in_transit_cover.name:
						is_GTC_pdf=True
						GoodsTC= str(settings.MEDIA_BASE_URL) + driver_vehical.goods_in_transit_cover.name
					else:
						is_GTC_pdf=False
						GoodsTC= str(settings.MEDIA_BASE_URL) + driver_vehical.goods_in_transit_cover.name
					
				else:
					GoodsTC= ''

				if driver_vehical.public_liability_insurance:
					if 'pdf' in driver_vehical.public_liability_insurance.name:
						is_PLI_pdf=True
						PublicLI= str(settings.MEDIA_BASE_URL) + driver_vehical.public_liability_insurance.name
					else:
						is_PLI_pdf=False
						PublicLI= str(settings.MEDIA_BASE_URL) + driver_vehical.public_liability_insurance.name
					
				else:
					PublicLI= ''
				motor_insurance_status=driver_vehical.motor_insurance_status
				vehicleimage_status=driver_vehical.vehicleimage_status
				GTC_status=driver_vehical.goods_in_transit_cover_status
				PLI_status=driver_vehical.public_liability_insurance_status
			else:
				vehical_type= ''
				vehical_number= ''
				vehical_image= ''
				vehical_motor_insurance= ''
				GoodsTC=''
				PublicLI=''
			
			driver_data.append({
					'name' : driver_obj.name,
					'countrycode' : driver_obj.countrycode,
					'phone' : driver_obj.phone,
					'email' : driver_obj.user.email,
					'image' : image,
					'license_front' : license_front,
					'is_license_front_pdf':is_license_front_pdf,
					'license_front_documentStatus':driver_obj.license_front_documentStatus,
					'is_license_back_pdf':is_license_back_pdf,
					'license_back' : license_back,
					'license_back_documentStatus':driver_obj.license_back_documentStatus,
					'id_front' : id_front,
					'id_front_documentStatus':driver_obj.id_front_documentStatus,
					'is_id_front_pdf':is_id_front_pdf,
					'id_back' : id_back,
					'id_back_documentStatus':driver_obj.id_back_documentStatus,
					'is_id_back_pdf':is_id_back_pdf,
					'crb_dbs' : crb_dbs,
					'crb_dbs_documentStatus':driver_obj.crb_dbs_documentStatus,
					'is_crb_dbs_pdf':is_crb_dbs_pdf,
					'id' : driver_obj.id,
					'vehical_number' : vehical_number,
					'vehical_type' : vehical_type,
					'vehical_image' : vehical_image,
					'is_vehicleimage_pdf':is_vehicleimage_pdf,
					'vehicleimage_status':vehicleimage_status,
					'is_vehicleimage_pdf':is_vehicleimage_pdf,
					'vehical_motor_in' : vehical_motor_insurance,
					'motor_insurance_status':motor_insurance_status,
					'is_motor_insurance_pdf':is_motor_insurance_pdf,
					'PublicLI':PublicLI,
					'GoodsTC':GoodsTC,
					'PLI_status':PLI_status,
					'GTC_status':GTC_status,
					'is_PLI_pdf':is_PLI_pdf,
					'is_GTC_pdf':is_GTC_pdf,

				})
			print(driver_data)
			print("===========Friver Data -====================00",driver_data)
			return JsonResponse(json.dumps(driver_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def edit_driver(request, *args, **kwargs):
	'''This function is being used to edit the driver details'''
	print('Admin - in edit_driver function')
	try:	
		driver_id = request.POST.get('driver_id')
		
		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		try:
			driver_vehical = DriverVehicle.objects.filter(driver = driver_obj,active=True).first()
		except:
			pass

		if driver_obj:
			driver_data = []
			if driver_obj.image:
				image = driver_obj.image.name
			else:
				image = ''

			if driver_obj.license_front:
				license_front = str(settings.MEDIA_BASE_URL) + driver_obj.license_front.name
			else:
				license_front = ''
			if driver_obj.license_back:
				license_back = str(settings.MEDIA_BASE_URL) + driver_obj.license_back.name
			else:
				license_back = ''
			if driver_obj.id_front:
				id_front = str(settings.MEDIA_BASE_URL) + driver_obj.id_front.name
			else:
				id_front = ''
			if driver_obj.id_back:
				id_back = str(settings.MEDIA_BASE_URL) + driver_obj.id_back.name
			else:
				id_back = ''
			if driver_obj.crb_dbs:
				crb_dbs = str(settings.MEDIA_BASE_URL) + driver_obj.crb_dbs.name
			else:
				crb_dbs = ''
			if driver_vehical:
				if driver_vehical.vehiclenumber:
					vehical_number=driver_vehical.vehiclenumber
				else:
					vehical_number= ''

				if driver_vehical.vehicletype:
					vehical_type=driver_vehical.vehicletype
				else:
					vehical_type= ''


				if driver_vehical.vehicleimage:
					vehical_image= str(settings.MEDIA_BASE_URL) + driver_vehical.vehicleimage.name
				else:
					vehical_image= ''


				if driver_vehical.motor_insurance:
					vehical_motor_insurance= str(settings.MEDIA_BASE_URL) + driver_vehical.motor_insurance.name
				else:
					vehical_motor_insurance= ''
			else:
				vehical_type= ''
				vehical_number= ''
				vehical_image= ''
				vehical_motor_insurance= ''
			
			driver_data.append({
					'name' : driver_obj.name,
					'countrycode' : driver_obj.countrycode,
					'phone' : driver_obj.phone,
					'email' : driver_obj.user.email,
					'image' : image,
					'license_front' : license_front,
					'license_back' : license_back,
					'id_front' : id_front,
					'id_back' : id_back,
					'crb_dbs' : crb_dbs,
					'id' : driver_obj.id,
					'vehical_number' : vehical_number,
					'vehical_type' : vehical_type,
					'vehical_image' : vehical_image,
					'vehical_motor_in' : vehical_motor_insurance,
				})
			print("===========Friver Data -====================00",driver_data)
			return JsonResponse(json.dumps(driver_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def add_driver(request, *args, **kwargs):
	'''This function is being used to add the driver details by Admin'''
	print('Admin - in add_driver function')
	try:
		def getI420FromBase64(codec, id_val, image_path="c:\\"):

			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			driver_obj = DriverModel.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.makedirs(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = '/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)+'/original-'+st+'.'+extension
			driver_obj.image = filename
			driver_obj.save()
			return('1')
		
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Name is required.'})
		email = request.POST.get('email')
		if not email:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Email Address is required.'})
		password = request.POST.get('password')
		if not password:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Password is required.'})

		countrycode = request.POST.get('countrycode')
		if not countrycode:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Country Code is required.'})
		phone = request.POST.get('phone')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		
		imgsrc = request.POST.get('image')

		user_obj = User.objects.filter(username = email).first()
		if user_obj:
			driver_obj = DriverModel.objects.filter(user = user_obj)
			if driver_obj:
				return JsonResponse({'status_code': 0, 'status_message': 'User exists.'})
			else:
				admin_obj = Admin.objects.filter(user = user_obj)
				if admin_obj:
					return JsonResponse({'status_code': 0, 'status_message': 'An Admin exists with this email address.'})
				else:
					customer_obj = Customer.objects.filter(user = user_obj)
					if customer_obj:
						return JsonResponse({'status_code': 0, 'status_message': 'A Customer exists with this email address.'})
		else:
			user_obj = User.objects.create_user(username = email, email = email, password = password)

		driver_obj = DriverModel.objects.create(user = user_obj,  name = name, email = email, countrycode = countrycode, phone = phone, accountapproved = True, emailverified = True)
		if driver_obj:
			respos=createDriverSlots(driver_obj.id)
			if respos == '1':
				print("========================Driver Slots Added Successfully====================")
			else:
				print("=======================Driver Slots errors====================================")
			if imgsrc:
				codec = imgsrc
				getI420FromBase64(codec,id_val = driver_obj.id)
			sentemail = sendnewusermail(senderemail = str(settings.EMAIL_HOST_USER), recipientemail = driver_obj.email, subject = 'New Signup', username = driver_obj.name, useremail = driver_obj.email, userpassword = password, loginurl = str(settings.WEB_BASE_URL)+'/login/')
			if sentemail:
				print('New user mail sent')
			else:
				print('error in new user mail sent')
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Record not created.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def disable_driver(request, *args, **kwargs):
	'''This function is being used to delete the driver details by Admin'''
	print('Admin - in disable_driver function')
	try:	
		driver_id = request.POST.get('driver_id')
		if not driver_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver Id is required.'})
		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		if driver_obj:
			driver_obj.isdisabled = True
			driver_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record disabled successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def enable_driver(request, *args, **kwargs):
	'''This function is being used to delete the driver details by Admin'''
	print('Admin - in enable_driver function')
	try:	
		driver_id = request.POST.get('driver_id')
		if not driver_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver Id is required.'})
		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		if driver_obj:
			driver_obj.isdisabled = False
			driver_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record enabled successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def approve_driver(request, *args, **kwargs):
	'''This function is being used to approve the driver details by Admin'''
	print('Admin - in approve_driver function')
	try:	
		driver_id = request.POST.get('driver_id')
		if not driver_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver Id is required.'})
		driver_obj = DriverModel.objects.filter(id = driver_id).first()
		if driver_obj:
			driver_obj.accountapproved = True
			driver_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Account approved successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def update_driver(request, *args, **kwargs):
	'''This function is being used to update the driver details by Admin'''
	print('Admin - in update_driver function')
	try:	
		def getI420FromBase64(codec, id_val, image_path="c:\\"):

			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			driver_obj = DriverModel.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = '/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)+'/original-'+st+'.'+extension
			driver_obj.image = filename
			driver_obj.save()
			return('1')
		
		driver_id = request.POST.get('driver_id')
		if not driver_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver Id is required.'})
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Name is required.'})
		countrycode = request.POST.get('countrycode')
		if not countrycode:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Country Code is required.'})
		phone = request.POST.get('phone')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		imgsrc = request.POST.get('image')
		driver_obj = DriverModel.objects.filter(id = driver_id).prefetch_related('user').first()
		if driver_obj:
			driver_obj.name = name
			driver_obj.countrycode = countrycode
			driver_obj.phone = phone
			driver_obj.save()
			if imgsrc:
				codec = imgsrc
				getI420FromBase64(codec,id_val = driver_obj.id)
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record updated successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'driver record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})





def edit_company(request, *args, **kwargs):
	'''This function is being used to edit the company details by Admin'''
	print('Admin - in edit_company function')
	try:	
		company_id = request.POST['company_id']
		
		company_obj = Company.objects.filter(id = company_id).first()
		if company_obj:
			company_data = []
			if company_obj.image:
				image = company_obj.image.path
			else:
				image = ''
			company_data.append({
					'firstname' : company_obj.user.first_name,
					'lastname' : company_obj.user.last_name,

					'name' : company_obj.name,
					'countrycode' : company_obj.countrycode,
					'phone' : company_obj.phone,
					'email' : company_obj.user.email,
					'address' : company_obj.address,
					'image' : image,
					'id' : company_obj.id,
				})
			return JsonResponse(json.dumps(company_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def add_company(request, *args, **kwargs):
	'''This function is being used to add the company details by Admin'''
	print('Admin - in add_company function')
	try:
		def getI420FromBase64(codec, id_val, image_path="c:\\"):

			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			company_obj = Company.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/Companies/'+str(company_obj.id)+'_'+str(company_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = str(settings.WEB_BASE_URL)+'/media/Users/Companies/'+str(company_obj.id)+'_'+str(company_obj.user.email)+'/original-'+st+'.'+extension
			company_obj.image = filename
			company_obj.save()
			return('1')
		
		
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Company Name is required.'})
		email = request.POST.get('email')
		if not email:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Email Address is required.'})
		password = request.POST.get('password')
		if not password:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Password is required.'})

		# countrycode = request.POST.get('countrycode')
		# if not countrycode:
		# 	return JsonResponse({'status_code' : 0, 'status_message' : 'Country Code is required.'})
		phone = request.POST.get('phone')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		address = request.POST.get('address')
		if not address:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Address is required.'})

		imgsrc = request.POST.get('image')

		user_obj = User.objects.filter(username = email).first()
		if user_obj:
			return JsonResponse({'status_code': 0, 'status_message': 'User exists.'})
		else:
			user_obj = User.objects.create_user(username = email, email = email, password = password)

		company_obj = Customer.objects.create(user = user_obj, name = name, email = email, phone = phone, address = address, accountapproved = True)
		if company_obj:
			if imgsrc:
				codec = imgsrc
				getI420FromBase64(codec,id_val = company_obj.id)
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Record not created.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def delete_company(request, *args, **kwargs):
	'''This function is being used to delete the company details by Admin'''
	print('Admin - in delete_company function')
	try:	
		company_id = request.POST['company_id']
		if not company_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'company Id is required.'})
		company_obj = Company.objects.filter(id = company_id).first()
		if company_obj:

			company_obj.isdeleted = True
			company_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'company record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def approve_company(request, *args, **kwargs):
	'''This function is being used to approve the company details by Admin'''
	print('Admin - in approve_company function')
	try:	
		company_id = request.POST['company_id']
		if not company_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Company Id is required.'})
		company_obj = Company.objects.filter(id = company_id).first()
		if company_obj:
			company_obj.accountapproved = True
			company_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Account approved successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Company record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def update_company(request, *args, **kwargs):
	'''This function is being used to update the company details by Admin'''
	print('Admin - in update_company function')
	try:
		def getI420FromBase64(codec, id_val, image_path="c:\\"):

			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			company_obj = Company.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/Companies/'+str(company_obj.id)+'_'+str(company_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = str(settings.WEB_BASE_URL)+'/media/Users/Companies/'+str(company_obj.id)+'_'+str(company_obj.user.email)+'/original-'+st+'.'+extension
			company_obj.image = filename
			company_obj.save()
			return('1')
			
		company_id = request.POST.get('company_id')
		if not company_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Company Id is required.'})
		firstname = request.POST.get('firstname')
		if not firstname:
			return JsonResponse({'status_code' : 0, 'status_message' : 'First Name is required.'})
		lastname = request.POST.get('lastname')
		if not lastname:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Last Name is required.'})
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Company Name is required.'})
		countrycode = request.POST.get('countrycode')
		if not countrycode:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Country Code is required.'})
		phone = request.POST.get('phone')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		address = request.POST.get('address')
		if not address:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Address is required.'})
		imgsrc = request.POST.get('image')
		company_obj = Company.objects.filter(id = company_id).first()
		if company_obj:
			company_obj.user.first_name = firstname
			company_obj.user.last_name = lastname
			company_obj.user.save()
			company_obj.name = name
			company_obj.countrycode = countrycode
			company_obj.phone = phone
			company_obj.address = address
			company_obj.save()
			if imgsrc:
				codec = imgsrc
				getI420FromBase64(codec,id_val = company_obj.id)
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record updated successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'company record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})







def edit_admin(request, *args, **kwargs):
	'''This function is being used to edit the admin details by Admin'''
	print('Admin - in edit_admin function')
	try:	
		admin_id = request.POST.get('admin_id')
		
		admin_obj = Admin.objects.filter(id = admin_id).first()
		if admin_obj:
			admin_data = []
			if admin_obj.image:
				image = admin_obj.image.name
			else:
				image = ''
			admin_data.append({
					'name' : admin_obj.name,
					'email' : admin_obj.email,
					'phone' : admin_obj.phone,
					
					'image' : image,
					'id' : admin_obj.id,
				})
			print(admin_data)
			return JsonResponse(json.dumps(admin_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def add_admin(request, *args, **kwargs):
	'''This function is being used to add the admin details by Admin'''
	print('Admin - in add_admin function')
	try:
		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			admin_obj = Admin.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/Admins/'+str(admin_obj.id)+'_'+str(admin_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = str(settings.WEB_BASE_URL)+'/media/Users/Admins/'+str(admin_obj.id)+'_'+str(admin_obj.user.email)+'/original-'+st+'.'+extension
			admin_obj.image = filename
			admin_obj.save()
			return('1')
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Name is required.'})
		email = request.POST.get('email')
		if not email:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Email Address is required.'})
		password = request.POST.get('password')
		if not password:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Password is required.'})
		phone = request.POST.get('phone')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		
		imgsrc = request.POST.get('image')

		user_obj = User.objects.filter(username = email).first()
		if user_obj:
			return JsonResponse({'status_code': 0, 'status_message': 'User exists.'})
		else:
			user_obj = User.objects.create_user(username = email, email = email, password = password, is_staff = True, is_superuser = False)
		admin_obj = Admin.objects.create(user = user_obj, name = name, email = email, phone = phone, accountapproved = True)
		try:
			pass
		except Exception as e:
			print(e)
		if admin_obj:
			if imgsrc:
				codec = imgsrc
				getI420FromBase64(codec,id_val = admin_obj.id)

			sentemail = sendnewusermail(senderemail = str(settings.EMAIL_HOST_USER), recipientemail = admin_obj.email, subject = 'New Signup', username = admin_obj.name, useremail = admin_obj.email, userpassword = password, loginurl = str(settings.WEB_BASE_URL)+'/admin/login/')
			if sentemail:
				print('New user mail sent')
			else:
				print('error in new user mail sent')
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Record not created.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def delete_admin(request, *args, **kwargs):
	'''This function is being used to delete the admin details by Admin'''
	print('Admin - in delete_admin function')
	try:	
		admin_id = request.POST.get('admin_id')
		if not admin_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'admin Id is required.'})
		admin_obj = Admin.objects.filter(id = admin_id).first()
		
		# code for 23rd June
		admin_obj = Admin.objects.filter(id = admin_id).first()
		# return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})

		# 
		if admin_obj:
			userid = admin_obj.user.id
			User.objects.filter(id = userid).delete()
			# admin_obj.isdeleted = True
			# admin_obj.save()
			print('0')
			# if admin_obj.image:
			# 	print('1')
			# 	try:
			# 		if(os.path.exists(admin_obj.image.path)):
			# 			print('2')
			# 			os.remove(admin_obj.image.path)
			# 		else:
			# 			print('3')
			# 	except Exception as e:
			# 		print(e)
			# 		print('4')
			# 	print(' VPAIS ')
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'admin record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def approve_admin(request, *args, **kwargs):
	'''This function is being used to approve the admin details by Admin'''
	print('Admin - in approve_admin function')
	try:	
		admin_id = request.POST.get('admin_id')
		if not admin_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'admin Id is required.'})
		admin_obj = admin.objects.filter(id = admin_id).first()
		if admin_obj:
			admin_obj.accountapproved = True
			admin_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Account approved successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'admin record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def update_admin(request, *args, **kwargs):
	'''This function is being used to update the admin details by Admin'''
	print('Admin - in update_admin function')
	try:	
		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print('HERE')
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			admin_obj = Admin.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/admins/'+str(admin_obj.id)+'_'+str(admin_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = str(settings.WEB_BASE_URL)+'/media/Users/admins/'+str(admin_obj.id)+'_'+str(admin_obj.user.email)+'/original-'+st+'.'+extension
			admin_obj.image = filename
			admin_obj.save()
			return('1')
		admin_id = request.POST.get('admin_id')
		if not admin_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'admin Id is required.'})
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Name is required.'})
		phone = request.POST.get('phone')
		print(' 1256')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		imgsrc = request.POST.get('image')
		print('1262')
		admin_obj = Admin.objects.filter(id = admin_id).prefetch_related('user').first()
		print('1300')
		if admin_obj:
			admin_obj.name = name
			admin_obj.phone = phone
			admin_obj.save()
			if imgsrc:
				codec = imgsrc
				# getI420FromBase64(codec,id_val = admin_obj.id)
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record updated successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'admin record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})















def edit_customer(request, *args, **kwargs):
	'''This function is being used to edit the customer details by Admin'''
	print('Admin - in edit_customer function')
	try:	
		customer_id = request.POST.get('customer_id')
		
		customer_obj = Customer.objects.filter(id = customer_id).first()
		if customer_obj:
			customer_data = []
			customerjobs_count = CustomerJob.objects.filter(customer = customer_obj).count()
			if customer_obj.image:
				image = customer_obj.image.name
			else:
				image = ''
			customer_data.append({
					'name' : customer_obj.name,
					'email' : customer_obj.email,
					'phone' : customer_obj.phone,
					'image' : image,
					'emailverified' : customer_obj.emailverified,
					'jobscount' : customerjobs_count,
					'id' : customer_obj.id,
				})
			print(customer_data)
			return JsonResponse(json.dumps(customer_data), safe = False)
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')

def add_customer(request, *args, **kwargs):
	'''This function is being used to add the customer details by Admin'''
	print('Admin - in add_customer function')
	try:
		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			customer_obj = Customer.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = str(settings.WEB_BASE_URL)+'/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)+'/original-'+st+'.'+extension
			customer_obj.image = filename
			customer_obj.save()
			return('1')
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Name is required.'})
		email = request.POST.get('email')
		if not email:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Email Address is required.'})
		password = request.POST.get('password')
		if not password:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Password is required.'})
		phone = request.POST.get('phone')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		
		imgsrc = request.POST.get('image')
		role = request.POST.get('role')

		user_obj = User.objects.filter(username = email).first()
		if user_obj:
			customer_obj = Customer.objects.filter(user = user_obj)
			if customer_obj:
				return JsonResponse({'status_code': 0, 'status_message': 'User exists.'})
			else:
				admin_obj = Admin.objects.filter(user = user_obj)
				if admin_obj:
					return JsonResponse({'status_code': 0, 'status_message': 'An Admin exists with this email address.'})
				else:
					driver_obj = DriverModel.objects.filter(user = user_obj)
					if driver_obj:
						return JsonResponse({'status_code': 0, 'status_message': 'A Driver exists with this email address.'})

		else:
			user_obj = User.objects.create_user(username = email, email = email, password = password)
		if role == 'company':
			role = 'company'
		else:
			role = 'customer'
		customer_obj = Customer.objects.create(user = user_obj, role = role, name = name, email = email, phone = phone, accountapproved = True , emailverified = True)
		if customer_obj:
			if imgsrc:
				codec = imgsrc
				getI420FromBase64(codec,id_val = customer_obj.id)

			sentemail = sendnewusermail(senderemail = str(settings.EMAIL_HOST_USER), recipientemail = customer_obj.email, subject = 'New Signup', username = customer_obj.name, useremail = customer_obj.email, userpassword = password, loginurl = str(settings.WEB_BASE_URL)+'/login/')
			if sentemail:
				print('New user mail sent')
			else:
				print('error in new user mail sent')
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Record not created.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def slotStatusonJobComplete2(sameparcelID):
	customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID)
	packageCompleted=True
	startSlot=24
	lastSlot=0
	driverID=0
	driverExist=False
	for customer in customerjob_obj_all:
		dJob=DriverJob.objects.filter(customerjob=customer).first()
		if dJob:
			driverExist=True
			driverID=dJob.driver.id
			print(customer.pickuptimeslotDate)
			print(customer.pickuptimeslot)
			stringFirst=customer.pickuptimeslot
			one=stringFirst.split('-')[0]
			two=stringFirst.split('-')[1]
			one=one[:-1]
			two=two[1:]
			one=convert24(one)
			two=convert24(two)
			stringFirst=one+" "+two
			print(one)
			print(two)
			print(stringFirst)
			pickupSlotID=int(stringFirst[:2])
			if pickupSlotID<startSlot:
				startSlot=pickupSlotID
			print("Pickupslotid",pickupSlotID)
			print(customer.dropofftimeslot)
			stringSecond=customer.dropofftimeslot
			one=stringSecond.split('-')[0]
			two=stringSecond.split('-')[1]
			one=one[:-1]
			two=two[1:]
			one=convert24(one)
			two=convert24(two)
			stringSecond=one+" "+two
			print(one)
			print(two)
			print(stringSecond)
			deliverySlotID=int(stringSecond[:2])
			if deliverySlotID>lastSlot:
				lastSlot=deliverySlotID
	if driverExist:
		makeslotAvailable(startSlot,lastSlot+1,driverID)

def slotStatusonJobCompletenew(sameparcelID):
	customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID)
	packageCompleted=True
	startSlot=24
	lastSlot=0
	driverID=0
	driverExist=False
	for customer in customerjob_obj_all:
		dJob=DriverJob.objects.filter(customerjob=customer).first()
		if dJob:
			print("we are in driver job")
			driverExist=True
			driverID=dJob.driver.id
			print(customer.pickuptimeslotDate)
			print(customer.pickuptimeslot)
			stringFirst=customer.pickuptimeslot
			one=stringFirst.split('-')[0]
			two=stringFirst.split('-')[1]
			one=one[:-1]
			two=two[1:]
			one=convert24(one)
			two=convert24(two)
			stringFirst=one+" "+two
			print(one)
			print(two)
			print(stringFirst)
			pickupSlotID=int(stringFirst[:2])
			if pickupSlotID<startSlot:
				startSlot=pickupSlotID
			print("Pickupslotid",pickupSlotID)
			print(customer.dropofftimeslot)
			stringSecond=customer.dropofftimeslot
			one=stringSecond.split('-')[0]
			two=stringSecond.split('-')[1]
			one=one[:-1]
			two=two[1:]
			one=convert24(one)
			two=convert24(two)
			stringSecond=one+" "+two
			print(one)
			print(two)
			print(stringSecond)
			deliverySlotID=int(stringSecond[:2])
			if deliverySlotID>lastSlot:
				lastSlot=deliverySlotID
	slotsFind=False
	idofslottables=0
	print("one 1")
	pickupdateCuystomer = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID).first()
	print(pickupdateCuystomer)
	print("one 2")
	parcelpickupdate=pickupdateCuystomer.pickuptimeslotDate
	print("one 3")
	dJob=DriverJob.objects.filter(customerjob=pickupdateCuystomer).first()
	print(dJob)
	if dJob:
		print("one 4")
		driver=dJob.driver
		print("one 5",driver)
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver)
		print("one 6",driverslotsobj)
		for d in driverslotsobj:
			print("one 7")
			if d.dateOfSlots==parcelpickupdate:
				print("one 8",d.dateOfSlots)
				slotsFind=True
				idofslottables=d.id
				print("one 8",idofslottables)
	if slotsFind==True:
		print("one 9")
		if driverExist:
			print("one 10")
			makeslotAvailablenew(startSlot,lastSlot+1,idofslottables)

def deletecustomerjob(request, *args, **kwargs):
	'''This function is being used to delete the customer details by Admin'''
	print('Admin - in deletecustomerjob function')
	try:	
		sameparcelID = request.POST.get('customerjob_id')
		if not sameparcelID:
			return JsonResponse({'status_code' : 0, 'status_message' : 'CustomerJob Id is required.'})
		customerjob_obj=CustomerJob.objects.filter(sameIdForParcelsDetails=sameparcelID)
		cancelParcel=True
		if customerjob_obj:
			for c in customerjob_obj:
				dJob=DriverJob.objects.filter(customerjob=c).first()
				if dJob.jobstarted==True:
					cancelParcel=False
			if cancelParcel==True:
				for custom in customerjob_obj:
					custom.isdeleted=True
					dJob=DriverJob.objects.filter(customerjob=custom).first()
					if dJob:
						dJob.isdeleted=True
						dJob.save()
					custom.save()
				slotStatusonJobCompletenew(sameparcelID)
				for custom in customerjob_obj:
					dJob=DriverJob.objects.filter(customerjob=custom).first()
					if dJob:
						dJob.delete()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		# customer_obj = CustomerJob.objects.filter(id = customerjob_id).delete()
		# return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		# if customer_obj:
		# 	customer_obj.isdeleted = True
		# 	customer_obj.save()
		# 	print('0')
		# 	if customer_obj.image:
		# 		print('1')
		# 		try:
		# 			if(os.path.exists(customer_obj.image.path)):
		# 				print('2')
		# 				os.remove(customer_obj.image.path)
		# 			else:
		# 				print('3')
		# 		except Exception as e:
		# 			print(e)
		# 			print('4')
			# return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})


def disable_customer(request, *args, **kwargs):
	'''This function is being used to delete the customer details by Admin'''
	print('Admin - in disable_customer function')
	try:	
		customer_id = request.POST.get('customer_id')
		if not customer_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer Id is required.'})
		customer_obj = Customer.objects.filter(id = customer_id).first()
		if customer_obj:
			customer_obj.isdisabled = True
			customer_obj.save()
			print('0')
			# if customer_obj.image:
			# 	print('1')
			# 	try:
			# 		if(os.path.exists(customer_obj.image.path)):
			# 			print('2')
			# 			os.remove(customer_obj.image.path)
			# 		else:
			# 			print('3')
			# 	except Exception as e:
			# 		print(e)
			# 		print('4')
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record disabled successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def enable_customer(request, *args, **kwargs):
	'''This function is being used to delete the customer details by Admin'''
	print('Admin - in enable_customer function')
	try:	
		customer_id = request.POST.get('customer_id')
		if not customer_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer Id is required.'})
		customer_obj = Customer.objects.filter(id = customer_id).first()
		if customer_obj:
			customer_obj.isdisabled = False
			customer_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record enabled successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})


def approve_customer(request, *args, **kwargs):
	'''This function is being used to approve the customer details by Admin'''
	print('Admin - in approve_customer function')
	try:	
		customer_id = request.POST.get('customer_id')
		if not customer_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer Id is required.'})
		customer_obj = Customer.objects.filter(id = customer_id).first()
		if customer_obj:
			customer_obj.accountapproved = True
			customer_obj.save()
			return JsonResponse({'status_code' : 200, 'status_message' : 'Account approved successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})

def update_customer(request, *args, **kwargs):
	'''This function is being used to update the customer details by Admin'''
	print('Admin - in update_customer function')
	try:	
		def getI420FromBase64(codec, id_val, image_path="c:\\"):

			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			img = Image.open(image_data)
			customer_obj = Customer.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			for obj in thumbnailsize_objs:
				img = Image.open(image_data)
				im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
				im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
			img = Image.open(image_data)	
			img.save(filepath+'/original-'+st+'.'+extension)	
			filename = str(settings.WEB_BASE_URL)+'/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)+'/original-'+st+'.'+extension
			customer_obj.image = filename
			customer_obj.save()
			return('1')
		customer_id = request.POST.get('customer_id')
		if not customer_id:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer Id is required.'})
		name = request.POST.get('name')
		if not name:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Name is required.'})
		phone = request.POST.get('phone')
		if not phone:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Phone Number is required.'})
		imgsrc = request.POST.get('image')
		customer_obj = Customer.objects.filter(id = customer_id).prefetch_related('user').first()
		if customer_obj:
			customer_obj.name = name
			customer_obj.phone = phone
			customer_obj.save()
			if imgsrc:
				codec = imgsrc
				getI420FromBase64(codec,id_val = customer_obj.id)
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record updated successfully.'})
		else:
			return JsonResponse({'status_code' : 0, 'status_message' : 'Customer record not found.'})
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 0, 'status_message' : str(e)})






def add_city(request, *args, **kwargs):
	'''This function is being used to add the city details by Admin'''
	print('Admin - in add_city function')
	try:	
		country = request.POST['country']
		city = request.POST['city']
		country_obj = Country.objects.filter(name = country).first()
		if country_obj:
			city_obj = City.objects.filter(country = country_obj, name = city).first()
			if city_obj:
				return HttpResponse('0')
			else:
				city_obj = City.objects.create(country = country_obj, name = city)
				if city_obj:
					return HttpResponse('1')
		else:
			return HttpResponse('3')
	except Exception as e:
		print(e)
		return HttpResponse('2')


@method_decorator(checkloginadmin, name='dispatch')
class SuperAdminDashboard(TemplateView):
	template_name = 'superadmin_dashboard.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on Superadmin dashboard screen'''
		context = super(SuperAdminDashboard, self).get_context_data(**kwargs)
		print("SuperAdminDashboard-in get ")
		if self.request.session.has_key('userrole'):
			context['userrole'] = self.request.session['userrole']
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				context['username'] = user_obj.first_name + ' ' + user_obj.last_name

		recent_customerjobs = CustomerJob.objects.all().order_by('-id')[:10]
		context['recent_customerjobs'] = recent_customerjobs
		
		totalcustomers = Customer.objects.filter(isdeleted = False, emailverified = True).count()
		totalcustomerjobs = CustomerJob.objects.count()
		totaldrivers = DriverModel.objects.filter(isdeleted = False, emailverified = True).count()
		context['totalcustomers'] = totalcustomers
		context['totalcustomerjobs'] = totalcustomerjobs
		context['totaldrivers'] = totaldrivers
		recent_companies = Company.objects.all().order_by('-id')[:5][::-1]
		context['recent_companies'] = recent_companies
		return context	


@method_decorator(checkloginadmin, name='dispatch')
class AdminDashboard(TemplateView):
	template_name = 'admin_dashboard.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on Admin dashboard screen'''
		context = super(AdminDashboard, self).get_context_data(**kwargs)
		print("AdminDashboard-in get ")
		if self.request.session.has_key('userrole'):
			context['userrole'] = self.request.session['userrole']
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				context['username'] = user_obj.first_name + ' ' + user_obj.last_name
		recent_customerjobs = CustomerJob.objects.all().order_by('-id')[:10]
		context['recent_customerjobs'] = recent_customerjobs
		
		totalcustomers = Customer.objects.filter(emailverified = True).count()
		totalcustomerjobs = CustomerJob.objects.count()
		totaldrivers = DriverModel.objects.filter(emailverified = True).count()
		context['totalcustomers'] = totalcustomers
		context['totalcustomerjobs'] = totalcustomerjobs
		context['totaldrivers'] = totaldrivers
		recent_companies = Company.objects.all().order_by('-id')[:5][::-1]
		context['recent_companies'] = recent_companies
		return context	


@method_decorator(checkloginadmin, name='dispatch')
class AllVehicleTypes(TemplateView):
	template_name = 'admin_showallvehicletypes.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all vehicle types screen to Admin user'''
		context = super(AllVehicleTypes, self).get_context_data(**kwargs)
		print("AllVehicleTypes-in get ")
		all_vehicletypes = VehicleType.objects.filter(isdeleted = False)
		data = []
		if all_vehicletypes:
			serialno = 0
			for vehicle in all_vehicletypes:
				serialno +=1
				data.append({
					'serialno' : serialno,
					'name' : vehicle.name,
					'carryinglimitinkg' : vehicle.carryinglimitinkg,
					'fixeddistance' : vehicle.fixeddistance,
					'distanceunit' : vehicle.distanceunit,
					'baserate' : vehicle.baserate,
					'addittionalrateperunit' : vehicle.addittionalrateperunit,
					'priceperdrop' : vehicle.priceperdrop,
					'priceperhour' : vehicle.priceperhour,
					'currency' : vehicle.currency,
					'id' : vehicle.id,
					'created_at' : vehicle.created_at,
					'height' : vehicle.heightOfVehical,
					'width' : vehicle.widthOfVehical,
					'length' : vehicle.lengthOfVehical,
					})
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_vehicletypes = paginator.page(page)
			print("truy")
		except PageNotAnInteger:
			all_vehicletypes = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_vehicletypes = paginator.page(paginator.num_pages)
			print("except2")

		context['all_vehicletypes'] = all_vehicletypes
		context['vehicletypes_section'] = 'yes'
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllAdmins(TemplateView):
	template_name = 'admin_showalladmins.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllAdmins, self).get_context_data(**kwargs)
		print("AdminShowAllAdmins-in get ")
		all_admin_users = User.objects.filter(is_staff = True, is_superuser = False).order_by('-id')
		data = []
		if all_admin_users:
			serialno = 0
			for admin_user in all_admin_users:
				admin_obj = Admin.objects.filter(user = admin_user).first()
				if admin_obj:
					serialno +=1
					data.append({
						'serialno' : serialno,
						'name' : admin_obj.name,
						'phone' : admin_obj.phone,
						'email' : admin_obj.email,
						'created_at' : admin_obj.user.date_joined,
						'accountapproved' : 'Yes',
						'id' : admin_obj.id,
						})
					# print(data)
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_admins = paginator.page(page)
			print(len(all_admins))
			print("truy")
		except PageNotAnInteger:
			all_admins = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_admins = paginator.page(paginator.num_pages)
			print("except2")

		context['all_admins'] = all_admins
		return context



@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCustomers(TemplateView):
	template_name = 'admin_showallcustomers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all customers screen to Admin user'''
		context = super(AdminShowAllCustomers, self).get_context_data(**kwargs)
		print("AdminShowAllCustomers-in get ")
		all_customers = Customer.objects.filter(role = 'customer', isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_customers:
			serialno = 0
			for customer in all_customers:
				serialno +=1
				if customer.emailverified:
					emailverified = 'Yes'
				else:
					emailverified = 'No'
				if customer.accountapproved:
					accountapproved = 'Yes'
				else:
					accountapproved = 'No'
				if customer.isdisabled:
					isdisabled = 'Yes'
				else:
					isdisabled = 'No'
				if customer.name:
					name = customer.name
				else:
					name = ''
				if not customer.countrycode:
					phone = customer.phone
				else:
					phone = customer.countrycode  + '-' + customer.phone
				data.append({
					'serialno' : serialno,
					'name' : name,
					'phone' : phone,
					'email' : customer.email,
					'created_at' : customer.user.date_joined,
					'accountapproved' : accountapproved,
					'emailverified' : emailverified,
					'isdisabled' : isdisabled,
					'id' : customer.id,
					})
				# print(data)
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customers = paginator.page(page)
			print(len(all_customers))
			print("truy")
		except PageNotAnInteger:
			all_customers = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customers = paginator.page(paginator.num_pages)
			print("except2")


		
		context['all_customers'] = all_customers
		context['in_allcustomers_section'] = 'yes'
		
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllCompanies(TemplateView):
	template_name = 'admin_showallcompanies.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all companies screen to Admin user'''
		context = super(AdminShowAllCompanies, self).get_context_data(**kwargs)
		print("AdminShowAllCompanies-in get ")
		all_customers = Customer.objects.filter(role = 'company', isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_customers:
			serialno = 0
			for customer in all_customers:
				serialno +=1
				if customer.emailverified:
					emailverified = 'Yes'
				else:
					emailverified = 'No'
				if customer.accountapproved:
					accountapproved = 'Yes'
				else:
					accountapproved = 'No'
				if customer.isdisabled:
					isdisabled = 'Yes'
				else:
					isdisabled = 'No'
				if customer.name:
					name = customer.name
				else:
					name = ''
				if not customer.countrycode:
					phone = customer.phone
				else:
					phone = customer.countrycode  + '-' + customer.phone
				data.append({
					'serialno' : serialno,
					'name' : name,
					'phone' : phone,
					'email' : customer.email,
					'created_at' : customer.user.date_joined,
					'accountapproved' : accountapproved,
					'emailverified' : emailverified,
					'isdisabled' : isdisabled,
					'id' : customer.id,
					})
				# print(data)
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_customers = paginator.page(page)
			print(len(all_customers))
			print("truy")
		except PageNotAnInteger:
			all_customers = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_customers = paginator.page(paginator.num_pages)
			print("except2")

		context['all_customers'] = all_customers
		context['in_allcompanies_section'] = 'yes'
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminCreditRequests(TemplateView):
	template_name = 'admin_showallcreditrequests.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all companies screen to Admin user'''
		context = super(AdminCreditRequests, self).get_context_data(**kwargs)
		print("AdminCreditRequests-in get ")
		all_credit_requests_data = []
		creditsrequested_obj = CreditsRequested.objects.all().order_by('-id')
		if creditsrequested_obj:
			serialno = 0
			for req in creditsrequested_obj:
				serialno += 1
				all_credit_requests_data.append({
					'serialno' : serialno,
					'company_email' : req.company_email,
					'credits' : req.credits,
					'note_by_company' : req.note_by_company,
					'status' : req.status,
					'date' : req.created_at.strftime("%d/%m/%Y %I:%M:%S %p"),
					'id' : req.id,
					})
		
				# print(data)

		paginator = Paginator(all_credit_requests_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_credit_requests_data = paginator.page(page)
			print(len(all_credit_requests_data))
			print("truy")
		except PageNotAnInteger:
			all_credit_requests_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_credit_requests_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_credit_requests'] = all_credit_requests_data
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDrivers(TemplateView):
	template_name = 'admin_showalldrivers.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDrivers, self).get_context_data(**kwargs)
		print("AdminShowAllDrivers-in get ")
		all_drivers = DriverModel.objects.filter(isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_drivers:
			serialno = 0
			for driver in all_drivers:
				serialno +=1
				vehicletype=''
				if driver.vehicletype == 0:
					vehicletype = 'Bike'
				elif driver.vehicletype == 1:
					vehicletype = 'Car'
				elif driver.vehicletype == 2:
					vehicletype = 'Small Van'
				elif driver.vehicletype == 3:
					vehicletype = 'Medium Van'
				elif driver.vehicletype == 4:
					vehicletype = 'Large Van'
				elif driver.vehicletype == 5:
					vehicletype = 'Not Specified'
				
				if driver.emailverified:
					emailverified = 'Yes'
				else:
					emailverified = 'No'
				if driver.accountapproved:
					accountapproved = 'Yes'
				else:
					accountapproved = 'No'
				if driver.isdisabled:
					isdisabled = 'Yes'
				else:
					isdisabled = 'No'
				
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude
				else:
					latitude = ''
					longitude = ''
				data.append({
					'serialno' : serialno,
					'name' : driver.name,
					'phone' : driver.countrycode + '-' + driver.phone,
					'email' : driver.user.email,
					'vehicletype' : vehicletype,
					'vehiclenumber' : driver.vehiclenumber,
					'preferredarea' : driver.preferredarea,
					'created_at' : driver.user.date_joined,
					'emailverified' : emailverified,
					'accountapproved' : accountapproved,
					'isdisabled' : isdisabled,
					'latitude' : latitude,
					'longitude' : longitude,
					'id' : driver.id,
					})
		vehicalList=[]
		vehicalObj=VehicleType.objects.filter(isdeleted = False)
		for v in vehicalObj:
			vehicalList.append({
				'name':v.name,
				'id':v.id,

				})
		context['allVehicals']=vehicalList
		paginator = Paginator(data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			data = paginator.page(page)
			print(len(data))
			print("truy")
		except PageNotAnInteger:
			data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_drivers'] = data
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AdminShowAllDriversMap(TemplateView):
	template_name = 'admin_showalldrivers_map.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all drivers screen to Admin user'''
		context = super(AdminShowAllDriversMap, self).get_context_data(**kwargs)
		print("AdminShowAllDriversMap-in get ")
		all_drivers = DriverModel.objects.filter(isdeleted = False).order_by('-id').prefetch_related('user')
		data = []
		if all_drivers:
			for driver in all_drivers:
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					latitude = drivercoordinates_obj.latitude
					longitude = drivercoordinates_obj.longitude
					data.append({
						'name' : driver.name,
						'phone' : driver.countrycode + '-' + driver.phone,
						'email' : driver.user.email,
						'vehiclenumber' : driver.vehiclenumber,
						'latitude' : latitude,
						'longitude' : longitude,
						'id' : driver.id,
						})
		context['all_drivers'] = data
		return context


@method_decorator(checkloginadmin, name='dispatch')
class AllCountries(TemplateView):
	template_name = 'admin_allcountries.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all countries screen to Admin user'''
		context = super(AllCountries, self).get_context_data(**kwargs)
		print("AllCountries-in get ")
		all_countries = Country.objects.all()
		context['all_countries'] = all_countries
		return context

@method_decorator(checkloginadmin, name='dispatch')
class AllCities(TemplateView):
	template_name = 'admin_allcities.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all cities screen to Admin user'''
		context = super(AllCities, self).get_context_data(**kwargs)
		print("AllCities-in get ")
		all_cities = City.objects.all()
		context['all_cities'] = all_cities
		return context

class AdminLogin(TemplateView):
	template_name = 'admin_login.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all cities screen to Admin user'''
		context = super(AdminLogin, self).get_context_data(**kwargs)
		return context

	def post(self, request, *args, **kwargs):
		'''This class is used for the login process for admin user'''
		try:
			print('AdminLogin Web - in post')
			user = authenticate(username = request.POST['email'], password = request.POST['password'])  
			if user is not None:
				request.session['email'] = request.POST['email']
				superadmin_obj = User.objects.filter(id=int(user.id),is_superuser = True).first()
				redirectlink = request.GET.get('next')
				if superadmin_obj:
					obj = Admin.objects.filter(user = superadmin_obj).first()
					if obj:
						request.session['userrole'] = 'superadmin'
						token = Token.objects.get_or_create(user=user)
						return JsonResponse({'status_code': 200, 'user' : 'superadmin', 'status_message' : 'superadmin login successfull', 'redirectlink' : redirectlink})
					else:
						return JsonResponse({'status_code': 0, 'status_message' : 'You can not login with Django admin credentials here.'})
					# return HttpResponse('2')
				else:
					admin_obj = User.objects.filter(id=int(user.id),is_staff = True).first()
					if admin_obj:
						obj = Admin.objects.filter(user = admin_obj).first()
						if obj:
							request.session['userrole'] = 'admin'
							token = Token.objects.get_or_create(user=user)
							return JsonResponse({'status_code': 200, 'user' : 'admin', 'status_message' : 'admin login successfull', 'redirectlink' : redirectlink})
						else:
							return JsonResponse({'status_code': 0, 'status_message' : 'You can not login with Django admin credentials here.'})
				return JsonResponse({'status_code': 0, 'status_message' : 'Invalid Credentials.'})
			else:
				return JsonResponse({'status_code': 0, 'status_message' : 'Invalid Credentials.'})
		except Exception as error:
			print('error is',error)
			return JsonResponse({'status_code': 0, 'status_message' : str(error)})

	

