from django.contrib.auth.models import User
from AdminApp.models import Admin, Notifications
from Customer.models import Customer
from Driver.models import DriverModel
from django.conf import settings

def getunreadnotificationcount(request):
	unread_notifications_count = 0
	if request.session.has_key('email'):
		email_val = request.session['email']
		user_obj = User.objects.filter(email = email_val).first()
		if user_obj:
			unread_notifications_count = Notifications.objects.filter(user = user_obj, status = 'unread', deleted = False).count()
	# print(unread_notifications_count)
	return {'unread_notifications_count': str(unread_notifications_count)}
	

def getuserdetails(request):
	unread_notifications_count = 0
	userdetails_obj = []
	image = ''
	if request.session.has_key('email'):
		email_val = request.session['email']
		user_obj = User.objects.filter(email = email_val).first()
		if user_obj:
			unread_notifications_count = Notifications.objects.filter(user = user_obj, status = 'unread', deleted = False).count()
			if request.session.has_key('userrole'):
				if request.session['userrole'] == 'customer' or request.session['userrole'] == 'company':
					userdetails_obj = Customer.objects.filter(user = user_obj).first()
				elif request.session['userrole'] == 'driver':
					userdetails_obj = DriverModel.objects.filter(user = user_obj).first()
				elif request.session['userrole'] == 'admin' or request.session['userrole'] == 'superadmin':
					userdetails_obj = Admin.objects.filter(user = user_obj).first()

				if userdetails_obj.image:
					image = str(settings.WEB_BASE_URL) + userdetails_obj.image.name
				else:
					image = ''

	# print(unread_notifications_count) 
	# print(image)
	return {'userdetail': userdetails_obj, 'userimage': image, 'unread_notifications_count': str(unread_notifications_count)}
	
