# Generated by Django 2.2 on 2022-01-07 09:52

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('AdminApp', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CreditsRequested',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('company_email', models.CharField(blank=True, max_length=100, null=True)),
                ('credits', models.FloatField(blank=True, default=0.0, null=True)),
                ('note_by_company', models.TextField()),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('approved', 'Approved'), ('disapproved', 'Disapproved')], default='pending', max_length=100)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.CharField(blank=True, default='customer', max_length=100, null=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True, unique=True)),
                ('countrycode', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, max_length=100, null=True)),
                ('image', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('address', models.TextField(blank=True, null=True)),
                ('idproof', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('fcmtoken', models.CharField(blank=True, max_length=300, null=True)),
                ('emailverificationlink', models.CharField(blank=True, max_length=300, null=True)),
                ('forgot_password_link', models.CharField(blank=True, max_length=500, null=True)),
                ('emailverified', models.BooleanField(default=False)),
                ('accountverified', models.BooleanField(default=False)),
                ('accountapproved', models.BooleanField(default=False)),
                ('isdisabled', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='CustomerJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Parcel Pending'), (1, 'Parcel Assigned'), (2, 'Parcel Delivered')], default=0)),
                ('sendername', models.CharField(blank=True, max_length=100, null=True)),
                ('senderemail', models.CharField(blank=True, max_length=100, null=True)),
                ('sendercountrycode', models.CharField(blank=True, max_length=100, null=True)),
                ('senderphone', models.CharField(blank=True, max_length=100, null=True)),
                ('pickupaddress', models.CharField(blank=True, max_length=300, null=True)),
                ('sendercity', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('senderlatitude', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('senderlongitude', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('pickupspecialnote', models.TextField()),
                ('pickupdatetime', models.DateTimeField(blank=True, null=True)),
                ('noofparcels', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('no_of_item_in_parcel', models.IntegerField(default=0, null=True)),
                ('recipientname', models.CharField(blank=True, max_length=100, null=True)),
                ('recipientcountrycode', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('recipientphone', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('recipientlatitude', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('recipientlongitude', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('dropoffaddress', models.CharField(blank=True, max_length=300, null=True)),
                ('dropoffspecialnote', models.TextField()),
                ('dropoffdatetime', models.DateTimeField(blank=True, null=True)),
                ('deliveryduration', models.IntegerField(choices=[(0, 'Same Day Delivery'), (1, 'Two Days Delivery'), (2, 'Multiple Days Delivery')], default=0)),
                ('length', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('width', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('height', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('weight', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('parceltype', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('pickuptimeslotDate', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('pickuptimeslot', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('dropofftimeslot', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('price', models.FloatField(blank=True, default=0.0, null=True)),
                ('specialbooking_charge', models.FloatField(blank=True, default=0.0, null=True)),
                ('image', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('qrcode', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('parcelpdf', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('specialbooking', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
                ('isdisabled', models.BooleanField(default=False)),
                ('deliverySafePlace', models.BooleanField(default=False)),
                ('creation_date', models.DateField(default=datetime.date.today)),
                ('comment_of_Parcel', models.CharField(blank=True, max_length=300, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sameIdForParcelsDetails', models.IntegerField(default=0)),
                ('priorityBaseIDForParcel', models.IntegerField(default=1)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ordertype', models.IntegerField(choices=[(1, 'Single'), (2, 'Multi-Drop')], default=0)),
                ('charge_from_card', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('totalamount', models.FloatField(blank=True, default=0.0, null=True)),
                ('parceldelivery_charges', models.FloatField(blank=True, default=0.0, null=True)),
                ('specialbooking_charges', models.FloatField(blank=True, default=0.0, null=True)),
                ('status', models.IntegerField(choices=[(0, 'Pending'), (1, 'Completed')], default=0)),
                ('creation_date', models.DateField(default=datetime.date.today)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('isdeleted', models.BooleanField(default=False)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='StoredCard',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_customer_id', models.CharField(blank=True, max_length=100, null=True)),
                ('stripe_card_id', models.CharField(blank=True, max_length=100, null=True)),
                ('stripe_card_number_lastfourdigits', models.CharField(blank=True, max_length=100, null=True)),
                ('stripe_card_exp_month', models.CharField(blank=True, max_length=100, null=True)),
                ('stripe_card_exp_year', models.CharField(blank=True, max_length=100, null=True)),
                ('is_default', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='RepeatOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('base_customerjob_id', models.CharField(blank=True, max_length=100, null=True)),
                ('repeat_date_string', models.CharField(blank=True, max_length=100, null=True)),
                ('repeat_after_days', models.CharField(blank=True, max_length=100, null=True)),
                ('start_date', models.CharField(blank=True, max_length=100, null=True)),
                ('end_date', models.CharField(blank=True, max_length=100, null=True)),
                ('pickuptimeslot', models.CharField(blank=True, max_length=100, null=True)),
                ('dropofftimeslot', models.CharField(blank=True, max_length=100, null=True)),
                ('last_booking_date', models.CharField(blank=True, max_length=100, null=True)),
                ('is_cancelled', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='OrderPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.CharField(blank=True, default='card', max_length=100, null=True)),
                ('credits_to_be_used', models.FloatField(blank=True, default=0.0, null=True)),
                ('stripe_charge_response', models.TextField()),
                ('stripe_charge_id', models.CharField(blank=True, max_length=100, null=True)),
                ('stripe_amount', models.FloatField(blank=True, default=0.0, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('order', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.Order')),
            ],
        ),
        migrations.CreateModel(
            name='DisputeMessageThreadModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customerjob', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
            ],
        ),
        migrations.CreateModel(
            name='DisputeMessageModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.TextField()),
                ('fromuser', models.BooleanField(default=False)),
                ('touser', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now=True)),
                ('updated_at', models.DateTimeField(auto_now_add=True)),
                ('customerjob', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
                ('disputemessagethread', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.DisputeMessageThreadModel')),
            ],
        ),
        migrations.CreateModel(
            name='CustomerJobPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.CharField(blank=True, default='card', max_length=100, null=True)),
                ('credits_to_be_used', models.FloatField(blank=True, default=0.0, null=True)),
                ('stripe_charge_response', models.TextField()),
                ('stripe_charge_id', models.CharField(blank=True, max_length=100, null=True)),
                ('stripe_amount', models.FloatField(blank=True, default=0.0, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('job', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
            ],
        ),
        migrations.CreateModel(
            name='CustomerJobDeliveryFailed',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deliveryfailed_image', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('deliveryfailed_datetime', models.DateTimeField(blank=True, null=True)),
                ('deliveryfailurereason', models.CharField(blank=True, max_length=100, null=True)),
                ('isdeleted', models.BooleanField(default=False)),
                ('job', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
            ],
        ),
        migrations.CreateModel(
            name='CustomerJobDeliveryExtraDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pickup_proof_method', models.CharField(blank=True, max_length=100, null=True)),
                ('pickup_fromperson_name', models.CharField(blank=True, max_length=100, null=True)),
                ('pickup_fromperson_signature', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('pickup_otp', models.CharField(blank=True, max_length=100, null=True)),
                ('delivery_proof_method', models.CharField(blank=True, max_length=100, null=True)),
                ('delivery_toperson_name', models.CharField(blank=True, max_length=100, null=True)),
                ('delivery_toperson_signature', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('delivery_otp', models.CharField(blank=True, max_length=100, null=True)),
                ('job', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
            ],
        ),
        migrations.CreateModel(
            name='CustomerJobDateTime',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payment_datetime', models.DateTimeField(blank=True, null=True)),
                ('driver_job_started_datetime', models.DateTimeField(blank=True, null=True)),
                ('driver_pickuparrived_datetime', models.DateTimeField(blank=True, null=True)),
                ('pickup_datetime', models.DateTimeField(blank=True, null=True)),
                ('startDropOffTime', models.DateTimeField(blank=True, null=True)),
                ('arrivedDropOffLocation', models.DateTimeField(blank=True, null=True)),
                ('itemsdelivered_datetime', models.DateTimeField(blank=True, null=True)),
                ('deliveryfailed_datetime', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('job', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
            ],
        ),
        migrations.AddField(
            model_name='customerjob',
            name='order',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.Order'),
        ),
        migrations.AddField(
            model_name='customerjob',
            name='vehicletype',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='AdminApp.VehicleType'),
        ),
        migrations.CreateModel(
            name='CompanyDetail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('job_title', models.CharField(blank=True, max_length=100, null=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('website', models.CharField(blank=True, max_length=100, null=True)),
                ('monthly_delivery_volume', models.CharField(blank=True, max_length=100, null=True)),
                ('registration_number', models.CharField(blank=True, max_length=100, null=True)),
                ('industry', models.CharField(blank=True, max_length=100, null=True)),
                ('credits', models.FloatField(blank=True, default=0.0, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('customer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True, unique=True)),
                ('countrycode', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, max_length=100, null=True)),
                ('image', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('address', models.TextField(blank=True, null=True)),
                ('tinnumber', models.CharField(blank=True, max_length=100, null=True)),
                ('fcmtoken', models.CharField(blank=True, max_length=300, null=True)),
                ('emailverificationlink', models.CharField(blank=True, max_length=300, null=True)),
                ('emailverified', models.BooleanField(default=False)),
                ('accountapproved', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
