from django.db import models
from django.contrib.auth.models import User
from django.utils.translation import gettext as _
from django.contrib.contenttypes.fields import GenericForeignKey
from django.contrib.contenttypes.models import ContentType
from AdminApp.models import *
import datetime

# Create your models here.

class Customer(models.Model):
	"""
	This model is used to store the information of Customer.
	"""
	user = models.ForeignKey(User, on_delete = models.CASCADE, null = True, blank = True)
	# country = models.ForeignKey(Country, on_delete = models.CASCADE, null = True, blank = True)
	# city = models.ForeignKey(City, on_delete = models.CASCADE, null = True, blank = True)
	role = models.CharField(max_length = 100, default = 'customer', null = True, blank = True)
	name = models.CharField(max_length = 100, null = True, blank = True)
	email = models.CharField(max_length = 100, unique = True, null = True, blank = True)
	countrycode = models.CharField(max_length = 100, null = True, blank = True)
	phone = models.CharField(max_length = 100, blank = True, null = True)
	image = models.FileField(max_length = 200, blank = True, null = True)
	address = models.TextField(blank = True, null = True)
	idproof = models.FileField(max_length = 200, blank = True, null = True)
	fcmtoken = models.CharField(max_length = 300, blank = True, null = True)
	emailverificationlink = models.CharField(max_length = 300, blank = True, null = True)
	forgot_password_link = models.CharField(max_length = 500, blank = True, null = True)
	emailverified = models.BooleanField(default = False)
	accountverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)
	
	def __str__(self):
		return str(self.user)


class StoredCard(models.Model):
	"""
	This model is used to store the information of Customer.
	"""
	customer = models.ForeignKey(Customer, on_delete = models.CASCADE, null = True, blank = True)
	
	stripe_customer_id = models.CharField(max_length = 100, null = True, blank = True)
	stripe_card_id = models.CharField(max_length = 100, null = True, blank = True)
	stripe_card_number_lastfourdigits = models.CharField(max_length = 100, null = True, blank = True)
	stripe_card_exp_month = models.CharField(max_length = 100, null = True, blank = True)
	stripe_card_exp_year = models.CharField(max_length = 100, null = True, blank = True)

	is_default = models.BooleanField(default = False)

	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)
	
	def __str__(self):
		return str(str(self.customer) + ' - ' + str(self.stripe_customer_id) + ' - ' + str(self.stripe_card_id) + ' - ' + str(self.is_default))



class CompanyDetail(models.Model):
	"""
	This model is used to store the information of Customer.
	"""
	customer = models.ForeignKey(Customer, on_delete = models.CASCADE, null = True, blank = True)
	
	job_title = models.CharField(max_length = 100, null = True, blank = True)
	name = models.CharField(max_length = 100, null = True, blank = True)
	website = models.CharField(max_length = 100, null = True, blank = True)
	monthly_delivery_volume = models.CharField(max_length = 100, null = True, blank = True)
	registration_number = models.CharField(max_length = 100, blank = True, null = True)
	industry =models.CharField(max_length = 100, blank = True, null = True)
	credits = models.FloatField(default = 0.0, blank = True, null = True)
	
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)
	
	def __str__(self):
		return str(self.customer)

class Company(models.Model):
	"""
	This model is used to store the information of Company.
	"""
	user = models.ForeignKey(User, on_delete = models.CASCADE, blank = True, null = True)
	name = models.CharField(max_length = 100, blank = True, null = True)
	email = models.CharField(max_length = 100, unique = True, blank = True, null = True)
	countrycode = models.CharField(max_length = 100, blank = True, null = True)
	phone = models.CharField(max_length = 100, blank = True, null = True)
	# country = models.ForeignKey(Country, on_delete = models.CASCADE, null = True, blank = True)
	# city = models.ForeignKey(City, on_delete = models.CASCADE, null = True, blank = True)
	image = models.FileField(max_length = 200, blank = True, null = True)
	address = models.TextField(blank = True, null = True)
	tinnumber = models.CharField(max_length = 100, null = True, blank = True)
	fcmtoken = models.CharField(max_length = 300, blank = True, null = True)
	emailverificationlink = models.CharField(max_length = 300, blank = True, null = True)
	emailverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)

	def __str__(self):
		return str(self.user)

DELIVERYDURATION_CHOICES = (
    (0, _("Same Day Delivery")),
    (1, _("Two Days Delivery")),
    (2, _("Multiple Days Delivery")),
)

PARCELSTATUS_CHOICES = (
    (0, _("Parcel Pending")),
    (1, _("Parcel Assigned")),
    (2, _("Parcel Delivered")),
)

ORDERSTATUS_CHOICES = (
    (0, _("Pending")),
    (1, _("Completed")),
)

ORDERTYPE_CHOICES = (
    (1, _("Single")),
    (2, _("Multi-Drop")),
)

CREDITSREQUEST_STATUS_CHOICES = (
    ('pending', _("Pending")),
    ('approved', _("Approved")),
    ('disapproved', _("Disapproved")),
)



class RepeatOrder(models.Model):
	"""
	This model is used to store the information of Order table.
	"""
	customer = models.ForeignKey(Customer, on_delete = models.CASCADE, null = True, blank = True)
	base_customerjob_id = models.CharField(max_length = 100, blank = True, null = True)
	repeat_date_string = models.CharField(max_length = 100, blank = True, null = True)
	repeat_after_days = models.CharField(max_length = 100, blank = True, null = True)
	start_date = models.CharField(max_length = 100, blank = True, null = True)
	end_date = models.CharField(max_length = 100, blank = True, null = True)
	pickuptimeslot = models.CharField(max_length = 100, blank = True, null = True)
	dropofftimeslot = models.CharField(max_length = 100, blank = True, null = True)
	last_booking_date = models.CharField(max_length = 100, blank = True, null = True)

	is_cancelled = models.BooleanField(default = False)
	
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)
	
	def __str__(self):
		return (str(self.id) + ' - ' + str(self.base_customerjob_id) + ' - ' + str(self.repeat_after_days) + ' - ' + str(self.start_date))


class CreditsRequested(models.Model):
	"""
	This model is used to store the information of Order table.
	"""
	company_email = models.CharField(max_length = 100, blank = True, null = True)
	credits = models.FloatField(default = 0.0, blank = True, null = True)
	note_by_company = models.TextField()
	status = models.CharField(max_length = 100, choices = CREDITSREQUEST_STATUS_CHOICES, default = 'pending') # default = Pending
	
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)
	
	def __str__(self):
		return (str(self.id) + ' - ' + str(self.company_email) + ' - ' + str(self.credits) + ' - ' + str(self.status))


class Order(models.Model):
	"""
	This model is used to store the information of Order table.
	"""
	customer = models.ForeignKey(Customer, on_delete = models.CASCADE, null = True, blank = True)
	ordertype = models.IntegerField(choices=ORDERTYPE_CHOICES, default=0) # default = Single
	charge_from_card = models.CharField(max_length = 100, default = '', blank = True, null = True)
	totalamount = models.FloatField(default = 0.0, blank = True, null = True)
	parceldelivery_charges = models.FloatField(default = 0.0, blank = True, null = True)
	specialbooking_charges = models.FloatField(default = 0.0, blank = True, null = True)
	
	status = models.IntegerField(choices=ORDERSTATUS_CHOICES, default=0) # default = Pending

	creation_date = models.DateField(default = datetime.date.today)

	created_at = models.DateTimeField(auto_now_add = True)
	updated_at = models.DateTimeField(auto_now = True)
	isdeleted = models.BooleanField(default = False)


	def __str__(self):
		return (str(self.id) + ' - ' + str(self.customer) + ' - ' + str(self.status))

class OrderPayment(models.Model):
	"""
	This model is used to store the information of Order table.
	"""
	order = models.ForeignKey(Order, on_delete = models.CASCADE, null = True, blank = True)
	method = models.CharField(max_length = 100, default = 'card', blank = True, null = True)
	credits_to_be_used = models.FloatField(default = 0.0, blank = True, null = True)
	stripe_charge_response = models.TextField()
	stripe_charge_id = models.CharField(max_length = 100, blank = True, null = True)
	stripe_amount = models.FloatField(default = 0.0, blank = True, null = True)

	created_at = models.DateTimeField(auto_now_add = True)
	updated_at = models.DateTimeField(auto_now = True)
	
	def __str__(self):
		return (str(self.id) + ' - ' + str(self.order))


class CustomerJob(models.Model):
	"""
	This model is used to store the information of CustomerJob.
	"""
	# content_type = models.ForeignKey(ContentType, on_delete = models.CASCADE, null = True)
	# object_id = models.PositiveIntegerField()
	# content_object = GenericForeignKey('content_type', 'object_id')

	order = models.ForeignKey(Order, on_delete = models.CASCADE, null = True, blank = True)
	customer = models.ForeignKey(Customer, on_delete = models.CASCADE, null = True, blank = True)
	status = models.IntegerField(choices=PARCELSTATUS_CHOICES, default=0) # default = Pending
	sendername = models.CharField(max_length = 100, blank = True, null = True)
	senderemail = models.CharField(max_length = 100, blank = True, null = True)
	sendercountrycode = models.CharField(max_length = 100, blank = True, null = True)
	senderphone = models.CharField(max_length = 100, blank = True, null = True)
	pickupaddress = models.CharField(max_length = 300, blank = True, null = True)
	sendercity = models.CharField(max_length = 100, default = '', blank = True, null = True)
	senderlatitude = models.CharField(max_length = 100, default = '', blank = True, null = True)
	senderlongitude = models.CharField(max_length = 100, default = '', blank = True, null = True)
	pickupspecialnote = models.TextField()
	pickupdatetime = models.DateTimeField( blank = True, null = True)
	noofparcels = models.CharField(max_length = 100, default = '', blank = True, null = True)
	no_of_item_in_parcel = models.IntegerField(null = True,default=0) # default = Single
	recipientname = models.CharField(max_length = 100, blank = True, null = True)
	recipientcountrycode = models.CharField(max_length = 100, default = '', blank = True, null = True)
	recipientphone = models.CharField(max_length = 100, default = '', blank = True, null = True)
	recipientlatitude = models.CharField(max_length = 100, default = '', blank = True, null = True)
	recipientlongitude = models.CharField(max_length = 100, default = '', blank = True, null = True)
	dropoffaddress = models.CharField(max_length = 300, blank = True, null = True)
	dropoffspecialnote = models.TextField()
	dropoffdatetime = models.DateTimeField( blank = True, null = True)

	deliveryduration = models.IntegerField(choices = DELIVERYDURATION_CHOICES, default = 0) # default - same day

	length = models.CharField(max_length = 100, default = '', blank = True, null = True)
	width = models.CharField(max_length = 100, default = '', blank = True, null = True)
	height = models.CharField(max_length = 100, default = '', blank = True, null = True)
	weight = models.CharField(max_length = 100, default = '', blank = True, null = True)
	parceltype = models.CharField(max_length = 100, default = '', blank = True, null = True)

	pickuptimeslotDate = models.CharField(max_length = 100, default = '', blank = True, null = True)
	pickuptimeslot = models.CharField(max_length = 100, default = '', blank = True, null = True)
	dropofftimeslot = models.CharField(max_length = 100, default = '', blank = True, null = True)

	
	vehicletype = models.ForeignKey(VehicleType, on_delete = models.SET_NULL, blank = True, null = True)
	price = models.FloatField(default = 0.0, blank = True, null = True)
	specialbooking_charge = models.FloatField(default = 0.0, blank = True, null = True)
	image = models.FileField(max_length = 200, blank = True, null = True)

	qrcode = models.FileField(max_length = 200, blank = True, null = True)
	parcelpdf = models.FileField(max_length = 200, blank = True, null = True)

	specialbooking = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)


	deliverySafePlace = models.BooleanField(default = False)
	creation_date = models.DateField(default = datetime.date.today)
	comment_of_Parcel = models.CharField(max_length = 300, blank = True, null = True)
	created_at = models.DateTimeField(auto_now_add = True)
	updated_at = models.DateTimeField(auto_now = True)
	sameIdForParcelsDetails=models.IntegerField(default = 0)
	priorityBaseIDForParcel=models.IntegerField(default = 1)


	def __str__(self):
		# return str(str(self.id) + ' - ' + str(self.order.id) + ' - ' + str(self.customer))
		if self.order:
			return str(str(self.id) + ' - ' + str(self.customer)+ ' - ' + str(self.order.id))
		else:
			return str(str(self.id) + ' - ' + str(self.customer))


class CustomerJobPayment(models.Model):
	"""
	This model is used to store the information of Order table.
	"""
	job = models.ForeignKey(CustomerJob, on_delete = models.CASCADE, null = True, blank = True)
	method = models.CharField(max_length = 100, default = 'card', blank = True, null = True)
	credits_to_be_used = models.FloatField(default = 0.0, blank = True, null = True)
	stripe_charge_response = models.TextField()
	stripe_charge_id = models.CharField(max_length = 100, blank = True, null = True)
	stripe_amount = models.FloatField(default = 0.0, blank = True, null = True)

	created_at = models.DateTimeField(auto_now_add = True)
	updated_at = models.DateTimeField(auto_now = True)
	
	def __str__(self):
		return (str(self.id) + ' - ' + str(self.job))


class CustomerJobDateTime(models.Model):
	job = models.ForeignKey(CustomerJob,on_delete = models.CASCADE, null = True, blank = True)
	payment_datetime = models.DateTimeField(null = True, blank = True)
	driver_job_started_datetime = models.DateTimeField(null = True, blank = True)
	driver_pickuparrived_datetime = models.DateTimeField(null = True, blank = True)
	pickup_datetime = models.DateTimeField(null = True, blank = True) 
	startDropOffTime = models.DateTimeField(null = True, blank = True)
	arrivedDropOffLocation = models.DateTimeField(null = True, blank = True)
	itemsdelivered_datetime = models.DateTimeField(null = True, blank = True)
	deliveryfailed_datetime = models.DateTimeField(null = True, blank = True)

	created_at = models.DateTimeField(auto_now_add = True)
	updated_at = models.DateTimeField(auto_now = True)

	def __str__(self):
		return str(self.job)

class CustomerJobDeliveryFailed(models.Model):
	deliveryfailed_image = models.FileField(max_length = 200, blank = True, null = True)
	job = models.ForeignKey(CustomerJob, on_delete = models.CASCADE, null = True, blank = True)
	deliveryfailed_datetime = models.DateTimeField(null = True, blank = True)
	deliveryfailurereason = models.CharField(max_length = 100, blank = True, null = True)
	isdeleted=models.BooleanField(default = False)
	def __str__(self):
		return str(self.job)

class CustomerJobDeliveryExtraDetails(models.Model):
	job = models.ForeignKey(CustomerJob, on_delete = models.CASCADE, null = True, blank = True)
	pickup_proof_method = models.CharField(max_length = 100, blank = True, null = True)
	pickup_fromperson_name = models.CharField(max_length = 100, blank = True, null = True)
	pickup_fromperson_signature = models.FileField(max_length = 200, blank = True, null = True)
	pickup_otp = models.CharField(max_length = 100, blank = True, null = True)

	delivery_proof_method = models.CharField(max_length = 100, blank = True, null = True)
	delivery_toperson_name = models.CharField(max_length = 100, blank = True, null = True)
	delivery_toperson_signature = models.FileField(max_length = 200, blank = True, null = True)
	delivery_otp = models.CharField(max_length = 100, blank = True, null = True)
	
	def __str__(self):
		return str(self.job)




class DisputeMessageThreadModel(models.Model):
    customerjob = models.ForeignKey(CustomerJob, on_delete = models.CASCADE, null = True, blank = True)
	    
    def __str__(self):
        return str(self.id)


class DisputeMessageModel(models.Model):
    disputemessagethread = models.ForeignKey(DisputeMessageThreadModel,on_delete=models.CASCADE,null=True,blank=True)
    customerjob = models.ForeignKey(CustomerJob, on_delete = models.CASCADE, null = True, blank = True)
    message = models.TextField()
    fromuser = models.BooleanField(default = False)
    touser = models.BooleanField(default = False)
    created_at = models.DateTimeField(auto_now=True)
    updated_at = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return str(self.id)






# user = models.ForeignKey(User,on_delete=models.SET_NULL,null=True,blank=True)