
from django.urls import path
from django.conf.urls import url
from .views import *
from . import views
from django.views.decorators.csrf import csrf_exempt

urlpatterns = [
	path('test/', TestWeb.as_view(), name = 'test-web'),
	path('login/', CustomerLogin.as_view(), name = 'customer-login'),
	path('registrationotp/', RegistrationOTP.as_view(), name = 'registration-otp'),
	path('register/', CustomerRegistration.as_view(), name = 'customer-registration'),
	path('resendotp/', csrf_exempt(ResendOTP.as_view()), name = 'resend-otp'),
	path('logout/', Logout.as_view(), name = 'logout'),
	path('quickfareestimate/', QuickFareEstimate.as_view(), name = 'quick-fare-estimate'),
	path('getfares/test/', GetFaresTest.as_view(), name = 'get-fares-test'), #acc to requirement 27-07-2020
	path('getfares/', GetFares.as_view(), name = 'get-fares'),
	path('placeorder/', PlaceOrder.as_view(), name = 'place-order'),
	path('placeorder/test/', PlaceOrderTest.as_view(), name = 'place-order-test'), # apiview - parcel save code #commented by manpreet singh on 16/12/2020
	path('placeorder/test2/', PlaceOrderTest2NEW.as_view(), name = 'place-order-test'), # apiview - parcel save code
	# path('placeorder/test2/', PlaceOrderTest2.as_view(), name = 'place-order-test-2'), # actual flow test
	path('placeorder/test3/', PlaceOrderTest3.as_view(), name = 'place-order-test-3'), # saved cards at checkout
	path('myjobs/ongoing/test/', MyJobsOngoingExtraTest.as_view(), name = 'my-jobs-ongoing-test'),
	path('getallparcels/', views.get_all_parcels, name = 'get-all-parcels'),
	path('myjobs/ongoing/', MyJobsOngoing.as_view(), name = 'my-jobs-ongoing'),
	path('myjobs/completed/', MyJobsCompletedExtraTest.as_view(), name = 'my-jobs-completed'),
	path('myjobs/', MyJobs.as_view(), name = 'my-jobs'),


	path('cancelOrder/', views.cancelOrder, name = 'get-all-parcels'),
	url(r'^customer/jobdetail/ExtraTest/(?P<customerjobid>\d+)/$', CustomerJobDetail.as_view(), name = 'customer-job-detail'),
	url(r'^customer/jobdetail/(?P<customerjobid>\d+)/$',CustomerJobDetailExtraTest.as_view(), name = 'customer-job-detail'),
	url(r'^customer/jobdetail/(?P<customerjobid>\d+)/raiseticket/$', CustomerJobRaiseTicket.as_view(), name = 'customer-job-raise-ticket'),

	path('customer/dashboard/', CustomerDashboard.as_view(), name = 'customer-dashboard'),
	path('company/dashboard/', CompanyDashboard.as_view(), name = 'company-dashboard'),

	path('customer/notifications/', CustomerNotifications.as_view(), name = 'customer-notifications'),

	path('customer/profile/', CustomerProfile.as_view(), name = 'customer-profile'),
	path('company/Profile/', CompanyProfile.as_view(), name = 'company-profile'),

	path('customer/profile/update', CustomerProfileUpdate.as_view(), name = 'customer-profile-update'),
	path('company/Profile/update', CompanyProfileUpdate.as_view(), name = 'company-profile-update'),

	url(r'^user/driver/forgot/', VerifyForgotPassword.as_view(), name='driver-verify-forgot-password-api'),
	url(r'^user/driver', UserVerificationDriver.as_view(), name='user-verification-driver'),

	path('changepassword/', ChangePassword.as_view(), name = 'change-password'),
	path('forgotpassword/', ForgotPassword.as_view(), name = 'forgot-password'),
	url(r'^user/(?P<userrole>\w+)/forgot/', CustomerVerifyForgotPassword.as_view(), name='customer-verify-forgot-password'),

	url(r'^user/(?P<userrole>\w+)/verify/', UserVerification.as_view(), name='user-verification'),

	# path('', CustomerDashboard.as_view(), name = 'login'),
	path('aboutus/', AboutUs.as_view(), name = 'about-us'),
	path('termsandconditions/', TermsAndConditions.as_view(), name = 'terms-and-conditions'),
	path('tutorial/', TutorialView.as_view(), name = 'tutorial'),
	path('functional_document/', FunctionalDocument.as_view(), name = 'functional-document'),
	path('contactform/', ContactForm.as_view(), name = 'contact-form'),

	path('company/makecreditrequest/', CompanyMakeCreditrequest.as_view(), name = 'company-make-credit-request'),
	path('company/placeorder/', CompanyPlaceOrder.as_view(), name = 'company-place-order'), # actual flow test

	path('company/showallcreditrequests/', CompanyCreditRequests.as_view(), name = 'company-show-all-credit-requests'),
	path('customer/wallet/', CustomerWallet.as_view(), name = 'customer-wallet'),
	path('customer/addcard/', CustomerAddCard.as_view(), name = 'customer-add-card'),
	path('customer/deletecard/', views.delete_card, name = 'customer-delete-card'),

	path('company/wallet/', CustomerWallet.as_view(), name = 'customer-wallet'),
	path('company/addcard/', CustomerAddCard.as_view(), name = 'customer-add-card'),
	path('company/deletecard/', views.delete_card, name = 'customer-delete-card'),

	path('', Index.as_view(), name = 'index'),
]






	