from django.shortcuts import render
from django.views.generic.base import TemplateView, View
from django.http import HttpResponse, JsonResponse, HttpResponseRedirect
from django.contrib.auth import authenticate
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from rest_framework.views import APIView
from .decorators import checklogincustomer, checklogincompany, checkifcustomeralreadylogin
from django.utils.decorators import method_decorator
from Customer.models import *
from Customer.commonfunctions import sendfcmnotification
from Driver.models import *
from AdminApp.models import *
from AdminApp.adminfunctions import assigndriverforparcel
from django.shortcuts import redirect
from django.urls import reverse
import math, random, datetime, pytz, string
from django.conf import settings
from django.core.mail import send_mail
from datetime import timedelta
import requests, json
from .commonfunctions import getunreadnotificationcount, generateparcelpdf
from django.contrib.auth.hashers import make_password
import sys, stripe
from django.core.paginator import Paginator
import base64, os
from io import BytesIO
from PIL import Image
from django.http import HttpResponseRedirect

def createDriverSlots(driverID):
	driver_obj = DriverModel.objects.filter(id = driverID).first()
	# print("DriverTimeSlots-in get ")
	# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
	driverslotsobj=DriverAllSlots.objects.create(driver=driver_obj)
	if driverslotsobj:
		driverslotsobj.openinghourSlot1='00:00:00'
		driverslotsobj.closinghourSlot1='01:00:00'
		driverslotsobj.activeSlot1=True
		driverslotsobj.openinghourSlot2='01:00:00'
		driverslotsobj.closinghourSlot2='02:00:00'
		driverslotsobj.activeSlot2=True
		driverslotsobj.openinghourSlot3='02:00:00'
		driverslotsobj.closinghourSlot3='03:00:00'
		driverslotsobj.activeSlot3=True
		driverslotsobj.openinghourSlot4='03:00:00'
		driverslotsobj.closinghourSlot4='04:00:00'
		driverslotsobj.activeSlot4=True
		driverslotsobj.openinghourSlot5='04:00:00'
		driverslotsobj.closinghourSlot5='05:00:00'
		driverslotsobj.activeSlot5=True
		driverslotsobj.openinghourSlot6='05:00:00'
		driverslotsobj.closinghourSlot6='06:00:00'
		driverslotsobj.activeSlot6=True
		driverslotsobj.openinghourSlot7='06:00:00'
		driverslotsobj.closinghourSlot7='07:00:00'
		driverslotsobj.activeSlot7=True
		driverslotsobj.openinghourSlot8='07:00:00'
		driverslotsobj.closinghourSlot8='08:00:00'
		driverslotsobj.activeSlot8=True
		driverslotsobj.openinghourSlot9='08:00:00'
		driverslotsobj.closinghourSlot9='09:00:00'
		driverslotsobj.activeSlot9=True
		driverslotsobj.openinghourSlot10='09:00:00'
		driverslotsobj.closinghourSlot10='10:00:00'
		driverslotsobj.activeSlot10=True
		driverslotsobj.openinghourSlot11='10:00:00'
		driverslotsobj.closinghourSlot11='11:00:00'
		driverslotsobj.activeSlot11=True
		driverslotsobj.openinghourSlot12='11:00:00'
		driverslotsobj.closinghourSlot12='12:00:00'
		driverslotsobj.activeSlot12=True
		driverslotsobj.openinghourSlot13='12:00:00'
		driverslotsobj.closinghourSlot13='13:00:00'
		driverslotsobj.activeSlot13=True
		driverslotsobj.openinghourSlot14='13:00:00'
		driverslotsobj.closinghourSlot14='14:00:00'
		driverslotsobj.activeSlot14=True
		driverslotsobj.openinghourSlot15='14:00:00'
		driverslotsobj.closinghourSlot15='15:00:00'
		driverslotsobj.activeSlot15=True
		driverslotsobj.openinghourSlot16='15:00:00'
		driverslotsobj.closinghourSlot16='16:00:00'
		driverslotsobj.activeSlot16=True
		driverslotsobj.openinghourSlot17='16:00:00'
		driverslotsobj.closinghourSlot17='17:00:00'
		driverslotsobj.activeSlot17=True
		driverslotsobj.openinghourSlot18='17:00:00'
		driverslotsobj.closinghourSlot18='18:00:00'
		driverslotsobj.activeSlot18=True
		driverslotsobj.openinghourSlot19='18:00:00'
		driverslotsobj.closinghourSlot19='19:00:00'
		driverslotsobj.activeSlot19=True
		driverslotsobj.openinghourSlot20='19:00:00'
		driverslotsobj.closinghourSlot20='20:00:00'
		driverslotsobj.activeSlot120=True
		driverslotsobj.openinghourSlot21='20:00:00'
		driverslotsobj.closinghourSlot21='21:00:00'
		driverslotsobj.activeSlot21=True
		driverslotsobj.openinghourSlot22='21:00:00'
		driverslotsobj.closinghourSlot22='22:00:00'
		driverslotsobj.activeSlot22=True
		driverslotsobj.openinghourSlot23='22:00:00'
		driverslotsobj.closinghourSlot23='23:00:00'
		driverslotsobj.activeSlot23=True
		driverslotsobj.openinghourSlot24='23:00:00'
		driverslotsobj.closinghourSlot24='00:00:00'
		driverslotsobj.activeSlot24=True
		driverslotsobj.save()
		return '1'
	return '0'

def convert24(str1):
	if str1[-2:] == "AM" and str1[:2] == "12":
		res= "00" + str1[2:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	elif str1[-2:] == "AM":
		res= str1[:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	elif str1[-2:] == "PM" and str1[:2] == "12":
		res= str1[:-2]
		res=res.replace(" ","")
		res=res+":00"
		return res
	else:
		res= str(int(str1[:2]) + 12) + str1[2:6]
		res=res+":00"
		res=res.replace(" ","")
		return res

def makeslotAvailable(slotId,slotId2,DriverID):
	try:
		slotId=slotId+1
		driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver_obj).first()
		if driverslotsobj:
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=True
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=True
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=True
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=True
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=True
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=True
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=True
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=True
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=True
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=True
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=True
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=True
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=True
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=True
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=True
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=True
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=True
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=True
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=True
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=True
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=True
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=True
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=True
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=True
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'

def makeslotAvailablenew(slotId,slotId2,driveridforslots):
	try:
		slotId=slotId+1
		# driver_obj = DriverModel.objects.filter(id = DriverID).first()
		# print("DriverTimeSlots-in get ")
		# alltimeslots = DriverAllSlots.objects.filter(driver=driver_obj).first()
		driverslotsobj=DriverAllSlots.objects.filter(id=driveridforslots).first()
		if driverslotsobj:
			if slotId<=1 and slotId2>=1:
				driverslotsobj.activeSlot1=True
			if slotId<=2 and slotId2>=2:
				driverslotsobj.activeSlot2=True
			if slotId<=3 and slotId2>=3:
				driverslotsobj.activeSlot3=True
			if slotId<=4 and slotId2>=4:
				driverslotsobj.activeSlot4=True
			if slotId<=5 and slotId2>=5:
				driverslotsobj.activeSlot5=True
			if slotId<=6 and slotId2>=6:
				driverslotsobj.activeSlot6=True
			if slotId<=7 and slotId2>=7:
				driverslotsobj.activeSlot7=True
			if slotId<=8 and slotId2>=8:
				driverslotsobj.activeSlot8=True
			if slotId<=9 and slotId2>=9:
				driverslotsobj.activeSlot9=True
			if slotId<=10 and slotId2>=10:
				driverslotsobj.activeSlot10=True
			if slotId<=11 and slotId2>=11:
				driverslotsobj.activeSlot11=True
			if slotId<=12 and slotId2>=12:
				driverslotsobj.activeSlot12=True
			if slotId<=13 and slotId2>=13:
				driverslotsobj.activeSlot13=True
			if slotId<=14 and slotId2>=14:
				driverslotsobj.activeSlot14=True
			if slotId<=15 and slotId2>=15:
				driverslotsobj.activeSlot15=True
			if slotId<=16 and slotId2>=16:
				driverslotsobj.activeSlot16=True
			if slotId<=17 and slotId2>=17:
				driverslotsobj.activeSlot17=True
			if slotId<=18 and slotId2>=18:
				driverslotsobj.activeSlot18=True
			if slotId<=19 and slotId2>=19:
				driverslotsobj.activeSlot19=True
			if slotId<=20 and slotId2>=20:
				driverslotsobj.activeSlot120=True
			if slotId<=21 and slotId2>=21:
				driverslotsobj.activeSlot21=True
			if slotId<=22 and slotId2>=22:
				driverslotsobj.activeSlot22=True
			if slotId<=23 and slotId2>=23:
				driverslotsobj.activeSlot23=True
			if slotId<=24 and slotId2>=24:
				driverslotsobj.activeSlot24=True
			driverslotsobj.save()
		return 'pass'
	except Exception as e:
		print(e)
		return 'fail'

def slotStatusonJobCompletenew(sameparcelID):
	customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID)
	packageCompleted=True
	startSlot=24
	lastSlot=0
	driverID=0
	driverExist=False
	for customer in customerjob_obj_all:
		dJob=DriverJob.objects.filter(customerjob=customer).first()
		if dJob:
			print("we are in driver job")
			driverExist=True
			driverID=dJob.driver.id
			print(customer.pickuptimeslotDate)
			print(customer.pickuptimeslot)
			stringFirst=customer.pickuptimeslot
			one=stringFirst.split('-')[0]
			two=stringFirst.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringFirst=one+" "+two
			print(one)
			print(two)
			print(stringFirst)
			pickupSlotID=int(stringFirst[:2])
			if pickupSlotID<startSlot:
				startSlot=pickupSlotID
			print("Pickupslotid",pickupSlotID)
			print(customer.dropofftimeslot)
			stringSecond=customer.dropofftimeslot
			one=stringSecond.split('-')[0]
			two=stringSecond.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringSecond=one+" "+two
			print(one)
			print(two)
			print(stringSecond)
			deliverySlotID=int(stringSecond[:2])
			if deliverySlotID>lastSlot:
				lastSlot=deliverySlotID
	slotsFind=False
	idofslottables=0
	print("one 1")
	pickupdateCuystomer = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID).first()
	print(pickupdateCuystomer)
	print("one 2")
	parcelpickupdate=pickupdateCuystomer.pickuptimeslotDate
	print("one 3")
	dJob=DriverJob.objects.filter(customerjob=pickupdateCuystomer).first()
	print(dJob)
	if dJob:
		print("one 4")
		driver=dJob.driver
		print("one 5",driver)
		driverslotsobj=DriverAllSlots.objects.filter(driver=driver)
		print("one 6",driverslotsobj)
		for d in driverslotsobj:
			print("one 7")
			if d.dateOfSlots==parcelpickupdate:
				print("one 8",d.dateOfSlots)
				slotsFind=True
				idofslottables=d.id
				print("one 8",idofslottables)
	if slotsFind==True:
		print("one 9")
		if driverExist:
			print("one 10")
			makeslotAvailablenew(startSlot,lastSlot+1,idofslottables)



def slotStatusonJobComplete(sameparcelID):
	customerjob_obj_all = CustomerJob.objects.filter(sameIdForParcelsDetails = sameparcelID)
	packageCompleted=True
	startSlot=24
	lastSlot=0
	driverID=0
	driverExist=False
	for customer in customerjob_obj_all:
		dJob=DriverJob.objects.filter(customerjob=customer).first()
		if dJob:
			driverExist=True
			driverID=dJob.driver.id
			print(customer.pickuptimeslotDate)
			print(customer.pickuptimeslot)
			stringFirst=customer.pickuptimeslot
			one=stringFirst.split('-')[0]
			two=stringFirst.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringFirst=one+" "+two
			print(one)
			print(two)
			print(stringFirst)
			pickupSlotID=int(stringFirst[:2])
			if pickupSlotID<startSlot:
				startSlot=pickupSlotID
			print("Pickupslotid",pickupSlotID)
			print(customer.dropofftimeslot)
			stringSecond=customer.dropofftimeslot
			one=stringSecond.split('-')[0]
			two=stringSecond.split('-')[1]
			one=convert24(one)
			two=convert24(two)
			stringSecond=one+" "+two
			print(one)
			print(two)
			print(stringSecond)
			deliverySlotID=int(stringSecond[:2])
			if deliverySlotID>lastSlot:
				lastSlot=deliverySlotID
	if driverExist:
		makeslotAvailable(startSlot,lastSlot+1,driverID)

def cancelOrder(request):
	print(request.POST)
	sameparcelID = request.POST.get('sameparcelID')
	try:
		customerjob_obj=CustomerJob.objects.filter(sameIdForParcelsDetails=sameparcelID)
		cancelParcel=True
		if customerjob_obj:
			for c in customerjob_obj:
				dJob=DriverJob.objects.filter(customerjob=c).first()
				if dJob.jobstarted==True:
					cancelParcel=False
			if cancelParcel==True:
				for custom in customerjob_obj:
					custom.isdeleted=True
					dJob=DriverJob.objects.filter(customerjob=custom).first()
					if dJob:
						dJob.isdeleted=True
						dJob.save()
					custom.save()
				slotStatusonJobCompletenew(sameparcelID)
				return JsonResponse({'status' : 200})
			else:
				return JsonResponse({'status' : 400})
		else:
			return JsonResponse({'status' : 400})
	except Exception as e:
		print(e)
		return JsonResponse({'status' : 400})

class cancelOrder2(TemplateView):
	template_name = 'customerjobdetail.html'
	def post(self, request, *args, **kwargs):
		pass
		# print("AboutUs-in post ")
	
	def get_context_data(self,**kwargs):
		context = super(cancelOrder, self).get_context_data(**kwargs)
		
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			data = {}
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj).first()
				if customer_obj:
					sameParrcelID = kwargs['sameparcelID']
					print(sameParrcelID)
					customerjob_obj=CustomerJob.objects.filter(sameIdForParcelsDetails=sameParrcelID)
					for custom in customerjob_obj:
						custom.isdeleted=True
						custom.save()
		
					context['status'] = 'Done'
		return HttpResponseRedirect("/path/")


class TestWeb(TemplateView):
	template_name = 'customer_quickfareestimate.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(TestWeb, self).get_context_data(**kwargs)
		print("TestWeb - in get ")

		from math import radians, cos, sin, asin, sqrt
		def haversine(lat1, lon1, lat2, lon2):
			lat1, lon1, lat2, lon2 = map(float, [lat1, lon1, lat2, lon2])# haversine formula 
			lat1, lon1, lat2, lon2 = map(radians, [lat1, lon1, lat2, lon2])# haversine formula 
			dlon = lon2 - lon1 
			dlat = lat2 - lat1 
			a = sin(dlat/2)**2 + cos(lat1) * cos(lat2) * sin(dlon/2)**2
			c = 2 * asin(sqrt(a)) 
			r = 6371 # Radius of earth in kilometers. Use 3956 for miles
			return (c * r)

		# def getmaximumweightinbuffer(wt):
		# 	if wt == 'Less than 5 kg':
		# 		return(True, 5)
		# 	elif wt == 'More than 5 kg but less than 20 kg':
		# 		return(True, 20)
		# 	elif wt == 'More than 20 kg but less than 50 kg':
		# 		return(True, 50)
		# 	elif wt == 'More than 50 kg':
		# 		return(True, 51)
		# 	else:
		# 		return(False, 0)


		def get_nearestdriversdata_from_driversobj(senderlatitude, senderlongitude, driver_obj):
			nearestdrivers_data = []
			for driver in driver_obj:
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
				if drivercoordinates_obj:
					distance = haversine(senderlatitude, senderlongitude, drivercoordinates_obj.latitude, drivercoordinates_obj.longitude)
					# print(distance)
					nearestdrivers_data.append({
						'driverid' : driver.id,
						'drivervehicle' : driver.vehicletype.name,
						'distance' : distance,
						})
				else:
					pass
					# print('driver coordinates do not exist')
			if len(nearestdrivers_data) > 0:
				success = True
			else:
				success = False
			return (success, nearestdrivers_data)

		def sort_nearestdrivers_data(nearestdrivers_data):
			nearestdrivers_data = sorted(nearestdrivers_data, key = lambda i: i['distance'],reverse=False)
			# print(nearestdrivers_data)
			return(nearestdrivers_data)

		def get_nearestdriversdata_biggervehicles(senderlatitude, senderlongitude, vehicletypeid):
			# print('in get_nearestdriversdata_biggervehicles')
			nearestdrivers_data = []
			requiredvehicletype_obj = VehicleType.objects.filter(id = job.vehicletype.id).first()
			if requiredvehicletype_obj:
				vehiclecarryinglimit = requiredvehicletype_obj.carryinglimitinkg
				biggervehicletype_obj = VehicleType.objects.filter(carryinglimitinkg__gte = vehiclecarryinglimit).order_by('carryinglimitinkg')
				if biggervehicletype_obj:
					for biggervehicle in biggervehicletype_obj:
						driver_obj = DriverModel.objects.filter(status = 0, vehicletype = biggervehicle)
						if driver_obj:
							for driver in driver_obj:
								drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver).first()
								if drivercoordinates_obj:
									distance = haversine(senderlatitude, senderlongitude, drivercoordinates_obj.latitude, drivercoordinates_obj.longitude)
									# print(distance)
									nearestdrivers_data.append({
										'driverid' : driver.id,
										'drivervehicle' : driver.vehicletype.name,
										'distance' : distance,
										})
									success = True
								else:
									pass
									# print('driver coordinates do not exist')
			if len(nearestdrivers_data) > 0:
				success = True
			else:
				success = False
			return (success, nearestdrivers_data)
			
		backendcontrol_obj = BackendControl.objects.first()
		if backendcontrol_obj:
			if backendcontrol_obj.enable:
				# pendingcustomerjobs = CustomerJob.objects.filter(status = 0)
				pendingcustomerjobs = CustomerJob.objects.filter(status = 0, id__gte = 220) # for test purpose
				# print(pendingcustomerjobs)
				for job in pendingcustomerjobs:
					nearestdrivers_data = []
					print(job)
					if job.senderlatitude and job.senderlongitude:
						# print('in first if')
						if job.vehicletype:
							print('\n')
							# print(str(job.id) + '  --  ' + job.senderlatitude + ',' + job.senderlongitude + '  --  ' + job.vehicletype.name)
							driver_obj = DriverModel.objects.filter(status = 0, vehicletype_id = job.vehicletype.id)
							# print(driver_obj)
							if len(driver_obj) == 0:
								# print('in if')
								success, nearestdrivers_data = get_nearestdriversdata_biggervehicles(senderlatitude = job.senderlatitude, senderlongitude = job.senderlongitude, vehicletypeid = job.vehicletype.id)
								if success:
									nearestdrivers_data = sort_nearestdrivers_data(nearestdrivers_data = nearestdrivers_data)
								else:
									pass
							else:
								# print('in else')
								success, nearestdrivers_data = get_nearestdriversdata_from_driversobj(senderlatitude = job.senderlatitude, senderlongitude = job.senderlongitude, driver_obj = driver_obj)
								if success:
									nearestdrivers_data = sort_nearestdrivers_data(nearestdrivers_data = nearestdrivers_data)
								else:
									success, nearestdrivers_data = get_nearestdriversdata_biggervehicles(senderlatitude = job.senderlatitude, senderlongitude = job.senderlongitude, vehicletypeid = job.vehicletype.id)
									if success:
										nearestdrivers_data = sort_nearestdrivers_data(nearestdrivers_data = nearestdrivers_data)
									else:
										pass
							# print(nearestdrivers_data)
							




							# print(nearestdrivers_data)
							if len(nearestdrivers_data) > 0:
								print('job assigned to driver with id: ' + str(nearestdrivers_data[0]['driverid']))	
								# res = assigndriverforparcel(job.id,nearestdrivers_data[0]['driverid'])
								# print(res)
								# job.status = 1
								# job.save()		
							else:
								print('no driver found for job: ', job.id)
			else:
				print('Auto assign is disabled')
		print('end')
		return context


def delete_card(request, *args, **kwargs):
	'''This function is being used to delete the parcel type details by Admin'''
	print('Customer - in delete_card function')
	try:	
		card_id = request.POST.get('card_id')
		if not card_id:
			return JsonResponse({'status_code' : 400, 'status_message' : 'card_id is required.'})
		storedcard_obj = StoredCard.objects.filter(id = card_id).first()
		if storedcard_obj:
			stripe.api_key = "sk_test_P9sozPTZ5nZbhc3fOFCsjNqm00hYGCvJ7l"

			res = stripe.Customer.delete_source(
			  storedcard_obj.stripe_customer_id,
			  storedcard_obj.stripe_card_id,
			)
			print(res)
			if res['deleted'] == True:
				StoredCard.objects.filter(id = card_id).delete()
				return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
			else:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request.'})
			
			return JsonResponse({'status_code' : 200, 'status_message' : 'Record deleted successfully.'})
		else:
			return JsonResponse({'status_code' : 400, 'status_message' : 'Bad Request.'})
		
	except Exception as e:
		print(e)
		return JsonResponse({'status_code' : 500, 'status_message' : 'Internal Server Error'})


@method_decorator(checklogincustomer, name='dispatch')
class CustomerAddCard(View):
	def post(self, request, *args, **kwargs):
		'''This function shows the content on profile screen'''
		print("CustomerAddCard - in post ")
		try:	
			
			# print(request.POST)
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			
			card_name = request.POST.get('card_name')
			card_number = request.POST.get('card_number')
			card_expiry_month = request.POST.get('card_expiry_month')
			card_expiry_year = request.POST.get('card_expiry_year')
			card_expiry_cvc = request.POST.get('card_expiry_cvc')
			

			
			if not card_name:
				return JsonResponse({'status_code': 400, 'status_message': 'card_name is required'})
			if not card_number:
				return JsonResponse({'status_code': 400, 'status_message': 'card_number is required'})
			if not card_expiry_month:
				return JsonResponse({'status_code': 400, 'status_message': 'card_expiry_month is required'})
			if not card_expiry_year:
				return JsonResponse({'status_code': 400, 'status_message': 'card_expiry_year is required'})
			if not card_expiry_cvc:
				return JsonResponse({'status_code': 400, 'status_message': 'card_expiry_cvc is required'})
			
			# stripe.api_key = "sk_test_P9sozPTZ5nZbhc3fOFCsjNqm00hYGCvJ7l" # varis_raheja
			stripe.api_key = str(settings.STRIPE_KEY)

			customer_obj = Customer.objects.filter(email = email_val).first()
			if customer_obj:
				storedcard_obj = StoredCard.objects.filter(customer = customer_obj).first()
				if storedcard_obj:
					pass
					print('atleast one card is stored')
					try:	
						card = stripe.Token.create(
						card={
							"number": card_number,
							"exp_month": int(card_expiry_month),
						    "exp_year": int(card_expiry_year),
						    "cvc": card_expiry_cvc,
							},
						)
						last_four_digits = card['card']['last4']
						exp_month = card['card']['exp_month']
						exp_year = card['card']['exp_year']
						card_id = card['card']['id']
						token_id = card['id']
						print('card_id = ', card_id) 
						print('token_id = ', token_id)
						res2 = stripe.Customer.create_source(
						  storedcard_obj.stripe_customer_id,
						  source = token_id,
						)
						storedcard_obj = StoredCard.objects.create(customer = customer_obj, stripe_customer_id = storedcard_obj.stripe_customer_id, stripe_card_id = card_id, stripe_card_number_lastfourdigits = last_four_digits, stripe_card_exp_month = exp_month, stripe_card_exp_year = exp_year)	

						return JsonResponse({'status_code': 200, 'status_message': 'Your card is added successfully.'})
						# paymentmethod = stripe.PaymentMethod.create(
						#   type="card",
						#   card={
						#     "number": card_number,
						#     "exp_month": int(card_expiry_month),
						#     "exp_year": int(card_expiry_year),
						#     "cvc": card_expiry_cvc,
						#   },
						# )
						# print(paymentmethod['id'])
					except Exception as e:
						print(e)
						return JsonResponse({'status_code': 400, 'status_message': 'Your card details are invalid'})
					
				else:
					customer = stripe.Customer.create(email = email_val)
					customer_id = customer['id']
					print('customer_id = ', customer_id)
					storedcard_obj = StoredCard.objects.create(customer = customer_obj, stripe_customer_id = customer_id, is_default = True)
					if storedcard_obj:
						try:
							card = stripe.Token.create(
							card={
								"number": card_number,
								"exp_month": int(card_expiry_month),
							    "exp_year": int(card_expiry_year),
							    "cvc": card_expiry_cvc,
								},
							)
							last_four_digits = card['card']['last4']
							exp_month = card['card']['exp_month']
							exp_year = card['card']['exp_year']
							card_id = card['card']['id']
							token_id = card['id']
							print('card_id = ', card_id) 
							print('token_id = ', token_id)
							# attach card with customer
							res2 = stripe.Customer.create_source(
							  customer_id,
							  source = token_id,
							)
							print(res2)
							storedcard_obj.stripe_card_id = card_id
							storedcard_obj.stripe_card_number_lastfourdigits = last_four_digits
							storedcard_obj.stripe_card_exp_month = exp_month
							storedcard_obj.stripe_card_exp_year = exp_year
							storedcard_obj.save()
							return JsonResponse({'status_code': 200, 'status_message': 'Your card is added successfully.'})
						except Exception as e:
							print(e)
							return JsonResponse({'status_code': 400, 'status_message': 'Your card details are invalid'})

			else:
				return JsonResponse({'status_code': 400, 'status_message': 'You are not authorized to add card'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})



class CustomerWallet(TemplateView):
	template_name = 'customer_wallet.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all companies screen to Admin user'''
		context = super(CustomerWallet, self).get_context_data(**kwargs)
		print("CustomerWallet-in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
		if self.request.session.has_key('userrole'):
			userrole_val = self.request.session['userrole']
		storedcards_data = []
		customer_obj = Customer.objects.filter(email = email_val).first()
		if customer_obj:
			storedcard_obj = StoredCard.objects.filter(customer = customer_obj)
			if storedcard_obj:
				serialno = 0
				for card in storedcard_obj:
					serialno += 1
					storedcards_data.append({
						'serialno' : serialno,
						'last4digits' : card.stripe_card_number_lastfourdigits,
						'expiry_date' : card.stripe_card_exp_month + '/' + card.stripe_card_exp_year,
						'card_id' : card.id,
						})
		
		context['storedcards_data'] = storedcards_data
		return context



class CompanyCreditRequests(TemplateView):
	template_name = 'company_showallcreditrequests.html'

	def get_context_data(self,**kwargs):
		'''This class shows the content on show all companies screen to Admin user'''
		context = super(CompanyCreditRequests, self).get_context_data(**kwargs)
		print("CompanyCreditRequests-in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
		if self.request.session.has_key('userrole'):
			userrole_val = self.request.session['userrole']
		all_credit_requests_data = []
		if userrole_val == 'company':
			if email_val:
				creditsrequested_obj = CreditsRequested.objects.filter(company_email = email_val).order_by('-id')
				if creditsrequested_obj:
					serialno = 0
					for req in creditsrequested_obj:
						serialno += 1
						all_credit_requests_data.append({
							'serialno' : serialno,
							'credits' : req.credits,
							'note_by_company' : req.note_by_company,
							'status' : req.status,
							'date' : req.created_at.strftime("%d/%m/%Y %I:%M:%S %p"),
							'id' : req.id,
							})
		if userrole_val == 'customer':
			if email_val:
				creditsrequested_obj = CreditsRequested.objects.filter(company_email = email_val).order_by('-id')
				if creditsrequested_obj:
					serialno = 0
					for req in creditsrequested_obj:
						serialno += 1
						all_credit_requests_data.append({
							'serialno' : serialno,
							'credits' : req.credits,
							'note_by_company' : req.note_by_company,
							'status' : req.status,
							'date' : req.created_at.strftime("%d/%m/%Y %I:%M:%S %p"),
							'id' : req.id,
							})
		print(all_credit_requests_data)		
				# print(data)

		paginator = Paginator(all_credit_requests_data, 15)
		page = int(self.request.GET.get('page',1))
		print('page = ', page)
		try:
			all_credit_requests_data = paginator.page(page)
			print(len(all_credit_requests_data))
		except PageNotAnInteger:
			all_credit_requests_data = paginator.page(paginator.num_pages)
			print("except1")
		except EmptyPage:
			all_credit_requests_data = paginator.page(paginator.num_pages)
			print("except2")

		context['all_credit_requests'] = all_credit_requests_data
		return context



@method_decorator(checklogincustomer, name='dispatch')
class CompanyMakeCreditrequest(View):
	def post(self, request, *args, **kwargs):
		'''This function shows the content on profile screen'''
		print("CompanyMakeCreditrequest - in post ")
		try:	
			
			# print(request.POST)
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			
			credits_request = request.POST.get('credits_request')
			credits_request_note = request.POST.get('credits_request_note')

			
			if not credits_request:
				return JsonResponse({'status_code': 400, 'status_message': 'credits_request is required'})
			if not credits_request_note:
				return JsonResponse({'status_code': 400, 'status_message': 'credits_request_note is required'})
			
			if userrole_val == 'company':
				customer_obj = Customer.objects.filter(user__email = email_val, role = 'company').prefetch_related('user').first()
				if customer_obj:
					creditsrequested_obj = CreditsRequested.objects.create(company_email = email_val, credits = credits_request, note_by_company = credits_request_note, status = 'pending')
					if creditsrequested_obj:
						return JsonResponse({'status_code': 200, 'status_message': 'success'})
			if userrole_val == 'customer':
				customer_obj = Customer.objects.filter(user__email = email_val, role = 'customer').prefetch_related('user').first()
				if customer_obj:
					creditsrequested_obj = CreditsRequested.objects.create(company_email = email_val, credits = credits_request, note_by_company = credits_request_note, status = 'pending')
					if creditsrequested_obj:
						return JsonResponse({'status_code': 200, 'status_message': 'success'})
			
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'You are not authorized to make credit request'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})



@method_decorator(checklogincustomer, name='dispatch')
class GetFaresTest(APIView):
	def post(self, request, *args, **kwargs):
		'''This function is being used to return fares according to different vehicle types'''
		try:
			print("GetFaresTest Web- in post ")
			print('\n\n')
			# print(request.POST)
			# print('\n\n')

			def getdistancebetweentwolocations(sendercoordinates_val, recipientcoordinates_val):
				try:
					api_key = str(settings.GOOGLE_API_KEY)
					url ='https://maps.googleapis.com/maps/api/distancematrix/json?'
					if sendercoordinates_val and recipientcoordinates_val:
					# return response object 
						print(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
						r = requests.get(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
					# else:
					# 	print(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)
					# 	r = requests.get(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

					x = r.json() 
					print(x) 
					print('\n')
					if x['status'] == 'OK':
						multiplicationfactor = 0.000621371192
						distanceinmiles = float(x['rows'][0]['elements'][0]['distance']['value']) * multiplicationfactor
						# print(distanceinmiles)
						senderlatitude = str(sendercoordinates_val.split(',')[0])
						senderlongitude = str(sendercoordinates_val.split(',')[1])
						recipientlatitude = str(recipientcoordinates_val.split(',')[0])
						recipientlongitude = str(recipientcoordinates_val.split(',')[1])
						distancetable_obj = DistanceTable(senderlatitude = senderlatitude, senderlongitude = senderlongitude, recipientlatitude = recipientlatitude, recipientlongitude = recipientlongitude, distance = distanceinmiles, distanceunit = 'mile', time = x['rows'][0]['elements'][0]['duration']['value'])
						distancetable_obj.save()
						return(200, 'success', distanceinmiles)
					else:
						return(400, 'Enter valid address', '')
						
				except Exception as e:
					print(e)
					return(400, 'Enter valid address', '')


			def calculatefarefromdistanceforvehicletype(distanceinmiles, vehicletype_val):
				data = []
				try:
					vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', name = vehicletype_val).first()
					if vehicletype_obj:
						distance = distanceinmiles
						if distance <= vehicletype_obj.fixeddistance:
							rate = vehicletype_obj.baserate
						else:
							rate = vehicletype_obj.baserate
							distance = distance - vehicletype_obj.fixeddistance
							if distance > int(distance):
								distance = int(distance) + 1
							else:
								distance = distance
							rate = rate + distance * vehicletype_obj.addittionalrateperunit
							
					return(200, 'success', round(float(rate),2))
				except Exception as e:
					print(e)
					return(400, 'Enter valid address', data)

			

			parcels_data = request.POST.get('parcels_data')
			noofparcels_val = request.POST.get('noofparcels')
			print('0')
			print(type(parcels_data))
			parcels_data = json.loads(parcels_data)
			print('1')
			print(parcels_data)
			total_price = 0.0
			api_key = str(settings.GOOGLE_API_KEY)
			data = []
			noofparcels_forspecialbooking = 0
			for parcel in parcels_data:
				print('\n')
				try:
					if parcel['specialbooking'] == 'yes':
						noofparcels_forspecialbooking += 1
				except Exception as e:
					print(e)
				pickupaddress_val = parcel['pickupaddress']
				dropaddress_val = parcel['dropaddress']

				senderlatitude_val = parcel['senderlatitude']
				senderlongitude_val = parcel['senderlongitude']
				recipientlatitude_val = parcel['recipientlatitude']
				recipientlongitude_val = parcel['recipientlongitude']
				distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
				if distancetable_obj:
					print('distance found in DistanceTable')
					distance = distancetable_obj.distance
				else:
					print('distance not found in DistanceTable')
					sendercoordinates_val = parcel['senderlatitude'] + ',' + parcel['senderlongitude']
					recipientcoordinates_val = parcel['recipientlatitude'] + ',' + parcel['recipientlongitude']
					status_code, status_message, distanceinmiles = getdistancebetweentwolocations( sendercoordinates_val = sendercoordinates_val, recipientcoordinates_val = recipientcoordinates_val)
					print(status_code, status_message, distanceinmiles)
					if status_code == 200:
						distance = distanceinmiles
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Please select same country for pickup and dropoff'})

				vehicle_count = VehicleType.objects.filter(distanceunit = 'mile', isdeleted = False).count()
				vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', isdeleted = False)
				if vehicletype_obj:
					for vehicle in vehicletype_obj:
						# distance = totaldistanceinmiles
						if distance <= vehicle.fixeddistance:
							rate = vehicle.baserate
						else:
							rate = vehicle.baserate
							print('\n')
							print(vehicle.name)
							print(rate)
							distance = distance - vehicle.fixeddistance
							# print(totaldistanceinmiles)
							if distance > int(distance):
								distance = int(distance) + 1
							else:
								distance = distance
							print(distance)
							print(vehicle.addittionalrateperunit)
							rate = rate + distance * vehicle.addittionalrateperunit
							print(rate)
						image = str(settings.WEB_BASE_URL)
						if vehicle.name == 'Bike':
							image += '/static/images/bike.png'
						elif vehicle.name == 'Car':
							image += '/static/images/car.jpg'
						elif vehicle.name == 'Small Van':
							image += '/static/images/smallvan.png'
						elif vehicle.name == 'Medium Van':
							image += '/static/images/smallvan.png'
						elif vehicle.name == 'Large Van':
							image += '/static/images/largevan.jpg'
						
						if len(data) < vehicle_count:	
							data.append({"vehicletype" : vehicle.name, 'price' : round(float(rate),2), 'image' : image, "currency" : vehicle.currency,})
						else:
							# print('second entry for vehicle type')
							for item in data:
								if item["vehicletype"] == vehicle.name:
									item["price"]+= rate

							
				print(data)
				current_credits = 0.0
				if self.request.session.has_key('email'):
					email_val = self.request.session['email']
				if self.request.session.has_key('userrole'):
					userrole_val = self.request.session['userrole']
					if userrole_val == 'company':
						customer_obj = Customer.objects.filter(user__email = email_val, role = 'company').prefetch_related('user').first()
						if customer_obj:
							companydetail_obj = CompanyDetail.objects.filter(customer = customer_obj).first()
							if companydetail_obj:
								current_credits = companydetail_obj.credits
			backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
			if backendcontrol_obj:
				specialbookingcharges = backendcontrol_obj.price
			else:
				specialbookingcharges = 10
			extracharges = noofparcels_forspecialbooking * specialbookingcharges
			return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'data' : data, 'extracharges' : extracharges, 'current_credits' : current_credits})			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})


class PlaceOrderTest3(TemplateView):
	template_name = 'placeorder_test3.html' 

	def get_context_data(self,**kwargs):
		'''This function passes arguments to place order page. '''
		context = super(PlaceOrderTest3, self).get_context_data(**kwargs)
		print("PlaceOrderTest3 - in get ")
		allparceltypes = ParcelType.objects.all()
		context['allparceltypes'] = allparceltypes
		# print(allparceltypes)
		data = []
		
		data.append({
			'id' : 1,
			'weight' : 'Less than 5 kg',
			})
		data.append({
			'id' : 2,
			'weight' : 'More than 5 kg but less than 20 kg',
			})
		data.append({
			'id' : 3,
			'weight' : 'More than 20 kg but less than 50 kg',
			})
		data.append({
			'id' : 4,
			'weight' : 'More than 50 kg',
			})

		print(data)
		context['allparcelweights'] = data
		timeslots_data = []
		alltimeslots = TimeSlots.objects.filter(active = True)
		if alltimeslots:
			for slot in alltimeslots:
				timeslots_data.append({
					'openinghour' : slot.openinghour.strftime("%I:%M %p"),
					'closinghour' : slot.closinghour.strftime("%I:%M %p"),
					'status' : slot.active,
					})
		# print(timeslots_data)
		context['alltimeslots'] = timeslots_data

		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
		if self.request.session.has_key('userrole'):
			userrole_val = self.request.session['userrole']
		storedcards_data = []
		customer_obj = Customer.objects.filter(email = email_val).first()
		if customer_obj:
			storedcard_obj = StoredCard.objects.filter(customer = customer_obj)
			if storedcard_obj:
				serialno = 0
				for card in storedcard_obj:
					serialno += 1
					storedcards_data.append({
						'serialno' : serialno,
						'last4digits' : card.stripe_card_number_lastfourdigits,
						'expiry_date' : card.stripe_card_exp_month + '/' + card.stripe_card_exp_year,
						'is_default' : card.is_default,
						'card_id' : card.id,
						})
		
		context['storedcards_data'] = storedcards_data
		context['placeorder_section'] = 'yes'
		return context	

def prorityandChecking(prority):
	checkin=CustomerJob.objects.filter(priorityBaseIDForParcel=prority)
	if checkin:
		prority=prority+1
		return(prorityandChecking(prority))
	else:
		return prority


class PlaceOrderTest2NEW(TemplateView):
	template_name = 'placeorder_test2.html' 

	def get_context_data(self,**kwargs):
		profile_data=[]
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			user_obj = User.objects.filter(email = email_val).first()
			print('2')
			customer_obj = Customer.objects.filter(user = user_obj).first()
			if customer_obj:
				customerjob_obj = CustomerJob.objects.filter(customer=customer_obj)
				for custom in customerjob_obj:
					profile_data.append({
								'recipientname':custom.recipientname,
								'recipientcountrycode':custom.recipientcountrycode,
								'recipientphone':custom.recipientphone,
								'recipientlatitude':custom.recipientlatitude,
								'recipientlongitude':custom.recipientlongitude,
								'dropoffaddress':custom.dropoffaddress,
							})
		'''This function passes arguments to place order page. '''
		context = super(PlaceOrderTest2NEW, self).get_context_data(**kwargs)
		print("PlaceOrderTest2 - in get ")
		allparceltypes = ParcelType.objects.all()
		context['allparceltypes'] = allparceltypes
		# print(allparceltypes)
		data = []
		
		data.append({
			'id' : 1,
			'weight' : 'Less than 5 kg',
			})
		data.append({
			'id' : 2,
			'weight' : 'More than 5 kg but less than 20 kg',
			})
		data.append({
			'id' : 3,
			'weight' : 'More than 20 kg but less than 50 kg',
			})
		data.append({
			'id' : 4,
			'weight' : 'More than 50 kg',
			})

		print(data)
		context['allparcelweights'] = data
		timeslots_data = []
		alltimeslots = TimeSlots.objects.filter(active = True)
		if alltimeslots:
			for slot in alltimeslots:
				timeslots_data.append({
					'openinghour' : slot.openinghour.strftime("%I:%M %p"),
					'closinghour' : slot.closinghour.strftime("%I:%M %p"),
					'status' : slot.active,
					})

		# print(timeslots_data)
		from datetime import datetime as dtofNew
		dateofone=dtofNew.now()
		dateofTodayNew=dateofone.strftime("%m/%d/%Y")

		# from datetime import datetime
		import pytz as pyNew
		current_time = dtofNew.now(pyNew.timezone('Europe/London')) 
		# current_time = dtofNew.strptime("1:00", "%H:%M")
		currentHour = current_time.hour
		if currentHour==23:
		  currentHour=str(0)
		else:
		  currentHour=str(currentHour+1)
		newfirstDate=current_time.strftime("%I:00"+" "+"%p")
		print(newfirstDate)
		newHour=currentHour+':00'
		d2 = dtofNew.strptime(newHour, "%H:%M")
		newsecondDate=d2.strftime("%I:00"+" "+"%p")
		print(newsecondDate)
		currenttimeSlot=newfirstDate+' '+'-'+' '+newsecondDate
		print(currenttimeSlot)
		# import pytz as pyNew  
		# current_time = datetime.datetime.now(pyNew.timezone('Europe/London')) 
		# currentHour = current_time.hour
		# print ("Hour : ", end = "")  
		# print (current_time.hour)


		context['currentHour']=currenttimeSlot  
		context['todayDate']=dateofTodayNew
		context['alltimeslots'] = timeslots_data
		context['placeorder_section'] = 'yes'
		context['recipientDetails'] = profile_data
		return context	

	def post(self, request, *args, **kwargs):
		'''This function is being used to save the customer job request details in the database'''
		print('\n\n')
		print('PlaceOrderTest2 Web - in post')
		print('\n\n')
		# print(request.POST)
		# print('\n\n')


		def generateqrcode(id_val):
			print(id_val)
			import pyqrcode, png, os
			# from pyqrcode import QRCode
			customerjob_obj = CustomerJob.objects.get(id = id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				pass
			else:
				os.umask(0)
				os.mkdir(filepath)
			
			url = pyqrcode.create(content = 'AWB-' + str(id_val))
			url.png(filepath + '/qrcode.png',scale = 8)
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
			customerjob_obj.qrcode = filename
			customerjob_obj.save()
			return('1')


		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')



		# session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')
		ordertype = request.POST.get('ordertype')
		totalamount = request.POST.get('totalamount')
		vehicletype = request.POST.get('vehicletype')
		totalamount = str(totalamount.split(' ')[-1])


		
		try:
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
				print(email_val)
				user_obj = User.objects.filter(email = email_val).first()
				print('2')
				customer_obj = Customer.objects.filter(user = user_obj).first()
				print('3')
				if customer_obj:
					if ordertype == 'singledrop':
						ordertype = 1
					elif ordertype == 'multidrop':
						ordertype = 2
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Order type is required.'})
					order_obj = Order.objects.create(customer = customer_obj, ordertype = ordertype, totalamount = float(totalamount), isdeleted = False)
		except Exception as e:
			print(e)
		print('0')

		print(type(parcels_data))
		parcels_data = json.loads(parcels_data)
		print('1')

		print(totalamount)
		if payment_token:
			try:	
				print(payment_token)
				stripe.api_key = str(settings.STRIPE_KEY)
				charge = stripe.Charge.create(
				amount = int(float(totalamount)*100),
				currency = 'gbp',
				description = 'Parcel Payment',
				source = payment_token,
				)
				print(charge)
				OrderPayment.objects.create(order = order_obj, stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
			except Exception as e:
				print('Exception in creating charge = ', e)
		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')
		try:
			last_customer_obj=CustomerJob.objects.last()
			if last_customer_obj:
				if int(last_customer_obj.sameIdForParcelsDetails)==0:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1000
				else:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1
		except Exception as e:
			pass
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			user_obj = User.objects.filter(email = email_val).first()
			print('2')
			customer_obj = Customer.objects.filter(user = user_obj).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print('\n')
					# print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					print("Selected Date For parcel pickup",parcel['dt'])

					print(parcel['safePalace'])

					
					print("No of items in one parcel",parcel['noofitems'])
					noofitems=parcel['noofitems']
					noofitems=int(noofitems)
					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = parcel['sendercity']
					# noofparcels_val = parcel['noofparcels']
					length_val = parcel['length']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					dropspecialnote = parcel['dropspecialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']
					pickuptimeslot_val = parcel['pickuptimeslot']
					dropofftimeslot_val = parcel['dropofftimeslot']

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val =  parcel['recipientlongitude']
					safePalace_val = parcel['safePalace']
					# vehicletype_val = parcel['vehicletype']
					# price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					specialbooking_val = parcel['specialbooking']
					if specialbooking_val == 'yes':
						specialbooking = True
					else:
						specialbooking = False

					if safePalace_val == 'yes':
						safePalace = True
					else:
						safePalace = False
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype).first()
					if vehicletype_obj:
						print('5')
						try:
							distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
							if distancetable_obj:
								distance = distancetable_obj.distance

										# distance = totaldistanceinmiles
								if distance <= vehicletype_obj.fixeddistance:
									rate = vehicletype_obj.baserate
								else:
									rate = vehicletype_obj.baserate
									print('\n')
									print(vehicletype_obj.name)
									print(rate)
									distance = distance - vehicletype_obj.fixeddistance
									# print(totaldistanceinmiles)
									if distance > int(distance):
										distance = int(distance) + 1
									else:
										distance = distance
									print(distance)
									print(vehicletype_obj.addittionalrateperunit)
									rate = rate + distance * vehicletype_obj.addittionalrateperunit
									print(rate)

								pass
						except Exception as e:
							print(e)
						try:
							specialbooking_charge = 0.0
							if specialbooking:
								backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
								if backendcontrol_obj:
									specialbooking_charge = backendcontrol_obj.price
						except Exception as e:
							print(e)
						from datetime import datetime as dateufor
						datetime_str = parcel['dt']
						datetime_object = dateufor.strptime(datetime_str, '%m/%d/%Y')
						dat1=datetime_object.date()
						dat2=dat1.strftime("%d-%b-%Y")
						print(dat2)
						# dat1=datetime.datetime.now()
						# print(dat1)
						# dat2=dat1.strftime("%d-%b-%Y")
						# print(dat2)
						last_customer_obj=CustomerJob.objects.last()
						prorityIdforParcel=last_customer_obj.priorityBaseIDForParcel
						prorityIdforParcel=prorityIdforParcel+1
						prorityIdforParcel=prorityandChecking(prorityIdforParcel)
						customerjob_obj = CustomerJob.objects.create(order = order_obj, sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, length = length_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = rate, pickuptimeslot = pickuptimeslot_val, dropofftimeslot = dropofftimeslot_val, specialbooking = specialbooking, specialbooking_charge = specialbooking_charge,sameIdForParcelsDetails=sameIdForStoring,no_of_item_in_parcel=noofitems,deliverySafePlace=safePalace,pickuptimeslotDate=dat2,dropoffspecialnote=dropspecialnote,priorityBaseIDForParcel=prorityIdforParcel)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							CustomerJobDateTime.objects.create(job = customerjob_obj, payment_datetime = current_date)
						except Exception as e:
							print(e)
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = user_obj, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							# codec = 'data:image/png;base64,' + imagebase64_val
							codec = imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
						
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})

class PlaceOrderTest2(TemplateView):
	template_name = 'placeorder_test2.html' 

	def get_context_data(self,**kwargs):
		'''This function passes arguments to place order page. '''
		context = super(PlaceOrderTest2, self).get_context_data(**kwargs)
		print("PlaceOrderTest2 - in get ")
		allparceltypes = ParcelType.objects.all()
		context['allparceltypes'] = allparceltypes
		# print(allparceltypes)
		data = []
		
		data.append({
			'id' : 1,
			'weight' : 'Less than 5 kg',
			})
		data.append({
			'id' : 2,
			'weight' : 'More than 5 kg but less than 20 kg',
			})
		data.append({
			'id' : 3,
			'weight' : 'More than 20 kg but less than 50 kg',
			})
		data.append({
			'id' : 4,
			'weight' : 'More than 50 kg',
			})

		print(data)
		context['allparcelweights'] = data
		timeslots_data = []
		alltimeslots = TimeSlots.objects.filter(active = True)
		if alltimeslots:
			for slot in alltimeslots:
				timeslots_data.append({
					'openinghour' : slot.openinghour.strftime("%I:%M %p"),
					'closinghour' : slot.closinghour.strftime("%I:%M %p"),
					'status' : slot.active,
					})
		# print(timeslots_data)
		context['alltimeslots'] = timeslots_data
		context['placeorder_section'] = 'yes'
		return context	

	def post(self, request, *args, **kwargs):
		'''This function is being used to save the customer job request details in the database'''
		print('\n\n')
		print('PlaceOrderTest2 Web - in post')
		print('\n\n')
		# print(request.POST)
		# print('\n\n')


		def generateqrcode(id_val):
			print(id_val)
			import pyqrcode, png, os
			# from pyqrcode import QRCode
			customerjob_obj = CustomerJob.objects.get(id = id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				pass
			else:
				os.umask(0)
				os.mkdir(filepath)
			
			url = pyqrcode.create(content = 'AWB-' + str(id_val))
			url.png(filepath + '/qrcode.png',scale = 8)
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
			customerjob_obj.qrcode = filename
			customerjob_obj.save()
			return('1')


		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')



		# session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')
		ordertype = request.POST.get('ordertype')
		totalamount = request.POST.get('totalamount')
		vehicletype = request.POST.get('vehicletype')
		totalamount = str(totalamount.split(' ')[-1])


		
		try:
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
				print(email_val)
				user_obj = User.objects.filter(email = email_val).first()
				print('2')
				customer_obj = Customer.objects.filter(user = user_obj).first()
				print('3')
				if customer_obj:
					if ordertype == 'singledrop':
						ordertype = 1
					elif ordertype == 'multidrop':
						ordertype = 2
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Order type is required.'})
					order_obj = Order.objects.create(customer = customer_obj, ordertype = ordertype, totalamount = float(totalamount), isdeleted = False)
		except Exception as e:
			print(e)
		print('0')

		print(type(parcels_data))
		parcels_data = json.loads(parcels_data)
		print('1')
		print(totalamount)
		if payment_token:
			try:	
				print(payment_token)
				stripe.api_key = str(settings.STRIPE_KEY)
				charge = stripe.Charge.create(
				amount = int(float(totalamount)*100),
				currency = 'gbp',
				description = 'Parcel Payment',
				source = payment_token,
				)
				print(charge)
				OrderPayment.objects.create(order = order_obj, stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
			except Exception as e:
				print('Exception in creating charge = ', e)
		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')

		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			user_obj = User.objects.filter(email = email_val).first()
			print('2')
			customer_obj = Customer.objects.filter(user = user_obj).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print('\n')
					# print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = parcel['sendercity']
					# noofparcels_val = parcel['noofparcels']
					length_val = parcel['length']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']
					pickuptimeslot_val = parcel['pickuptimeslot']
					dropofftimeslot_val = parcel['dropofftimeslot']

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val = parcel['recipientlongitude']

					# vehicletype_val = parcel['vehicletype']
					# price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					specialbooking_val = parcel['specialbooking']
					if specialbooking_val == 'yes':
						specialbooking = True
					else:
						specialbooking = False
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype).first()
					if vehicletype_obj:
						print('5')
						try:
							distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
							if distancetable_obj:
								distance = distancetable_obj.distance

										# distance = totaldistanceinmiles
								if distance <= vehicletype_obj.fixeddistance:
									rate = vehicletype_obj.baserate
								else:
									rate = vehicletype_obj.baserate
									print('\n')
									print(vehicletype_obj.name)
									print(rate)
									distance = distance - vehicletype_obj.fixeddistance
									# print(totaldistanceinmiles)
									if distance > int(distance):
										distance = int(distance) + 1
									else:
										distance = distance
									print(distance)
									print(vehicletype_obj.addittionalrateperunit)
									rate = rate + distance * vehicletype_obj.addittionalrateperunit
									print(rate)

								pass
						except Exception as e:
							print(e)
						try:
							specialbooking_charge = 0.0
							if specialbooking:
								backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
								if backendcontrol_obj:
									specialbooking_charge = backendcontrol_obj.price
						except Exception as e:
							print(e)
						customerjob_obj = CustomerJob.objects.create(order = order_obj, sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, length = length_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = rate, pickuptimeslot = pickuptimeslot_val, dropofftimeslot = dropofftimeslot_val, specialbooking = specialbooking, specialbooking_charge = specialbooking_charge)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							CustomerJobDateTime.objects.create(job = customerjob_obj, payment_datetime = current_date)
						except Exception as e:
							print(e)
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = user_obj, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							# codec = 'data:image/png;base64,' + imagebase64_val
							codec = imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
						
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		
		




class CompanyPlaceOrder(TemplateView):
	template_name = 'company_placeorder.html' 

	def get_context_data(self,**kwargs):
		'''This function passes arguments to place order page. '''
		context = super(CompanyPlaceOrder, self).get_context_data(**kwargs)
		print("CompanyPlaceOrder - in get ")
		allparceltypes = ParcelType.objects.all()
		context['allparceltypes'] = allparceltypes
		# print(allparceltypes)
		data = []
		
		data.append({
			'id' : 1,
			'weight' : 'Less than 5 kg',
			})
		data.append({
			'id' : 2,
			'weight' : 'More than 5 kg but less than 20 kg',
			})
		data.append({
			'id' : 3,
			'weight' : 'More than 20 kg but less than 50 kg',
			})
		data.append({
			'id' : 4,
			'weight' : 'More than 50 kg',
			})

		print(data)
		context['allparcelweights'] = data
		timeslots_data = []
		alltimeslots = TimeSlots.objects.filter(active = True)
		if alltimeslots:
			for slot in alltimeslots:
				timeslots_data.append({
					'openinghour' : slot.openinghour.strftime("%I:%M %p"),
					'closinghour' : slot.closinghour.strftime("%I:%M %p"),
					'status' : slot.active,
					})
		# print(timeslots_data)
		context['alltimeslots'] = timeslots_data
		context['placeorder_section'] = 'yes'
		return context	

	def post(self, request, *args, **kwargs):
		'''This function is being used to save the customer job request details in the database'''
		print('\n\n')
		print('PlaceOrderTest2 Web - in post')
		print('\n\n')
		# print(request.POST)
		# print('\n\n')


		def generateqrcode(id_val):
			print(id_val)
			import pyqrcode, png, os
			# from pyqrcode import QRCode
			customerjob_obj = CustomerJob.objects.get(id = id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				pass
			else:
				os.umask(0)
				os.mkdir(filepath)
			
			url = pyqrcode.create(content = 'AWB-' + str(id_val))
			url.png(filepath + '/qrcode.png',scale = 8)
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
			customerjob_obj.qrcode = filename
			customerjob_obj.save()
			return('1')


		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')



		# session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')
		ordertype = request.POST.get('ordertype')
		vehicletype = request.POST.get('vehicletype')
		
		totalamount = request.POST.get('totalamount')
		totalamount = str(totalamount.split(' ')[-1])
		
		credits_to_be_used = request.POST.get('credits_to_be_used')
		credits_to_be_used = str(credits_to_be_used.split(' ')[-1])

		
		try:
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
				print(email_val)
				user_obj = User.objects.filter(email = email_val).first()
				print('2')
				customer_obj = Customer.objects.filter(user = user_obj).first()
				print('3')
				if customer_obj:
					companydetail_obj = CompanyDetail.objects.filter(customer__email = customer_obj.email).first()
					if companydetail_obj:
						if companydetail_obj.credits - float(credits_to_be_used) < 0.0:
							return JsonResponse({'status_code': 900, 'status_message': 'You have insufficient credits to book this parcel. Please request credits from profile section or place order select card.'})
					if ordertype == 'singledrop':
						ordertype = 1
					elif ordertype == 'multidrop':
						ordertype = 2
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Order type is required.'})
					order_obj = Order.objects.create(customer = customer_obj, ordertype = ordertype, totalamount = float(totalamount), isdeleted = False)
		except Exception as e:
			print(e)
		print('0')

		print(type(parcels_data))
		parcels_data = json.loads(parcels_data)
		print('1')
		print(totalamount)
		if payment_token:
			try:	
				print(payment_token)
				stripe.api_key = str(settings.STRIPE_KEY)
				charge = stripe.Charge.create(
				amount = int(float(totalamount)*100),
				currency = 'gbp',
				description = 'Parcel Payment',
				source = payment_token,
				)
				print(charge)
				OrderPayment.objects.create(order = order_obj, stripe_charge_response = str(charge), stripe_charge_id = charge.id, stripe_amount = float((charge.amount)/100))
			except Exception as e:
				print('Exception in creating charge = ', e)
		else:
			companydetail_obj = CompanyDetail.objects.filter(customer__email = customer_obj.email).first()
			if companydetail_obj:
				if companydetail_obj.credits - float(credits_to_be_used) >= 0.0:
					companydetail_obj.credits -= float(credits_to_be_used)
					companydetail_obj.save()
					orderpayment_obj = OrderPayment.objects.create(order = order_obj, method = 'credits', credits_to_be_used = float(credits_to_be_used))
					if orderpayment_obj:
						pass
						print('credits payment success')
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Internal Server Error.'})	
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'You have insufficient credits to book this parcel. Please request credits from profile section.'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'You have insufficient credits to book this parcel. Please request credits from profile section.'})
		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')
		try:
			last_customer_obj=CustomerJob.objects.last()
			if last_customer_obj:
				if int(last_customer_obj.sameIdForParcelsDetails)==0:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1000
				else:
					sameIdForStoring=int(last_customer_obj.sameIdForParcelsDetails)+1
		except Exception as e:
			pass
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			user_obj = User.objects.filter(email = email_val).first()
			print('2')
			customer_obj = Customer.objects.filter(user = user_obj).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print('\n')
					# print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = parcel['sendercity']
					# noofparcels_val = parcel['noofparcels']
					length_val = parcel['length']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']
					pickuptimeslot_val = parcel['pickuptimeslot']
					dropofftimeslot_val = parcel['dropofftimeslot']

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val = parcel['recipientlongitude']

					# vehicletype_val = parcel['vehicletype']
					# price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					specialbooking_val = parcel['specialbooking']
					if specialbooking_val == 'yes':
						specialbooking = True
					else:
						specialbooking = False
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype).first()
					if vehicletype_obj:
						print('5')
						try:
							distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
							if distancetable_obj:
								distance = distancetable_obj.distance

										# distance = totaldistanceinmiles
								if distance <= vehicletype_obj.fixeddistance:
									rate = vehicletype_obj.baserate
								else:
									rate = vehicletype_obj.baserate
									print('\n')
									print(vehicletype_obj.name)
									print(rate)
									distance = distance - vehicletype_obj.fixeddistance
									# print(totaldistanceinmiles)
									if distance > int(distance):
										distance = int(distance) + 1
									else:
										distance = distance
									print(distance)
									print(vehicletype_obj.addittionalrateperunit)
									rate = rate + distance * vehicletype_obj.addittionalrateperunit
									print(rate)

								pass
						except Exception as e:
							print(e)
						try:
							specialbooking_charge = 0.0
							if specialbooking:
								backendcontrol_obj = BackendControl.objects.filter(name = 'Special Booking Charges').first()
								if backendcontrol_obj:
									specialbooking_charge = backendcontrol_obj.price
						except Exception as e:
							print(e)
						customerjob_obj = CustomerJob.objects.create(order = order_obj, sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, length = length_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = rate, pickuptimeslot = pickuptimeslot_val, dropofftimeslot = dropofftimeslot_val, specialbooking = specialbooking, specialbooking_charge = specialbooking_charge,sameIdForParcelsDetails=sameIdForStoring)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							current_date = datetime.datetime.now()
							CustomerJobDateTime.objects.create(job = customerjob_obj, payment_datetime = current_date)
						except Exception as e:
							print(e)
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = user_obj, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							# codec = 'data:image/png;base64,' + imagebase64_val
							codec = imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
						
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		
		# print('data is  : ',request.POST)
		try:
			# print(request.POST)
			
			def generateqrcode(id_val):
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					pass
				else:
					os.mkdir(filepath)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')


			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				base64_data = codec.split(";base64,")
				extens = base64_data[0]
				ext = extens.split("/")
				extension = str(ext[1])
				base64_data = base64_data[1]
				byte_data = base64.b64decode(base64_data)
				image_data = BytesIO(byte_data)
				from PIL import Image
				import string, random, os
				img = Image.open(image_data)
				customerjob_obj = CustomerJob.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.mkdir(filepath)
				img = Image.open(image_data)
				im = img.thumbnail([400,400], Image.ANTIALIAS)
				im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
				customerjob_obj.image = filename
				customerjob_obj.save()
				return('1')



			session_token_val = request.POST.get('session_token')
			payment_token = request.POST.get('payment_token')
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			senderlatitude_val = request.POST.get('senderlatitude')
			senderlongitude_val = request.POST.get('senderlongitude')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')
			recipientspecialnote_val = request.POST.get('recipientspecialnote')
			recipientlatitude_val = request.POST.get('recipientlatitude')
			recipientlongitude_val = request.POST.get('recipientlongitude')

			vehicletype_val = request.POST.get('vehicletype')
			price_val = request.POST.get('price')
			imagebase64_val = request.POST.get('imagebase64')
			
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			# if not payment_token:
			# 	return Response({'status': 0, 'message': 'payment_token Empty',})
			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			if not sendercountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender senderphone_val is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})

			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype_val is required'})
			if not price_val:
				return JsonResponse({'status_code': 400, 'status_message': 'price_val is required'})
			# if not imagebase64_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'Image is required'})
			
			if payment_token:
				try:	
					print(payment_token)
					# stripe.api_key = 'sk_test_w82uzdTc8eWEVizgPOI0WRnj00n43jBnY5'
					str(settings.STRIPE_KEY)
					charge = stripe.Charge.create(
					amount=int(float(price_val)*100),
					currency='eur',
					description='Parcel Payment',
					source=payment_token,
					)
					print(charge)
				except Exception as e:
					print('Exception in creating charge = ', e)
			deliveryduration_val = 1
			print('0')
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					print('4')
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype_val).first()
					if vehicletype_obj:
						print('5')
						customerjob_obj = CustomerJob.objects.create(sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = price_val)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': customerjob_obj.id})	
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})	
			user_obj = User.objects.filter(username = 'raheja@yopmail.com').first()
			if user_obj:
				pass	
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			
			token_obj = Token.objects.filter()

			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj, accountapproved = True).first()
				if customer_obj:
					# content_object = customer_obj,
					otp_obj = OTP.objects.filter(case = 'signup',otp = otp_val).last()
					if otp_obj:
						st_time = otp_obj.startdatetime
						ex_time = otp_obj.expiredatetime
						print(st_time)
						print(ex_time)
						timezone = str(settings.TIME_ZONE)
						time = datetime.datetime.now(pytz.timezone(timezone))
						print(time)
						if((time>st_time) and (time<ex_time)):
							otp_obj.verified = True
							otp_obj.save()
							return JsonResponse({'status_code': 200, 'status_message': 'User registered successfully.'})							
						else:
							return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired 1'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
				
			else:
				return JsonResponse({'status_code': 401, 'status_message': 'User not logged in.'})
				
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})






class PlaceOrderTest(APIView):
	'''This class is being used to save the customer job request details in the database'''
	
	def post(self, request, *args, **kwargs):
		print('\n\n')
		print('PlaceOrderTest Web - in post')
		print('\n\n')
		# print(request.POST)
		# print('\n\n')


		def generateqrcode(id_val):
			print(id_val)
			import pyqrcode, png, os
			# from pyqrcode import QRCode
			customerjob_obj = CustomerJob.objects.get(id = id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				pass
			else:
				os.umask(0)
				os.mkdir(filepath)
			
			url = pyqrcode.create(content = 'AWB-' + str(id_val))
			url.png(filepath + '/qrcode.png',scale = 8)
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
			customerjob_obj.qrcode = filename
			customerjob_obj.save()
			return('1')


		def getI420FromBase64(codec, id_val, image_path="c:\\"):
			print(id_val)
			base64_data = codec.split(";base64,")
			extens = base64_data[0]
			ext = extens.split("/")
			extension = str(ext[1])
			base64_data = base64_data[1]
			byte_data = base64.b64decode(base64_data)
			image_data = BytesIO(byte_data)
			from PIL import Image
			import string, random, os
			img = Image.open(image_data)
			customerjob_obj = CustomerJob.objects.get(id=id_val)
			st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
			thumbnailsize_objs = ThumbnailSize.objects.all()
			filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
			if(os.path.exists(filepath)):
				filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
				for f in filesToRemove:
					os.remove(f) 
			else:
				os.mkdir(filepath)
			img = Image.open(image_data)
			im = img.thumbnail([400,400], Image.ANTIALIAS)
			im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
			
			filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
			customerjob_obj.image = filename
			customerjob_obj.save()
			return('1')



		session_token_val = request.POST.get('session_token')
		parcels_data = request.POST.get('parcels_data')
		noofparcels_val = request.POST.get('noofparcels')
		payment_token = request.POST.get('payment_token')

		print('0')

		print(type(parcels_data))
		parcels_data = json.loads(parcels_data)
		print('1')
		totalprice = 0.0
		for parcel in parcels_data:
			print('\n')
			totalprice += float(parcel['price'])
			print(parcel['price'])
		print(totalprice)
		if payment_token:
			try:	
				print(payment_token)
				stripe.api_key = str(settings.STRIPE_KEY)
				charge = stripe.Charge.create(
				amount=int(float(totalprice)*100),
				currency='gbp',
				description='Parcel Payment',
				source=payment_token,
				)
				print(charge)
			except Exception as e:
				print('Exception in creating charge = ', e)
		# return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		deliveryduration_val = 1
		print('0')

		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			user_obj = User.objects.filter(email = email_val).first()
			print('2')
			customer_obj = Customer.objects.filter(user = user_obj).first()
			print('3')
			if customer_obj:
				print('4')
				for parcel in parcels_data:
					print('\n')
					# print(parcel)
					print('\n')
					print(parcel['sendername'])
					print(parcel['sendercountrycode'])
					print(parcel['senderphone'])
					print(parcel['pickupaddress'])
					print(parcel['sendercity'])
					# print(parcel['noofparcels'])
					print(parcel['width'])
					print(parcel['height'])
					print(parcel['weight'])
					print(parcel['parceltype'])
					print(parcel['specialnote'])
					print(parcel['recipientname'])
					print(parcel['recipientcountrycode'])
					print(parcel['recipientphone'])
					print(parcel['dropaddress'])
					sendername_val = parcel['sendername']
					sendercountrycode_val = parcel['sendercountrycode']
					senderphone_val = parcel['senderphone']
					
					senderlatitude_val = parcel['senderlatitude']
					senderlongitude_val = parcel['senderlongitude']

					pickupaddress_val = parcel['pickupaddress']
					sendercity_val = parcel['sendercity']
					# noofparcels_val = parcel['noofparcels']
					width_val = parcel['width']
					height_val = parcel['height']
					weight_val = parcel['weight']
					parceltype_val = parcel['parceltype']
					specialnote_val = parcel['specialnote']
					recipientname_val = parcel['recipientname']
					recipientcountrycode_val = parcel['recipientcountrycode']
					recipientphone_val = parcel['recipientphone']
					dropaddress_val = parcel['dropaddress']

					recipientlatitude_val = parcel['recipientlatitude']
					recipientlongitude_val = parcel['recipientlongitude']

					vehicletype_val = parcel['vehicletype']
					price_val = parcel['price']
					imagebase64_val = parcel['imagebase64']
					# return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype_val).first()
					if vehicletype_obj:
						print('5')
						customerjob_obj = CustomerJob.objects.create(sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = price_val)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = user_obj, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							# codec = 'data:image/png;base64,' + imagebase64_val
							codec = imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						try:
							res = generateparcelpdf(customerjob_obj.id)
							print(res)
						except Exception as e:
							print(e)
						
						
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		else:
			return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
		lastcustomerjobid = CustomerJob.objects.last().id
		return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': lastcustomerjobid})	
		return JsonResponse({'status_code': 400, 'status_message': 'How are you?'})
		return JsonResponse({'status_code': 200, 'status_message': 'success.'})
		
		# print('data is  : ',request.POST)
		try:
			# print(request.POST)
			
			def generateqrcode(id_val):
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					pass
				else:
					os.mkdir(filepath)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')


			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				base64_data = codec.split(";base64,")
				extens = base64_data[0]
				ext = extens.split("/")
				extension = str(ext[1])
				base64_data = base64_data[1]
				byte_data = base64.b64decode(base64_data)
				image_data = BytesIO(byte_data)
				from PIL import Image
				import string, random, os
				img = Image.open(image_data)
				customerjob_obj = CustomerJob.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.mkdir(filepath)
				img = Image.open(image_data)
				im = img.thumbnail([400,400], Image.ANTIALIAS)
				im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
				customerjob_obj.image = filename
				customerjob_obj.save()
				return('1')



			session_token_val = request.POST.get('session_token')
			payment_token = request.POST.get('payment_token')
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			senderlatitude_val = request.POST.get('senderlatitude')
			senderlongitude_val = request.POST.get('senderlongitude')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')
			recipientspecialnote_val = request.POST.get('recipientspecialnote')
			recipientlatitude_val = request.POST.get('recipientlatitude')
			recipientlongitude_val = request.POST.get('recipientlongitude')

			vehicletype_val = request.POST.get('vehicletype')
			price_val = request.POST.get('price')
			imagebase64_val = request.POST.get('imagebase64')
			
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			# if not payment_token:
			# 	return Response({'status': 0, 'message': 'payment_token Empty',})
			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			if not sendercountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender senderphone_val is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})

			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype_val is required'})
			if not price_val:
				return JsonResponse({'status_code': 400, 'status_message': 'price_val is required'})
			# if not imagebase64_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'Image is required'})
			
			if payment_token:
				try:	
					print(payment_token)
					# stripe.api_key = 'sk_test_w82uzdTc8eWEVizgPOI0WRnj00n43jBnY5'
					str(settings.STRIPE_KEY)
					charge = stripe.Charge.create(
					amount=int(float(price_val)*100),
					currency='eur',
					description='Parcel Payment',
					source=payment_token,
					)
					print(charge)
				except Exception as e:
					print('Exception in creating charge = ', e)
			deliveryduration_val = 1
			print('0')
			token_obj = Token.objects.filter(key = session_token_val).first()
			print('1')
			if token_obj:
				print('2')
				user_id = token_obj.user_id
				customer_obj = Customer.objects.filter(user__id = user_id).first()
				print('3')
				if customer_obj:
					print('4')
					vehicletype_obj = VehicleType.objects.filter(name = vehicletype_val).first()
					if vehicletype_obj:
						print('5')
						customerjob_obj = CustomerJob.objects.create(sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = price_val)
						if senderlatitude_val:
							customerjob_obj.senderlatitude = senderlatitude_val
							customerjob_obj.senderlongitude = senderlongitude_val
							customerjob_obj.recipientlatitude = recipientlatitude_val
							customerjob_obj.recipientlongitude = recipientlongitude_val
							customerjob_obj.save()
						try:
							Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
							Notifications.objects.create(user = token_obj.user, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
						except Exception as e:
							print(e)
						try:
							sendfcmnotification(customer_obj.fcmtoken, 'customer', 'parcel', 'KwickDelivery', 'Your parcel details are saved successfully')
						except Exception as e:
							print(e)
						if imagebase64_val:
							codec = 'data:image/png;base64,' + imagebase64_val
							print('before function call')
							getI420FromBase64(codec, id_val = customerjob_obj.id)
							print('after function call')
						try:
							generateqrcode(id_val = customerjob_obj.id)
							print('after function call')
						except Exception as e:
							print(e)
						return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': customerjob_obj.id})	
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})	
			user_obj = User.objects.filter(username = 'raheja@yopmail.com').first()
			if user_obj:
				pass	
			
			if not session_token_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			
			token_obj = Token.objects.filter()

			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj, accountapproved = True).first()
				if customer_obj:
					# content_object = customer_obj,
					otp_obj = OTP.objects.filter(case = 'signup',otp = otp_val).last()
					if otp_obj:
						st_time = otp_obj.startdatetime
						ex_time = otp_obj.expiredatetime
						print(st_time)
						print(ex_time)
						timezone = str(settings.TIME_ZONE)
						time = datetime.datetime.now(pytz.timezone(timezone))
						print(time)
						if((time>st_time) and (time<ex_time)):
							otp_obj.verified = True
							otp_obj.save()
							return JsonResponse({'status_code': 200, 'status_message': 'User registered successfully.'})							
						else:
							return JsonResponse({'status_code': 0, 'status_message': 'OTP has expired 1'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Customer exists.'})
				
			else:
				return JsonResponse({'status_code': 401, 'status_message': 'User not logged in.'})
				
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})




class ContactForm(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('ContactForm - post ')

		print('data is  : ',request.POST)
		try:
			name_val = request.POST.get('name')
			email_val = request.POST.get('email')
			message_val = request.POST.get('message')
			if not name_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter name'})
			if not email_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter email'})
			if not message_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter message'})
			
			message = 'There is a message from ' + email_val + '\n'
			message += name_val + ' : ' + message_val
			try:
				print(message)
				res = send_mail('Contact Form:',message,'tmpython4esf@gmail.com',['test@yopmail.com'],fail_silently=False)
				print(res)
				return JsonResponse({'status_code': 200, 'status_message' : 'Request sent.'})
			except Exception as e:
				print(e)
			
		
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})






# @method_decorator(checklogincustomer, name='dispatch')
class QuickFareEstimate(TemplateView):
	template_name = 'customer_quickfareestimate.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(QuickFareEstimate, self).get_context_data(**kwargs)
		print("QuickFareEstimate - in get ")
		data = []
		allvehicletypes = VehicleType.objects.filter(isdeleted = False)
		if allvehicletypes:
			for vehicletype in allvehicletypes:
				data.append({
					'vehicletypeid' : vehicletype.id,
					'vehicletype' : vehicletype.name,
					})
		context['allvehicletypes'] = data
		return context

	def post(self, request, *args, **kwargs):
		try:
			print('QuickFareEstimate API - in post')
			
			def getdistancebetweentwolocations(pickupaddress_val, dropaddress_val, senderlatitude_val, senderlongitude_val, recipientlatitude_val, recipientlongitude_val):
				try:

					api_key = str(settings.GOOGLE_API_KEY)

					pickupaddress_val = pickupaddress_val.replace(' ','')
					pickupaddress_val = pickupaddress_val.replace('#','')
					dropaddress_val = dropaddress_val.replace(' ','')
					dropaddress_val = dropaddress_val.replace('#','')
					source = pickupaddress_val

					dest = dropaddress_val

					url ='https://maps.googleapis.com/maps/api/distancematrix/json?'
					if senderlatitude_val and senderlongitude_val and recipientlatitude_val and recipientlongitude_val:
						sendercoordinates_val = senderlatitude_val + ',' + senderlongitude_val
						recipientcoordinates_val = recipientlatitude_val + ',' + recipientlongitude_val
					# return response object 
						print(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
						r = requests.get(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
					else:
						print(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)
						r = requests.get(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

					x = r.json() 
					print(x) 
					print('\n')
					if x['status'] == 'OK':
						multiplicationfactor = 0.000621371192
						distanceinmiles = float(x['rows'][0]['elements'][0]['distance']['value']) * multiplicationfactor
						# print(distanceinmiles)
						
						distancetable_obj = DistanceTable(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distance = distanceinmiles, distanceunit = 'mile', time = x['rows'][0]['elements'][0]['duration']['value'])
						distancetable_obj.save()
						return(200, 'success', distanceinmiles)
					else:
						return(400, 'Enter valid address', '')
						
				except Exception as e:
					print(e)
					return(400, 'Enter valid address', '')


			def calculatefarefromdistanceforvehicletype(distanceinmiles, vehicletype_val):
				data = []
				try:
					vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', name = vehicletype_val).first()
					if vehicletype_obj:
						distance = distanceinmiles
						if distance <= vehicletype_obj.fixeddistance:
							rate = vehicletype_obj.baserate
						else:
							rate = vehicletype_obj.baserate
							distance = distance - vehicletype_obj.fixeddistance
							if distance > int(distance):
								distance = int(distance) + 1
							else:
								distance = distance
							rate = rate + distance * vehicletype_obj.addittionalrateperunit
						image = ''
						if vehicletype_obj.name == 'Bike':
							image = str(settings.WEB_BASE_URL) + '/static/images/bike.png'
						elif vehicletype_obj.name == 'Car':
							image = str(settings.WEB_BASE_URL) + '/static/images/car.jpg'
						elif vehicletype_obj.name == 'Small Van':
							image = str(settings.WEB_BASE_URL) + '/static/images/smallvan.png'
						elif vehicletype_obj.name == 'Medium Van':
							image = str(settings.WEB_BASE_URL) + '/static/images/smallvan.png'
						elif vehicletype_obj.name == 'Large Van':
							image = str(settings.WEB_BASE_URL) + '/static/images/largevan.jpg'
							
						data.append({"vehicletype" : vehicletype_obj.name, 'price' : str(round(float(rate),2)), 'currency' : vehicletype_obj.currency, 'image' : image})
					return(200, 'success', data)
				except Exception as e:
					print(e)
					return(400, 'Enter valid address', data)

			



			# def getquickfareforvehicletype(pickupaddress_val, dropaddress_val, vehicletype_val, sendercoordinates_val, recipientcoordinates_val):
			# 	data = []
			# 	try:

			# 		api_key = str(settings.GOOGLE_API_KEY)

			# 		pickupaddress_val = pickupaddress_val.replace(' ','')
			# 		pickupaddress_val = pickupaddress_val.replace('#','')
			# 		dropaddress_val = dropaddress_val.replace(' ','')
			# 		dropaddress_val = dropaddress_val.replace('#','')
			# 		source = pickupaddress_val

			# 		dest = dropaddress_val

			# 		url ='https://maps.googleapis.com/maps/api/distancematrix/json?'
			# 		if sendercoordinates_val and recipientcoordinates_val:
			# 		# return response object 
			# 			print(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
			# 			r = requests.get(url + 'origins=' + sendercoordinates_val + '&destinations=' + recipientcoordinates_val + '&key=' + api_key)
			# 		else:
			# 			print(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)
			# 			r = requests.get(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

			# 		x = r.json() 
			# 		print(x) 
			# 		print('\n')
			# 		if x['status'] == 'OK':
			# 			multiplicationfactor = 0.000621371192
			# 			distanceinmiles = float(x['rows'][0]['elements'][0]['distance']['value']) * multiplicationfactor
			# 			# print(distanceinmiles)
			# 			vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', name = vehicletype_val).first()
			# 			if vehicletype_obj:
			# 				distance = distanceinmiles
			# 				if distance <= vehicletype_obj.fixeddistance:
			# 					rate = vehicletype_obj.baserate
			# 				else:
			# 					rate = vehicletype_obj.baserate
			# 					distance = distance - vehicletype_obj.fixeddistance
			# 					if distance > int(distance):
			# 						distance = int(distance) + 1
			# 					else:
			# 						distance = distance
			# 					rate = rate + distance * vehicletype_obj.addittionalrateperunit
			# 				image = ''
			# 				if vehicletype_obj.name == 'Bike':
			# 					image = str(settings.WEB_BASE_URL) + '/static/images/bike.png'
			# 				elif vehicletype_obj.name == 'Car':
			# 					image = str(settings.WEB_BASE_URL) + '/static/images/car.jpg'
			# 				elif vehicletype_obj.name == 'Small Van':
			# 					image = str(settings.WEB_BASE_URL) + '/static/images/smallvan.png'
			# 				elif vehicletype_obj.name == 'Medium Van':
			# 					image = str(settings.WEB_BASE_URL) + '/static/images/smallvan.png'
			# 				elif vehicletype_obj.name == 'Large Van':
			# 					image = str(settings.WEB_BASE_URL) + '/static/images/largevan.jpg'
								
			# 				data.append({"vehicletype" : vehicletype_obj.name, 'price' : str(round(float(rate),2)), 'currency' : vehicletype_obj.currency, 'image' : image})
			# 			return(200, 'success', data)
			# 		else:
			# 			return(400, 'Enter valid address', data)
						
			# 	except Exception as e:
			# 		print(e)
			# 		return(400, 'Enter valid address', data)

			print(request.POST)
			pickupaddress_val = request.POST.get('pickupaddress')
			senderlatitude_val = request.POST.get('senderlatitude')
			senderlongitude_val = request.POST.get('senderlongitude')
			dropaddress_val = request.POST.get('dropaddress')
			recipientlatitude_val = request.POST.get('recipientlatitude')
			recipientlongitude_val = request.POST.get('recipientlongitude')
			vehicletype_val = request.POST.get('vehicletype')

			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress is required'})
			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype is required'})
			
			distancetable_obj = DistanceTable.objects.filter(senderlatitude = senderlatitude_val, senderlongitude = senderlongitude_val, recipientlatitude = recipientlatitude_val, recipientlongitude = recipientlongitude_val, distanceunit = 'mile').first()
			if distancetable_obj:
				print('distance found in DistanceTable')
				distance = distancetable_obj.distance
			else:
				print('distance not found in DistanceTable')

				status_code, status_message, distance = getdistancebetweentwolocations(pickupaddress_val = pickupaddress_val, dropaddress_val = dropaddress_val,  senderlatitude_val = senderlatitude_val, senderlongitude_val = senderlongitude_val, recipientlatitude_val = recipientlatitude_val, recipientlongitude_val = recipientlongitude_val)
				print(status_code, status_message, distance)
				if status_code != 200:
					return JsonResponse({'status_code': status_code, 'status_message': status_message})

			status_code, status_message, data = calculatefarefromdistanceforvehicletype(distanceinmiles = distance, vehicletype_val = vehicletype_val)
			print(status_code, status_message, data)
			if status_code == 200:
				return JsonResponse({'status_code': status_code, 'status_message' : status_message, 'data' : data})
				
			return JsonResponse({'status_code': status_code, 'status_message' : status_message})

			# status_code, status_message, data = getquickfareforvehicletype(pickupaddress_val, dropaddress_val, vehicletype_val, sendercoordinates_val, recipientcoordinates_val)
			
			# return JsonResponse({'status_code': status_code, 'status_message' : status_message, 'data' : data})
		except Exception as error:
			print('error is',error)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})


@method_decorator(checklogincustomer, name='dispatch')
class CustomerNotifications(TemplateView):
	template_name = 'customer_notifications.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(CustomerNotifications, self).get_context_data(**kwargs)
		print("CustomerNotifications - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				notifications_data = []
				all_notifications = Notifications.objects.filter(user = user_obj).order_by('-id')
				if all_notifications:
					serialno = 0
					for notification in all_notifications:
						serialno += 1
						notifications_data.append({
							'serialno' : serialno,
							'id' : notification.id,
							'forcustomer' : notification.forcustomer,
							'notificationtype' : notification.notificationtype,
							'notificationtext' : notification.notificationtext,
							'status' : notification.status,
							'date' : notification.date,
							'customerjobid' : notification.customerjobid,
							'deleted' : notification.deleted,
							})
					# print(notifications_data)
					paginator = Paginator(notifications_data, 15)
					page = int(self.request.GET.get('page',1))
					print('page = ', page)
					try:
						notifications_data = paginator.page(page)
						print(len(notifications_data))
						print('try')
					except PageNotAnInteger:
						notifications_data = paginator.page(paginator.num_pages)
						print("except1")
					except EmptyPage:
						notifications_data = paginator.page(paginator.num_pages)
						print("except2")
					context['all_notifications'] = notifications_data
					context['userrole'] = 'customer'
					Notifications.objects.filter(user = user_obj).update(status = 'read')
		return context	



class CustomerJobRaiseTicket(TemplateView):
	template_name = 'customerjobraiseticket.html'
	def post(self, request, *args, **kwargs):
		print("CustomerJobRaiseTicket - in post ")
		print('\n\n')
		print(request.POST)
		try:	
			customerjobid = request.POST.get('customerjobid')
			complaintmessage = request.POST.get('complaintmessage')
			disputemessagethreadmodel_obj = DisputeMessageThreadModel.objects.filter(customerjob_id = customerjobid).first()
			if disputemessagethreadmodel_obj:
				DisputeMessageModel.objects.create(disputemessagethread = disputemessagethreadmodel_obj, customerjob = disputemessagethreadmodel_obj.customerjob, message = complaintmessage, fromuser = True)
			else:
				print('in else')
				disputemessagethreadmodel_obj = DisputeMessageThreadModel.objects.create(customerjob_id = customerjobid)
				if disputemessagethreadmodel_obj:
					print('if')
					DisputeMessageModel.objects.create(disputemessagethread = disputemessagethreadmodel_obj, customerjob = disputemessagethreadmodel_obj.customerjob, message = complaintmessage, fromuser = True)
			return JsonResponse({'status_code': 200, 'status_message': 'success'})

		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})
		
	
	def get_context_data(self,**kwargs):
		context = super(CustomerJobRaiseTicket, self).get_context_data(**kwargs)
		
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			data = {}
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj).first()
				if customer_obj:
					customerjobid = kwargs['customerjobid']
					print(customerjobid)
					disputemessagethreadmodel_obj = DisputeMessageThreadModel.objects.filter(customerjob_id = customerjobid).first()
					if disputemessagethreadmodel_obj:
						disputemessagemodel_obj = DisputeMessageModel.objects.filter(disputemessagethread = disputemessagethreadmodel_obj)
						if disputemessagemodel_obj:
							context['disputemessage'] = disputemessagemodel_obj
							print(context['disputemessage'])
		context['customerjobid'] = customerjobid
		return context

class CustomerJobDetail(TemplateView):
	template_name = 'customerjobdetail.html'
	def post(self, request, *args, **kwargs):
		pass
		# print("AboutUs-in post ")
	
	def get_context_data(self,**kwargs):
		context = super(CustomerJobDetail, self).get_context_data(**kwargs)
		
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			data = {}
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj).first()
				if customer_obj:
					customerjobid = kwargs['customerjobid']
					print(customerjobid)
					customerjob_obj=CustomerJob.objects.filter(id = customerjobid, customer = customer_obj).first()
					if customerjob_obj:

						if not customerjob_obj.sendercountrycode:
							sendercountrycode = ''
						else:
							sendercountrycode = customerjob_obj.sendercountrycode

						if not customerjob_obj.recipientcountrycode:
							recipientcountrycode = ''
						else:
							recipientcountrycode = customerjob_obj.recipientcountrycode
						if not customerjob_obj.qrcode:
							qrcode = ''
						else:
							qrcode = str(settings.MEDIA_BASE_URL) + customerjob_obj.qrcode.name
						if customerjob_obj.parcelpdf:
							parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
						else:
							parcelpdf_link = ''
						parcelimage = ''
						if customerjob_obj.image:
							parcelimage = str(settings.MEDIA_BASE_URL) + customerjob_obj.image.name
							
						totalamount = customerjob_obj.price + customerjob_obj.specialbooking_charge
						customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob_obj).first()
						payment_datetime, pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', '', ''
						if customerjobdatetime_obj:
							payment_datetime = customerjobdatetime_obj.payment_datetime
							pickup_datetime = customerjobdatetime_obj.pickup_datetime
							itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime
							deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime

						dataLogging=False
						delivery_proof_method, delivery_toperson_name, delivery_toperson_phone, delivery_toperson_signature = '', '', '', ''
						pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
						customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job = customerjob_obj).first()
						if customerjobdeliveryextradetails_obj:
							dataLogging=True
							if customerjobdeliveryextradetails_obj.delivery_proof_method == 'signature':
								delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
								delivery_toperson_name = customerjobdeliveryextradetails_obj.delivery_toperson_name
								delivery_toperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.delivery_toperson_signature.name
							elif customerjobdeliveryextradetails_obj.delivery_proof_method == 'otp':
								delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
								delivery_toperson_name = customerjob_obj.recipientname
								delivery_toperson_phone = customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone
							else:
								delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method

							
							if customerjobdeliveryextradetails_obj.pickup_proof_method == 'signature':
								pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
								pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
								pickup_fromperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.pickup_fromperson_signature.name
							elif customerjobdeliveryextradetails_obj.pickup_proof_method == 'otp':
								pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
								pickup_fromperson_name = customerjob_obj.sendername
								pickup_fromperson_phone = customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone
							else:
								pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
								pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
						
						deliveryonSafePalaceorNot=False
						safePalaceDeliverData={}
						try:
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
							if driverjob_obj:
								SafePalaceObject=DriverDropSafePalace.objects.filter(customerjob=customerjob_obj,driver_job=driverjob_obj).first()
								if SafePalaceObject:
									deliveryonSafePalaceorNot=True
									safePalaceDeliverData.update({'image':SafePalaceObject.safeplace.name,
										               'dateandTime':SafePalaceObject.created_at,
										               })
						except Exception as e:
							print(e)

						deliveryIsFailedOrNot=False
						failedData={}
						try:
							deliveryFailed=CustomerJobDeliveryFailed.objects.filter(job=customerjob_obj,isdeleted=False).first()
							if deliveryFailed:
								deliveryIsFailedOrNot=True
								failedData.update({'image':deliveryFailed.deliveryfailed_image.name,
									               'dateandTime':deliveryFailed.deliveryfailed_datetime,
									               'reason':deliveryFailed.deliveryfailurereason, 
									               })
						except Exception as e:
							print(e)

						driverexist = False
						driverjob_data = {}
						driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
						if driverjob_obj:
							driverjob_data.update({
								'drivername' : driverjob_obj.driver.name,
								'drivercountrycode' : driverjob_obj.driver.countrycode,
								'driverphone' : driverjob_obj.driver.phone,
								'driverid' : driverjob_obj.driver.id,
								'driverjobid' : driverjob_obj.id,
								})
							driverexist = True	
						data.update({
							'id' : customerjob_obj.id,
							'sendername' : customerjob_obj.sendername,
							'senderemail' : customerjob_obj.customer.user.email,
							'sendercountrycode' : sendercountrycode,
							'senderphone' : customerjob_obj.senderphone,
							'sendercity' : customerjob_obj.sendercity,
							'senderpickupaddress' : customerjob_obj.pickupaddress,
							'pickuptimeslot' : customerjob_obj.pickuptimeslot,
							'recipientname' : customerjob_obj.recipientname,
							'recipientcountrycode' : recipientcountrycode,
							'recipientphone' : customerjob_obj.recipientphone,
							'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
							'dropofftimeslot' : customerjob_obj.dropofftimeslot,
							'length' : customerjob_obj.length,
							'weight' : customerjob_obj.weight,
							'height' : customerjob_obj.height,
							'width' : customerjob_obj.width,
							'parceltype' : customerjob_obj.parceltype,
							'image' : customerjob_obj.image,
							'vehicletype' : customerjob_obj.vehicletype.name,
							'price' : customerjob_obj.price,
							'specialbooking_charge' : customerjob_obj.specialbooking_charge,
							'totalamount' : totalamount,
							'parcelimage' : parcelimage,
							'parcelpdf_link' : parcelpdf_link,
							'qrcode' : qrcode,
							'customerjobid' : customerjob_obj.id,
							'awbnumber' : 'AWB-' + str(10000 + customerjob_obj.id),
							'driverexist' : driverexist,
							'driverdetails' : driverjob_data,

							'delivery_proof_method' : delivery_proof_method,
							'delivery_toperson_name' : delivery_toperson_name,
							'delivery_toperson_phone' : delivery_toperson_phone,
							'delivery_toperson_signature' : delivery_toperson_signature,
							
							'pickup_proof_method' : pickup_proof_method,
							'pickup_fromperson_name' : pickup_fromperson_name,
							'pickup_fromperson_phone' : pickup_fromperson_phone,
							'pickup_fromperson_signature' : pickup_fromperson_signature,

							'pickup_datetime' : pickup_datetime,
							'itemsdelivered_datetime' : itemsdelivered_datetime,
							'payment_datetime' : payment_datetime,
							'dataLogging':dataLogging,
							'deliveryIsFailedOrNot':deliveryIsFailedOrNot,
							'failedData':failedData,
							'deliveryonSafePalaceorNot':deliveryonSafePalaceorNot,
							'safePalaceDeliverData':safePalaceDeliverData,
							'pickuptimeslotDate':customerjob_obj.pickuptimeslotDate,
							})
		
						context['customerjob'] = data
						print(context['customerjob'])
		return context


class CustomerJobDetailExtraTest(TemplateView):
	template_name = 'customerjobdetail.html'
	def post(self, request, *args, **kwargs):
		pass
		# print("AboutUs-in post ")
	
	def get_context_data(self,**kwargs):
		context = super(CustomerJobDetailExtraTest, self).get_context_data(**kwargs)
		
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			allData=[]
			
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj).first()
				if customer_obj:
					customerjobid = kwargs['customerjobid']
					print(customerjobid)
					customerjob_objall=CustomerJob.objects.filter(sameIdForParcelsDetails = customerjobid, customer = customer_obj)
					if customerjob_objall:
						for customerjob_obj in customerjob_objall:
							data = {}
							if not customerjob_obj.sendercountrycode:
								sendercountrycode = ''
							else:
								sendercountrycode = customerjob_obj.sendercountrycode

							if not customerjob_obj.recipientcountrycode:
								recipientcountrycode = ''
							else:
								recipientcountrycode = customerjob_obj.recipientcountrycode
							if not customerjob_obj.qrcode:
								qrcode = ''
							else:
								qrcode = str(settings.MEDIA_BASE_URL) + customerjob_obj.qrcode.name
							if customerjob_obj.parcelpdf:
								parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
							else:
								parcelpdf_link = ''
							parcelimage = ''
							if customerjob_obj.image:
								parcelimage = str(settings.MEDIA_BASE_URL) + customerjob_obj.image.name
								
							totalamount = customerjob_obj.price + customerjob_obj.specialbooking_charge
							customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob_obj).first()
							payment_datetime, pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', '', ''
							if customerjobdatetime_obj:
								payment_datetime = customerjobdatetime_obj.payment_datetime
								pickup_datetime = customerjobdatetime_obj.pickup_datetime
								itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime
								deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime

							delivery_proof_method, delivery_toperson_name, delivery_toperson_phone, delivery_toperson_signature = '', '', '', ''
							pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
							customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job = customerjob_obj).first()
							if customerjobdeliveryextradetails_obj:
								if customerjobdeliveryextradetails_obj.delivery_proof_method == 'signature':
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
									delivery_toperson_name = customerjobdeliveryextradetails_obj.delivery_toperson_name
									delivery_toperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.delivery_toperson_signature.name
								elif customerjobdeliveryextradetails_obj.delivery_proof_method == 'otp':
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
									delivery_toperson_name = customerjob_obj.recipientname
									delivery_toperson_phone = customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone
								else:
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method

								
								if customerjobdeliveryextradetails_obj.pickup_proof_method == 'signature':
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
									pickup_fromperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.pickup_fromperson_signature.name
								elif customerjobdeliveryextradetails_obj.pickup_proof_method == 'otp':
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjob_obj.sendername
									pickup_fromperson_phone = customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone
								else:
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
							
							driverexist = False
							driverjob_data = {}
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
							if driverjob_obj:
								driverjob_data.update({
									'drivername' : driverjob_obj.driver.name,
									'drivercountrycode' : driverjob_obj.driver.countrycode,
									'driverphone' : driverjob_obj.driver.phone,
									'driverid' : driverjob_obj.driver.id,
									'driverjobid' : driverjob_obj.id,
									})
								driverexist = True	
							data.update({
								'id' : customerjob_obj.id,
								'sendername' : customerjob_obj.sendername,
								'senderemail' : customerjob_obj.customer.user.email,
								'sendercountrycode' : sendercountrycode,
								'senderphone' : customerjob_obj.senderphone,
								'sendercity' : customerjob_obj.sendercity,
								'senderpickupaddress' : customerjob_obj.pickupaddress,
								'pickuptimeslot' : customerjob_obj.pickuptimeslot,
								'recipientname' : customerjob_obj.recipientname,
								'recipientcountrycode' : recipientcountrycode,
								'recipientphone' : customerjob_obj.recipientphone,
								'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
								'dropofftimeslot' : customerjob_obj.dropofftimeslot,
								'length' : customerjob_obj.length,
								'weight' : customerjob_obj.weight,
								'height' : customerjob_obj.height,
								'width' : customerjob_obj.width,
								'parceltype' : customerjob_obj.parceltype,
								'image' : customerjob_obj.image,
								'vehicletype' : customerjob_obj.vehicletype.name,
								'price' : customerjob_obj.price,
								'specialbooking_charge' : customerjob_obj.specialbooking_charge,
								'totalamount' : totalamount,
								'parcelimage' : parcelimage,
								'parcelpdf_link' : parcelpdf_link,
								'qrcode' : qrcode,
								'customerjobid' : customerjob_obj.id,
								'awbnumber' : 'AWB-' + str(10000 + customerjob_obj.id),
								'driverexist' : driverexist,
								'driverdetails' : driverjob_data,

								'delivery_proof_method' : delivery_proof_method,
								'delivery_toperson_name' : delivery_toperson_name,
								'delivery_toperson_phone' : delivery_toperson_phone,
								'delivery_toperson_signature' : delivery_toperson_signature,
								
								'pickup_proof_method' : pickup_proof_method,
								'pickup_fromperson_name' : pickup_fromperson_name,
								'pickup_fromperson_phone' : pickup_fromperson_phone,
								'pickup_fromperson_signature' : pickup_fromperson_signature,
								'pickupspecialnote':customerjob_obj.pickupspecialnote,
								'dropoffspecialnote':customerjob_obj.dropoffspecialnote,
								'pickup_datetime' : pickup_datetime,
								'itemsdelivered_datetime' : itemsdelivered_datetime,
								'payment_datetime' : payment_datetime,
								})
							allData.append(data)
		
						context['customerjoball'] = allData
						print(context['customerjoball'])
		return context

@method_decorator(checklogincustomer, name='dispatch')
class CustomerProfileUpdate(View):
	def post(self, request):
		'''This function shows the content on profile screen'''
		print("CustomerProfileUpdate - in get ")
		try:	
			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				print('\n\n')
				# print(codec)
				base64_data = codec.split(";base64,")
				extens = base64_data[0]
				ext = extens.split("/")
				extension = str(ext[1])
				base64_data = base64_data[1]
				byte_data = base64.b64decode(base64_data)
				image_data = BytesIO(byte_data)
				from PIL import Image
				import string, random, os
				img = Image.open(image_data)
				customer_obj = Customer.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.makedirs(filepath)
				for obj in thumbnailsize_objs:
					img = Image.open(image_data)
					im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
					im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
				img = Image.open(image_data)	
				img.save(filepath+'/original-'+st+'.'+extension)	
				filename = '/media/Users/Customers/'+str(customer_obj.id)+'_'+str(customer_obj.user.email)+'/original-'+st+'.'+extension
				customer_obj.image = filename
				customer_obj.save()
				return('1')


			# print(request.POST)
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			
			userrole_val = self.request.POST.get('userrole')
			customerid_val = self.request.POST.get('customerid')
			name_val = self.request.POST.get('name')
			email_val = self.request.POST.get('email')
			phone_val = self.request.POST.get('phone')
			image_val = self.request.POST.get('image')

			if not customerid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Customer Id is required'})
			if not name_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Name is required'})
			if not email_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Email Address is required'})
			if not phone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Phone is required'})
			
			customer_obj = Customer.objects.filter(id = customerid_val).first()
			if customer_obj:
				customer_obj.name = name_val
				customer_obj.email = email_val
				customer_obj.phone = phone_val
				customer_obj.save()
				if image_val:
					codec = image_val
					res = getI420FromBase64(codec,id_val = customer_obj.id)
					print(res)
				if userrole_val == 'company':
					job_title = self.request.POST.get('job_title')
					company_name = self.request.POST.get('company_name')
					company_website = self.request.POST.get('company_website')
					monthly_delivery_volume = self.request.POST.get('monthly_delivery_volume')
					registration_number = self.request.POST.get('registration_number')
					industry = self.request.POST.get('industry')
					companydetail_obj = CompanyDetail.objects.filter(customer = customer_obj).update(job_title = job_title, name = company_name, website = company_website, monthly_delivery_volume = monthly_delivery_volume, registration_number = registration_number, industry = industry)
				return JsonResponse({'status_code': 200, 'status_message': 'Profile updated successfully'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'You are not allowed to change details'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})
		

@method_decorator(checklogincustomer, name='dispatch')
class CompanyProfileUpdate(View):
	def post(self, request):
		'''This function shows the content on profile screen'''
		print("CustomerProfileUpdate - in get ")
		try:	
			context = {}
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			
			customerid_val = self.request.POST.get('customerid')
			name_val = self.request.POST.get('name')
			email_val = self.request.POST.get('email')
			phone_val = self.request.POST.get('phone')

			if not customerid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Customer Id is required'})
			if not name_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Name is required'})
			if not email_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Email Address is required'})
			if not phone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Phone is required'})
			
			customer_obj = Customer.objects.filter(id = customerid_val).first()
			if customer_obj:
				customer_obj.name = name_val
				customer_obj.email = email_val
				customer_obj.phone = phone_val
				customer_obj.save()
				return JsonResponse({'status_code': 200, 'status_message': 'Profile updated successfully'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'You are not allowed to change details'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})

@method_decorator(checklogincustomer, name='dispatch')
class CustomerProfile(TemplateView):
	template_name = 'customer_profile.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on profile screen'''
		context = super(CustomerProfile, self).get_context_data(**kwargs)
		print("CustomerProfile - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			userrole_val = self.request.session['userrole']

		user_obj = User.objects.filter(email = email_val).first()
		print('0')
		if user_obj:
			print('1')
			customer_obj = Customer.objects.filter(user = user_obj).prefetch_related('user').first()
			if customer_obj:
				if userrole_val == 'company':
					companydetail_data = {}
					companydetail_obj = CompanyDetail.objects.filter(customer = customer_obj).first()
					if companydetail_obj:
						companydetail_data.update({
							'job_title' : companydetail_obj.job_title,
							'name' : companydetail_obj.name,
							'website' : companydetail_obj.website,
							'monthly_delivery_volume' : companydetail_obj.monthly_delivery_volume,
							'registration_number' : companydetail_obj.registration_number,
							'industry' : companydetail_obj.industry,
							'credits' : companydetail_obj.credits,
							})
					context['companydetail_data'] = companydetail_data

				print('2')
				customer_data = {}
				try:
					from django.db.models import Avg
					rating_customer = UserRating.objects.filter(ratingfor = 'customer', customerid = customer_obj.id).aggregate(Avg('rating'))
					print(rating_customer)
					print(rating_customer['rating__avg'])
					if not rating_customer['rating__avg']:
						ratings = 0.0
					else:	
						ratings = rating_customer['rating__avg']
				except Exception as e:
					print(e)
					ratings = 0.0
				if customer_obj.image:
					image = str(settings.WEB_BASE_URL) + customer_obj.image.name
				else:
					image = ''
				customer_data.update({
					'userrole' : customer_obj.role,
					'name' : customer_obj.name,
					'email' : customer_obj.email,
					'phone' : customer_obj.phone,
					'image' : image,
					'ratings' : ratings,
					'id' : customer_obj.id,
					})
				context['user'] = customer_data
				print(customer_data)

		context['profile_section'] = 'yes'
		return context	


@method_decorator(checklogincompany, name='dispatch')
class CompanyProfile(TemplateView):
	template_name = 'company_profile.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on company dashboard screen'''
		context = super(CompanyProfile, self).get_context_data(**kwargs)
		print("CompanyProfile - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
		user_obj = User.objects.filter(email = email_val).first()
		if user_obj:
			company_obj = Company.objects.filter(user = user_obj).prefetch_related('user').first()
			if company_obj:
				context['user'] = company_obj
				context['userrole'] = 'company'
		context['profile_section'] = 'yes'
		return context	



class ResendOTP(View):
	def post(self, request, *args, **kwargs):	
		'''This function is used to resend OTP to the user'''
		print('Web - in resend_otp function')
		try:
			email_val = request.POST.get('email')
			if not email_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Email Address is required'})
			countrycode_val = request.POST.get('countrycode')
			if not countrycode_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Countrycode is required'})
			if '+' not in countrycode_val:
				countrycode_val = '+' + countrycode_val
			phone_val = request.POST.get('phone')
			if not phone_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Phone number is required'})
			digits = "0123456789"
			otp = ""
			for i in range(5) : 
				otp += digits[math.floor(random.random() * 10)]
			start_time = datetime.datetime.now()
			expire_time = datetime.datetime.now() + timedelta(minutes = 15)
			case = 'signup'
			otp_obj = OTP.objects.filter(mobile = countrycode_val + phone_val, case = case).first()
			if otp_obj:
				otp_obj.startdatetime = start_time
				otp_obj.expiredatetime = expire_time
				otp_obj.otp = otp
				otp_obj.save()
			else:
				otp_obj = OTP.objects.create(mobile = countrycode_val + phone_val, case = case, otp = otp, startdatetime = start_time, expiredatetime = expire_time)
			return JsonResponse({'status_code': 200, 'status_message': 'OTP sent on phone.'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 0, 'status_message': 'Internal Server Error'})

@method_decorator(checklogincustomer, name='dispatch')
class GetFares(APIView):
	def post(self, request, *args, **kwargs):
		'''This function is being used to return fares according to different vehicle types'''
		try:
			print("GetFares Web- in post ")
			print('\n\n')
			print(request.POST)
			print('\n\n')
			session_token_val = request.POST.get('session_token')
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')

			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			if not sendercountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender phone number is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})
						
			data = []
			try:
				api_key ='AIzaSyCZt3wR3ItaSSmIhWnRy4hy6FnqmEM81oY'

				pickupaddress_val = pickupaddress_val.replace(' ','')
				pickupaddress_val = pickupaddress_val.replace('#','')
				dropaddress_val = dropaddress_val.replace(' ','')
				dropaddress_val = dropaddress_val.replace('#','')
				source = pickupaddress_val

				dest = dropaddress_val

				url ='https://maps.googleapis.com/maps/api/distancematrix/json?'

				# return response object 
				print(api_key)
				print(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

				r = requests.get(url + 'origins=' + source + '&destinations=' + dest + '&key=' + api_key)

				# json method of response object 
				# return json format result 
				x = r.json() 
				print(x) 
				print('\n')
				if x['status'] == 'OK':
					# if x['rows']:
					# print('\n')
					# print(x['rows'][0]['elements'])
					# print('\n')
					multiplicationfactor = 0.000621371192
					# print(x['rows'][0]['elements'][0]['distance']['value'])
					distanceinmiles = float(x['rows'][0]['elements'][0]['distance']['value']) * multiplicationfactor
					print(distanceinmiles)
					vehicletype_obj = VehicleType.objects.filter(distanceunit = 'mile', isdeleted = False)
					if vehicletype_obj:
						for vehicle in vehicletype_obj:
							distance = distanceinmiles
							if distance <= vehicle.fixeddistance:
								rate = vehicle.baserate
							else:
								rate = vehicle.baserate
								print('\n')
								print(vehicle.name)
								print(rate)
								distance = distance - vehicle.fixeddistance
								print(distanceinmiles)
								if distance > int(distance):
									distance = int(distance) + 1
								else:
									distance = distance
								print(distance)
								print(vehicle.addittionalrateperunit)
								rate = rate + distance * vehicle.addittionalrateperunit
								print(rate)
							image = str(settings.WEB_BASE_URL)
							if vehicle.name == 'Bike':
								image += '/static/images/bike.png'
							elif vehicle.name == 'Car':
								image += '/static/images/car.jpg'
							elif vehicle.name == 'smallvan':
								image += '/static/images/smallvan.png'
							elif vehicle.name == 'mediumvan':
								image += '/static/images/smallvan.png'
							elif vehicle.name == 'largevan':
								image += '/static/images/largevan.jpg'
								
							data.append({"vehicletype" : vehicle.name, 'price' : str(round(float(rate),2)), 'image' : image})

					# print(x) 

				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Enter valid address'})
			except Exception as e:
				print(e)
				return JsonResponse({'status_code': 400, 'status_message': 'Enter valid address'})
				# data.append({"vehicletype":'bike','price' : 10.0, 'image': 'http://13.126.26.12/static/images/bike.png'})
				# data.append({"vehicletype":'car','price' : 20.0, 'image': 'http://13.126.26.12/static/images/car.jpg'})
				# data.append({"vehicletype":'smallvan','price' : 30.0, 'image': 'http://13.126.26.12/static/images/smallvan.png'})
				# data.append({"vehicletype":'mediumvan','price' : 40.0, 'image': 'http://13.126.26.12/static/images/smallvan.png'})
				# data.append({"vehicletype":'largevan','price' : 50.0, 'image': 'http://13.126.26.12/static/images/largevan.jpg'})
				

			return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'data' : data})			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})

@method_decorator(checklogincustomer, name='dispatch')
class PlaceOrder(TemplateView):
	template_name = 'placeorder.html' 

	def get_context_data(self,**kwargs):
		'''This function passes arguments to place order page. '''
		context = super(PlaceOrder, self).get_context_data(**kwargs)
		print("PlaceOrder - in get ")
		allparceltypes = ParcelType.objects.all()
		context['allparceltypes'] = allparceltypes
		print(allparceltypes)
		context['placeorder_section'] = 'yes'
		return context	

	def post(self, request, *args, **kwargs):
		'''This function is being used to save the customer job request details in the database'''
		print('PlaceOrder Web - in post')
		try:
			print(request.POST)

			def generateqrcode(id_val):
				print(id_val)
				import pyqrcode, png, os
				# from pyqrcode import QRCode
				customerjob_obj = CustomerJob.objects.get(id = id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					pass
				else:
					os.mkdir(filepath)
				
				url = pyqrcode.create(content = 'AWB-' + str(id_val))
				url.png(filepath + '/qrcode.png',scale = 8)
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/qrcode.png'
				customerjob_obj.qrcode = filename
				customerjob_obj.save()
				return('1')




			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				base64_data = codec.split(";base64,")
				extens = base64_data[0]
				ext = extens.split("/")
				extension = str(ext[1])
				base64_data = base64_data[1]
				byte_data = base64.b64decode(base64_data)
				image_data = BytesIO(byte_data)
				from PIL import Image
				import string, random, os
				img = Image.open(image_data)
				customerjob_obj = CustomerJob.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
				if(os.path.exists(filepath)):
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					os.mkdir(filepath)
				img = Image.open(image_data)
				im = img.thumbnail([400,400], Image.ANTIALIAS)
				im = img.save(filepath+'/'+ 'parcelimage.'+extension)								
				
				filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/'+ 'parcelimage.'+extension		
				customerjob_obj.image = filename
				customerjob_obj.save()
				return('1')




			payment_token = request.POST.get('payment_token')
			
			sendername_val = request.POST.get('sendername')
			sendercountrycode_val = request.POST.get('sendercountrycode')
			senderphone_val = request.POST.get('senderphone')
			pickupaddress_val = request.POST.get('pickupaddress')
			sendercity_val = request.POST.get('sendercity')
			noofparcels_val = request.POST.get('noofparcels')

			width_val = request.POST.get('width')
			height_val = request.POST.get('height')
			weight_val = request.POST.get('weight')
			parceltype_val = request.POST.get('parceltype')
			specialnote_val = request.POST.get('specialnote')

			recipientname_val = request.POST.get('recipientname')
			recipientcountrycode_val = request.POST.get('recipientcountrycode')
			recipientphone_val = request.POST.get('recipientphone')
			dropaddress_val = request.POST.get('dropaddress')

			vehicletype_val = request.POST.get('vehicletype')
			price_val = request.POST.get('price')
			imagebase64_val = request.POST.get('imagebase64')
			

			if not payment_token:
				return JsonResponse({'status': 0, 'message': 'payment_token Empty',})
			if not sendername_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendername_val is required'})
			# if not sendercountrycode_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'Sender countrycode is required'})
			if not senderphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Sender senderphone_val is required'})
			if not pickupaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'pickupaddress_val is required'})
			if not sendercity_val:
				return JsonResponse({'status_code': 400, 'status_message': 'sendercity_val is required'})
			if not noofparcels_val:
				return JsonResponse({'status_code': 400, 'status_message': 'noofparcels_val is required'})
			# if not width_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'width_val is required'})
			# if not height_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'height_val is required'})
			# if not weight_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'weight_val is required'})
			if not parceltype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'parceltype_val is required'})
			# if not specialnote_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'specialnote_val is required'})
			if not recipientname_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientname_val is required'})
			if not recipientcountrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipient countrycode is required'})
			if not recipientphone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'recipientphone_val is required'})
			if not dropaddress_val:
				return JsonResponse({'status_code': 400, 'status_message': 'dropaddress_val is required'})

			if not vehicletype_val:
				return JsonResponse({'status_code': 400, 'status_message': 'vehicletype_val is required'})
			if not price_val:
				return JsonResponse({'status_code': 400, 'status_message': 'price_val is required'})
			# if not imagebase64_val:
			# 	return JsonResponse({'status': 400, 'message': 'Image is required'})


			import stripe
			print('2')
			paymentamount_val = int(float(price_val) * 100)
			stripe.api_key = str(settings.STRIPE_KEY)
			charge = stripe.Charge.create(
			amount=paymentamount_val,
			currency='eur',
			description='Parcel Payment',
			source=payment_token,
			)
			print(charge)
			payment_id = charge.id
			receipt_url = charge.receipt_url
			refunds_url = charge.refunds.url
			print('1')
			payment_method = charge['payment_method_details']['card']['funding']
			print(payment_method)
			if payment_method=='credit':
				payment_method = 'Credit Card'
			elif payment_method == 'debit':
				payment_method = 'Debit Card'

			lastfourdigits = charge['payment_method_details']['card']['last4']
			print('\n\n\n\n'+lastfourdigits+'\n\n\n\n')
			


			deliveryduration_val = 1
			print('0')
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
				print(email_val)
				user_obj = User.objects.filter(email = email_val).first()
				if user_obj:
					customer_obj = Customer.objects.filter(user = user_obj).first()
					print('3')
					if customer_obj:
						print('4')
						vehicletype_obj = VehicleType.objects.filter(name = vehicletype_val).first()
						if vehicletype_obj:
							print('5')
							customerjob_obj = CustomerJob.objects.create(sendername = sendername_val, sendercountrycode = sendercountrycode_val, senderphone = senderphone_val, pickupaddress = pickupaddress_val, sendercity = sendercity_val, noofparcels = noofparcels_val, pickupspecialnote = specialnote_val, recipientname = recipientname_val, recipientcountrycode = recipientcountrycode_val, recipientphone = recipientphone_val, dropoffaddress = dropaddress_val, deliveryduration = deliveryduration_val, width = width_val, height = height_val, weight = weight_val, parceltype = parceltype_val, customer = customer_obj, vehicletype = vehicletype_obj, price = price_val)

							try:
								Notifications.objects.create(customerjobid = customerjob_obj.id, forcustomer = True, notificationtype = 'Parcel Job Created', notificationtext = 'You have created one parcel order.', status = 'unread')
								Notifications.objects.create(user = user_obj, customerjobid = customerjob_obj.id, foradmin = True, notificationtype = 'Parcel Job Created', notificationtext = 'Customer has created one parcel order.', status = 'unread')
							except Exception as e:
								print(e)
							
							if imagebase64_val:
								codec = 'data:image/png;base64,' + imagebase64_val
								print('before function call')
								getI420FromBase64(codec, id_val = customerjob_obj.id)
								print('after function call')
							try:
								generateqrcode(id_val = customerjob_obj.id)
								print('after function call')
							except Exception as e:
								print(e)

							return JsonResponse({'status_code': 200, 'status_message': 'Success.', 'customerjob_id': customerjob_obj.id})	
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in.'})
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})	
				
			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})




@method_decorator(checklogincustomer, name='dispatch')
class MyJobs(TemplateView):
	template_name = 'myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(MyJobs, self).get_context_data(**kwargs)
		print("MyJobs - in get ")
		print('\n\n\n')
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			customer_obj = Customer.objects.filter(email = email_val).first()
			if customer_obj:
				customerjob_obj = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')
				if customerjob_obj:
					context['all_customerjobs'] = customerjob_obj
					print(customerjob_obj)
			# customerjob
		print('\n\n\n')
		context['myjobs_section'] = 'yes'
		return context	

def get_all_parcels(request):
	print(request.POST)
	order_id = request.POST.get('order_id')
	order_obj = Order.objects.filter(id = order_id).first()
	order_data = []
	if order_obj:
		customerjob_obj = CustomerJob.objects.filter(order = order_obj).order_by('-id')
		if customerjob_obj:
			print(len(customerjob_obj))
			for job in customerjob_obj:
				try:
					awbnumber = 'AWB-' + str(10000 + job.id)
				except Exception as e:
					print(e)
					awbnumber = ''
				if not job.image:
					image = ''
				else:
					image = str(settings.WEB_BASE_URL) + job.image.name
				order_data.append({
					'id' : job.id,
					'email' : job.customer.email,
					'sendername' : job.sendername,
					'senderphone' : job.senderphone,
					'senderpickupaddress' : job.pickupaddress,
					'recipientname' : job.recipientname,
					'recipientdropoffaddress' : job.dropoffaddress,
					'image': image,
					'awbnumber' : awbnumber,
					'customerjobid' : job.sameIdForParcelsDetails,

					})
				# if order.id == 136:
					# print(order_data)
				print(order_data)
	return JsonResponse({'all_parcels_data' : order_data})


@method_decorator(checklogincustomer, name='dispatch')
class MyJobsOngoingExtraTest(TemplateView):
	template_name = 'myjobs_test.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(MyJobsOngoingExtraTest, self).get_context_data(**kwargs)
		print("MyJobsOngoingExtraTest - in get ")
		print('\n\n\n')
		# data = []
		ongoingcustomerjobs_data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			customer_obj = Customer.objects.filter(email = email_val).first()
			if customer_obj:
				unique_parcel_ids=[]
				order_obj = Order.objects.filter(customer = customer_obj, status = 0).order_by('-id')
				if order_obj:
					for order in order_obj:
						order_data = []
						customerjob_obj = CustomerJob.objects.filter(order = order, customer = customer_obj).order_by('-id')
						if customerjob_obj:
							print(len(customerjob_obj))
							for job in customerjob_obj:
								if job.sameIdForParcelsDetails not in unique_parcel_ids:
									if job.sameIdForParcelsDetails !=0:
										unique_parcel_ids.append(job.sameIdForParcelsDetails)
									completed = False
									try:
										awbnumber = 'AWB-' + str(10000 + job.id)
									except Exception as e:
										print(e)
										awbnumber = ''
									if not job.image:
										image = ''
									else:
										image = str(settings.WEB_BASE_URL) + job.image.name
									if order.ordertype == 1:
										ordertype = 'Single-Drop'
									elif order.ordertype == 2:
										ordertype = 'Multi-Drop'
									else:
										ordertype = ''
									order_data.append({
										'orderid' : order.id,
										'ordertype' : ordertype,
										'id' : job.id,
										'email' : customer_obj.email,
										'sendername' : job.sendername,
										'senderphone' : job.senderphone,
										'senderpickupaddress' : job.pickupaddress,
										'recipientname' : job.recipientname,
										'recipientdropoffaddress' : job.dropoffaddress,
										'image': image,
										'awbnumber' : awbnumber,
										'customerjobid' : job.sameIdForParcelsDetails,
										'deleted':job.isdeleted,
										'extraId' : job.id,
										})
									# if order.id == 136:
									# 	print(order_data)
							ongoingcustomerjobs_data.append(order_data)
							print(order_data)
							print(unique_parcel_ids)	
				context['ongoingcustomerjobs_data'] = ongoingcustomerjobs_data
				context['page_name'] = 'Ongoing Jobs'
						# print(data)
			# customerjob
		print('\n\n\n')
		context['myjobs_section'] = 'yes'
		return context


@method_decorator(checklogincustomer, name='dispatch')
class MyJobsOngoingTest(TemplateView):
	template_name = 'myjobs_test.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(MyJobsOngoingTest, self).get_context_data(**kwargs)
		print("MyJobsOngoingTest - in get ")
		print('\n\n\n')
		# data = []
		ongoingcustomerjobs_data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			customer_obj = Customer.objects.filter(email = email_val).first()
			if customer_obj:
				order_obj = Order.objects.filter(customer = customer_obj, status = 0).order_by('-id')
				if order_obj:
					for order in order_obj:
						order_data = []
						customerjob_obj = CustomerJob.objects.filter(order = order, customer = customer_obj).order_by('-id')
						if customerjob_obj:
							print(len(customerjob_obj))
							for job in customerjob_obj:
								try:
									awbnumber = 'AWB-' + str(10000 + job.id)
								except Exception as e:
									print(e)
									awbnumber = ''
								if not job.image:
									image = ''
								else:
									image = str(settings.WEB_BASE_URL) + job.image.name
								if order.ordertype == 1:
									ordertype = 'Single-Drop'
								elif order.ordertype == 2:
									ordertype = 'Multi-Drop'
								else:
									ordertype = ''
								order_data.append({
									'orderid' : order.id,
									'ordertype' : ordertype,
									'id' : job.id,
									'email' : customer_obj.email,
									'sendername' : job.sendername,
									'senderphone' : job.senderphone,
									'senderpickupaddress' : job.pickupaddress,
									'recipientname' : job.recipientname,
									'recipientdropoffaddress' : job.dropoffaddress,
									'image': image,
									'awbnumber' : awbnumber,
									'customerjobid' : job.id,
									})
								# if order.id == 136:
								# 	print(order_data)
						ongoingcustomerjobs_data.append(order_data)	
				context['ongoingcustomerjobs_data'] = ongoingcustomerjobs_data
				context['page_name'] = 'Ongoing Jobs'
						# print(data)
			# customerjob
		print('\n\n\n')
		context['myjobs_section'] = 'yes'
		return context	


@method_decorator(checklogincustomer, name='dispatch')
class MyJobsOngoing(TemplateView):
	template_name = 'myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(MyJobsOngoing, self).get_context_data(**kwargs)
		print("MyJobsOngoing - in get ")
		print('\n\n\n')
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			customer_obj = Customer.objects.filter(email = email_val).first()
			if customer_obj:
				customerjob_obj = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')
				if customerjob_obj:
					for customerjob in customerjob_obj:
						if customerjob.image:
							image = str(settings.WEB_BASE_URL) + customerjob.image.name
						else:
							image = ''
						data.append({
							'id' : customerjob.id,
							'email' : customer_obj.email,
							'sendername' : customerjob.sendername,
							'senderemail' : customerjob.customer.user.email,
							'senderphone' : customerjob.senderphone,
							'senderpickupaddress' : customerjob.pickupaddress,
							'recipientname' : customerjob.recipientname,
							'recipientdropoffaddress' : customerjob.dropoffaddress,
							'image': image,
							'customerjobid' : customerjob.id,
							})
						context['all_customerjobs'] = data
						context['page_name'] = 'Ongoing Jobs'
						# print(data)
			# customerjob
		print('\n\n\n')
		context['myjobs_section'] = 'yes'
		return context	

@method_decorator(checklogincustomer, name='dispatch')
class MyJobsCompleted(TemplateView):
	template_name = 'myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(MyJobsCompleted, self).get_context_data(**kwargs)
		print("MyJobsCompleted - in get ")
		print('\n\n\n')
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			customer_obj = Customer.objects.filter(email = email_val).first()
			if customer_obj:
				customerjob_obj = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')
				if customerjob_obj:
					for customerjob in customerjob_obj:
						driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
						if driverjob_obj:
							if driverjob_obj.jobcompleted:
								if customerjob.image:
									image = str(settings.WEB_BASE_URL) + customerjob.image.name
								else:
									image = ''
								data.append({
									'id' : customerjob.id,
									'email' : customer_obj.email,
									'sendername' : customerjob.sendername,
									'senderemail' : customerjob.customer.user.email,
									'senderphone' : customerjob.senderphone,
									'senderpickupaddress' : customerjob.pickupaddress,
									'recipientname' : customerjob.recipientname,
									'recipientdropoffaddress' : customerjob.dropoffaddress,
									'image': image,
									'customerjobid' : customerjob.id,
									})
								context['all_customerjobs'] = data
								context['page_name'] = 'Completed Jobs'
								# print(data)
			# customerjob
		print('\n\n\n')
		context['myjobs_section'] = 'yes'
		return context



@method_decorator(checklogincustomer, name='dispatch')
class MyJobsCompletedExtraTest(TemplateView):
	template_name = 'myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(MyJobsCompletedExtraTest, self).get_context_data(**kwargs)
		print("MyJobsCompletedExtraTest - in get ")
		print('\n\n\n')
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			print(email_val)
			customer_obj = Customer.objects.filter(email = email_val).first()
			unique_parcel_ids=[]
			if customer_obj:
				customerjob_obj = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')
				if customerjob_obj:
					for customerjob in customerjob_obj:
						if customerjob.sameIdForParcelsDetails not in unique_parcel_ids:
							if customerjob.sameIdForParcelsDetails !=0:
								unique_parcel_ids.append(customerjob.sameIdForParcelsDetails)
							completed = False
							if customerjob.sameIdForParcelsDetails !=0:
								driverjob_obj = DriverJob.objects.filter(sameIdForParcels=customerjob.sameIdForParcelsDetails)
								driverexist = False
								driverID=0
								if driverjob_obj:
									driverexist = True
									completed = True
									for d in driverjob_obj:
										if d.jobcompleted==False:
											completed = False
											driverID=d.sameIdForParcels
							if customerjob.sameIdForParcelsDetails == 0:
								driverjob_obj = DriverJob.objects.filter(customerjob = customerjob).first()
								driverexist = False
								driverID=0
								if driverjob_obj:
									driverexist = True
									if driverjob_obj.jobcompleted:
										completed = True
							Show=True
							if customerjob.sameIdForParcelsDetails == 0:
								Show=False
							if driverjob_obj:
								if completed:
									if customerjob.image:
										image = str(settings.WEB_BASE_URL) + customerjob.image.name
									else:
										image = ''
									data.append({
										'id' : customerjob.id,
										'email' : customer_obj.email,
										'sendername' : customerjob.sendername,
										'senderemail' : customerjob.customer.user.email,
										'senderphone' : customerjob.senderphone,
										'senderpickupaddress' : customerjob.pickupaddress,
										'recipientname' : customerjob.recipientname,
										'recipientdropoffaddress' : customerjob.dropoffaddress,
										'image': image,
										# 'customerjobid' : customerjob.id,
										'showId':Show,
										'extraId' : customerjob.id,#Created By Manpreet Singh on 9/11/2020
										'customerjobid' : str(customerjob.sameIdForParcelsDetails),# ID used by manpreet for same parcels
										})
		context['all_customerjobs'] = data
		context['page_name'] = 'Completed Jobs'
		print(data)
		print('\n\n\n')
		context['myjobs_section'] = 'yes'
		return context




@method_decorator(checklogincustomer, name='dispatch')
class CustomerDashboard(TemplateView):
	template_name = 'customer_dashboard.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(CustomerDashboard, self).get_context_data(**kwargs)
		print("CustomerDashboard - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
		user_obj = User.objects.filter(email = email_val).first()
		if user_obj:
			customer_obj = Customer.objects.filter(user = user_obj).prefetch_related('user').first()
			if customer_obj:
				context['user'] = customer_obj
				context['userrole'] = 'customer'
				recent_customerjobs = CustomerJob.objects.filter(customer = customer_obj).order_by('-id')[:5]
		# context['user'] = 'Customer'
		context['recent_customerjobs'] = recent_customerjobs
		context['dashboard_section'] = 'yes'
		return context	


@method_decorator(checklogincompany, name='dispatch')
class CompanyDashboard(TemplateView):
	template_name = 'company_dashboard.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on company dashboard screen'''
		context = super(CompanyDashboard, self).get_context_data(**kwargs)
		print("CompanyDashboard - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
		user_obj = User.objects.filter(email = email_val).first()
		if user_obj:
			company_obj = Company.objects.filter(user = user_obj).prefetch_related('user').first()
			if company_obj:
				context['user'] = company_obj
				context['userrole'] = 'company'
		context['dashboard_section'] = 'yes'
		return context	


class UserVerifications(View):
	
	def get(self, request):
		print('\n\n')
		print('Userverification - in get')
		print('\n\n')
		if self.request.session.has_key('email'):
			emailid=self.request.session['email']
		link = str(self.request.path)
		userrole = link.split('/')[2]
		context = {}
		if userrole == 'customer':
			user_obj = Customer.objects.filter(emailverificationlink = link).first()
		elif userrole == 'company':
			user_obj = Company.objects.filter(emailverificationlink = link).first()
			urlname = 'company-dashboard'
		elif userrole == 'driver':
			user_obj = DriverModel.objects.filter(forgot_password_link = link).first()
			urlname = 'driver-dashboard'
		if user_obj:
			user_obj.emailverified = True
			user_obj.save()
			if userrole == 'customer':
				url_val = 'customer-login'
			elif userrole == 'company':
				url_val = 'company-dashboard'
			elif userrole == 'driver':
				url_val = 'driver-dashboard'
			else:
				url_val = 'customer-login'
			request.session['email'] = user_obj.email
			request.session['userrole'] = userrole
			return HttpResponseRedirect(reverse(url_val))
		else:
			return HttpResponseRedirect(reverse(url_val))


class CustomerVerifyForgotPassword(TemplateView):
	template_name = 'verify_forgot_password.html'
	def get_context_data(self,**kwargs):
		context = super(CustomerVerifyForgotPassword, self).get_context_data(**kwargs)
		context = {}
		link = str(self.request.path)
		ran_string = link.split('/')[-1]
		user_email = link.split('/')[-2]
		userrole = link.split('/')[2]
		user_obj = User.objects.filter(email = user_email).first()
		
		if userrole == 'customer' or userrole == 'company':
			customer_obj = Customer.objects.filter(user = user_obj,forgot_password_link = link).first()
			if customer_obj:
				context['user_exist'] = True
			else:
				context['user_exist'] = False
		else:
			context['user_exist'] = False

		print(context['user_exist'])
		return context

	def post(self, request, *args, **kwargs):
		context={}
		password=request.POST['pass']
		c_password=request.POST['conf_pass']
		link=request.POST['link_url']
		ran_string = link.split('/')[-1]
		user_email = link.split('/')[-2]
		user_obj = User.objects.filter(email = user_email).first()
		customer_obj = Customer.objects.filter(user = user_obj,forgot_password_link=link).first()
		if customer_obj:
			user_obj.set_password(c_password)
			user_obj.save()
			context['success'] = True
			context['status_code'] = 200
		else:
			context['success'] = False
			context['status_code'] = 200

		return HttpResponse(json.dumps(context))



		

class VerifyForgotPassword(TemplateView):
	template_name = 'verify_forgot_password.html'
	def get_context_data(self, *args,**kwargs):
		context = {}
		link = str(self.request.path)
		print(link)
		user_email = link.split('/')[-2]
		user_obj = User.objects.filter(email = user_email).first()
		driver_obj = DriverModel.objects.filter(user = user_obj, forgot_password_link = link).first()
		if driver_obj:
			print('True')
			context['user_exist'] = True
		else:
			print('False')
			context['user_exist'] = False

		print(context['user_exist'])
		return context

	def post(self, request, *args, **kwargs):
		context={}
		password=request.POST['pass']
		c_password=request.POST['conf_pass']
		link=request.POST['link_url']
		ran_string = link.split('/')[-1]
		user_email = link.split('/')[-2]
		user_obj = User.objects.filter(email = user_email).first()
		driver_obj=DriverModel.objects.filter(user = user_obj,forgot_password_link = link).first()
		if driver_obj:
			user_obj.set_password(c_password)
			user_obj.save()
			context['success'] = True
			context['status_code'] = 200
		else:
			context['success'] = False
			context['status_code'] = 200

		return HttpResponse(json.dumps(context))



		
		# userrole = link.split('/')[2]
		# context = {}
		# if userrole == 'customer':
		# 	user_obj = Customer.objects.filter(emailverificationlink = link).first()
		# elif userrole == 'company':
		# 	user_obj = Company.objects.filter(emailverificationlink = link).first()
		# 	urlname = 'company-dashboard'
		# elif userrole == 'driver':
		# 	user_obj = Driver.objects.filter(emailverificationlink = link).first()
		# 	urlname = 'driver-dashboard'
		# if user_obj:
		# 	user_obj.emailverified = True
		# 	user_obj.save()
		# 	if userrole == 'customer':
		# 		url_val = 'customer-login'
		# 	elif userrole == 'company':
		# 		url_val = 'company-dashboard'
		# 	elif userrole == 'driver':
		# 		url_val = 'driver-dashboard'
		# 	else:
		# 		url_val = 'customer-login'
		# 	request.session['email'] = user_obj.email
		# 	request.session['userrole'] = userrole
		# 	return HttpResponseRedirect(reverse(url_val))
		# else:
		# 	return HttpResponseRedirect(reverse(url_val))

class UserVerificationDriver(TemplateView):
	template_name = 'userpageverification.html'

	def get_context_data(self,**kwargs):
		context = super(UserVerificationDriver, self).get_context_data(**kwargs)
		print('UserVerificationDriver - in get')
		if self.request.session.has_key('email'):
			emailid=self.request.session['email']
		link = str(self.request.path)
		userrole = link.split('/')[2]
		
		if userrole == 'customer':
			user_obj = Customer.objects.filter(emailverificationlink = link).first()
		elif userrole == 'company':
			user_obj = Company.objects.filter(emailverificationlink = link).first()
			urlname = 'company-dashboard'
		elif userrole == 'driver':
			user_obj = DriverModel.objects.filter(emailverificationlink = link).first()
			urlname = 'driver-dashboard'
		if user_obj:
			try:
				if userrole == 'driver':
					context['driverid'] = user_obj.id
			except Exception as e:
				print(e)
			user_obj.emailverified = True
			user_obj.save()
			if userrole == 'customer':
				context['data'] = 'success'
				url_val = 'customer-login'
			elif userrole == 'company':
				url_val = 'company-dashboard'
			elif userrole == 'driver':
				context['data'] = 'success'
				url_val = 'driver-dashboard'
			else:
				url_val = 'customer-login'
			# request.session['email'] = user_obj.email
			# request.session['userrole'] = userrole
			# return HttpResponseRedirect(reverse(url_val))
			context['data'] = 'success'
		else:
			context['data'] = 'error'
		return context	
			# return HttpResponseRedirect(reverse(url_val))

class UserVerification(TemplateView):
	template_name = 'userpageverification.html'

	def get_context_data(self,**kwargs):
		context = super(UserVerification, self).get_context_data(**kwargs)
		print('Userverification - in get')
		if self.request.session.has_key('email'):
			emailid=self.request.session['email']
		link = str(self.request.path)
		userrole = link.split('/')[2]
		
		if userrole == 'customer' or userrole == 'company':
			user_obj = Customer.objects.filter(emailverificationlink = link).first()
		elif userrole == 'driver':
			user_obj = DriverModel.objects.filter(emailverificationlink = link).first()
			urlname = 'driver-dashboard'
		if user_obj:
			user_obj.emailverified = True
			user_obj.save()
			if userrole == 'customer' or userrole == 'company':
				context['data'] = 'success'
				url_val = 'customer-login'
			# elif userrole == 'company':
			# 	url_val = 'company-dashboard'
			elif userrole == 'driver':
				url_val = 'driver-dashboard'
			else:
				url_val = 'customer-login'
			# request.session['email'] = user_obj.email
			# request.session['userrole'] = userrole
			# return HttpResponseRedirect(reverse(url_val))
			context['data'] = 'success'
		else:
			context['data'] = 'error'
		return context	
			# return HttpResponseRedirect(reverse(url_val))
		
class CustomerLogin(TemplateView):
	template_name = 'customer_login.html'

	def post(self, request, *args, **kwargs):
		'''This function is used for the login process for customer or company user'''
		try:
			print('CustomerLogin Web - in post')
			print(request.POST)
			userrole_val = request.POST.get('userrole')
			email_val = request.POST.get('email')
			password_val = request.POST.get('password')
			
			if not userrole_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User Role is required'})
			if not email_val:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Email address is required'})
			if not password_val:
				return JsonResponse({'status_code' : 400, 'status_message' : 'Password is required'})
			user = authenticate(username = email_val, password = password_val)  
			if user is not None:
				redirectlink = request.GET.get('next')
				token, status = Token.objects.get_or_create(user = user)
				if userrole_val == 'customer' or userrole_val == 'company':
					if userrole_val == 'customer':
						customer_obj = Customer.objects.filter(user = user, role = 'customer').first()
					elif userrole_val == 'company':
						customer_obj = Customer.objects.filter(user = user, role = 'company').first()
					if customer_obj:
						if customer_obj.emailverified == False:
							return JsonResponse({'status_code' : 111, 'status_message' : 'Please verify your email first.'})
						elif customer_obj.isdisabled:
							return JsonResponse({'status_code' : 100, 'status_message' : 'User is disabled by Admin.'})
						else:
							request.session['email'] = email_val
							request.session['userrole'] = userrole_val
							result, unread_notifications_count = getunreadnotificationcount(user.id)
							if result == 'success':
								print(unread_notifications_count)
							elif result == 'error':
								print(unread_notifications_count)

							return JsonResponse({'status_code': 200, 'user' : userrole_val, 'name' : customer_obj.name, 'phone' : customer_obj.phone, 'image' : customer_obj.image.name, 'token' : token.key, 'unread_notifications_count' : unread_notifications_count, 'status_message' : 'customer login successfull', 'redirectlink' : redirectlink})
				
				return JsonResponse({'status_code': 401, 'status_message' : 'Invalid Credentials.'})
			else:
				return JsonResponse({'status_code': 401, 'status_message' : 'Invalid Credentials.'})
		except Exception as error:
			print('error is',error)
			return JsonResponse({'status_code': 500, 'status_message' : 'Exception occurred : ' + str(error)})

		# try:
		# 	print('CustomerLogin Web - in post')
		# 	print(request.POST)
		# 	user = authenticate(username = request.POST['email'], password = request.POST['password'])  
		# 	if user is not None:
		# 		redirectlink = request.GET.get('next')
		# 		customer_obj = Customer.objects.filter(user = user, emailverified = True).first()
		# 		if customer_obj:
		# 			token, status = Token.objects.get_or_create(user = user)
		# 			request.session['email'] = request.POST['email']
		# 			request.session['userrole'] = 'customer'
		# 			return JsonResponse({'status_code': 200, 'user' : 'customer', 'status_message' : 'customer login successfull', 'redirectlink' : redirectlink})
				
		# 		return JsonResponse({'status_code': 0, 'status_message' : 'Invalid Credentials.'})
		# 	else:
		# 		return JsonResponse({'status_code': 0, 'status_message' : 'Invalid Credentials.'})
		# except Exception as error:
		# 	print('error is',error)
		# 	return JsonResponse({'status_code': 0, 'status_message' : 'Internal Server Error'})

	def get_context_data(self,**kwargs):
		'''This function shows the content on login screen'''
		context = super(CustomerLogin, self).get_context_data(**kwargs)
		print("CustomerLogin-in get ")
		fullpath = self.request.get_full_path()
		path = self.request.GET.get('next')
		if not path:
			path = ''
		else:
			path = path.split('=')
			path = str(path[-1])
		context['redirectlink'] = path
		return context	


class RegistrationOTP(APIView):
	def post(self, request, *args, **kwargs):
		'''This class sends the OTP on customer mobile at the time of registration'''
		try:
			print('RegistrationOTP Web - in post')
			print('\n')
			print(request.POST)
			print('\n')

			userrole_val = request.POST.get('userrole')
			name_val = request.POST.get('name')
			email_val = request.POST.get('email')
			countrycode_val = request.POST.get('countrycode')
			phone_val = request.POST.get('phone')
			password_val = request.POST.get('password')
			if not userrole_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User Role is required'})
			if not name_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Name is required'})
			if not email_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Email Address is required'})
			if not countrycode_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Countrycode is required'})
			if not phone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Phone number is required'})
			if not password_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Password is required'})
			
			
			if userrole_val == 'company':
				job_title = self.request.POST.get('job_title')
				company_name = self.request.POST.get('company_name')
				company_website = self.request.POST.get('company_website')
				monthly_delivery_volume = self.request.POST.get('monthly_delivery_volume')
				registration_number = self.request.POST.get('registration_number')
				industry = self.request.POST.get('industry')
			print('0'*4)
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				print('1'*4)
				try:
					if userrole_val == 'customer' or userrole_val == 'company':
						customer_emailverified_obj = Customer.objects.filter(user = user_obj, emailverified = True)
						if customer_emailverified_obj:
							print('2'*4)
							return JsonResponse({'status_code': 409, 'status_message': 'User already exists.'})
						customer_emailnotverified_obj = Customer.objects.filter(user = user_obj, emailverified = False)
						if customer_emailnotverified_obj:
							print('3'*4)
							return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address earlier. Please search your mail inbox.'})
						else:
							print('4'*4)
							return JsonResponse({'status_code': 409, 'status_message': 'A driver with this email address already exists.'})
					elif userrole_val == 'driver':
						driver_emailverified_obj = DriverModel.objects.filter(user = user_obj, emailverified = True)
						if driver_emailverified_obj:
							return JsonResponse({'status_code': 409, 'status_message': 'User already exists'})
						driver_emailnotverified_obj = DriverModel.objects.filter(user = user_obj, emailverified = False)
						if driver_emailnotverified_obj:

							return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address.'})
						else:
							return JsonResponse({'status_code': 409, 'status_message': 'A customer with this email address already exists.'})
				except Exception as e:
					print(e)
					return JsonResponse({'status_code': 409, 'status_message': 'User exists.'})
			else:
				print('5'*4)
				user_obj = User.objects.create_user(username = email_val, email = email_val, password = password_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(12)])
				baselink = '/user/' + userrole_val + '/verify/' + str(user_obj.email) + '/' + st
				completelink = str(settings.WEB_BASE_URL) + baselink
				message = "\nVerify your account through following link:\n" + completelink
				try:
					print(message)
					res = send_mail('Email verification:',message,'tmpython4esf@gmail.com',[str(email_val)],fail_silently=True)
					print(res)
				except Exception as e:
					print(e)
				if userrole_val == 'customer':
					customer_obj = Customer.objects.create(user = user_obj, name = name_val, email = email_val, countrycode = countrycode_val, phone = phone_val, emailverificationlink = baselink)
					if customer_obj:
						return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address.'})

				elif userrole_val == 'company':
					customer_obj = Customer.objects.create(user = user_obj, role = userrole_val, name = name_val, email = email_val, countrycode = countrycode_val, phone = phone_val, emailverificationlink = baselink)
					if customer_obj:
						companydetail_obj = CompanyDetail.objects.create(customer = customer_obj, job_title = job_title, name = company_name, website = company_website, monthly_delivery_volume = monthly_delivery_volume, registration_number = registration_number, industry = industry)
						if companydetail_obj:
							return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address.'})
				if userrole_val == 'driver':
					driver_obj = DriverModel.objects.create(user = user_obj, name = name_val, email = email_val, countrycode = countrycode_val, phone = phone_val, emailverificationlink = baselink)
					if driver_obj:
						respos=createDriverSlots(driver_obj.id)
						return JsonResponse({'status_code' : 200, 'status_message' : 'A verification link has been sent to your email address.'})
				# 	company_obj = Company.objects.create(user = user_obj, phone = phone_val, name = name_val, email = email_val, tinnumber = tinnumber_val, emailverificationlink = baselink)
				# 	if company_obj:
				# 		return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
				# elif userrole_val == 'driver':
				# 	driver_obj = Driver.objects.create(user = user_obj, name = name_val, email = email_val, phone = phone_val, vehicletype = vehicletype_val, vehiclenumber = vehiclenumber_val, preferredarea = preferredarea_val, emailverificationlink = baselink)
				# 	if driver_obj:
				# 		return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
				else:
					return JsonResponse({'status_code' : 400, 'status_message' : 'User Role is not defined'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})

class CustomerRegistration(TemplateView):
	template_name = 'customer_registration.html'

	def post(self, request, *args, **kwargs):
		'''This class saves the registration details of customer or company users'''
		try:
			userrole_val = request.POST.get('userrole')
			if not userrole_val:
				return JsonResponse({'status_code': 0, 'status_message': 'User Role is required'})
			firstname_val = request.POST.get('firstname')
			if not firstname_val:
				return JsonResponse({'status_code': 0, 'status_message': 'First Name is required'})
			lastname_val = request.POST.get('lastname')
			if not lastname_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Last Name is required'})
			email_val = request.POST.get('email')
			if not email_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Email Address is required'})
			countrycode_val = request.POST.get('countrycode')
			if not countrycode_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Countrycode is required'})
			if '+' not in countrycode_val:
				countrycode_val = '+' + countrycode_val
			phone_val = request.POST.get('phone')
			if not phone_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Phone number is required'})
			password_val = request.POST.get('password')
			if not password_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Password is required'})
			address_val = request.POST.get('address')
			if not address_val:
				return JsonResponse({'status_code': 0, 'status_message': 'Address is required'})
			user_obj = User.objects.filter(username = email_val).first()
			if user_obj:
				return JsonResponse({'status_code': 0, 'status_message': 'User exists.'})
			else:
				otp_val = request.POST.get('otp')
				if not otp_val:
					return JsonResponse({'status_code': 0, 'status_message': 'OTP is required'})
				otp_obj = OTP.objects.filter(mobile = countrycode_val + phone_val, case = 'signup', otp = otp_val).first()
				if otp_obj:
					currentdatetime = datetime.datetime.now(pytz.timezone('UTC'))
					if (currentdatetime >= otp_obj.startdatetime and currentdatetime <= otp_obj.expiredatetime):
						otp_obj.verified = True
						otp_obj.save()
						user_obj = User.objects.create_user(username = email_val, email = email_val, password = password_val, first_name = firstname_val, last_name = lastname_val)
						if user_obj:
							if userrole_val == 'customer':
								customer_obj = Customer.objects.create(user = user_obj, countrycode = countrycode_val, phone = phone_val, address = address_val)
								if customer_obj:
									return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
							elif userrole_val == 'company':
								company_obj = Company.objects.create(user = user_obj, countrycode = countrycode_val, phone = phone_val, address = address_val)
								if company_obj:
									return JsonResponse({'status_code' : 200, 'status_message' : 'Record added successfully.'})
							else:
								return JsonResponse({'status_code' : 0, 'status_message' : 'Record not created.'})
						return JsonResponse({'status_code': 0, 'status_message': 'Some backend error occurred.'})
					else:
						return JsonResponse({'status_code': 0, 'status_message': 'OTP has been expired.'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Invalid OTP.'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 0, 'status_message': 'Internal Server Error'})

	def get_context_data(self,**kwargs):
		context = super(CustomerRegistration, self).get_context_data(**kwargs)
		print("CustomerRegistration-in get ")
		return context	


class Logout(APIView):
	def get(self, request):
		'''This function performs the logout operation by deleting all session elements'''
		print("Logout-in get ")
		if self.request.session.has_key('email'):
			del self.request.session['email']
		userrole = 'customer'
		if self.request.session.has_key('userrole'):
			userrole = self.request.session['userrole'] 
			del self.request.session['userrole']
		if userrole == 'customer' or userrole == 'driver':
			return HttpResponseRedirect(reverse('customer-login'))
		elif userrole == 'admin' or userrole == 'superadmin':
			return HttpResponseRedirect(reverse('admin-login'))
		else:
			return HttpResponseRedirect(reverse('customer-login'))

@method_decorator(checkifcustomeralreadylogin, name='dispatch')
class Index(TemplateView):
	template_name = 'index.html'

	def get_context_data(self,**kwargs):
		context = super(Index, self).get_context_data(**kwargs)
		'''This function returns the index page for application url'''
		print("Index-in get ")
		if self.request.session.has_key('userrole'):
			userrole = self.request.session['userrole']
			if userrole == 'customer':
				return HttpResponseRedirect(reverse('customer-dashboard'))
			elif userrole == 'company':
				return HttpResponseRedirect(reverse('company-dashboard'))
			elif userrole == 'driver':
				return HttpResponseRedirect(reverse('driver-dashboard'))
			elif userrole == 'admin':
				return HttpResponseRedirect(reverse('admin-dashboard'))
			elif userrole == 'superadmin':
				return HttpResponseRedirect(reverse('superadmin-dashboard'))
			else:
				return HttpResponseRedirect(reverse('customer-login'))

		else:
			return context	
			# return HttpResponseRedirect(reverse('customer-login'))

class AboutUs(TemplateView):
	template_name = 'aboutus.html'

	def get_context_data(self,**kwargs):
		context = super(AboutUs, self).get_context_data(**kwargs)
		'''This function returns the index page for application url'''
		print("AboutUs-in get ")
		
		return context	

class TutorialView(TemplateView):
	template_name = 'tutorial.html'

	def get_context_data(self,**kwargs):
		context = super(TutorialView, self).get_context_data(**kwargs)
		'''This function returns the index page for application url'''
		print("TutorialView-in get ")
		
		return context	


class TermsAndConditions(TemplateView):
	template_name = 'termsandconditions.html'

	def get_context_data(self,**kwargs):
		context = super(TermsAndConditions, self).get_context_data(**kwargs)
		'''This function returns the index page for application url'''
		print("TermsAndConditions-in get ")
		
		return context	


class FunctionalDocument(TemplateView):
	template_name = 'functional_document.html'

	def get_context_data(self,**kwargs):
		context = super(FunctionalDocument, self).get_context_data(**kwargs)
		'''This function returns the index page for application url'''
		print("FunctionalDocument-in get ")
		
		return context	

class ChangePassword(TemplateView):
	template_name = 'changepassword.html'

	def get_context_data(self,**kwargs):
		context = super(ChangePassword, self).get_context_data(**kwargs)
		'''This function returns the index page for application url'''
		print("ChangePassword-in get ")
		userrole = ''
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj)
				if customer_obj:
					userrole = 'customer'
				else:
					driver_obj = DriverModel.objects.filter(user = user_obj)
					if driver_obj:
						userrole = 'driver'
					# else:
						

		context['userrole'] = userrole
		return context	


	def post(self, request, *args, **kwargs):
		print('\n\n\n\naa')
		print('data is  : ',request.POST)
		try:
			userrole_val = request.POST.get('userrole')
			oldpassword_val = request.POST.get('oldpassword')
			newpassword_val = request.POST.get('newpassword')
			# if not userrole_val:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'UserRole is required',})
			if not oldpassword_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter old password',})
			if not newpassword_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter new password',})

			if self.request.session.has_key('email'):
				emailid = self.request.session['email']
			
				user_obj = User.objects.get(email = emailid)
				
				if user_obj.check_password(oldpassword_val):
					print('correct password')
					user_obj.password = make_password(newpassword_val)
					user_obj.save()
					return JsonResponse({'status_code': 200, 'status_message': 'success',})
					
				else:
					print('invalid password')
					return JsonResponse({'status_code': 400, 'status_message': 'Old password is incorrect',})

			
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})



class ForgotPassword(TemplateView):
	template_name = 'forgotpassword.html'

	def get_context_data(self,**kwargs):
		context = super(ForgotPassword, self).get_context_data(**kwargs)
		'''This function returns the index page for application url'''
		print("ForgotPassword-in get ")
		userrole = ''
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = Customer.objects.filter(user = user_obj)
				if customer_obj:
					userrole = 'customer'
				else:
					driver_obj = DriverModel.objects.filter(user = user_obj)
					if driver_obj:
						userrole = 'driver'
		context['userrole'] = userrole
		return context	


	def post(self, request, *args, **kwargs):
		try:
			print("ForgotPassword-in post")	
			print(request.POST)
			userrole_val = request.POST.get('userrole')
			email_val = request.POST.get('email')
			if not userrole_val:
				return JsonResponse({'status_code': 0, 'status_message': 'User Role is required'})
			if not email_val:
				return JsonResponse({'status': 400, 'message': 'Email Address is required',})		
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				if userrole_val == 'driver':
					userrole_obj = DriverModel.objects.filter(user = user_obj).first()
				elif userrole_val == 'customer':
					userrole_obj = Customer.objects.filter(user = user_obj, role = 'customer').first()
				elif userrole_val == 'company':
					userrole_obj = Customer.objects.filter(user = user_obj, role = 'company').first()
				if userrole_obj:	
					ran_num = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(12)])
					baselink = '/user/' + userrole_val + '/forgot/' + str(user_obj.email) + '/' + ran_num
					completelink = str(settings.WEB_BASE_URL) + baselink
					message = "\nForgot your Password click following link:\n" + completelink
					userrole_obj.forgot_password_link = baselink
					userrole_obj.save()
					send_mail('Forgot Password:',message,'testdemotest11@gmail.com',[str(email_val)],fail_silently=True)				
					return JsonResponse({'status_code': 200, 'status_message': 'A reset password link has been sent to your email address'})
				else:
					return JsonResponse({'status_code': 0, 'status_message': 'Email does not exist.',})				

			else:
				return JsonResponse({'status_code': 0, 'status_message': 'Email does not exist.',})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 0, 'status_message': str(e),})
