# Generated by Django 2.2 on 2022-01-07 09:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('Customer', '0001_initial'),
        ('AdminApp', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='DriverModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Open to take parcels'), (1, 'Occupied')], default=0)),
                ('countrycode', models.CharField(max_length=100, null=True)),
                ('phone', models.CharField(max_length=100, null=True)),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.CharField(blank=True, max_length=100, null=True, unique=True)),
                ('image', models.ImageField(blank=True, max_length=200, null=True, upload_to='static/profile/')),
                ('idproof', models.FileField(blank=True, null=True, upload_to='')),
                ('fcmtoken', models.CharField(blank=True, max_length=300, null=True)),
                ('vehicleimage', models.FileField(blank=True, max_length=200, null=True, upload_to='')),
                ('vehiclenumber', models.CharField(blank=True, max_length=100, null=True)),
                ('preferredarea', models.CharField(blank=True, max_length=100, null=True)),
                ('address', models.TextField(blank=True, default='', null=True)),
                ('city', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('postalcode', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('country', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('national_insurance_number', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('driving_license_number', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('license_front', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('license_front_documentStatus', models.IntegerField(default=0)),
                ('license_back', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('license_back_documentStatus', models.IntegerField(default=0)),
                ('id_front', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('id_front_documentStatus', models.IntegerField(default=0)),
                ('id_back', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('id_back_documentStatus', models.IntegerField(default=0)),
                ('crb_dbs', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('crb_dbs_documentStatus', models.IntegerField(default=0)),
                ('emailverificationlink', models.CharField(blank=True, max_length=300, null=True)),
                ('forgot_password_link', models.CharField(blank=True, max_length=500, null=True)),
                ('emailverified', models.BooleanField(default=False)),
                ('accountapproved', models.BooleanField(default=False)),
                ('isdisabled', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('vehicletype', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='AdminApp.VehicleType')),
            ],
        ),
        migrations.CreateModel(
            name='DriverWorkingSlots',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slots', models.CharField(blank=True, max_length=100, null=True)),
                ('date', models.DateField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('driver', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverModel')),
            ],
        ),
        migrations.CreateModel(
            name='DriverVehicle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('vehiclenumber', models.CharField(blank=True, max_length=100, null=True)),
                ('vehicletype', models.CharField(blank=True, max_length=100, null=True)),
                ('vehicleimage', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('vehicleimage_status', models.IntegerField(default=0)),
                ('motor_insurance', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('motor_insurance_status', models.IntegerField(default=0)),
                ('goods_in_transit_cover', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('goods_in_transit_cover_status', models.IntegerField(default=0)),
                ('public_liability_insurance', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('public_liability_insurance_status', models.IntegerField(default=0)),
                ('active', models.BooleanField(default=False)),
                ('is_deleted', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('vehicle_approve_status', models.IntegerField(default=0)),
                ('driver', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverModel')),
            ],
        ),
        migrations.CreateModel(
            name='DriverJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sameIdForParcels', models.IntegerField(default=0)),
                ('jobstarted', models.BooleanField(default=False)),
                ('arrived_at_pickup', models.BooleanField(default=False)),
                ('parcel_picked_by_driver', models.BooleanField(default=False)),
                ('start_DropOff', models.BooleanField(default=False)),
                ('arrived_atDropOffLocation', models.BooleanField(default=False)),
                ('jobcompleted', models.BooleanField(default=False)),
                ('deliveryfailed', models.BooleanField(default=False)),
                ('paidtodriver', models.BooleanField(default=False)),
                ('iscancelledbyadmin', models.BooleanField(default=False)),
                ('isdeleted', models.BooleanField(default=False)),
                ('parcel_disabled', models.BooleanField(default=False)),
                ('safeplaceDeliverd', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('adminSumitionResaon', models.CharField(blank=True, max_length=100, null=True)),
                ('submitByAdmin', models.BooleanField(default=False)),
                ('priorityBaseIDJobs', models.IntegerField(default=1)),
                ('customerjob', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
                ('driver', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverModel')),
            ],
        ),
        migrations.CreateModel(
            name='DriverExtraMoney',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(blank=True, max_length=100, null=True)),
                ('amount', models.CharField(blank=True, max_length=100, null=True)),
                ('currency', models.CharField(blank=True, max_length=100, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('driver', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverModel')),
            ],
        ),
        migrations.CreateModel(
            name='DriverDropSafePalace',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('safeplace', models.FileField(blank=True, default='', max_length=200, null=True, upload_to='')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('customerjob', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='Customer.CustomerJob')),
                ('driver_job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverJob')),
            ],
        ),
        migrations.CreateModel(
            name='DriverCoordinates',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('latitude', models.CharField(blank=True, max_length=100, null=True)),
                ('longitude', models.CharField(blank=True, max_length=100, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('driver', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverModel')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DriverAllSlots',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dateOfSlots', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('openinghourSlot1', models.TimeField(null=True)),
                ('closinghourSlot1', models.TimeField(null=True)),
                ('activeSlot1', models.BooleanField(default=False)),
                ('openinghourSlot2', models.TimeField(null=True)),
                ('closinghourSlot2', models.TimeField(null=True)),
                ('activeSlot2', models.BooleanField(default=False)),
                ('openinghourSlot3', models.TimeField(null=True)),
                ('closinghourSlot3', models.TimeField(null=True)),
                ('activeSlot3', models.BooleanField(default=False)),
                ('openinghourSlot4', models.TimeField(null=True)),
                ('closinghourSlot4', models.TimeField(null=True)),
                ('activeSlot4', models.BooleanField(default=False)),
                ('openinghourSlot5', models.TimeField(null=True)),
                ('closinghourSlot5', models.TimeField(null=True)),
                ('activeSlot5', models.BooleanField(default=False)),
                ('openinghourSlot6', models.TimeField(null=True)),
                ('closinghourSlot6', models.TimeField(null=True)),
                ('activeSlot6', models.BooleanField(default=False)),
                ('openinghourSlot7', models.TimeField(null=True)),
                ('closinghourSlot7', models.TimeField(null=True)),
                ('activeSlot7', models.BooleanField(default=False)),
                ('openinghourSlot8', models.TimeField(null=True)),
                ('closinghourSlot8', models.TimeField(null=True)),
                ('activeSlot8', models.BooleanField(default=False)),
                ('openinghourSlot9', models.TimeField(null=True)),
                ('closinghourSlot9', models.TimeField(null=True)),
                ('activeSlot9', models.BooleanField(default=False)),
                ('openinghourSlot10', models.TimeField(null=True)),
                ('closinghourSlot10', models.TimeField(null=True)),
                ('activeSlot10', models.BooleanField(default=False)),
                ('openinghourSlot11', models.TimeField(null=True)),
                ('closinghourSlot11', models.TimeField(null=True)),
                ('activeSlot11', models.BooleanField(default=False)),
                ('openinghourSlot12', models.TimeField(null=True)),
                ('closinghourSlot12', models.TimeField(null=True)),
                ('activeSlot12', models.BooleanField(default=False)),
                ('openinghourSlot13', models.TimeField(null=True)),
                ('closinghourSlot13', models.TimeField(null=True)),
                ('activeSlot13', models.BooleanField(default=False)),
                ('openinghourSlot14', models.TimeField(null=True)),
                ('closinghourSlot14', models.TimeField(null=True)),
                ('activeSlot14', models.BooleanField(default=False)),
                ('openinghourSlot15', models.TimeField(null=True)),
                ('closinghourSlot15', models.TimeField(null=True)),
                ('activeSlot15', models.BooleanField(default=False)),
                ('openinghourSlot16', models.TimeField(null=True)),
                ('closinghourSlot16', models.TimeField(null=True)),
                ('activeSlot16', models.BooleanField(default=False)),
                ('openinghourSlot17', models.TimeField(null=True)),
                ('closinghourSlot17', models.TimeField(null=True)),
                ('activeSlot17', models.BooleanField(default=False)),
                ('openinghourSlot18', models.TimeField(null=True)),
                ('closinghourSlot18', models.TimeField(null=True)),
                ('activeSlot18', models.BooleanField(default=False)),
                ('openinghourSlot19', models.TimeField(null=True)),
                ('closinghourSlot19', models.TimeField(null=True)),
                ('activeSlot19', models.BooleanField(default=False)),
                ('openinghourSlot20', models.TimeField(null=True)),
                ('closinghourSlot20', models.TimeField(null=True)),
                ('activeSlot120', models.BooleanField(default=False)),
                ('openinghourSlot21', models.TimeField(null=True)),
                ('closinghourSlot21', models.TimeField(null=True)),
                ('activeSlot21', models.BooleanField(default=False)),
                ('openinghourSlot22', models.TimeField(null=True)),
                ('closinghourSlot22', models.TimeField(null=True)),
                ('activeSlot22', models.BooleanField(default=False)),
                ('openinghourSlot23', models.TimeField(null=True)),
                ('closinghourSlot23', models.TimeField(null=True)),
                ('activeSlot23', models.BooleanField(default=False)),
                ('openinghourSlot24', models.TimeField(null=True)),
                ('closinghourSlot24', models.TimeField(null=True)),
                ('activeSlot24', models.BooleanField(default=False)),
                ('driver', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='Driver.DriverModel')),
            ],
        ),
    ]
