from django.db import models
from django.contrib.auth.models import User
from django.utils.translation import gettext as _
from Customer.models import *
# from Admin.models import VehicleType


VEHICLETYPE_CHOICES = (
    (0, _("Bike")),
    (1, _("Car")),
    (2, _("Small Van")),
    (3, _("Medium Van")),    
    (4, _("Large Van")),
    (5, _("Not Specified")),
)

DRIVERSTATUS_CHOICES = (
    (0, _("Open to take parcels")),
    (1, _("Occupied")),
)




# Create your models here.

class DriverModel(models.Model):
	"""
	This model is used to store the information of driver.
	"""
	user = models.ForeignKey(User, on_delete = models.CASCADE)
	status = models.IntegerField(choices = DRIVERSTATUS_CHOICES, default = 0)
	countrycode = models.CharField(max_length = 100, null = True)
	phone = models.CharField(max_length = 100, null = True)
	name = models.CharField(max_length = 100, null = True, blank = True)
	email = models.CharField(max_length = 100, unique = True, null = True, blank = True)
	# country = models.ForeignKey(Country, on_delete = models.CASCADE, null = True, blank = True)
	# city = models.ForeignKey(City, on_delete = models.CASCADE, null = True, blank = True)
	# phone = models.CharField(max_length = 100, blank = True, null = True)
	image = models.ImageField(upload_to="static/profile/",max_length = 200,blank = True, null = True)
	idproof = models.FileField(blank = True, null = True)
	fcmtoken = models.CharField(max_length = 300, blank = True, null = True)
	
	vehicletype = models.ForeignKey(VehicleType, on_delete=models.SET_NULL, default = None, null = True, blank = True)
	vehicleimage = models.FileField(max_length = 200, blank = True, null = True)
	vehiclenumber = models.CharField(max_length = 100, blank = True, null = True)
	
	preferredarea = models.CharField(max_length = 100, blank = True, null = True)
	
	address = models.TextField(blank = True, default = '', null = True)
	city = models.CharField(max_length = 100, default = '', blank = True, null = True)
	postalcode = models.CharField(max_length = 100, default = '', blank = True, null = True)
	country = models.CharField(max_length = 100, default = '', blank = True, null = True)
	national_insurance_number = models.CharField(max_length = 100, default = '', blank = True, null = True)
	driving_license_number = models.CharField(max_length = 100, default = '', blank = True, null = True)

	license_front = models.FileField(max_length = 200, default = '', blank = True, null = True)
	license_front_documentStatus = models.IntegerField(default = 0)
	license_back = models.FileField(max_length = 200, default = '', blank = True, null = True)
	license_back_documentStatus = models.IntegerField(default = 0)
	id_front = models.FileField(max_length = 200, default = '', blank = True, null = True)
	id_front_documentStatus = models.IntegerField(default = 0)
	id_back = models.FileField(max_length = 200, default = '', blank = True, null = True)
	id_back_documentStatus = models.IntegerField(default = 0)
	crb_dbs = models.FileField(max_length = 200, default = '', blank = True, null = True)
	crb_dbs_documentStatus = models.IntegerField(default = 0)
	emailverificationlink = models.CharField(max_length = 300, blank = True, null = True)
	forgot_password_link = models.CharField(max_length = 500, blank = True, null = True)
	emailverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)

	def __str__(self):
		return str(str(self.email) + ' -- ' + str(self.email))

class DriverExtraMoney(models.Model):
	"""
	This model is used to store the information of driver.
	"""
	driver = models.ForeignKey(DriverModel, on_delete = models.CASCADE)
	description = models.CharField(max_length = 100, blank = True, null = True)
	amount = models.CharField(max_length = 100, blank = True, null = True)
	currency = models.CharField(max_length = 100, blank = True, null = True)

	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	def __str__(self):
		return str(str(self.id)	+ '  --  ' + str(self.driver)	+ '  --  ' + str(self.description)	+ '  --  ' + str(self.amount))


class DriverVehicle(models.Model):
	"""
	This model is used to store the information of driver.
	"""
	driver = models.ForeignKey(DriverModel, on_delete = models.CASCADE)
	vehiclenumber = models.CharField(max_length = 100, blank = True, null = True)
	vehicletype = models.CharField(max_length = 100, blank = True, null = True)
	vehicleimage = models.FileField(max_length = 200, default = '', blank = True, null = True)
	vehicleimage_status = models.IntegerField(default = 0)
	motor_insurance = models.FileField(max_length = 200, default = '', blank = True, null = True)
	motor_insurance_status = models.IntegerField(default = 0)
	goods_in_transit_cover = models.FileField(max_length = 200, default = '', blank = True, null = True)
	goods_in_transit_cover_status = models.IntegerField(default = 0)
	public_liability_insurance = models.FileField(max_length = 200, default = '', blank = True, null = True)
	public_liability_insurance_status = models.IntegerField(default = 0)

	active = models.BooleanField(default = False)
	is_deleted = models.BooleanField(default = False)

	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)
	vehicle_approve_status = models.IntegerField(default = 0)

	def __str__(self):
		return str(str(self.id)	+ '  --  ' + str(self.driver)	+ '  --  ' + str(self.vehicletype))


class DriverCoordinates(models.Model):
	"""
	This model is used to store the information of driver.
	"""
	user = models.ForeignKey(User, on_delete = models.CASCADE)
	driver = models.ForeignKey(DriverModel, on_delete = models.CASCADE)
	latitude = models.CharField(max_length = 100, blank = True, null = True)
	longitude = models.CharField(max_length = 100, blank = True, null = True)
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	def __str__(self):
		return str(str(self.id)	+ '  --  ' + str(self.driver)	+ '  --  ' + str(self.latitude)	+ '  --  ' + str(self.longitude))


class DriverWorkingSlots(models.Model):
	"""
	This model is used to store the information of driver.
	"""
	driver = models.ForeignKey(DriverModel, on_delete = models.CASCADE)
	slots = models.CharField(max_length = 100, blank = True, null = True)
	date = models.DateField()
	
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)

	def __str__(self):
		return str(str(self.id)	+ '  --  ' + str(self.driver)	+ '  --  ' + str(self.date)	+ '  --  ' + str(self.slots))

class DriverJob(models.Model):
	"""
	This model is used to store the information of CustomerJob.
	"""
	customerjob = models.ForeignKey(CustomerJob, on_delete=models.CASCADE, null = True, blank = True)
	driver = models.ForeignKey(DriverModel, on_delete=models.CASCADE, null = True, blank = True)
	sameIdForParcels=models.IntegerField(default = 0)
	jobstarted = models.BooleanField(default = False)
	arrived_at_pickup = models.BooleanField(default = False)
	parcel_picked_by_driver = models.BooleanField(default = False)
	start_DropOff = models.BooleanField(default = False)
	arrived_atDropOffLocation = models.BooleanField(default = False)
	jobcompleted = models.BooleanField(default = False)
	deliveryfailed = models.BooleanField(default = False)
	paidtodriver = models.BooleanField(default = False)
	iscancelledbyadmin = models.BooleanField(default=False)
	isdeleted = models.BooleanField(default = False)
	parcel_disabled = models.BooleanField(default = False)
	safeplaceDeliverd = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add=True)
	updated_at = models.DateTimeField(auto_now=True)
	adminSumitionResaon = models.CharField(max_length = 100, blank = True, null = True)
	submitByAdmin = models.BooleanField(default = False)
	priorityBaseIDJobs=models.IntegerField(default = 1)
	# arrivalatpickuplocation = models.BooleanField(default = False)
	# arrivalatdropofflocation = models.BooleanField(default = False)

	def __str__(self):
		return str(str(self.id)	+ '  --  ' + str(self.driver)	+ '  --  ' + str(self.customerjob.id)	+ '  --  ' + str(self.customerjob))

class DriverDropSafePalace(models.Model):
	"""
	This model is used to store the information of driver.
	"""
	driver_job = models.ForeignKey(DriverJob, on_delete = models.CASCADE)
	customerjob = models.ForeignKey(CustomerJob, on_delete=models.CASCADE, null = True, blank = True)
	safeplace = models.FileField(max_length = 200, default = '', blank = True, null = True)
	created_at = models.DateTimeField(auto_now_add=True)

	def __str__(self):
		return str(str(self.driver_job)	+ '  --  ' + str(self.customerjob))


class DriverAllSlots(models.Model):
	"""
	This model is used to store the information of driver.
	"""
	driver = models.ForeignKey(DriverModel, on_delete = models.CASCADE)
	dateOfSlots= models.CharField(max_length = 100, default = '', blank = True, null = True)
	openinghourSlot1 = models.TimeField(null = True)
	closinghourSlot1 = models.TimeField(null = True)
	activeSlot1 = models.BooleanField(default = False)
	openinghourSlot2 = models.TimeField(null = True)
	closinghourSlot2 = models.TimeField(null = True)
	activeSlot2 = models.BooleanField(default = False)
	openinghourSlot3 = models.TimeField(null = True)
	closinghourSlot3 = models.TimeField(null = True)
	activeSlot3 = models.BooleanField(default = False)
	openinghourSlot4 = models.TimeField(null = True)
	closinghourSlot4 = models.TimeField(null = True)
	activeSlot4 = models.BooleanField(default = False)
	openinghourSlot5 = models.TimeField(null = True)
	closinghourSlot5 = models.TimeField(null = True)
	activeSlot5 = models.BooleanField(default = False)
	openinghourSlot6 = models.TimeField(null = True)
	closinghourSlot6 = models.TimeField(null = True)
	activeSlot6 = models.BooleanField(default = False)
	openinghourSlot7 = models.TimeField(null = True)
	closinghourSlot7 = models.TimeField(null = True)
	activeSlot7 = models.BooleanField(default = False)
	openinghourSlot8 = models.TimeField(null = True)
	closinghourSlot8 = models.TimeField(null = True)
	activeSlot8 = models.BooleanField(default = False)
	openinghourSlot9 = models.TimeField(null = True)
	closinghourSlot9 = models.TimeField(null = True)
	activeSlot9 = models.BooleanField(default = False)
	openinghourSlot10 = models.TimeField(null = True)
	closinghourSlot10 = models.TimeField(null = True)
	activeSlot10 = models.BooleanField(default = False)
	openinghourSlot11 = models.TimeField(null = True)
	closinghourSlot11 = models.TimeField(null = True)
	activeSlot11 = models.BooleanField(default = False)
	openinghourSlot12 = models.TimeField(null = True)
	closinghourSlot12 = models.TimeField(null = True)
	activeSlot12 = models.BooleanField(default = False)
	openinghourSlot13 = models.TimeField(null = True)
	closinghourSlot13 = models.TimeField(null = True)
	activeSlot13 = models.BooleanField(default = False)
	openinghourSlot14 = models.TimeField(null = True)
	closinghourSlot14 = models.TimeField(null = True)
	activeSlot14 = models.BooleanField(default = False)
	openinghourSlot15 = models.TimeField(null = True)
	closinghourSlot15 = models.TimeField(null = True)
	activeSlot15 = models.BooleanField(default = False)
	openinghourSlot16 = models.TimeField(null = True)
	closinghourSlot16 = models.TimeField(null = True)
	activeSlot16 = models.BooleanField(default = False)
	openinghourSlot17 = models.TimeField(null = True)
	closinghourSlot17 = models.TimeField(null = True)
	activeSlot17 = models.BooleanField(default = False)
	openinghourSlot18 = models.TimeField(null = True)
	closinghourSlot18 = models.TimeField(null = True)
	activeSlot18 = models.BooleanField(default = False)
	openinghourSlot19 = models.TimeField(null = True)
	closinghourSlot19 = models.TimeField(null = True)
	activeSlot19 = models.BooleanField(default = False)
	openinghourSlot20 = models.TimeField(null = True)
	closinghourSlot20 = models.TimeField(null = True)
	activeSlot120 = models.BooleanField(default = False)
	openinghourSlot21 = models.TimeField(null = True)
	closinghourSlot21 = models.TimeField(null = True)
	activeSlot21 = models.BooleanField(default = False)
	openinghourSlot22 = models.TimeField(null = True)
	closinghourSlot22 = models.TimeField(null = True)
	activeSlot22 = models.BooleanField(default = False)
	openinghourSlot23 = models.TimeField(null = True)
	closinghourSlot23 = models.TimeField(null = True)
	activeSlot23 = models.BooleanField(default = False)
	openinghourSlot24 = models.TimeField(null = True)
	closinghourSlot24 = models.TimeField(null = True)
	activeSlot24 = models.BooleanField(default = False)


	def __str__(self):
		return str(str(self.driver))