from django.urls import path
from django.conf.urls import url
from .views import *
from django.views.decorators.csrf import csrf_exempt
urlpatterns = [
	path('login/', Login.as_view(), name = 'driver-login'),
	path('dashboard/', Dashboard.as_view(), name = 'driver-dashboard'),
	path('profile/', DriverProfile.as_view(), name = 'driver-profile'),
	path('chat/', DriverChat.as_view(), name = 'driver-chat'),
	path('chat/test/', DriverChatTest.as_view(), name = 'driver-chat'), # for testing web sockets
	path('sendmessagetoadmin/', csrf_exempt(DriverSendMessageToAdmin.as_view()), name = 'driver-sendmessagetoadmin'),
	
	path('profile/update', DriverProfileUpdate.as_view(), name = 'driver-profile-update'),
	path('checkprofileupdated/', CheckDriverProfileCompleted.as_view(), name = 'driver-check-profile-updated'),


	path('myjobs/', MyJobs.as_view(), name = 'my-jobs'),
	path('myjobs/outstandingrequests/', DriverOutstandingRequests2.as_view(), name = 'driver-outstanding-requests'),
	path('myjobs/completedrequests/', DriverCompletedRequests2.as_view(), name = 'driver-completed-requests'),
	path('notifications/', DriverNotifications.as_view(), name = 'driver-notifications'),
	url(r'^customerjobdetail/(?P<customerjobid>\d+)/$', CustomerJobDetail2.as_view(), name = 'driver-customer-job-detail'),
	path('updatecoordinates/', DriverUpdateCoordinates.as_view(), name = 'driver-updatecoordinates-web'),

	path('paymenthistory/', DriverPaymentHistory.as_view(), name = 'driver-payment-history'),
	path('vehicle/', vehicle.as_view(), name = 'driver-payment-history'),
	url(r'^showVehicalDoc/(?P<id>\d+)/$', showVehicalDoc.as_view(), name = 'driver-payment-history'),
	path('addVehicle/', DriverAddVehicle.as_view(), name = 'driver-payment-history'),
	path('uploadVehicleDoc/', uploadVehicleDoc.as_view(), name = 'driver-payment-history'),
	path('uploadDriverDoc/', uploadDriverDoc.as_view(), name = 'driver-payment-history'),
]
