from django.shortcuts import render
from django.views.generic.base import TemplateView, View
from rest_framework.views import APIView
from django.contrib.auth import authenticate
from rest_framework.authtoken.models import Token
from django.utils.decorators import method_decorator
from django.http import JsonResponse, HttpResponse
from Driver.models import *
from AdminApp.models import *
from .decorators import checklogindriver
from django.conf import settings
import json, base64, os, random, string
from io import BytesIO
from PIL import Image
from django.core.files.storage import FileSystemStorage
from django.core.paginator import Paginator
import pytz
# Create your views here.

@method_decorator(checklogindriver, name='dispatch')
class showVehicalDoc(TemplateView):
	'''This class is used to show the content on driver dashboard screen'''
	template_name = 'uploadDoc.html'

	def get_context_data(self,**kwargs):
		context = super(showVehicalDoc, self).get_context_data(**kwargs)
		docId=kwargs['id']
		print("showVehicalDoc - in get ")
		recent_driverjobs_data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				driver_obj = DriverModel.objects.filter(user = user_obj).prefetch_related('user').first()
				if driver_obj:
					drivervehicle_obj = DriverVehicle.objects.filter(id=docId)
					context['driverVehical'] = drivervehicle_obj
		return context


class uploadVehicleDoc(View):
	def post(self, request):
		'''This function shows the content on profile screen'''
		print("uploadVehicleDoc - in post ")
		try:
			def getI420FromBase64(document_name,codec, id_val, image_path="c:\\"):
				print(id_val)
				print('\n\n')
				# print(codec)
				print('0')
				base64_data = codec.split(";base64,")
				print('1')
				extens = base64_data[0]
				print('2')
				ext = extens.split("/")
				print('3')
				print(ext)
				extension = str(ext[1])
				print('4')
				base64_data = base64_data[1]
				print('5')
				byte_data = base64.b64decode(base64_data)
				print('6')
				image_data = BytesIO(byte_data)
				print('7')
				from PIL import Image
				import string, random, os
				print('8')
				img = Image.open(image_data)
				print('9')
				# driver_obj = DriverModel.objects.get(id=id_val)
				driverVehical=DriverVehicle.objects.filter(id = id_val).first()
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driverVehical.driver.id)+'_'+str(driverVehical.driver.user.email)
				print('10')
				if(os.path.exists(filepath)):
					print('11')
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					print('12')
					os.makedirs(filepath)
				print('13')
				for obj in thumbnailsize_objs:
					img = Image.open(image_data)
					im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
					im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
				img = Image.open(image_data)	
				print('14')
				img.save(filepath+'/original-'+st+'.'+extension)	
				print('15')
				filename = '/media/Users/Drivers/'+str(driverVehical.driver.id)+'_'+str(driverVehical.driver.user.email)+'/original-'+st+'.'+extension
				# drivervehicle_obj = DriverVehicle.objects.create(driver = driver_obj)
				if document_name == 'motor_insurance':
					driverVehical.motor_insurance = filename
					driverVehical.motor_insurance_status=1
				elif document_name == 'goods_in_transit_cover':
					driverVehical.goods_in_transit_cover = filename
					driverVehical.goods_in_transit_cover_status=1
				elif document_name == 'public_liability_insurance':
					driverVehical.public_liability_insurance = filename
					driverVehical.public_liability_insurance_status=1
				elif document_name == 'vehicleimage':
					driverVehical.vehicleimage = filename
					driverVehical.vehicleimage_status=1	
				driverVehical.save()
				# driverVehical.vehicleimage = filename
				# driverVehical.save()
				return('1')
			def upload_func(file,filename):
				print("Writing file")
				with open(filename,'wb+') as f:
					for chunk in file.chunks():
						f.write(chunk)
				return 1
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			driver_obj = DriverModel.objects.filter(email = email_val).first()
			if driver_obj:
				pass
			drivervehicle_id = self.request.POST.get('id')
			document_name = self.request.POST.get('docName')
			document_file = self.request.POST.get('file')
			file_type='image'
			if not drivervehicle_id:
				return JsonResponse({'status_code': 400, 'status_message': 'drivervehicle_id is required.'})
			if not document_name:
				return JsonResponse({'status_code': 400, 'status_message': 'document_name is required.'})
			if not document_file:
				return JsonResponse({'status_code': 400, 'status_message': 'File is required.'})
			if not file_type:
				return JsonResponse({'status_code': 400, 'status_message': 'File Type is required.'})
			# driver_obj = DriverModel.objects.filter(user = user_obj).first()
			if driver_obj:
				drivervehicle_obj = DriverVehicle.objects.filter(driver = driver_obj).first()
				if driver_obj:
					if drivervehicle_obj:
						drivervehicle_obj = DriverVehicle.objects.get(id=drivervehicle_id)
						if file_type=='image':
							image=document_file
							# customerjob_obj = CustomerJob.objects.filter(id = customerjobid_val).first()
							# filename = image.name
							# filename = filename.split('.')
							# extension = str(filename[-1])
							# image_data = BytesIO(image.read())
							# img = Image.open(image_data)
							# st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
							# filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)
							# filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
							# if(os.path.exists(filepath)):
								# pass
							# else:
								# os.makedirs(filepath)
							# img.save(filepath+'/'+st+'.'+extension)	
							# img.save(filepath +'/pickup_proofofdelivery.'+extension)	
							# filename = '/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)+'/'+st+'.'+extension
							# if document_name == 'motor_insurance':
							getI420FromBase64(document_name,image,drivervehicle_id)
							# 	drivervehicle_obj.motor_insurance = filename
							# 	drivervehicle_obj.motor_insurance_status=1
							# elif document_name == 'goods_in_transit_cover':
							# 	getI420FromBase64(image,drivervehicle_id)
							# 	drivervehicle_obj.goods_in_transit_cover = filename
							# 	drivervehicle_obj.goods_in_transit_cover_status=1
							# elif document_name == 'public_liability_insurance':
							# 	getI420FromBase64(image,drivervehicle_id)
							# 	drivervehicle_obj.public_liability_insurance = filename
							# 	drivervehicle_obj.public_liability_insurance_status=1
							# drivervehicle_obj.save()
							# return('1')
							# filename = '/media/CustomerJobs/'+str(customerjob_obj.id) + '/pickup_proofofdelivery.'+extension
							# customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job_id = customerjobid_val).first()
							# if customerjobdeliveryextradetails_obj:
							# 	customerjobdeliveryextradetails_obj.pickup_proof_method = method_type
							# 	customerjobdeliveryextradetails_obj.pickup_fromperson_name = name_val
							# 	customerjobdeliveryextradetails_obj.pickup_fromperson_signature = filename
							# 	customerjobdeliveryextradetails_obj.save()
							# else:
							# 	CustomerJobDeliveryExtraDetails.objects.create(job_id = customerjobid_val, pickup_proof_method = method_type, pickup_fromperson_name = name_val, pickup_fromperson_signature = filename)
							

							# codec = 'data:image/png;base64,' + document_image
							# print('before function call')
							# res = getI420FromBase64(codec, id_val = drivervehicle_id, document_name = document_name)
							# print('after function call')
							# if res == '1':
						if file_type=='pdf':
							pdf_file=document_file
							# customerjob_obj = CustomerJob.objects.filter(id = customerjobid_val).first()
							filename = pdf_file.name
							filename = filename.split('.')
							extension = str(filename[-1])
							# image_data = BytesIO(image.read())
							# img = Image.open(image_data)
							st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
							filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)
							# filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
							if(os.path.exists(filepath)):
								pass
							else:
								os.makedirs(filepath)
							# img.save(filepath+'/'+st+'.'+extension)	
							# img.save(filepath +'/pickup_proofofdelivery.'+extension)	
							filename = '/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)+'/'+st+'.'+extension
							res=upload_func(pdf_file,str(settings.BASE_DIR)+filename)
							if res==1:
								print("file saved successfully")
							else:
								print("file not saved")
							if document_name == 'motor_insurance':
								drivervehicle_obj.motor_insurance = filename
								drivervehicle_obj.motor_insurance_status=1
							elif document_name == 'goods_in_transit_cover':
								drivervehicle_obj.goods_in_transit_cover = filename
								drivervehicle_obj.goods_in_transit_cover_status=1
							elif document_name == 'public_liability_insurance':
								drivervehicle_obj.public_liability_insurance = filename
								drivervehicle_obj.public_liability_insurance_status=1
							drivervehicle_obj.save()
						return JsonResponse({'status_code': 200, 'status_message': 'success'})
						# else:
							# return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})
		try:
			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				print('\n\n')
				# print(codec)
				print('0')
				base64_data = codec.split(";base64,")
				print('1')
				extens = base64_data[0]
				print('2')
				ext = extens.split("/")
				print('3')
				print(ext)
				extension = str(ext[1])
				print('4')
				base64_data = base64_data[1]
				print('5')
				byte_data = base64.b64decode(base64_data)
				print('6')
				image_data = BytesIO(byte_data)
				print('7')
				from PIL import Image
				import string, random, os
				print('8')
				img = Image.open(image_data)
				print('9')
				# driver_obj = DriverModel.objects.get(id=id_val)
				driverVehical=DriverVehicle.objects.filter(id = id_val).first()
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driverVehical.driver.id)+'_'+str(driverVehical.driver.user.email)
				print('10')
				if(os.path.exists(filepath)):
					print('11')
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					print('12')
					os.makedirs(filepath)
				print('13')
				for obj in thumbnailsize_objs:
					img = Image.open(image_data)
					im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
					im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
				img = Image.open(image_data)	
				print('14')
				img.save(filepath+'/original-'+st+'.'+extension)	
				print('15')
				filename = '/media/Users/Drivers/'+str(driverVehical.driver.id)+'_'+str(driverVehical.driver.user.email)+'/original-'+st+'.'+extension
				# drivervehicle_obj = DriverVehicle.objects.create(driver = driver_obj)
				driverVehical.vehicleimage = filename
				driverVehical.save()
				return('1')
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			driver_obj = DriverModel.objects.filter(email = email_val).first()
			if driver_obj:
				vehiclenumber = self.request.POST.get('name')
				vehicletype = self.request.POST.get('type')
				vehicleimage = self.request.POST.get('image')
				status='active'
				if not vehicleimage:
					return JsonResponse({'status_code': 400, 'status_message': 'vehicleimage is required.'})
				if not vehiclenumber:
					return JsonResponse({'status_code': 400, 'status_message': 'vehiclenumber is required.'})
				if not vehicletype:
					return JsonResponse({'status_code': 400, 'status_message': 'vehicletype is required.'})
				if driver_obj:
					if status == 'active':
						active = True
						DriverVehicle.objects.filter(driver = driver_obj).update(active = False)
					else:
						active = False
					try:
						vehical_list_obj=VehicleType.objects.filter(name=vehicletype).first()
						driver_obj.vehicletype=vehical_list_obj
						driver_obj.save()
					except Exception as e:
						print(e)
					drivervehicle_obj = DriverVehicle.objects.create(driver = driver_obj, vehiclenumber = vehiclenumber, vehicletype = vehicletype, active = active)
					if drivervehicle_obj:
						if vehicleimage:
							# codec = 'data:image/png;base64,' + vehicleimage
							codec=vehicleimage
							print('before function call')
							res = getI420FromBase64(codec, id_val = drivervehicle_obj.id)
							print('after function call')
							if res == '1':
								return JsonResponse({'status_code': 200, 'status_message': 'success', 'vehicleid' : drivervehicle_obj.id})
							else:
								return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
						else:
							return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})

class uploadDriverDoc(View):
	def post(self, request):
		'''This function shows the content on profile screen'''
		print("uploadDriverDoc - in post ")
		try:
			def getI420FromBase64(document_name,codec, id_val, image_path="c:\\"):
				print(id_val)
				print('\n\n')
				# print(codec)
				print('0')
				base64_data = codec.split(";base64,")
				print('1')
				extens = base64_data[0]
				print('2')
				ext = extens.split("/")
				print('3')
				print(ext)
				extension = str(ext[1])
				print('4')
				base64_data = base64_data[1]
				print('5')
				byte_data = base64.b64decode(base64_data)
				print('6')
				image_data = BytesIO(byte_data)
				print('7')
				from PIL import Image
				import string, random, os
				print('8')
				img = Image.open(image_data)
				print('9')
				driver_obj = DriverModel.objects.get(id=id_val)
				# driverVehical=DriverVehicle.objects.filter(id = id_val).first()
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)
				print('10')
				if(os.path.exists(filepath)):
					print('11')
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					print('12')
					os.makedirs(filepath)
				print('13')
				for obj in thumbnailsize_objs:
					img = Image.open(image_data)
					im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
					im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
				img = Image.open(image_data)	
				print('14')
				img.save(filepath+'/original-'+st+'.'+extension)	
				print('15')
				filename = '/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)+'/original-'+st+'.'+extension
				# drivervehicle_obj = DriverVehicle.objects.create(driver = driver_obj)
				print('16')
				if document_name == 'license_front':
					driver_obj.license_front = filename
					driver_obj.license_front_documentStatus=1
				elif document_name == 'license_back':
					driver_obj.license_back = filename
					driver_obj.license_back_documentStatus=1
				elif document_name == 'id_front':
					driver_obj.id_front = filename
					driver_obj.id_front_documentStatus=1
				elif document_name == 'id_back':
					driver_obj.id_back = filename
					driver_obj.id_back_documentStatus=1
				elif document_name == 'crb_dbs':
					driver_obj.crb_dbs = filename
					driver_obj.crb_dbs_documentStatus=1		
				driver_obj.save()
				# driverVehical.vehicleimage = filename
				# driverVehical.save()
				print('17')
				return('1')
			def upload_func(file,filename):
				print("Writing file")
				with open(filename,'wb+') as f:
					for chunk in file.chunks():
						f.write(chunk)
				return 1
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			driver_obj = DriverModel.objects.filter(email = email_val).first()
			if driver_obj:
				pass
			drivervehicle_id = self.request.POST.get('id')
			document_name = self.request.POST.get('docName')
			document_file = self.request.POST.get('file')
			file_type='image'
			# if not drivervehicle_id:
			# 	return JsonResponse({'status_code': 400, 'status_message': 'Driver id is required.'})
			if not document_name:
				return JsonResponse({'status_code': 400, 'status_message': 'document_name is required.'})
			if not document_file:
				return JsonResponse({'status_code': 400, 'status_message': 'File is required.'})
			if not file_type:
				return JsonResponse({'status_code': 400, 'status_message': 'File Type is required.'})
			# driver_obj = DriverModel.objects.filter(user = user_obj).first()
			if driver_obj:
				forFun=True
				# drivervehicle_obj = DriverVehicle.objects.filter(driver = driver_obj).first()
				if driver_obj:
					if forFun:
						if file_type=='image':
							image=document_file
							getI420FromBase64(document_name,image,driver_obj.id)
							print('18')
						# drivervehicle_obj = DriverVehicle.objects.get(id=drivervehicle_id)
						# if file_type=='image':
						# 	image=document_file
						# 	getI420FromBase64(document_name,image,drivervehicle_id)
							
						if file_type=='pdf':
							pdf_file=document_file
							# customerjob_obj = CustomerJob.objects.filter(id = customerjobid_val).first()
							filename = pdf_file.name
							filename = filename.split('.')
							extension = str(filename[-1])
							# image_data = BytesIO(image.read())
							# img = Image.open(image_data)
							st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
							filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)
							# filepath = str(settings.BASE_DIR)+'/media/CustomerJobs/'+str(customerjob_obj.id)
							if(os.path.exists(filepath)):
								pass
							else:
								os.makedirs(filepath)
							# img.save(filepath+'/'+st+'.'+extension)	
							# img.save(filepath +'/pickup_proofofdelivery.'+extension)	
							filename = '/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)+'/'+st+'.'+extension
							res=upload_func(pdf_file,str(settings.BASE_DIR)+filename)
							if res==1:
								print("file saved successfully")
							else:
								print("file not saved")
							if document_name == 'motor_insurance':
								drivervehicle_obj.motor_insurance = filename
								drivervehicle_obj.motor_insurance_status=1
							elif document_name == 'goods_in_transit_cover':
								drivervehicle_obj.goods_in_transit_cover = filename
								drivervehicle_obj.goods_in_transit_cover_status=1
							elif document_name == 'public_liability_insurance':
								drivervehicle_obj.public_liability_insurance = filename
								drivervehicle_obj.public_liability_insurance_status=1
							drivervehicle_obj.save()
						print('19')
						return JsonResponse({'status_code': 200, 'status_message': 'success'})
						# else:
							# return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})			

class DriverAddVehicle(View):
	def post(self, request):
		'''This function shows the content on profile screen'''
		print("DriverAddVehicle - in post ")
		try:
			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				print('\n\n')
				# print(codec)
				print('0')
				base64_data = codec.split(";base64,")
				print('1')
				extens = base64_data[0]
				print('2')
				ext = extens.split("/")
				print('3')
				print(ext)
				extension = str(ext[1])
				print('4')
				base64_data = base64_data[1]
				print('5')
				byte_data = base64.b64decode(base64_data)
				print('6')
				image_data = BytesIO(byte_data)
				print('7')
				from PIL import Image
				import string, random, os
				print('8')
				img = Image.open(image_data)
				print('9')
				# driver_obj = DriverModel.objects.get(id=id_val)
				driverVehical=DriverVehicle.objects.filter(id = id_val).first()
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driverVehical.driver.id)+'_'+str(driverVehical.driver.user.email)
				print('10')
				if(os.path.exists(filepath)):
					print('11')
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					print('12')
					os.makedirs(filepath)
				print('13')
				for obj in thumbnailsize_objs:
					img = Image.open(image_data)
					im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
					im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
				img = Image.open(image_data)	
				print('14')
				img.save(filepath+'/original-'+st+'.'+extension)	
				print('15')
				filename = '/media/Users/Drivers/'+str(driverVehical.driver.id)+'_'+str(driverVehical.driver.user.email)+'/original-'+st+'.'+extension
				# drivervehicle_obj = DriverVehicle.objects.create(driver = driver_obj)
				driverVehical.vehicleimage = filename
				driverVehical.save()
				return('1')
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			driver_obj = DriverModel.objects.filter(email = email_val).first()
			if driver_obj:
				vehiclenumber = self.request.POST.get('name')
				vehicletype = self.request.POST.get('type')
				vehicleimage = self.request.POST.get('image')
				status='active'
				if not vehicleimage:
					return JsonResponse({'status_code': 400, 'status_message': 'vehicleimage is required.'})
				if not vehiclenumber:
					return JsonResponse({'status_code': 400, 'status_message': 'vehiclenumber is required.'})
				if not vehicletype:
					return JsonResponse({'status_code': 400, 'status_message': 'vehicletype is required.'})
				if driver_obj:
					if status == 'active':
						active = True
						DriverVehicle.objects.filter(driver = driver_obj).update(active = False)
					else:
						active = False
					try:
						vehical_list_obj=VehicleType.objects.filter(name=vehicletype).first()
						driver_obj.vehicletype=vehical_list_obj
						driver_obj.save()
					except Exception as e:
						print(e)
					drivervehicle_obj = DriverVehicle.objects.create(driver = driver_obj, vehiclenumber = vehiclenumber, vehicletype = vehicletype, active = active)
					if drivervehicle_obj:
						if vehicleimage:
							# codec = 'data:image/png;base64,' + vehicleimage
							codec=vehicleimage
							print('before function call')
							res = getI420FromBase64(codec, id_val = drivervehicle_obj.id)
							print('after function call')
							if res == '1':
								return JsonResponse({'status_code': 200, 'status_message': 'success', 'vehicleid' : drivervehicle_obj.id})
							else:
								return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
						else:
							return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
					else:
						return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
				else:
					return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'Not a valid request'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error'})




@method_decorator(checklogindriver, name='dispatch')
class vehicle(TemplateView):
	'''This class is used to show the content on driver dashboard screen'''
	template_name = 'vehicle.html'

	def get_context_data(self,**kwargs):
		context = super(vehicle, self).get_context_data(**kwargs)
		print("vehicle - in get ")
		recent_driverjobs_data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				driverDocs=[]
				driver_obj = DriverModel.objects.filter(user = user_obj).prefetch_related('user').first()
				if driver_obj:
					driverDocs.append({'license_front_documentStatus':driver_obj.license_front_documentStatus,
						'license_front':driver_obj.license_front.name,
						'license_back':driver_obj.license_back.name,
						'license_back_documentStatus':driver_obj.license_back_documentStatus,
						'id_front':driver_obj.id_front.name,
						'id_front_documentStatus':driver_obj.id_front_documentStatus,
						'id_back':driver_obj.id_back.name,
						'id_back_documentStatus':driver_obj.id_back_documentStatus,
						'crb_dbs':driver_obj.crb_dbs.name,
						'crb_dbs_documentStatus':driver_obj.crb_dbs_documentStatus,})
					drivervehicle_obj = DriverVehicle.objects.filter(driver=driver_obj).order_by('-id')
					for d in drivervehicle_obj:
						print(d.vehicleimage)
					context['driverVehical'] = drivervehicle_obj
					context['driverDocs'] = driverDocs
		allvehical=VehicleType.objects.filter(isdeleted=False)
		context['allvehical']=allvehical
		return context

class DriverPaymentHistory(TemplateView):
	template_name = 'driver_paymenthistory.html'

	def get_context_data(self,**kwargs):
		context = super(DriverPaymentHistory, self).get_context_data(**kwargs)
		''' This API method is used to get profile data of user'''
		print('data is  : ',self.request.GET)
		try:
			paymenthistory_data= [] 
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
				user_obj = User.objects.filter(email = email_val).first()
				print('0')
				if user_obj:
					driver_obj = DriverModel.objects.filter(user = user_obj).first()
					if driver_obj:
						# yesterday_date = datetime.date.today() - timedelta (days = 7)
						from_date = '01/08/2020'
						from_date = datetime.datetime.strptime(from_date, "%d/%m/%Y")
						# from_date = datetime.date.today()
						to_date = datetime.datetime.combine(datetime.date.today(), datetime.datetime.min.time())
						# to_date = '01/08/2020'
						# to_date = datetime.datetime.strptime(to_date, "%d/%m/%Y")
						day_count = (to_date - from_date).days + 1
						print(day_count)
						for date in (to_date - datetime.timedelta(n) for n in range(day_count)):
							date = date.date()
							# date = datetime.date.today()
							print('date = ', date)
							no_of_drops = DriverJob.objects.filter(driver = driver_obj, created_at__contains = date, jobcompleted = True).count()
							print('no_of_drops = ', no_of_drops)
							driverjob_obj = DriverJob.objects.filter(driver = driver_obj, created_at__contains = date, jobcompleted = True)
							min_time = datetime.datetime.combine(date,datetime.datetime.now().time())
							max_time = datetime.datetime.combine(date, datetime.datetime.min.time())
							if driverjob_obj:
								serialno = 0
								print('in if')
								# print(driverjob_obj)
								utc = pytz.timezone(settings.TIME_ZONE)
								min_time = utc.localize(min_time)
								max_time = utc.localize(max_time)
								for driverjob in driverjob_obj:
									customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = driverjob.customerjob).first()
									if customerjobdatetime_obj:
										print(customerjobdatetime_obj.driver_pickuparrived_datetime)
										if customerjobdatetime_obj.driver_pickuparrived_datetime:
											if min_time > customerjobdatetime_obj.driver_pickuparrived_datetime:
												min_time = customerjobdatetime_obj.driver_pickuparrived_datetime
										if customerjobdatetime_obj.itemsdelivered_datetime:
											if max_time < customerjobdatetime_obj.itemsdelivered_datetime:
												max_time = customerjobdatetime_obj.itemsdelivered_datetime
								print('min_time = ', min_time)
								print('max_time = ', max_time)
								if min_time and max_time:
									tdelta = max_time - min_time
									seconds = tdelta.seconds
									total_minutes = (seconds / 60)
									print(total_minutes)
									# total_minutes = tdelta.total_minutes()
									print(driver_obj.vehicletype)
									priceperdrop = driver_obj.vehicletype.priceperdrop
									priceperhour = driver_obj.vehicletype.priceperhour
									print('priceperdrop = ', priceperdrop)
									print('priceperhour = ', priceperhour)
									total_price = str(round((no_of_drops * priceperdrop + ((total_minutes/60) * priceperhour)),2))
									print(total_price)
									serialno += 1
									paymenthistory_data.append({
										'serialno' : serialno,
										
										'no_of_drops' : no_of_drops,
										'priceperdrop' : priceperdrop,
										'priceperhour' : priceperhour,
										'min_time' : min_time,
										'max_time' : max_time,
										'date' : date,
										'total_hours' : str(round((total_minutes/60),2)),
										'total_price' : total_price,
										})
							else:
								print('else')
						pass
			print(paymenthistory_data)
			context['paymenthistory_data'] = paymenthistory_data
			# return JsonResponse({ 'status_code': 200 , 'data' : paymenthistory_data,'status_message' : 'success' })
			return context
		except Exception as e:
			print(e)
			# return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})



class DriverUpdateCoordinates(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\naa')
		print('data is  : ',request.POST)
		try:
			driverid_val = request.POST.get('driverid')
			latitude_val = request.POST.get('latitude')
			longitude_val = request.POST.get('longitude')
			if not driverid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
			if not latitude_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter latitude'})
			if not longitude_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Please enter longitude'})
			driver_obj = DriverModel.objects.filter(id = driverid_val).first()
			if driver_obj:
				drivercoordinates_obj = DriverCoordinates.objects.filter(driver = driver_obj).first()
				if drivercoordinates_obj:
					drivercoordinates_obj.latitude = latitude_val
					drivercoordinates_obj.longitude = longitude_val
					drivercoordinates_obj.save()
				else:
					DriverCoordinates.objects.create(user_id = driver_obj.user.id, driver = driver_obj, latitude = latitude_val, longitude = longitude_val)
				
				return JsonResponse({'status_code': 200, 'status_message': 'success',})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'User not logged in'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message' : 'Internal Server Error'})





class DriverSendMessageToAdmin(APIView):
	
	def post(self, request, *args, **kwargs):
		print('\n\n\n\n')
		print('Chat  - in post ')
		print('data is  : ',request.POST)
		try:
			sender = request.POST.get('sender')
			driver_id = request.POST.get('driver_id')
			# admin_id = request.POST.get('admin_id')
			message = request.POST.get('message')
			messageexist = request.POST.get('messageexist')
			attachmentexist = request.POST.get('attachmentexist')
			if messageexist == 'yes':
				message = request.POST.get('message')
			if attachmentexist == 'yes':
				attachment = request.FILES['file']
				if attachment:
					print('attachment exists')
				else:
					print('no attachment')
			if driver_id == '':
				print('driver_id does not exist')
			
			if message == '':
				print('message does not exist')
			if sender == '':
				print('sender does not exist')
			admin_id = 1
			if driver_id and admin_id  and sender:
				if messageexist == 'yes':
					chat_obj = Chat.objects.create(driver_id=driver_id,admin_id=admin_id,message=message,sender=sender)
					if chat_obj:
						print('message saved in database')
				if attachmentexist == 'yes':
					st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(8)])
					print(st)
					fs = FileSystemStorage()
					filename = fs.save(attachment.name, attachment)
					filename = fs.url(filename)
					filename = '/media/' + filename 
					print(filename)
					chat_obj = Chat.objects.create(driver_id=driver_id,admin_id=admin_id,files=filename,sender=sender)
					if chat_obj:
						print('attachment saved in database')
			if attachmentexist == 'yes':
				attachment = str(settings.WEB_BASE_URL) + filename
			else:
				attachment = ''
			if messageexist == 'no':
				message = ''
					
			return JsonResponse({'status_code': 200, 'status_message': 'notification read', 'messageexist' : messageexist, 'message' :message, 'attachmentexist' : attachmentexist, 'attachment' : attachment, 'time' : chat_obj.created_at.strftime("%d/%m/%Y %I:%M %p") })		
			# return JsonResponse({'status_code': 200, 'status_message': 'success',})
			# return JsonResponse({'code': 400, 'message': 'Bad Request',})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal Server Error',})
	

class DriverChatTest(TemplateView):
	template_name = 'driver_chat_test.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on profile screen'''
		context = super(DriverChatTest, self).get_context_data(**kwargs)
		print("DriverChatTest - in get ")
		final_list=[]
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			print('0')
			if user_obj:
				print('1')
				driver_obj = DriverModel.objects.filter(user = user_obj).first()
				if driver_obj:
					context['driverid'] = driver_obj.id
					all_chats=Chat.objects.filter(driver_id = driver_obj.id)
					for i in all_chats:

						dic={}
						if i.files:
							attachment = str(settings.WEB_BASE_URL) + i.files.name
						else:
							attachment = ''
						sender=i.sender
						message=i.message
						
						time=i.created_at.strftime("%d/%m/%Y %I:%M %p")
						dic['sender']=sender
						dic['message']=message
						dic['attachment']=attachment
						dic['time']=time
						final_list.append(dic)
					# print(final_list)
			context['all_chats'] = final_list

		return context	




class DriverChat(TemplateView):
	template_name = 'driver_chat.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on profile screen'''
		context = super(DriverChat, self).get_context_data(**kwargs)
		print("DriverProfile - in get ")
		final_list=[]
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			print('0')
			if user_obj:
				print('1')
				driver_obj = DriverModel.objects.filter(user = user_obj).first()
				if driver_obj:
					context['driverid'] = driver_obj.id
					all_chats=Chat.objects.filter(driver_id = driver_obj.id)
					for i in all_chats:

						dic={}
						if i.files:
							attachment = str(settings.WEB_BASE_URL) + i.files.name
						else:
							attachment = ''
						sender=i.sender
						message=i.message
						
						time=i.created_at.strftime("%d/%m/%Y %I:%M %p")
						dic['sender']=sender
						dic['message']=message
						dic['attachment']=attachment
						dic['time']=time
						final_list.append(dic)
					# print(final_list)
			context['all_chats'] = final_list

		return context	





class CheckDriverProfileCompleted(APIView):
	# permission_classes = (AllowAny,)
	def post(self, request, *args, **kwargs):
		print('\n\n')
		print('CheckDriverProfileCompleted API - in post')
		print('data is  : ',request.POST)
		try:
			data = []
			profile = False
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
				user_obj = User.objects.filter(email = email_val).first()
				print('0')
				if user_obj:
					print('1')
					driver_obj = DriverModel.objects.filter(user = user_obj).prefetch_related('user').first()
					if driver_obj:
						if driver_obj.name and driver_obj.email and driver_obj.phone and driver_obj.vehicletype and driver_obj.vehiclenumber:
							profile = True
				data.append({'profile': profile})
				print('\n\n')
				print(profile)
				return HttpResponse(json.dumps(data))
			else:
				return HttpResponse(json.dumps(data))
		except Exception as e:
			print(e)
			# return HttpResponse(str(e))
			data.append({'profile': profile})
			return HttpResponse(json.dumps(data))


# @method_decorator(checklogincustomer, name='dispatch')
class DriverProfileUpdate(View):
	def post(self, request):
		'''This function shows the content on profile screen'''
		print("DriverProfileUpdate - in post ")
		try:	
			def getI420FromBase64(codec, id_val, image_path="c:\\"):
				print(id_val)
				print('\n\n')
				# print(codec)
				print('0')
				base64_data = codec.split(";base64,")
				print('1')
				extens = base64_data[0]
				print('2')
				ext = extens.split("/")
				print('3')
				print(ext)
				extension = str(ext[1])
				print('4')
				base64_data = base64_data[1]
				print('5')
				byte_data = base64.b64decode(base64_data)
				print('6')
				image_data = BytesIO(byte_data)
				print('7')
				from PIL import Image
				import string, random, os
				print('8')
				img = Image.open(image_data)
				print('9')
				driver_obj = DriverModel.objects.get(id=id_val)
				st = ''.join([random.choice(string.ascii_letters + string.digits) for n in range(6)])
				thumbnailsize_objs = ThumbnailSize.objects.all()
				filepath = str(settings.BASE_DIR)+'/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)
				print('10')
				if(os.path.exists(filepath)):
					print('11')
					filesToRemove = [os.path.join(filepath,f) for f in os.listdir(filepath)]
					for f in filesToRemove:
						os.remove(f) 
				else:
					print('12')
					os.makedirs(filepath)
				print('13')
				for obj in thumbnailsize_objs:
					img = Image.open(image_data)
					im = img.thumbnail([int(obj.height),int(obj.width)], Image.ANTIALIAS)
					im = img.save(filepath+'/'+str(obj.height)+'*'+str(obj.width)+'-'+st+'.'+extension)								
				img = Image.open(image_data)	
				print('14')
				img.save(filepath+'/original-'+st+'.'+extension)	
				print('15')
				filename = '/media/Users/Drivers/'+str(driver_obj.id)+'_'+str(driver_obj.user.email)+'/original-'+st+'.'+extension
				driver_obj.image = filename
				driver_obj.save()
				return('1')


			# print(request.POST)
			if self.request.session.has_key('email'):
				email_val = self.request.session['email']
			if self.request.session.has_key('userrole'):
				userrole_val = self.request.session['userrole']
			
			driverid_val = self.request.POST.get('driverid')
			name_val = self.request.POST.get('name')
			email_val = self.request.POST.get('email')
			phone_val = self.request.POST.get('phone')
			# vehicletype_val = self.request.POST.get('vehicletype')
			# vehiclenumber_val = self.request.POST.get('vehiclenumber')
			
			address = self.request.POST.get('address')
			city = self.request.POST.get('city')
			postalcode = self.request.POST.get('postalcode')
			country = self.request.POST.get('country')
			national_insurance_number = self.request.POST.get('national_insurance_number')
			driving_license_number = self.request.POST.get('driving_license_number')

			image_val = self.request.POST.get('image')

			if not driverid_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Driver Id is required'})
			if not name_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Name is required'})
			if not email_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Email Address is required'})
			if not phone_val:
				return JsonResponse({'status_code': 400, 'status_message': 'Phone is required'})
			if not address:
				return JsonResponse({'status_code': 400, 'status_message': 'address is required'})
			if not city:
				return JsonResponse({'status_code': 400, 'status_message': 'city is required'})
			if not postalcode:
				return JsonResponse({'status_code': 400, 'status_message': 'postalcode is required'})
			if not country:
				return JsonResponse({'status_code': 400, 'status_message': 'country is required'})
			if not national_insurance_number:
				return JsonResponse({'status_code': 400, 'status_message': 'national_insurance_number is required'})
			if not driving_license_number:
				return JsonResponse({'status_code': 400, 'status_message': 'driving_license_number is required'})
			
			
			driver_obj = DriverModel.objects.filter(id = driverid_val).first()
			if driver_obj:
				driver_obj.name = name_val
				driver_obj.email = email_val
				driver_obj.phone = phone_val
				driver_obj.address = address
				driver_obj.city = city
				driver_obj.postalcode = postalcode
				driver_obj.country = country
				driver_obj.national_insurance_number = national_insurance_number
				driver_obj.driving_license_number = driving_license_number
				# vehicletype_obj = VehicleType.objects.filter(id = vehicletype_val).first()
				# driver_obj.vehicletype = vehicletype_obj
				driver_obj.save()
				if image_val:
					codec = image_val
					res = getI420FromBase64(codec,id_val = driver_obj.id)
					print(res)
				return JsonResponse({'status_code': 200, 'status_message': 'Profile updated successfully'})
			else:
				return JsonResponse({'status_code': 400, 'status_message': 'You are not allowed to change details'})
		except Exception as e:
			print(e)
			return JsonResponse({'status_code': 500, 'status_message': 'Internal server error.'})
	


# @method_decorator(checklogincustomer, name='dispatch')
class DriverProfile(TemplateView):
	template_name = 'driver_profile.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on profile screen'''
		context = super(DriverProfile, self).get_context_data(**kwargs)
		print("DriverProfile - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
		user_obj = User.objects.filter(email = email_val).first()
		print('0')
		if user_obj:
			print('1')
			driver_obj = DriverModel.objects.filter(user = user_obj).prefetch_related('user').first()
			if driver_obj:
				print('2')
				driver_data = []
				try:
					from django.db.models import Avg
					rating_driver = UserRating.objects.filter(ratingfor = 'driver', driverid = driver_obj.id).aggregate(Avg('rating'))
					print(rating_driver)
					print(rating_driver['rating__avg'])
					if not rating_driver['rating__avg']:
						ratings = 0.0
					else:	
						ratings = rating_driver['rating__avg']
				except Exception as e:
					print(e)
					ratings = 0.0
				if not driver_obj.vehicletype:
					vehicletypeid = ''
				else:
					vehicletypeid = driver_obj.vehicletype.id
				
				if not driver_obj.address:
					address = ''
				else:
					address = driver_obj.address
				driver_data.append({
					'name' : driver_obj.name,
					'ratings' : ratings,
					'email' : driver_obj.email,
					'phone' : driver_obj.phone,
					'image' : driver_obj.image.name,
					'vehicletype' : vehicletypeid,
					'address' : address,
					'city' : driver_obj.city,
					'postalcode' : driver_obj.postalcode,
					'country' : driver_obj.country,
					'national_insurance_number' : driver_obj.national_insurance_number,
					'driving_license_number' : driver_obj.driving_license_number,
					'id' : driver_obj.id,
					})
				context['user'] = driver_data
				# print(driver_data)
		vehicletype_obj = VehicleType.objects.filter(isdeleted = False)
		context['allvehicletypes'] = vehicletype_obj
		context['profile_section'] = 'yes'
		return context	















class CustomerJobDetail(TemplateView):
	template_name = 'driverSideCustomerDetails.html'
	def post(self, request, *args, **kwargs):
		pass
		# print("AboutUs-in post ")
	
	def get_context_data(self,**kwargs):
		context = super(CustomerJobDetail, self).get_context_data(**kwargs)
		print('Driver - CustomerJobDetail - get')
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			data = {}
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = DriverModel.objects.filter(user = user_obj).first()
				if customer_obj:
					customerjobid = kwargs['customerjobid']
					print(customerjobid)
					driverjob_obj = DriverJob.objects.filter(customerjob_id = customerjobid).first()
					if driverjob_obj:

						if not driverjob_obj.customerjob.sendercountrycode:
							sendercountrycode = ''
						else:
							sendercountrycode = driverjob_obj.customerjob.sendercountrycode

						if not driverjob_obj.customerjob.recipientcountrycode:
							recipientcountrycode = ''
						else:
							recipientcountrycode = driverjob_obj.customerjob.recipientcountrycode
						if not driverjob_obj.customerjob.qrcode:
							qrcode = ''
						else:
							qrcode = str(settings.MEDIA_BASE_URL) + driverjob_obj.customerjob.qrcode.name
						# print(qrcode)
						if not driverjob_obj.customerjob.image:
							parcelimage = str(settings.MEDIA_BASE_URL) + '/static/images/open-parcel-1.png'
						else:
							parcelimage = str(settings.MEDIA_BASE_URL) + driverjob_obj.customerjob.image.name

						driverexist = False
						driverjob_data = {}
						
						driverjob_data.update({
							'drivername' : driverjob_obj.driver.name,
							'drivercountrycode' : driverjob_obj.driver.countrycode,
							'driverphone' : driverjob_obj.driver.phone,
							'driverid' : driverjob_obj.driver.id,
							'driverjobid' : driverjob_obj.id,
							})
						driverexist = True	
						data.update({
							'id' : driverjob_obj.customerjob.id,
							'sendername' : driverjob_obj.customerjob.sendername,
							'senderemail' : driverjob_obj.customerjob.customer.user.email,
							'senderphone' : driverjob_obj.customerjob.senderphone,
							'sendercity' : driverjob_obj.customerjob.sendercity,
							'senderpickupaddress' : driverjob_obj.customerjob.pickupaddress,
							'pickuptimeslot' : driverjob_obj.customerjob.pickuptimeslot,
							'recipientname' : driverjob_obj.customerjob.recipientname,
							'recipientphone' : driverjob_obj.customerjob.recipientphone,
							'recipientdropoffaddress' : driverjob_obj.customerjob.dropoffaddress,
							'dropofftimeslot' : driverjob_obj.customerjob.dropofftimeslot,
							'length' : driverjob_obj.customerjob.length,
							'weight' : driverjob_obj.customerjob.weight,
							'height' : driverjob_obj.customerjob.height,
							'width' : driverjob_obj.customerjob.width,
							'parceltype' : driverjob_obj.customerjob.parceltype,
							'image' : driverjob_obj.customerjob.image,
							'vehicletype' : driverjob_obj.customerjob.vehicletype.name,
							'price' : driverjob_obj.customerjob.price,
							
							'parcelimage' : parcelimage,
							'parcelpdf_link' : '',
							'qrcode' : qrcode,
							'customerjobid' : driverjob_obj.customerjob.id,
							'awbnumber' : 'AWB-' + str(10000 + driverjob_obj.customerjob.id),
							'driverexist' : driverexist,
							'driverdetails' : driverjob_data,
							})
						print(data)
						context['customerjob'] = data
						# print(context['customerjob'])
		return context


class CustomerJobDetail2(TemplateView):
	template_name = 'driverSideCustomerDetails.html'
	def post(self, request, *args, **kwargs):
		pass
		# print("AboutUs-in post ")
	
	def get_context_data(self,**kwargs):
		context = super(CustomerJobDetail2, self).get_context_data(**kwargs)
		print('Driver - CustomerJobDetail2 - get')
		if self.request.session.has_key('email'):
			emailid = self.request.session['email']
			data = {}
			user_obj = User.objects.filter(email = emailid).first()
			if user_obj:
				customer_obj = DriverModel.objects.filter(user = user_obj).first()
				if customer_obj:
					allData=[]
					customerjobid = kwargs['customerjobid']
					print(customerjobid)
					customerjob_objall=CustomerJob.objects.filter(sameIdForParcelsDetails = customerjobid)
					if customerjob_objall:
						for customerjob_obj in customerjob_objall:
							data = {}
							if not customerjob_obj.sendercountrycode:
								sendercountrycode = ''
							else:
								sendercountrycode = customerjob_obj.sendercountrycode

							if not customerjob_obj.recipientcountrycode:
								recipientcountrycode = ''
							else:
								recipientcountrycode = customerjob_obj.recipientcountrycode
							if not customerjob_obj.qrcode:
								qrcode = ''
							else:
								qrcode = str(settings.MEDIA_BASE_URL) + customerjob_obj.qrcode.name
							if customerjob_obj.parcelpdf:
								parcelpdf_link = str(settings.WEB_BASE_URL) + customerjob_obj.parcelpdf.name
							else:
								parcelpdf_link = ''
							parcelimage = ''
							if customerjob_obj.image:
								parcelimage = str(settings.MEDIA_BASE_URL) + customerjob_obj.image.name
								
							totalamount = customerjob_obj.price + customerjob_obj.specialbooking_charge
							customerjobdatetime_obj = CustomerJobDateTime.objects.filter(job = customerjob_obj).first()
							payment_datetime, pickup_datetime, itemsdelivered_datetime, deliveryfailed_datetime = '', '', '', ''
							if customerjobdatetime_obj:
								payment_datetime = customerjobdatetime_obj.payment_datetime
								pickup_datetime = customerjobdatetime_obj.pickup_datetime
								itemsdelivered_datetime = customerjobdatetime_obj.itemsdelivered_datetime
								deliveryfailed_datetime = customerjobdatetime_obj.deliveryfailed_datetime

							delivery_proof_method, delivery_toperson_name, delivery_toperson_phone, delivery_toperson_signature = '', '', '', ''
							pickup_proof_method, pickup_fromperson_name, pickup_fromperson_phone, pickup_fromperson_signature = '', '', '', ''
							customerjobdeliveryextradetails_obj = CustomerJobDeliveryExtraDetails.objects.filter(job = customerjob_obj).first()
							if customerjobdeliveryextradetails_obj:
								if customerjobdeliveryextradetails_obj.delivery_proof_method == 'signature':
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
									delivery_toperson_name = customerjobdeliveryextradetails_obj.delivery_toperson_name
									delivery_toperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.delivery_toperson_signature.name
								elif customerjobdeliveryextradetails_obj.delivery_proof_method == 'otp':
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method
									delivery_toperson_name = customerjob_obj.recipientname
									delivery_toperson_phone = customerjob_obj.recipientcountrycode + '-' + customerjob_obj.recipientphone
								else:
									delivery_proof_method = customerjobdeliveryextradetails_obj.delivery_proof_method

								
								if customerjobdeliveryextradetails_obj.pickup_proof_method == 'signature':
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
									pickup_fromperson_signature = str(settings.MEDIA_BASE_URL) + customerjobdeliveryextradetails_obj.pickup_fromperson_signature.name
								elif customerjobdeliveryextradetails_obj.pickup_proof_method == 'otp':
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjob_obj.sendername
									pickup_fromperson_phone = customerjob_obj.sendercountrycode + '-' + customerjob_obj.senderphone
								else:
									pickup_proof_method = customerjobdeliveryextradetails_obj.pickup_proof_method
									pickup_fromperson_name = customerjobdeliveryextradetails_obj.pickup_fromperson_name
							
							driverexist = False
							driverjob_data = {}
							driverjob_obj = DriverJob.objects.filter(customerjob = customerjob_obj).first()
							if driverjob_obj:
								driverjob_data.update({
									'drivername' : driverjob_obj.driver.name,
									'drivercountrycode' : driverjob_obj.driver.countrycode,
									'driverphone' : driverjob_obj.driver.phone,
									'driverid' : driverjob_obj.driver.id,
									'driverjobid' : driverjob_obj.id,
									})
								driverexist = True	
							data.update({
								'id' : customerjob_obj.id,
								'sendername' : customerjob_obj.sendername,
								'senderemail' : customerjob_obj.customer.user.email,
								'sendercountrycode' : sendercountrycode,
								'senderphone' : customerjob_obj.senderphone,
								'sendercity' : customerjob_obj.sendercity,
								'senderpickupaddress' : customerjob_obj.pickupaddress,
								'pickuptimeslot' : customerjob_obj.pickuptimeslot,
								'recipientname' : customerjob_obj.recipientname,
								'recipientcountrycode' : recipientcountrycode,
								'recipientphone' : customerjob_obj.recipientphone,
								'recipientdropoffaddress' : customerjob_obj.dropoffaddress,
								'dropofftimeslot' : customerjob_obj.dropofftimeslot,
								'length' : customerjob_obj.length,
								'weight' : customerjob_obj.weight,
								'height' : customerjob_obj.height,
								'width' : customerjob_obj.width,
								'parceltype' : customerjob_obj.parceltype,
								'image' : customerjob_obj.image,
								'vehicletype' : customerjob_obj.vehicletype.name,
								'price' : customerjob_obj.price,
								'specialbooking_charge' : customerjob_obj.specialbooking_charge,
								'totalamount' : totalamount,
								'parcelimage' : parcelimage,
								'parcelpdf_link' : parcelpdf_link,
								'qrcode' : qrcode,
								'customerjobid' : customerjob_obj.id,
								'awbnumber' : 'AWB-' + str(10000 + customerjob_obj.id),
								'driverexist' : driverexist,
								'driverdetails' : driverjob_data,

								'delivery_proof_method' : delivery_proof_method,
								'delivery_toperson_name' : delivery_toperson_name,
								'delivery_toperson_phone' : delivery_toperson_phone,
								'delivery_toperson_signature' : delivery_toperson_signature,
								
								'pickup_proof_method' : pickup_proof_method,
								'pickup_fromperson_name' : pickup_fromperson_name,
								'pickup_fromperson_phone' : pickup_fromperson_phone,
								'pickup_fromperson_signature' : pickup_fromperson_signature,
								'pickupspecialnote':customerjob_obj.pickupspecialnote,
								'dropoffspecialnote':customerjob_obj.dropoffspecialnote,
								'pickup_datetime' : pickup_datetime,
								'itemsdelivered_datetime' : itemsdelivered_datetime,
								'payment_datetime' : payment_datetime,
								})
							allData.append(data)
		
						context['customerjoball'] = allData
						print(context['customerjoball'])
		return context


# @method_decorator(checklogincustomer, name='dispatch')
class DriverNotifications(TemplateView):
	template_name = 'driver_notifications.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on customer dashboard screen'''
		context = super(DriverNotifications, self).get_context_data(**kwargs)
		print("DriverNotifications - in get ")
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				notifications_data = []
				all_notifications = Notifications.objects.filter(user = user_obj).order_by('-id')
				if all_notifications:
					serialno = 0
					for notification in all_notifications:
						serialno += 1
						jobtype = ''
						if notification.notificationtype == 'Parcel Pickup Request':
							jobtype = 'Pickup Request'
						notifications_data.append({
							'serialno' : serialno,
							'id' : notification.id,
							'fordriver' : notification.fordriver,
							'notificationtype' : notification.notificationtype,
							'jobtype' : jobtype,
							'notificationtext' : notification.notificationtext,
							'status' : notification.status,
							'customerjobid' : notification.customerjobid,
							'date' : notification.date,
							'deleted' : notification.deleted,
							})
					paginator = Paginator(notifications_data, 15)
					page = int(self.request.GET.get('page',1))
					print('page = ', page)
					try:
						notifications_data = paginator.page(page)
						print(len(notifications_data))
						print('try')
					except PageNotAnInteger:
						notifications_data = paginator.page(paginator.num_pages)
						print("except1")
					except EmptyPage:
						notifications_data = paginator.page(paginator.num_pages)
						print("except2")

					context['all_notifications'] = notifications_data
					context['userrole'] = 'driver'
				Notifications.objects.filter(user = user_obj).update(status = 'read')	
		return context	



# @method_decorator(checklogincustomer, name='dispatch')
class MyJobs(TemplateView):
	template_name = 'driver_myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(MyJobs, self).get_context_data(**kwargs)
		print("MyJobs - in get ")
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				driver_obj = DriverModel.objects.filter(user = user_obj).first()
				if driver_obj:
					driverjobs_obj = DriverJob.objects.filter(driver = driver_obj)
					for driverjob in driverjobs_obj:
						if driverjob.jobstarted or driverjob.jobcompleted: 
							if driverjob.jobcompleted:
								status = 'Completed'
							elif driverjob.jobstarted:
								status = 'Picked Up'
						else:
							status = 'Assigned'
						data.append({
							'sendername' : driverjob.customerjob,
							'name' : driverjob.driver.user.first_name,
							'senderphone' : driverjob.customerjob.senderphone,
							'pickupaddress' : driverjob.customerjob.pickupaddress,
							'status' : status,
							'id' : driverjob.id,
							})
					context['all_driverjobs'] = data
					context['header_title'] = 'My Jobs'
		context['myjobs_section'] = 'yes'
		return context	


class DriverOutstandingRequests(TemplateView):
	template_name = 'driver_myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(DriverOutstandingRequests, self).get_context_data(**kwargs)
		print("DriverOutstandingRequests - in get ")
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				driver_obj = DriverModel.objects.filter(user = user_obj).first()
				if driver_obj:
					driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False)
					for driverjob in driverjobs_obj:
						if driverjob.jobstarted or driverjob.jobcompleted: 
							if driverjob.jobcompleted:
								status = 'Completed'
							elif driverjob.jobstarted:
								status = 'Picked Up'
						else:
							status = 'Assigned'
						if status == 'Picked Up' or status == 'Assigned':
							data.append({
								'sendername' : driverjob.customerjob.sendername,
								'senderemail' : driverjob.customerjob.senderemail,
								'senderphone' : driverjob.customerjob.senderphone,
								'senderpickupaddress' : driverjob.customerjob.pickupaddress,
								'recipientname' : driverjob.customerjob.recipientname,
								'recipientdropoffaddress' : driverjob.customerjob.dropoffaddress,
								'customerjobid' : driverjob.customerjob.id,
								'status' : status,
								'id' : driverjob.id,
								})
						# print(data)
					context['all_driverjobs'] = data
					context['header_title'] = 'Outstanding Requests'
		context['myjobs_section'] = 'yes'
		return context

class DriverOutstandingRequests2(TemplateView):
	template_name = 'driver_myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(DriverOutstandingRequests2, self).get_context_data(**kwargs)
		print("DriverOutstandingRequests2 - in get ")
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				driver_obj = DriverModel.objects.filter(user = user_obj).first()
				if driver_obj:
					driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False)
					print('1')
					supportdetail_obj = SupportDetail.objects.filter(isdeleted = False).first()
					if supportdetail_obj:
						support_phone = supportdetail_obj.phone
					else:
						support_phone = ''
					driverjob_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False,deliveryfailed=False)
					if driverjob_obj:
						print('2')
						print(len(driverjob_obj))
						same_customer_list=[]
						first_time_get_customer=[]
						first_time_get_customer2=[]
						unique=[]
						outstandingdriverjobs_data=[]
						# all_customers=[]
						print("here is my unique ids",unique)
						parcel_data = []
						for job in driverjob_obj:
							if job.sameIdForParcels not in unique:
								if job.sameIdForParcels !=0:
									unique.append(job.sameIdForParcels)
								driverJobStatusId='0'
								status = 'Driver have not yet Started Job'
								if job.jobstarted == True and job.arrived_at_pickup == False:
									status = 'Driver Started Job'
									driverJobStatusId='1'
								elif job.arrived_at_pickup == True and job.parcel_picked_by_driver == False:
									status = 'Driver Arrived,Waiting For Pickup'
									driverJobStatusId='2'
								elif job.parcel_picked_by_driver == True and job.start_DropOff == False:
									status = 'Parcel Picked-Up'
									driverJobStatusId='3'
								elif job.start_DropOff == True and job.arrived_atDropOffLocation == False:
									status = 'Driver Start Job off for delivery'
									driverJobStatusId='4'
								elif job.arrived_atDropOffLocation == True and job.jobcompleted == False:
									status = 'Arrived At Drop Off Location'
									driverJobStatusId='5'
								elif job.parcel_picked_by_driver == True and job.jobcompleted == True:
									status = 'Delivered'
									driverJobStatusId='6'

								if job.customerjob.order.ordertype == 1:
									ordertype = 'Single-Drop'
								elif job.customerjob.order.ordertype == 2:
									ordertype = 'Multi-Drop'

								if status != 'Delivered':
									data.append({
										'sendername' : job.customerjob.sendername,
										'senderemail' : job.customerjob.senderemail,
										'senderphone' : job.customerjob.senderphone,
										'senderpickupaddress' : job.customerjob.pickupaddress,
										'recipientname' : job.customerjob.recipientname,
										'recipientdropoffaddress' : job.customerjob.dropoffaddress,
										'customerjobid' : job.customerjob.sameIdForParcelsDetails,
										'status' : status,
										'id' : job.id,
										})
					context['all_driverjobs'] = data
					context['header_title'] = 'Outstanding Requests'
		context['myjobs_section'] = 'yes'
		return context			

class DriverCompletedRequests(TemplateView):
	template_name = 'driver_myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(DriverCompletedRequests, self).get_context_data(**kwargs)
		print("DriverCompletedRequests - in get ")
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				driver_obj = DriverModel.objects.filter(user = user_obj).first()
				if driver_obj:
					driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = True)
					for driverjob in driverjobs_obj:
						if driverjob.jobstarted or driverjob.jobcompleted: 
							if driverjob.jobcompleted:
								status = 'Completed'
							elif driverjob.jobstarted:
								status = 'Picked Up'
						else:
							status = 'Assigned'
						if status == 'Completed':
							data.append({
								'sendername' : driverjob.customerjob.sendername,
								'senderemail' : driverjob.customerjob.senderemail,
								'senderphone' : driverjob.customerjob.senderphone,
								'senderpickupaddress' : driverjob.customerjob.pickupaddress,
								'recipientname' : driverjob.customerjob.recipientname,
								'recipientdropoffaddress' : driverjob.customerjob.dropoffaddress,
								'customerjobid' : driverjob.customerjob.id,
								'status' : status,
								'id' : driverjob.id,
								})
					context['all_driverjobs'] = data
					context['header_title'] = 'Completed Requests'
		context['myjobs_section'] = 'yes'
		return context


class DriverCompletedRequests2(TemplateView):
	template_name = 'driver_myjobs.html'

	def get_context_data(self,**kwargs):
		'''This function shows the content on all customer jobs by user'''
		context = super(DriverCompletedRequests2, self).get_context_data(**kwargs)
		print("DriverCompletedRequests2 - in get ")
		data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				unique=[]
				driver_obj = DriverModel.objects.filter(user = user_obj).first()
				if driver_obj:
					driverjobs_obj = DriverJob.objects.filter(driver = driver_obj, jobcompleted = True)
					for driverjob in driverjobs_obj:
						if driverjob.sameIdForParcels not in unique:
							if driverjob.sameIdForParcels !=0:
								unique.append(driverjob.sameIdForParcels)
							status = 'Driver have not yet Started Job'
							if driverjob.jobstarted == True and driverjob.arrived_at_pickup == False:
								status = 'Driver Started Job'
								driverJobStatusId='1'
							elif driverjob.arrived_at_pickup == True and driverjob.parcel_picked_by_driver == False:
								status = 'Driver Arrived,Waiting For Pickup'
								driverJobStatusId='2'
							elif driverjob.parcel_picked_by_driver == True and driverjob.start_DropOff == False:
								status = 'Parcel Picked-Up'
								driverJobStatusId='3'
							elif driverjob.start_DropOff == True and driverjob.arrived_atDropOffLocation == False:
								status = 'Driver Start Job off for delivery'
								driverJobStatusId='4'
							elif driverjob.arrived_atDropOffLocation == True and driverjob.jobcompleted == False:
								status = 'Arrived At Drop Off Location'
								driverJobStatusId='5'
							elif driverjob.parcel_picked_by_driver == True and driverjob.jobcompleted == True:
								status = 'Delivered'
								driverJobStatusId='6'
							if status == 'Delivered':
								data.append({
									'sendername' : driverjob.customerjob.sendername,
									'senderemail' : driverjob.customerjob.senderemail,
									'senderphone' : driverjob.customerjob.senderphone,
									'senderpickupaddress' : driverjob.customerjob.pickupaddress,
									'recipientname' : driverjob.customerjob.recipientname,
									'recipientdropoffaddress' : driverjob.customerjob.dropoffaddress,
									'customerjobid' : driverjob.customerjob.sameIdForParcelsDetails,
									'status' : status,
									'id' : driverjob.id,
									})
					context['all_driverjobs'] = data
					context['header_title'] = 'Completed Requests'
		context['myjobs_section'] = 'yes'
		return context			




class Login(APIView):
	'''This class is used for login process for driver users'''
	
	def post(self, request, *args, **kwargs):
		try:
			print('DeliveryLogin Web - in post')
			email_val = request.POST.get('email')
			if not email_val:
				return JsonResponse({'status_code' : 200, 'status_message' : 'Email address is required'})
			password_val = request.POST.get('password')
			if not password_val:
				return JsonResponse({'status_code' : 200, 'status_message' : 'Password is required'})
			user = authenticate(username = email_val, password = password_val)  
			if user is not None:
				print('1')
				driver_obj = DriverModel.objects.filter(user = user).first()
				if driver_obj:
					print('2')
					if driver_obj.emailverified == False:
						return JsonResponse({'status_code' : 111, 'status_message' : 'Please verify your email first.'})
					elif driver_obj.isdisabled:
						return JsonResponse({'status_code' : 100, 'status_message' : 'User is disabled by Admin.'})
					else:
						token, status = Token.objects.get_or_create(user = user)
						request.session['email'] = request.POST.get('email')
						request.session['userrole'] = 'driver'
						request.session['driverid'] = driver_obj.id
						return JsonResponse({'status_code': 200, 'user' : 'driver', 'token' : token.key, 'status_message' : 'driver login successfull'})
				return JsonResponse({'status_code': 0, 'status_message' : 'Invalid Credentials.'})
			else:
				return JsonResponse({'status_code': 0, 'status_message' : 'Invalid Credentials.'})
		except Exception as error:
			print('error is',error)
			return JsonResponse({'status_code': 0, 'status_message' : 'Exception occurred : ' + str(error)})

@method_decorator(checklogindriver, name='dispatch')
class Dashboard(TemplateView):
	'''This class is used to show the content on driver dashboard screen'''
	template_name = 'driver_dashboard.html'

	def get_context_data(self,**kwargs):
		context = super(Dashboard, self).get_context_data(**kwargs)
		print("DriverDashboard - in get ")
		recent_driverjobs_data = []
		if self.request.session.has_key('email'):
			email_val = self.request.session['email']
			user_obj = User.objects.filter(email = email_val).first()
			if user_obj:
				driver_obj = DriverModel.objects.filter(user = user_obj).prefetch_related('user').first()
				if driver_obj:
					context['user'] = driver_obj
					context['userrole'] = 'driver'
					recent_driverjobs = DriverJob.objects.filter(driver = driver_obj).order_by('-id')[:5]
					if recent_driverjobs:
						for job in recent_driverjobs:
							if not job.customerjob.image:
								parcelimage = str(settings.MEDIA_BASE_URL) + '/static/images/open-parcel-1.png'
							else:
								parcelimage = str(settings.MEDIA_BASE_URL) + job.customerjob.image.name
							recent_driverjobs_data.append({
								'sendername' : job.customerjob.sendername,
								'recipientname' : job.customerjob.recipientname,
								'pickupaddress' : job.customerjob.pickupaddress,
								'dropoffaddress' : job.customerjob.dropoffaddress,
								'parcelimage' : parcelimage,
								'customerjobid' : job.customerjob.id,
								})

		# context['user'] = 'Customer'
		context['recent_driverjobs'] = recent_driverjobs_data
		totaljobs = DriverJob.objects.filter(driver = driver_obj).count()
		totalpendingjobs = DriverJob.objects.filter(driver = driver_obj, jobcompleted = False).count()
		totalearnings = 0 
		context['totaljobs'] = totaljobs
		context['totalpendingjobs'] = totalpendingjobs
		context['totalearnings'] = totalearnings
		# context['user'] = 'Customer'
		# context['user'] = 'Company'
		# all_drivers = DriverModel.objects.all()
		# context['all_drivers'] = all_drivers
		return context