# from channels.routing import route
# from AdminApp.consumers import ws_connect, ws_disconnect


# channel_routing = [
#     route('websocket.connect', ws_connect),
#     route('websocket.disconnect', ws_disconnect),
# ]


# from channels.routing import ProtocolTypeRouter

# application = ProtocolTypeRouter({
#     # Empty for now (http->django views is added by default)
# })



from django.conf.urls import url

from channels.routing import ProtocolTypeRouter, URLRouter
from channels.auth import AuthMiddlewareStack
from channels.security.websocket import AllowedHostsOriginValidator
from AdminApp.consumers import AdminChatConsumer, DriverUpdateCoordinates, DriverGetChats, ChatConsumer, DriverCoordinatesConsumer,DriverCoordinatesCustomerEndConsumer
# from aprs_news.consumers import APRSNewsConsumer

application = ProtocolTypeRouter({

    # WebSocket chat handler
    "websocket": AllowedHostsOriginValidator(
        AuthMiddlewareStack(
            URLRouter([
                url(r"^chat/admin/$", AdminChatConsumer),
                url(r"^api/driver/(?P<driverid>\d+)/updatecoordinates/$", DriverUpdateCoordinates),
                url(r"^api/driver/(?P<driverid>\d+)/getchats/$", DriverGetChats),
                url(r"^api/chats/(?P<userrole>\w+)/(?P<userid>\d+)/$", ChatConsumer),
                url(r"^api/driver/coordinates/(?P<userrole>\w+)/(?P<userid>\d+)/$", DriverCoordinatesConsumer),
                url(r"^api/driver/getcoordinates/(?P<driverid>\d+)/$", DriverCoordinatesCustomerEndConsumer),
            ])
        )
    )

    # Using the third-party project frequensgi, which provides an APRS protocol
    # "aprs": APRSNewsConsumer,

})



