"""GoodsDelivery URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from django.conf.urls import url, include
from django.views.static import serve
from django.conf import settings
from django.conf.urls import handler400, handler403, handler404, handler500

handler404 = 'AdminApp.views.handler404'
handler500 = "AdminApp.views.handler500"

urlpatterns = [
    path('siteadmin/', admin.site.urls),
    path('api/customer/', include('API_Customer.urls')),
    path('api/driver/', include('API_Driver.urls')),
    path('driver/', include('Driver.urls')),
    path('admin/', include('AdminApp.urls')),
    url(r'^api/', include('API_Customer.urls')),
    path('', include('Customer.urls')),
    # url(r'^customer/',include('Customer.urls')),
    url(r'^media/(?P<path>.*)$', serve,{'document_root': settings.MEDIA_ROOT}), 
    url(r'^static/(?P<path>.*)$', serve,{'document_root': settings.STATIC_ROOT}),
]
