function nametest(st)
{
  if(/^[a-zA-Z\s]+$/.test(st))
  {
  return true;
  }
  else
  {
    return false;
  }
}
function CheckPassword(inputtxt) 
{ 
  var decimal=  /^(?=.*[A-Z]).{6,50}$/;
  if(inputtxt.match(decimal)) 
  { 
    return true;
  }
  else
  { 
    return false;
  }
} 

//below code is to assign new task for admin by SuperAdmin
$(".assign_task").on( "click", function() {
  admin_id = $ (this).closest('td').find('.admin_id').text()
  admin_email = $ (this).closest('td').find('.admin_email').text()
  $('#assigntask_email').val(admin_email)
  $('#assigntask_description').val('')
  $('#assigntask_adminid').val(admin_id)
  $('#AssignTask').modal('show')

});

$( "#assign-task-btn" ).on( "click", function() {
  // debugger;
  $('#assigntask_description_txt').text('')

  admin_id = $('#assigntask_adminid').val()
  description = $('#assigntask_description').val()
  description = description.trim()

  if (description.length == 0)
  {
    $('#assigntask_description_txt').text('This field is required.')
    return false;
  }
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/assigntask/',
      data: { 'admin_id' : admin_id, 'description' : description, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#AssignTask').modal('hide')
          $('.response-msg').text('Task created successfully.')
          $('#success_modal_add').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else
        {
          $('.response-msg').text(response.status_message)
          $('#success_modal_add').modal('show')
        }
      }
    });
});








$(".approve_admin").on( "click", function() {
  // debugger;
  admin_id = $ (this).closest('td').find('.admin_id').text()
  // alert(admin_id)
  $('#tobeapproved_id').val(admin_id)
  $('#ApproveModal').modal('show')

});

$( ".approve-account-btn" ).on( "click", function() {
  // debugger;
  admin_id = $('#tobeapproved_id').val()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/approveadmin/',
      data: { 'admin_id' : admin_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          // $('#DeleteUserModal').modal('hide');
          // $('#success_modal_deleted').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else if(response.status_code == 0)
        {

        }
      }
    });
});



$( "#open-add-admin-modal" ).on( "click", function() {
  // debugger;
  $('#add_admin_name_txt').text('')
  $('#add_admin_email_txt').text('')
  $('#add_admin_password_txt').text('')
  $('#add_admin_countrycode_txt').text('')
  $('#add_admin_phone_txt').text('')
  $('#AddAdminModal').modal('show')

});

$("#add-admin-btn" ).on( "click", function() {
  $('#add_admin_name_txt').text('')
  $('#add_admin_email_txt').text('')
  $('#add_admin_password_txt').text('')
  $('#add_admin_phone_txt').text('')
  
  var name = $('#add_admin_name').val()
  var email = $('#add_admin_email').val()
  var password = $('#add_admin_password').val()
  var phone = $('#add_admin_phone').val()
  var imgsrc = $('#add-image-srcdata').val();
  phone = phone.trim()
  if (name.length == 0)
  {
    $('#add_admin_name_txt').text('This field is required.')
    return false;
  }
  if (name.length > 50)
  {
    $('#add_admin_name_txt').text('Enter less than 50 characters.')
    return false;
  }
  if (!nametest(name))
  {
    $('#add_admin_name_txt').text('Only characters and spaces allowed.')
    return false; 
  }

  if (email.length == 0)
  {
    $('#add_admin_email_txt').text('This field is required.')
    return false;
  }
  if (email.length > 35)
  {
    $('#add_admin_email_txt').text('Email less than 35 Characters')
    return false;
  }
  var filter = /^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/;
  if (!filter.test(email))
  {
    $('#add_admin_email_txt').text('Enter a Valid Email Address')
    return false;
  }
  if (password.length == 0)
  {
    $('#add_admin_password_txt').text('This field is required.')
    return false;
  }
  else
  {
    if(password.length < 6)
    {
        $('#add_admin_password_txt').text('Password should contain minimum 6 characters.')
        $( "#add_admin_password" ).focus();
        return false;
    }
    else if(password.length > 50)
    {
        $('#add_admin_password_txt').text('Password should contain maximum 50 characters.')
        $( "#add_admin_password" ).focus();
        return false;
    }
    else 
    {
        if(CheckPassword(password))
        {
            if(/\s/g.test(password))
            {
              $('#add_admin_password_txt').text('Password can not contain space.')
              $( "#add_admin_password" ).focus();
              return false;
            }
          
        }
        else
        {
            $('#add_admin_password_txt').text('Password should contain atleast one uppercase letter.')
            $( "#add_admin_password" ).focus();
            return false;     
        }
    }
  }
  if (phone.length == 0)
  {
    $('#add_admin_phone_txt').text('This field is required.')
    return false;
  }
  if (phone.length > 15)
  {
    $('#add_admin_phone_txt').text('Phone less than 15 characters')
    return false;
  }
  if(isNaN(phone)){
     $('#add_admin_phone_txt').text('Enter a Only Number')
    return false;
  }
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/addadmin/',
      data: {'name' : name, 'email' : email, 'password' : password, 'phone' : phone, 'image' : imgsrc, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#AddAdminModal').modal('hide');
          $('.response-msg').text('Record added successfully.')
          $('#success_modal_add').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else if(response.status_code == 0)
        {
          $('#add_admin_email_txt').text(response.status_message)
        }
        // $('#EditAdminModal').modal('show')
      }
    });
});




$( ".delete_admin" ).on( "click", function() {
  // debugger;
  admin_id = $ (this).closest('td').find('.admin_id').text()
  $('#delete-record-data').val(admin_id)
  $('#DeleteUserModal').modal('show')

});

$( ".delete-record-yes-btn" ).on( "click", function() {
  // debugger;
  admin_id = $('#delete-record-data').val()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/deleteadmin/',
      data: { 'admin_id' : admin_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#DeleteUserModal').modal('hide');
          $('#success_modal_deleted').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else if(response.status_code == 0)
        {

        }
      }
    });
});

$( "#close-admin-view-btn" ).on( "click", function() {
  $('#ViewadminModal').modal('hide')
});
$( ".view_admin" ).on( "click", function() {
  // debugger;
  admin_id = $ (this).closest('td').find('.admin_id').text()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/editadmin/',
      data: { 'admin_id' : admin_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        admin_details = JSON.parse(response)
        console.log(admin_details)
        if(admin_details[0].image)
          {
            // $('#view-show-image').attr("style", 'height:75px;width:75px;');
            $('#view-show-image').attr("src", admin_details[0].image);
          }
          else
          {
            // alert('no image')
            $('#view-show-image').attr("src", "/static/images/camera.png"); 
          }
        $('#view_admin_name').val(admin_details[0].name)
        $('#view_admin_email').val(admin_details[0].email)

        $('#view_admin_countrycode').val(admin_details[0].countrycode)
        $('#view_admin_phone').val(admin_details[0].phone)
        $('#view_admin_phone_txt').text('')
        $('#view_admin_id').val(admin_details[0].id)
        console.log('model showing')
        $('#ViewAdminModal').modal('show')
      }
    });
});
$( ".edit_admin" ).on( "click", function() {
	// debugger;
  admin_id = $ (this).closest('td').find('.admin_id').text()
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/editadmin/',
      data: { 'admin_id' : admin_id, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        admin_details = JSON.parse(response)
        if(admin_details[0].image)
        {
          // $('#edit-show-image').attr("style", 'height:75px;width:75px;');
          $('#edit-show-image').attr("src", admin_details[0].image);
        }
        else
        {
          $('#edit-show-image').attr("src", "/static/images/camera.png"); 
        }
        $('#edit_admin_name').val(admin_details[0].name)
        $('#edit_admin_email').val(admin_details[0].email)

        $('#edit_admin_countrycode').val(admin_details[0].countrycode)
        $('#edit_admin_phone').val(admin_details[0].phone)
        $('#edit_admin_phone_txt').text('')
        $('#edit_admin_id').val(admin_details[0].id)
        $('#EditAdminModal').modal('show')
      }
    });
});

$( "#update-admin-btn" ).on( "click", function() {
  
  $('#edit_admin_name_txt').text('')
  $('#edit_admin_phone_txt').text('')
  
  var name = $('#edit_admin_name').val()
  var phone = $('#edit_admin_phone').val()
  var imgsrc = $('#edit-image-srcdata').val();
  var admin_id = $('#edit_admin_id').val()

  name = name.trim()
  phone = phone.trim()
  
  if (name.length == 0)
  {
    $('#edit_admin_name_txt').text('This field is required.')
    return false;
  }
  if(name.length > 30)
  {
    $('#edit_admin_name_txt').text('Name less than 30 characters')
    return false;
  }
  if (phone.length == 0)
  {
    $('#edit_admin_phone_txt').text('This field is required.')
    return false;
  }
  if (phone.length > 15)
  {
    $('#edit_admin_phone_txt').text('Phone less than 15 characters')
    return false;
  }
  if(isNaN(phone)){
     $('#edit_admin_phone_txt').text('Enter a Only Number')
    return false;
  }
  var token=$('input[name="csrfmiddlewaretoken"]').val()
  $.ajax({
      type: 'POST',
      url: '/admin/updateadmin/',
      data: { 'admin_id' : admin_id, 'name' : name, 'phone' : phone, 'image' : imgsrc, 'csrfmiddlewaretoken' : token},
      success: function(response){
        console.log(response);
        if(response.status_code == 200)
        {
          $('#EditAdminModal').modal('hide');
          $('#success_modal_updated').modal('show')
          setTimeout(function () {
              location.reload();
          }, 2000);
        }
        else if(response.status_code == 0)
        {

        }
        // $('#EditAdminModal').modal('show')
      }
    });
});