
function CheckPassword(inputtxt) 
{ 
  var decimal=  /^(?=.*[A-Z]).{6,50}$/;
  if(inputtxt.match(decimal)) 
  { 
    return true;
  }
  else
  { 
    return false;
  }
} 
$("#change-password-btn").on( "click", function() {
  // debugger;

  $('#oldpassword_txt').text('')
  $('#newpassword_txt').text('')
  $('#confirmnewpassword_txt').text('')
  

  var oldpassword = $('#oldpassword').val()
  var newpassword = $('#newpassword').val()
  var confirmnewpassword = $('#confirmnewpassword').val()
  var userrole = $('#userrole').text()
  
  oldpassword = oldpassword.trim()
  newpassword = newpassword.trim()
  confirmnewpassword = confirmnewpassword.trim()
  userrole = userrole.trim()
  

  if (oldpassword.length == 0)
  {
    $('#oldpassword_txt').text('This field is required.')
    $( "#oldpassword" ).focus();
    return false;
  }
  if (newpassword.length == 0)
  {
    $('#newpassword_txt').text('This field is required.')
    $( "#newpassword" ).focus();
    return false;
  }
  else
  {
    if(newpassword.length < 6)
    {
        $('#newpassword_txt').text('Password should contain minimum 6 characters.')
        $( "#newpassword" ).focus();
        return false;
    }
    else if(newpassword.length > 50)
    {
        $('#newpassword_txt').text('Password should contain maximum 50 characters.')
        $( "#newpassword" ).focus();
        return false;
    }
    else 
    {
        if(CheckPassword(newpassword))
        {
            if(/\s/g.test(newpassword))
            {
              $('#newpassword_txt').text('Password can not contain space.')
              $( "#newpassword" ).focus();
              return false;
            }
          
        }
        else
        {
            $('#newpassword_txt').text('Password should contain atleast one uppercase letter.')
            $( "#newpassword" ).focus();
            return false;     
        }
    }
  }
  if (newpassword != confirmnewpassword)
  {
    $('#confirmnewpassword_txt').text('New Password and Confirm New Password should be same.')
    $( "#confirmnewpassword" ).focus();
    return false;
  }
  
  var token = $('input[name="csrfmiddlewaretoken"]').val()
  $('#loading-img').show();
  $.ajax({
      method: 'POST',
      url: '/changepassword/',
      data: { 'oldpassword' : oldpassword, 'newpassword' : newpassword, 'userrole' : userrole, 'csrfmiddlewaretoken' : token},
      success: function(response){
        $('#loading-img').hide();
        console.log(response);
        if(response.status_code == 200)
        {
          
          $("#success_modal_updated").modal('show')
              setTimeout(function () {
                 location.reload()
              }, 2000);
        }
        else 
        {
          if(response.status_message)
          {
            $('#error-msg').text(response.status_message)
            $('#ErrorMessageModal').modal('show')
            // alert(response.status_message)
          }
        }
      }
    });
});

$(".toggle-password").click(function() {
  $(this).toggleClass("fa-eye fa-eye-slash");
  var input = $($(this).attr("toggle"));
  if (input.attr("type") == "password") {
    input.attr("type", "text");
  } else {
    input.attr("type", "password");
  }
});