from django.db import models
from django.contrib.auth.models import User
# Create your models here.

class SuperAdmin(models.Model):
    user = models.ForeignKey(User,on_delete=models.CASCADE)
    email = models.CharField(max_length=54,null=True)
    firstName = models.CharField(max_length=100,null=True)
    lastName = models.CharField(max_length=100,null=True)
    image = models.CharField(max_length=100,null= True)
    gender = models.CharField(max_length=10,null=True)
    address = models.TextField(null= True)
    password = models.CharField(max_length=250,default='',null=True)
    phoneNumber = models.CharField(max_length=100,null=True)
    forgotPasswordLink = models.CharField(max_length=254,null=True)
    is_subadmin = models.BooleanField(default=False,null=True)
    role = models.IntegerField(max_length=10,null=True)
    role_name = models.CharField(max_length=254,null=True)
    created_at=models.DateTimeField(auto_now_add=True)
    updated_at=models.DateTimeField(auto_now=True)
    end_date = models.DateTimeField(null=True)

    class Meta:
        db_table = "super_admin"


class AdminNotification(models.Model):
    
    admin = models.ForeignKey(User, on_delete=models.CASCADE)
    message = models.TextField()
    is_read = models.BooleanField(default=False)
    created_at = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = 'admin_notifications'


class Subscription(models.Model):
    plane_name = models.CharField(max_length=255)
    description = models.CharField(max_length=255,null=True)
    price = models.IntegerField(max_length=255,null=True)
    end_date = models.DateField()
    start_date = models.DateField()
    created_at = models.DateField(auto_now_add=True)
    updated_at = models.DateField(auto_now=True)
    is_active = models.BooleanField(default=True)
    durations = models.CharField(max_length=255,null=True)
    type = models.CharField(max_length=255,null=True)

    class Meta:
        db_table ="subscription"


class ContentPages(models.Model):
    page_type = models.CharField(max_length = 100, null = True)
    title =  models.CharField(max_length = 244, null= True)
    content  = models.TextField()
    user_type = models.CharField(max_length = 100, null= True)
    status = models.BooleanField(default=True,null=True)
    start_date = models.DateTimeField(auto_now_add=True)
    end_date = models.DateTimeField(null=True)


    class Meta:
        db_table = "content_pages"