from datetime import timezone
from shutil import make_archive
from django.db import models
from django.contrib.auth.models import User
from django.db.models.deletion import CASCADE, SET_NULL, DO_NOTHING
from django.utils import timezone




class EndUser(models.Model):
	enduser_id  = models.CharField(max_length=20,default='',null=True)
	name = models.CharField(max_length=244,default='')
	email = models.EmailField(max_length=100,null=True)
	gender = models.CharField(max_length=30,default='',null=True)
	email_verification_otp = models.IntegerField(null=True)
	email_verified = models.BooleanField(default=False)
	phone_number = models.CharField(max_length=20, default='',null=True)
	phone_number_otp = models.CharField(max_length=20, default='',null=True)
	phone_number_verified = models.BooleanField(default=False)
	password = models.CharField(max_length=250,default='',null=True)
	forgot_password_otp = models.IntegerField(null=True)
	image = models.TextField(null=True)
	status =  models.BooleanField(default=True)
	created_at = models.DateTimeField(auto_now_add=True)
	last_login = models.DateTimeField(null=True, blank=True)
	updated_at = models.DateTimeField(auto_now=True)
	end_date = models.DateTimeField(null=True) 

	class Meta:
		db_table = 'end_User'

class ChatBot(models.Model):
	user = models.ForeignKey(EndUser, on_delete=models.CASCADE, related_name='chatbots')  
	chatbot_name = models.CharField(max_length=100,null=True)
	business_types = models.CharField(max_length=240,null=True)
	business_logo = models.CharField(max_length=244,null=True)
	business_name = models.CharField(max_length=240,null=True)
	business_pdf  = models.CharField(max_length=255)
	chatbot_color = models.CharField(max_length=250,null=True)
	chatbot_style = models.CharField(max_length=250,null=True)
	created_at = models.DateTimeField(auto_now_add=True)

	class Meta:
		db_table = 'chat_Bot'


class UserLeads(models.Model):
	name = models.CharField(max_length=244,null=True)
	email = models.EmailField(max_length=244,null=True)
	address = models.CharField(max_length=255,null=True)
	type = models.CharField(max_length=200,null=True)
	status = models.CharField(max_length=255,null=True)
	lead  = models.CharField(max_length=244,null=True)
	note = models.CharField(max_length=244,null=True)
	phone_number = models.CharField(max_length=244,null=True)
	created_at = models.DateTimeField(auto_now_add=True)

	class Meta:
		db_table = 'user_leads'

class EndUserNotifications(models.Model):
	user = models.ForeignKey(EndUser, on_delete=models.CASCADE)
	message = models.TextField(null=True)
	is_read = models.BooleanField(default=False,null=True)
	type = models.CharField(max_length=100,null=True)
	start_date = models.DateTimeField(auto_now_add=True,null=False)
	end_date = models.DateTimeField(null=True)

	class Meta:
		db_table = "enduser_notifications"