from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from django.contrib.auth.hashers import make_password, check_password
from rest_framework_simplejwt.tokens import RefreshToken
# from rest_framework.permission import IsAuthentication 
from user_panel.authentication import authenticated
from .models import User
from user_panel.models import *
from admin_panel.models import *
from passlib.hash import django_pbkdf2_sha256 as handler
import random
from django.conf import settings
from django.template.loader import render_to_string
from django.core.mail import send_mail
# Create your views here.
from django.core import mail
from admin_panel.functions import *
from admin_panel.views import *
from datetime import datetime


#Register#

class userRegister(APIView):
    def post(self, request):

        name = request.data.get("name")
        email = request.data.get("email")
        password = request.data.get("password")
        
        if not name:
           return Response({"message": 'name  is required'}, status=status.HTTP_400_BAD_REQUEST)
        if not email:
            return Response({"message": 'email is required'}, status=status.HTTP_400_BAD_REQUEST)
        if not password:
            return Response({"message": 'password is required'}, status=status.HTTP_400_BAD_REQUEST)

        if EndUser.objects.filter(email=email).exists():
            return Response({"message": "User with this email already exists"}, status=status.HTTP_400_BAD_REQUEST)

        user = EndUser.objects.create(
            name = name,
            email=email,
            password=make_password(password)
        )
        refresh = RefreshToken.for_user(user)
        return Response({"message": "User registered successfully",
                          "access": str(refresh.access_token),
                            "refresh": str(refresh)}, 
                         
            status=status.HTTP_201_CREATED)

        
#loginpage#

class loginUser(APIView):
    def post(self,request):
        email = request.data.get('email')
        password = request.data.get('password')

        if not email:
            return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
        if not password:
            return Response({"message":'password is required'},status=status.HTTP_400_BAD_REQUEST)
        
        try:
            user = EndUser.objects.get(email=email)
        except EndUser.DoesNotExist:
            return Response({"message": "User Not credentials"}, status=status.HTTP_401_UNAUTHORIZED)

        if not check_password(password, user.password):
            return Response({"message": "Invalid credentials"}, status=status.HTTP_401_UNAUTHORIZED)
        
        refresh = RefreshToken.for_user(user)

        return Response({
            "message": "Login successful",
            "username":user.name,
            "access": str(refresh.access_token),
            "refresh": str(refresh)
        }, status=status.HTTP_200_OK)


#terms and Conditions
# class getTermsConditions(TemplateView):
# 	template_name = 'user_terms.html'
# 	def get(self,request):
# 		data_obj = ContentPages.objects.filter(page_type='Terms',user_type = "User").first()
# 		return render(request,self.template_name,locals())	

class getTermsConditions(APIView):
    def get(self, request):
        data_obj = ContentPages.objects.filter(page_type='Terms', user_type='User').first()
        if data_obj:
            return Response({
                'title': data_obj.title,
                'content': data_obj.content,
                'page_type': data_obj.page_type,
                'user_type': data_obj.user_type,
            }, status=status.HTTP_200_OK)
        else:
            return Response({'detail': 'No Terms and Conditions found.'}, status=status.HTTP_404_NOT_FOUND)

#UserChangepasword#
class userChangePassword(APIView):
    def post(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id=uid).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)

            admin_obj  =  SuperAdmin.objects.all().first()
            if user_obj.status ==  False:
                return Response({"message":'Your account has been Inactive, Please contact to admin.',"email":admin_obj.email},status=status.HTTP_406_NOT_ACCEPTABLE)
            
            old_password = request.data.get('old_password')
            if not old_password:
                return Response({'message':'old password is required'},status=status.HTTP_400_BAD_REQUEST)
            new_password = request.data.get('new_password')
            if not new_password:
                return Response({'message':'new password is required'},status=status.HTTP_400_BAD_REQUEST)
            check_password = user_obj.password
            check = handler.verify(old_password,check_password)
            if check == False:
                return Response({'message':'Old password is incorrect'},status=status.HTTP_403_FORBIDDEN)
            password = new_password
            encrypt_password = handler.hash(password)
            user_obj.password = encrypt_password
            user_obj.save()
            return Response({'message':'Success'}) 
        except Exception as e:
            return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)
        

class userForgetPassword(APIView):
    def post(self,request):
            try:
                data = request.data
                email = data.get('email').strip().lower()
                if not email:
                    return Response({"message":'Email is required'})
                user  = EndUser.objects.filter(email=email).count()
                if user == 0:
                    return Response({"message":'This email does not exist in our database, please enter the valid email address.'},status=status.HTTP_404_NOT_FOUND)
                user_obj  = EndUser.objects.filter(email=email).first()
                if user_obj:
                    theotp=random.randrange(1000, 9999, 5)
                    user_obj.forgot_password_otp=theotp
                    user_obj.save()
                    print("------------",user_obj,"the otp")
                    to_email = user_obj.email
                    subject = "Forget Password OTP"
                    html_message = render_to_string('forget_password_otp.html', {'otp': theotp})
                    plain_message = html_message
                    from_email = settings.EMAIL_HOST_USER
                    mail.send_mail(subject, plain_message, from_email, [to_email], html_message=html_message)
                    return Response({
                        "message": "Rendered HTML",
                        "html": html_message
                    })
                    # return Response({"message":'Reset Password OTP has been sent to this email address'})
                else:
                    return Response({"message":'Email not exists'})

            except Exception as e:
                print(e)
                return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)
            
# #verifyforgetpassword#            
class verifyForgetPasswordOTP (APIView):
    def post(self,request):
            try:
                email = request.data.get('email').strip().lower()
                if not email:
                        return Response({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'Email is required'},status=status.HTTP_400_BAD_REQUEST)
                otp = request.data.get('otp')
                if not otp:
                        return Response({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'otp is Required'},status =status.HTTP_400_BAD_REQUEST)
                check_email = EndUser.objects.filter(email = email).exists()
                if not check_email :
                        return Response({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'Email not exist'},status=status.HTTP_400_BAD_REQUEST)
                user_obj = EndUser.objects.filter(email= email,forgot_password_otp = otp).first()
                if user_obj:
                    return Response({'status_code':status.HTTP_200_OK,'status_message':'Successfully Verified'})
                else:
                    return Response({'status_code':status.HTTP_400_BAD_REQUEST,'status_message':'Invalid otp'})
            except Exception as e:
                return Response({'status_code':status.HTTP_500_INTERNAL_SERVER_ERROR,'status_message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)        
                
                    
 
class changeForgetPassword(APIView):
    def post(self,request):
        try:
            email = request.data.get('email').strip().lower()
            if not email:
                return Response({'message': 'email is required'}, status=status.HTTP_404_NOT_FOUND)
            user_obj = EndUser.objects.filter(email=email).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            admin_obj  =  SuperAdmin.objects.all().first()
            if user_obj.status ==  False:
                return Response({"message":'Your account has been Inactive, Please contact to admin.',"email":admin_obj.email},status=status.HTTP_406_NOT_ACCEPTABLE)			
            new_password = request.data.get('new_password')
            if not new_password:
                return Response({'message':'new password is required'},status=status.HTTP_400_BAD_REQUEST)
            confirm_password = request.data.get('confirm_password')
            if not confirm_password:
                return Response({'message':'confirm password is required'},status=status.HTTP_400_BAD_REQUEST)
            if new_password != confirm_password:
                return Response({'message':'Password and confirm password are not same.'},status=status.HTTP_403_FORBIDDEN)
            encrypt_password = handler.hash(confirm_password)
            user_obj.password = encrypt_password
            user_obj.save()
            return Response({'message':'Success'}) 
        except Exception as e:
            return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)
        


class updateProfile(APIView):
    def get(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e :
                return Response({'message':str(e)},status=status.HTTP_401_UNAUTHORIZED)
            
            user_obj = EndUser.objects.filter(id=uid).first()

            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            all_data ={
                "name":user_obj.name,
                "gender":user_obj.gender,
                "phone_number":user_obj.phone_number,
                "image":user_obj.image,
                "email":user_obj.email
            }
            return Response({'status_code':status.HTTP_200_OK,'status_message':'Fetched Successfully','all_data':all_data})
        except Exception as e:
            return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)



    def post(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e :
                return Response({'message':str(e)},status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id=uid).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            
            name = request.data.get("name")
            gender = request.data.get("gender")
            phone_number =request.data.get("phone_number")
            image = request.data.get("image")
            email = request.data.get("email")
            # if request.FILES.get("image"):
            # 	uploaded_image = request.FILES["image"]
            # 	file_url = uploadTheImages(uploaded_image)  # Your custom image upload function
            # 	user_obj.image = "/" + file_url  # Save path in DB
            
            user_obj.name = name
            user_obj.gender = gender
            user_obj.phone_number = phone_number
            user_obj.image = image
            user_obj.email = email
            user_obj.save()
            print("user_obj",user_obj)

            return Response({'status_code':status.HTTP_200_OK,'status_message':'Profile updated successfully'})
        except Exception as e:
            return Response({'message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class UploadImages(APIView):
    def post(self,request):
        try:
            data = request.data
            images = data.getlist('image')
            image_urls = []
            for image in images:
                image_path = uploadTheDocument(image)
                image_urls.append(image_path)
            return Response({'status_code':status.HTTP_200_OK,'status_message':'Success','data':image_urls})
        except Exception as e:
            return Response({'message': str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class chatBot(APIView):

    def get(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e :
                return Response({'message':str(e)},status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id = uid).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            
            chatBots = ChatBot.objects.filter(user_id = str(uid))

            chatbot_listing =[]

            for bot in chatBots:
                chatbot_listing.append({
                    "id":bot.id,
                    "user_id":bot.user_id,
                    "chatbot_name":bot.chatbot_name,
                    "business_types":bot.business_types,
                    "business_logo":bot.business_logo,
                    "business_name":bot.business_name,
                    "business_pdf":bot.business_pdf,
                    "chatbot_color":bot.chatbot_color,
                    "chatbot_style":bot.chatbot_style,
                    "created_at":bot.created_at

                })
            return Response({'message': 'Success', 'data': chatbot_listing}, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({'message': 'Internal server error', 'details': str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)
        
    def post(self, request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)

            user_obj = EndUser.objects.filter(id=uid).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)

            data = request.data
            file = request.FILES.get("business_pdf")
            chatbot_name = data.get("chatbot_name")

            if not all([file, chatbot_name]):
                return Response({'message': 'business_pdf and chatbot_name are required.'}, status=status.HTTP_400_BAD_REQUEST)

            allowed_ext = [".pdf", ".csv", ".xlsx"]
            ext = os.path.splitext(file.name)[1].lower()
            if ext not in allowed_ext:
                return Response({'message': 'Invalid file type. Allowed types: PDF, CSV, XLSX'}, status=status.HTTP_400_BAD_REQUEST)

            folder_path = os.path.join(settings.MEDIA_ROOT, "data", str(uid), chatbot_name)
            os.makedirs(folder_path, exist_ok=True)

            save_path = os.path.join(folder_path, file.name)
            with open(save_path, "wb") as f:
                for chunk in file.chunks():
                    f.write(chunk)

            relative_file_path = os.path.relpath(save_path, settings.MEDIA_ROOT)

            chatbot = ChatBot.objects.create(
                user=user_obj,
                chatbot_name=chatbot_name,
                business_types=data.get('business_types'),
                business_logo=data.get('business_logo'),
                business_name=data.get('business_name'),
                business_pdf=relative_file_path, 
                chatbot_color=data.get('chatbot_color'),
                chatbot_style=data.get('chatbot_style'),
                created_at=data.get('created_at'),
            )

            return Response({'message': 'Chatbot created', 'chatbot_id': chatbot.id}, status=status.HTTP_201_CREATED)

        except Exception as e:
            return Response({'message': 'Internal server error', 'details': str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)
        
        
    # def post(self,request):
    # 	try:
    # 		try:
    # 			uid = authenticated(request)
    # 		except Exception as e :
    # 			return Response({'message':str(e)},status=status.HTTP_401_UNAUTHORIZED)
    # 		user_obj = EndUser.objects.filter(id=uid).first()
    # 		if not user_obj:
    # 			return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
    # 		data= request.data

    # 		chatbot = ChatBot.objects.create(
    # 			user = user_obj,

    # 			chatbot_name = data.get('chatbot_name'),
    # 			business_types= data.get('business_types'),
    # 			business_logo = data.get('business_logo'),
    # 			business_name = data.get('business_name'),
    # 			business_pdf = data.get('business_pdf'),
    # 			chatbot_color = data.get('chatbot_color'),
    # 			chatbot_style = data.get('chatbot_style'),
    # 			created_at = data.get('created_at'),
    # 		)
    # 		return Response({'message': 'Chatbot setting created', 'chatbot_id': chatbot.id}, status=status.HTTP_201_CREATED)

    # 	except Exception as e:
    # 			return Response({'message': 'Internal server error', 'details': str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)
        

class editchatBot(APIView):
    def put(self, request, bot_id):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)

            user_obj = EndUser.objects.filter(id=uid).first()
            if not user_obj:
                return Response({'message': 'User not found'}, status=status.HTTP_404_NOT_FOUND)

            bot = ChatBot.objects.filter(id=bot_id, user=user_obj).first()
            if not bot:
                return Response({'message': 'Chatbot not found'}, status=status.HTTP_404_NOT_FOUND)

            data = request.data

            chatbot_name = data.get("chatbot_name")
            business_types = data.get("business_types")
            business_logo = data.get("business_logo")
            business_name = data.get("business_name")
            business_pdf = data.get("business_pdf")

            if not chatbot_name or not business_name:
                return Response({'message': 'Required fields missing'}, status=status.HTTP_400_BAD_REQUEST)

            bot.chatbot_name = chatbot_name
            bot.business_types = business_types if business_types else bot.business_types
            if business_logo:
                bot.business_logo = business_logo
            bot.business_name = business_name
            if business_pdf:
                bot.business_pdf = business_pdf

            bot.save()

            return Response({
                'message': 'Chatbot updated successfully',
            }, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({'message': 'Internal server error', 'details': str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class userLead(APIView):
    
    def post(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e :
                return Response({'message':str(e)},status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id=uid).first()
            if not user_obj:
                return Response({'message': 'user not found'}, status=status.HTTP_404_NOT_FOUND)
            data = request.data

            lead = UserLeads.objects.create(
                name=data.get("name"),
                email=data.get("email"),
                lead=data.get("lead"),
                note=data.get("note"),
                address = data.get("address"),
                type= data.get("type"),
                status = data.get('status'),
                phone_number=data.get("phone_number"),
                created_at = data.get('created_at')
            )

            message = f"New lead submitted by {lead.name} ({lead.email}) - Lead: {lead.lead}"

            admins = User.objects.all()
            for admin in admins:
                AdminNotification.objects.create(
                    admin=admin,
                    # message=message
                    message="New lead submitted"
                )


            return Response({"message": "Lead created and admin notified"}, status=status.HTTP_201_CREATED)
        except Exception as e:
                return Response({'message': 'Internal server error', 'details': str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class subscription(APIView):
    def get(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            
            user_obj = EndUser.objects.filter(id=uid).first()

            if not user_obj:
                return Response({'message': 'User not found'}, status=status.HTTP_404_NOT_FOUND)
            
            subscriptions = Subscription.objects.filter(is_active=True)

            subscriptios_list =[]

            for sub in subscriptions:
                subscriptios_list.append({
                    "id":sub.id,
                    "plane_name":sub.plane_name,
                    "description":sub.description,
                    "price":sub.price,
                    "end_date":sub.end_date,
                    "start_date":sub.start_date,
                    "created_at":sub.created_at,
                    "updated_at":sub.updated_at,
                    "is_active":sub.is_active,
                    "durations":sub.durations,
                    "type":sub.type
                })
                return Response({'message': 'Success', 'data': subscriptios_list}, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({'message': 'Internal server error', 'details': str(e)},
                            status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class getUserNotifications(APIView):
    def get(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id = uid).first()
            if not user_obj:
                return Response({'message': 'User not found'}, status=status.HTTP_404_NOT_FOUND)
            admin_obj = SuperAdmin.objects.all().first()
            if user_obj.status == False:
                return Response({"message":'Your account has been Inactive, Please contact to admin.',"email":admin_obj.email},status=status.HTTP_406_NOT_ACCEPTABLE)
            notify_obj =EndUserNotifications.objects.filter(user_id = user_obj.id)

            all_Data = []
            for notify in notify_obj:
                all_data= {
                    'id':notify.id,
                    'message':notify.message,
                    'is_read':notify.is_read,
                    'type':notify.type,
                    'start_date':timesince(notify.start_date)+' ago',
                }
                all_Data.append(all_data)

            return Response({'status_code':status.HTTP_200_OK,'status_message':'Fetched Successfully','data':all_Data})
        except Exception as e:
            return Response({'status_code':status.HTTP_500_INTERNAL_SERVER_ERROR,'status_message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)
        
class deleteUserNotifications(APIView):
    def post(self,request):
        try:
            try:
                uid = authenticated(request)
            except Exception as e:
                return Response({'message': str(e)}, status=status.HTTP_401_UNAUTHORIZED)
            user_obj = EndUser.objects.filter(id = uid).first()
            if not user_obj:
                return Response({'message': 'User not found'}, status=status.HTTP_404_NOT_FOUND)
            if user_obj.status == False:
                return Response({"message":'Your account has been Inactive, Please contact to admin.',"email":admin_obj.email},status=status.HTTP_406_NOT_ACCEPTABLE)
            notification_id = request.data.get('notification_id')
            if not notification_id:
                return Response({'message': 'notification_id id required'}, status=status.HTTP_404_NOT_FOUND)

            not_obj =  EndUserNotifications.objects.filter(id = notification_id).first()
            not_obj.delete()
            return Response({'status_code':status.HTTP_200_OK,'status_message':'Deleted Successfully'})
        except Exception as e:
            return Response({'status_code':status.HTTP_500_INTERNAL_SERVER_ERROR,'status_message':str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class chatbotDetails(APIView):
    def get(self, request):
        try:
            bot_id = request.GET.get('bot_id')
            bot = ChatBot.objects.filter(id = bot_id).first()
            
            all_data = {
                "id": bot.id,
                "user_id": bot.user_id,
                "chatbot_name": bot.chatbot_name,
                "business_types": bot.business_types,
                "business_logo": request.build_absolute_uri(bot.business_logo) if bot.business_logo else None,
                "business_name": bot.business_name,
                "business_pdf": request.build_absolute_uri(bot.business_pdf) if bot.business_pdf else None,
                "chatbot_color": bot.chatbot_color,
                "chatbot_style": bot.chatbot_style,
                "created_at": bot.created_at.strftime('%Y-%m-%d %H:%M:%S'),
            }

            return Response({'message': 'Success', 'data': all_data}, status=status.HTTP_200_OK)

        except Exception as e:
            return Response({
                'message': 'Internal server error',
                'details': str(e)
            }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

