from django.contrib import admin
from .models import ChatbotSettings, FAQ, Document


@admin.register(ChatbotSettings)
class ChatbotSettingsAdmin(admin.ModelAdmin):
    list_display = ("site_name", "enable_openai", "enable_wpamelia", "enable_woocommerce", "tone_of_voice")


@admin.register(FAQ)
class FAQAdmin(admin.ModelAdmin):
    search_fields = ("question", "answer")
    list_display = ("question", "source_url")


@admin.register(Document)
class DocumentAdmin(admin.ModelAdmin):
    search_fields = ("title", "content")
    list_display = ("title", "url", "chunk_id")

# Register your models here.
