from __future__ import annotations

from dataclasses import dataclass
from typing import List, Optional, Dict, Any

import requests


@dataclass
class Booking:
    id: str
    title: str
    start_iso: str
    end_iso: str
    location: Optional[str] = None
    customer_email: Optional[str] = None


class AmeliaClient:
    def __init__(self, base_url: str, api_key: str | None = None) -> None:
        self.base_url = base_url.rstrip("/")
        self.api_key = api_key

    def _headers(self) -> Dict[str, str]:
        headers = {"Content-Type": "application/json"}
        if self.api_key:
            headers["Authorization"] = f"Bearer {self.api_key}"
        return headers

    def find_bookings(self, email: Optional[str] = None, booking_id: Optional[str] = None) -> List[Booking]:
        # TODO: Implement with real Amelia endpoints
        return []

    def reschedule(self, booking_id: str, new_start_iso: str) -> bool:
        # TODO: Implement with real Amelia endpoints
        return True

    def cancel(self, booking_id: str) -> bool:
        # TODO: Implement with real Amelia endpoints
        return True


@dataclass
class Coupon:
    code: str
    amount: float
    discount_type: str  # percent|fixed
    expiry_iso: Optional[str] = None
    email_restriction: Optional[str] = None


class WooClient:
    def __init__(self, base_url: str, consumer_key: str, consumer_secret: str) -> None:
        self.base_url = base_url.rstrip("/")
        self.consumer_key = consumer_key
        self.consumer_secret = consumer_secret

    def create_coupon(self, prefix: str, amount: float, discount_type: str, email: Optional[str], days_valid: int, one_time: bool) -> Coupon:
        # TODO: Implement with real Woo REST API v3
        code = f"{prefix}TEST-1234"
        return Coupon(code=code, amount=amount, discount_type=discount_type)

    def find_order(self, order_number: str, email: Optional[str]) -> Dict[str, Any] | None:
        # TODO: Implement with real Woo REST API v3
        return None
