from django.db import models


class ChatbotSettings(models.Model):
    site_name = models.CharField(max_length=200, default="Alpaca Eco Farm")
    enable_openai = models.BooleanField(default=True)
    enable_woocommerce = models.BooleanField(default=True)
    enable_wpamelia = models.BooleanField(default=True)
    enable_faq_redirects = models.BooleanField(default=True)

    tone_of_voice = models.CharField(max_length=100, default="informative")
    enable_emojis = models.BooleanField(default=True)

    branding_primary = models.CharField(max_length=20, default="#2F855A")
    branding_secondary = models.CharField(max_length=20, default="#EDF2F7")
    header_text = models.CharField(max_length=120, default="How can we help?")
    welcome_message = models.TextField(default="Hi! Ask me about tours, bookings, and more.")
    floating_button_text = models.CharField(max_length=60, default="Chat with us")

    # Woo coupon defaults
    coupon_enabled = models.BooleanField(default=True)
    coupon_type = models.CharField(max_length=20, default="percent")  # percent|fixed
    coupon_value = models.DecimalField(max_digits=8, decimal_places=2, default=15)
    coupon_expiry_days = models.IntegerField(default=30)
    coupon_one_time_use = models.BooleanField(default=True)

    # Feature toggles
    enable_refunds = models.BooleanField(default=False)
    enable_rebooking = models.BooleanField(default=True)
    enable_order_cancellation = models.BooleanField(default=False)

    # Standard texts
    no_bookings_text = models.CharField(max_length=200, default="No bookings found. Would you like to book one?")
    cancellation_policy_text = models.TextField(default="Cancellations allowed up to 24 hours before start time.")

    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self) -> str:
        return f"ChatbotSettings({self.site_name})"


class FAQ(models.Model):
    question = models.CharField(max_length=255)
    answer = models.TextField()
    source_url = models.URLField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self) -> str:
        return self.question


class Document(models.Model):
    title = models.CharField(max_length=255)
    url = models.URLField()
    content = models.TextField()
    chunk_id = models.CharField(max_length=100, blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self) -> str:
        return self.title

# Create your models here.
