/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class ApiEcrServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "api.ecr";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-east-2"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-northeast-3"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("ap-southeast-5"), Region.of("ap-southeast-6"), Region.of("ap-southeast-7"), Region.of("ca-central-1"), Region.of("ca-west-1"), Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"), Region.of("il-central-1"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("mx-central-1"), Region.of("sa-east-1"), Region.of("us-catalyst-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-northeast-1"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("fips-us-gov-east-1"), Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("us-iso-east-1"), Region.of("us-iso-west-1"), Region.of("us-isob-east-1"), Region.of("us-isob-west-1"), Region.of("eu-isoe-west-1"), Region.of("us-isof-east-1"), Region.of("us-isof-south-1"), Region.of("eusc-de-east-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-iso-e", null), new DefaultServicePartitionMetadata("aws-iso-f", null), new DefaultServicePartitionMetadata("aws-eusc", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), (Object)"af-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), (Object)"ap-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-2")).build(), (Object)"ap-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"ap-northeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"ap-northeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), (Object)"ap-northeast-3").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), (Object)"ap-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), (Object)"ap-south-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"ap-southeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"ap-southeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(), (Object)"ap-southeast-3").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), (Object)"ap-southeast-4").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), (Object)"ap-southeast-5").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"ap-southeast-6").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).build(), (Object)"ap-southeast-7").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"ca-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"eu-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), (Object)"eu-central-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), (Object)"eu-north-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-1")).build(), (Object)"eu-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), (Object)"eu-south-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"eu-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"eu-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), (Object)"eu-west-3").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), (Object)"us-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("il-central-1")).build(), (Object)"il-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), (Object)"me-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), (Object)"me-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), (Object)"mx-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), (Object)"sa-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-catalyst-1")).build(), (Object)"us-catalyst-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-northeast-1")).build(), (Object)"us-northeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), (Object)"us-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"us-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), (Object)"cn-north-1").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), (Object)"cn-northwest-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).build(), (Object)"eusc-de-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), (Object)"us-iso-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).build(), (Object)"us-iso-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).build(), (Object)"us-isob-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).build(), (Object)"us-isob-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).build(), (Object)"eu-isoe-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).build(), (Object)"us-isof-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), (Object)"us-isof-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), (Object)"us-gov-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), (Object)"us-gov-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), (Object)"api.ecr.af-south-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), (Object)"api.ecr.ap-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-2")).build(), (Object)"api.ecr.ap-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"api.ecr.ap-northeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"api.ecr.ap-northeast-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(), (Object)"api.ecr.ap-northeast-3.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), (Object)"api.ecr.ap-south-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), (Object)"api.ecr.ap-south-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"api.ecr.ap-southeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"api.ecr.ap-southeast-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(), (Object)"api.ecr.ap-southeast-3.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), (Object)"api.ecr.ap-southeast-4.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), (Object)"api.ecr.ap-southeast-5.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"api.ecr.ap-southeast-6.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).build(), (Object)"api.ecr.ap-southeast-7.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), (Object)"api.ecr.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"api.ecr.ca-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"api.ecr.eu-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), (Object)"api.ecr.eu-central-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), (Object)"api.ecr.eu-north-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-1")).build(), (Object)"api.ecr.eu-south-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), (Object)"api.ecr.eu-south-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"api.ecr.eu-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"api.ecr.eu-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), (Object)"api.ecr.eu-west-3.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"ecr-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"ecr-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-1")).build(), (Object)"ecr-fips.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"ecr-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("il-central-1")).build(), (Object)"api.ecr.il-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), (Object)"api.ecr.me-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), (Object)"api.ecr.me-south-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), (Object)"api.ecr.mx-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), (Object)"api.ecr.sa-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-catalyst-1")).build(), (Object)"api.ecr.us-catalyst-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"api.ecr.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"ecr-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"api.ecr.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), (Object)"ecr-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-northeast-1")).build(), (Object)"api.ecr.us-northeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), (Object)"api.ecr.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"ecr-fips.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"api.ecr.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), (Object)"ecr-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), (Object)"api.ecr.cn-north-1.amazonaws.com.cn").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), (Object)"api.ecr.cn-northwest-1.amazonaws.com.cn").put((Object)ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).build(), (Object)"api.ecr.eusc-de-east-1.amazonaws.eu").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), (Object)"api.ecr.us-iso-east-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-west-1")).build(), (Object)"api.ecr.us-iso-west-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-east-1")).build(), (Object)"api.ecr.us-isob-east-1.sc2s.sgov.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).build(), (Object)"api.ecr.us-isob-west-1.sc2s.sgov.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-isoe-west-1")).build(), (Object)"api.ecr.eu-isoe-west-1.cloud.adc-e.uk").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).build(), (Object)"api.ecr.us-isof-east-1.csp.hci.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), (Object)"api.ecr.us-isof-south-1.csp.hci.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-east-1")).build(), (Object)"ecr-fips.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-gov-west-1")).build(), (Object)"ecr-fips.us-gov-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), (Object)"api.ecr.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"ecr-fips.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), (Object)"api.ecr.us-gov-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"ecr-fips.us-gov-west-1.amazonaws.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().put((Object)Pair.of((Object)"aws", (Object)PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()), (Object)"ecr-fips.{region}.{dnsSuffix}").put((Object)Pair.of((Object)"aws-us-gov", (Object)PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()), (Object)"ecr-fips.{region}.{dnsSuffix}").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

