/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class GrafanaServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "grafana";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-east-2"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-5"), Region.of("ap-southeast-6"), Region.of("ap-southeast-7"), Region.of("ca-west-1"), Region.of("eu-central-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("mx-central-1"), Region.of("us-catalyst-2"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-northeast-1"), Region.of("us-west-2"), Region.of("us-isob-west-1"), Region.of("eusc-de-east-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-eusc", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-2")).build(), (Object)"ap-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"ap-northeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"ap-northeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"ap-southeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"ap-southeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), (Object)"ap-southeast-5").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"ap-southeast-6").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).build(), (Object)"ap-southeast-7").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"ca-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"eu-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"eu-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"eu-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), (Object)"mx-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-catalyst-2")).build(), (Object)"us-catalyst-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-northeast-1")).build(), (Object)"us-northeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).build(), (Object)"eusc-de-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).build(), (Object)"us-isob-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-2")).build(), (Object)"grafana.ap-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"grafana.ap-northeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"grafana.ap-northeast-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"grafana.ap-southeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"grafana.ap-southeast-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), (Object)"grafana.ap-southeast-5.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"grafana.ap-southeast-6.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-7")).build(), (Object)"grafana.ap-southeast-7.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"grafana.ca-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"grafana.eu-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"grafana.eu-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"grafana.eu-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), (Object)"grafana.mx-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-catalyst-2")).build(), (Object)"grafana.us-catalyst-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"grafana.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"grafana.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-northeast-1")).build(), (Object)"grafana.us-northeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"grafana.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).build(), (Object)"grafana.eusc-de-east-1.amazonaws.eu").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isob-west-1")).build(), (Object)"grafana.us-isob-west-1.sc2s.sgov.gov").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

