/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import java.io.IOException;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.internal_do_not_import_933867.com.fasterxml.jackson.core.JsonParser;
import org.apache.logging.log4j.internal_do_not_import_933867.com.fasterxml.jackson.core.JsonToken;
import org.apache.logging.log4j.internal_do_not_import_933867.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.logging.log4j.internal_do_not_import_933867.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.logging.log4j.internal_do_not_import_933867.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.apache.logging.log4j.internal_do_not_import_933867.com.fasterxml.jackson.databind.util.ClassUtil;

public final class Log4jStackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;

    public Log4jStackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            String className = null;
            String methodName = null;
            String fileName = null;
            int lineNumber = -1;
            while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                String propName = jp.getCurrentName();
                if ("class".equals(propName)) {
                    className = jp.getText();
                    continue;
                }
                if ("file".equals(propName)) {
                    fileName = jp.getText();
                    continue;
                }
                if ("line".equals(propName)) {
                    if (t.isNumeric()) {
                        lineNumber = jp.getIntValue();
                        continue;
                    }
                    try {
                        lineNumber = Integers.parseInt(jp.getText());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw JsonMappingException.from(jp, "Non-numeric token (" + (Object)((Object)t) + ") for property 'line'", (Throwable)e);
                    }
                }
                if ("method".equals(propName)) {
                    methodName = jp.getText();
                    continue;
                }
                if ("nativeMethod".equals(propName)) continue;
                this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
            }
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        throw JsonMappingException.from(jp, String.format("Cannot deserialize instance of %s out of %s token", new Object[]{ClassUtil.nameOf(this._valueClass), t}));
    }
}

