/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.async;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.FileTransformerConfiguration;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.SplittingTransformerConfiguration;
import software.amazon.awssdk.core.async.ResponsePublisher;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.ByteArrayAsyncResponseTransformer;
import software.amazon.awssdk.core.internal.async.DefaultAsyncResponseTransformerSplitResult;
import software.amazon.awssdk.core.internal.async.FileAsyncResponseTransformer;
import software.amazon.awssdk.core.internal.async.InputStreamResponseTransformer;
import software.amazon.awssdk.core.internal.async.PublisherAsyncResponseTransformer;
import software.amazon.awssdk.core.internal.async.SplittingTransformer;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public interface AsyncResponseTransformer<ResponseT, ResultT> {
    public CompletableFuture<ResultT> prepare();

    public void onResponse(ResponseT var1);

    public void onStream(SdkPublisher<ByteBuffer> var1);

    public void exceptionOccurred(Throwable var1);

    default public SplitResult<ResponseT, ResultT> split(SplittingTransformerConfiguration splitConfig) {
        Validate.notNull((Object)splitConfig, (String)"splitConfig must not be null", (Object[])new Object[0]);
        CompletableFuture future = new CompletableFuture();
        SplittingTransformer transformer = SplittingTransformer.builder().upstreamResponseTransformer(this).maximumBufferSizeInBytes(splitConfig.bufferSizeInBytes()).resultFuture(future).build();
        return (SplitResult)SplitResult.builder().publisher(transformer).resultFuture(future).build();
    }

    default public SplitResult<ResponseT, ResultT> split(Consumer<SplittingTransformerConfiguration.Builder> splitConfig) {
        SplittingTransformerConfiguration conf = (SplittingTransformerConfiguration)((SplittingTransformerConfiguration.Builder)SplittingTransformerConfiguration.builder().applyMutation(splitConfig)).build();
        return this.split(conf);
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(Path path) {
        return new FileAsyncResponseTransformer(path);
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(Path path, FileTransformerConfiguration config) {
        return new FileAsyncResponseTransformer(path, config);
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(Path path, Consumer<FileTransformerConfiguration.Builder> config) {
        Validate.paramNotNull(config, (String)"config");
        return new FileAsyncResponseTransformer(path, (FileTransformerConfiguration)((FileTransformerConfiguration.Builder)FileTransformerConfiguration.builder().applyMutation(config)).build());
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(File file) {
        return AsyncResponseTransformer.toFile(file.toPath());
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(File file, FileTransformerConfiguration config) {
        return new FileAsyncResponseTransformer(file.toPath(), config);
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseT> toFile(File file, Consumer<FileTransformerConfiguration.Builder> config) {
        Validate.paramNotNull(config, (String)"config");
        return new FileAsyncResponseTransformer(file.toPath(), (FileTransformerConfiguration)((FileTransformerConfiguration.Builder)FileTransformerConfiguration.builder().applyMutation(config)).build());
    }

    public static <ResponseT> AsyncResponseTransformer<ResponseT, ResponseBytes<ResponseT>> toBytes() {
        return new ByteArrayAsyncResponseTransformer();
    }

    public static <ResponseT extends SdkResponse> AsyncResponseTransformer<ResponseT, ResponsePublisher<ResponseT>> toPublisher() {
        return new PublisherAsyncResponseTransformer();
    }

    public static <ResponseT extends SdkResponse> AsyncResponseTransformer<ResponseT, ResponseInputStream<ResponseT>> toBlockingInputStream() {
        return new InputStreamResponseTransformer();
    }

    public static interface SplitResult<ResponseT, ResultT>
    extends ToCopyableBuilder<Builder<ResponseT, ResultT>, SplitResult<ResponseT, ResultT>> {
        public SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> publisher();

        public CompletableFuture<ResultT> resultFuture();

        public static <ResponseT, ResultT> Builder<ResponseT, ResultT> builder() {
            return DefaultAsyncResponseTransformerSplitResult.builder();
        }

        public static interface Builder<ResponseT, ResultT>
        extends CopyableBuilder<Builder<ResponseT, ResultT>, SplitResult<ResponseT, ResultT>> {
            public SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> publisher();

            public Builder<ResponseT, ResultT> publisher(SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> var1);

            public CompletableFuture<ResultT> resultFuture();

            public Builder<ResponseT, ResultT> resultFuture(CompletableFuture<ResultT> var1);
        }
    }
}

